/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.oauth2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.security.JWTParser;
import org.slf4j.Logger;

public class Oauth2ClaimValidator {
    private static final String MATCH_MODE_PREFIX_OR_SHORT = "[]";
    private static final String MATCH_MODE_PREFIX_OR = "[or]";
    private static final String MATCH_MODE_PREFIX_AND = "[and]";
    private Logger log;
    private Map<String, List<String>> claimsToValidate;
    private Map<String, ClaimMatchMode> claimsMatchMode;

    public Oauth2ClaimValidator(Logger log, Properties loginProperties) {
        this.log = log;
        this.claimsMatchMode = new HashMap<String, ClaimMatchMode>();
        this.claimsToValidate = this.parseClaimsFromProperties(loginProperties);
    }

    private Map<String, List<String>> parseClaimsFromProperties(Properties properties) {
        HashMap<String, List<String>> claims = new HashMap<String, List<String>>();
        if (properties == null || properties.isEmpty()) {
            this.logDebug("Properties vuote, nessun claim da validare configurato", new Object[0]);
            return claims;
        }
        for (String key : properties.stringPropertyNames()) {
            if (!this.isClaimValidationProperty(key)) continue;
            this.processClaimProperty(key, properties, claims);
        }
        this.logClaimsSummary(claims);
        return claims;
    }

    private boolean isClaimValidationProperty(String key) {
        return key != null && key.startsWith("oauth2.claims.validation.");
    }

    private void processClaimProperty(String key, Properties properties, Map<String, List<String>> claims) {
        String claimName = this.extractClaimName(key);
        if (claimName.isEmpty()) {
            this.logWarn("Property '{}' non valida: nome claim vuoto", key);
            return;
        }
        String valuesStr = properties.getProperty(key);
        if (StringUtils.isNotEmpty((CharSequence)valuesStr)) {
            ClaimMatchMode matchMode = ClaimMatchMode.EXACT;
            String valuesStrWithoutPrefix = valuesStr;
            if (valuesStr.startsWith(MATCH_MODE_PREFIX_OR)) {
                matchMode = ClaimMatchMode.OR;
                valuesStrWithoutPrefix = valuesStr.substring(MATCH_MODE_PREFIX_OR.length());
            } else if (valuesStr.startsWith(MATCH_MODE_PREFIX_AND)) {
                matchMode = ClaimMatchMode.AND;
                valuesStrWithoutPrefix = valuesStr.substring(MATCH_MODE_PREFIX_AND.length());
            } else if (valuesStr.startsWith(MATCH_MODE_PREFIX_OR_SHORT)) {
                matchMode = ClaimMatchMode.OR;
                valuesStrWithoutPrefix = valuesStr.substring(MATCH_MODE_PREFIX_OR_SHORT.length());
            }
            List<String> allowedValues = this.parseAllowedValues(valuesStrWithoutPrefix);
            if (matchMode != ClaimMatchMode.EXACT) {
                this.claimsMatchMode.put(claimName, matchMode);
            }
            claims.put(claimName, allowedValues);
            this.logClaimConfiguration(claimName, allowedValues);
        }
    }

    private String extractClaimName(String key) {
        return key.substring("oauth2.claims.validation.".length());
    }

    private List<String> parseAllowedValues(String valuesStr) {
        String[] values;
        ArrayList<String> allowedValues = new ArrayList<String>();
        for (String value : values = valuesStr.split(",")) {
            String trimmedValue = value.trim();
            if (trimmedValue.isEmpty()) continue;
            allowedValues.add(trimmedValue);
        }
        return allowedValues.isEmpty() ? null : allowedValues;
    }

    private void logClaimConfiguration(String claimName, List<String> allowedValues) {
        if (allowedValues == null) {
            this.logDebug("Claim '{}' configurato per verifica solo presenza", claimName);
        } else {
            this.logDebug("Claim '{}' configurato con valori ammessi: {}", claimName, allowedValues);
        }
    }

    private void logClaimsSummary(Map<String, List<String>> claims) {
        if (this.log == null) {
            return;
        }
        if (claims.isEmpty()) {
            this.log.info("Nessun claim da validare configurato nelle properties");
        } else {
            this.log.info("Configurati {} claim da validare", (Object)claims.size());
        }
    }

    private void logDebug(String message, Object ... args) {
        if (this.log != null) {
            this.log.debug(message, args);
        }
    }

    private void logWarn(String message, Object ... args) {
        if (this.log != null) {
            this.log.warn(message, args);
        }
    }

    public ValidationResult validate(String token) {
        ValidationResult result;
        block7: {
            result = new ValidationResult();
            result.setValid(true);
            if (this.claimsToValidate == null || this.claimsToValidate.isEmpty()) {
                if (this.log != null) {
                    this.log.debug("Nessun claim da validare");
                }
                return result;
            }
            if (token == null || token.isEmpty()) {
                result.setValid(false);
                result.addError("Token JWT non fornito");
                return result;
            }
            try {
                JWTParser jwtParser = new JWTParser(token);
                Map<String, String> tokenClaims = jwtParser.getPayloadClaims();
                if (tokenClaims == null || tokenClaims.isEmpty()) {
                    result.setValid(false);
                    result.addError("Token JWT non contiene claim nel payload");
                    return result;
                }
                for (Map.Entry<String, List<String>> entry : this.claimsToValidate.entrySet()) {
                    String claimName = entry.getKey();
                    List<String> allowedValues = entry.getValue();
                    this.validateSingleClaim(claimName, allowedValues, tokenClaims, result);
                }
            }
            catch (UtilsException e) {
                result.setValid(false);
                result.addError("Errore durante la lettura dei claim dal token: " + e.getMessage());
                if (this.log == null) break block7;
                this.log.error("Errore lettura claim dal token", (Throwable)e);
            }
        }
        return result;
    }

    private void validateSingleClaim(String claimName, List<String> allowedValues, Map<String, String> tokenClaims, ValidationResult result) {
        boolean valid;
        String claimValue = tokenClaims.get(claimName);
        if (claimValue == null) {
            result.setValid(false);
            result.addError("Claim '" + claimName + "' non presente nel token");
            return;
        }
        if (allowedValues == null || allowedValues.isEmpty()) {
            if (this.log != null) {
                this.log.debug("Claim '{}' presente con valore: {}", (Object)claimName, (Object)claimValue);
            }
            return;
        }
        ClaimMatchMode matchMode = this.claimsMatchMode.get(claimName);
        if (matchMode == null) {
            matchMode = ClaimMatchMode.EXACT;
        }
        if (matchMode == ClaimMatchMode.EXACT) {
            valid = false;
            for (String allowedValue : allowedValues) {
                if (!claimValue.equals(allowedValue)) continue;
                valid = true;
                break;
            }
        } else {
            ArrayList<String> claimTokens = new ArrayList<String>();
            for (String t : claimValue.split(",")) {
                String trimmed = t.trim();
                if (trimmed.isEmpty()) continue;
                claimTokens.add(trimmed);
            }
            if (matchMode == ClaimMatchMode.OR) {
                valid = false;
                for (String allowedValue : allowedValues) {
                    if (!claimTokens.contains(allowedValue)) continue;
                    valid = true;
                    break;
                }
            } else {
                valid = true;
                for (String allowedValue : allowedValues) {
                    if (claimTokens.contains(allowedValue)) continue;
                    valid = false;
                    break;
                }
            }
        }
        if (!valid) {
            result.setValid(false);
            String modeLabel = matchMode == ClaimMatchMode.EXACT ? "" : " (mode: " + matchMode.name().toLowerCase() + ")";
            result.addError("Claim '" + claimName + "' ha valore '" + claimValue + "' che non \u00e8 tra i valori ammessi: " + allowedValues + modeLabel);
            if (this.log != null) {
                this.log.warn("Claim '{}' ha valore '{}' non ammesso. Valori ammessi: {} (mode: {})", new Object[]{claimName, claimValue, allowedValues, matchMode});
            }
        } else if (this.log != null) {
            this.log.debug("Claim '{}' validato con successo. Valore: {} (mode: {})", new Object[]{claimName, claimValue, matchMode});
        }
    }

    public static enum ClaimMatchMode {
        EXACT,
        OR,
        AND;

    }

    public static class ValidationResult {
        private boolean valid = true;
        private List<String> errors = new ArrayList<String>();

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public List<String> getErrors() {
            return this.errors;
        }

        public void addError(String error) {
            this.errors.add(error);
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public String getErrorsAsString() {
            if (this.errors.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.errors.size(); ++i) {
                if (i > 0) {
                    sb.append("; ");
                }
                sb.append(this.errors.get(i));
            }
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ValidationResult [valid=").append(this.valid);
            if (!this.valid && !this.errors.isEmpty()) {
                sb.append(", errors=").append(this.getErrorsAsString());
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

