/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.openapi.validator;

import com.atlassian.oai.validator.model.ApiPath;
import com.atlassian.oai.validator.model.ApiPathImpl;
import com.atlassian.oai.validator.model.NormalisedPath;
import com.atlassian.oai.validator.model.NormalisedPathImpl;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.model.SimpleRequest;
import com.atlassian.oai.validator.model.SimpleResponse;
import com.atlassian.oai.validator.report.SimpleValidationReportFormat;
import com.atlassian.oai.validator.report.ValidationReport;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.networknt.schema.SpecVersion;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.model.v3.OAI3Context;
import org.openapi4j.core.util.StringUtil;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.operation.validator.model.Request;
import org.openapi4j.operation.validator.model.impl.Body;
import org.openapi4j.operation.validator.model.impl.DefaultRequest;
import org.openapi4j.operation.validator.model.impl.DefaultResponse;
import org.openapi4j.operation.validator.validation.OperationValidator;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Path;
import org.openapi4j.parser.validation.v3.OpenApi3Validator;
import org.openapi4j.schema.validator.ValidationData;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.json.AbstractUtils;
import org.openspcoop2.utils.json.IJsonSchemaValidator;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.json.JsonPathException;
import org.openspcoop2.utils.json.JsonPathExpressionEngine;
import org.openspcoop2.utils.json.JsonPathNotFoundException;
import org.openspcoop2.utils.json.JsonPathNotValidException;
import org.openspcoop2.utils.json.JsonSchemaValidatorConfig;
import org.openspcoop2.utils.json.JsonValidatorAPI;
import org.openspcoop2.utils.json.ValidationException;
import org.openspcoop2.utils.json.ValidationResponse;
import org.openspcoop2.utils.json.ValidatorFactory;
import org.openspcoop2.utils.json.YAMLUtils;
import org.openspcoop2.utils.openapi.OpenapiApi;
import org.openspcoop2.utils.openapi.OpenapiApiValidatorStructure;
import org.openspcoop2.utils.openapi.UniqueInterfaceGenerator;
import org.openspcoop2.utils.openapi.UniqueInterfaceGeneratorConfig;
import org.openspcoop2.utils.openapi.validator.OpenAPILibrary;
import org.openspcoop2.utils.openapi.validator.OpenapiApiValidatorConfig;
import org.openspcoop2.utils.openapi.validator.OpenapiLibraryValidatorConfig;
import org.openspcoop2.utils.openapi.validator.SwaggerRequestValidatorOpenAPI;
import org.openspcoop2.utils.openapi.validator.swagger.SwaggerOpenApiValidator;
import org.openspcoop2.utils.openapi.validator.swagger.SwaggerRequestValidator;
import org.openspcoop2.utils.openapi.validator.swagger.SwaggerResponseValidator;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.rest.AbstractApiValidator;
import org.openspcoop2.utils.rest.ApiFormats;
import org.openspcoop2.utils.rest.ApiParameterType;
import org.openspcoop2.utils.rest.ApiValidatorConfig;
import org.openspcoop2.utils.rest.IApiValidator;
import org.openspcoop2.utils.rest.ProcessingException;
import org.openspcoop2.utils.rest.ValidatorException;
import org.openspcoop2.utils.rest.api.Api;
import org.openspcoop2.utils.rest.api.ApiBodyParameter;
import org.openspcoop2.utils.rest.api.ApiOperation;
import org.openspcoop2.utils.rest.api.ApiReference;
import org.openspcoop2.utils.rest.api.ApiResponse;
import org.openspcoop2.utils.rest.api.ApiSchema;
import org.openspcoop2.utils.rest.api.ApiSchemaType;
import org.openspcoop2.utils.rest.api.ApiSchemaTypeRestriction;
import org.openspcoop2.utils.rest.entity.Cookie;
import org.openspcoop2.utils.rest.entity.HttpBaseEntity;
import org.openspcoop2.utils.rest.entity.HttpBaseRequestEntity;
import org.openspcoop2.utils.rest.entity.HttpBaseResponseEntity;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.xml.XMLUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Validator
extends AbstractApiValidator
implements IApiValidator {
    private Api api;
    private Map<String, IJsonSchemaValidator> validatorMap;
    private Map<String, File> fileSchema;
    private OpenApi3 openApi4j;
    private SwaggerRequestValidator swaggerRequestValidator;
    private SwaggerResponseValidator swaggerResponseValidator;
    private OpenAPI openApiSwagger;
    private OpenapiLibraryValidatorConfig openApi4jConfig;
    boolean onlySchemas = false;
    private Logger log;
    private static final String VALIDATION_STRUCTURE = "VALIDATION_STRUCTURE";
    private static final String VALIDATION_SWAGGER_REQUEST_VALIDATOR_OPENAPI = "VALIDATION_SWAGGER_REQUEST_VALIDATOR_OPENAPI";
    private Semaphore semaphore = new Semaphore("OpenAPIValidator");
    private static final Pattern PREFIXED_SEMICOLON_NAME_REGEX = Pattern.compile("(?:;)([^;]+)(?:=)([^;]*)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Logger log, Api api, ApiValidatorConfig config) throws ProcessingException {
        this.log = log;
        if (api == null) {
            throw new ProcessingException("Api cannot be null");
        }
        SemaphoreLock lock = this.semaphore.acquireThrowRuntime("init");
        try {
            JsonSchemaValidatorConfig.ADDITIONAL policyAdditionalProperties;
            JsonValidatorAPI.ApiName jsonValidatorAPI;
            OpenapiApiValidatorStructure apiValidatorStructure;
            OpenapiApi openapiApi;
            Api apiRest;
            block113: {
                boolean bl;
                this.api = api;
                apiRest = null;
                openapiApi = null;
                apiValidatorStructure = null;
                SwaggerRequestValidatorOpenAPI swaggerRequestValidatorOpenAPI = null;
                if (api instanceof OpenapiApi) {
                    openapiApi = (OpenapiApi)this.api;
                    apiRest = this.api;
                    apiValidatorStructure = openapiApi.getValidationStructure();
                    if (apiRest.containsKey(VALIDATION_SWAGGER_REQUEST_VALIDATOR_OPENAPI)) {
                        swaggerRequestValidatorOpenAPI = (SwaggerRequestValidatorOpenAPI)apiRest.getVendorImpl(VALIDATION_SWAGGER_REQUEST_VALIDATOR_OPENAPI);
                    }
                } else {
                    apiRest = this.api;
                    if (apiRest.containsKey(VALIDATION_STRUCTURE)) {
                        apiValidatorStructure = (OpenapiApiValidatorStructure)apiRest.getVendorImpl(VALIDATION_STRUCTURE);
                    }
                    this.onlySchemas = true;
                }
                jsonValidatorAPI = null;
                OpenAPILibrary openApiLibrary = null;
                policyAdditionalProperties = config.getPolicyAdditionalProperties();
                if (config instanceof OpenapiApiValidatorConfig) {
                    OpenapiApiValidatorConfig c;
                    jsonValidatorAPI = ((OpenapiApiValidatorConfig)config).getJsonValidatorAPI();
                    if (openapiApi != null && (c = (OpenapiApiValidatorConfig)config).getOpenApiValidatorConfig() != null && (OpenAPILibrary.openapi4j.equals(openApiLibrary = c.getOpenApiValidatorConfig().getOpenApiLibrary()) || OpenAPILibrary.swagger_request_validator.equals(openApiLibrary))) {
                        this.openApi4jConfig = c.getOpenApiValidatorConfig();
                    }
                }
                if (jsonValidatorAPI == null) {
                    jsonValidatorAPI = JsonValidatorAPI.ApiName.NETWORK_NT;
                }
                if (!OpenAPILibrary.openapi4j.equals(openApiLibrary) && !OpenAPILibrary.swagger_request_validator.equals(openApiLibrary)) break block113;
                JsonNode schemaNodeRoot = null;
                URL uriSchemaNodeRoot = null;
                HashMap<URL, JsonNode> schemaMap = null;
                String root = "file:/";
                boolean bl2 = true;
                if (apiValidatorStructure != null && apiValidatorStructure.getNodeValidatorePrincipale() != null && !apiValidatorStructure.getNodeValidatorePrincipale().isEmpty()) {
                    bl = false;
                    for (String string : apiValidatorStructure.getNodeValidatorePrincipale().keySet()) {
                        if (root.equals(string)) {
                            schemaNodeRoot = apiValidatorStructure.getNodeValidatorePrincipale().get(string);
                            uriSchemaNodeRoot = new URL(root);
                            continue;
                        }
                        if (schemaMap == null) {
                            schemaMap = new HashMap<URL, JsonNode>();
                        }
                        schemaMap.put(new URL(string), apiValidatorStructure.getNodeValidatorePrincipale().get(string));
                    }
                } else {
                    YAMLUtils yamlUtils = YAMLUtils.getInstance();
                    JSONUtils jSONUtils = JSONUtils.getInstance();
                    Object apiRaw = openapiApi.getApiRaw();
                    boolean apiRawIsYaml = yamlUtils.isYaml((String)apiRaw);
                    boolean readApiSchemas = true;
                    if (this.openApi4jConfig.isMergeAPISpec()) {
                        readApiSchemas = false;
                        HashMap<String, String> attachments = new HashMap<String, String>();
                        if (api.getSchemas() != null && api.getSchemas().size() > 0) {
                            for (ApiSchema apiSchema : api.getSchemas()) {
                                if (!ApiSchemaType.JSON.equals(apiSchema.getType()) && !ApiSchemaType.YAML.equals(apiSchema.getType())) continue;
                                byte[] schema = apiSchema.getContent();
                                if (ApiSchemaType.JSON.equals(apiSchema.getType())) {
                                    if (!jSONUtils.isJson(schema)) continue;
                                    attachments.put(apiSchema.getName(), new String(apiSchema.getContent()));
                                    continue;
                                }
                                if (!yamlUtils.isYaml(schema)) continue;
                                attachments.put(apiSchema.getName(), new String(apiSchema.getContent()));
                            }
                        }
                        if (!attachments.isEmpty()) {
                            UniqueInterfaceGeneratorConfig configUniqueInterfaceGeneratorConfig = new UniqueInterfaceGeneratorConfig();
                            configUniqueInterfaceGeneratorConfig.setFormat(ApiFormats.OPEN_API_3);
                            configUniqueInterfaceGeneratorConfig.setYaml(apiRawIsYaml);
                            configUniqueInterfaceGeneratorConfig.setMaster((String)apiRaw);
                            configUniqueInterfaceGeneratorConfig.setAttachments(attachments);
                            try {
                                String apiMerged = UniqueInterfaceGenerator.generate(configUniqueInterfaceGeneratorConfig, null, null, true, log);
                                if (apiMerged == null) {
                                    throw new Exception("empty ApiSpec");
                                }
                                apiRaw = apiMerged;
                            }
                            catch (Throwable t) {
                                log.error("Merge API Spec failed: " + t.getMessage(), t);
                                readApiSchemas = true;
                            }
                        }
                    }
                    if (apiRawIsYaml) {
                        if (YAMLUtils.containsKeyAnchor((String)apiRaw)) {
                            String jsonRepresentation = YAMLUtils.resolveKeyAnchorAndConvertToJson((String)apiRaw);
                            schemaNodeRoot = jSONUtils.getAsNode(jsonRepresentation);
                        } else {
                            schemaNodeRoot = yamlUtils.getAsNode((String)apiRaw);
                        }
                    } else {
                        schemaNodeRoot = jSONUtils.getAsNode((String)apiRaw);
                    }
                    this.normalizeRefs(schemaNodeRoot);
                    uriSchemaNodeRoot = new URL(root);
                    if (readApiSchemas && api.getSchemas() != null && api.getSchemas().size() > 0) {
                        for (ApiSchema apiSchema : api.getSchemas()) {
                            if (!ApiSchemaType.JSON.equals(apiSchema.getType()) && !ApiSchemaType.YAML.equals(apiSchema.getType())) continue;
                            byte[] schema = apiSchema.getContent();
                            JsonNode schemaNodeInternal = null;
                            if (ApiSchemaType.JSON.equals(apiSchema.getType())) {
                                if (jSONUtils.isJson(schema)) {
                                    schemaNodeInternal = jSONUtils.getAsNode(schema);
                                }
                            } else if (yamlUtils.isYaml(schema)) {
                                String sSchema = new String(schema);
                                if (YAMLUtils.containsKeyAnchor(sSchema)) {
                                    String jsonRepresentation = YAMLUtils.resolveKeyAnchorAndConvertToJson(sSchema);
                                    schemaNodeInternal = jSONUtils.getAsNode(jsonRepresentation);
                                } else {
                                    schemaNodeInternal = yamlUtils.getAsNode(schema);
                                }
                            }
                            if (schemaNodeInternal == null) continue;
                            this.normalizeRefs(schemaNodeInternal);
                            if (schemaMap == null) {
                                schemaMap = new HashMap();
                            }
                            schemaMap.put(new URL(root + apiSchema.getName()), schemaNodeInternal);
                        }
                    }
                }
                if (OpenAPILibrary.openapi4j.equals(openApiLibrary)) {
                    OAI3Context context = new OAI3Context(uriSchemaNodeRoot, schemaNodeRoot, schemaMap);
                    if (this.openApi4jConfig != null) {
                        context.setMultipartOptimization(this.openApi4jConfig.isValidateMultipartOptimization());
                    }
                    this.openApi4j = (OpenApi3)TreeUtil.json.convertValue((Object)context.getBaseDocument(), OpenApi3.class);
                    this.openApi4j.setContext((OAIContext)context);
                    if (bl && this.openApi4jConfig != null && this.openApi4jConfig.isValidateAPISpec()) {
                        try {
                            ValidationResults validationResults = OpenApi3Validator.instance().validate(this.openApi4j);
                            if (!validationResults.isValid()) {
                                throw new ProcessingException("OpenAPI3 not valid: " + validationResults.toString());
                            }
                        }
                        catch (org.openapi4j.core.validation.ValidationException validationException) {
                            if (validationException.results() != null) {
                                throw new ProcessingException("OpenAPI3 not valid: " + validationException.results().toString());
                            }
                            throw new ProcessingException("OpenAPI3 not valid: " + validationException.getMessage());
                        }
                    }
                } else if (OpenAPILibrary.swagger_request_validator.equals(openApiLibrary)) {
                    Optional<String> validationResult;
                    if (bl && this.openApi4jConfig.isValidateAPISpec() && (validationResult = new SwaggerOpenApiValidator().validate(schemaNodeRoot)).isPresent()) {
                        throw new ProcessingException("OpenAPI3 not valid: " + validationResult.get());
                    }
                    if (swaggerRequestValidatorOpenAPI != null) {
                        this.openApiSwagger = swaggerRequestValidatorOpenAPI.getOpenApiSwagger();
                    } else {
                        SwaggerRequestValidatorOpenAPI newInstanceSwaggerRequestValidatorOpenAPI = new SwaggerRequestValidatorOpenAPI(schemaNodeRoot, this.openApi4jConfig, api);
                        this.openApiSwagger = newInstanceSwaggerRequestValidatorOpenAPI.getOpenApiSwagger();
                        apiRest.addVendorImpl(VALIDATION_SWAGGER_REQUEST_VALIDATOR_OPENAPI, newInstanceSwaggerRequestValidatorOpenAPI);
                    }
                    this.swaggerRequestValidator = new SwaggerRequestValidator(this.openApiSwagger, this.openApi4jConfig);
                    this.swaggerResponseValidator = new SwaggerResponseValidator(this.openApiSwagger, this.openApi4jConfig);
                }
                if (apiValidatorStructure == null) {
                    OpenapiApiValidatorStructure validationStructure = new OpenapiApiValidatorStructure();
                    HashMap<String, JsonNode> hashMap = new HashMap<String, JsonNode>();
                    hashMap.put(root, schemaNodeRoot);
                    if (schemaMap != null && !schemaMap.isEmpty()) {
                        for (URL url : schemaMap.keySet()) {
                            hashMap.put(url.toString(), (JsonNode)schemaMap.get(url));
                        }
                    }
                    validationStructure.setNodeValidatorePrincipale(hashMap);
                    openapiApi.setValidationStructure(validationStructure);
                }
                return;
            }
            try {
                String path;
                this.validatorMap = new HashMap<String, IJsonSchemaValidator>();
                boolean existsRefInternal = false;
                Map<Object, Object> schemiValidatorePrincipale = new HashMap();
                HashMap<String, JsonNode> nodeValidatorePrincipale = new HashMap();
                if (apiValidatorStructure != null) {
                    schemiValidatorePrincipale = apiValidatorStructure.getSchemiValidatorePrincipale();
                    nodeValidatorePrincipale = apiValidatorStructure.getNodeValidatorePrincipale();
                } else if (openapiApi != null) {
                    Map<String, Schema<?>> definitions = openapiApi.getAllDefinitions();
                    String string2 = Json.mapper().writeValueAsString(definitions);
                    string2 = string2.replaceAll("#/components/schemas", "#/definitions");
                    block17: for (String string3 : definitions.keySet()) {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        bout.write("{".getBytes());
                        String defOggetto = Json.mapper().writeValueAsString(definitions.get(string3));
                        defOggetto = defOggetto.trim();
                        defOggetto = defOggetto.replaceAll("#/components/schemas", "#/definitions");
                        if (defOggetto.startsWith("{")) {
                            defOggetto = defOggetto.substring(1);
                        }
                        if (defOggetto.endsWith("}")) {
                            defOggetto = defOggetto.substring(0, defOggetto.length() - 1);
                        }
                        defOggetto = defOggetto.trim();
                        bout.write(defOggetto.getBytes());
                        bout.write(",".getBytes());
                        bout.write("\"definitions\" : ".getBytes());
                        bout.write(string2.getBytes());
                        bout.write("}".getBytes());
                        JSONUtils jsonUtils = JSONUtils.getInstance();
                        JsonNode schemaNode = jsonUtils.getAsNode(bout.toByteArray());
                        nodeValidatorePrincipale.put(string3, schemaNode);
                        schemiValidatorePrincipale.put(string3, bout.toByteArray());
                        JsonPathExpressionEngine engine = new JsonPathExpressionEngine();
                        List<String> refPath = this.getRefPath(engine, schemaNode);
                        if (refPath == null || refPath.isEmpty()) continue;
                        for (String ref : refPath) {
                            path = this.getRefPath(ref);
                            if (path == null) continue;
                            existsRefInternal = true;
                            continue block17;
                        }
                    }
                }
                this.fileSchema = new HashMap<String, File>();
                if (apiValidatorStructure != null) {
                    this.fileSchema = apiValidatorStructure.getFileSchema();
                } else if (api.getSchemas() != null && api.getSchemas().size() > 0) {
                    HashMap<String, JsonNode> tmpNode = new HashMap<String, JsonNode>();
                    HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
                    HashMap<String, ApiSchemaType> tmpSchemaType = new HashMap<String, ApiSchemaType>();
                    for (ApiSchema apiSchema : api.getSchemas()) {
                        if (!ApiSchemaType.JSON.equals(apiSchema.getType()) && !ApiSchemaType.YAML.equals(apiSchema.getType())) continue;
                        byte[] schema = apiSchema.getContent();
                        JsonNode schemaNode = null;
                        AbstractUtils utils = null;
                        JSONUtils jsonUtils = JSONUtils.getInstance();
                        if (ApiSchemaType.JSON.equals(apiSchema.getType())) {
                            utils = JSONUtils.getInstance();
                            if (((JSONUtils)utils).isJson(schema)) {
                                schemaNode = utils.getAsNode(schema);
                            }
                        } else {
                            utils = YAMLUtils.getInstance();
                            if (((YAMLUtils)utils).isYaml(schema)) {
                                schemaNode = utils.getAsNode(schema);
                            }
                        }
                        if (schemaNode == null) continue;
                        if (schemaNode instanceof TextNode) {
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            bout.write("{".getBytes());
                            bout.write(schema);
                            bout.write("}".getBytes());
                            bout.flush();
                            bout.close();
                            schemaNode = utils.getAsNode(bout.toByteArray());
                        }
                        if (schemaNode instanceof ObjectNode) {
                            JsonNode nodeComponents;
                            ObjectNode objectNode = (ObjectNode)schemaNode;
                            boolean foundDefinitions = false;
                            JsonNode nodeDefinitions = objectNode.get("definitions");
                            if (nodeDefinitions != null && nodeDefinitions instanceof ObjectNode) {
                                foundDefinitions = true;
                            }
                            if (!foundDefinitions && (nodeComponents = objectNode.get("components")) instanceof ObjectNode) {
                                ObjectNode objectNodeComponents = (ObjectNode)nodeComponents;
                                JsonNode nodeSchemas = objectNodeComponents.get("schemas");
                                if (nodeSchemas != null && nodeSchemas instanceof ObjectNode) {
                                    ObjectNode objectNodeDefinitions = utils.newObjectNode();
                                    objectNodeDefinitions.set("definitions", nodeSchemas);
                                    String schemaAsString = null;
                                    schemaAsString = ApiSchemaType.YAML.equals(apiSchema.getType()) ? jsonUtils.toString((JsonNode)objectNodeDefinitions) : utils.toString((JsonNode)objectNodeDefinitions);
                                    schemaAsString = schemaAsString.replaceAll("#/components/schemas", "#/definitions");
                                    schema = schemaAsString.getBytes();
                                    schemaNode = objectNodeDefinitions;
                                } else {
                                    schema = null;
                                    schemaNode = null;
                                }
                            }
                        }
                        if (schemaNode == null) continue;
                        if (this.onlySchemas) {
                            IJsonSchemaValidator validator = ValidatorFactory.newJsonSchemaValidator(jsonValidatorAPI);
                            JsonSchemaValidatorConfig schemaValidationConfig = new JsonSchemaValidatorConfig();
                            schemaValidationConfig.setVerbose(config.isVerbose());
                            schemaValidationConfig.setAdditionalProperties(policyAdditionalProperties);
                            schemaValidationConfig.setPoliticaInclusioneTipi(JsonSchemaValidatorConfig.POLITICA_INCLUSIONE_TIPI.DEFAULT);
                            schemaValidationConfig.setEmitLogError(config.isEmitLogError());
                            schemaValidationConfig.setJsonSchemaVersion(SpecVersion.VersionFlag.V4);
                            validator.setSchema(schema, schemaValidationConfig, log);
                            this.validatorMap.put(apiSchema.getName(), validator);
                            continue;
                        }
                        File tmp = FileSystemUtilities.createTempFile("validator", "." + apiSchema.getType().name().toLowerCase());
                        this.fileSchema.put(apiSchema.getName(), tmp);
                        tmpNode.put(apiSchema.getName(), schemaNode);
                        hashMap.put(apiSchema.getName(), schema);
                        tmpSchemaType.put(apiSchema.getName(), apiSchema.getType());
                    }
                    if (!this.onlySchemas) {
                        JsonNode schemaNode;
                        if (!existsRefInternal && !hashMap.isEmpty()) {
                            Iterator iterator = hashMap.keySet().iterator();
                            while (iterator.hasNext()) {
                                JsonPathExpressionEngine engine = new JsonPathExpressionEngine();
                                String apiSchemaName = (String)iterator.next();
                                schemaNode = (JsonNode)tmpNode.get(apiSchemaName);
                                List<String> refPath = this.getRefPath(engine, schemaNode);
                                if (refPath != null && !refPath.isEmpty()) {
                                    for (String ref : refPath) {
                                        String path2 = this.getRefPath(ref);
                                        if (path2 == null) continue;
                                        existsRefInternal = true;
                                        break;
                                    }
                                }
                                if (!existsRefInternal) continue;
                                break;
                            }
                        }
                        if (existsRefInternal && !hashMap.isEmpty()) {
                            for (String apiSchemaName : hashMap.keySet()) {
                                schemaNode = (JsonNode)tmpNode.get(apiSchemaName);
                                byte[] schemaContent = (byte[])hashMap.get(apiSchemaName);
                                JsonPathExpressionEngine engine = new JsonPathExpressionEngine();
                                List<String> refPath = this.getRefPath(engine, schemaNode);
                                String schemaRebuild = null;
                                if (refPath != null && !refPath.isEmpty()) {
                                    for (String ref : refPath) {
                                        String normalizePath;
                                        path = this.getRefPath(ref);
                                        if (path == null || (normalizePath = this.normalizePath(path)) == null || !this.fileSchema.containsKey(normalizePath)) continue;
                                        if (schemaRebuild == null) {
                                            schemaRebuild = new String(schemaContent);
                                        }
                                        if (!schemaRebuild.contains(path) && path.startsWith("./")) {
                                            path = path.substring(2);
                                        }
                                        File file = this.fileSchema.get(normalizePath);
                                        while (schemaRebuild.contains(path)) {
                                            schemaRebuild = schemaRebuild.replace(path, "file://" + file.getAbsolutePath());
                                        }
                                    }
                                }
                                File f = this.fileSchema.get(apiSchemaName);
                                if (schemaRebuild != null) {
                                    FileSystemUtilities.writeFile(f, schemaRebuild.getBytes());
                                    AbstractUtils utils = null;
                                    utils = ApiSchemaType.JSON.equals(tmpSchemaType.get(apiSchemaName)) ? JSONUtils.getInstance() : YAMLUtils.getInstance();
                                    schemaNode = utils.getAsNode(schemaRebuild);
                                    tmpNode.put(apiSchemaName, schemaNode);
                                    hashMap.put(apiSchemaName, schemaRebuild.getBytes());
                                    continue;
                                }
                                FileSystemUtilities.writeFile(f, schemaContent);
                            }
                            if (!hashMap.isEmpty()) {
                                for (String apiSchemaName : hashMap.keySet()) {
                                    schemaNode = (JsonNode)tmpNode.get(apiSchemaName);
                                    if (!(schemaNode instanceof ObjectNode)) continue;
                                    ObjectNode objectNode = (ObjectNode)schemaNode;
                                    Iterator it = objectNode.fieldNames();
                                    String name = null;
                                    while (it.hasNext()) {
                                        JsonNode internalNode;
                                        name = (String)it.next();
                                        if (!"definitions".equalsIgnoreCase(name) || !((internalNode = objectNode.get(name)) instanceof ObjectNode)) continue;
                                        ObjectNode internalObjectNode = (ObjectNode)internalNode;
                                        Iterator itInternal = internalObjectNode.fieldNames();
                                        while (itInternal.hasNext()) {
                                            String nameInternal = (String)itInternal.next();
                                            JsonNode typeDefinition = internalObjectNode.get(nameInternal);
                                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                                            bout.write("{".getBytes());
                                            String defOggetto = JSONUtils.getInstance().toString(typeDefinition);
                                            defOggetto = defOggetto.trim();
                                            defOggetto = defOggetto.replaceAll("#/components/schemas", "#/definitions");
                                            if (defOggetto.startsWith("{")) {
                                                defOggetto = defOggetto.substring(1);
                                            }
                                            if (defOggetto.endsWith("}")) {
                                                defOggetto = defOggetto.substring(0, defOggetto.length() - 1);
                                            }
                                            defOggetto = defOggetto.trim();
                                            bout.write(defOggetto.getBytes());
                                            bout.write(",".getBytes());
                                            bout.write("\"definitions\" : ".getBytes());
                                            String definitionStringSchema = JSONUtils.getInstance().toString(internalNode);
                                            definitionStringSchema = definitionStringSchema.replaceAll("#/components/schemas", "#/definitions");
                                            bout.write(definitionStringSchema.getBytes());
                                            bout.write("}".getBytes());
                                            IJsonSchemaValidator validator = ValidatorFactory.newJsonSchemaValidator(jsonValidatorAPI);
                                            JsonSchemaValidatorConfig schemaValidationConfig = new JsonSchemaValidatorConfig();
                                            schemaValidationConfig.setVerbose(config.isVerbose());
                                            schemaValidationConfig.setAdditionalProperties(policyAdditionalProperties);
                                            schemaValidationConfig.setPoliticaInclusioneTipi(JsonSchemaValidatorConfig.POLITICA_INCLUSIONE_TIPI.DEFAULT);
                                            schemaValidationConfig.setEmitLogError(config.isEmitLogError());
                                            schemaValidationConfig.setJsonSchemaVersion(SpecVersion.VersionFlag.V4);
                                            validator.setSchema(bout.toByteArray(), schemaValidationConfig, log);
                                            this.validatorMap.put(apiSchemaName + "#" + nameInternal, validator);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (apiValidatorStructure != null) {
                    this.validatorMap = apiValidatorStructure.getValidatorMap();
                } else if (schemiValidatorePrincipale != null && schemiValidatorePrincipale.size() > 0) {
                    for (String string : schemiValidatorePrincipale.keySet()) {
                        byte[] schema = (byte[])schemiValidatorePrincipale.get(string);
                        JsonNode jsonNode = (JsonNode)nodeValidatorePrincipale.get(string);
                        JsonPathExpressionEngine engine = new JsonPathExpressionEngine();
                        List<String> refPath = this.getRefPath(engine, jsonNode);
                        String schemaRebuild = null;
                        if (refPath != null && !refPath.isEmpty()) {
                            for (String ref : refPath) {
                                String normalizePath;
                                String path3 = this.getRefPath(ref);
                                if (path3 == null || (normalizePath = this.normalizePath(path3)) == null || !this.fileSchema.containsKey(normalizePath)) continue;
                                if (schemaRebuild == null) {
                                    schemaRebuild = new String(schema);
                                }
                                if (!schemaRebuild.contains(path3) && path3.startsWith("./")) {
                                    path3 = path3.substring(2);
                                }
                                File file = this.fileSchema.get(normalizePath);
                                while (schemaRebuild.contains(path3)) {
                                    schemaRebuild = schemaRebuild.replace(path3, "file://" + file.getAbsolutePath());
                                }
                            }
                        }
                        if (schemaRebuild != null) {
                            schema = schemaRebuild.getBytes();
                        }
                        IJsonSchemaValidator validator = ValidatorFactory.newJsonSchemaValidator(jsonValidatorAPI);
                        JsonSchemaValidatorConfig schemaValidationConfig = new JsonSchemaValidatorConfig();
                        schemaValidationConfig.setVerbose(config.isVerbose());
                        schemaValidationConfig.setAdditionalProperties(policyAdditionalProperties);
                        schemaValidationConfig.setPoliticaInclusioneTipi(JsonSchemaValidatorConfig.POLITICA_INCLUSIONE_TIPI.DEFAULT);
                        schemaValidationConfig.setEmitLogError(config.isEmitLogError());
                        schemaValidationConfig.setJsonSchemaVersion(SpecVersion.VersionFlag.V4);
                        validator.setSchema(schema, schemaValidationConfig, log);
                        this.validatorMap.put(string, validator);
                    }
                }
                if (apiValidatorStructure == null) {
                    OpenapiApiValidatorStructure validationStructure = new OpenapiApiValidatorStructure();
                    validationStructure.setSchemiValidatorePrincipale(schemiValidatorePrincipale);
                    validationStructure.setNodeValidatorePrincipale(nodeValidatorePrincipale);
                    validationStructure.setFileSchema(this.fileSchema);
                    validationStructure.setValidatorMap(this.validatorMap);
                    if (openapiApi != null) {
                        openapiApi.setValidationStructure(validationStructure);
                    } else if (apiRest != null) {
                        apiRest.addVendorImpl(VALIDATION_STRUCTURE, validationStructure);
                    }
                }
            }
            catch (Throwable e) {
                try {
                    this.close(log, api, config);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new ProcessingException(e);
            }
        }
        finally {
            this.semaphore.release(lock, "init");
        }
    }

    private List<String> getRefPath(JsonPathExpressionEngine engine, JsonNode schemaNode) throws JsonPathException, JsonPathNotValidException {
        List<String> l = null;
        try {
            l = engine.getStringMatchPattern(schemaNode, "$..$ref");
        }
        catch (JsonPathNotFoundException jsonPathNotFoundException) {
            // empty catch block
        }
        return l;
    }

    private String getRefPath(String ref) {
        if (ref.trim().startsWith("#")) {
            return null;
        }
        return ref.trim().substring(0, ref.indexOf("#"));
    }

    private static String getRefType(String ref) {
        if (ref.trim().startsWith("#")) {
            return ref;
        }
        return ref.trim().substring(ref.indexOf("#"), ref.length());
    }

    private String normalizePath(String path) throws ProcessingException {
        if (path.startsWith("http://") || path.startsWith("https://") || path.startsWith("file://")) {
            try {
                URL url = new URL(path);
                File fileUrl = new File(url.getFile());
                return fileUrl.getName();
            }
            catch (Exception e) {
                throw new ProcessingException(e.getMessage(), e);
            }
        }
        File f = new File(path);
        return f.getName();
    }

    private void normalizeRefs(JsonNode node) throws ProcessingException {
        List listRef = node.findParents("$ref");
        if (listRef != null) {
            for (JsonNode jsonNodeRef : listRef) {
                ObjectNode oNode;
                JsonNode valore;
                String ref;
                String path;
                if (!(jsonNodeRef instanceof ObjectNode) || (path = this.getRefPath(ref = (valore = (oNode = (ObjectNode)jsonNodeRef).get("$ref")).asText())) == null) continue;
                String normalizePath = this.normalizePath(path);
                String refType = Validator.getRefType(ref);
                oNode.remove("$ref");
                oNode.put("$ref", normalizePath + refType);
            }
        }
    }

    @Override
    public void close(Logger log, Api api, ApiValidatorConfig config) throws ProcessingException {
        if (this.fileSchema != null) {
            for (String key : this.fileSchema.keySet()) {
                File file = this.fileSchema.get(key);
                if (file.delete()) continue;
                log.error("Eliminazione file temporaneo [" + file.getAbsolutePath() + "] associato allo schema [" + key + "] non riuscita");
            }
        }
    }

    @Override
    public void validate(HttpBaseEntity<?> httpEntity) throws ProcessingException, ValidatorException {
        ArrayList args = new ArrayList();
        super.validate(this.api, httpEntity, args);
    }

    private List<ApiBodyParameter> getBodyParameters(HttpBaseEntity<?> httpEntity, ApiOperation operation) {
        List<ApiBodyParameter> bodyParameters = null;
        if (httpEntity instanceof HttpBaseRequestEntity) {
            if (operation.getRequest() != null) {
                bodyParameters = operation.getRequest().getBodyParameters();
            }
        } else if (httpEntity instanceof HttpBaseResponseEntity) {
            HttpBaseResponseEntity response = (HttpBaseResponseEntity)httpEntity;
            ApiResponse apiResponseFound = null;
            ApiResponse apiResponseDefault = null;
            if (operation.getResponses() != null) {
                for (ApiResponse apiResponse : operation.getResponses()) {
                    if (apiResponse.isDefaultHttpReturnCode()) {
                        apiResponseDefault = apiResponse;
                    }
                    if (response.getStatus() != apiResponse.getHttpReturnCode()) continue;
                    apiResponseFound = apiResponse;
                    break;
                }
            }
            if (apiResponseFound == null && apiResponseDefault != null) {
                apiResponseFound = apiResponseDefault;
            }
            if (apiResponseFound != null) {
                bodyParameters = apiResponseFound.getBodyParameters();
            }
        }
        return bodyParameters;
    }

    @Override
    public void validatePreConformanceCheck(HttpBaseEntity<?> httpEntity, ApiOperation operation, Object ... args) throws ProcessingException, ValidatorException {
        List<ApiBodyParameter> bodyParameters = this.getBodyParameters(httpEntity, operation);
        if (this.openApi4j != null) {
            this.validateWithOpenApi4j(httpEntity, operation);
        } else if (this.swaggerRequestValidator != null) {
            this.validateWithSwaggerRequestValidator(httpEntity, operation);
        }
        boolean required = false;
        if (bodyParameters != null && !bodyParameters.isEmpty()) {
            for (ApiBodyParameter body : bodyParameters) {
                if (!body.isRequired()) continue;
                required = true;
            }
        }
        if (required && httpEntity.getContent() == null) {
            throw new ValidatorException("Required body undefined");
        }
        if (this.openApi4j == null && this.swaggerRequestValidator == null && bodyParameters != null && !bodyParameters.isEmpty()) {
            try {
                boolean isJson;
                boolean bl = isJson = httpEntity.getContentType() != null && httpEntity.getContentType().toLowerCase().contains("json");
                if (isJson) {
                    List<IJsonSchemaValidator> validatorLst = this.getValidatorList(operation, httpEntity);
                    boolean valid = false;
                    Exception exc = null;
                    if (httpEntity.getContent() != null) {
                        byte[] bytes = httpEntity.getContent().toString().getBytes();
                        for (IJsonSchemaValidator validator : validatorLst) {
                            ValidationResponse response = validator.validate(bytes);
                            if (!ValidationResponse.ESITO.OK.equals((Object)response.getEsito())) {
                                exc = response.getException();
                                continue;
                            }
                            valid = true;
                        }
                    } else {
                        throw new ValidatorException("Content undefined");
                    }
                    if (!valid) {
                        throw new ValidatorException(exc);
                    }
                }
            }
            catch (ValidationException e) {
                throw new ValidatorException(e);
            }
        }
    }

    private List<IJsonSchemaValidator> getValidatorList(ApiOperation operation, HttpBaseEntity<?> httpEntity) throws ValidatorException {
        ArrayList<IJsonSchemaValidator> lst = new ArrayList<IJsonSchemaValidator>();
        if (this.onlySchemas) {
            if (this.validatorMap != null) {
                lst.addAll(this.validatorMap.values());
            }
        } else {
            List<ApiBodyParameter> bodyParameters = this.getBodyParameters(httpEntity, operation);
            if (bodyParameters != null && !bodyParameters.isEmpty()) {
                for (ApiBodyParameter body : bodyParameters) {
                    Object key = null;
                    if (body.getElement() instanceof ApiReference) {
                        ApiReference apiRef = (ApiReference)body.getElement();
                        key = apiRef.getSchemaRef() + "#" + apiRef.getType();
                    } else {
                        key = body.getElement().toString();
                    }
                    if (this.validatorMap == null || !this.validatorMap.containsKey(key)) continue;
                    lst.add(this.validatorMap.get(key));
                }
            }
        }
        if (lst.isEmpty()) {
            throw new ValidatorException("Validator not found");
        }
        return lst;
    }

    private void validateWithOpenApi4j(HttpBaseEntity<?> httpEntity, ApiOperation operation) throws ProcessingException, ValidatorException {
        org.openapi4j.parser.model.v3.Operation operationOpenApi4j = null;
        Path pathOpenApi4j = null;
        block3: for (String path : this.openApi4j.getPaths().keySet()) {
            Path pathO = (Path)this.openApi4j.getPaths().get(path);
            for (String method : pathO.getOperations().keySet()) {
                org.openapi4j.parser.model.v3.Operation op = pathO.getOperation(method);
                String normalizePath = ApiOperation.normalizePath(path);
                if (!operation.getHttpMethod().toString().equalsIgnoreCase(method) || !operation.getPath().equals(normalizePath)) continue;
                operationOpenApi4j = op;
                pathOpenApi4j = pathO;
                continue block3;
            }
        }
        if (operationOpenApi4j == null || pathOpenApi4j == null) {
            throw new ProcessingException("Resource " + operation.getHttpMethod() + " " + operation.getPath() + " not found in OpenAPI 3");
        }
        try {
            ValidationData vData = new ValidationData();
            this.openApi4j.setServers(null);
            OperationValidator val = new OperationValidator(this.openApi4j, pathOpenApi4j, operationOpenApi4j);
            if (httpEntity instanceof HttpBaseRequestEntity) {
                HttpBaseRequestEntity httpRequest = (HttpBaseRequestEntity)httpEntity;
                Request requestOpenApi4j = this.buildRequestOpenApi4j(httpRequest.getUrl(), httpRequest.getMethod().toString(), httpRequest.getParameters(), httpRequest.getCookies(), httpRequest.getHeaders(), httpRequest.getContent());
                if (this.openApi4jConfig.isValidateRequestPath()) {
                    val.validatePath(requestOpenApi4j, vData);
                }
                if (this.openApi4jConfig.isValidateRequestQuery()) {
                    val.validateQuery(requestOpenApi4j, vData);
                }
                if (this.openApi4jConfig.isValidateRequestHeaders()) {
                    val.validateHeaders(requestOpenApi4j, vData);
                }
                if (this.openApi4jConfig.isValidateRequestCookie()) {
                    val.validateCookies(requestOpenApi4j, vData);
                }
                if (this.openApi4jConfig.isValidateRequestBody()) {
                    val.validateBody(requestOpenApi4j, vData);
                }
            } else if (httpEntity instanceof HttpBaseResponseEntity) {
                HttpBaseResponseEntity response = (HttpBaseResponseEntity)httpEntity;
                org.openapi4j.operation.validator.model.Response responseOpenApi4j = Validator.buildResponseOpenApi4j(response.getStatus(), response.getHeaders(), response.getContent());
                if (this.openApi4jConfig.isValidateResponseHeaders()) {
                    val.validateHeaders(responseOpenApi4j, vData);
                }
                if (this.openApi4jConfig.isValidateResponseBody()) {
                    val.validateBody(responseOpenApi4j, vData);
                }
            }
            if (!vData.isValid()) {
                if (vData.results() != null) {
                    throw new ValidatorException(vData.results().toString());
                }
                throw new ValidatorException("Validation failed");
            }
        }
        catch (ValidatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    private Request buildRequestOpenApi4j(String urlInvocazione, String method, Map<String, List<String>> queryParams, List<Cookie> cookies, Map<String, List<String>> headers, Object content) throws ProcessingException {
        try {
            Iterator<String> headerNames;
            DefaultRequest.Builder builder = new DefaultRequest.Builder(urlInvocazione, Request.Method.getMethod((String)method));
            String queryString = null;
            if (queryParams != null && !queryParams.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String key : queryParams.keySet()) {
                    List<String> values = queryParams.get(key);
                    try {
                        key = TransportUtils.urlEncodeParam(key, Charset.UTF_8.getValue());
                    }
                    catch (Exception e) {
                        if (this.log != null) {
                            this.log.error("URLEncode key[" + key + "] error: " + e.getMessage(), (Throwable)e);
                        }
                        e.printStackTrace(System.out);
                    }
                    for (String value : values) {
                        if (sb.length() > 0) {
                            sb.append("&");
                        }
                        try {
                            value = TransportUtils.urlEncodeParam(value, Charset.UTF_8.getValue());
                        }
                        catch (Exception e) {
                            if (this.log != null) {
                                this.log.error("URLEncode value[" + value + "] error: " + e.getMessage(), (Throwable)e);
                            }
                            e.printStackTrace(System.out);
                        }
                        sb.append(key);
                        sb.append("=");
                        sb.append(value);
                    }
                }
                queryString = sb.toString();
            }
            if (HttpRequestMethod.GET.toString().equalsIgnoreCase(method)) {
                builder.query(queryString);
            } else {
                if (queryString != null) {
                    builder.query(queryString);
                }
                if (content != null) {
                    Object s = null;
                    byte[] b = null;
                    InputStream is = null;
                    if (content instanceof String) {
                        s = (String)content;
                    } else if (content instanceof byte[]) {
                        b = (byte[])content;
                    } else if (content instanceof InputStream) {
                        is = (InputStream)content;
                    }
                    if (s != null) {
                        builder.body(Body.from((String)s));
                    } else if (b != null) {
                        try (ByteArrayInputStream bin = new ByteArrayInputStream(b);){
                            builder.body(Body.from((InputStream)bin));
                        }
                    } else if (is != null) {
                        builder.body(Body.from((InputStream)is));
                    } else {
                        throw new Exception("Type '" + content.getClass().getName() + "' unsupported");
                    }
                }
            }
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    builder.cookie(cookie.getName(), cookie.getValue());
                }
            }
            if (headers != null && (headerNames = headers.keySet().iterator()) != null) {
                while (headerNames.hasNext()) {
                    String headerName = headerNames.next();
                    builder.header(headerName, (Collection)headers.get(headerName));
                }
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    private static org.openapi4j.operation.validator.model.Response buildResponseOpenApi4j(int status, Map<String, List<String>> headers, Object content) throws ProcessingException {
        try {
            Iterator<String> headerNames;
            DefaultResponse.Builder builder = new DefaultResponse.Builder(status);
            if (content != null) {
                String s = null;
                byte[] b = null;
                InputStream is = null;
                if (content instanceof String) {
                    s = (String)content;
                } else if (content instanceof byte[]) {
                    b = (byte[])content;
                } else if (content instanceof InputStream) {
                    is = (InputStream)content;
                } else if (content instanceof Document) {
                    b = XMLUtils.getInstance().toByteArray((Document)content);
                } else if (content instanceof Element) {
                    b = XMLUtils.getInstance().toByteArray((Element)content);
                }
                if (s != null) {
                    builder.body(Body.from((String)s));
                } else if (b != null) {
                    try (ByteArrayInputStream bin = new ByteArrayInputStream(b);){
                        builder.body(Body.from((InputStream)bin));
                    }
                } else if (is != null) {
                    builder.body(Body.from((InputStream)is));
                } else {
                    throw new Exception("Type '" + content.getClass().getName() + "' unsupported");
                }
            }
            if (headers != null && (headerNames = headers.keySet().iterator()) != null) {
                while (headerNames.hasNext()) {
                    String headerName = headerNames.next();
                    builder.header(headerName, (Collection)headers.get(headerName));
                }
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    private void validateWithSwaggerRequestValidator(HttpBaseEntity<?> httpEntity, ApiOperation gwOperation) throws ProcessingException, ValidatorException {
        ValidationReport report;
        Optional<Map.Entry> item = this.openApiSwagger.getPaths().entrySet().stream().filter(pathItem -> ApiOperation.normalizePath((String)pathItem.getKey()).equals(gwOperation.getPath())).findFirst();
        if (item.isEmpty()) {
            throw new ProcessingException("Resource " + gwOperation.getHttpMethod() + " " + gwOperation.getPath() + " not found in OpenAPI 3");
        }
        PathItem.HttpMethod method = PathItem.HttpMethod.valueOf((String)gwOperation.getHttpMethod().toString());
        Operation swaggerOperation = (Operation)((PathItem)item.get().getValue()).readOperationsMap().get(method);
        ApiPathImpl apiPath = new ApiPathImpl(httpEntity.getUrl(), null);
        NormalisedPathImpl requestPath = new NormalisedPathImpl(httpEntity.getUrl(), null);
        com.atlassian.oai.validator.model.ApiOperation swaggerValidatorOperation = new com.atlassian.oai.validator.model.ApiOperation((ApiPath)apiPath, (NormalisedPath)requestPath, method, swaggerOperation);
        if (httpEntity instanceof HttpBaseRequestEntity) {
            HttpBaseRequestEntity request = (HttpBaseRequestEntity)httpEntity;
            com.atlassian.oai.validator.model.Request swaggerRequest = Validator.buildSwaggerRequest(request);
            report = this.swaggerRequestValidator.validateRequest(swaggerRequest, swaggerValidatorOperation);
        } else if (httpEntity instanceof HttpBaseResponseEntity) {
            HttpBaseResponseEntity response = (HttpBaseResponseEntity)httpEntity;
            Response swaggerResponse = Validator.buildSwaggerResponse(response);
            report = this.swaggerResponseValidator.validateResponse(swaggerResponse, swaggerValidatorOperation);
        } else {
            throw new ProcessingException("Unknown type for HttpBaseEntity: " + httpEntity.getClass().toString());
        }
        if (report.hasErrors()) {
            String msgReport = SimpleValidationReportFormat.getInstance().apply(report);
            throw new ValidatorException(msgReport);
        }
    }

    @Override
    public void validatePostConformanceCheck(HttpBaseEntity<?> httpEntity, ApiOperation operation, Object ... args) throws ProcessingException, ValidatorException {
    }

    @Override
    public void validateValueAsType(ApiParameterType parameterType, String value, String type, ApiSchemaTypeRestriction typeRestriction) throws ProcessingException, ValidatorException {
        if (type != null) {
            String stringValue;
            BigDecimal numberValue;
            block109: {
                type = type.trim();
                numberValue = null;
                stringValue = null;
                if ("string".equalsIgnoreCase(type)) {
                    stringValue = value;
                } else {
                    if ("byte".equalsIgnoreCase(type) || "unsignedByte".equalsIgnoreCase(type)) {
                        try {
                            byte v = Byte.parseByte(value);
                            numberValue = new BigDecimal(v);
                        }
                        catch (Throwable e) {
                            throw new ValidatorException(e.getMessage(), e);
                        }
                    }
                    if ("char".equalsIgnoreCase(type)) {
                        if (value.length() > 1) {
                            throw new ValidatorException("More than one character");
                        }
                        stringValue = value;
                    } else {
                        if ("double".equalsIgnoreCase(type) || "decimal".equalsIgnoreCase(type)) {
                            try {
                                double v = Double.parseDouble(value);
                                numberValue = BigDecimal.valueOf(v);
                            }
                            catch (Throwable e) {
                                throw new ValidatorException(e.getMessage(), e);
                            }
                        }
                        if ("float".equalsIgnoreCase(type)) {
                            try {
                                float v = Float.parseFloat(value);
                                numberValue = BigDecimal.valueOf(v);
                            }
                            catch (Throwable e) {
                                throw new ValidatorException(e.getMessage(), e);
                            }
                        }
                        if ("int".equalsIgnoreCase(type) || "integer".equalsIgnoreCase(type) || "positiveInteger".equalsIgnoreCase(type) || "negativeInteger".equalsIgnoreCase(type) || "nonPositiveInteger".equalsIgnoreCase(type) || "nonNegativeInteger".equalsIgnoreCase(type) || "unsignedInt".equalsIgnoreCase(type) || "int32".equalsIgnoreCase(type)) {
                            try {
                                int i = Integer.parseInt(value);
                                if ("positiveInteger".equalsIgnoreCase(type)) {
                                    if (i <= 0) {
                                        throw new ValidatorException("Expected a positive value");
                                    }
                                } else if ("nonNegativeInteger".equalsIgnoreCase(type)) {
                                    if (i < 0) {
                                        throw new ValidatorException("Expected a non negative value");
                                    }
                                } else if ("negativeInteger".equalsIgnoreCase(type)) {
                                    if (i >= 0) {
                                        throw new ValidatorException("Expected a negative value");
                                    }
                                } else if ("nonPositiveInteger".equalsIgnoreCase(type)) {
                                    if (i > 0) {
                                        throw new ValidatorException("Expected a non positive value");
                                    }
                                } else if ("unsignedInt".equalsIgnoreCase(type) && i < 0) {
                                    throw new ValidatorException("Expected a unsigned value");
                                }
                                numberValue = BigDecimal.valueOf(i);
                            }
                            catch (Throwable e) {
                                throw new ValidatorException(e.getMessage(), e);
                            }
                        }
                        if ("long".equalsIgnoreCase(type) || "unsignedLong".equalsIgnoreCase(type) || "int64".equalsIgnoreCase(type)) {
                            try {
                                long l = Long.parseLong(value);
                                if ("unsignedLong".equalsIgnoreCase(type) && l < 0L) {
                                    throw new ValidatorException("Expected a unsigned value");
                                }
                                numberValue = new BigDecimal(l);
                            }
                            catch (Throwable e) {
                                throw new ValidatorException(e.getMessage(), e);
                            }
                        }
                        if ("number".equalsIgnoreCase(type)) {
                            try {
                                try {
                                    double d = Double.parseDouble(value);
                                    numberValue = BigDecimal.valueOf(d);
                                }
                                catch (Exception e) {
                                    long l = Long.parseLong(value);
                                    numberValue = new BigDecimal(l);
                                }
                            }
                            catch (Throwable e) {
                                throw new ValidatorException(e.getMessage(), e);
                            }
                        } else {
                            if ("short".equalsIgnoreCase(type) || "unsignedShort".equalsIgnoreCase(type)) {
                                try {
                                    short s = Short.parseShort(value);
                                    if ("unsignedShort".equalsIgnoreCase(type) && s < 0) {
                                        throw new ValidatorException("Expected a unsigned value");
                                    }
                                    numberValue = new BigDecimal(s);
                                }
                                catch (Throwable e) {
                                    throw new ValidatorException(e.getMessage(), e);
                                }
                            }
                            if ("boolean".equalsIgnoreCase(type)) {
                                try {
                                    if (!"true".equals(value) && !"false".equals(value)) {
                                        throw new Exception("Only true/false value expected (found: " + value + "); Note that truthy and falsy values such as \"true\", \"\", 0 or null are not considered boolean values.");
                                    }
                                    break block109;
                                }
                                catch (Throwable e) {
                                    throw new ValidatorException(e.getMessage(), e);
                                }
                            }
                            if ("anyURI".equalsIgnoreCase(type)) {
                                try {
                                    new URI(value);
                                }
                                catch (Throwable e) {
                                    throw new ValidatorException(e.getMessage(), e);
                                }
                            }
                            if ("uuid".equalsIgnoreCase(type)) {
                                try {
                                    UUID.fromString(value);
                                }
                                catch (Throwable e) {
                                    throw new ValidatorException(e.getMessage(), e);
                                }
                            }
                            if ("date-time".equalsIgnoreCase(type)) {
                                try {
                                    DateUtils.validateDateTimeAsRFC3339Sec56(value);
                                }
                                catch (Throwable e) {
                                    throw new ValidatorException(e.getMessage(), e);
                                }
                            }
                            if ("date".equalsIgnoreCase(type)) {
                                try {
                                    DateUtils.validateDateAsRFC3339Sec56(value);
                                }
                                catch (Throwable e) {
                                    throw new ValidatorException(e.getMessage(), e);
                                }
                            }
                        }
                    }
                }
            }
            if (typeRestriction != null) {
                if (numberValue != null) {
                    int compare;
                    if (typeRestriction.getMaximum() != null && (compare = numberValue.compareTo(typeRestriction.getMaximum())) >= 0) {
                        if (compare > 0) {
                            throw new ValidatorException("Value higher than the maximum '" + typeRestriction.getMaximum() + "'");
                        }
                        if (typeRestriction.getExclusiveMaximum() != null && typeRestriction.getExclusiveMaximum().booleanValue()) {
                            throw new ValidatorException("Value equals to the maximum '" + typeRestriction.getMaximum() + "' and exclusive maximum is enabled");
                        }
                    }
                    if (typeRestriction.getMinimum() != null) {
                        compare2 = numberValue.compareTo(typeRestriction.getMinimum());
                        if (compare2 < 0) {
                            throw new ValidatorException("Value lowest than the minimum '" + typeRestriction.getMinimum() + "'");
                        }
                        if (compare2 <= 0 && typeRestriction.getExclusiveMinimum() != null && typeRestriction.getExclusiveMinimum().booleanValue()) {
                            throw new ValidatorException("Value equals to the minimum '" + typeRestriction.getMinimum() + "' and exclusive minimum is enabled");
                        }
                    }
                    if (typeRestriction.getMultipleOf() != null && numberValue.compareTo(typeRestriction.getMultipleOf()) != 0) {
                        try {
                            BigDecimal compare2 = numberValue.divide(typeRestriction.getMultipleOf(), 0, RoundingMode.UNNECESSARY);
                        }
                        catch (ArithmeticException e) {
                            throw new ValidatorException("Value is not multiple of '" + typeRestriction.getMultipleOf() + "'");
                        }
                    }
                }
                if (stringValue != null) {
                    if (typeRestriction.getEnumValues() != null && !typeRestriction.getEnumValues().isEmpty()) {
                        ArrayList<String> valoriPresenti = new ArrayList<String>();
                        if (typeRestriction.isArrayParameter()) {
                            if (ApiParameterType.query.equals((Object)parameterType) || ApiParameterType.form.equals((Object)parameterType)) {
                                List l;
                                if (typeRestriction.isStyleQueryForm() || typeRestriction.getStyle() == null) {
                                    List l2;
                                    if (typeRestriction.isExplodeDisabled() && (l2 = StringUtil.tokenize((String)stringValue, (String)",", (boolean)false, (boolean)false)) != null && !l2.isEmpty()) {
                                        valoriPresenti.addAll(l2);
                                    }
                                } else if (typeRestriction.isStyleQuerySpaceDelimited()) {
                                    List l3;
                                    if (typeRestriction.isExplodeDisabled() && (l3 = StringUtil.tokenize((String)stringValue, (String)Pattern.quote(" "), (boolean)false, (boolean)false)) != null && !l3.isEmpty()) {
                                        valoriPresenti.addAll(l3);
                                    }
                                } else if (typeRestriction.isStyleQueryPipeDelimited() && typeRestriction.isExplodeDisabled() && (l = StringUtil.tokenize((String)stringValue, (String)Pattern.quote("|"), (boolean)false, (boolean)false)) != null && !l.isEmpty()) {
                                    valoriPresenti.addAll(l);
                                }
                            } else if (ApiParameterType.header.equals((Object)parameterType)) {
                                List l;
                                if ((typeRestriction.isStyleHeaderSimple() || typeRestriction.getStyle() == null) && (l = StringUtil.tokenize((String)stringValue, (String)",", (boolean)false, (boolean)false)) != null && !l.isEmpty()) {
                                    valoriPresenti.addAll(l);
                                }
                            } else if (ApiParameterType.path.equals((Object)parameterType)) {
                                if (typeRestriction.isStylePathSimple() || typeRestriction.getStyle() == null) {
                                    List l = StringUtil.tokenize((String)stringValue, (String)",", (boolean)false, (boolean)false);
                                    if (l != null && !l.isEmpty()) {
                                        valoriPresenti.addAll(l);
                                    }
                                } else if (typeRestriction.isStylePathLabel()) {
                                    if (stringValue.length() > 1) {
                                        String splitPattern = typeRestriction.isExplodeEnabled() ? "\\." : ",";
                                        String[] v = stringValue.substring(1).split(splitPattern);
                                        if (v != null && v.length > 0) {
                                            for (String valore : v) {
                                                valoriPresenti.add(valore);
                                            }
                                        }
                                    }
                                } else if (typeRestriction.isStylePathMatrix()) {
                                    String splitPattern = typeRestriction.isExplodeEnabled() ? ";" : ",";
                                    List<String> l = this.getArrayValues(typeRestriction.isExplodeEnabled(), stringValue, splitPattern);
                                    if (l != null && !l.isEmpty()) {
                                        valoriPresenti.addAll(l);
                                    }
                                }
                            }
                        }
                        if (valoriPresenti.isEmpty()) {
                            valoriPresenti.add(stringValue);
                        }
                        for (String valorePresente : valoriPresenti) {
                            boolean found = false;
                            StringBuilder sbList = new StringBuilder();
                            for (Object o : typeRestriction.getEnumValues()) {
                                if (o == null) continue;
                                String check = o.toString();
                                if (sbList.length() > 0) {
                                    sbList.append(",");
                                }
                                sbList.append(check);
                                if (!valorePresente.equals(check)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            throw new ValidatorException("Uncorrect enum value '" + valorePresente + "', expected: '" + sbList.toString() + "'");
                        }
                    }
                    if (typeRestriction.getMinLength() != null && stringValue.length() < typeRestriction.getMinLength().intValue()) {
                        throw new ValidatorException("Too short, expected min length '" + typeRestriction.getMinLength() + "'");
                    }
                    if (typeRestriction.getMaxLength() != null && stringValue.length() > typeRestriction.getMaxLength().intValue()) {
                        throw new ValidatorException("Too big, expected max length '" + typeRestriction.getMaxLength() + "'");
                    }
                    if (typeRestriction.getPattern() != null) {
                        String pattern = typeRestriction.getPattern().trim();
                        try {
                            if (pattern.startsWith("^") && pattern.endsWith("$") ? !RegularExpressionEngine.isMatch(stringValue, pattern) : !RegularExpressionEngine.isFind(stringValue, pattern)) {
                                throw new ValidatorException("Pattern match failed ('" + pattern + "')");
                            }
                        }
                        catch (ValidatorException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            throw new ValidatorException("Pattern validation error '" + pattern + "': " + e.getMessage(), e);
                        }
                    }
                }
            }
        }
    }

    private List<String> getArrayValues(boolean explode, String rawValue, String splitPattern) {
        try {
            Matcher matcher = PREFIXED_SEMICOLON_NAME_REGEX.matcher(rawValue);
            if (explode) {
                ArrayList<String> arrayValues = new ArrayList<String>();
                int limit = 1000;
                for (int index = 0; matcher.find() && index < limit; ++index) {
                    arrayValues.add(matcher.group(2));
                }
                return arrayValues;
            }
            return matcher.matches() ? Arrays.asList(matcher.group(2).split(splitPattern)) : null;
        }
        catch (Throwable t) {
            this.log.error(t.getMessage(), t);
            return null;
        }
    }

    private static Request.Method fromHttpMethod(HttpRequestMethod method) {
        return Request.Method.valueOf((String)method.toString());
    }

    private static Response buildSwaggerResponse(HttpBaseResponseEntity<?> response) throws ProcessingException {
        Object content;
        SimpleResponse.Builder builder = new SimpleResponse.Builder(response.getStatus());
        if (response.getHeaders() != null && !response.getHeaders().isEmpty()) {
            response.getHeaders().forEach((arg_0, arg_1) -> ((SimpleResponse.Builder)builder).withHeader(arg_0, arg_1));
        }
        if ((content = response.getContent()) instanceof String) {
            builder.withBody((String)content);
        } else if (content instanceof byte[]) {
            builder.withBody((byte[])content);
        } else if (content instanceof InputStream) {
            builder.withBody((InputStream)content);
        } else if (content instanceof Document) {
            try {
                builder.withBody(XMLUtils.getInstance().toByteArray((Document)content));
            }
            catch (Exception e) {
                throw new ProcessingException(e.getMessage(), e);
            }
        } else if (content instanceof Element) {
            try {
                builder.withBody(XMLUtils.getInstance().toByteArray((Element)content));
            }
            catch (Exception e) {
                throw new ProcessingException(e.getMessage(), e);
            }
        } else if (content != null) {
            throw new ProcessingException("Type '" + content.getClass().getName() + "' unsupported");
        }
        return builder.build();
    }

    private static com.atlassian.oai.validator.model.Request buildSwaggerRequest(HttpBaseRequestEntity<?> request) throws ProcessingException {
        Object content = request.getContent();
        SimpleRequest.Builder builder = new SimpleRequest.Builder(Validator.fromHttpMethod(request.getMethod()), request.getUrl());
        Map<String, List<String>> hdr = request.getHeaders();
        if (hdr != null && !hdr.isEmpty()) {
            List<String> originalValues = TransportUtils.getValues(hdr, "Accept");
            TransportUtils.removeRawObject(hdr, "Accept");
            if (!hdr.isEmpty()) {
                hdr.forEach((arg_0, arg_1) -> ((SimpleRequest.Builder)builder).withHeader(arg_0, arg_1));
            }
            if (originalValues != null) {
                hdr.put("Accept", originalValues);
            }
        }
        if (request.getParameters() != null && !request.getParameters().isEmpty()) {
            request.getParameters().forEach((arg_0, arg_1) -> ((SimpleRequest.Builder)builder).withQueryParam(arg_0, arg_1));
        }
        if (request.getCookies() != null && !request.getCookies().isEmpty()) {
            Cookie cookie = request.getCookies().get(0);
            String cookiesValue = cookie.getName() + "=" + cookie.getValue();
            for (int i = 1; i < request.getCookies().size(); ++i) {
                cookie = request.getCookies().get(i);
                cookiesValue = cookiesValue + "; " + cookie.getName() + "=" + cookie.getValue();
            }
            builder.withHeader("Cookie", new String[]{cookiesValue});
        }
        if (content instanceof String) {
            builder.withBody((String)content);
        } else if (content instanceof byte[]) {
            builder.withBody((byte[])content);
        } else if (content instanceof InputStream) {
            builder.withBody((InputStream)content);
        } else if (content != null) {
            throw new ProcessingException("Type '" + content.getClass().getName() + "' unsupported");
        }
        return builder.build();
    }

    protected static void removeTypeObjectAssociationWithOneOfAndAnyOfModels(OpenAPI openAPI) {
        if (openAPI.getComponents() != null) {
            Validator.removeTypeObjectFromEachValue(openAPI.getComponents().getSchemas(), schema -> schema);
        }
    }

    private static <T> void removeTypeObjectFromEachValue(Map<String, T> map, Function<T, Object> function) {
        if (map != null) {
            map.values().forEach(it -> Validator.removeTypeObjectAssociationWithOneOfAndAnyOfFromSchema(function.apply(it)));
        }
    }

    private static void removeTypeObjectAssociationWithOneOfAndAnyOfFromSchema(Object object) {
        if (object instanceof ObjectSchema) {
            Validator.removeTypeObjectFromEachValue(((ObjectSchema)object).getProperties(), schema -> schema);
        } else if (object instanceof ArraySchema) {
            Validator.removeTypeObjectAssociationWithOneOfAndAnyOfFromSchema(((ArraySchema)object).getItems());
        } else if (object instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)object;
            composedSchema.setType(null);
        }
    }

    protected static void removeRegexPatternOnStringsOfFormatByte(OpenAPI openAPI) {
        if (openAPI.getPaths() != null) {
            openAPI.getPaths().values().forEach(pathItem -> pathItem.readOperations().forEach(operation -> {
                Validator.excludeBase64PatternFromEachValue(operation.getResponses(), io.swagger.v3.oas.models.responses.ApiResponse::getContent);
                if (operation.getRequestBody() != null) {
                    Validator.excludeBase64PatternFromSchema(operation.getRequestBody().getContent());
                }
                if (operation.getParameters() != null) {
                    operation.getParameters().forEach(it -> Validator.excludeBase64PatternFromSchema(it.getContent()));
                    operation.getParameters().forEach(it -> Validator.excludeBase64PatternFromSchema(it.getSchema()));
                }
            }));
        }
        if (openAPI.getComponents() != null) {
            Validator.excludeBase64PatternFromEachValue(openAPI.getComponents().getResponses(), io.swagger.v3.oas.models.responses.ApiResponse::getContent);
            Validator.excludeBase64PatternFromEachValue(openAPI.getComponents().getRequestBodies(), RequestBody::getContent);
            Validator.excludeBase64PatternFromEachValue(openAPI.getComponents().getHeaders(), Header::getContent);
            Validator.excludeBase64PatternFromEachValue(openAPI.getComponents().getHeaders(), Header::getSchema);
            Validator.excludeBase64PatternFromEachValue(openAPI.getComponents().getParameters(), Parameter::getContent);
            Validator.excludeBase64PatternFromEachValue(openAPI.getComponents().getParameters(), Parameter::getSchema);
            Validator.excludeBase64PatternFromEachValue(openAPI.getComponents().getSchemas(), schema -> schema);
        }
    }

    private static <T> void excludeBase64PatternFromEachValue(Map<String, T> map, Function<T, Object> function) {
        if (map != null) {
            map.values().forEach(it -> Validator.excludeBase64PatternFromSchema(function.apply(it)));
        }
    }

    private static void excludeBase64PatternFromSchema(Object object) {
        StringSchema stringSchema;
        if (object instanceof Content) {
            Validator.excludeBase64PatternFromEachValue((Content)object, MediaType::getSchema);
        } else if (object instanceof ObjectSchema) {
            Validator.excludeBase64PatternFromEachValue(((ObjectSchema)object).getProperties(), schema -> schema);
        } else if (object instanceof ArraySchema) {
            Validator.excludeBase64PatternFromSchema(((ArraySchema)object).getItems());
        } else if (object instanceof StringSchema && "byte".equals((stringSchema = (StringSchema)object).getFormat())) {
            stringSchema.setPattern(null);
        }
    }
}

