/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.properties;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.properties.CollectionProperties;
import org.openspcoop2.utils.properties.PropertiesReader;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.slf4j.Logger;

public abstract class InstanceProperties {
    private PropertiesReader propertiesOriginale;
    private CollectionProperties propertiesRidefinitoFile;
    private PropertiesReader propertiesRidefinitoObject;
    protected Logger log;
    private String openspcoop2LocalHome;
    private boolean readCallsNotSynchronized;

    protected InstanceProperties(String openspcoop2LocalHome, Properties propertiesOriginale, Logger log) {
        this(openspcoop2LocalHome, propertiesOriginale, log, true);
    }

    protected InstanceProperties(String openspcoop2LocalHome, Properties propertiesOriginale, Logger log, boolean readCallsNotSynchronized) {
        this.propertiesOriginale = new PropertiesReader(propertiesOriginale, readCallsNotSynchronized);
        this.log = log;
        if (this.log == null) {
            this.log = LoggerWrapperFactory.getLogger(InstanceProperties.class);
        }
        this.openspcoop2LocalHome = openspcoop2LocalHome;
        this.readCallsNotSynchronized = readCallsNotSynchronized;
    }

    private void logError(String msg, Exception e) {
        this.log.error(msg, (Throwable)e);
    }

    public void setLocalFileImplementation(String variable, String path, String confDirectory) {
        CollectionProperties prop = PropertiesUtilities.searchLocalImplementation(this.openspcoop2LocalHome, this.log, variable, path, confDirectory, this.readCallsNotSynchronized);
        if (prop != null) {
            this.propertiesRidefinitoFile = prop;
        }
    }

    public void setLocalFileImplementation(CollectionProperties prop) {
        this.propertiesRidefinitoFile = prop;
    }

    public void setLocalObjectImplementation(Properties prop) {
        this.propertiesRidefinitoObject = new PropertiesReader(prop, this.readCallsNotSynchronized);
    }

    public String getValue(String key) throws UtilsException {
        return this.getValueEngine(key, false);
    }

    public String getValueConvertEnvProperties(String key) throws UtilsException {
        return this.getValueEngine(key, true);
    }

    public Properties readProperties(String prefix) throws UtilsException {
        return this.readPropertiesEngine(prefix, false);
    }

    public Properties readPropertiesConvertEnvProperties(String prefix) throws UtilsException {
        return this.readPropertiesEngine(prefix, true);
    }

    public ConcurrentMap<String, String> readPropertiesAsConcurrentHashMap(String prefix) throws UtilsException {
        return Utilities.convertToConcurrentHashMap(this.readProperties(prefix));
    }

    public ConcurrentMap<String, String> readPropertiesAsConcurrentHashMapConvertEnvProperties(String prefix) throws UtilsException {
        return Utilities.convertToConcurrentHashMap(this.readPropertiesConvertEnvProperties(prefix));
    }

    public Map<String, String> readPropertiesAsHashMap(String prefix) throws UtilsException {
        return Utilities.convertToHashMap(this.readProperties(prefix));
    }

    public Map<String, String> readPropertiesAsHashMapConvertEnvProperties(String prefix) throws UtilsException {
        return Utilities.convertToHashMap(this.readPropertiesConvertEnvProperties(prefix));
    }

    public String convertEnvProperties(String value) throws UtilsException {
        return this.propertiesOriginale.convertEnvProperties(value);
    }

    public Enumeration<String> propertyNames() {
        String ridefinito;
        Enumeration<?> enumPropRidefinito;
        Enumeration<?> enumProp = this.propertiesOriginale.propertyNames();
        ArrayList<String> object = new ArrayList<String>();
        while (enumProp.hasMoreElements()) {
            object.add((String)enumProp.nextElement());
        }
        if (this.propertiesRidefinitoFile != null) {
            enumPropRidefinito = this.propertiesRidefinitoFile.propertyNames();
            while (enumPropRidefinito != null && enumPropRidefinito.hasMoreElements()) {
                ridefinito = (String)enumPropRidefinito.nextElement();
                if (object.contains(ridefinito)) continue;
                object.add(ridefinito);
            }
        }
        if (this.propertiesRidefinitoObject != null) {
            enumPropRidefinito = this.propertiesRidefinitoObject.propertyNames();
            while (enumPropRidefinito != null && enumPropRidefinito.hasMoreElements()) {
                ridefinito = (String)enumPropRidefinito.nextElement();
                if (object.contains(ridefinito)) continue;
                object.add(ridefinito);
            }
        }
        return Collections.enumeration(object);
    }

    private String getValueEngine(String key, boolean convertEnvProperties) throws UtilsException {
        try {
            int i;
            String tmp;
            String[] addObject = null;
            boolean appendObject = false;
            String tmpObject = null;
            if (this.propertiesRidefinitoObject != null) {
                tmpObject = convertEnvProperties ? this.propertiesRidefinitoObject.getValue_convertEnvProperties(key) : this.propertiesRidefinitoObject.getValue(key);
            }
            if (tmpObject != null) {
                tmpObject = tmpObject.trim();
                String add = null;
                if (tmpObject.startsWith("+")) {
                    appendObject = true;
                    add = tmpObject.substring(1);
                    add = add.trim();
                }
                if (add != null) {
                    if (add.startsWith(",") && add.length() > 1) {
                        addObject = add.substring(1).split(",");
                        if (addObject != null && addObject.length > 0) {
                            for (int i2 = 0; i2 < addObject.length; ++i2) {
                                addObject[i2] = addObject[i2].trim();
                            }
                        } else {
                            addObject = new String[]{tmpObject};
                        }
                    }
                } else {
                    addObject = new String[]{tmpObject};
                }
            }
            String[] addFile = null;
            boolean appendFile = false;
            String tmpFile = null;
            if (this.propertiesRidefinitoFile != null) {
                tmpFile = convertEnvProperties ? this.propertiesRidefinitoFile.getValue_convertEnvProperties(key) : this.propertiesRidefinitoFile.getValue(key);
            }
            if (tmpFile != null) {
                tmpFile = tmpFile.trim();
                String add = null;
                if (tmpFile.startsWith("+")) {
                    appendFile = true;
                    add = tmpFile.substring(1);
                    add = add.trim();
                }
                if (add != null) {
                    if (add.startsWith(",") && add.length() > 1) {
                        addFile = add.substring(1).split(",");
                        if (addFile != null && addFile.length > 0) {
                            for (int i3 = 0; i3 < addFile.length; ++i3) {
                                addFile[i3] = addFile[i3].trim();
                            }
                        } else {
                            addFile = new String[]{tmpFile};
                        }
                    }
                } else {
                    addFile = new String[]{tmpFile};
                }
            }
            if ((tmp = null) == null) {
                tmp = convertEnvProperties ? this.propertiesOriginale.getValue_convertEnvProperties(key) : this.propertiesOriginale.getValue(key);
            }
            if (addObject == null && addFile == null) {
                return tmp;
            }
            if (!appendObject && !appendFile) {
                if (addObject != null) {
                    return addObject[0];
                }
                if (addFile != null) {
                    return addFile[0];
                }
                return tmp;
            }
            StringBuilder bf = new StringBuilder();
            ArrayList<String> valoriAggiunti = new ArrayList<String>();
            if (addObject != null) {
                for (i = 0; i < addObject.length; ++i) {
                    if (valoriAggiunti.contains(addObject[i])) continue;
                    if (bf.length() > 0) {
                        bf.append(",");
                    }
                    bf.append(addObject[i]);
                    valoriAggiunti.add(addObject[i]);
                }
            }
            if (addFile != null) {
                for (i = 0; i < addFile.length; ++i) {
                    if (valoriAggiunti.contains(addFile[i])) continue;
                    if (bf.length() > 0) {
                        bf.append(",");
                    }
                    bf.append(addFile[i]);
                    valoriAggiunti.add(addFile[i]);
                }
            }
            if (tmp != null && !valoriAggiunti.contains(tmp)) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                bf.append(tmp);
                valoriAggiunti.add(tmp);
            }
            return bf.toString();
        }
        catch (Exception e) {
            this.logError("Errore durante la lettura della proprieta' [" + key + "](" + convertEnvProperties + ")", e);
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private Properties readPropertiesEngine(String prefix, boolean convertEnvProperties) throws UtilsException {
        Properties tmp = null;
        try {
            String key;
            Enumeration<Object> keys;
            tmp = convertEnvProperties ? this.propertiesOriginale.readProperties_convertEnvProperties(prefix) : this.propertiesOriginale.readProperties(prefix);
            if (this.propertiesRidefinitoFile != null) {
                Properties tmp2 = null;
                tmp2 = convertEnvProperties ? this.propertiesRidefinitoFile.readProperties_convertEnvProperties(prefix) : this.propertiesRidefinitoFile.readProperties(prefix);
                if (tmp2 != null) {
                    keys = tmp2.keys();
                    while (keys.hasMoreElements()) {
                        key = (String)keys.nextElement();
                        if (tmp.containsKey(key)) {
                            tmp.remove(key);
                        }
                        tmp.put(key, tmp2.get(key));
                    }
                }
            }
            if (this.propertiesRidefinitoObject != null) {
                Properties tmp3 = null;
                tmp3 = convertEnvProperties ? this.propertiesRidefinitoObject.readProperties_convertEnvProperties(prefix) : this.propertiesRidefinitoObject.readProperties(prefix);
                if (tmp3 != null) {
                    keys = tmp3.keys();
                    while (keys.hasMoreElements()) {
                        key = (String)keys.nextElement();
                        if (tmp.containsKey(key)) {
                            tmp.remove(key);
                        }
                        tmp.put(key, tmp3.get(key));
                    }
                }
            }
        }
        catch (Exception e) {
            this.logError("Errore durante la lettura delle proprieta' con prefix [" + prefix + "](" + convertEnvProperties + ")", e);
            throw new UtilsException(e.getMessage(), e);
        }
        return tmp;
    }

    public static String readConfDirFromGovWayProperties() {
        try {
            Method rootDirMethod;
            Object rootDir;
            Class<?> cOp2Props = Class.forName("org.openspcoop2.pdd.config.OpenSPCoop2Properties");
            Method cOp2PropsMethodGetInstance = cOp2Props.getMethod("getInstance", new Class[0]);
            Object op2Props = cOp2PropsMethodGetInstance.invoke(null, new Object[0]);
            if (op2Props != null && (rootDir = (rootDirMethod = op2Props.getClass().getMethod("getRootDirectory", new Class[0])).invoke(op2Props, new Object[0])) instanceof String) {
                return (String)rootDir;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

