/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class GestoreJNDI {
    private Properties contextProperties;
    private static Semaphore semaphore = new Semaphore("GestoreJNDI");
    private static Map<String, Object> localTreeJNDI = new ConcurrentHashMap<String, Object>();
    public static final String LOCAL_TREE_JNDI_PREFIX = "local:/openspcoop2/";

    public GestoreJNDI(Properties contextP) {
        this.contextProperties = contextP;
    }

    public GestoreJNDI() {
        this.contextProperties = new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(String fullPath) throws UtilsException {
        if (fullPath != null && fullPath.startsWith(LOCAL_TREE_JNDI_PREFIX)) {
            Object o = null;
            SemaphoreLock lock = semaphore.acquireThrowRuntime("lookup");
            try {
                o = localTreeJNDI.get(fullPath);
            }
            finally {
                semaphore.release(lock, "lookup");
            }
            if (o == null) {
                throw new UtilsException("LocalResource [" + fullPath + "] not found");
            }
            return o;
        }
        InitialContext ctx = null;
        try {
            ctx = this.contextProperties != null && this.contextProperties.size() > 0 ? new InitialContext(this.contextProperties) : new InitialContext();
            Object lock = ctx.lookup(fullPath);
            return lock;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean unbind(String fullPath) {
        return this.unbind(fullPath, null, null);
    }

    public boolean unbind(String fullPath, Logger log) {
        return this.unbind(fullPath, log, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unbind(String fullPath, Logger log, Logger logConsole) {
        if (fullPath != null && fullPath.startsWith(LOCAL_TREE_JNDI_PREFIX)) {
            Object o = null;
            SemaphoreLock lock = semaphore.acquireThrowRuntime("unbind");
            try {
                o = localTreeJNDI.remove(fullPath);
            }
            finally {
                semaphore.release(lock, "unbind");
            }
            String msg = "LocalResource [" + fullPath + "] not found";
            if (log != null) {
                log.warn(msg);
            }
            if (logConsole != null) {
                logConsole.warn(msg);
            }
            return o != null;
        }
        InitialContext currentContext = null;
        try {
            currentContext = new InitialContext();
            String name = currentContext.composeName(fullPath, currentContext.getNameInNamespace());
            if (log != null) {
                String msg = "Unbind  fullname " + name;
                log.debug(msg);
            }
            try {
                currentContext.unbind(name);
            }
            catch (NameNotFoundException ignored) {
                if (log != null) {
                    log.error("Errore durante l'unbind (Ignored) [" + ignored + "]", (Throwable)ignored);
                }
                if (logConsole != null) {
                    logConsole.error("Errore durante l'unbind (Ignored) [" + ignored + "]", (Throwable)ignored);
                }
                boolean bl = false;
                try {
                    if (currentContext != null) {
                        currentContext.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (log != null) {
                log.error("Errore durante l'unbind [" + e + "]", (Throwable)e);
            }
            if (logConsole != null) {
                logConsole.error("Errore durante l'unbind [" + e + "]", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (currentContext != null) {
                    currentContext.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean bind(String fullPath, Object toBind) {
        return this.bind(fullPath, toBind, null, null);
    }

    public boolean bind(String fullPath, Object toBind, Logger log) {
        return this.bind(fullPath, toBind, log, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind(String fullPath, Object toBind, Logger log, Logger logConsole) {
        if (fullPath != null && fullPath.startsWith(LOCAL_TREE_JNDI_PREFIX)) {
            SemaphoreLock lock = semaphore.acquireThrowRuntime("bind");
            try {
                if (localTreeJNDI.containsKey(fullPath)) {
                    String msg = "LocalResource [" + fullPath + "] already exists";
                    if (log != null) {
                        log.warn(msg);
                    }
                    if (logConsole != null) {
                        logConsole.warn(msg);
                    }
                    boolean bl = false;
                    return bl;
                }
                localTreeJNDI.put(fullPath, toBind);
                boolean msg = true;
                return msg;
            }
            finally {
                semaphore.release(lock, "bind");
            }
        }
        Context currentContext = null;
        try {
            currentContext = new InitialContext();
            String name = currentContext.composeName(fullPath, currentContext.getNameInNamespace());
            String[] components = name.split("/");
            int stop = components.length - 1;
            for (int ix = 0; ix < stop; ++ix) {
                String nextPath = components[ix];
                try {
                    currentContext = (Context)currentContext.lookup(nextPath);
                    continue;
                }
                catch (NameNotFoundException ignored) {
                    currentContext = currentContext.createSubcontext(nextPath);
                }
            }
            currentContext.bind(components[stop], toBind);
            String msg = "binding [" + fullPath + "] to " + currentContext;
            if (log != null) {
                log.info(msg);
            }
            if (logConsole != null) {
                logConsole.info(msg);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (log != null) {
                log.error("Errore durante il bind [" + e + "]", (Throwable)e);
            }
            if (logConsole != null) {
                logConsole.error("Errore durante il bind [" + e + "]", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (currentContext != null) {
                    currentContext.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

