/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.rest.api;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.beans.BaseBean;

public class ApiSchemaTypeRestriction
extends BaseBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object schema;
    private String format;
    private String type;
    private Boolean arrayParameter;
    private String style;
    private String explode;
    private BigDecimal minimum;
    private BigDecimal maximum;
    private Boolean exclusiveMinimum;
    private Boolean exclusiveMaximum;
    private BigDecimal multipleOf;
    private Long minLength;
    private Long maxLength;
    private String pattern;
    private List<?> enumValues;
    private static final String TYPE = "type";
    private static final String TYPE_OBJECT = "object";
    private static final String TYPE_ARRAY = "array";
    private static final String FORMAT = "format";
    private static final String MINIMUM = "minimum";
    private static final String EXCLUSIVE_MINIMUM = "exclusiveMinimum";
    private static final String MAXIMUM = "maximum";
    private static final String EXCLUSIVE_MAXIMUM = "exclusiveMaximum";
    private static final String MULTIPLE_OF = "multipleOf";
    private static final String MIN_LENGTH = "minLength";
    private static final String MAX_LENGTH = "maxLength";
    private static final String PATTERN = "pattern";
    private static final String ENUM_VALUES = "enumValues";
    private static final String ARRAY_PARAMETER = "arrayParameter";
    private static final String STYLE = "style";
    private static final String STYLE_PATH_SIMPLE = "simple";
    private static final String STYLE_PATH_LABEL = "label";
    private static final String STYLE_PATH_MATRIX = "matrix";
    private static final String STYLE_QUERY_FORM = "form";
    private static final String STYLE_QUERY_SPACE_DELIMITED = "spaceDelimited";
    private static final String STYLE_QUERY_PIPE_DELIMITED = "pipeDelimited";
    private static final String STYLE_QUERY_DEEP_OBJECT = "deepObject";
    private static final String STYLE_HEADER_SIMPLE = "simple";
    private static final String STYLE_COOKIE_FORM = "form";
    private static final String EXPLODE = "explode";

    public static ApiSchemaTypeRestriction toApiSchemaTypeRestriction(String restriction) throws UtilsException {
        if (restriction != null) {
            restriction = restriction.trim();
        }
        if (restriction == null || "".equals(restriction) || !restriction.contains("=")) {
            throw new UtilsException("Formato non valido");
        }
        ApiSchemaTypeRestriction schema = new ApiSchemaTypeRestriction();
        String[] tmp = restriction.split(";");
        if (tmp == null || tmp.length <= 0) {
            throw new UtilsException("Formato non valido");
        }
        for (int i = 0; i < tmp.length; ++i) {
            String regola = tmp[i];
            if (regola != null) {
                regola = regola.trim();
            }
            if (regola == null || "".equals(regola) || !regola.contains("=")) {
                throw new UtilsException("Formato non valido (trovata regola '" + regola + "' senza '=')");
            }
            String[] nomeValore = regola.split("=");
            if (nomeValore == null || nomeValore.length != 2) {
                throw new UtilsException("Formato non valido (regola '" + regola + "'); atteso tipo=restrizione");
            }
            String tipo = nomeValore[0];
            if (tipo != null) {
                tipo = tipo.trim();
            }
            if (tipo == null || "".equals(tipo)) {
                throw new UtilsException("Formato non valido (regola '" + regola + "'); atteso tipo=restrizione");
            }
            String restrizione = nomeValore[1];
            if (restrizione != null) {
                restrizione = restrizione.trim();
            }
            if (restrizione == null || "".equals(restrizione)) {
                throw new UtilsException("Formato non valido (regola '" + regola + "'); atteso tipo=restrizione");
            }
            try {
                if (TYPE.equalsIgnoreCase(tipo)) {
                    schema.setType(restrizione);
                    continue;
                }
                if (FORMAT.equalsIgnoreCase(tipo)) {
                    schema.setFormat(restrizione);
                    continue;
                }
                if (MINIMUM.equalsIgnoreCase(tipo)) {
                    schema.setMinimum(new BigDecimal(restrizione));
                    continue;
                }
                if (EXCLUSIVE_MINIMUM.equalsIgnoreCase(tipo)) {
                    schema.setExclusiveMinimum(Boolean.parseBoolean(restrizione));
                    continue;
                }
                if (MAXIMUM.equalsIgnoreCase(tipo)) {
                    schema.setMaximum(new BigDecimal(restrizione));
                    continue;
                }
                if (EXCLUSIVE_MAXIMUM.equalsIgnoreCase(tipo)) {
                    schema.setExclusiveMaximum(Boolean.parseBoolean(restrizione));
                    continue;
                }
                if (MULTIPLE_OF.equalsIgnoreCase(tipo)) {
                    schema.setMultipleOf(new BigDecimal(restrizione));
                    continue;
                }
                if (MIN_LENGTH.equalsIgnoreCase(tipo)) {
                    schema.setMinLength(Long.valueOf(restrizione));
                    continue;
                }
                if (MAX_LENGTH.equalsIgnoreCase(tipo)) {
                    schema.setMaxLength(Long.valueOf(restrizione));
                    continue;
                }
                if (PATTERN.equalsIgnoreCase(tipo)) {
                    schema.setPattern(restrizione);
                    continue;
                }
                if (ENUM_VALUES.equalsIgnoreCase(tipo)) {
                    String[] values = restrizione.split(",");
                    if (values == null || values.length <= 0) continue;
                    ArrayList<String> l = new ArrayList<String>();
                    for (String v : values) {
                        if (v == null) continue;
                        v = v.trim();
                        l.add(v);
                    }
                    if (l.isEmpty()) continue;
                    schema.setEnumValues(l);
                    continue;
                }
                if (ARRAY_PARAMETER.equalsIgnoreCase(tipo)) {
                    schema.setArrayParameter(Boolean.parseBoolean(restrizione));
                    continue;
                }
                if (STYLE.equalsIgnoreCase(tipo)) {
                    schema.setStyle(restrizione);
                    continue;
                }
                if (EXPLODE.equalsIgnoreCase(tipo)) {
                    schema.setExplode(restrizione);
                    continue;
                }
                throw new UtilsException("Trovata regola '" + regola + "' con un tipo '" + tipo + "' sconosciuto");
            }
            catch (UtilsException u) {
                throw u;
            }
            catch (Exception e) {
                throw new UtilsException("Trovata regola '" + regola + "' con una restrizione non valida: " + e.getMessage());
            }
        }
        return schema;
    }

    public static String toString(ApiSchemaTypeRestriction restriction) throws UtilsException {
        return restriction.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.type != null) {
            sb.append(TYPE).append("=").append(this.type);
        }
        if (this.format != null) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(FORMAT).append("=").append(this.format);
        }
        if (this.minimum != null) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(MINIMUM).append("=").append(this.minimum);
        }
        if (this.exclusiveMinimum != null) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(EXCLUSIVE_MINIMUM).append("=").append(this.exclusiveMinimum);
        }
        if (this.maximum != null) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(MAXIMUM).append("=").append(this.maximum);
        }
        if (this.exclusiveMaximum != null) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(EXCLUSIVE_MAXIMUM).append("=").append(this.exclusiveMaximum);
        }
        if (this.multipleOf != null) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(MULTIPLE_OF).append("=").append(this.multipleOf);
        }
        if (this.minLength != null) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(MIN_LENGTH).append("=").append(this.minLength);
        }
        if (this.maxLength != null) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(MAX_LENGTH).append("=").append(this.maxLength);
        }
        if (this.pattern != null) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(PATTERN).append("=").append(this.pattern);
        }
        if (this.enumValues != null && !this.enumValues.isEmpty()) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            StringBuilder sbList = new StringBuilder();
            for (Object object : this.enumValues) {
                if (sbList.length() > 0) {
                    sbList.append(",");
                }
                sbList.append(object);
            }
            sb.append(ENUM_VALUES).append("=").append(sbList.toString());
        }
        if (this.arrayParameter != null) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(ARRAY_PARAMETER).append("=").append(this.arrayParameter);
        }
        if (this.style != null) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(STYLE).append("=").append(this.style);
        }
        if (this.explode != null) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(EXPLODE).append("=").append(this.explode);
        }
        return sb.toString();
    }

    public Object getSchema() {
        return this.schema;
    }

    public void setSchema(Object schema) {
        this.schema = schema;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isTypeObject() {
        return TYPE_OBJECT.equals(this.type);
    }

    public boolean isTypeArray() {
        return TYPE_ARRAY.equals(this.type);
    }

    public BigDecimal getMinimum() {
        return this.minimum;
    }

    public void setMinimum(BigDecimal minimum) {
        this.minimum = minimum;
    }

    public BigDecimal getMaximum() {
        return this.maximum;
    }

    public void setMaximum(BigDecimal maximum) {
        this.maximum = maximum;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public void setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public void setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
    }

    public BigDecimal getMultipleOf() {
        return this.multipleOf;
    }

    public void setMultipleOf(BigDecimal multipleOf) {
        this.multipleOf = multipleOf;
    }

    public Long getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Long minLength) {
        this.minLength = minLength;
    }

    public Long getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Long maxLength) {
        this.maxLength = maxLength;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public List<?> getEnumValues() {
        return this.enumValues;
    }

    public void setEnumValues(List<?> enumValues) {
        this.enumValues = enumValues;
    }

    public Boolean getArrayParameter() {
        return this.arrayParameter;
    }

    public boolean isArrayParameter() {
        return this.arrayParameter != null && this.arrayParameter != false;
    }

    public void setArrayParameter(Boolean arrayParameter) {
        this.arrayParameter = arrayParameter;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isStylePathSimple() {
        return "simple".equals(this.style);
    }

    public boolean isStylePathLabel() {
        return STYLE_PATH_LABEL.equals(this.style);
    }

    public boolean isStylePathMatrix() {
        return STYLE_PATH_MATRIX.equals(this.style);
    }

    public boolean isStyleQueryForm() {
        return "form".equals(this.style);
    }

    public boolean isStyleQuerySpaceDelimited() {
        return STYLE_QUERY_SPACE_DELIMITED.equals(this.style);
    }

    public boolean isStyleQueryPipeDelimited() {
        return STYLE_QUERY_PIPE_DELIMITED.equals(this.style);
    }

    public boolean isStyleQueryDeepObject() {
        return STYLE_QUERY_DEEP_OBJECT.equals(this.style);
    }

    public boolean isStyleHeaderSimple() {
        return "simple".equals(this.style);
    }

    public boolean isStyleCookieForm() {
        return "form".equals(this.style);
    }

    public String getExplode() {
        return this.explode;
    }

    public void setExplode(String explode) {
        this.explode = explode;
    }

    public boolean isExplodeEnabled() {
        return "true".equals(this.explode);
    }

    public boolean isExplodeDisabled() {
        return "false".equals(this.explode);
    }
}

