/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.rest.api;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.beans.BaseBean;
import org.openspcoop2.utils.rest.ProcessingException;
import org.openspcoop2.utils.rest.ValidatorException;
import org.openspcoop2.utils.rest.api.Api;
import org.openspcoop2.utils.rest.api.ApiOperation;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;

public class ApiUtilities
extends BaseBean {
    private static final long serialVersionUID = 1L;
    private static List<String> _static_list_characters;

    public static void validatePath(String path) throws ValidatorException {
        if (path.contains("{") || path.contains("}")) {
            if (path.contains("{") && !path.contains("}")) {
                throw new ValidatorException("Dynamic path '{' without closing '}' ");
            }
            if (!path.contains("{") && path.contains("}")) {
                throw new ValidatorException("Dynamic path '}' without opening '{' ");
            }
            int countOpen = 0;
            int countClose = 0;
            boolean open = false;
            for (int i = 0; i < path.length(); ++i) {
                String charAt = "" + path.charAt(i);
                if (charAt.equals("{")) {
                    ++countOpen;
                    open = true;
                    continue;
                }
                if (!charAt.equals("}")) continue;
                if (!open) {
                    throw new ValidatorException("Dynamic path malformed; found '}' before '{'");
                }
                open = false;
                ++countClose;
            }
            if (countOpen != countClose) {
                throw new ValidatorException("Dynamic path malformed; found " + countOpen + " '{' and " + countClose + " closing '}' ");
            }
            String specialCharStart = null;
            String specialCharEnd = null;
            for (String check : _static_list_characters) {
                if (path.contains(check)) continue;
                if (specialCharStart == null) {
                    specialCharStart = check;
                    continue;
                }
                if (specialCharEnd != null) continue;
                specialCharEnd = check;
                break;
            }
            String pathConverted = new String(path);
            while (pathConverted.contains("{")) {
                pathConverted = pathConverted.replace("{", specialCharStart);
            }
            while (pathConverted.contains("}")) {
                pathConverted = pathConverted.replace("}", specialCharStart);
            }
            try {
                URI.create(pathConverted);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                while (msg.contains(pathConverted)) {
                    msg = msg.replace(pathConverted, path);
                }
                throw new ValidatorException("Dynamic path malformed; " + msg, e);
            }
        }
        try {
            URI.create(path);
        }
        catch (Exception e) {
            throw new ValidatorException("Path malformed; " + e.getMessage(), e);
        }
    }

    public static ApiOperation findOperation(Api api, HttpRequestMethod httpMethod, String url, boolean exactlyLength) throws ProcessingException {
        String[] urlList = ApiUtilities.extractUrlList(api.getBaseURL(), url);
        return ApiUtilities.getOperation(urlList, api, httpMethod, exactlyLength);
    }

    public static String[] extractUrlList(URL baseURI, String url) throws ProcessingException {
        if (url == null) {
            throw new ProcessingException("URL non fornita");
        }
        ArrayList<String> urlList = new ArrayList<String>();
        if (baseURI != null && url.startsWith(baseURI.toString())) {
            url = url.substring(baseURI.toString().length(), url.length());
        }
        for (String s : url.split("/")) {
            if (s == null || s.equals("")) continue;
            urlList.add(s);
        }
        return urlList.toArray(new String[0]);
    }

    private static ApiOperation getOperation(List<ApiOperation> list, String[] url, HttpRequestMethod httpMethod, boolean exactlyLength) throws ProcessingException {
        int levelExactlyMatch = -1;
        int levelDinamicMatch = -1;
        ApiOperation apiOpExactlyMatch = null;
        ApiOperation apiOpDynamicMatch = null;
        for (int i = 0; i < list.size(); ++i) {
            ApiOperation apiOp = list.get(i);
            if (apiOp.getHttpMethod() != null && !apiOp.getHttpMethod().equals(httpMethod) || url.length < apiOp.sizePath()) continue;
            int counterMatch = 0;
            boolean exactlyMatch = true;
            boolean dynamicMatch = true;
            for (int j = 0; j < apiOp.sizePath(); ++j) {
                String path = null;
                try {
                    path = apiOp.getPath(j);
                }
                catch (ProcessingException processingException) {
                    // empty catch block
                }
                if (path != null && !path.equalsIgnoreCase(url[j])) {
                    exactlyMatch = false;
                    if (!apiOp.isDynamicPath(j)) {
                        dynamicMatch = false;
                        break;
                    }
                }
                ++counterMatch;
            }
            if (exactlyMatch) {
                if (counterMatch <= levelExactlyMatch) continue;
                levelExactlyMatch = counterMatch;
                apiOpExactlyMatch = apiOp;
                continue;
            }
            if (!dynamicMatch || counterMatch <= levelDinamicMatch) continue;
            levelDinamicMatch = counterMatch;
            apiOpDynamicMatch = apiOp;
        }
        if (exactlyLength) {
            if (levelExactlyMatch == url.length) {
                return apiOpExactlyMatch;
            }
            if (levelDinamicMatch == url.length) {
                return apiOpDynamicMatch;
            }
            return null;
        }
        if (levelExactlyMatch > levelDinamicMatch) {
            return apiOpExactlyMatch;
        }
        return apiOpDynamicMatch;
    }

    private static ApiOperation getOperation(String[] url, Api api, HttpRequestMethod httpMethod, boolean exactlyLength) throws ProcessingException {
        ArrayList<ApiOperation> listMethodAndPath = new ArrayList<ApiOperation>();
        ArrayList<ApiOperation> listQualsiasiMethodAndPath = new ArrayList<ApiOperation>();
        ArrayList<ApiOperation> listMethodAndQualsiasiPath = new ArrayList<ApiOperation>();
        ArrayList<ApiOperation> listQualsiasi = new ArrayList<ApiOperation>();
        for (ApiOperation apiOperation : api.getOperations()) {
            if (apiOperation.getHttpMethod() != null && apiOperation.getPath() != null) {
                listMethodAndPath.add(apiOperation);
                continue;
            }
            if (apiOperation.getPath() != null) {
                listQualsiasiMethodAndPath.add(apiOperation);
                continue;
            }
            if (apiOperation.getHttpMethod() != null) {
                if (!apiOperation.getHttpMethod().equals(httpMethod)) continue;
                listMethodAndQualsiasiPath.add(apiOperation);
                continue;
            }
            listQualsiasi.add(apiOperation);
        }
        ApiOperation op = ApiUtilities.getOperation(listMethodAndPath, url, httpMethod, exactlyLength);
        if (op == null) {
            op = ApiUtilities.getOperation(listQualsiasiMethodAndPath, url, httpMethod, exactlyLength);
        }
        if (op != null) {
            return op;
        }
        if (listMethodAndQualsiasiPath.size() > 0 && listQualsiasi.size() > 0) {
            throw new ProcessingException("Found more resource with path '*' (both httpMethod that '*')");
        }
        if (listMethodAndQualsiasiPath.size() > 0) {
            if (listMethodAndQualsiasiPath.size() > 1) {
                throw new ProcessingException("Found more resource with httpMethod '" + ((ApiOperation)listMethodAndQualsiasiPath.get(0)).getHttpMethod() + "' and path '*'");
            }
            if (listMethodAndQualsiasiPath.size() == 1) {
                return (ApiOperation)listMethodAndQualsiasiPath.get(0);
            }
        }
        if (listQualsiasi.size() > 0) {
            if (listQualsiasi.size() > 1) {
                throw new ProcessingException("Found more resource with httpMethod '*' and path '*'");
            }
            if (listQualsiasi.size() == 1) {
                return (ApiOperation)listQualsiasi.get(0);
            }
        }
        return null;
    }

    static {
        int i;
        _static_list_characters = new ArrayList<String>();
        for (i = 65; i <= 90; ++i) {
            _static_list_characters.add("" + (char)i);
        }
        for (i = 97; i <= 122; ++i) {
            _static_list_characters.add("" + (char)i);
        }
        String chars = ".-_*;:";
        char[] cs = chars.toCharArray();
        for (int i2 = 0; i2 < cs.length; ++i2) {
            _static_list_characters.add("" + cs[i2]);
        }
    }
}

