/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.util.Arrays;
import javax.crypto.spec.SecretKeySpec;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.security.AbstractCipher;
import org.openspcoop2.utils.security.CipherInfo;
import org.openspcoop2.utils.security.EncryptOpenSSLPass;
import org.openspcoop2.utils.security.OpenSSLEncryptionMode;

public class DecryptOpenSSLPass
extends AbstractCipher {
    private OpenSSLEncryptionMode mode;
    private String password;

    public static CipherInfo buildCipherInfo(byte[] cipherBytes, String password, String digestAlgoParam, OpenSSLEncryptionMode mode) throws UtilsException {
        CipherInfo cipherInfo = new CipherInfo();
        cipherInfo.setSalt(DecryptOpenSSLPass.buildSalt(cipherBytes));
        cipherInfo.setEncodedKey(EncryptOpenSSLPass.buildSecretKey(password, cipherInfo.getSalt(), digestAlgoParam, mode));
        cipherInfo.setKey(new SecretKeySpec(cipherInfo.getEncodedKey(), "AES"));
        cipherInfo.setIv(EncryptOpenSSLPass.buildIV(password, cipherInfo.getSalt(), cipherInfo.getEncodedKey(), digestAlgoParam));
        cipherInfo.setIvParameterSpec(EncryptOpenSSLPass.convertTo(cipherInfo.getIv()));
        return cipherInfo;
    }

    static byte[] buildSalt(byte[] cipherBytes) throws UtilsException {
        try {
            return Arrays.copyOfRange(cipherBytes, 8, 16);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static byte[] extractCipherBytes(byte[] data) {
        return Arrays.copyOfRange(data, 16, data.length);
    }

    public DecryptOpenSSLPass(String password) {
        this(password, null);
    }

    public DecryptOpenSSLPass(String password, OpenSSLEncryptionMode modeParam) {
        super(2);
        this.mode = modeParam != null ? modeParam : OpenSSLEncryptionMode.AES_256_CBC;
        this.password = password;
    }

    public byte[] decrypt(byte[] data) throws UtilsException {
        CipherInfo cipherInfo = DecryptOpenSSLPass.buildCipherInfo(data, this.password, null, this.mode);
        this.key = cipherInfo.getKey();
        this.ivParameterSpec = cipherInfo.getIvParameterSpec();
        byte[] cipherBytes = DecryptOpenSSLPass.extractCipherBytes(data);
        return super.process(cipherBytes, EncryptOpenSSLPass.getAlgorithm(this.mode));
    }

    public byte[] decryptBase64(byte[] data) throws UtilsException {
        return this.decrypt(Base64Utilities.decode(data));
    }

    public byte[] decryptBase64(String data) throws UtilsException {
        return this.decrypt(Base64Utilities.decode(data));
    }

    public byte[] decryptHexBinary(char[] data) throws UtilsException {
        return this.decrypt(HexBinaryUtilities.decode(data));
    }

    public byte[] decryptHexBinary(String data) throws UtilsException {
        return this.decrypt(HexBinaryUtilities.decode(data));
    }

    @Override
    public void initIV(String algorithm) throws UtilsException {
    }
}

