/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.common.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rt.security.crypto.MessageDigestUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.security.JsonUtils;

public class JwtHeaders {
    public static final String JWT_HDR_ALG = "alg";
    public static final String JWT_HDR_JKU = "jku";
    public static final String JWT_HDR_JWK = "jwk";
    public static final String JWT_HDR_KID = "kid";
    public static final String JWT_HDR_X5U = "x5u";
    public static final String JWT_HDR_X5C = "x5c";
    public static final String JWT_HDR_X5T = "x5t";
    public static final String JWT_HDR_X5t_S256 = "x5t#S256";
    public static final String JWT_HDR_TYP = "typ";
    public static final String JWT_HDR_CTY = "cty";
    public static final String JWT_HDR_CRIT = "crit";
    public static final String JWT_HDR_ENC = "enc";
    public static final String JWT_HDR_ZIP = "zip";
    private String type;
    private String contentType;
    private String kid;
    private List<String> criticalHeaders = new ArrayList<String>();
    private URI x509Url;
    private List<X509Certificate> x509c = new ArrayList<X509Certificate>();
    private boolean addX5C = false;
    boolean x509IncludeCertSha1 = false;
    boolean x509IncludeCertSha256 = false;
    private URI jwkUrl;
    private JsonWebKey jwKey;
    private Map<String, Object> jwKeyRaw;
    private HashMap<String, String> extensions = new HashMap();

    public void setType(String type) {
        this.type = type;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getKid() {
        return this.kid;
    }

    public void addCriticalHeader(String hdr) {
        this.criticalHeaders.add(hdr);
    }

    public void setX509Url(URI x509Url) {
        this.x509Url = x509Url;
    }

    public void addX509cert(X509Certificate x509c) {
        this.x509c.add(x509c);
    }

    public void setAddX5C(boolean addX5C) {
        this.addX5C = addX5C;
    }

    public boolean isX509IncludeCertSha1() {
        return this.x509IncludeCertSha1;
    }

    public boolean isX509IncludeCertSha256() {
        return this.x509IncludeCertSha256;
    }

    public void setJwkUrl(URI jwkUrl) {
        this.jwkUrl = jwkUrl;
    }

    public void setJwKey(JsonWebKey jwKey) {
        this.jwKey = jwKey;
    }

    public void setJwKey(JsonWebKeys jsonWebKeys, String alias) throws UtilsException {
        this.jwKey = JsonUtils.readKey(jsonWebKeys, alias);
    }

    public void setJwKeyRaw(Map<String, Object> jwKeyRaw) {
        this.jwKeyRaw = jwKeyRaw;
    }

    public void addExtension(String hdr, String value) {
        this.extensions.put(hdr, value);
    }

    public String getType() {
        return this.type;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public List<String> getCriticalHeaders() {
        return this.criticalHeaders;
    }

    public URI getX509Url() {
        return this.x509Url;
    }

    public boolean isAddX5C() {
        return this.addX5C;
    }

    public List<X509Certificate> getX509c() {
        return this.x509c;
    }

    public void setX509IncludeCertSha1(boolean includeCertSha1) {
        this.x509IncludeCertSha1 = includeCertSha1;
    }

    public void setX509IncludeCertSha256(boolean includeCertSha256) {
        this.x509IncludeCertSha256 = includeCertSha256;
    }

    public URI getJwkUrl() {
        return this.jwkUrl;
    }

    public JsonWebKey getJwKey() {
        return this.jwKey;
    }

    public HashMap<String, String> getExtensions() {
        return this.extensions;
    }

    public List<String> headers() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.type != null) {
            list.add(JWT_HDR_TYP);
        }
        if (this.contentType != null) {
            list.add(JWT_HDR_CTY);
        }
        if (this.kid != null) {
            list.add(JWT_HDR_KID);
        }
        if (this.criticalHeaders != null && !this.criticalHeaders.isEmpty()) {
            list.add(JWT_HDR_CRIT);
        }
        if (this.x509Url != null) {
            list.add(JWT_HDR_X5U);
        }
        if (this.x509c != null && !this.x509c.isEmpty() && this.addX5C) {
            list.add(JWT_HDR_X5C);
        }
        if (this.x509IncludeCertSha1 && this.x509c != null && !this.x509c.isEmpty()) {
            list.add(JWT_HDR_X5T);
        }
        if (this.x509IncludeCertSha256) {
            list.add(JWT_HDR_X5t_S256);
        }
        if (this.jwkUrl != null) {
            list.add(JWT_HDR_JKU);
        }
        if (this.jwKey != null || this.jwKeyRaw != null) {
            list.add(JWT_HDR_JWK);
        }
        if (this.extensions != null && !this.extensions.isEmpty()) {
            for (String hdr : this.extensions.keySet()) {
                list.add(hdr);
            }
        }
        return list;
    }

    public void fillJwsHeaders(JoseHeaders hdrs, boolean forceOverride, String algorithm) throws Exception {
        String digest;
        byte[] digestB;
        X509Certificate[] chain;
        if (this.type != null && (!hdrs.containsHeader(JWT_HDR_TYP) || forceOverride)) {
            hdrs.setHeader(JWT_HDR_TYP, (Object)this.type);
        }
        if (this.contentType != null && (!hdrs.containsHeader(JWT_HDR_CTY) || forceOverride)) {
            hdrs.setContentType(this.contentType);
        }
        if (this.kid != null && (!hdrs.containsHeader(JWT_HDR_KID) || forceOverride)) {
            hdrs.setKeyId(this.kid);
        }
        if (this.criticalHeaders != null && !this.criticalHeaders.isEmpty()) {
            List<String> headers = new ArrayList();
            if (hdrs.containsHeader(JWT_HDR_CRIT) && (headers = hdrs.getCritical()) == null) {
                headers = new ArrayList();
            }
            for (String ch : this.criticalHeaders) {
                if (headers.contains(ch)) continue;
                headers.add(ch);
            }
            hdrs.setCritical(headers);
        }
        if (this.x509Url != null && (!hdrs.containsHeader(JWT_HDR_X5U) || forceOverride)) {
            hdrs.setX509Url(this.x509Url.toString());
        }
        if (this.x509c != null && !this.x509c.isEmpty() && (!hdrs.containsHeader(JWT_HDR_X5C) || forceOverride) && this.addX5C) {
            chain = this.x509c.toArray(new X509Certificate[1]);
            hdrs.setX509Chain(KeyManagementUtils.encodeX509CertificateChain((X509Certificate[])chain));
        }
        if (this.x509IncludeCertSha1 && this.x509c != null && !this.x509c.isEmpty() && (!hdrs.containsHeader(JWT_HDR_X5T) || forceOverride)) {
            chain = this.x509c.toArray(new X509Certificate[1]);
            digestB = MessageDigestUtils.createDigest((byte[])chain[0].getEncoded(), (String)"SHA-1");
            digest = Base64UrlUtility.encode((byte[])digestB);
            hdrs.setX509Thumbprint(digest);
        }
        if (this.x509IncludeCertSha256 && (!hdrs.containsHeader(JWT_HDR_X5t_S256) || forceOverride)) {
            chain = this.x509c.toArray(new X509Certificate[1]);
            digestB = MessageDigestUtils.createDigest((byte[])chain[0].getEncoded(), (String)"SHA-256");
            digest = Base64UrlUtility.encode((byte[])digestB);
            hdrs.setX509ThumbprintSHA256(digest);
        }
        if (this.jwkUrl != null && (!hdrs.containsHeader(JWT_HDR_JKU) || forceOverride)) {
            hdrs.setJsonWebKeysUrl(this.jwkUrl.toString());
        }
        if (this.jwKeyRaw != null) {
            if (!hdrs.containsHeader(JWT_HDR_JWK) || forceOverride) {
                hdrs.setHeader(JWT_HDR_JWK, this.jwKeyRaw);
            }
        } else if (this.jwKey != null && (!hdrs.containsHeader(JWT_HDR_JWK) || forceOverride)) {
            JwkUtils.includeCertChain((JsonWebKey)this.jwKey, (JoseHeaders)hdrs, (String)algorithm);
            JwkUtils.includePublicKey((JsonWebKey)this.jwKey, (JoseHeaders)hdrs, (String)algorithm);
        }
        if (this.extensions != null && !this.extensions.isEmpty()) {
            for (String hdr : this.extensions.keySet()) {
                if (hdrs.containsHeader(hdr) && !forceOverride) continue;
                String value = this.extensions.get(hdr);
                hdrs.setHeader(hdr, (Object)value);
            }
        }
    }
}

