/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.PrivateKey;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;

public class Signature {
    private KeyStore keystore;
    private PrivateKey privateKey;

    public Signature(KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        this.keystore = keystore;
        this.privateKey = this.keystore.getPrivateKey(alias, passwordPrivateKey);
    }

    public byte[] sign(String data, String charsetName, String algorithm) throws UtilsException {
        try {
            return this.sign(data.getBytes(charsetName), algorithm);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public byte[] sign(byte[] data, String algorithm) throws UtilsException {
        try {
            java.security.Signature sig = java.security.Signature.getInstance(algorithm);
            sig.initSign(this.privateKey);
            sig.update(data);
            return sig.sign();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

