/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Collection;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;

public class VerifyPKCS7Signature {
    private KeyStore keystore;
    private Certificate certificate;
    private BouncyCastleProvider bouncyCastleProvider;
    private byte[] originalContent;

    public VerifyPKCS7Signature(KeyStore keystore) throws UtilsException {
        this.keystore = keystore;
        this.certificate = this.keystore.getCertificate();
    }

    public VerifyPKCS7Signature(KeyStore keystore, String alias) throws UtilsException {
        this.keystore = keystore;
        this.certificate = this.keystore.getCertificate(alias);
        this.bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)this.bouncyCastleProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verify(byte[] signatureData, String algorithm) throws UtilsException {
        try {
            CMSSignedData cmsSignedData = new CMSSignedData(signatureData);
            try {
                Collection signers = cmsSignedData.getSignerInfos().getSigners();
                X509CertificateHolder ch = new X509CertificateHolder(this.certificate.getEncoded());
                for (SignerInformation si : signers) {
                    if (!si.getSID().match((Object)ch) || !si.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider((Provider)this.bouncyCastleProvider).build(ch))) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                CMSTypedData signedContent = cmsSignedData.getSignedContent();
                this.originalContent = (byte[])signedContent.getContent();
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public byte[] getOriginalContent() {
        return this.originalContent;
    }
}

