/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.Signature;
import java.security.cert.Certificate;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;

public class VerifySignature {
    private KeyStore keystore;
    private Certificate certificate;

    public VerifySignature(KeyStore keystore) throws UtilsException {
        this.keystore = keystore;
        this.certificate = this.keystore.getCertificate();
    }

    public VerifySignature(KeyStore keystore, String alias) throws UtilsException {
        this.keystore = keystore;
        this.certificate = this.keystore.getCertificate(alias);
    }

    public boolean verify(String data, String charsetName, byte[] signatureData, String algorithm) throws UtilsException {
        try {
            return this.verify(data.getBytes(charsetName), signatureData, algorithm);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public boolean verify(byte[] data, byte[] signatureData, String algorithm) throws UtilsException {
        try {
            Signature sig = Signature.getInstance(algorithm);
            sig.initVerify(this.certificate);
            sig.update(data);
            return sig.verify(signatureData);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

