/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.semaphore;

import java.sql.Connection;
import java.text.SimpleDateFormat;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.semaphore.ISemaphoreEventGenerator;
import org.openspcoop2.utils.semaphore.SemaphoreEvent;
import org.slf4j.Logger;

public class SemaphoreLogEventGenerator
implements ISemaphoreEventGenerator {
    private Logger log;

    public SemaphoreLogEventGenerator(Logger log) {
        this.log = log;
    }

    @Override
    public void emitEvent(Connection con, SemaphoreEvent event) {
        SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
        String msg = "[" + event.getSeverity() + "] [" + event.getOperationType() + "] Date[" + dateformat.format(event.getDate()) + "] IdNode[" + event.getIdNode() + "] [Lock:" + event.isLock() + "]: " + event.getDetails();
        switch (event.getSeverity()) {
            case DEBUG: {
                this.log.debug(msg);
                break;
            }
            case INFO: {
                this.log.info(msg);
                break;
            }
            case WARN: {
                this.log.warn(msg);
                break;
            }
            case ERROR: {
                this.log.error(msg);
            }
        }
    }
}

