/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.serialization;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.openspcoop2.utils.serialization.Filter;
import org.openspcoop2.utils.serialization.IOException;
import org.openspcoop2.utils.serialization.ISerializer;
import org.openspcoop2.utils.serialization.PropertyFilter;
import org.openspcoop2.utils.serialization.SerializationConfig;
import org.openspcoop2.utils.serialization.Utilities;

public class JSonSerializer
implements ISerializer {
    private JsonConfig jsonConfig;

    public JSonSerializer() {
        this(new SerializationConfig());
    }

    public JSonSerializer(SerializationConfig config) {
        JSonSerializer filtroInternoOggettiFiltratiDiversiByteArray = null;
        if (config.getFilter().sizeFiltersByValue() > 0 || config.getFilter().sizeFiltersByName() > 0) {
            SerializationConfig conf = new SerializationConfig();
            conf.setFilter(new Filter());
            conf.setIdBuilder(config.getIdBuilder());
            conf.setExcludes(config.getExcludes());
            filtroInternoOggettiFiltratiDiversiByteArray = new JSonSerializer(conf);
        }
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setJsonPropertyFilter((net.sf.json.util.PropertyFilter)new PropertyFilter(config.getFilter(), config.getIdBuilder(), filtroInternoOggettiFiltratiDiversiByteArray));
        if (config.getExcludes() != null) {
            jsonConfig.setExcludes(config.getExcludes().toArray(new String[0]));
        }
        this.jsonConfig = jsonConfig;
    }

    @Override
    public String getObject(Object o) throws IOException {
        try {
            Utilities.normalizeDateObjects(o);
            if (o instanceof Enum) {
                JSONArray jsonObject = JSONArray.fromObject((Object)o, (JsonConfig)this.jsonConfig);
                return jsonObject.toString();
            }
            if (o != null && o.getClass().isArray()) {
                JSONArray jsonObject = new JSONArray();
                Object[] array = (Object[])o;
                for (int i = 0; i < array.length; ++i) {
                    Object object = array[i];
                    jsonObject.add((Object)JSONObject.fromObject((Object)object, (JsonConfig)this.jsonConfig));
                }
                return jsonObject.toString();
            }
            if (o instanceof List) {
                JSONArray jsonObject = new JSONArray();
                List list = (List)o;
                for (int i = 0; i < list.size(); ++i) {
                    Object object = list.get(i);
                    jsonObject.add((Object)JSONObject.fromObject(object, (JsonConfig)this.jsonConfig));
                }
                return jsonObject.toString();
            }
            if (o instanceof Set) {
                Set set = (Set)o;
                return this.getObject(set.toArray());
            }
            if (o instanceof Annotation || o != null && o.getClass().isAnnotation()) {
                throw new IOException("'object' is an Annotation.");
            }
            JSONObject jsonObject = JSONObject.fromObject((Object)o, (JsonConfig)this.jsonConfig);
            return jsonObject.toString();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void writeObject(Object o, OutputStream out) throws IOException {
        try {
            String s = this.getObject(o);
            out.write(s.getBytes());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void writeObject(Object o, Writer out) throws IOException {
        try {
            String s = this.getObject(o);
            out.write(s);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

