/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openspcoop2.utils.serialization.Filter;
import org.openspcoop2.utils.serialization.ISerializer;
import org.openspcoop2.utils.serialization.PropertyFilterCore;
import org.openspcoop2.utils.serialization.SerializationConfig;

public class JacksonSimpleBeanPropertyFilter
extends SimpleBeanPropertyFilter.SerializeExceptFilter {
    private static final long serialVersionUID = 1L;
    private PropertyFilterCore core;
    private List<String> excludes;
    private List<Class<?>> excludesByClass;

    public JacksonSimpleBeanPropertyFilter(SerializationConfig config, ISerializer serializer) {
        super(JacksonSimpleBeanPropertyFilter.getHashSet(config.getFilter(), config.getExcludes()));
        this.core = new PropertyFilterCore(config.getFilter(), config.getIdBuilder(), serializer);
        this.excludes = config.getExcludes();
        this.excludesByClass = config.getFilter() != null && config.getFilter().getFilterByValue() != null ? config.getFilter().getFilterByValue() : new ArrayList();
    }

    private static Set<String> getHashSet(Filter filter, List<String> excludes) {
        HashSet<String> set = new HashSet<String>();
        if (filter != null && filter.sizeFiltersByName() > 0) {
            set.addAll(filter.getFilterByName());
        }
        if (excludes != null && excludes.size() > 0) {
            set.addAll(excludes);
        }
        return set;
    }

    public void serializeAsField(Object pojo, JsonGenerator gen, SerializerProvider provider, PropertyWriter writer) throws Exception {
        if (this.include(writer) && !this.excludesByClass.contains(writer.getType().getRawClass())) {
            writer.serializeAsField(pojo, gen, provider);
        } else {
            if (gen.canOmitFields()) {
                writer.serializeAsOmittedField(pojo, gen, provider);
            }
            if (this.excludes == null || !this.excludes.contains(writer.getName())) {
                this.core.applicaFiltro(pojo, writer.getName(), pojo, writer.getType().getRawClass());
            }
        }
    }
}

