/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.serialization;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.openspcoop2.utils.serialization.Filter;
import org.openspcoop2.utils.serialization.IOException;
import org.openspcoop2.utils.serialization.ISerializer;
import org.openspcoop2.utils.serialization.PropertyFilter;
import org.openspcoop2.utils.serialization.SerializationConfig;
import org.openspcoop2.utils.serialization.Utilities;

public class XMLSerializer
implements ISerializer {
    private JsonConfig jsonConfig;
    private net.sf.json.xml.XMLSerializer xmlSerializer;

    public XMLSerializer() {
        this(new SerializationConfig());
    }

    public XMLSerializer(SerializationConfig config) {
        XMLSerializer filtroInternoOggettiFiltratiDiversiByteArray = null;
        if (config.getFilter() != null && (config.getFilter().sizeFiltersByValue() > 0 || config.getFilter().sizeFiltersByName() > 0)) {
            SerializationConfig conf = new SerializationConfig();
            conf.setFilter(new Filter());
            conf.setExcludes(config.getExcludes());
            conf.setIdBuilder(config.getIdBuilder());
            filtroInternoOggettiFiltratiDiversiByteArray = new XMLSerializer(conf);
        }
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setJsonPropertyFilter((net.sf.json.util.PropertyFilter)new PropertyFilter(config.getFilter(), config.getIdBuilder(), filtroInternoOggettiFiltratiDiversiByteArray));
        if (config.getExcludes() != null) {
            jsonConfig.setExcludes(config.getExcludes().toArray(new String[0]));
        }
        this.jsonConfig = jsonConfig;
        this.xmlSerializer = new net.sf.json.xml.XMLSerializer();
    }

    @Override
    public String getObject(Object o) throws IOException {
        try {
            Utilities.normalizeDateObjects(o);
            if (o instanceof Enum) {
                JSONArray jsonArray = JSONArray.fromObject((Object)o, (JsonConfig)this.jsonConfig);
                return this.xmlSerializer.write((JSON)jsonArray);
            }
            if (o != null && o.getClass().isArray()) {
                JSONArray jsonArray = new JSONArray();
                Object[] array = (Object[])o;
                for (int i = 0; i < array.length; ++i) {
                    Object object = array[i];
                    jsonArray.add((Object)JSONObject.fromObject((Object)object, (JsonConfig)this.jsonConfig));
                }
                return this.xmlSerializer.write((JSON)jsonArray);
            }
            if (o instanceof List) {
                JSONArray jsonArray = new JSONArray();
                List list = (List)o;
                for (int i = 0; i < list.size(); ++i) {
                    Object object = list.get(i);
                    jsonArray.add((Object)JSONObject.fromObject(object, (JsonConfig)this.jsonConfig));
                }
                return this.xmlSerializer.write((JSON)jsonArray);
            }
            if (o instanceof Set) {
                Set set = (Set)o;
                return this.getObject(set.toArray());
            }
            if (o instanceof Annotation || o != null && o.getClass().isAnnotation()) {
                throw new IOException("'object' is an Annotation.");
            }
            JSONObject jsonObject = JSONObject.fromObject((Object)o, (JsonConfig)this.jsonConfig);
            return this.xmlSerializer.write((JSON)jsonObject);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void writeObject(Object o, OutputStream out) throws IOException {
        try {
            String s = this.getObject(o);
            out.write(s.getBytes());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void writeObject(Object o, Writer out) throws IOException {
        try {
            String s = this.getObject(o);
            out.write(s);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

