/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.context;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.service.context.ContextConfig;
import org.openspcoop2.utils.service.context.ContextInInterceptor;
import org.openspcoop2.utils.service.context.ContextThreadLocal;
import org.openspcoop2.utils.service.context.IContext;

public class ContextOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private ContextConfig contextConfig = null;

    public ContextOutInterceptor() {
        super("setup-ending");
    }

    public ContextConfig getContextConfig() {
        return this.contextConfig;
    }

    public void setContextConfig(ContextConfig contextConfig) {
        this.contextConfig = contextConfig;
    }

    public void handleMessage(Message message) throws Fault {
        try {
            IContext context = ContextThreadLocal.get();
            if (this.contextConfig.isEmitTransaction()) {
                context.getApplicationLogger().log();
            }
            ContextThreadLocal.unset();
        }
        catch (Throwable e) {
            LoggerWrapperFactory.getLogger(ContextInInterceptor.class).error(e.getMessage(), e);
            throw new Fault(e);
        }
    }
}

