/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sonde.impl;

import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.sonde.ParametriSonda;
import org.openspcoop2.utils.sonde.Sonda;
import org.openspcoop2.utils.sonde.SondaException;

public class SondaBatch
extends Sonda {
    public SondaBatch(ParametriSonda param) {
        super(param);
        HashSet<String> reserved = new HashSet<String>();
        reserved.add("data_ultimo_batch");
        reserved.add("esito_batch");
        reserved.add("interazioni_fallite");
        reserved.add("descrizione_errore");
        this.getParam().setReserved(reserved);
    }

    @Override
    public Sonda.StatoSonda getStatoSonda() {
        Date now = new Date();
        Date data_warn = new Date(now.getTime() - super.getParam().getSogliaWarn());
        Date data_err = new Date(now.getTime() - super.getParam().getSogliaError());
        Sonda.StatoSonda statoSonda = new Sonda.StatoSonda();
        boolean esito_batch = false;
        if (super.getParam().getDatiCheck().containsKey("esito_batch")) {
            String esitoBatchString = super.getParam().getDatiCheck().getProperty("esito_batch");
            try {
                esito_batch = Boolean.parseBoolean(esitoBatchString);
            }
            catch (NumberFormatException e) {
                e.printStackTrace(System.err);
                System.err.println("Errore durante il parsing del parametro esito_batch: " + super.getParam().getDatiCheck().getProperty("esito_batch") + ". Elimino il valore");
                super.getParam().getDatiCheck().remove("esito_batch");
            }
        } else {
            System.err.println("Parametro esito_batch non trovato");
        }
        Long dataUltimoBatchLong = null;
        if (super.getParam().getDatiCheck().containsKey("data_ultimo_batch")) {
            try {
                dataUltimoBatchLong = Long.valueOf(super.getParam().getDatiCheck().getProperty("data_ultimo_batch"));
            }
            catch (NumberFormatException e) {
                e.printStackTrace(System.err);
                System.err.println("Errore durante il parsing del parametro data_ultimo_batch: " + super.getParam().getDatiCheck().getProperty("data_ultimo_batch") + ". Elimino il valore");
                super.getParam().getDatiCheck().remove("data_ultimo_batch");
            }
        } else {
            System.err.println("Parametro data_ultimo_batch non trovato");
        }
        if (dataUltimoBatchLong == null) {
            statoSonda.setStato(2);
            statoSonda.setDescrizione("Il batch " + super.getParam().getNome() + " risulta non essere eseguito.");
            return statoSonda;
        }
        Date data_ultimo_batch = new Date(dataUltimoBatchLong);
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.sss");
        String dataUltimoBatchString = format.format(data_ultimo_batch);
        if (esito_batch) {
            if (data_ultimo_batch.before(data_err)) {
                String errorDateFormatted = format.format(data_err);
                statoSonda.setStato(2);
                statoSonda.setDescrizione("Il batch " + super.getParam().getNome() + " risulta non essere eseguito dal " + dataUltimoBatchString + ". Data di error (" + errorDateFormatted + ") superata.");
            } else if (data_ultimo_batch.before(data_warn)) {
                String warnDateFormatted = format.format(data_warn);
                statoSonda.setStato(1);
                statoSonda.setDescrizione("Il batch " + super.getParam().getNome() + " risulta non essere eseguito dal " + dataUltimoBatchString + ". Data di warn (" + warnDateFormatted + ") superata.");
            } else {
                statoSonda.setStato(0);
                statoSonda.setDescrizione("Batch " + super.getParam().getNome() + " eseguito con successo il " + dataUltimoBatchString + ".");
            }
            return statoSonda;
        }
        Integer interazioniFallite = -1;
        if (super.getParam().getDatiCheck().containsKey("interazioni_fallite")) {
            try {
                interazioniFallite = Integer.parseInt(super.getParam().getDatiCheck().getProperty("interazioni_fallite"));
            }
            catch (NumberFormatException e) {
                e.printStackTrace(System.err);
                System.err.println("Errore durante il parsing del parametro interazioni_fallite: " + super.getParam().getDatiCheck().getProperty("interazioni_fallite") + ". Elimino il valore");
                super.getParam().getDatiCheck().remove("interazioni_fallite");
            }
        } else {
            System.err.println("Parametro interazioni_fallite non trovato");
        }
        statoSonda.setStato(2);
        String descr = null;
        if (super.getParam().getDatiCheck().containsKey("descrizione_errore")) {
            descr = new String(Base64Utilities.decode((String)super.getParam().getDatiCheck().get("descrizione_errore")));
        }
        statoSonda.setDescrizione("Il batch " + super.getParam().getNome() + " risulta fallire dal " + dataUltimoBatchString + " (fallite " + interazioniFallite + " iterazioni). Descrizione dell'ultimo errore:" + descr);
        return statoSonda;
    }

    public Sonda.StatoSonda aggiornaStatoSonda(boolean esito_batch, Date data_ultimo_batch, String descrizioneErrore, Connection connection, TipiDatabase tipoDatabase) throws SondaException {
        return this.aggiornaStatoSonda(esito_batch, null, data_ultimo_batch, descrizioneErrore, connection, tipoDatabase);
    }

    public Sonda.StatoSonda aggiornaStatoSonda(boolean esito_batch, Properties params, Date data_ultimo_batch, String descrizioneErrore, Connection connection, TipiDatabase tipoDatabase) throws SondaException {
        super.getParam().putAllCheck(params);
        super.getParam().getDatiCheck().put("data_ultimo_batch", "" + data_ultimo_batch.getTime());
        super.getParam().getDatiCheck().put("esito_batch", String.valueOf(esito_batch));
        if (!esito_batch) {
            if (super.getParam().getDatiCheck().containsKey("interazioni_fallite")) {
                Integer interazioniFallite = Integer.parseInt(super.getParam().getDatiCheck().getProperty("interazioni_fallite"));
                super.getParam().getDatiCheck().put("interazioni_fallite", "" + (interazioniFallite + 1));
            } else {
                super.getParam().getDatiCheck().put("interazioni_fallite", "1");
            }
            if (descrizioneErrore != null) {
                super.getParam().getDatiCheck().put("descrizione_errore", Base64Utilities.encodeAsString(descrizioneErrore.getBytes()));
            }
        } else {
            if (super.getParam().getDatiCheck().containsKey("descrizione_errore")) {
                super.getParam().getDatiCheck().remove("descrizione_errore");
            }
            if (super.getParam().getDatiCheck().containsKey("interazioni_fallite")) {
                super.getParam().getDatiCheck().remove("interazioni_fallite");
            }
        }
        return this.updateSonda(connection, tipoDatabase);
    }
}

