/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sql;

import java.util.Date;
import java.util.Iterator;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.sql.DayFormatEnum;
import org.openspcoop2.utils.sql.EscapeSQLConfiguration;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLQueryObjectCore;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class MySQLQueryObject
extends SQLQueryObjectCore {
    public MySQLQueryObject(TipiDatabase tipoDatabase) {
        super(tipoDatabase);
    }

    @Override
    public String getSelectTimestampConstantField(Date date) throws SQLQueryObjectException {
        DateTimeFormatterWrapper sqlDateformat = DateUtils.getDefaultDateTimeFormatter("yyyy-MM-dd HH:mm:ss.SSS");
        return "STR_TO_DATE('" + sqlDateformat.format(date) + "', '%Y-%m-%d %H:%i:%s.%f')";
    }

    @Override
    public String getUnixTimestampConversion(String column) {
        return "(UNIX_TIMESTAMP(" + column + ")*1000)";
    }

    @Override
    public String getDiffUnixTimestamp(String columnMax, String columnMin) {
        return "( " + this.getUnixTimestampConversion(columnMax) + " - " + this.getUnixTimestampConversion(columnMin) + " )";
    }

    @Override
    public ISQLQueryObject addSelectAvgTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "avg(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this.engineAddSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMaxTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "max(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this.engineAddSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMinTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "min(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this.engineAddSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectSumTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "sum(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this.engineAddSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addFromTable(ISQLQueryObject subSelect) throws SQLQueryObjectException {
        StringBuilder bf = new StringBuilder();
        bf.append(" ( ");
        bf.append(subSelect.createSQLQuery());
        bf.append(" ) as subquery" + this.getSerial() + " ");
        this.addFromTable(bf.toString());
        return this;
    }

    @Override
    protected EscapeSQLConfiguration getEscapeSQLConfiguration() {
        EscapeSQLConfiguration config = new EscapeSQLConfiguration();
        config.addCharacter('_');
        config.addCharacter('%');
        config.addCharacter('|');
        config.setUseEscapeClausole(true);
        config.setEscape('|');
        config.addCharacterWithOtherEscapeChar('\\', '\\');
        config.addCharacterWithOtherEscapeChar('\'', '\'');
        return config;
    }

    private SQLQueryObjectException newSQLQueryObjectExceptionDayFormatEnum(DayFormatEnum dayFormat) {
        return new SQLQueryObjectException("DayFormatEnum '" + dayFormat + "' unknown");
    }

    @Override
    public String getExtractDayFormatFromTimestampFieldPrefix(DayFormatEnum dayFormat) throws SQLQueryObjectException {
        if (dayFormat == null) {
            throw new SQLQueryObjectException("dayFormat undefined");
        }
        switch (dayFormat) {
            case FULL_DAY_NAME: {
                return "DAYNAME(";
            }
            case SHORT_DAY_NAME: {
                return "DATE_FORMAT(";
            }
            case DAY_OF_YEAR: {
                return "DAYOFYEAR(";
            }
            case DAY_OF_WEEK: {
                return "DAYOFWEEK(";
            }
        }
        throw this.newSQLQueryObjectExceptionDayFormatEnum(dayFormat);
    }

    @Override
    public String getExtractDayFormatFromTimestampFieldSuffix(DayFormatEnum dayFormat) throws SQLQueryObjectException {
        if (dayFormat == null) {
            throw new SQLQueryObjectException("dayFormat undefined");
        }
        switch (dayFormat) {
            case SHORT_DAY_NAME: {
                return ", '%a')";
            }
            case FULL_DAY_NAME: 
            case DAY_OF_YEAR: 
            case DAY_OF_WEEK: {
                return ")";
            }
        }
        throw this.newSQLQueryObjectExceptionDayFormatEnum(dayFormat);
    }

    @Override
    public String createSQLQuery() throws SQLQueryObjectException {
        return this.createSQLQuery(false);
    }

    private String createSQLQuery(boolean union) throws SQLQueryObjectException {
        this.precheckBuildQuery();
        StringBuilder bf = new StringBuilder();
        bf.append("SELECT ");
        Iterator itForceIndex = this.forceIndexTableNames.iterator();
        while (itForceIndex.hasNext()) {
            bf.append(" " + (String)itForceIndex.next() + " ");
        }
        if (this.isSelectDistinct()) {
            bf.append(" DISTINCT ");
        }
        if (this.fields.isEmpty()) {
            bf.append("*");
        } else {
            Iterator it = this.fields.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append((String)it.next());
            }
        }
        bf.append(this.getSQL(false, false, false, union));
        return bf.toString();
    }

    @Override
    public String createSQLDeleteEngine() throws SQLQueryObjectException {
        StringBuilder bf = new StringBuilder();
        bf.append("DELETE ");
        bf.append(this.getSQL(true, false, false, false));
        return bf.toString();
    }

    private String getSQL(boolean delete, boolean update, boolean conditions, boolean union) throws SQLQueryObjectException {
        boolean first;
        Iterator<Object> it;
        StringBuilder bf = new StringBuilder();
        if (this.selectForUpdate) {
            this.checkSelectForUpdate(update, delete, union);
        }
        if (!update && !conditions) {
            bf.append(" FROM ");
            if (this.tables.isEmpty()) {
                throw new SQLQueryObjectException("Tabella di ricerca (... FROM Table ...) non definita");
            }
            if (delete && this.tables.size() > 2) {
                throw new SQLQueryObjectException("Non e' possibile effettuare una delete con piu' di una tabella alla volta");
            }
            it = this.tables.iterator();
            first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append((String)it.next());
            }
        }
        if (!this.conditions.isEmpty()) {
            if (!conditions) {
                bf.append(" WHERE ");
            }
            if (this.notBeforeConditions) {
                bf.append("NOT (");
            }
            for (int i = 0; i < this.conditions.size(); ++i) {
                if (i > 0) {
                    if (this.andLogicOperator) {
                        bf.append(" AND ");
                    } else {
                        bf.append(" OR ");
                    }
                }
                bf.append((String)this.conditions.get(i));
            }
            if (this.notBeforeConditions) {
                bf.append(")");
            }
        }
        if (!(this.getGroupByConditions().isEmpty() || delete || update || conditions)) {
            bf.append(" GROUP BY ");
            it = this.getGroupByConditions().iterator();
            first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append((String)it.next());
            }
        }
        if (!(this.orderBy.isEmpty() || delete || update || conditions)) {
            bf.append(" ORDER BY ");
            it = this.orderBy.iterator();
            first = true;
            while (it.hasNext()) {
                String column = (String)it.next();
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append(column);
                boolean sortTypeAsc = this.sortTypeAsc;
                if (this.orderBySortType.containsKey(column)) {
                    sortTypeAsc = (Boolean)this.orderBySortType.get(column);
                }
                if (sortTypeAsc) {
                    bf.append(" ASC ");
                    continue;
                }
                bf.append(" DESC ");
            }
        }
        if (this.offset >= 0 && this.orderBy.isEmpty()) {
            throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
        }
        if (!(this.limit <= 0 || delete || update || conditions)) {
            bf.append(" LIMIT ");
            bf.append(this.limit);
        }
        if (!(this.offset < 0 || delete || update || conditions)) {
            if (this.limit <= 0) {
                bf.append(" LIMIT ");
                bf.append(Integer.MAX_VALUE);
            }
            bf.append(" OFFSET ");
            bf.append(this.offset);
        }
        if (!conditions && this.selectForUpdate) {
            bf.append(" FOR UPDATE ");
        }
        return bf.toString();
    }

    @Override
    public String createSQLUnion(boolean unionAll, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        boolean first;
        this.checkUnionField(false, sqlQueryObject);
        if (this.selectForUpdate) {
            this.checkSelectForUpdate(false, false, true);
        }
        StringBuilder bf = new StringBuilder();
        bf.append("SELECT ");
        Iterator itForceIndex = this.forceIndexTableNames.iterator();
        while (itForceIndex.hasNext()) {
            bf.append(" " + (String)itForceIndex.next() + " ");
        }
        if (this.fields.isEmpty()) {
            bf.append("*");
        } else {
            Iterator it = this.fields.iterator();
            first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append((String)it.next());
            }
        }
        bf.append(" FROM ( ");
        for (int i = 0; i < sqlQueryObject.length; ++i) {
            if (((MySQLQueryObject)sqlQueryObject[i]).selectForUpdate) {
                try {
                    ((MySQLQueryObject)sqlQueryObject[i]).checkSelectForUpdate(false, false, true);
                }
                catch (Exception e) {
                    throw new SQLQueryObjectException("Parametro SqlQueryObject[" + i + "] non valido: " + e.getMessage());
                }
            }
            if (i > 0) {
                bf.append(" UNION ");
                if (unionAll) {
                    bf.append(" ALL ");
                }
            }
            bf.append("( ");
            bf.append(((MySQLQueryObject)sqlQueryObject[i]).createSQLQuery(true));
            bf.append(") ");
        }
        bf.append(" ) as subquery" + this.getSerial() + " ");
        if (!this.getGroupByConditions().isEmpty()) {
            bf.append(" GROUP BY ");
            Iterator<String> it = this.getGroupByConditions().iterator();
            first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append(it.next());
            }
        }
        if (!this.orderBy.isEmpty()) {
            bf.append(" ORDER BY ");
            Iterator it = this.orderBy.iterator();
            first = true;
            while (it.hasNext()) {
                String column = (String)it.next();
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append(column);
                boolean sortTypeAsc = this.sortTypeAsc;
                if (this.orderBySortType.containsKey(column)) {
                    sortTypeAsc = (Boolean)this.orderBySortType.get(column);
                }
                if (sortTypeAsc) {
                    bf.append(" ASC ");
                    continue;
                }
                bf.append(" DESC ");
            }
        }
        if (this.offset >= 0 && this.orderBy.isEmpty()) {
            throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
        }
        if (this.limit > 0) {
            bf.append(" LIMIT ");
            bf.append(this.limit);
        }
        if (this.offset >= 0) {
            if (this.limit <= 0) {
                bf.append(" LIMIT ");
                bf.append(Integer.MAX_VALUE);
            }
            bf.append(" OFFSET ");
            bf.append(this.offset);
        }
        return bf.toString();
    }

    @Override
    public String createSQLUnionCount(boolean unionAll, String aliasCount, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        this.checkUnionField(true, sqlQueryObject);
        if (aliasCount == null) {
            throw new SQLQueryObjectException("Alias per il count non definito");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("SELECT count(*) " + this.getDefaultAliasFieldKeyword() + " ");
        bf.append(aliasCount);
        bf.append(" FROM ( ");
        bf.append(this.createSQLUnion(unionAll, sqlQueryObject));
        bf.append(" ) as subquery" + this.getSerial() + " ");
        return bf.toString();
    }

    @Override
    public String createSQLUpdateEngine() throws SQLQueryObjectException {
        StringBuilder bf = new StringBuilder();
        bf.append("UPDATE ");
        bf.append(this.updateTable);
        bf.append(" SET ");
        for (int i = 0; i < this.updateFieldsName.size(); ++i) {
            if (i > 0) {
                bf.append(" , ");
            }
            bf.append((String)this.updateFieldsName.get(i));
            bf.append(" = ");
            bf.append((String)this.updateFieldsValue.get(i));
        }
        bf.append(this.getSQL(false, true, false, false));
        return bf.toString();
    }

    @Override
    public String createSQLConditionsEngine() throws SQLQueryObjectException {
        StringBuilder bf = new StringBuilder();
        bf.append(this.getSQL(false, false, true, false));
        return bf.toString();
    }
}

