/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.transport.http.CookiePathResponseWrapper;
import org.slf4j.Logger;

public class CookiePathFilter
implements Filter {
    private boolean enabled = true;
    private boolean debug = false;
    private Logger log;
    private static final String CONFIG_ENABLED = "cookiePath.enabled";
    private static final String CONFIG_LOG = "cookiePath.logCategory";
    private static final String CONFIG_DEBUG = "cookiePath.debug";

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig != null) {
            String tmp = filterConfig.getInitParameter(CONFIG_ENABLED);
            if (tmp != null && "false".equalsIgnoreCase(tmp.trim())) {
                this.enabled = false;
            }
            this.log = (tmp = filterConfig.getInitParameter(CONFIG_LOG)) != null ? LoggerWrapperFactory.getLogger(tmp.trim()) : LoggerWrapperFactory.getLogger(CookiePathFilter.class);
            tmp = filterConfig.getInitParameter(CONFIG_DEBUG);
            if (tmp != null && "true".equalsIgnoreCase(tmp.trim())) {
                this.debug = true;
            }
        }
    }

    private void log(String msg) {
        if (this.debug && this.log != null) {
            this.log.debug(msg);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.enabled) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String contextPath = httpRequest.getContextPath();
        if (contextPath == null || contextPath.isEmpty()) {
            contextPath = "/";
        }
        this.log("[CookiePathFilter] doFilter - URI: " + httpRequest.getRequestURI() + ", contextPath: " + contextPath);
        chain.doFilter(request, (ServletResponse)new CookiePathResponseWrapper(httpResponse, contextPath, this.log, this.debug));
    }

    public void destroy() {
    }
}

