/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.io.PrintWriter;
import org.openspcoop2.utils.transport.http.CookiePathResponseWrapper;

class CookiePathPrintWriter
extends PrintWriter {
    private final CookiePathResponseWrapper responseWrapper;
    private boolean firstWrite = true;

    public CookiePathPrintWriter(PrintWriter wrapped, CookiePathResponseWrapper responseWrapper) {
        super(wrapped);
        this.responseWrapper = responseWrapper;
    }

    private void checkFirstWrite() {
        if (this.firstWrite) {
            this.firstWrite = false;
            this.responseWrapper.log("[CookiePathFilter] PrintWriter - prima scrittura, processo cookie");
            this.responseWrapper.triggerCookieProcessing();
        }
    }

    @Override
    public void write(int c) {
        this.checkFirstWrite();
        super.write(c);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        this.checkFirstWrite();
        super.write(buf, off, len);
    }

    @Override
    public void write(String s, int off, int len) {
        this.checkFirstWrite();
        super.write(s, off, len);
    }

    @Override
    public void flush() {
        this.checkFirstWrite();
        super.flush();
    }
}

