/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.openspcoop2.utils.transport.http.CookiePathPrintWriter;
import org.openspcoop2.utils.transport.http.CookiePathServletOutputStream;
import org.slf4j.Logger;

class CookiePathResponseWrapper
extends HttpServletResponseWrapper {
    private static final String PATH_ATTR = "Path=";
    private static final Pattern PATH_PATTERN = Pattern.compile("(;\\s*Path=)([^;\\s]*)", 2);
    private final HttpServletResponse originalResponse;
    private final String contextPath;
    private final Logger log;
    private final boolean debug;
    private boolean cookiesProcessed = false;

    public CookiePathResponseWrapper(HttpServletResponse response, String contextPath, Logger log, boolean debug) {
        super(response);
        this.originalResponse = response;
        this.contextPath = contextPath;
        this.log = log;
        this.debug = debug;
    }

    void log(String msg) {
        if (this.debug && this.log != null) {
            this.log.debug(msg);
        }
    }

    public void addCookie(Cookie cookie) {
        this.log("[CookiePathFilter] addCookie chiamato - cookie: " + (cookie != null ? cookie.getName() : "null"));
        if (cookie != null) {
            String currentPath = cookie.getPath();
            this.log("[CookiePathFilter] addCookie - nome: " + cookie.getName() + ", path originale: '" + currentPath + "', contextPath: '" + this.contextPath + "'");
            if (currentPath == null || currentPath.isEmpty()) {
                cookie.setPath(this.contextPath);
                this.log("[CookiePathFilter] addCookie - path impostato a: '" + this.contextPath + "'");
            } else if (currentPath.startsWith(this.contextPath) && currentPath.length() > this.contextPath.length()) {
                this.log("[CookiePathFilter] addCookie - path normalizzato da '" + currentPath + "' a '" + this.contextPath + "'");
                cookie.setPath(this.contextPath);
            } else {
                this.log("[CookiePathFilter] addCookie - path non modificato: '" + currentPath + "'");
            }
        }
        super.addCookie(cookie);
    }

    public void setHeader(String name, String value) {
        if ("Set-Cookie".equalsIgnoreCase(name) && value != null) {
            String originalValue = value;
            value = this.normalizeCookiePath(value);
            String msg = "[CookiePathFilter] setHeader Set-Cookie - originale: '" + originalValue + "' -> normalizzato : '" + value + "'";
            this.log(msg);
        }
        super.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        if ("Set-Cookie".equalsIgnoreCase(name) && value != null) {
            String originalValue = value;
            value = this.normalizeCookiePath(value);
            this.log("[CookiePathFilter] addHeader Set-Cookie - originale: '" + originalValue + "' -> normalizzato: '" + value + "'");
        }
        super.addHeader(name, value);
    }

    private synchronized void processSetCookieHeaders() {
        if (this.cookiesProcessed) {
            return;
        }
        this.cookiesProcessed = true;
        try {
            Collection cookieHeaders = this.originalResponse.getHeaders("Set-Cookie");
            if (cookieHeaders == null || cookieHeaders.isEmpty()) {
                this.log("[CookiePathFilter] processSetCookieHeaders - nessun Set-Cookie trovato");
                return;
            }
            this.log("[CookiePathFilter] processSetCookieHeaders - trovati " + cookieHeaders.size() + " header Set-Cookie");
            boolean first = true;
            for (String cookieHeader : cookieHeaders) {
                if (cookieHeader == null || cookieHeader.isEmpty()) continue;
                String normalizedHeader = this.normalizeCookiePath(cookieHeader);
                this.log("[CookiePathFilter] processSetCookieHeaders - originale: '" + cookieHeader + "' -> normalizzato: '" + normalizedHeader + "'");
                if (first) {
                    this.originalResponse.setHeader("Set-Cookie", normalizedHeader);
                    first = false;
                    continue;
                }
                this.originalResponse.addHeader("Set-Cookie", normalizedHeader);
            }
        }
        catch (Exception e) {
            this.log("[CookiePathFilter] processSetCookieHeaders - errore: " + e.getMessage());
        }
    }

    public void flushBuffer() throws IOException {
        this.log("[CookiePathFilter] flushBuffer chiamato");
        this.processSetCookieHeaders();
        super.flushBuffer();
    }

    public void sendError(int sc) throws IOException {
        String msg = "[CookiePathFilter] sendError(" + sc + ") chiamato ";
        this.log(msg);
        this.processSetCookieHeaders();
        super.sendError(sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.log("[CookiePathFilter] sendError(" + sc + ", " + msg + ") chiamato");
        this.processSetCookieHeaders();
        super.sendError(sc, msg);
    }

    public void sendRedirect(String location) throws IOException {
        this.log("[CookiePathFilter] sendRedirect(" + location + ") chiamato");
        this.processSetCookieHeaders();
        super.sendRedirect(location);
    }

    public PrintWriter getWriter() throws IOException {
        this.log("[CookiePathFilter] getWriter chiamato");
        return new CookiePathPrintWriter(super.getWriter(), this);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.log("[CookiePathFilter] getOutputStream chiamato");
        return new CookiePathServletOutputStream(super.getOutputStream(), this);
    }

    void triggerCookieProcessing() {
        this.processSetCookieHeaders();
    }

    private String normalizeCookiePath(String cookieHeader) {
        Matcher matcher = PATH_PATTERN.matcher(cookieHeader);
        if (matcher.find()) {
            boolean isMoreRestrictive;
            String currentPath = matcher.group(2);
            String unquotedPath = this.unquote(currentPath);
            this.log("[CookiePathFilter] normalizeCookiePath - path: '" + currentPath + "' -> unquoted: '" + unquotedPath + "'");
            boolean hasQuotes = currentPath != null && !currentPath.equals(unquotedPath);
            boolean bl = isMoreRestrictive = unquotedPath != null && unquotedPath.startsWith(this.contextPath) && unquotedPath.length() > this.contextPath.length();
            if (hasQuotes || isMoreRestrictive) {
                String newHeader = matcher.replaceFirst("$1" + Matcher.quoteReplacement(this.contextPath));
                this.log("[CookiePathFilter] normalizeCookiePath - PATH NORMALIZZATO da '" + currentPath + "' a '" + this.contextPath + "' (hasQuotes=" + hasQuotes + ", isMoreRestrictive=" + isMoreRestrictive + ")");
                return newHeader;
            }
        } else {
            String newHeader = cookieHeader + "; Path=" + this.contextPath;
            this.log("[CookiePathFilter] normalizeCookiePath - NESSUN PATH trovato, aggiunto: '" + this.contextPath + "'");
            return newHeader;
        }
        return cookieHeader;
    }

    private String unquote(String value) {
        if (value != null && value.length() >= 2 && value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }
}

