/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.openspcoop2.utils.transport.http.CookiePathResponseWrapper;

class CookiePathServletOutputStream
extends ServletOutputStream {
    private final ServletOutputStream wrapped;
    private final CookiePathResponseWrapper responseWrapper;
    private boolean firstWrite = true;

    public CookiePathServletOutputStream(ServletOutputStream wrapped, CookiePathResponseWrapper responseWrapper) {
        this.wrapped = wrapped;
        this.responseWrapper = responseWrapper;
    }

    private void checkFirstWrite() {
        if (this.firstWrite) {
            this.firstWrite = false;
            this.responseWrapper.log("[CookiePathFilter] OutputStream - prima scrittura, processo cookie");
            this.responseWrapper.triggerCookieProcessing();
        }
    }

    public void write(int b) throws IOException {
        this.checkFirstWrite();
        this.wrapped.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.checkFirstWrite();
        this.wrapped.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkFirstWrite();
        this.wrapped.write(b, off, len);
    }

    public void flush() throws IOException {
        this.checkFirstWrite();
        this.wrapped.flush();
    }

    public void close() throws IOException {
        this.checkFirstWrite();
        this.wrapped.close();
    }

    public boolean isReady() {
        return this.wrapped.isReady();
    }

    public void setWriteListener(WriteListener writeListener) {
        this.wrapped.setWriteListener(writeListener);
    }
}

