/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;

public class HttpBodyParameters {
    private boolean doOutput = false;
    private boolean doInput = false;

    public HttpBodyParameters(HttpRequestMethod httpMethod, String contentType) throws UtilsException {
        switch (httpMethod) {
            case OPTIONS: {
                this.doOutput = false;
                this.doInput = true;
                break;
            }
            case GET: {
                this.doOutput = false;
                this.doInput = true;
                break;
            }
            case HEAD: {
                this.doOutput = false;
                this.doInput = false;
                break;
            }
            case POST: {
                this.doOutput = true;
                this.doInput = true;
                break;
            }
            case PUT: {
                this.doOutput = true;
                this.doInput = true;
                break;
            }
            case DELETE: {
                this.doOutput = false;
                this.doInput = true;
                break;
            }
            case TRACE: {
                this.doOutput = false;
                this.doInput = true;
                break;
            }
            case PATCH: {
                this.doOutput = true;
                this.doInput = true;
                break;
            }
            case LINK: {
                this.doOutput = true;
                this.doInput = true;
                break;
            }
            case UNLINK: {
                this.doOutput = true;
                this.doInput = true;
                break;
            }
            default: {
                throw new UtilsException("HttpMethod [" + httpMethod + "] unsupported");
            }
        }
        if (contentType == null || "".equals(contentType)) {
            this.doOutput = false;
        }
    }

    public boolean isDoOutput() {
        return this.doOutput;
    }

    public boolean isDoInput() {
        return this.doInput;
    }
}

