/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.CertificateFactory;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.KeystoreUtils;
import org.openspcoop2.utils.certificate.hsm.HSMManager;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.random.RandomGenerator;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.transport.http.IBYOKUnwrapManager;
import org.openspcoop2.utils.transport.http.IOCSPValidator;
import org.openspcoop2.utils.transport.http.OCSPTrustManager;
import org.openspcoop2.utils.transport.http.SSLConfig;
import org.openspcoop2.utils.transport.http.SSLHostNameVerifierDisabled;
import org.openspcoop2.utils.transport.http.SSLSavingTrustManager;
import org.openspcoop2.utils.transport.http.SSLTrustAllManager;
import org.openspcoop2.utils.transport.http.SSLX509ManagerForcedClientAlias;
import org.openspcoop2.utils.transport.http.WrappedHttpServletRequest;
import org.slf4j.Logger;

public class SSLUtilities {
    private static String jvmHttpsClientCertificateConfigurated = null;
    private static TrustManager[] trustAllCertsManager;

    private SSLUtilities() {
    }

    private static synchronized void initJvmHttpsClientCertificateConfigurated() {
        if (jvmHttpsClientCertificateConfigurated == null) {
            jvmHttpsClientCertificateConfigurated = System.getProperty("javax.net.ssl.keyStore");
        }
    }

    public static boolean isJvmHttpsClientCertificateConfigurated() {
        if (jvmHttpsClientCertificateConfigurated == null) {
            SSLUtilities.initJvmHttpsClientCertificateConfigurated();
        }
        return jvmHttpsClientCertificateConfigurated != null;
    }

    public static String getJvmHttpsClientCertificateConfigurated() {
        if (jvmHttpsClientCertificateConfigurated == null) {
            SSLUtilities.initJvmHttpsClientCertificateConfigurated();
        }
        return jvmHttpsClientCertificateConfigurated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSSLEnabledProtocols(String sslType) throws UtilsException {
        try {
            ArrayList<String> p = new ArrayList<String>();
            SSLContext context = SSLContext.getInstance(sslType);
            context.init(null, null, null);
            SSLSocket socket = null;
            try {
                socket = (SSLSocket)context.getSocketFactory().createSocket();
                String[] protocols = socket.getEnabledProtocols();
                for (int i = 0; i < protocols.length; ++i) {
                    p.add(protocols[i]);
                }
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            return p;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSSLSupportedProtocols() throws UtilsException {
        try {
            ArrayList<String> p = new ArrayList<String>();
            SSLContext defaultContext = SSLContext.getDefault();
            SSLSocket socket = null;
            try {
                socket = (SSLSocket)defaultContext.getSocketFactory().createSocket();
                String[] protocols = socket.getSupportedProtocols();
                for (int i = 0; i < protocols.length; ++i) {
                    p.add(protocols[i]);
                }
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            return p;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String getSafeDefaultProtocol() {
        try {
            return SSLUtilities.getDefaultProtocol();
        }
        catch (Exception e) {
            return "TLS";
        }
    }

    public static String getDefaultProtocol() throws UtilsException {
        List<String> p = SSLUtilities.getSSLSupportedProtocols();
        if (p.contains("TLSv1.3")) {
            return "TLSv1.3";
        }
        if (p.contains("TLSv1.2")) {
            return "TLSv1.2";
        }
        if (p.contains("TLSv1.1")) {
            return "TLSv1.1";
        }
        if (p.contains("TLSv1")) {
            return "TLSv1";
        }
        if (p.contains("TLS")) {
            return "TLS";
        }
        if (p.contains("SSLv3")) {
            return "SSLv3";
        }
        if (p.contains("SSL")) {
            return "SSL";
        }
        if (p.contains("SSLv2Hello")) {
            return "SSLv2Hello";
        }
        return p.get(0);
    }

    public static List<String> getAllSslProtocol() {
        ArrayList<String> p = new ArrayList<String>();
        p.add("TLSv1.2");
        p.add("TLSv1.1");
        p.add("TLSv1");
        p.add("TLS");
        p.add("SSLv3");
        p.add("SSL");
        p.add("SSLv2Hello");
        try {
            List<String> pTmp = SSLUtilities.getSSLSupportedProtocols();
            for (String s : pTmp) {
                if (p.contains(s)) continue;
                p.add(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSSLEnabledCipherSuites(String sslType) throws UtilsException {
        try {
            ArrayList<String> l = new ArrayList<String>();
            SSLContext context = SSLContext.getInstance(sslType);
            context.init(null, null, null);
            SSLSocket socket = null;
            try {
                socket = (SSLSocket)context.getSocketFactory().createSocket();
                String[] cs = socket.getEnabledCipherSuites();
                for (int i = 0; i < cs.length; ++i) {
                    l.add(cs[i]);
                }
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            return l;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSSLSupportedCipherSuites() throws UtilsException {
        try {
            ArrayList<String> l = new ArrayList<String>();
            SSLContext defaultContext = SSLContext.getDefault();
            SSLSocket socket = null;
            try {
                socket = (SSLSocket)defaultContext.getSocketFactory().createSocket();
                String[] cs = socket.getSupportedCipherSuites();
                for (int i = 0; i < cs.length; ++i) {
                    l.add(cs[i]);
                }
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            return l;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static List<Provider> getSSLProviders() throws UtilsException {
        try {
            ArrayList<Provider> p = new ArrayList<Provider>();
            for (Provider provider : Security.getProviders()) {
                p.add(provider);
            }
            return p;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static List<String> getSSLProvidersName() throws UtilsException {
        try {
            ArrayList<String> p = new ArrayList<String>();
            for (Provider provider : Security.getProviders()) {
                p.add(provider.getName());
            }
            return p;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static List<String> getServiceTypes(Provider provider) throws UtilsException {
        try {
            ArrayList<String> p = new ArrayList<String>();
            for (Provider.Service service : provider.getServices()) {
                if (p.contains(service.getType())) continue;
                p.add(service.getType());
            }
            return p;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static List<String> getServiceTypeAlgorithms(Provider provider, String serviceType) throws UtilsException {
        try {
            ArrayList<String> p = new ArrayList<String>();
            for (Provider.Service service : provider.getServices()) {
                if (!serviceType.equals(service.getType())) continue;
                p.add(service.getAlgorithm());
            }
            return p;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private static synchronized void initTrustAllCertsManager() {
        if (trustAllCertsManager == null) {
            trustAllCertsManager = new TrustManager[]{new SSLTrustAllManager()};
        }
    }

    public static TrustManager[] getTrustAllCertsManager() {
        if (trustAllCertsManager == null) {
            SSLUtilities.initTrustAllCertsManager();
        }
        return trustAllCertsManager;
    }

    public static SSLContext generateSSLContext(SSLConfig sslConfig, StringBuilder bfLog) throws UtilsException {
        return SSLUtilities.generateSSLContext(sslConfig, null, null, bfLog);
    }

    public static SSLContext generateSSLContext(SSLConfig sslConfig, IOCSPValidator ocspValidator, IBYOKUnwrapManager byok, StringBuilder bfLog) throws UtilsException {
        SSLContext sslContext = null;
        bfLog.append("Creo contesto SSL...\n");
        KeyManager[] km = null;
        TrustManager[] tm = null;
        InputStream finKeyStore = null;
        InputStream finTrustStore = null;
        try {
            if (sslConfig.getKeyStore() != null || sslConfig.getKeyStoreLocation() != null) {
                bfLog.append("Gestione keystore...\n");
                bfLog.append("\tKeystore type[" + sslConfig.getKeyStoreType() + "]\n");
                bfLog.append("\tKeystore location[" + sslConfig.getKeyStoreLocation() + "]\n");
                bfLog.append("\tKeystore byok policy[" + sslConfig.getKeyStoreBYOKPolicy() + "]\n");
                bfLog.append("\tKeystore keyManagementAlgorithm[" + sslConfig.getKeyManagementAlgorithm() + "]\n");
                String location = null;
                try {
                    boolean oldMethodKeyAlias;
                    location = sslConfig.getKeyStoreLocation();
                    boolean hsmKeystore = false;
                    HSMManager hsmManager = HSMManager.getInstance();
                    if (hsmManager != null) {
                        if (sslConfig.getKeyStore() != null) {
                            hsmKeystore = sslConfig.isKeyStoreHsm();
                        } else if (sslConfig.getKeyStoreType() != null && hsmManager.existsKeystoreType(sslConfig.getKeyStoreType())) {
                            hsmKeystore = true;
                        }
                    }
                    bfLog.append("\tKeystore HSM[" + hsmManager + "]\n");
                    KeyStore keystore = null;
                    KeyStore keystoreParam = null;
                    Provider keystoreProvider = null;
                    if (sslConfig.getKeyStore() != null) {
                        keystoreParam = sslConfig.getKeyStore();
                        if (hsmKeystore) {
                            keystoreProvider = keystoreParam.getProvider();
                        }
                    } else if (hsmKeystore) {
                        org.openspcoop2.utils.certificate.KeyStore ks = hsmManager.getKeystore(sslConfig.getKeyStoreType());
                        if (ks == null) {
                            throw new UtilsException("Keystore not found");
                        }
                        keystoreParam = ks.getKeystore();
                        keystoreProvider = keystoreParam.getProvider();
                    } else {
                        File file = new File(location);
                        finKeyStore = file.exists() ? new FileInputStream(file) : SSLUtilities.class.getResourceAsStream(location);
                        if (finKeyStore == null) {
                            throw new UtilsException("Keystore not found");
                        }
                        if (byok != null) {
                            byte[] keystoreEncBytes = Utilities.getAsByteArray(finKeyStore);
                            byte[] keystorePlainBytes = byok.unwrap(keystoreEncBytes);
                            keystoreParam = KeystoreUtils.readKeystore(keystorePlainBytes, sslConfig.getKeyStoreType(), sslConfig.getKeyStorePassword());
                        } else {
                            keystoreParam = KeystoreUtils.readKeystore(finKeyStore, sslConfig.getKeyStoreType(), sslConfig.getKeyStorePassword());
                        }
                    }
                    if ((oldMethodKeyAlias = false) && sslConfig.getKeyAlias() != null) {
                        Key key = keystoreParam.getKey(sslConfig.getKeyAlias(), sslConfig.getKeyPassword().toCharArray());
                        if (key == null) {
                            throw new UtilsException("Key with alias '" + sslConfig.getKeyAlias() + "' not found");
                        }
                        keystore = hsmKeystore ? KeyStore.getInstance(KeystoreType.JKS.getNome()) : KeyStore.getInstance(sslConfig.getKeyStoreType());
                        keystore.load(null);
                        keystore.setKeyEntry(sslConfig.getKeyAlias(), key, sslConfig.getKeyPassword() != null ? sslConfig.getKeyPassword().toCharArray() : "".toCharArray(), keystoreParam.getCertificateChain(sslConfig.getKeyAlias()));
                    } else {
                        keystore = keystoreParam;
                    }
                    KeyManagerFactory keyManagerFactory = null;
                    keyManagerFactory = KeyManagerFactory.getInstance(sslConfig.getKeyManagementAlgorithm());
                    keyManagerFactory.init(keystore, sslConfig.getKeyPassword() != null ? sslConfig.getKeyPassword().toCharArray() : "".toCharArray());
                    km = keyManagerFactory.getKeyManagers();
                    if (!oldMethodKeyAlias && sslConfig.getKeyAlias() != null && km != null && km.length > 0 && km[0] != null && km[0] instanceof X509KeyManager) {
                        String alias = sslConfig.getKeyAlias();
                        Enumeration<String> enAliases = keystore.aliases();
                        if (enAliases != null) {
                            while (enAliases.hasMoreElements()) {
                                String a = enAliases.nextElement();
                                if (!a.equalsIgnoreCase(alias)) continue;
                                alias = a;
                                break;
                            }
                        }
                        SSLX509ManagerForcedClientAlias wrapperX509KeyManager = new SSLX509ManagerForcedClientAlias(alias, (X509KeyManager)km[0]);
                        km[0] = wrapperX509KeyManager;
                    }
                    bfLog.append("Gestione keystore effettuata\n");
                }
                catch (Throwable e) {
                    if (location != null) {
                        throw new UtilsException("[" + location + "] " + e.getMessage(), e);
                    }
                    throw new UtilsException(e.getMessage(), e);
                }
            }
            KeyStore truststoreParam = null;
            if (sslConfig.isTrustAllCerts()) {
                bfLog.append("Gestione trust all certs...\n");
                tm = SSLUtilities.getTrustAllCertsManager();
                bfLog.append("Gestione trust all certs effettuata\n");
            } else if (sslConfig.getTrustStore() != null || sslConfig.getTrustStoreLocation() != null) {
                bfLog.append("Gestione truststore...\n");
                bfLog.append("\tTruststore type[" + sslConfig.getTrustStoreType() + "]\n");
                bfLog.append("\tTruststore location[" + sslConfig.getTrustStoreLocation() + "]\n");
                bfLog.append("\tTruststore trustManagementAlgorithm[" + sslConfig.getTrustManagementAlgorithm() + "]\n");
                String location = null;
                try {
                    location = sslConfig.getTrustStoreLocation();
                    boolean hsmTruststore = false;
                    HSMManager hsmManager = HSMManager.getInstance();
                    if (hsmManager != null) {
                        if (sslConfig.getTrustStore() != null) {
                            hsmTruststore = sslConfig.isTrustStoreHsm();
                        } else if (sslConfig.getTrustStoreType() != null && hsmManager.existsKeystoreType(sslConfig.getTrustStoreType())) {
                            hsmTruststore = true;
                        }
                    }
                    bfLog.append("\tTruststore HSM[" + hsmTruststore + "]\n");
                    Provider truststoreProvider = null;
                    if (sslConfig.getTrustStore() != null) {
                        truststoreParam = sslConfig.getTrustStore();
                        if (hsmTruststore) {
                            truststoreProvider = truststoreParam.getProvider();
                        }
                    } else if (hsmTruststore) {
                        org.openspcoop2.utils.certificate.KeyStore ks = hsmManager.getKeystore(sslConfig.getTrustStoreType());
                        if (ks == null) {
                            throw new UtilsException("Truststore not found");
                        }
                        truststoreParam = ks.getKeystore();
                        truststoreProvider = truststoreParam.getProvider();
                    } else {
                        File file = new File(location);
                        finTrustStore = file.exists() ? new FileInputStream(file) : SSLUtilities.class.getResourceAsStream(location);
                        if (finTrustStore == null) {
                            throw new UtilsException("Truststore not found");
                        }
                        truststoreParam = KeystoreUtils.readKeystore(finTrustStore, sslConfig.getTrustStoreType(), sslConfig.getTrustStorePassword());
                    }
                    TrustManagerFactory trustManagerFactory = null;
                    trustManagerFactory = TrustManagerFactory.getInstance(sslConfig.getTrustManagementAlgorithm());
                    String trustManagementAlgo = sslConfig.getTrustManagementAlgorithm();
                    if (trustManagementAlgo != null) {
                        trustManagementAlgo = trustManagementAlgo.trim();
                    }
                    if ("PKIX".equalsIgnoreCase(trustManagementAlgo)) {
                        if (sslConfig.getTrustStoreCRLs() != null) {
                            bfLog.append("\tTruststore CRLs\n");
                        } else if (sslConfig.getTrustStoreCRLsLocation() != null) {
                            bfLog.append("\tTruststore CRLs[" + sslConfig.getTrustStoreCRLsLocation() + "]\n");
                        }
                        Provider sigProvider = null;
                        CertPathTrustManagerParameters params = SSLUtilities.buildCertPathTrustManagerParameters(truststoreParam, sslConfig.getTrustStoreCRLs(), sslConfig.getTrustStoreCRLsLocation(), sigProvider);
                        trustManagerFactory.init(params);
                    } else {
                        trustManagerFactory.init(truststoreParam);
                    }
                    tm = trustManagerFactory.getTrustManagers();
                    bfLog.append("Gestione truststore effettuata\n");
                }
                catch (Throwable e) {
                    if (location != null) {
                        throw new UtilsException("[" + location + "] " + e.getMessage(), e);
                    }
                    throw new UtilsException(e.getMessage(), e);
                }
            }
            if (ocspValidator != null) {
                if (ocspValidator.getTrustStore() == null && truststoreParam != null) {
                    ocspValidator.setTrustStore(new org.openspcoop2.utils.certificate.KeyStore(truststoreParam));
                }
                tm = OCSPTrustManager.wrap(tm, ocspValidator);
                ocspValidator.setOCSPTrustManager(OCSPTrustManager.read(tm));
            }
            bfLog.append("Init SSLContext type[" + sslConfig.getSslType() + "] ...\n");
            sslContext = SSLContext.getInstance(sslConfig.getSslType());
            if (sslConfig.isSecureRandom()) {
                RandomGenerator randomGenerator = null;
                if (sslConfig.getSecureRandomAlgorithm() != null && !"".equals(sslConfig.getSecureRandomAlgorithm())) {
                    bfLog.append("Creazione Secure Random con algoritmo '" + sslConfig.getSecureRandomAlgorithm() + "' ...\n");
                    randomGenerator = new RandomGenerator(true, sslConfig.getSecureRandomAlgorithm());
                    bfLog.append("Creazione Secure Random con algoritmo '" + sslConfig.getSecureRandomAlgorithm() + "' effettuata\n");
                } else {
                    bfLog.append("Creazione Secure Random ...\n");
                    randomGenerator = new RandomGenerator(true);
                    bfLog.append("Creazione Secure Random effettuata\n");
                }
                SecureRandom secureRandom = (SecureRandom)randomGenerator.getRandomEngine();
                bfLog.append("Inizializzazione SSLContext con Secure Random ...\n");
                sslContext.init(km, tm, secureRandom);
            } else {
                sslContext.init(km, tm, null);
            }
            if (sslContext.getClientSessionContext() != null) {
                bfLog.append("ClientSessionContext size:").append(sslContext.getClientSessionContext().getSessionCacheSize()).append(" timeout:").append(sslContext.getClientSessionContext().getSessionTimeout()).append("\n");
            }
            if (sslContext.getServerSessionContext() != null) {
                bfLog.append("ServerSessionContext size:").append(sslContext.getServerSessionContext().getSessionCacheSize()).append(" timeout:").append(sslContext.getServerSessionContext().getSessionTimeout()).append("\n");
            }
            bfLog.append("Init SSLContext type[" + sslConfig.getSslType() + "] effettuato\n");
            SSLContext sSLContext = sslContext;
            return sSLContext;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (finKeyStore != null) {
                    finKeyStore.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (finTrustStore != null) {
                    finTrustStore.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static CertPathTrustManagerParameters buildCertPathTrustManagerParameters(KeyStore truststoreParam, CertStore crlStore, String crlLocation, Provider provider) throws Exception {
        KeyStore truststore = KeyStore.getInstance(KeyStore.getDefaultType());
        truststore.load(null);
        Enumeration<String> aliases = truststoreParam.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            truststore.setCertificateEntry(alias, truststoreParam.getCertificate(alias));
        }
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(truststore, (CertSelector)new X509CertSelector());
        pkixParams.setRevocationEnabled(false);
        pkixParams.setDate(DateManager.getDate());
        if (crlStore != null || crlLocation != null) {
            CertStore crlsCertstore = null;
            crlsCertstore = crlStore != null ? crlStore : SSLUtilities.buildCRLCertStoreEngine(crlLocation);
            pkixParams.addCertStore(crlsCertstore);
            pkixParams.setRevocationEnabled(true);
        }
        if (provider != null) {
            pkixParams.setSigProvider(provider.getName());
        }
        return new CertPathTrustManagerParameters(pkixParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CertStore buildCRLCertStoreEngine(String crlsPath) throws Exception {
        ArrayList<byte[]> crlBytes = new ArrayList<byte[]>();
        ArrayList<String> crlPathsList = new ArrayList<String>();
        if (crlsPath.contains(",")) {
            String[] tmp = crlsPath.split(",");
            for (String crlPath : tmp) {
                crlPathsList.add(crlPath.trim());
            }
        } else {
            crlPathsList.add(crlsPath.trim());
        }
        for (String crlPath : crlPathsList) {
            InputStream isStore = null;
            try {
                File fStore = new File(crlPath);
                isStore = fStore.exists() ? new FileInputStream(fStore) : SSLUtilities.class.getResourceAsStream(crlPath);
                if (isStore == null) {
                    throw new UtilsException("CRL [" + crlPath + "] not found");
                }
                crlBytes.add(Utilities.getAsByteArray(isStore));
            }
            finally {
                try {
                    if (isStore == null) continue;
                    isStore.close();
                }
                catch (Exception fStore) {}
            }
        }
        ArrayList<X509CRL> caCrls = new ArrayList<X509CRL>();
        java.security.cert.CertificateFactory certFactory = CertificateFactory.getCertificateFactory();
        for (int i = 0; i < crlBytes.size(); ++i) {
            byte[] crl = (byte[])crlBytes.get(i);
            try (ByteArrayInputStream bin = new ByteArrayInputStream(crl);){
                X509CRL caCrl = (X509CRL)certFactory.generateCRL(bin);
                caCrls.add(caCrl);
                continue;
            }
            catch (Exception e) {
                throw new SecurityException("Error loading CRL '" + (String)crlPathsList.get(i) + "': " + e.getMessage(), e);
            }
        }
        try {
            CollectionCertStoreParameters certStoreParams = new CollectionCertStoreParameters(caCrls);
            return CertStore.getInstance("Collection", certStoreParams);
        }
        catch (Exception e) {
            throw new SecurityException("Build CertStore failed: " + e.getMessage(), e);
        }
    }

    public static HostnameVerifier generateHostnameVerifier(SSLConfig sslConfig, StringBuilder bfLog, Logger log, Loader loader) throws UtilsException {
        try {
            if (sslConfig.isHostnameVerifier()) {
                if (sslConfig.getClassNameHostnameVerifier() != null) {
                    bfLog.append("HostNamve verifier enabled [" + sslConfig.getClassNameHostnameVerifier() + "]\n");
                    return (HostnameVerifier)loader.newInstance(sslConfig.getClassNameHostnameVerifier());
                }
                bfLog.append("HostName verifier enabled\n");
                return null;
            }
            bfLog.append("HostName verifier disabled\n");
            SSLHostNameVerifierDisabled disabilitato = new SSLHostNameVerifierDisabled(log);
            return disabilitato;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void setSSLContextIntoJavaProperties(SSLConfig sslConfig, StringBuilder bfLog) throws UtilsException {
        bfLog.append("Creo contesto SSL...\n");
        try {
            if (sslConfig.getKeyStoreLocation() != null) {
                bfLog.append("Gestione keystore...\n");
                System.setProperty("javax.net.ssl.keyStore", sslConfig.getKeyStoreLocation());
                if (sslConfig.getKeyStoreType() != null) {
                    System.setProperty("javax.net.ssl.keyStoreType", sslConfig.getKeyStoreType());
                }
                if (sslConfig.getKeyStorePassword() != null) {
                    System.setProperty("javax.net.ssl.keyStorePassword", sslConfig.getKeyStorePassword());
                }
                if (sslConfig.getKeyPassword() != null) {
                    System.setProperty("javax.net.ssl.keyStorePassword", sslConfig.getKeyStorePassword());
                    if (sslConfig.getKeyStorePassword() != null && !sslConfig.getKeyPassword().equals(sslConfig.getKeyStorePassword())) {
                        throw new UtilsException("Keystore and key password in java must be equals");
                    }
                }
                bfLog.append("Gestione keystore effettuata\n");
            }
            if (sslConfig.getTrustStoreLocation() != null) {
                bfLog.append("Gestione truststore...\n");
                System.setProperty("javax.net.ssl.trustStore", sslConfig.getTrustStoreLocation());
                if (sslConfig.getKeyStoreType() != null) {
                    System.setProperty("javax.net.ssl.trustStoreType", sslConfig.getTrustStoreType());
                }
                if (sslConfig.getKeyStorePassword() != null) {
                    System.setProperty("javax.net.ssl.trustStorePassword", sslConfig.getTrustStorePassword());
                }
                bfLog.append("Gestione truststore effettuata\n");
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readPeerCertificates(String host, int port) throws UtilsException {
        try {
            SSLContext sslContext = SSLContext.getInstance(SSLUtilities.getDefaultProtocol());
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            SSLSavingTrustManager tm = new SSLSavingTrustManager(defaultTrustManager);
            sslContext.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            SSLSocket sslSocket = null;
            try {
                sslSocket = (SSLSocket)sslSocketFactory.createSocket(host, port);
                sslSocket.setSoTimeout(10000);
                sslSocket.setWantClientAuth(false);
                try {
                    sslSocket.startHandshake();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            finally {
                try {
                    if (sslSocket != null) {
                        sslSocket.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            X509Certificate[] certs = tm.getPeerCertificates();
            if (certs == null || certs.length <= 0) {
                throw new UtilsException("Peer Certificates not found");
            }
            StringBuilder sb = new StringBuilder();
            for (X509Certificate certificate : certs) {
                StringWriter sw = new StringWriter();
                JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)sw);
                pemWriter.writeObject((Object)certificate);
                pemWriter.close();
                sw.close();
                sb.append(sw.toString());
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static X509Certificate[] readCertificatesFromUndertowServlet(HttpServletRequest req) {
        return SSLUtilities.readCertificatesFromUndertowServlet(req, null);
    }

    public static X509Certificate[] readCertificatesFromUndertowServlet(HttpServletRequest reqParam, Logger log) {
        block8: {
            try {
                Method mPeerCertificates;
                Object sslSessionInfo;
                Method mSSLSessionInfo;
                Object connection;
                Method mConnection;
                Object exchange;
                Method mExchange;
                String actual;
                String undertow;
                boolean isUndertow;
                HttpServletRequest req = reqParam;
                if (reqParam instanceof WrappedHttpServletRequest) {
                    req = ((WrappedHttpServletRequest)reqParam).httpServletRequest;
                }
                if (!(isUndertow = (undertow = "io.undertow.servlet.spec.HttpServletRequestImpl").equals(actual = req.getClass().getName())) || (mExchange = req.getClass().getMethod("getExchange", new Class[0])) == null || (exchange = mExchange.invoke((Object)req, new Object[0])) == null || (mConnection = exchange.getClass().getMethod("getConnection", new Class[0])) == null || (connection = mConnection.invoke(exchange, new Object[0])) == null || (mSSLSessionInfo = connection.getClass().getMethod("getSslSessionInfo", new Class[0])) == null || (sslSessionInfo = mSSLSessionInfo.invoke(connection, new Object[0])) == null || (mPeerCertificates = sslSessionInfo.getClass().getMethod("getPeerCertificates", new Class[0])) == null) break block8;
                try {
                    Object peerCertificates = mPeerCertificates.invoke(sslSessionInfo, new Object[0]);
                    if (peerCertificates instanceof X509Certificate[]) {
                        return (X509Certificate[])peerCertificates;
                    }
                }
                catch (Throwable t) {
                    if (Utilities.existsInnerException(t, "io.undertow.server.RenegotiationRequiredException")) {
                        return null;
                    }
                    if (log != null) {
                        log.error("readCertificatesFromUndertowServlet 'get peer certificates' failed: " + t.getMessage(), t);
                    }
                }
            }
            catch (Throwable t) {
                if (log == null) break block8;
                log.error("readCertificatesFromUndertowServlet failed: " + t.getMessage(), t);
            }
        }
        return null;
    }
}

