/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.wadl;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.ast.ApplicationNode;
import org.jvnet.ws.wadl.ast.FaultNode;
import org.jvnet.ws.wadl.ast.MethodNode;
import org.jvnet.ws.wadl.ast.PathSegment;
import org.jvnet.ws.wadl.ast.RepresentationNode;
import org.jvnet.ws.wadl.ast.ResourceNode;
import org.openspcoop2.utils.rest.ApiReaderConfig;
import org.openspcoop2.utils.rest.IApiReader;
import org.openspcoop2.utils.rest.ProcessingException;
import org.openspcoop2.utils.rest.api.Api;
import org.openspcoop2.utils.rest.api.ApiBodyParameter;
import org.openspcoop2.utils.rest.api.ApiHeaderParameter;
import org.openspcoop2.utils.rest.api.ApiOperation;
import org.openspcoop2.utils.rest.api.ApiParameterSchema;
import org.openspcoop2.utils.rest.api.ApiRequest;
import org.openspcoop2.utils.rest.api.ApiRequestDynamicPathParameter;
import org.openspcoop2.utils.rest.api.ApiRequestQueryParameter;
import org.openspcoop2.utils.rest.api.ApiResponse;
import org.openspcoop2.utils.rest.api.ApiSchema;
import org.openspcoop2.utils.rest.api.ApiSchemaType;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.wadl.ApplicationWrapper;
import org.openspcoop2.utils.wadl.WADLApi;
import org.openspcoop2.utils.wadl.WADLUtilities;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WADLApiReader
implements IApiReader {
    private ApplicationWrapper applicationWadlWrapper;
    private ApiSchema[] schemas;

    private Map<String, byte[]> convert(ApiSchema ... schema) {
        HashMap<String, byte[]> map = null;
        if (schema != null && schema.length > 0) {
            for (ApiSchema apiSchema : schema) {
                if (!ApiSchemaType.XSD.equals(apiSchema.getType())) continue;
                if (map == null) {
                    map = new HashMap<String, byte[]>();
                }
                map.put(apiSchema.getName(), apiSchema.getContent());
            }
        }
        return map;
    }

    @Override
    public void init(Logger log, String content, ApiReaderConfig config) throws ProcessingException {
        this._init(log, content, config, new ApiSchema[0]);
    }

    @Override
    public void init(Logger log, String content, ApiReaderConfig config, ApiSchema ... schema) throws ProcessingException {
        this._init(log, content, config, schema);
    }

    private void _init(Logger log, String content, ApiReaderConfig config, ApiSchema ... schema) throws ProcessingException {
        try {
            this.applicationWadlWrapper = WADLUtilities.getInstance(config.getXmlUtils()).readWADLFromBytes(log, content.getBytes(config.getCharset().getValue()), config.isVerbose(), config.isProcessInclude(), config.isProcessInlineSchema(), this.convert(schema));
            this.schemas = schema;
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    @Override
    public void init(Logger log, byte[] content, ApiReaderConfig config) throws ProcessingException {
        this._init(log, content, config, new ApiSchema[0]);
    }

    @Override
    public void init(Logger log, byte[] content, ApiReaderConfig config, ApiSchema ... schema) throws ProcessingException {
        this._init(log, content, config, schema);
    }

    private void _init(Logger log, byte[] content, ApiReaderConfig config, ApiSchema ... schema) throws ProcessingException {
        try {
            this.applicationWadlWrapper = WADLUtilities.getInstance(config.getXmlUtils()).readWADLFromBytes(log, content, config.isVerbose(), config.isProcessInclude(), config.isProcessInlineSchema(), this.convert(schema));
            this.schemas = schema;
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    @Override
    public void init(Logger log, File file, ApiReaderConfig config) throws ProcessingException {
        this._init(log, file, config, new ApiSchema[0]);
    }

    @Override
    public void init(Logger log, File file, ApiReaderConfig config, ApiSchema ... schema) throws ProcessingException {
        this._init(log, file, config, schema);
    }

    private void _init(Logger log, File file, ApiReaderConfig config, ApiSchema ... schema) throws ProcessingException {
        try {
            this.applicationWadlWrapper = WADLUtilities.getInstance(config.getXmlUtils()).readWADLFromFile(log, file, config.isVerbose(), config.isProcessInclude(), config.isProcessInlineSchema(), this.convert(schema));
            this.schemas = schema;
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    @Override
    public void init(Logger log, URI uri, ApiReaderConfig config) throws ProcessingException {
        this._init(log, uri, config, new ApiSchema[0]);
    }

    @Override
    public void init(Logger log, URI uri, ApiReaderConfig config, ApiSchema ... schema) throws ProcessingException {
        this._init(log, uri, config, schema);
    }

    private void _init(Logger log, URI uri, ApiReaderConfig config, ApiSchema ... schema) throws ProcessingException {
        try {
            this.applicationWadlWrapper = WADLUtilities.getInstance(config.getXmlUtils()).readWADLFromURI(log, uri, config.isVerbose(), config.isProcessInclude(), config.isProcessInlineSchema(), this.convert(schema));
            this.schemas = schema;
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    @Override
    public void init(Logger log, Document doc, ApiReaderConfig config) throws ProcessingException {
        this._init(log, doc, config, new ApiSchema[0]);
    }

    @Override
    public void init(Logger log, Document doc, ApiReaderConfig config, ApiSchema ... schema) throws ProcessingException {
        this._init(log, doc, config, schema);
    }

    private void _init(Logger log, Document doc, ApiReaderConfig config, ApiSchema ... schema) throws ProcessingException {
        try {
            this.applicationWadlWrapper = WADLUtilities.getInstance(config.getXmlUtils()).readWADLFromDocument(log, doc, config.isVerbose(), config.isProcessInclude(), config.isProcessInlineSchema(), this.convert(schema));
            this.schemas = schema;
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    @Override
    public void init(Logger log, Element element, ApiReaderConfig config) throws ProcessingException {
        this._init(log, element, config, new ApiSchema[0]);
    }

    @Override
    public void init(Logger log, Element element, ApiReaderConfig config, ApiSchema ... schema) throws ProcessingException {
        this._init(log, element, config, schema);
    }

    private void _init(Logger log, Element element, ApiReaderConfig config, ApiSchema ... schema) throws ProcessingException {
        try {
            this.applicationWadlWrapper = WADLUtilities.getInstance(config.getXmlUtils()).readWADLFromDocument(log, element, config.isVerbose(), config.isProcessInclude(), config.isProcessInlineSchema(), this.convert(schema));
            this.schemas = schema;
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    @Override
    public Api read() throws ProcessingException {
        ApplicationNode an;
        List rs;
        WADLApi api = new WADLApi(this.applicationWadlWrapper);
        if (this.schemas != null && this.schemas.length > 0) {
            for (ApiSchema apiSchema : this.schemas) {
                api.addSchema(apiSchema);
            }
        }
        if ((rs = (an = this.applicationWadlWrapper.getApplicationNode()).getResources()).size() <= 0) {
            throw new ProcessingException("Non sono state trovate risorse registrate nel documento");
        }
        if (rs.size() > 1) {
            throw new ProcessingException("Trovato pi\u00f9 di un elemento 'resources' nella radice del documento");
        }
        try {
            api.setBaseURL(new URL(((ResourceNode)rs.get(0)).getUriTemplate()));
        }
        catch (Exception e) {
            throw new ProcessingException("Trovata resources base url malformata: " + e.getMessage(), e);
        }
        this.readOperations(rs, api);
        return api;
    }

    private void readOperations(List<ResourceNode> rs, Api api) throws ProcessingException {
        try {
            if (rs != null && rs.size() > 0) {
                for (ResourceNode resourceNode : rs) {
                    List method = resourceNode.getMethods();
                    if (method != null && method.size() > 0) {
                        for (MethodNode methodNode : method) {
                            MultivaluedMap mapFault;
                            MultivaluedMap mapOutput;
                            List lInput;
                            List lSegment;
                            List lQuery;
                            ApiOperation operation = new ApiOperation(HttpRequestMethod.valueOf(methodNode.getName().toUpperCase()), resourceNode.getAllResourceUriTemplate());
                            List lHeaders = methodNode.getHeaderParameters();
                            if (lHeaders != null && lHeaders.size() > 0) {
                                if (operation.getRequest() == null) {
                                    operation.setRequest(new ApiRequest());
                                }
                                for (Param param : lHeaders) {
                                    ApiParameterSchema apiParameterSchema = new ApiParameterSchema();
                                    apiParameterSchema.addType(param.getType().toString(), null);
                                    ApiHeaderParameter header = new ApiHeaderParameter(param.getName(), apiParameterSchema);
                                    header.setRequired(param.isRequired());
                                    operation.getRequest().addHeaderParameter(header);
                                }
                            }
                            if ((lQuery = methodNode.getQueryParameters()) != null && lQuery.size() > 0) {
                                Param param;
                                if (operation.getRequest() == null) {
                                    operation.setRequest(new ApiRequest());
                                }
                                param = lQuery.iterator();
                                while (param.hasNext()) {
                                    Param param2 = (Param)param.next();
                                    ApiParameterSchema apiParameterSchema = new ApiParameterSchema();
                                    apiParameterSchema.addType(param2.getType().toString(), null);
                                    ApiRequestQueryParameter query = new ApiRequestQueryParameter(param2.getName(), apiParameterSchema);
                                    query.setRequired(param2.isRequired());
                                    operation.getRequest().addQueryParameter(query);
                                }
                            }
                            if ((lSegment = resourceNode.getPathSegments()) != null && lSegment.size() > 0) {
                                for (PathSegment segment : lSegment) {
                                    List lDynamicPath = segment.getTemplateParameters();
                                    if (lDynamicPath == null || lDynamicPath.size() <= 0) continue;
                                    for (Param param : lDynamicPath) {
                                        if (operation.getRequest() == null) {
                                            operation.setRequest(new ApiRequest());
                                        }
                                        ApiParameterSchema apiParameterSchema = new ApiParameterSchema();
                                        apiParameterSchema.addType(param.getType().toString(), null);
                                        ApiRequestDynamicPathParameter query = new ApiRequestDynamicPathParameter(param.getName(), apiParameterSchema);
                                        query.setRequired(true);
                                        operation.getRequest().addDynamicPathParameter(query);
                                    }
                                }
                            }
                            if ((lInput = methodNode.getSupportedInputs()) != null && lInput.size() > 0) {
                                PathSegment segment;
                                segment = lInput.iterator();
                                while (segment.hasNext()) {
                                    RepresentationNode representationNode = (RepresentationNode)segment.next();
                                    if (operation.getRequest() == null) {
                                        operation.setRequest(new ApiRequest());
                                    }
                                    ApiBodyParameter query = new ApiBodyParameter(null);
                                    query.setMediaType(representationNode.getMediaType());
                                    query.setElement(representationNode.getElement());
                                    operation.getRequest().addBodyParameter(query);
                                }
                            }
                            if ((mapOutput = methodNode.getSupportedOutputs()) != null && mapOutput.size() > 0) {
                                for (List listLong : mapOutput.keySet()) {
                                    List representationNode = (List)mapOutput.get((Object)listLong);
                                    for (int i = 0; i < listLong.size(); ++i) {
                                        int httpStatus = ((Long)listLong.get(i)).intValue();
                                        RepresentationNode rNodeHttpStatus = (RepresentationNode)representationNode.get(i);
                                        ApiResponse apiResponse = null;
                                        for (ApiResponse responseExists : operation.getResponses()) {
                                            if (responseExists.getHttpReturnCode() != httpStatus) continue;
                                            apiResponse = responseExists;
                                            break;
                                        }
                                        if (apiResponse == null) {
                                            apiResponse = new ApiResponse();
                                            apiResponse.setHttpReturnCode(httpStatus);
                                            if (rNodeHttpStatus.getParam() != null) {
                                                for (Param param : rNodeHttpStatus.getParam()) {
                                                    ApiParameterSchema apiParameterSchema = new ApiParameterSchema();
                                                    apiParameterSchema.addType(param.getType().toString(), null);
                                                    ApiHeaderParameter header = new ApiHeaderParameter(param.getName(), apiParameterSchema);
                                                    header.setRequired(param.isRequired());
                                                    apiResponse.addHeaderParameter(header);
                                                }
                                            }
                                            operation.addResponse(apiResponse);
                                        }
                                        if (rNodeHttpStatus.getMediaType() == null) continue;
                                        String name = null;
                                        if (rNodeHttpStatus.getElement() != null) {
                                            name = rNodeHttpStatus.getElement().getLocalPart();
                                        }
                                        Iterator bodyParameter = new ApiBodyParameter(name);
                                        ((ApiBodyParameter)((Object)bodyParameter)).setMediaType(rNodeHttpStatus.getMediaType());
                                        ((ApiBodyParameter)((Object)bodyParameter)).setElement(rNodeHttpStatus.getElement());
                                        apiResponse.addBodyParameter((ApiBodyParameter)((Object)bodyParameter));
                                    }
                                }
                            }
                            if ((mapFault = methodNode.getFaults()) != null && mapFault.size() > 0) {
                                for (List listLong : mapFault.keySet()) {
                                    List representationNode = (List)mapFault.get((Object)listLong);
                                    for (int i = 0; i < listLong.size(); ++i) {
                                        int httpStatus = ((Long)listLong.get(i)).intValue();
                                        FaultNode rNodeHttpStatus = (FaultNode)representationNode.get(i);
                                        ApiResponse apiResponse = null;
                                        for (ApiResponse responseExists : operation.getResponses()) {
                                            if (responseExists.getHttpReturnCode() != httpStatus) continue;
                                            apiResponse = responseExists;
                                            break;
                                        }
                                        if (apiResponse == null) {
                                            apiResponse = new ApiResponse();
                                            apiResponse.setHttpReturnCode(httpStatus);
                                            if (rNodeHttpStatus.getParam() != null) {
                                                for (Param param : rNodeHttpStatus.getParam()) {
                                                    ApiParameterSchema apiParameterSchema = new ApiParameterSchema();
                                                    apiParameterSchema.addType(param.getType().toString(), null);
                                                    ApiHeaderParameter header = new ApiHeaderParameter(param.getName(), apiParameterSchema);
                                                    header.setRequired(param.isRequired());
                                                    apiResponse.addHeaderParameter(header);
                                                }
                                            }
                                            operation.addResponse(apiResponse);
                                        }
                                        if (rNodeHttpStatus.getMediaType() == null) continue;
                                        String name = null;
                                        if (rNodeHttpStatus.getElement() != null) {
                                            name = rNodeHttpStatus.getElement().getLocalPart();
                                        }
                                        ApiBodyParameter bodyParameter = new ApiBodyParameter(name);
                                        bodyParameter.setMediaType(rNodeHttpStatus.getMediaType());
                                        bodyParameter.setElement(rNodeHttpStatus.getElement());
                                        apiResponse.addBodyParameter(bodyParameter);
                                    }
                                }
                            }
                            api.addOperation(operation);
                        }
                    }
                    this.readOperations(resourceNode.getChildResources(), api);
                }
            }
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }
}

