/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml2json;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import org.codehaus.jettison.mapped.Configuration;
import org.openspcoop2.utils.json.JsonPathExpressionEngine;
import org.openspcoop2.utils.json.JsonPathNotValidException;
import org.openspcoop2.utils.xml.AbstractXPathExpressionEngine;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XPathExpressionEngine;
import org.openspcoop2.utils.xml2json.IJson2Xml;
import org.openspcoop2.utils.xml2json.Xml2JsonFactory;
import org.slf4j.Logger;

public class JsonXmlPathExpressionEngine {
    private static final String PREFIX = "xpath ";
    private static final String NAMESPACE_PREFIX = "namespace(";
    private static final String NAMESPACE_END = ")";

    public static void validate(String patternParam, Logger log) throws JsonPathNotValidException {
        boolean json2Xml = false;
        String pattern = patternParam;
        String tipo = "Mapped";
        if (patternParam != null && patternParam.toLowerCase().startsWith(PREFIX.toLowerCase())) {
            json2Xml = true;
            pattern = patternParam.substring(PREFIX.length());
            tipo = "Mapped";
        }
        if (pattern == null || "".equals(pattern)) {
            throw new JsonPathNotValidException("Espressione da utilizzare non fornita");
        }
        if (!json2Xml) {
            try {
                JsonPath.compile((String)pattern, (Predicate[])new Predicate[0]);
            }
            catch (Exception e) {
                throw new JsonPathNotValidException("Validazione del jsonPath indicato [" + pattern + "] fallita: " + e.getMessage(), e);
            }
        }
        try {
            pattern = pattern.trim();
            if (pattern.toLowerCase().startsWith(NAMESPACE_PREFIX)) {
                String[] tmp;
                if (!(pattern = pattern.substring(NAMESPACE_PREFIX.length())).contains(NAMESPACE_END)) {
                    throw new JsonPathNotValidException("Espressione '" + patternParam + "' in un formato non corretto; non \u00e8 stata riscontrata la chiusura della definizione dei namespace");
                }
                int offSet = pattern.indexOf(NAMESPACE_END);
                String namespaces = pattern.substring(0, offSet);
                if (offSet < pattern.length() - 1) {
                    pattern = pattern.substring(offSet + 1, pattern.length());
                    pattern = pattern.trim();
                } else {
                    pattern = null;
                }
                if (pattern == null || "".equals(pattern)) {
                    throw new JsonPathNotValidException("Espressione '" + patternParam + "' da utilizzare non fornita dopo la dichiarazione dei namespace");
                }
                if (namespaces != null && !"".equals(namespaces) && (tmp = namespaces.split(",")) != null && tmp.length > 0) {
                    for (String namespaceDeclaration : tmp) {
                        if (namespaceDeclaration == null || "".equals(namespaceDeclaration)) continue;
                        if (!namespaceDeclaration.contains(":")) {
                            throw new JsonPathNotValidException("Espressione '" + patternParam + "' da utilizzare non corretta; dichiarazione dei namespace in un formato non corretto: atteso ':' separator. (" + namespaces + ") (" + namespaceDeclaration + NAMESPACE_END);
                        }
                        int indexOfPrefix = namespaceDeclaration.indexOf(":");
                        String prefix = namespaceDeclaration.substring(0, indexOfPrefix);
                        String uri = null;
                        if (indexOfPrefix >= namespaceDeclaration.length() - 1) {
                            throw new JsonPathNotValidException("Espressione '" + patternParam + "' da utilizzare non corretta; dichiarazione dei namespace in un formato non corretto: attesa dichiarazione namespace. (" + namespaces + ") (" + namespaceDeclaration + NAMESPACE_END);
                        }
                        uri = namespaceDeclaration.substring(indexOfPrefix + 1, namespaceDeclaration.length());
                        prefix = prefix.trim();
                        uri = uri.trim();
                        if (prefix == null || "".equals(prefix)) {
                            throw new JsonPathNotValidException("Espressione '" + patternParam + "' da utilizzare non corretta; dichiarazione dei namespace in un formato non corretto: prefisso non presente. (" + namespaces + ") (" + namespaceDeclaration + NAMESPACE_END);
                        }
                        if (uri != null && !"".equals(uri)) continue;
                        throw new JsonPathNotValidException("Espressione '" + patternParam + "' da utilizzare non corretta; dichiarazione dei namespace in un formato non corretto: dichiarazione namespace non presente. (" + namespaces + ") (" + namespaceDeclaration + NAMESPACE_END);
                    }
                }
            }
            XPathExpressionEngine engine = new XPathExpressionEngine();
            engine.validate(pattern);
        }
        catch (JsonPathNotValidException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonPathNotValidException("Trasformazione json2xml '" + tipo + "' fallita: " + e.getMessage(), e);
        }
    }

    public static String extractAndConvertResultAsString(String elementJson, String pattern, Logger log) throws Exception {
        Object o = JsonXmlPathExpressionEngine._extractAndConvertResultAsString(elementJson, pattern, log, false);
        if (o != null) {
            return (String)o;
        }
        return null;
    }

    public static List<String> extractAndConvertResultAsList(String elementJson, String pattern, Logger log) throws Exception {
        Object o = JsonXmlPathExpressionEngine._extractAndConvertResultAsString(elementJson, pattern, log, true);
        if (o != null) {
            return (List)o;
        }
        return null;
    }

    private static Object _extractAndConvertResultAsString(String elementJson, String patternParam, Logger log, boolean returnAsList) throws Exception {
        IJson2Xml json2Xml = null;
        String pattern = patternParam;
        String tipo = "Mapped";
        if (patternParam != null && patternParam.toLowerCase().startsWith(PREFIX.toLowerCase())) {
            json2Xml = Xml2JsonFactory.getJson2XmlMapped(new Configuration());
            pattern = patternParam.substring(PREFIX.length());
            tipo = "Mapped";
        }
        if (pattern == null || "".equals(pattern)) {
            throw new Exception("Espressione da utilizzare non fornita");
        }
        if (json2Xml != null) {
            String node = null;
            DynamicNamespaceContext dnc = new DynamicNamespaceContext();
            try {
                String elementJsonWrapped = "{ \"json2xml\" : " + elementJson + " }";
                node = json2Xml.json2xml(elementJsonWrapped);
                if (node == null || "".equals(node)) {
                    throw new Exception("xml element ottenuto \u00e8 vuoto");
                }
                pattern = pattern.trim();
                String namespaces = null;
                StringBuilder sbNamespaceDeclarations = new StringBuilder("");
                if (pattern.toLowerCase().startsWith(NAMESPACE_PREFIX)) {
                    String[] tmp;
                    if (!(pattern = pattern.substring(NAMESPACE_PREFIX.length())).contains(NAMESPACE_END)) {
                        throw new Exception("Espressione in un formato non corretto; non \u00e8 stata riscontrata la chiusura della definizione dei namespace");
                    }
                    int offSet = pattern.indexOf(NAMESPACE_END);
                    namespaces = pattern.substring(0, offSet);
                    if (offSet < pattern.length() - 1) {
                        pattern = pattern.substring(offSet + 1, pattern.length());
                        pattern = pattern.trim();
                    } else {
                        pattern = null;
                    }
                    if (pattern == null || "".equals(pattern)) {
                        throw new Exception("Espressione da utilizzare non fornita dopo la dichiarazione dei namespace");
                    }
                    String newNameXmlns = "___xmlns";
                    boolean foundXmlns = false;
                    boolean foundDeclXmlns = false;
                    if (node.contains("<xmlns:")) {
                        foundXmlns = true;
                        node = node.replaceAll("<xmlns:", "<" + newNameXmlns + ":");
                        node = node.replaceAll("</xmlns:", "</" + newNameXmlns + ":");
                    }
                    if (namespaces != null && !"".equals(namespaces) && (tmp = namespaces.split(",")) != null && tmp.length > 0) {
                        for (String namespaceDeclaration : tmp) {
                            if (namespaceDeclaration == null || "".equals(namespaceDeclaration)) continue;
                            if (!namespaceDeclaration.contains(":")) {
                                throw new Exception("Espressione da utilizzare non corretta; dichiarazione dei namespace in un formato non corretto: atteso ':' separator. (" + namespaces + ") (" + namespaceDeclaration + NAMESPACE_END);
                            }
                            int indexOfPrefix = namespaceDeclaration.indexOf(":");
                            String prefix = namespaceDeclaration.substring(0, indexOfPrefix);
                            String uri = null;
                            if (indexOfPrefix >= namespaceDeclaration.length() - 1) {
                                throw new Exception("Espressione da utilizzare non corretta; dichiarazione dei namespace in un formato non corretto: attesa dichiarazione namespace. (" + namespaces + ") (" + namespaceDeclaration + NAMESPACE_END);
                            }
                            uri = namespaceDeclaration.substring(indexOfPrefix + 1, namespaceDeclaration.length());
                            prefix = prefix.trim();
                            uri = uri.trim();
                            if (prefix == null || "".equals(prefix)) {
                                throw new Exception("Espressione da utilizzare non corretta; dichiarazione dei namespace in un formato non corretto: prefisso non presente. (" + namespaces + ") (" + namespaceDeclaration + NAMESPACE_END);
                            }
                            if (uri == null || "".equals(uri)) {
                                throw new Exception("Espressione da utilizzare non corretta; dichiarazione dei namespace in un formato non corretto: dichiarazione namespace non presente. (" + namespaces + ") (" + namespaceDeclaration + NAMESPACE_END);
                            }
                            if (prefix.equals("xmlns")) {
                                prefix = newNameXmlns;
                                foundDeclXmlns = true;
                            }
                            dnc.addNamespace(prefix, uri);
                            sbNamespaceDeclarations.append(" xmlns:").append(prefix).append("=\"").append(uri).append("\" ");
                        }
                    }
                    if (foundXmlns && !foundDeclXmlns) {
                        String prefix = newNameXmlns;
                        String uri = "http://govway.org/utils/json2xml/xmlns";
                        dnc.addNamespace(prefix, uri);
                        sbNamespaceDeclarations.append(" xmlns:").append(prefix).append("=\"").append(uri).append("\" ");
                    }
                }
                if (sbNamespaceDeclarations != null && sbNamespaceDeclarations.length() > 0) {
                    node = node.replaceFirst("<json2xml>", "<json2xml" + sbNamespaceDeclarations + ">");
                }
            }
            catch (Exception e) {
                throw new Exception("Trasformazione json2xml '" + tipo + "' fallita: " + e.getMessage(), e);
            }
            try {
                XPathExpressionEngine xPathEngine = new XPathExpressionEngine();
                if (returnAsList) {
                    return AbstractXPathExpressionEngine.extractAndConvertResultAsList(node, dnc, (AbstractXPathExpressionEngine)xPathEngine, pattern, log);
                }
                return AbstractXPathExpressionEngine.extractAndConvertResultAsString(node, dnc, (AbstractXPathExpressionEngine)xPathEngine, pattern, log);
            }
            catch (Exception e) {
                throw new Exception("Trasformazione json2xml '" + tipo + "' fallita: " + e.getMessage() + "\nXml: \n" + node, e);
            }
        }
        if (returnAsList) {
            return JsonPathExpressionEngine.extractAndConvertResultAsList(elementJson, pattern, log);
        }
        return JsonPathExpressionEngine.extractAndConvertResultAsString(elementJson, pattern, log);
    }
}

