/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.redisson.RedissonPriorityQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RPriorityBlockingQueue;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.ListDrainToDecoder;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonPriorityBlockingQueue<V>
extends RedissonPriorityQueue<V>
implements RPriorityBlockingQueue<V> {
    protected RedissonPriorityBlockingQueue(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name, redisson);
    }

    protected RedissonPriorityBlockingQueue(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
    }

    @Override
    public void put(V e) throws InterruptedException {
        this.add(e);
    }

    @Override
    public boolean offer(V e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(e);
    }

    @Override
    public RFuture<V> takeAsync() {
        CompletableFuture result = new CompletableFuture();
        this.takeAsync(result, 0L, 0L, RedisCommands.LPOP, this.getRawName());
        return new CompletableFutureWrapper(result);
    }

    protected <T> void takeAsync(CompletableFuture<V> result, long delay, long timeoutInMicro, RedisCommand<T> command, Object ... params) {
        long start = System.currentTimeMillis();
        this.commandExecutor.getServiceManager().getGroup().schedule(() -> {
            RFuture future = this.wrapLockedAsync(command, params);
            future.whenComplete((res, e) -> {
                if (e != null && !(e instanceof RedisConnectionException)) {
                    result.completeExceptionally((Throwable)e);
                    return;
                }
                if (res != null) {
                    result.complete(res);
                    return;
                }
                if (result.isCancelled()) {
                    return;
                }
                long remain = 0L;
                if (timeoutInMicro > 0L && (remain = timeoutInMicro - (System.currentTimeMillis() - start) * 1000L) <= 0L) {
                    result.complete(null);
                    return;
                }
                long del = ThreadLocalRandom.current().nextInt(2000000);
                if (timeoutInMicro > 0L && remain < 2000000L) {
                    del = 0L;
                }
                this.takeAsync(result, del, remain, command, params);
            });
        }, delay, TimeUnit.MICROSECONDS);
    }

    @Override
    public V take() throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.takeAsync());
    }

    @Override
    public RFuture<V> pollAsync(long timeout, TimeUnit unit) {
        CompletableFuture result = new CompletableFuture();
        this.takeAsync(result, 0L, unit.toMicros(timeout), RedisCommands.LPOP, this.getRawName());
        return new CompletableFutureWrapper(result);
    }

    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollAsync(timeout, unit));
    }

    @Override
    public V pollFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        throw new UnsupportedOperationException("use poll method");
    }

    @Override
    public Map<String, List<V>> pollFirstFromAny(Duration duration, int count, String ... queueNames) throws InterruptedException {
        throw new UnsupportedOperationException("use poll method");
    }

    @Override
    public Map<String, List<V>> pollLastFromAny(Duration duration, int count, String ... queueNames) throws InterruptedException {
        throw new UnsupportedOperationException("use poll method");
    }

    @Override
    public RFuture<Map<String, List<V>>> pollFirstFromAnyAsync(Duration duration, int count, String ... queueNames) {
        throw new UnsupportedOperationException("use poll method");
    }

    @Override
    public RFuture<Map<String, List<V>>> pollLastFromAnyAsync(Duration duration, int count, String ... queueNames) {
        throw new UnsupportedOperationException("use poll method");
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        CompletableFuture result = new CompletableFuture();
        this.takeAsync(result, 0L, unit.toMicros(timeout), RedisCommands.RPOPLPUSH, this.getRawName(), queueName);
        return new CompletableFutureWrapper(result);
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollLastAndOfferFirstToAsync(queueName, timeout, unit));
    }

    @Override
    public V takeLastAndOfferFirstTo(String queueName) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.takeLastAndOfferFirstToAsync(queueName));
    }

    @Override
    public int subscribeOnElements(Consumer<V> consumer) {
        return this.commandExecutor.getServiceManager().getElementsSubscribeService().subscribeOnElements(this::takeAsync, consumer);
    }

    @Override
    public void unsubscribe(int listenerId) {
        this.commandExecutor.getServiceManager().getElementsSubscribeService().unsubscribe(listenerId);
    }

    @Override
    public RFuture<V> takeLastAndOfferFirstToAsync(String queueName) {
        return this.pollLastAndOfferFirstToAsync(queueName, 0L, TimeUnit.SECONDS);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super V> c) {
        this.lock.lock();
        try {
            int n = this.get(this.drainToAsync(c));
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local vals = redis.call('lrange', KEYS[1], 0, -1); redis.call('ltrim', KEYS[1], -1, 0); return vals", Collections.singletonList(this.getRawName()), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super V> c, int maxElements) {
        if (maxElements <= 0) {
            return 0;
        }
        this.lock.lock();
        try {
            int n = this.get(this.drainToAsync(c, maxElements));
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local elemNum = math.min(ARGV[1], redis.call('llen', KEYS[1])) - 1;local vals = redis.call('lrange', KEYS[1], 0, elemNum); redis.call('ltrim', KEYS[1], elemNum + 1, -1); return vals", Collections.singletonList(this.getRawName()), maxElements);
    }

    @Override
    public RFuture<Boolean> offerAsync(V e) {
        throw new UnsupportedOperationException("use offer method");
    }

    @Override
    public RFuture<List<V>> pollAsync(int limit) {
        return this.wrapLockedAsync(() -> this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), this.codec, RedisCommands.EVAL_LIST, "local result = {};for i = 1, ARGV[1], 1 do local value = redis.call('lpop', KEYS[1]);if value ~= false then table.insert(result, value);else return result;end;end; return result;", Collections.singletonList(this.getRawName()), limit));
    }

    @Override
    public RFuture<V> pollFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        throw new UnsupportedOperationException("use poll method");
    }

    @Override
    public RFuture<Void> putAsync(V e) {
        throw new UnsupportedOperationException("use add method");
    }

    @Override
    public List<V> poll(int limit) {
        return this.get(this.pollAsync(limit));
    }
}

