/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.resolver;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.liveobject.resolver.AbstractNamingScheme;
import org.redisson.liveobject.resolver.NamingScheme;

public class DefaultNamingScheme
extends AbstractNamingScheme
implements NamingScheme {
    public DefaultNamingScheme(Codec codec) {
        super(codec);
    }

    @Override
    public String getNamePattern(Class<?> entityClass) {
        return "redisson_live_object:{*}:" + entityClass.getName();
    }

    @Override
    public String getName(Class<?> entityClass, Object idValue) {
        try {
            String encode = DefaultNamingScheme.bytesToHex(this.codec.getMapKeyEncoder().encode(idValue));
            return "redisson_live_object:{" + encode + "}:" + entityClass.getName();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable create name for '" + entityClass + "' with id:" + idValue, ex);
        }
    }

    @Override
    public String getFieldReferenceName(Class<?> entityClass, Object idValue, Class<?> fieldClass, String fieldName) {
        try {
            String encode = DefaultNamingScheme.bytesToHex(this.codec.getMapKeyEncoder().encode(idValue));
            return "redisson_live_object_field:{" + encode + "}:" + entityClass.getName() + ":" + fieldName;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable create name for '" + entityClass + "' and field:'" + fieldName + "' with id:" + idValue, ex);
        }
    }

    @Override
    public Object resolveId(String name) {
        String decode = name.substring(name.indexOf("{") + 1, name.indexOf("}"));
        ByteBuf b = Unpooled.wrappedBuffer((byte[])ByteBufUtil.decodeHexDump((CharSequence)decode));
        try {
            Object object = this.codec.getMapKeyDecoder().decode(b, new State());
            return object;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to decode [" + decode + "] into object", ex);
        }
        finally {
            b.release();
        }
    }

    private static String bytesToHex(ByteBuf bytes) {
        try {
            String string = ByteBufUtil.hexDump((ByteBuf)bytes);
            return string;
        }
        finally {
            bytes.release();
        }
    }

    @Override
    public String getIndexName(Class<?> entityClass, String fieldName) {
        return "redisson_live_object_index:{" + entityClass.getName() + "}:" + fieldName;
    }
}

