/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public class RedisURI {
    private final boolean ssl;
    private final String host;
    private final int port;
    private String username;
    private String password;

    public RedisURI(String scheme, String host, int port) {
        this.ssl = "rediss".equals(scheme);
        this.host = host;
        this.port = port;
    }

    public RedisURI(String uri) {
        if (!uri.startsWith("redis://") && !uri.startsWith("rediss://")) {
            throw new IllegalArgumentException("Redis url should start with redis:// or rediss:// (for SSL connection)");
        }
        if (uri.split(":").length < 3) {
            throw new IllegalArgumentException("Redis url doesn't contain a port");
        }
        String urlHost = this.parseUrl(uri);
        try {
            String[] details;
            URL url = new URL(urlHost);
            if (url.getUserInfo() != null && (details = url.getUserInfo().split(":", 2)).length == 2) {
                if (!details[0].isEmpty()) {
                    this.username = details[0];
                }
                this.password = details[1];
            }
            this.host = url.getHost();
            this.port = url.getPort();
            this.ssl = uri.startsWith("rediss://");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String parseUrl(String uri) {
        int hostStartIndex = uri.indexOf("://") + 3;
        String urlHost = "http://" + uri.substring(hostStartIndex);
        String ipV6Host = uri.substring(hostStartIndex, uri.lastIndexOf(":"));
        if (ipV6Host.contains("@")) {
            ipV6Host = ipV6Host.split("@")[1];
        }
        if (ipV6Host.contains(":")) {
            urlHost = urlHost.replace(ipV6Host, "[" + ipV6Host + "]");
        }
        return urlHost;
    }

    public String getScheme() {
        if (this.ssl) {
            return "rediss";
        }
        return "redis";
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isIP() {
        return NetUtil.createByteArrayFromIpAddressString((String)this.host) != null;
    }

    private String trimIpv6Brackets(String host) {
        if (host.startsWith("[") && host.endsWith("]")) {
            return host.substring(1, host.length() - 1);
        }
        return host;
    }

    public boolean equals(InetSocketAddress entryAddr) {
        return (entryAddr.getHostName() != null && entryAddr.getHostName().equals(this.trimIpv6Brackets(this.getHost())) || entryAddr.getAddress().getHostAddress().equals(this.trimIpv6Brackets(this.getHost()))) && entryAddr.getPort() == this.getPort();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisURI redisURI = (RedisURI)o;
        return this.ssl == redisURI.ssl && this.port == redisURI.port && Objects.equals(this.host, redisURI.host);
    }

    public int hashCode() {
        return Objects.hash(this.ssl, this.host, this.port);
    }

    public String toString() {
        return this.getScheme() + "://" + this.trimIpv6Brackets(this.host) + ":" + this.port;
    }
}

