/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.archive.AbstractArchiveEngine;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingException;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.archive.AbstractArchiveGenericProperties;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveActivePolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveAllarme;
import org.openspcoop2.protocol.sdk.archive.ArchiveAttributeAuthority;
import org.openspcoop2.protocol.sdk.archive.ArchiveConfigurationPolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoDelete;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImportDetail;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImportDetailConfigurazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveFruitore;
import org.openspcoop2.protocol.sdk.archive.ArchiveGruppo;
import org.openspcoop2.protocol.sdk.archive.ArchiveMappingErogazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveMappingFruizione;
import org.openspcoop2.protocol.sdk.archive.ArchivePdd;
import org.openspcoop2.protocol.sdk.archive.ArchivePluginArchivio;
import org.openspcoop2.protocol.sdk.archive.ArchivePluginClasse;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaDelegata;
import org.openspcoop2.protocol.sdk.archive.ArchiveRuolo;
import org.openspcoop2.protocol.sdk.archive.ArchiveScope;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.archive.ArchiveTokenPolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveUrlInvocazioneRegola;
import org.openspcoop2.protocol.sdk.archive.IArchiveObject;
import org.openspcoop2.protocol.sdk.constants.ArchiveStatoImport;
import org.slf4j.Logger;

public class DeleterArchiveUtils {
    private AbstractArchiveEngine importerEngine;
    private Logger log;
    private String userLogin;
    private boolean deletePolicyConfigurazione;
    private boolean deletePluginConfigurazione;
    private ProtocolFactoryManager protocolFactoryManager;
    private static String NEW_LINE = "\n\t\t";
    private static boolean NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO = false;

    public DeleterArchiveUtils(AbstractArchiveEngine importerEngine, Logger log, String userLogin, boolean deletePolicyConfigurazione, boolean deletePluginConfigurazione) throws Exception {
        this.importerEngine = importerEngine;
        this.log = log;
        this.userLogin = userLogin;
        this.deletePolicyConfigurazione = deletePolicyConfigurazione;
        this.deletePluginConfigurazione = deletePluginConfigurazione;
        this.protocolFactoryManager = ProtocolFactoryManager.getInstance();
    }

    public ArchiveEsitoDelete deleteArchive(Archive archive, String userLogin) throws Exception, ImportInformationMissingException {
        int i;
        ArchiveEsitoImportDetail detail;
        boolean existsParteSpecifica;
        int i2;
        ArchiveEsitoDelete esito = new ArchiveEsitoDelete();
        HashMap<String, IDSoggetto> mapIdSoggettoDefault = new HashMap<String, IDSoggetto>();
        HashMap<String, Boolean> mapAPIconReferente = new HashMap<String, Boolean>();
        if (this.protocolFactoryManager == null) {
            throw new Exception("ProtocolFactoryManager not initialized");
        }
        Enumeration pEnum = this.protocolFactoryManager.getProtocolFactories().keys();
        if (pEnum != null) {
            while (pEnum.hasMoreElements()) {
                String protocollo = (String)pEnum.nextElement();
                IDSoggetto soggettoDefaultProtocollo = this.importerEngine.getSoggettoDefault(protocollo);
                if (soggettoDefaultProtocollo == null) {
                    throw new Exception("IDSoggetto di default non trovato per il protocollo '" + protocollo + "'");
                }
                mapIdSoggettoDefault.put(protocollo, soggettoDefaultProtocollo);
                IProtocolFactory<?> pf = this.protocolFactoryManager.getProtocolFactoryByName(protocollo);
                boolean supportoReferente = false;
                if (pf != null) {
                    supportoReferente = pf.createProtocolConfiguration().isSupportoSoggettoReferenteAccordiParteComune();
                }
                mapAPIconReferente.put(protocollo, supportoReferente);
            }
        }
        ArrayList<MappingErogazionePortaApplicativa> listMappingErogazionePA = new ArrayList<MappingErogazionePortaApplicativa>();
        ArrayList<MappingFruizionePortaDelegata> listMappingFruizionePD = new ArrayList<MappingFruizionePortaDelegata>();
        for (i2 = 0; i2 < archive.getAccordiServizioParteSpecifica().size(); ++i2) {
            ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica = (ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i2);
            archiveAccordoServizioParteSpecifica.update();
            if (archiveAccordoServizioParteSpecifica.getMappingPorteApplicativeAssociate() == null || archiveAccordoServizioParteSpecifica.getMappingPorteApplicativeAssociate().size() <= 0) continue;
            List<IDPortaApplicativa> idPACheck = null;
            existsParteSpecifica = false;
            try {
                existsParteSpecifica = this.importerEngine.existsAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica());
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean existsIDPorteApplicativeAssociateErogazione = false;
            try {
                existsIDPorteApplicativeAssociateErogazione = this.importerEngine.existsIDPorteApplicativeAssociateErogazione(archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (existsParteSpecifica && existsIDPorteApplicativeAssociateErogazione) {
                idPACheck = this.importerEngine.getIDPorteApplicativeAssociateErogazione(archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica());
            }
            for (MappingErogazionePortaApplicativa mappingPorteApplicativeAssociata : archiveAccordoServizioParteSpecifica.getMappingPorteApplicativeAssociate()) {
                if (idPACheck == null || idPACheck.size() <= 0 || !idPACheck.contains(mappingPorteApplicativeAssociata.getIdPortaApplicativa())) continue;
                listMappingErogazionePA.add(mappingPorteApplicativeAssociata);
            }
        }
        for (i2 = 0; i2 < archive.getAccordiFruitori().size(); ++i2) {
            ArchiveFruitore archiveFruitore = (ArchiveFruitore)archive.getAccordiFruitori().get(i2);
            archiveFruitore.update();
            if (archiveFruitore.getMappingPorteDelegateAssociate() == null || archiveFruitore.getMappingPorteDelegateAssociate().size() <= 0) continue;
            List<IDPortaDelegata> idPDCheck = null;
            existsParteSpecifica = false;
            try {
                existsParteSpecifica = this.importerEngine.existsAccordoServizioParteSpecifica(archiveFruitore.getIdAccordoServizioParteSpecifica());
            }
            catch (Exception existsIDPorteApplicativeAssociateErogazione) {
                // empty catch block
            }
            boolean existsIDPorteDelegateAssociateFruizione = false;
            try {
                existsIDPorteDelegateAssociateFruizione = this.importerEngine.existsIDPorteDelegateAssociateFruizione(archiveFruitore.getIdAccordoServizioParteSpecifica(), archiveFruitore.getIdSoggettoFruitore());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (existsParteSpecifica && existsIDPorteDelegateAssociateFruizione) {
                idPDCheck = this.importerEngine.getIDPorteDelegateAssociateFruizione(archiveFruitore.getIdAccordoServizioParteSpecifica(), archiveFruitore.getIdSoggettoFruitore());
            }
            for (MappingFruizionePortaDelegata mappingPorteDelegateAssociata : archiveFruitore.getMappingPorteDelegateAssociate()) {
                if (idPDCheck == null || idPDCheck.size() <= 0 || !idPDCheck.contains(mappingPorteDelegateAssociata.getIdPortaDelegata())) continue;
                listMappingFruizionePD.add(mappingPorteDelegateAssociata);
            }
        }
        if (listMappingErogazionePA.size() > 0) {
            for (i2 = 0; i2 < listMappingErogazionePA.size(); ++i2) {
                MappingErogazionePortaApplicativa mapping = (MappingErogazionePortaApplicativa)listMappingErogazionePA.get(i2);
                ArchiveMappingErogazione archiveMappingErogazione = new ArchiveMappingErogazione(mapping);
                ArchiveEsitoImportDetail detail2 = new ArchiveEsitoImportDetail((IArchiveObject)archiveMappingErogazione);
                try {
                    if (this.importerEngine.existsMappingErogazione(mapping.getIdServizio(), mapping.getIdPortaApplicativa())) {
                        this.importerEngine.deleteMappingErogazione(mapping.getIdServizio(), mapping.getIdPortaApplicativa());
                        detail2.setState(ArchiveStatoImport.DELETED);
                    } else {
                        detail2.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                    }
                }
                catch (Exception e) {
                    this.log.error("Errore durante l'eliminazione del mapping di erogazione del servizio [" + mapping.getIdServizio() + "] verso la porta applicativa [" + mapping.getIdPortaApplicativa().getNome() + "]: " + e.getMessage(), (Throwable)e);
                    detail2.setState(ArchiveStatoImport.ERROR);
                    detail2.setException((Throwable)e);
                }
                esito.getMappingErogazioni().add((Object)detail2);
            }
        }
        if (listMappingFruizionePD.size() > 0) {
            for (i2 = 0; i2 < listMappingFruizionePD.size(); ++i2) {
                MappingFruizionePortaDelegata mapping = (MappingFruizionePortaDelegata)listMappingFruizionePD.get(i2);
                ArchiveMappingFruizione archiveMappingFruizione = new ArchiveMappingFruizione(mapping);
                ArchiveEsitoImportDetail detail3 = new ArchiveEsitoImportDetail((IArchiveObject)archiveMappingFruizione);
                try {
                    if (this.importerEngine.existsMappingFruizione(mapping.getIdServizio(), mapping.getIdFruitore(), mapping.getIdPortaDelegata())) {
                        this.importerEngine.deleteMappingFruizione(mapping.getIdServizio(), mapping.getIdFruitore(), mapping.getIdPortaDelegata());
                        detail3.setState(ArchiveStatoImport.DELETED);
                    } else {
                        detail3.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                    }
                }
                catch (Exception e) {
                    this.log.error("Errore durante l'eliminazione del mapping di fruizione del servizio [" + mapping.getIdServizio() + "] verso la porta delegata [" + mapping.getIdPortaDelegata().getNome() + "] da parte del soggetto [" + mapping.getIdFruitore() + "]: " + e.getMessage(), (Throwable)e);
                    detail3.setState(ArchiveStatoImport.ERROR);
                    detail3.setException((Throwable)e);
                }
                esito.getMappingFruizioni().add((Object)detail3);
            }
        }
        for (i2 = 0; i2 < archive.getPorteApplicative().size(); ++i2) {
            ArchivePortaApplicativa archivePortaApplicativa = (ArchivePortaApplicativa)archive.getPorteApplicative().get(i2);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archivePortaApplicativa);
            try {
                archivePortaApplicativa.update();
                if (archivePortaApplicativa.getIdServizio() != null) {
                    try {
                        if (this.importerEngine.existsMappingErogazione(archivePortaApplicativa.getIdServizio(), archivePortaApplicativa.getIdPortaApplicativa())) {
                            this.importerEngine.deleteMappingErogazione(archivePortaApplicativa.getIdServizio(), archivePortaApplicativa.getIdPortaApplicativa());
                        }
                    }
                    catch (Exception e) {
                        this.log.debug("Errore durante l'eliminazione del mapping di erogazione del servizio [" + archivePortaApplicativa.getIdServizio() + "] verso la porta applicativa [" + archivePortaApplicativa.getIdPortaApplicativa() + "]: " + e.getMessage(), (Throwable)e);
                    }
                }
                this.deletePortaApplicativa(archivePortaApplicativa, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getPorteApplicative().add((Object)detail);
        }
        for (i2 = 0; i2 < archive.getControlloTraffico_activePolicies().size(); ++i2) {
            ArchiveActivePolicy archivePolicy = (ArchiveActivePolicy)archive.getControlloTraffico_activePolicies().get(i2);
            if (archivePolicy.isPolicyGlobale() || !RuoloPolicy.APPLICATIVA.equals((Object)archivePolicy.getRuoloPorta())) continue;
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archivePolicy);
            try {
                this.deleteActivePolicy(archivePolicy, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getControlloTraffico_activePolicies().add((Object)detail);
        }
        for (i2 = 0; i2 < archive.getPorteDelegate().size(); ++i2) {
            ArchivePortaDelegata archivePortaDelegata = (ArchivePortaDelegata)archive.getPorteDelegate().get(i2);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archivePortaDelegata);
            try {
                PortaDelegata pd;
                archivePortaDelegata.update();
                if (archivePortaDelegata.getIdSoggettoProprietario() != null && (pd = archivePortaDelegata.getPortaDelegata()).getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && pd.getServizio() != null && pd.getServizio().getNome() != null) {
                    IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pd.getServizio().getTipo(), pd.getServizio().getNome(), new IDSoggetto(pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()), pd.getServizio().getVersione().intValue());
                    try {
                        if (this.importerEngine.existsMappingFruizione(idServizio, archivePortaDelegata.getIdSoggettoProprietario(), archivePortaDelegata.getIdPortaDelegata())) {
                            this.importerEngine.deleteMappingFruizione(idServizio, archivePortaDelegata.getIdSoggettoProprietario(), archivePortaDelegata.getIdPortaDelegata());
                        }
                    }
                    catch (Exception e) {
                        this.log.debug("Errore durante l'eliminazione del mapping di fruizione del servizio [" + idServizio + "] verso la porta delegata [" + archivePortaDelegata.getIdPortaDelegata() + "] da parte del soggetto [" + archivePortaDelegata.getIdSoggettoProprietario() + "]: " + e.getMessage(), (Throwable)e);
                    }
                }
                this.deletePortaDelegata(archivePortaDelegata, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getPorteDelegate().add((Object)detail);
        }
        for (i2 = 0; i2 < archive.getControlloTraffico_activePolicies().size(); ++i2) {
            ArchiveActivePolicy archivePolicy = (ArchiveActivePolicy)archive.getControlloTraffico_activePolicies().get(i2);
            if (archivePolicy.isPolicyGlobale() || !RuoloPolicy.DELEGATA.equals((Object)archivePolicy.getRuoloPorta())) continue;
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archivePolicy);
            try {
                this.deleteActivePolicy(archivePolicy, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getControlloTraffico_activePolicies().add((Object)detail);
        }
        for (i2 = 0; i2 < archive.getAccordiFruitori().size(); ++i2) {
            ArchiveFruitore archiveFruitore = (ArchiveFruitore)archive.getAccordiFruitori().get(i2);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archiveFruitore);
            try {
                if (archiveFruitore.getIdAccordoServizioParteSpecifica() != null && this.importerEngine.existsIDPorteDelegateAssociateFruizione(archiveFruitore.getIdAccordoServizioParteSpecifica(), archiveFruitore.getIdSoggettoFruitore())) {
                    this.importerEngine.deleteMappingFruizione(archiveFruitore.getIdAccordoServizioParteSpecifica(), archiveFruitore.getIdSoggettoFruitore());
                }
                this.deleteFruitore(archiveFruitore, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getAccordiFruitori().add((Object)detail);
        }
        ArrayList<ArchiveAccordoServizioParteSpecifica> listAccordiServizioParteSpecifica = new ArrayList<ArchiveAccordoServizioParteSpecifica>();
        ArrayList<ArchiveAccordoServizioParteSpecifica> listAccordiServizioParteSpecifica_serviziComposti = new ArrayList<ArchiveAccordoServizioParteSpecifica>();
        for (i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica = (ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i);
            IDAccordo idAccordo = archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteComune();
            if (this.importerEngine.existsAccordoServizioParteComune(idAccordo)) {
                AccordoServizioParteComune aspc = this.importerEngine.getAccordoServizioParteComune(idAccordo);
                if (aspc.getServizioComposto() != null) {
                    listAccordiServizioParteSpecifica_serviziComposti.add(archiveAccordoServizioParteSpecifica);
                    continue;
                }
                listAccordiServizioParteSpecifica.add(archiveAccordoServizioParteSpecifica);
                continue;
            }
            listAccordiServizioParteSpecifica_serviziComposti.add(archiveAccordoServizioParteSpecifica);
        }
        for (i = 0; i < listAccordiServizioParteSpecifica_serviziComposti.size(); ++i) {
            ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica = (ArchiveAccordoServizioParteSpecifica)listAccordiServizioParteSpecifica_serviziComposti.get(i);
            ArchiveEsitoImportDetail detail4 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioParteSpecifica);
            try {
                if (archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica() != null && this.importerEngine.existsIDPorteApplicativeAssociateErogazione(archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica())) {
                    this.importerEngine.deleteMappingErogazione(archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica());
                }
                this.deleteAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica, true, detail4);
            }
            catch (Exception e) {
                detail4.setState(ArchiveStatoImport.ERROR);
                detail4.setException((Throwable)e);
            }
            esito.getAccordiServizioParteSpecificaServiziComposti().add((Object)detail4);
        }
        for (i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
            ArchiveAccordoServizioComposto archiveAccordoServizioComposto = (ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i);
            ArchiveEsitoImportDetail detail5 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioComposto);
            try {
                archiveAccordoServizioComposto.update();
                this.deleteAccordoServizioComposto(archiveAccordoServizioComposto, detail5, mapIdSoggettoDefault, mapAPIconReferente);
            }
            catch (Exception e) {
                detail5.setState(ArchiveStatoImport.ERROR);
                detail5.setException((Throwable)e);
            }
            esito.getAccordiServizioComposto().add((Object)detail5);
        }
        for (i = 0; i < listAccordiServizioParteSpecifica.size(); ++i) {
            ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica = (ArchiveAccordoServizioParteSpecifica)listAccordiServizioParteSpecifica.get(i);
            ArchiveEsitoImportDetail detail6 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioParteSpecifica);
            try {
                if (archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica() != null && this.importerEngine.existsIDPorteApplicativeAssociateErogazione(archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica())) {
                    this.importerEngine.deleteMappingErogazione(archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica());
                }
                this.deleteAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica, false, detail6);
            }
            catch (Exception e) {
                detail6.setState(ArchiveStatoImport.ERROR);
                detail6.setException((Throwable)e);
            }
            esito.getAccordiServizioParteSpecifica().add((Object)detail6);
        }
        for (i = 0; i < archive.getAccordiServizioParteComune().size(); ++i) {
            ArchiveAccordoServizioParteComune archiveAccordoServizioParteComune = (ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i);
            ArchiveEsitoImportDetail detail7 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioParteComune);
            try {
                archiveAccordoServizioParteComune.update();
                this.deleteAccordoServizioParteComune(archiveAccordoServizioParteComune, detail7, mapIdSoggettoDefault, mapAPIconReferente);
            }
            catch (Exception e) {
                detail7.setState(ArchiveStatoImport.ERROR);
                detail7.setException((Throwable)e);
            }
            esito.getAccordiServizioParteComune().add((Object)detail7);
        }
        for (i = 0; i < archive.getAccordiCooperazione().size(); ++i) {
            ArchiveAccordoCooperazione archiveAccordoCooperazione = (ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i);
            ArchiveEsitoImportDetail detail8 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoCooperazione);
            try {
                archiveAccordoCooperazione.update();
                this.deleteAccordoCooperazione(archiveAccordoCooperazione, detail8);
            }
            catch (Exception e) {
                detail8.setState(ArchiveStatoImport.ERROR);
                detail8.setException((Throwable)e);
            }
            esito.getAccordiCooperazione().add((Object)detail8);
        }
        for (i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            ArchiveServizioApplicativo archiveServizioApplicativo = (ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i);
            ArchiveEsitoImportDetail detail9 = new ArchiveEsitoImportDetail((IArchiveObject)archiveServizioApplicativo);
            try {
                archiveServizioApplicativo.update();
                this.deleteServizioApplicativo(archiveServizioApplicativo, detail9);
            }
            catch (Exception e) {
                detail9.setState(ArchiveStatoImport.ERROR);
                detail9.setException((Throwable)e);
            }
            esito.getServiziApplicativi().add((Object)detail9);
        }
        for (i = 0; i < archive.getSoggetti().size(); ++i) {
            ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)archive.getSoggetti().get(i);
            ArchiveEsitoImportDetail detail10 = new ArchiveEsitoImportDetail((IArchiveObject)archiveSoggetto);
            try {
                this.deleteSoggetto(archiveSoggetto, detail10);
            }
            catch (Exception e) {
                detail10.setState(ArchiveStatoImport.ERROR);
                detail10.setException((Throwable)e);
            }
            esito.getSoggetti().add((Object)detail10);
        }
        for (i = 0; i < archive.getGruppi().size(); ++i) {
            ArchiveGruppo archiveGruppo = (ArchiveGruppo)archive.getGruppi().get(i);
            ArchiveEsitoImportDetail detail11 = new ArchiveEsitoImportDetail((IArchiveObject)archiveGruppo);
            try {
                this.deleteGruppo(archiveGruppo, detail11);
            }
            catch (Exception e) {
                detail11.setState(ArchiveStatoImport.ERROR);
                detail11.setException((Throwable)e);
            }
            esito.getGruppi().add((Object)detail11);
        }
        for (i = 0; i < archive.getRuoli().size(); ++i) {
            ArchiveRuolo archiveRuolo = (ArchiveRuolo)archive.getRuoli().get(i);
            ArchiveEsitoImportDetail detail12 = new ArchiveEsitoImportDetail((IArchiveObject)archiveRuolo);
            try {
                this.deleteRuolo(archiveRuolo, detail12);
            }
            catch (Exception e) {
                detail12.setState(ArchiveStatoImport.ERROR);
                detail12.setException((Throwable)e);
            }
            esito.getRuoli().add((Object)detail12);
        }
        for (i = 0; i < archive.getScope().size(); ++i) {
            ArchiveScope archiveScope = (ArchiveScope)archive.getScope().get(i);
            ArchiveEsitoImportDetail detail13 = new ArchiveEsitoImportDetail((IArchiveObject)archiveScope);
            try {
                this.deleteScope(archiveScope, detail13);
            }
            catch (Exception e) {
                detail13.setState(ArchiveStatoImport.ERROR);
                detail13.setException((Throwable)e);
            }
            esito.getScope().add((Object)detail13);
        }
        for (i = 0; i < archive.getPdd().size(); ++i) {
            ArchivePdd archivePdd = (ArchivePdd)archive.getPdd().get(i);
            ArchiveEsitoImportDetail detail14 = new ArchiveEsitoImportDetail((IArchiveObject)archivePdd);
            try {
                this.deletePdd(archivePdd, detail14);
            }
            catch (Exception e) {
                detail14.setState(ArchiveStatoImport.ERROR);
                detail14.setException((Throwable)e);
            }
            esito.getPdd().add((Object)detail14);
        }
        for (i = 0; i < archive.getAllarmi().size(); ++i) {
            ArchiveAllarme archiveAllarme = (ArchiveAllarme)archive.getAllarmi().get(i);
            ArchiveEsitoImportDetail detail15 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAllarme);
            try {
                this.deleteAllarme(archiveAllarme, detail15);
            }
            catch (Exception e) {
                detail15.setState(ArchiveStatoImport.ERROR);
                detail15.setException((Throwable)e);
            }
            esito.getAllarmi().add((Object)detail15);
        }
        for (i = 0; i < archive.getControlloTraffico_activePolicies().size(); ++i) {
            ArchiveActivePolicy archivePolicy = (ArchiveActivePolicy)archive.getControlloTraffico_activePolicies().get(i);
            ArchiveEsitoImportDetail detail16 = new ArchiveEsitoImportDetail((IArchiveObject)archivePolicy);
            if (esito.getControlloTraffico_activePolicies().containsKey(detail16.key())) continue;
            try {
                this.deleteActivePolicy(archivePolicy, detail16);
            }
            catch (Exception e) {
                detail16.setState(ArchiveStatoImport.ERROR);
                detail16.setException((Throwable)e);
            }
            esito.getControlloTraffico_activePolicies().add((Object)detail16);
        }
        for (i = 0; i < archive.getControlloTraffico_configurationPolicies().size(); ++i) {
            ArchiveConfigurationPolicy archivePolicy = (ArchiveConfigurationPolicy)archive.getControlloTraffico_configurationPolicies().get(i);
            ArchiveEsitoImportDetail detail17 = new ArchiveEsitoImportDetail((IArchiveObject)archivePolicy);
            try {
                this.deleteConfigPolicy(archivePolicy, detail17);
            }
            catch (Exception e) {
                detail17.setState(ArchiveStatoImport.ERROR);
                detail17.setException((Throwable)e);
            }
            esito.getControlloTraffico_configurationPolicies().add((Object)detail17);
        }
        for (i = 0; i < archive.getToken_validation_policies().size(); ++i) {
            ArchiveTokenPolicy archivePolicy = (ArchiveTokenPolicy)archive.getToken_validation_policies().get(i);
            ArchiveEsitoImportDetail detail18 = new ArchiveEsitoImportDetail((IArchiveObject)archivePolicy);
            try {
                this.deleteTokenPolicy(archivePolicy, detail18);
            }
            catch (Exception e) {
                detail18.setState(ArchiveStatoImport.ERROR);
                detail18.setException((Throwable)e);
            }
            esito.getToken_validation_policies().add((Object)detail18);
        }
        for (i = 0; i < archive.getToken_retrieve_policies().size(); ++i) {
            ArchiveTokenPolicy archivePolicy = (ArchiveTokenPolicy)archive.getToken_retrieve_policies().get(i);
            ArchiveEsitoImportDetail detail19 = new ArchiveEsitoImportDetail((IArchiveObject)archivePolicy);
            try {
                this.deleteTokenPolicy(archivePolicy, detail19);
            }
            catch (Exception e) {
                detail19.setState(ArchiveStatoImport.ERROR);
                detail19.setException((Throwable)e);
            }
            esito.getToken_retrieve_policies().add((Object)detail19);
        }
        for (i = 0; i < archive.getAttributeAuthorities().size(); ++i) {
            ArchiveAttributeAuthority archiveAttributeAuthority = (ArchiveAttributeAuthority)archive.getAttributeAuthorities().get(i);
            ArchiveEsitoImportDetail detail20 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAttributeAuthority);
            try {
                this.deleteAttributeAuthority(archiveAttributeAuthority, detail20);
            }
            catch (Exception e) {
                detail20.setState(ArchiveStatoImport.ERROR);
                detail20.setException((Throwable)e);
            }
            esito.getAttributeAuthorities().add((Object)detail20);
        }
        for (i = 0; i < archive.getPlugin_classi().size(); ++i) {
            ArchivePluginClasse archiveClasse = (ArchivePluginClasse)archive.getPlugin_classi().get(i);
            ArchiveEsitoImportDetail detail21 = new ArchiveEsitoImportDetail((IArchiveObject)archiveClasse);
            try {
                this.deletePluginClasse(archiveClasse, detail21);
            }
            catch (Exception e) {
                detail21.setState(ArchiveStatoImport.ERROR);
                detail21.setException((Throwable)e);
            }
            esito.getPlugin_classi().add((Object)detail21);
        }
        for (i = 0; i < archive.getPlugin_archivi().size(); ++i) {
            ArchivePluginArchivio archivePlugin = (ArchivePluginArchivio)archive.getPlugin_archivi().get(i);
            ArchiveEsitoImportDetail detail22 = new ArchiveEsitoImportDetail((IArchiveObject)archivePlugin);
            try {
                this.deletePluginArchivio(archivePlugin, detail22);
            }
            catch (Exception e) {
                detail22.setState(ArchiveStatoImport.ERROR);
                detail22.setException((Throwable)e);
            }
            esito.getPlugin_archivi().add((Object)detail22);
        }
        for (i = 0; i < archive.getConfigurazionePdD_urlInvocazione_regole().size(); ++i) {
            ArchiveUrlInvocazioneRegola archiveRegola = (ArchiveUrlInvocazioneRegola)archive.getConfigurazionePdD_urlInvocazione_regole().get(i);
            ArchiveEsitoImportDetail detail23 = new ArchiveEsitoImportDetail((IArchiveObject)archiveRegola);
            try {
                this.deleteUrlInvocazioneRegola(archiveRegola, detail23);
            }
            catch (Exception e) {
                detail23.setState(ArchiveStatoImport.ERROR);
                detail23.setException((Throwable)e);
            }
            esito.getConfigurazionePdD_urlInvocazione_regole().add((Object)detail23);
        }
        if (archive.getConfigurazionePdD() != null && archive.getConfigurazionePdD().sizeExtendedInfoList() > 0) {
            Configurazione newConfig = new Configurazione();
            newConfig.getExtendedInfoList().addAll(archive.getConfigurazionePdD().getExtendedInfoList());
            ArchiveEsitoImportDetailConfigurazione detail24 = new ArchiveEsitoImportDetailConfigurazione((Object)newConfig);
            try {
                this.deleteConfigurazione(newConfig, (ArchiveEsitoImportDetailConfigurazione<Configurazione>)detail24);
            }
            catch (Exception e) {
                detail24.setState(ArchiveStatoImport.ERROR);
                detail24.setException((Throwable)e);
            }
            esito.setConfigurazionePdD(detail24);
        }
        this.importerEngine.finalizeDelete(archive);
        return esito;
    }

    public void deleteConfigurazione(Configurazione config, ArchiveEsitoImportDetailConfigurazione<Configurazione> detail) {
        try {
            this.importerEngine.deleteConfigurazione(config);
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione della configurazione: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteConfigPolicy(ArchiveConfigurationPolicy archivePolicy, ArchiveEsitoImportDetail detail) {
        String nomePolicy = archivePolicy.getNomePolicy();
        try {
            if (!this.deletePolicyConfigurazione) {
                detail.setState(ArchiveStatoImport.DELETED_POLICY_CONFIG_NOT_ENABLED);
                return;
            }
            if (!this.importerEngine.existsControlloTraffico_configurationPolicy(nomePolicy)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            ArrayList<String> whereIsInUso = new ArrayList<String>();
            if (this.importerEngine.isControlloTraffico_configurationPolicyInUso(nomePolicy, whereIsInUso)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(nomePolicy, whereIsInUso, false, NEW_LINE));
            }
            this.importerEngine.deleteControlloTraffico_configurationPolicy(archivePolicy.getPolicy());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione della configurazione della policy [" + nomePolicy + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteActivePolicy(ArchiveActivePolicy archivePolicy, ArchiveEsitoImportDetail detail) {
        AttivazionePolicy attivazionePolicy = archivePolicy.getPolicy();
        String aliasPolicy = archivePolicy.getAliasPolicy();
        RuoloPolicy ruoloPorta = archivePolicy.getRuoloPorta();
        String nomePorta = archivePolicy.getNomePorta();
        Object tipoPolicy = "configurazione";
        if (ruoloPorta != null && nomePorta != null) {
            tipoPolicy = ruoloPorta.toString() + " " + nomePorta;
        }
        try {
            boolean policyGlobale = archivePolicy.isPolicyGlobale();
            if (policyGlobale && !this.deletePolicyConfigurazione) {
                detail.setState(ArchiveStatoImport.DELETED_POLICY_CONFIG_NOT_ENABLED);
                return;
            }
            if (!this.importerEngine.existsControlloTraffico_activePolicy(ruoloPorta, nomePorta, attivazionePolicy.getAlias())) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            ArrayList<String> whereIsInUso = new ArrayList<String>();
            if (this.importerEngine.isControlloTraffico_activePolicyInUso(ruoloPorta, nomePorta, attivazionePolicy.getAlias(), whereIsInUso)) {
                // empty if block
            }
            this.importerEngine.deleteControlloTraffico_activePolicy(archivePolicy.getPolicy());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione dell'attivazione della policy [" + aliasPolicy + "] (" + (String)tipoPolicy + "): " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteAllarme(ArchiveAllarme archiveAllarme, ArchiveEsitoImportDetail detail) {
        Allarme allarme = archiveAllarme.getAllarme();
        String alias = archiveAllarme.getAlias();
        RuoloPorta ruoloPorta = archiveAllarme.getRuoloPorta();
        String nomePorta = archiveAllarme.getNomePorta();
        Object tipoAllarme = "configurazione";
        if (ruoloPorta != null && nomePorta != null) {
            tipoAllarme = ruoloPorta.toString() + " " + nomePorta;
        }
        try {
            boolean allarmeGlobale = archiveAllarme.isAllarmeGlobale();
            if (allarmeGlobale && !this.deletePolicyConfigurazione) {
                detail.setState(ArchiveStatoImport.DELETED_POLICY_CONFIG_NOT_ENABLED);
                return;
            }
            if (!this.importerEngine.existsAllarme(ruoloPorta, nomePorta, allarme.getAlias())) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            ArrayList<String> whereIsInUso = new ArrayList<String>();
            if (this.importerEngine.isAllarmeInUso(ruoloPorta, nomePorta, allarme.getAlias(), whereIsInUso)) {
                // empty if block
            }
            this.importerEngine.deleteAllarme(archiveAllarme.getAllarme(), this.log);
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione dell'allarme [" + alias + "] (" + (String)tipoAllarme + "): " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteTokenPolicy(ArchiveTokenPolicy archivePolicy, ArchiveEsitoImportDetail detail) {
        this._deleteGenericProperties("Token Policy", (AbstractArchiveGenericProperties)archivePolicy, detail);
    }

    public void deleteAttributeAuthority(ArchiveAttributeAuthority archiveAA, ArchiveEsitoImportDetail detail) {
        this._deleteGenericProperties("Attribute Authority", (AbstractArchiveGenericProperties)archiveAA, detail);
    }

    public void _deleteGenericProperties(String oggetto, AbstractArchiveGenericProperties archiveGenericProperties, ArchiveEsitoImportDetail detail) {
        String nomePolicy = archiveGenericProperties.getNomePolicy();
        String tipologiaPolicy = archiveGenericProperties.getTipologiaPolicy();
        try {
            if (!this.deletePolicyConfigurazione) {
                detail.setState(ArchiveStatoImport.DELETED_POLICY_CONFIG_NOT_ENABLED);
                return;
            }
            if (!this.importerEngine.existsGenericProperties(tipologiaPolicy, nomePolicy)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isGenericPropertiesInUso(tipologiaPolicy, nomePolicy, whereIsInUso, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO)) {
                IDGenericProperties idGP = new IDGenericProperties();
                idGP.setNome(nomePolicy);
                idGP.setTipologia(tipologiaPolicy);
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idGP, whereIsInUso, false, NEW_LINE));
            }
            this.importerEngine.deleteGenericProperties(archiveGenericProperties.getPolicy());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione della configurazione '" + oggetto + ")' [" + nomePolicy + "] (tipo: '" + tipologiaPolicy + "'): " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deletePluginClasse(ArchivePluginClasse archivePluginClasse, ArchiveEsitoImportDetail detail) {
        String tipoPlugin = archivePluginClasse.getTipoPlugin();
        String tipo = archivePluginClasse.getTipo();
        try {
            if (!this.deletePluginConfigurazione) {
                detail.setState(ArchiveStatoImport.DELETED_PLUGIN_CONFIG_NOT_ENABLED);
                return;
            }
            if (!this.importerEngine.existsPluginClasse(archivePluginClasse.getTipoPlugin(), archivePluginClasse.getTipo())) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            IdPlugin idPlugin = new IdPlugin();
            idPlugin.setTipoPlugin(archivePluginClasse.getTipoPlugin());
            idPlugin.setTipo(archivePluginClasse.getTipo());
            idPlugin.setLabel(archivePluginClasse.getPlugin().getLabel());
            idPlugin.setClassName(archivePluginClasse.getPlugin().getClassName());
            if (this.importerEngine.isPluginClasseInUso(idPlugin, whereIsInUso, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(archivePluginClasse.getPlugin().getClassName(), archivePluginClasse.getPlugin().getLabel(), archivePluginClasse.getTipoPlugin(), archivePluginClasse.getTipo(), whereIsInUso, false, NEW_LINE));
            }
            this.importerEngine.deletePluginClasse(archivePluginClasse.getPlugin());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione del plugin [" + tipo + "] (tipo-plugin: '" + tipoPlugin + "'): " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deletePluginArchivio(ArchivePluginArchivio archivePluginArchivio, ArchiveEsitoImportDetail detail) {
        String nome = archivePluginArchivio.getNome();
        try {
            if (!this.deletePluginConfigurazione) {
                detail.setState(ArchiveStatoImport.DELETED_PLUGIN_CONFIG_NOT_ENABLED);
                return;
            }
            if (!this.importerEngine.existsPluginArchivio(archivePluginArchivio.getNome())) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isPluginArchivioInUso(archivePluginArchivio.getNome(), whereIsInUso, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO)) {
                // empty if block
            }
            this.importerEngine.deletePluginArchivio(archivePluginArchivio.getPlugin());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione dell'archivio dei plugin [" + nome + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteUrlInvocazioneRegola(ArchiveUrlInvocazioneRegola archiveUrlInvocazioneRegola, ArchiveEsitoImportDetail detail) {
        String nome = archiveUrlInvocazioneRegola.getNome();
        try {
            if (!this.deletePolicyConfigurazione) {
                detail.setState(ArchiveStatoImport.DELETED_POLICY_CONFIG_NOT_ENABLED);
                return;
            }
            if (!this.importerEngine.existsUrlInvocazioneRegola(archiveUrlInvocazioneRegola.getNome())) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isUrlInvocazioneRegolaInUso(archiveUrlInvocazioneRegola.getNome(), whereIsInUso, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO)) {
                // empty if block
            }
            this.importerEngine.deleteUrlInvocazioneRegola(archiveUrlInvocazioneRegola.getRegola());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione della regola di proxy pass [" + nome + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deletePdd(ArchivePdd archivePdd, ArchiveEsitoImportDetail detail) {
        String nomePdd = archivePdd.getNomePdd();
        try {
            if (!this.importerEngine.existsPortaDominio(nomePdd)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            PortaDominio pddReadFromDb = this.importerEngine.getPortaDominio(nomePdd);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(pddReadFromDb.getSuperUser())) {
                throw new Exception("La Porta di Dominio [" + nomePdd + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            String tipoPdd = this.importerEngine.getTipoPortaDominio(nomePdd);
            if (!PddTipologia.ESTERNO.equals(tipoPdd)) {
                throw new Exception("Porta di Dominio [" + nomePdd + "] non \u00e8 eliminabile poich\u00e8 di dominio interno");
            }
            if (PddTipologia.OPERATIVO.toString().equals(this.importerEngine.getTipoPortaDominio(nomePdd))) {
                throw new Exception("La Porta di Dominio [" + nomePdd + "] non \u00e8 eliminabile essendo di tipo '" + PddTipologia.OPERATIVO.toString() + "'");
            }
            ArrayList<String> whereIsInUso = new ArrayList<String>();
            if (this.importerEngine.isPddInUso(nomePdd, whereIsInUso, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(nomePdd, whereIsInUso, false, NEW_LINE));
            }
            this.importerEngine.deletePortaDominio(archivePdd.getPortaDominio());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione della porta di dominio [" + nomePdd + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteGruppo(ArchiveGruppo archiveGruppo, ArchiveEsitoImportDetail detail) {
        IDGruppo idGruppo = archiveGruppo.getIdGruppo();
        try {
            if (!this.importerEngine.existsGruppo(idGruppo)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            Gruppo gruppoReadFromDb = this.importerEngine.getGruppo(idGruppo);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(gruppoReadFromDb.getSuperUser())) {
                throw new Exception("Il Gruppo [" + idGruppo + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isGruppoInUso(idGruppo, whereIsInUso, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idGruppo, whereIsInUso, false, NEW_LINE));
            }
            this.importerEngine.deleteGruppo(archiveGruppo.getGruppo());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione del gruppo [" + idGruppo + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteRuolo(ArchiveRuolo archiveRuolo, ArchiveEsitoImportDetail detail) {
        IDRuolo idRuolo = archiveRuolo.getIdRuolo();
        try {
            if (!this.importerEngine.existsRuolo(idRuolo)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            Ruolo ruoloReadFromDb = this.importerEngine.getRuolo(idRuolo);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(ruoloReadFromDb.getSuperUser())) {
                throw new Exception("Il Ruolo [" + idRuolo + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isRuoloInUso(idRuolo, whereIsInUso, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idRuolo, whereIsInUso, false, NEW_LINE));
            }
            this.importerEngine.deleteRuolo(archiveRuolo.getRuolo());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione del ruolo [" + idRuolo + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteScope(ArchiveScope archiveScope, ArchiveEsitoImportDetail detail) {
        IDScope idScope = archiveScope.getIdScope();
        try {
            if (!this.importerEngine.existsScope(idScope)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            Scope scopeReadFromDb = this.importerEngine.getScope(idScope);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(scopeReadFromDb.getSuperUser())) {
                throw new Exception("Lo Scope [" + idScope + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isScopeInUso(idScope, whereIsInUso, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idScope, whereIsInUso, false, NEW_LINE));
            }
            this.importerEngine.deleteScope(archiveScope.getScope());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione dello scope [" + idScope + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteSoggetto(ArchiveSoggetto archiveSoggetto, ArchiveEsitoImportDetail detail) {
        IDSoggetto idSoggetto = archiveSoggetto.getIdSoggetto();
        try {
            boolean delete = false;
            if (archiveSoggetto.getSoggettoRegistro() != null && this.importerEngine.existsSoggettoRegistro(idSoggetto)) {
                String tipoPdd;
                Soggetto old = this.importerEngine.getSoggettoRegistro(idSoggetto);
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("Il soggetto non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
                }
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                boolean verificaRuoli = false;
                if (this.importerEngine.isSoggettoRegistroInUso(idSoggetto, whereIsInUso, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO, verificaRuoli)) {
                    throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idSoggetto, whereIsInUso, false, NEW_LINE, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO));
                }
                if (old.getPortaDominio() != null && !PddTipologia.ESTERNO.equals(tipoPdd = this.importerEngine.getTipoPortaDominio(old.getPortaDominio()))) {
                    throw new Exception("Il soggetto non \u00e8 eliminabile poich\u00e8 di dominio interno");
                }
                this.importerEngine.deleteSoggettoRegistro(archiveSoggetto.getSoggettoRegistro());
                delete = true;
            }
            if (archiveSoggetto.getSoggettoConfigurazione() != null && this.importerEngine.existsSoggettoConfigurazione(idSoggetto)) {
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                boolean verificaRuoli = false;
                if (this.importerEngine.isSoggettoConfigurazioneInUso(idSoggetto, whereIsInUso, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO, verificaRuoli)) {
                    throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idSoggetto, whereIsInUso, false, NEW_LINE, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO));
                }
                this.importerEngine.deleteSoggettoConfigurazione(archiveSoggetto.getSoggettoConfigurazione());
                delete = true;
            }
            if (delete) {
                detail.setState(ArchiveStatoImport.DELETED);
            } else {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione del soggetto [" + idSoggetto + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteServizioApplicativo(ArchiveServizioApplicativo archiveServizioApplicativo, ArchiveEsitoImportDetail detail) {
        IDServizioApplicativo idServizioApplicativo = archiveServizioApplicativo.getIdServizioApplicativo();
        IDSoggetto idSoggettoProprietario = archiveServizioApplicativo.getIdSoggettoProprietario();
        try {
            if (!this.importerEngine.existsServizioApplicativo(idServizioApplicativo)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            org.openspcoop2.core.config.Soggetto soggetto = this.importerEngine.getSoggettoConfigurazione(idSoggettoProprietario);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto proprietario [" + idSoggettoProprietario + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            boolean verificaRuoli = false;
            if (this.importerEngine.isServizioApplicativoInUso(idServizioApplicativo, whereIsInUso, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO, verificaRuoli)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idServizioApplicativo, whereIsInUso, false, NEW_LINE, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO));
            }
            this.importerEngine.deleteServizioApplicativo(archiveServizioApplicativo.getServizioApplicativo());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione del servizio applicativo [" + idServizioApplicativo + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteAccordoCooperazione(ArchiveAccordoCooperazione archiveAccordoCooperazione, ArchiveEsitoImportDetail detail) {
        IDAccordoCooperazione idAccordoCooperazione = archiveAccordoCooperazione.getIdAccordoCooperazione();
        try {
            if (!this.importerEngine.existsAccordoCooperazione(idAccordoCooperazione)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            AccordoCooperazione acReadFromDb = this.importerEngine.getAccordoCooperazione(idAccordoCooperazione);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(acReadFromDb.getSuperUser())) {
                throw new Exception("L'accordo di cooperazione [" + idAccordoCooperazione + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isAccordoCooperazioneInUso(idAccordoCooperazione, whereIsInUso, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idAccordoCooperazione, whereIsInUso, false, NEW_LINE, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO));
            }
            this.importerEngine.deleteAccordoCooperazione(archiveAccordoCooperazione.getAccordoCooperazione());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione dell'accordo di cooperazione [" + idAccordoCooperazione + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteAccordoServizioParteComune(ArchiveAccordoServizioParteComune archiveAccordoServizioParteComune, ArchiveEsitoImportDetail detail, Map<String, IDSoggetto> mapIdSoggettoDefault, Map<String, Boolean> mapAPIconReferente) {
        IDAccordo idAccordoServizioParteComune = archiveAccordoServizioParteComune.getIdAccordoServizioParteComune();
        try {
            IProtocolFactory<?> protocolFactory = this.protocolFactoryManager.getProtocolFactoryByOrganizationType(idAccordoServizioParteComune.getSoggettoReferente().getTipo());
            boolean APIconReferente = mapAPIconReferente.get(protocolFactory.getProtocol());
            if (!APIconReferente) {
                IDSoggetto soggettoDefaultProtocollo = mapIdSoggettoDefault.get(protocolFactory.getProtocol());
                if (!idAccordoServizioParteComune.getSoggettoReferente().equals((Object)soggettoDefaultProtocollo)) {
                    archiveAccordoServizioParteComune.getAccordoServizioParteComune().getSoggettoReferente().setTipo(soggettoDefaultProtocollo.getTipo());
                    archiveAccordoServizioParteComune.getAccordoServizioParteComune().getSoggettoReferente().setNome(soggettoDefaultProtocollo.getNome());
                    idAccordoServizioParteComune.getSoggettoReferente().setTipo(soggettoDefaultProtocollo.getTipo());
                    idAccordoServizioParteComune.getSoggettoReferente().setNome(soggettoDefaultProtocollo.getNome());
                }
            }
            if (!this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioParteComune)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            AccordoServizioParteComune aspcReadFromDb = this.importerEngine.getAccordoServizioParteComune(idAccordoServizioParteComune);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(aspcReadFromDb.getSuperUser())) {
                throw new Exception("L'accordo di servizio parte comune [" + idAccordoServizioParteComune + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isAccordoServizioParteComuneInUso(idAccordoServizioParteComune, whereIsInUso, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idAccordoServizioParteComune, whereIsInUso, false, NEW_LINE, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO));
            }
            this.importerEngine.deleteAccordoServizioParteComune(archiveAccordoServizioParteComune.getAccordoServizioParteComune());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione dell'accordo di servizio parte comune [" + idAccordoServizioParteComune + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteAccordoServizioComposto(ArchiveAccordoServizioComposto archiveAccordoServizioComposto, ArchiveEsitoImportDetail detail, Map<String, IDSoggetto> mapIdSoggettoDefault, Map<String, Boolean> mapAPIconReferente) {
        IDAccordo idAccordoServizioComposto = archiveAccordoServizioComposto.getIdAccordoServizioParteComune();
        try {
            IProtocolFactory<?> protocolFactory = this.protocolFactoryManager.getProtocolFactoryByOrganizationType(idAccordoServizioComposto.getSoggettoReferente().getTipo());
            boolean APIconReferente = mapAPIconReferente.get(protocolFactory.getProtocol());
            if (!APIconReferente) {
                IDSoggetto soggettoDefaultProtocollo = mapIdSoggettoDefault.get(protocolFactory.getProtocol());
                if (!idAccordoServizioComposto.getSoggettoReferente().equals((Object)soggettoDefaultProtocollo)) {
                    archiveAccordoServizioComposto.getAccordoServizioParteComune().getSoggettoReferente().setTipo(soggettoDefaultProtocollo.getTipo());
                    archiveAccordoServizioComposto.getAccordoServizioParteComune().getSoggettoReferente().setNome(soggettoDefaultProtocollo.getNome());
                    idAccordoServizioComposto.getSoggettoReferente().setTipo(soggettoDefaultProtocollo.getTipo());
                    idAccordoServizioComposto.getSoggettoReferente().setNome(soggettoDefaultProtocollo.getNome());
                }
            }
            if (!this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioComposto)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            AccordoServizioParteComune ascReadFromDb = this.importerEngine.getAccordoServizioParteComune(idAccordoServizioComposto);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(ascReadFromDb.getSuperUser())) {
                throw new Exception("L'accordo di servizio composto [" + idAccordoServizioComposto + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isAccordoServizioParteComuneInUso(idAccordoServizioComposto, whereIsInUso, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idAccordoServizioComposto, whereIsInUso, false, NEW_LINE, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO));
            }
            this.importerEngine.deleteAccordoServizioParteComune(archiveAccordoServizioComposto.getAccordoServizioParteComune());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione dell'accordo di servizio parte comune [" + idAccordoServizioComposto + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteAccordoServizioParteSpecifica(ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica, boolean servizioComposto, ArchiveEsitoImportDetail detail) {
        IDServizio idAccordoServizioParteSpecifica = archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica();
        try {
            if (!this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            AccordoServizioParteSpecifica aspsReadFromDb = this.importerEngine.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(aspsReadFromDb.getSuperUser())) {
                throw new Exception("L'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isAccordoServizioParteSpecificaInUso(archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica(), whereIsInUso, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica(), whereIsInUso, false, NEW_LINE, NORMALIZE_OBJECT_ID_MESSAGGIO_IN_USO, "Servizio"));
            }
            this.importerEngine.deleteAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione dell'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteFruitore(ArchiveFruitore archiveFruitore, ArchiveEsitoImportDetail detail) {
        IDServizio idAccordoServizioParteSpecifica = archiveFruitore.getIdAccordoServizioParteSpecifica();
        IDSoggetto idSoggettoFruitore = archiveFruitore.getIdSoggettoFruitore();
        try {
            AccordoServizioParteSpecifica oldAccordo = null;
            Fruitore old = null;
            if (this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                oldAccordo = this.importerEngine.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
                for (int i = 0; i < oldAccordo.sizeFruitoreList(); ++i) {
                    Fruitore check = oldAccordo.getFruitore(i);
                    if (!check.getTipo().equals(idSoggettoFruitore.getTipo()) || !check.getNome().equals(idSoggettoFruitore.getNome())) continue;
                    old = oldAccordo.removeFruitore(i);
                    break;
                }
            }
            if (old == null) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            Soggetto soggetto = this.importerEngine.getSoggettoRegistro(idSoggettoFruitore);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto fruitore [" + idSoggettoFruitore + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(oldAccordo.getSuperUser())) {
                throw new Exception("L'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            IDServizio oldIDServizioForUpdate = IDServizioFactory.getInstance().getIDServizioFromValues(oldAccordo.getTipo(), oldAccordo.getNome(), oldAccordo.getTipoSoggettoErogatore(), oldAccordo.getNomeSoggettoErogatore(), oldAccordo.getVersione().intValue());
            oldAccordo.setOldIDServizioForUpdate(oldIDServizioForUpdate);
            this.importerEngine.updateAccordoServizioParteSpecifica(oldAccordo);
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione del fruitore[" + idSoggettoFruitore + "] dell'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deletePortaDelegata(ArchivePortaDelegata archivePortaDelegata, ArchiveEsitoImportDetail detail) {
        IDPortaDelegata idPortaDelegata = archivePortaDelegata.getIdPortaDelegata();
        IDSoggetto idSoggettoProprietario = archivePortaDelegata.getIdSoggettoProprietario();
        try {
            if (!this.importerEngine.existsPortaDelegata(idPortaDelegata)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            org.openspcoop2.core.config.Soggetto soggetto = this.importerEngine.getSoggettoConfigurazione(idSoggettoProprietario);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto proprietario [" + idSoggettoProprietario + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            PortaDelegata portaDelegata = archivePortaDelegata.getPortaDelegata();
            this.importerEngine.deletePortaDelegata(portaDelegata);
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione della porta delegata [" + idPortaDelegata + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deletePortaApplicativa(ArchivePortaApplicativa archivePortaApplicativa, ArchiveEsitoImportDetail detail) {
        IDPortaApplicativa idPortaApplicativa = archivePortaApplicativa.getIdPortaApplicativa();
        IDSoggetto idSoggettoProprietario = archivePortaApplicativa.getIdSoggettoProprietario();
        try {
            if (!this.importerEngine.existsPortaApplicativa(idPortaApplicativa)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            org.openspcoop2.core.config.Soggetto soggetto = this.importerEngine.getSoggettoConfigurazione(idSoggettoProprietario);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto proprietario [" + idSoggettoProprietario + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            PortaApplicativa pa = archivePortaApplicativa.getPortaApplicativa();
            this.importerEngine.deletePortaApplicativa(pa);
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione della porta applicativa [" + idPortaApplicativa + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }
}

