/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.IdAllarme;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.config.AttributeAuthority;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneHandler;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneServizioApplicativo;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneSoggetto;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataServizioApplicativo;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.Scope;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaSoggetto;
import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.config.constants.TipoAutorizzazione;
import org.openspcoop2.core.config.constants.TipoBehaviour;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteApplicative;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteDelegate;
import org.openspcoop2.core.config.driver.FiltroRicercaServiziApplicativi;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.IdActivePolicy;
import org.openspcoop2.core.controllo_traffico.IdPolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoFiltroApplicativo;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.GruppoAccordo;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.RuoloSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaGruppi;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.core.registry.driver.FiltroRicercaScope;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.protocol.basic.registry.ConfigIntegrationReader;
import org.openspcoop2.protocol.basic.registry.RegistryReader;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.archive.AbstractArchiveEngine;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveActivePolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveAllarme;
import org.openspcoop2.protocol.sdk.archive.ArchiveAttributeAuthority;
import org.openspcoop2.protocol.sdk.archive.ArchiveCascadeConfiguration;
import org.openspcoop2.protocol.sdk.archive.ArchiveConfigurationPolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveFruitore;
import org.openspcoop2.protocol.sdk.archive.ArchiveGruppo;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveMode;
import org.openspcoop2.protocol.sdk.archive.ArchivePdd;
import org.openspcoop2.protocol.sdk.archive.ArchivePluginArchivio;
import org.openspcoop2.protocol.sdk.archive.ArchivePluginClasse;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaDelegata;
import org.openspcoop2.protocol.sdk.archive.ArchiveRuolo;
import org.openspcoop2.protocol.sdk.archive.ArchiveScope;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.archive.ArchiveTokenPolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveUrlInvocazioneRegola;
import org.openspcoop2.protocol.sdk.archive.IArchive;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.slf4j.Logger;

public class ExporterArchiveUtils {
    private AbstractArchiveEngine archiveEngine;
    private Logger log;
    private ProtocolFactoryManager protocolFactoryManager;
    private ArchiveIdCorrelazione idCorrelazione = null;

    public ExporterArchiveUtils(AbstractArchiveEngine archiveEngine, Logger log) throws Exception {
        this.archiveEngine = archiveEngine;
        this.log = log;
        this.protocolFactoryManager = ProtocolFactoryManager.getInstance();
        this.idCorrelazione = new ArchiveIdCorrelazione("export");
    }

    public void export(String protocol, Archive archive, OutputStream out, ArchiveMode mode) throws Exception {
        IProtocolFactory<?> protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName(protocol);
        IArchive archiveEngine = protocolFactory.createArchive();
        RegistryReader archiveRegistryReader = new RegistryReader((IDriverRegistroServiziGet)this.archiveEngine.getDriverRegistroServizi(), this.log);
        ConfigIntegrationReader archiveConfigIntegrationReader = new ConfigIntegrationReader((IDriverConfigurazioneGet)this.archiveEngine.getDriverConfigurazione(), this.log);
        archiveEngine.exportArchive(archive, out, mode, (IRegistryReader)archiveRegistryReader, (IConfigIntegrationReader)archiveConfigIntegrationReader);
    }

    public byte[] export(String protocol, Archive archive, ArchiveMode mode) throws Exception {
        IProtocolFactory<?> protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName(protocol);
        IArchive archiveEngine = protocolFactory.createArchive();
        RegistryReader archiveRegistryReader = new RegistryReader((IDriverRegistroServiziGet)this.archiveEngine.getDriverRegistroServizi(), this.log);
        ConfigIntegrationReader archiveConfigIntegrationReader = new ConfigIntegrationReader((IDriverConfigurazioneGet)this.archiveEngine.getDriverConfigurazione(), this.log);
        return archiveEngine.exportArchive(archive, mode, (IRegistryReader)archiveRegistryReader, (IConfigIntegrationReader)archiveConfigIntegrationReader);
    }

    public void fillArchive(Archive archive, ArchiveType exportSourceArchiveType, List<?> listObject, ArchiveCascadeConfiguration cascadeConfig) throws Exception {
        switch (exportSourceArchiveType) {
            case PDD: {
                for (Object object : listObject) {
                    this.readPdd(archive, (String)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case GRUPPO: {
                for (Object object : listObject) {
                    this.readGruppo(archive, (IDGruppo)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case RUOLO: {
                for (Object object : listObject) {
                    this.readRuolo(archive, (IDRuolo)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case SCOPE: {
                for (Object object : listObject) {
                    this.readScope(archive, (IDScope)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case SOGGETTO: {
                for (Object object : listObject) {
                    this.readSoggetto(archive, (IDSoggetto)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case SERVIZIO_APPLICATIVO: {
                for (Object object : listObject) {
                    this.readServizioApplicativo(archive, (IDServizioApplicativo)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case PORTA_DELEGATA: {
                for (Object object : listObject) {
                    this.readPortaDelegata(archive, (IDPortaDelegata)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case PORTA_APPLICATIVA: {
                for (Object object : listObject) {
                    this.readPortaApplicativa(archive, (IDPortaApplicativa)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case ACCORDO_COOPERAZIONE: {
                for (Object object : listObject) {
                    this.readAccordoCooperazione(archive, (IDAccordoCooperazione)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                for (Object object : listObject) {
                    this.readAccordoServizioParteComune(archive, (IDAccordo)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case ACCORDO_SERVIZIO_COMPOSTO: {
                for (Object object : listObject) {
                    this.readAccordoServizioComposto(archive, (IDAccordo)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case ACCORDO_SERVIZIO_PARTE_SPECIFICA: {
                for (Object object : listObject) {
                    this.readAccordoServizioParteSpecifica(archive, (IDServizio)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case EROGAZIONE: {
                for (Object object : listObject) {
                    this.readErogazione(archive, (IDServizio)object, cascadeConfig);
                }
                break;
            }
            case FRUIZIONE: {
                for (Object object : listObject) {
                    this.readFruizione(archive, (IDFruizione)object, cascadeConfig);
                }
                break;
            }
            case CONFIGURAZIONE_CONTROLLO_TRAFFICO_CONFIG_POLICY: {
                for (Object object : listObject) {
                    this.readControlloTraffico_configurationPolicy(archive, (IdPolicy)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case CONFIGURAZIONE_CONTROLLO_TRAFFICO_ACTIVE_POLICY: {
                for (Object object : listObject) {
                    this.readControlloTraffico_activePolicy(archive, (IdActivePolicy)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case ALLARME: {
                for (Object object : listObject) {
                    this.readAllarme(archive, (IdAllarme)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case CONFIGURAZIONE_TOKEN_POLICY: {
                for (Object object : listObject) {
                    this.readTokenPolicy(archive, (IDGenericProperties)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case CONFIGURAZIONE_ATTRIBUTE_AUTHORITY: {
                for (Object object : listObject) {
                    this.readAttributeAuthority(archive, (IDGenericProperties)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case CONFIGURAZIONE_PLUGIN_CLASSE: {
                for (Object object : listObject) {
                    this.readPlugin_classe(archive, (IdPlugin)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case CONFIGURAZIONE_PLUGIN_ARCHVIO: {
                for (Object object : listObject) {
                    this.readPlugin_archivio(archive, (String)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case CONFIGURAZIONE_URL_INVOCAZIONE_REGOLA: {
                for (Object object : listObject) {
                    this.readUrlInvocazioneRegola(archive, (String)object, cascadeConfig);
                }
                break;
            }
            case CONFIGURAZIONE_URL_INVOCAZIONE: {
                this.setConfigurazioneUrlInvocazione(archive);
                break;
            }
            case CONFIGURAZIONE: {
                this.readControlloTrafficoConfigurazione(archive, true, false, exportSourceArchiveType);
                this.readAllarmiConfigurazione(archive, true, false, exportSourceArchiveType);
                this.readTokenPolicyConfigurazione(archive, exportSourceArchiveType);
                this.readAttributeAuthorityConfigurazione(archive, exportSourceArchiveType);
                this.readPluginConfigurazione(archive, exportSourceArchiveType);
                this.setConfigurazione(archive);
                FiltroRicercaGruppi filtroRicercaGruppi = new FiltroRicercaGruppi();
                List<IDGruppo> idGruppi = null;
                try {
                    idGruppi = this.archiveEngine.getAllIdGruppi(filtroRicercaGruppi);
                    for (IDGruppo idGruppo : idGruppi) {
                        boolean found = false;
                        if (archive.getGruppi() != null && archive.getGruppi().size() > 0) {
                            for (String idArchiveGruppo : archive.getGruppi().keys()) {
                                ArchiveGruppo archiveGruppo = (ArchiveGruppo)archive.getGruppi().get(idArchiveGruppo);
                                if (!archiveGruppo.getIdGruppo().equals((Object)idGruppo)) continue;
                                found = true;
                                break;
                            }
                        }
                        if (found) continue;
                        this.readGruppo(archive, idGruppo, cascadeConfig, false, ArchiveType.GRUPPO);
                    }
                    break;
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    break;
                }
            }
            case ALL: 
            case ALL_WITHOUT_CONFIGURAZIONE: {
                boolean found;
                FiltroRicercaSoggetti filtroSoggetti = new FiltroRicercaSoggetti();
                try {
                    ArchiveCascadeConfiguration cascadeAll = new ArchiveCascadeConfiguration(true);
                    List<IDSoggetto> idsSoggetti = this.archiveEngine.getAllIdSoggettiRegistro(filtroSoggetti);
                    if (idsSoggetti != null && idsSoggetti.size() > 0) {
                        for (IDSoggetto idSoggetto : idsSoggetti) {
                            this.readSoggetto(archive, idSoggetto, cascadeAll, exportSourceArchiveType);
                        }
                    }
                }
                catch (DriverConfigurazioneNotFound cascadeAll) {
                    // empty catch block
                }
                boolean loadActivePolicyFruizioneErogazione = false;
                boolean loadAllarmiErogazioneFruizione = false;
                if (exportSourceArchiveType.equals((Object)ArchiveType.ALL)) {
                    this.readControlloTrafficoConfigurazione(archive, true, loadActivePolicyFruizioneErogazione, exportSourceArchiveType);
                    this.readAllarmiConfigurazione(archive, true, loadAllarmiErogazioneFruizione, exportSourceArchiveType);
                    this.readTokenPolicyConfigurazione(archive, exportSourceArchiveType);
                    this.readAttributeAuthorityConfigurazione(archive, exportSourceArchiveType);
                    this.readPluginConfigurazione(archive, exportSourceArchiveType);
                    this.setConfigurazione(archive);
                } else if (exportSourceArchiveType.equals((Object)ArchiveType.ALL_WITHOUT_CONFIGURAZIONE)) {
                    this.readControlloTrafficoConfigurazione(archive, false, loadActivePolicyFruizioneErogazione, exportSourceArchiveType);
                    this.readAllarmiConfigurazione(archive, false, loadAllarmiErogazioneFruizione, exportSourceArchiveType);
                }
                FiltroRicerca filtroRicercaPdd = new FiltroRicerca();
                List<String> idPdds = null;
                try {
                    idPdds = this.archiveEngine.getAllIdPorteDominio(filtroRicercaPdd);
                    for (String idPdd : idPdds) {
                        found = false;
                        if (archive.getPdd() != null && archive.getPdd().size() > 0) {
                            for (String idArchivePdd : archive.getPdd().keys()) {
                                ArchivePdd archivePdd = (ArchivePdd)archive.getPdd().get(idArchivePdd);
                                if (!archivePdd.getNomePdd().equals(idPdd)) continue;
                                found = true;
                                break;
                            }
                        }
                        if (found) continue;
                        this.readPdd(archive, idPdd, cascadeConfig, false, ArchiveType.PDD);
                    }
                }
                catch (DriverRegistroServiziNotFound archiveGruppo) {
                    // empty catch block
                }
                if (exportSourceArchiveType.equals((Object)ArchiveType.ALL)) {
                    FiltroRicercaGruppi filtroRicercaGruppi = new FiltroRicercaGruppi();
                    List<IDGruppo> idGruppi = null;
                    try {
                        idGruppi = this.archiveEngine.getAllIdGruppi(filtroRicercaGruppi);
                        for (IDGruppo idGruppo : idGruppi) {
                            found = false;
                            if (archive.getGruppi() != null && archive.getGruppi().size() > 0) {
                                for (String idArchiveGruppo : archive.getGruppi().keys()) {
                                    ArchiveGruppo archiveGruppo = (ArchiveGruppo)archive.getGruppi().get(idArchiveGruppo);
                                    if (!archiveGruppo.getIdGruppo().equals((Object)idGruppo)) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (found) continue;
                            this.readGruppo(archive, idGruppo, cascadeConfig, false, ArchiveType.GRUPPO);
                        }
                    }
                    catch (DriverRegistroServiziNotFound archiveGruppo) {
                        // empty catch block
                    }
                }
                FiltroRicercaRuoli filtroRicercaRuoli = new FiltroRicercaRuoli();
                List<IDRuolo> idRuoli = null;
                try {
                    idRuoli = this.archiveEngine.getAllIdRuoli(filtroRicercaRuoli);
                    for (IDRuolo idRuolo : idRuoli) {
                        boolean found2 = false;
                        if (archive.getRuoli() != null && archive.getRuoli().size() > 0) {
                            for (String idArchiveRuolo : archive.getRuoli().keys()) {
                                ArchiveRuolo archiveRuolo = (ArchiveRuolo)archive.getRuoli().get(idArchiveRuolo);
                                if (!archiveRuolo.getIdRuolo().equals((Object)idRuolo)) continue;
                                found2 = true;
                                break;
                            }
                        }
                        if (found2) continue;
                        this.readRuolo(archive, idRuolo, cascadeConfig, false, ArchiveType.RUOLO);
                    }
                }
                catch (DriverRegistroServiziNotFound found3) {
                    // empty catch block
                }
                FiltroRicercaScope filtroRicercaScope = new FiltroRicercaScope();
                List<IDScope> idScopes = null;
                try {
                    idScopes = this.archiveEngine.getAllIdScope(filtroRicercaScope);
                    for (IDScope idScope : idScopes) {
                        boolean found4 = false;
                        if (archive.getScope() != null && archive.getScope().size() > 0) {
                            for (String idArchiveScope : archive.getScope().keys()) {
                                ArchiveScope archiveScope = (ArchiveScope)archive.getScope().get(idArchiveScope);
                                if (!archiveScope.getIdScope().equals((Object)idScope)) continue;
                                found4 = true;
                                break;
                            }
                        }
                        if (found4) continue;
                        this.readScope(archive, idScope, cascadeConfig, false, ArchiveType.SCOPE);
                    }
                    break;
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    break;
                }
            }
        }
    }

    private void setConfigurazione(Archive archive) throws Exception {
        Configurazione configurazione = this.archiveEngine.getConfigurazione();
        this._setConfigurazioneUrlInvocazione(archive, configurazione);
        archive.setConfigurazionePdD(configurazione);
    }

    private void setConfigurazioneUrlInvocazione(Archive archive) throws Exception {
        Configurazione configurazione = this.archiveEngine.getConfigurazione();
        this._setConfigurazioneUrlInvocazione(archive, configurazione);
    }

    private void _setConfigurazioneUrlInvocazione(Archive archive, Configurazione configurazione) throws Exception {
        if (configurazione != null && configurazione.getUrlInvocazione() != null) {
            ConfigurazioneUrlInvocazione urlInvocazione = configurazione.getUrlInvocazione();
            while (urlInvocazione.sizeRegolaList() > 0) {
                ConfigurazioneUrlInvocazioneRegola regola = urlInvocazione.removeRegola(0);
                String key = ArchiveUrlInvocazioneRegola.buildKey((String)regola.getNome());
                if (archive.getConfigurazionePdD_urlInvocazione_regole().containsKey(key)) continue;
                archive.getConfigurazionePdD_urlInvocazione_regole().add((Object)new ArchiveUrlInvocazioneRegola(regola, this.idCorrelazione));
            }
            archive.setConfigurazionePdD_urlInvocazione(urlInvocazione);
        }
    }

    private void readUrlInvocazioneRegola(Archive archive, String nome, ArchiveCascadeConfiguration cascadeConfig) throws Exception {
        String key = ArchiveUrlInvocazioneRegola.buildKey((String)nome);
        if (!archive.getConfigurazionePdD_urlInvocazione_regole().containsKey(key)) {
            archive.getConfigurazionePdD_urlInvocazione_regole().add((Object)new ArchiveUrlInvocazioneRegola(this.archiveEngine.getUrlInvocazioneRegola(nome), this.idCorrelazione));
        }
    }

    private void readControlloTrafficoConfigurazione(Archive archive, boolean policyGlobali, boolean policyFruizioniErogazioni, ArchiveType provenienza) throws Exception {
        archive.setControlloTraffico_configurazione(this.archiveEngine.getControlloTraffico_Configurazione());
        List<IdPolicy> listControlloTraffico_configurationPolicies = null;
        try {
            listControlloTraffico_configurationPolicies = this.archiveEngine.getAllIdControlloTraffico_configurationPolicies();
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        if (policyGlobali && listControlloTraffico_configurationPolicies != null && listControlloTraffico_configurationPolicies.size() > 0) {
            for (IdPolicy idPolicy : listControlloTraffico_configurationPolicies) {
                String keyPolicyConfig = ArchiveConfigurationPolicy.buildKey((String)idPolicy.getNome());
                if (archive.getControlloTraffico_configurationPolicies().containsKey(keyPolicyConfig)) continue;
                archive.getControlloTraffico_configurationPolicies().add((Object)new ArchiveConfigurationPolicy(this.archiveEngine.getControlloTraffico_configurationPolicy(idPolicy), this.idCorrelazione));
            }
        }
        List<IdActivePolicy> listControlloTraffico_activePolicies = null;
        try {
            if (policyGlobali && policyFruizioniErogazioni) {
                listControlloTraffico_activePolicies = this.archiveEngine.getAllIdControlloTraffico_activePolicies_all(null);
            } else if (policyGlobali) {
                listControlloTraffico_activePolicies = this.archiveEngine.getAllIdControlloTraffico_activePolicies_globali(null);
            } else if (policyFruizioniErogazioni) {
                listControlloTraffico_activePolicies = this.archiveEngine.getAllIdControlloTraffico_activePolicies_erogazioniFruizioni(null);
            }
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        if (listControlloTraffico_activePolicies != null && listControlloTraffico_activePolicies.size() > 0) {
            for (IdActivePolicy idPolicy : listControlloTraffico_activePolicies) {
                ArchiveCascadeConfiguration cascadeConfig2;
                TipoFiltroApplicativo tipoFiltro;
                AttivazionePolicy policy = null;
                String keyActivePolicy = ArchiveActivePolicy.buildKey((RuoloPolicy)idPolicy.getFiltroRuoloPorta(), (String)idPolicy.getFiltroNomePorta(), (String)idPolicy.getAlias());
                if (!archive.getControlloTraffico_activePolicies().containsKey(keyActivePolicy)) {
                    policy = this.archiveEngine.getControlloTraffico_activePolicy(idPolicy.getFiltroRuoloPorta(), idPolicy.getFiltroNomePorta(), idPolicy.getAlias());
                    archive.getControlloTraffico_activePolicies().add((Object)new ArchiveActivePolicy(policy, this.idCorrelazione));
                }
                if (policyGlobali) continue;
                String keyPolicyConfig = ArchiveConfigurationPolicy.buildKey((String)idPolicy.getIdPolicy());
                if (!archive.getControlloTraffico_configurationPolicies().containsKey(keyPolicyConfig) && listControlloTraffico_configurationPolicies != null && listControlloTraffico_configurationPolicies.size() > 0) {
                    for (IdPolicy idConfigPolicy : listControlloTraffico_configurationPolicies) {
                        if (!idConfigPolicy.getNome().equals(idPolicy.getIdPolicy())) continue;
                        archive.getControlloTraffico_configurationPolicies().add((Object)new ArchiveConfigurationPolicy(this.archiveEngine.getControlloTraffico_configurationPolicy(idConfigPolicy), this.idCorrelazione));
                        break;
                    }
                }
                if (policy != null && policy.getFiltro() != null && policy.getFiltro().isEnabled() && policy.getFiltro().isInformazioneApplicativaEnabled() && StringUtils.isNotEmpty((String)policy.getFiltro().getInformazioneApplicativaTipo()) && TipoFiltroApplicativo.PLUGIN_BASED.equals((Object)(tipoFiltro = TipoFiltroApplicativo.toEnumConstant((String)policy.getFiltro().getInformazioneApplicativaTipo(), (boolean)false)))) {
                    try {
                        cascadeConfig2 = new ArchiveCascadeConfiguration();
                        cascadeConfig2.setCascadePluginConfigurazione(true);
                        this.readPlugin_classe(archive, TipoPlugin.RATE_LIMITING.getValue(), policy.getFiltro().getInformazioneApplicativaNome(), cascadeConfig2, provenienza);
                    }
                    catch (DriverConfigurazioneNotFound cascadeConfig2) {
                        // empty catch block
                    }
                }
                if (policy == null || policy.getGroupBy() == null || !policy.getGroupBy().isEnabled() || !policy.getGroupBy().isInformazioneApplicativaEnabled() || !StringUtils.isNotEmpty((String)policy.getGroupBy().getInformazioneApplicativaTipo()) || !TipoFiltroApplicativo.PLUGIN_BASED.equals((Object)(tipoFiltro = TipoFiltroApplicativo.toEnumConstant((String)policy.getGroupBy().getInformazioneApplicativaTipo(), (boolean)false)))) continue;
                try {
                    cascadeConfig2 = new ArchiveCascadeConfiguration();
                    cascadeConfig2.setCascadePluginConfigurazione(true);
                    this.readPlugin_classe(archive, TipoPlugin.RATE_LIMITING.getValue(), policy.getGroupBy().getInformazioneApplicativaNome(), cascadeConfig2, provenienza);
                }
                catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
            }
        }
    }

    private void readControlloTrafficoPolicyPorta(Archive archive, boolean delegata, String nomePorta, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        List<IdActivePolicy> listControlloTraffico_activePolicies = null;
        try {
            listControlloTraffico_activePolicies = delegata ? this.archiveEngine.getAllIdControlloTraffico_activePolicies_fruizione(nomePorta) : this.archiveEngine.getAllIdControlloTraffico_activePolicies_erogazione(nomePorta);
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        if (listControlloTraffico_activePolicies != null && listControlloTraffico_activePolicies.size() > 0) {
            for (IdActivePolicy idPolicy : listControlloTraffico_activePolicies) {
                this.readControlloTraffico_activePolicy(archive, idPolicy, cascadeConfig, provenienza);
            }
        }
    }

    private void readControlloTraffico_configurationPolicy(Archive archive, IdPolicy idPolicy, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        ConfigurazionePolicy policy = null;
        String key = ArchiveConfigurationPolicy.buildKey((String)idPolicy.getNome());
        if (!archive.getControlloTraffico_configurationPolicies().containsKey(key)) {
            policy = this.archiveEngine.getControlloTraffico_configurationPolicy(idPolicy.getNome());
            archive.getControlloTraffico_configurationPolicies().add((Object)new ArchiveConfigurationPolicy(policy, this.idCorrelazione));
        }
    }

    private void readControlloTraffico_activePolicy(Archive archive, IdActivePolicy idPolicy, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        AttivazionePolicy policy = null;
        String keyActivePolicy = ArchiveActivePolicy.buildKey((RuoloPolicy)idPolicy.getFiltroRuoloPorta(), (String)idPolicy.getFiltroNomePorta(), (String)idPolicy.getAlias());
        if (!archive.getControlloTraffico_activePolicies().containsKey(keyActivePolicy)) {
            policy = this.archiveEngine.getControlloTraffico_activePolicy(idPolicy.getFiltroRuoloPorta(), idPolicy.getFiltroNomePorta(), idPolicy.getAlias());
            archive.getControlloTraffico_activePolicies().add((Object)new ArchiveActivePolicy(policy, this.idCorrelazione));
        }
        if (cascadeConfig.isCascadePolicyConfigurazione()) {
            IdPolicy idPolicyConfig = new IdPolicy();
            idPolicyConfig.setNome(idPolicy.getIdPolicy());
            this.readControlloTraffico_configurationPolicy(archive, idPolicyConfig, cascadeConfig, provenienza);
        }
        if (cascadeConfig.isCascadePluginConfigurazione()) {
            TipoFiltroApplicativo tipoFiltro;
            if (policy != null && policy.getFiltro() != null && policy.getFiltro().isEnabled() && policy.getFiltro().isInformazioneApplicativaEnabled() && StringUtils.isNotEmpty((String)policy.getFiltro().getInformazioneApplicativaTipo()) && TipoFiltroApplicativo.PLUGIN_BASED.equals((Object)(tipoFiltro = TipoFiltroApplicativo.toEnumConstant((String)policy.getFiltro().getInformazioneApplicativaTipo(), (boolean)false)))) {
                try {
                    this.readPlugin_classe(archive, TipoPlugin.RATE_LIMITING.getValue(), policy.getFiltro().getInformazioneApplicativaNome(), cascadeConfig, provenienza);
                }
                catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                    // empty catch block
                }
            }
            if (policy != null && policy.getGroupBy() != null && policy.getGroupBy().isEnabled() && policy.getGroupBy().isInformazioneApplicativaEnabled() && StringUtils.isNotEmpty((String)policy.getGroupBy().getInformazioneApplicativaTipo()) && TipoFiltroApplicativo.PLUGIN_BASED.equals((Object)(tipoFiltro = TipoFiltroApplicativo.toEnumConstant((String)policy.getGroupBy().getInformazioneApplicativaTipo(), (boolean)false)))) {
                try {
                    this.readPlugin_classe(archive, TipoPlugin.RATE_LIMITING.getValue(), policy.getGroupBy().getInformazioneApplicativaNome(), cascadeConfig, provenienza);
                }
                catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                    // empty catch block
                }
            }
        }
    }

    private void readAllarmiConfigurazione(Archive archive, boolean policyGlobali, boolean policyFruizioniErogazioni, ArchiveType provenienza) throws Exception {
        if (!CostantiDB.isAllarmiEnabled()) {
            return;
        }
        List<IdAllarme> listAllarmi = null;
        try {
            if (policyGlobali && policyFruizioniErogazioni) {
                listAllarmi = this.archiveEngine.getAllIdAllarmi_all(null);
            } else if (policyGlobali) {
                listAllarmi = this.archiveEngine.getAllIdAllarmi_globali(null);
            } else if (policyFruizioniErogazioni) {
                listAllarmi = this.archiveEngine.getAllIdAllarmi_erogazioniFruizioni(null);
            }
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        if (listAllarmi != null && !listAllarmi.isEmpty()) {
            for (IdAllarme idAllarme : listAllarmi) {
                String keyAllarme = ArchiveAllarme.buildKey((RuoloPorta)idAllarme.getFiltroRuoloPorta(), (String)idAllarme.getFiltroNomePorta(), (String)idAllarme.getAlias());
                if (!archive.getAllarmi().containsKey(keyAllarme)) {
                    archive.getAllarmi().add((Object)new ArchiveAllarme(this.archiveEngine.getAllarme(idAllarme.getFiltroRuoloPorta(), idAllarme.getFiltroNomePorta(), idAllarme.getAlias()), this.idCorrelazione));
                }
                if (policyGlobali) continue;
                try {
                    ArchiveCascadeConfiguration cascadeConfig = new ArchiveCascadeConfiguration();
                    cascadeConfig.setCascadePluginConfigurazione(true);
                    this.readPlugin_classe(archive, TipoPlugin.ALLARME.getValue(), idAllarme.getTipo(), cascadeConfig, provenienza);
                }
                catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
            }
        }
    }

    private void readAllarmiPorta(Archive archive, boolean delegata, String nomePorta, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        if (!CostantiDB.isAllarmiEnabled()) {
            return;
        }
        List<IdAllarme> listAllarmi = null;
        try {
            listAllarmi = delegata ? this.archiveEngine.getAllIdAllarmi_fruizione(nomePorta) : this.archiveEngine.getAllIdAllarmi_erogazione(nomePorta);
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        if (listAllarmi != null && listAllarmi.size() > 0) {
            for (IdAllarme idAllarme : listAllarmi) {
                String keyAllarme = ArchiveAllarme.buildKey((RuoloPorta)idAllarme.getFiltroRuoloPorta(), (String)idAllarme.getFiltroNomePorta(), (String)idAllarme.getAlias());
                if (!archive.getAllarmi().containsKey(keyAllarme)) {
                    archive.getAllarmi().add((Object)new ArchiveAllarme(this.archiveEngine.getAllarme(idAllarme.getFiltroRuoloPorta(), idAllarme.getFiltroNomePorta(), idAllarme.getAlias()), this.idCorrelazione));
                }
                if (!cascadeConfig.isCascadePluginConfigurazione()) continue;
                try {
                    this.readPlugin_classe(archive, TipoPlugin.ALLARME.getValue(), idAllarme.getTipo(), cascadeConfig, provenienza);
                }
                catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
            }
        }
    }

    private void readAllarme(Archive archive, IdAllarme idAllarme, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        Allarme allarme = null;
        String key = ArchiveAllarme.buildKey((RuoloPorta)idAllarme.getFiltroRuoloPorta(), (String)idAllarme.getFiltroNomePorta(), (String)idAllarme.getAlias());
        if (!archive.getAllarmi().containsKey(key)) {
            allarme = this.archiveEngine.getAllarme(idAllarme.getFiltroRuoloPorta(), idAllarme.getFiltroNomePorta(), idAllarme.getAlias());
            archive.getAllarmi().add((Object)new ArchiveAllarme(allarme, this.idCorrelazione));
        }
        if (cascadeConfig.isCascadePluginConfigurazione()) {
            try {
                this.readPlugin_classe(archive, TipoPlugin.ALLARME.getValue(), idAllarme.getTipo(), cascadeConfig, provenienza);
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
        }
    }

    private void readTokenPolicyConfigurazione(Archive archive, ArchiveType provenienza) throws Exception {
        ArchiveCascadeConfiguration cascadeConfigPolicy = new ArchiveCascadeConfiguration();
        cascadeConfigPolicy.setCascadePolicyConfigurazione(true);
        List<IDGenericProperties> listPolicies_validation = null;
        try {
            listPolicies_validation = this.archiveEngine.getAllIdGenericProperties_validation();
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        if (listPolicies_validation != null && listPolicies_validation.size() > 0) {
            for (IDGenericProperties idGP : listPolicies_validation) {
                this.readTokenPolicy_validation(archive, idGP.getNome(), cascadeConfigPolicy, provenienza);
            }
        }
        List<IDGenericProperties> listPolicies_retrieve = null;
        try {
            listPolicies_retrieve = this.archiveEngine.getAllIdGenericProperties_retrieve();
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        if (listPolicies_retrieve != null && listPolicies_retrieve.size() > 0) {
            for (IDGenericProperties idGP : listPolicies_retrieve) {
                this.readTokenPolicy_retrieve(archive, idGP.getNome(), cascadeConfigPolicy, provenienza);
            }
        }
    }

    private void readTokenPolicy(Archive archive, IDGenericProperties idGP, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        if ("gestionePolicyToken".equals(idGP.getTipologia())) {
            this.readTokenPolicy_validation(archive, idGP.getNome(), cascadeConfig, provenienza);
        } else if ("retrievePolicyToken".equals(idGP.getTipologia())) {
            this.readTokenPolicy_retrieve(archive, idGP.getNome(), cascadeConfig, provenienza);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readTokenPolicy_validation(Archive archive, String nomePolicy, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        if (!cascadeConfig.isCascadePolicyConfigurazione() && !ArchiveType.CONFIGURAZIONE_TOKEN_POLICY.equals((Object)provenienza)) return;
        String key = ArchiveTokenPolicy.buildKey((String)"gestionePolicyToken", (String)nomePolicy);
        if (archive.getToken_validation_policies().containsKey(key)) return;
        GenericProperties policy = this.archiveEngine.getGenericProperties_validation(nomePolicy);
        archive.getToken_validation_policies().add((Object)new ArchiveTokenPolicy(policy, this.idCorrelazione));
        if (policy == null || policy.sizePropertyList() <= 0) return;
        for (int i = 0; i < policy.sizePropertyList(); ++i) {
            ArchiveCascadeConfiguration cascadeConfigPlugin2;
            Property pJ;
            int j;
            Property p = policy.getProperty(i);
            if ("policy.discovery.claimsParser".equals(p.getNome()) && "CUSTOM".equals(p.getValore())) {
                for (j = 0; j < policy.sizePropertyList(); ++j) {
                    pJ = policy.getProperty(j);
                    if (!"policy.discovery.claimsParser.pluginType".equals(pJ.getNome())) continue;
                    try {
                        cascadeConfigPlugin2 = new ArchiveCascadeConfiguration();
                        cascadeConfigPlugin2.setCascadePluginConfigurazione(true);
                        this.readPlugin_classe(archive, TipoPlugin.TOKEN_DYNAMIC_DISCOVERY.getValue(), pJ.getValore(), cascadeConfigPlugin2, provenienza);
                        continue;
                    }
                    catch (DriverConfigurazioneNotFound cascadeConfigPlugin2) {
                        // empty catch block
                    }
                }
                continue;
            }
            if ("policy.validazioneJWT.claimsParser".equals(p.getNome()) && "CUSTOM".equals(p.getValore())) {
                for (j = 0; j < policy.sizePropertyList(); ++j) {
                    pJ = policy.getProperty(j);
                    if (!"policy.validazioneJWT.claimsParser.pluginType".equals(pJ.getNome())) continue;
                    try {
                        cascadeConfigPlugin2 = new ArchiveCascadeConfiguration();
                        cascadeConfigPlugin2.setCascadePluginConfigurazione(true);
                        this.readPlugin_classe(archive, TipoPlugin.TOKEN_VALIDAZIONE.getValue(), pJ.getValore(), cascadeConfigPlugin2, provenienza);
                        continue;
                    }
                    catch (DriverConfigurazioneNotFound cascadeConfigPlugin3) {
                        // empty catch block
                    }
                }
                continue;
            }
            if ("policy.validazioneDPoP.claimsParser".equals(p.getNome()) && "CUSTOM".equals(p.getValore())) {
                for (j = 0; j < policy.sizePropertyList(); ++j) {
                    pJ = policy.getProperty(j);
                    if (!"policy.validazioneDPoP.claimsParser.pluginType".equals(pJ.getNome())) continue;
                    try {
                        cascadeConfigPlugin2 = new ArchiveCascadeConfiguration();
                        cascadeConfigPlugin2.setCascadePluginConfigurazione(true);
                        this.readPlugin_classe(archive, TipoPlugin.DPOP_VALIDAZIONE.getValue(), pJ.getValore(), cascadeConfigPlugin2, provenienza);
                        continue;
                    }
                    catch (DriverConfigurazioneNotFound cascadeConfigPlugin4) {
                        // empty catch block
                    }
                }
                continue;
            }
            if ("policy.introspection.claimsParser".equals(p.getNome()) && "CUSTOM".equals(p.getValore())) {
                for (j = 0; j < policy.sizePropertyList(); ++j) {
                    pJ = policy.getProperty(j);
                    if (!"policy.introspection.claimsParser.pluginType".equals(pJ.getNome())) continue;
                    try {
                        cascadeConfigPlugin2 = new ArchiveCascadeConfiguration();
                        cascadeConfigPlugin2.setCascadePluginConfigurazione(true);
                        this.readPlugin_classe(archive, TipoPlugin.TOKEN_VALIDAZIONE.getValue(), pJ.getValore(), cascadeConfigPlugin2, provenienza);
                        continue;
                    }
                    catch (DriverConfigurazioneNotFound cascadeConfigPlugin5) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (!"policy.userInfo.claimsParser".equals(p.getNome()) || !"CUSTOM".equals(p.getValore())) continue;
            for (j = 0; j < policy.sizePropertyList(); ++j) {
                pJ = policy.getProperty(j);
                if (!"policy.userInfo.claimsParser.pluginType".equals(pJ.getNome())) continue;
                try {
                    cascadeConfigPlugin2 = new ArchiveCascadeConfiguration();
                    cascadeConfigPlugin2.setCascadePluginConfigurazione(true);
                    this.readPlugin_classe(archive, TipoPlugin.TOKEN_VALIDAZIONE.getValue(), pJ.getValore(), cascadeConfigPlugin2, provenienza);
                    continue;
                }
                catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                    // empty catch block
                }
            }
        }
    }

    private void readTokenPolicy_retrieve(Archive archive, String nomePolicy, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        if (cascadeConfig.isCascadePolicyConfigurazione() || ArchiveType.CONFIGURAZIONE_TOKEN_POLICY.equals((Object)provenienza)) {
            String key = ArchiveTokenPolicy.buildKey((String)"retrievePolicyToken", (String)nomePolicy);
            if (!archive.getToken_retrieve_policies().containsKey(key)) {
                GenericProperties policy = this.archiveEngine.getGenericProperties_retrieve(nomePolicy);
                archive.getToken_retrieve_policies().add((Object)new ArchiveTokenPolicy(policy, this.idCorrelazione));
                if (policy != null && policy.sizePropertyList() > 0) {
                    for (int i = 0; i < policy.sizePropertyList(); ++i) {
                        Property p = policy.getProperty(i);
                        if (!"policy.retrieveToken.claimsParser.custom".equals(p.getNome()) || !"CUSTOM".equals(p.getValore())) continue;
                        for (int j = 0; j < policy.sizePropertyList(); ++j) {
                            Property pJ = policy.getProperty(j);
                            if (!"policy.retrieveToken.claimsParser.pluginType".equals(pJ.getNome())) continue;
                            try {
                                ArchiveCascadeConfiguration cascadeConfigPlugin = new ArchiveCascadeConfiguration();
                                cascadeConfigPlugin.setCascadePluginConfigurazione(true);
                                this.readPlugin_classe(archive, TipoPlugin.TOKEN_NEGOZIAZIONE.getValue(), pJ.getValore(), cascadeConfigPlugin, provenienza);
                                continue;
                            }
                            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
    }

    private void readAttributeAuthorityConfigurazione(Archive archive, ArchiveType provenienza) throws Exception {
        ArchiveCascadeConfiguration cascadeConfigPolicy = new ArchiveCascadeConfiguration();
        cascadeConfigPolicy.setCascadePolicyConfigurazione(true);
        List<IDGenericProperties> listAttributeAuthorities = null;
        try {
            listAttributeAuthorities = this.archiveEngine.getAllIdGenericProperties_attributeAuthorities();
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        if (listAttributeAuthorities != null && listAttributeAuthorities.size() > 0) {
            for (IDGenericProperties idGP : listAttributeAuthorities) {
                this.readAttributeAuthority(archive, idGP.getNome(), cascadeConfigPolicy, provenienza);
            }
        }
    }

    private void readAttributeAuthority(Archive archive, IDGenericProperties idGP, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        if ("attributeAuthority".equals(idGP.getTipologia())) {
            this.readAttributeAuthority(archive, idGP.getNome(), cascadeConfig, provenienza);
        }
    }

    private void readAttributeAuthority(Archive archive, String nomePolicy, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        if (cascadeConfig.isCascadePolicyConfigurazione() || ArchiveType.CONFIGURAZIONE_ATTRIBUTE_AUTHORITY.equals((Object)provenienza)) {
            String key = ArchiveAttributeAuthority.buildKey((String)"attributeAuthority", (String)nomePolicy);
            if (!archive.getAttributeAuthorities().containsKey(key)) {
                GenericProperties policy = this.archiveEngine.getGenericProperties_attributeAuthority(nomePolicy);
                archive.getAttributeAuthorities().add((Object)new ArchiveAttributeAuthority(policy, this.idCorrelazione));
                if (policy != null && policy.sizePropertyList() > 0) {
                    for (int i = 0; i < policy.sizePropertyList(); ++i) {
                        Property p = policy.getProperty(i);
                        if (!"policy.attributeAuthority.response.type".equals(p.getNome()) || !"custom".equals(p.getValore())) continue;
                        for (int j = 0; j < policy.sizePropertyList(); ++j) {
                            Property pJ = policy.getProperty(j);
                            if (!"policy.attributeAuthority.claimsParser.pluginType".equals(pJ.getNome())) continue;
                            try {
                                ArchiveCascadeConfiguration cascadeConfigPlugin = new ArchiveCascadeConfiguration();
                                cascadeConfigPlugin.setCascadePluginConfigurazione(true);
                                this.readPlugin_classe(archive, TipoPlugin.ATTRIBUTE_AUTHORITY.getValue(), pJ.getValore(), cascadeConfigPlugin, provenienza);
                                continue;
                            }
                            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
    }

    private void readPluginConfigurazione(Archive archive, ArchiveType provenienza) throws Exception {
        ArchiveCascadeConfiguration cascadeConfigPlugin = new ArchiveCascadeConfiguration();
        cascadeConfigPlugin.setCascadePluginConfigurazione(true);
        List<IdPlugin> listPluginClasse = null;
        try {
            listPluginClasse = this.archiveEngine.getAllIdPluginClasse();
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        if (listPluginClasse != null && listPluginClasse.size() > 0) {
            for (IdPlugin idP : listPluginClasse) {
                this.readPlugin_classe(archive, idP.getTipoPlugin(), idP.getTipo(), cascadeConfigPlugin, provenienza);
            }
        }
        List<String> listPluginArchivi = null;
        try {
            listPluginArchivi = this.archiveEngine.getAllIdPluginArchivio();
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        if (listPluginArchivi != null && listPluginArchivi.size() > 0) {
            for (String idP : listPluginArchivi) {
                this.readPlugin_archivio(archive, idP, cascadeConfigPlugin, provenienza);
            }
        }
    }

    private void readPlugin_classe(Archive archive, IdPlugin idPlugin, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readPlugin_classe(archive, idPlugin.getTipoPlugin(), idPlugin.getTipo(), cascadeConfig, provenienza);
    }

    private void readPlugin_classe(Archive archive, String tipoPlugin, String tipo, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        if (cascadeConfig.isCascadePluginConfigurazione() || ArchiveType.CONFIGURAZIONE_PLUGIN_CLASSE.equals((Object)provenienza)) {
            String key = ArchivePluginClasse.buildKey((String)tipoPlugin, (String)tipo);
            if (!archive.getPlugin_classi().containsKey(key)) {
                archive.getPlugin_classi().add((Object)new ArchivePluginClasse(this.archiveEngine.getPluginClasse(tipoPlugin, tipo), this.idCorrelazione));
            }
        }
    }

    private void readPlugin_archivio(Archive archive, String nome, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        if (cascadeConfig.isCascadePluginConfigurazione() || ArchiveType.CONFIGURAZIONE_PLUGIN_ARCHVIO.equals((Object)provenienza)) {
            String key = ArchivePluginArchivio.buildKey((String)nome);
            if (!archive.getPlugin_archivi().containsKey(key)) {
                archive.getPlugin_archivi().add((Object)new ArchivePluginArchivio(this.archiveEngine.getPluginArchivio(nome), this.idCorrelazione));
            }
        }
    }

    private void readPdd(Archive archive, String nomePdd, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readPdd(archive, nomePdd, cascadeConfig, true, provenienza);
    }

    private void readPdd(Archive archive, String nomePdd, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String key = ArchivePdd.buildKey((String)nomePdd);
        if (!archive.getPdd().containsKey(key)) {
            try {
                if (cascadeConfig.isCascadePdd() || ArchiveType.PDD.equals((Object)provenienza)) {
                    PortaDominio pdd = this.archiveEngine.getPortaDominio(nomePdd);
                    ArchivePdd archivePdd = new ArchivePdd(pdd, this.idCorrelazione);
                    archive.getPdd().add((Object)archivePdd);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(PdD " + nomePdd + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaSoggetti filtroSoggetti = new FiltroRicercaSoggetti();
            filtroSoggetti.setNomePdd(nomePdd);
            try {
                List<IDSoggetto> idsSoggetti = this.archiveEngine.getAllIdSoggettiRegistro(filtroSoggetti);
                if (idsSoggetti != null && idsSoggetti.size() > 0) {
                    for (IDSoggetto idSoggetto : idsSoggetti) {
                        this.readSoggetto(archive, idSoggetto, cascadeConfig, ArchiveType.PDD);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
        }
    }

    private void readGruppo(Archive archive, IDGruppo idGruppo, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readGruppo(archive, idGruppo, cascadeConfig, true, provenienza);
    }

    /*
     * WARNING - void declaration
     */
    private void readGruppo(Archive archive, IDGruppo idGruppo, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String key = ArchiveGruppo.buildKey((String)idGruppo.getNome());
        if (!archive.getGruppi().containsKey(key)) {
            try {
                if (cascadeConfig.isCascadeGruppi() || ArchiveType.GRUPPO.equals((Object)provenienza)) {
                    Gruppo gruppo = this.archiveEngine.getGruppo(idGruppo);
                    ArchiveGruppo archiveGruppo = new ArchiveGruppo(gruppo, this.idCorrelazione);
                    archive.getGruppi().add((Object)archiveGruppo);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(Gruppo " + idGruppo.getNome() + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaAccordi filtroAccordiServizioParteComune = new FiltroRicercaAccordi();
            filtroAccordiServizioParteComune.setIdGruppo(idGruppo);
            filtroAccordiServizioParteComune.setServizioComposto(Boolean.valueOf(false));
            try {
                List<IDAccordo> idsAccordi = this.archiveEngine.getAllIdAccordiServizioParteComune(filtroAccordiServizioParteComune);
                if (idsAccordi != null && idsAccordi.size() > 0) {
                    for (IDAccordo iDAccordo : idsAccordi) {
                        this.readAccordoServizioParteComune(archive, iDAccordo, cascadeConfig, ArchiveType.GRUPPO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound idsAccordi) {
                // empty catch block
            }
            FiltroRicercaAccordi filtroAccordiServizioComposto = new FiltroRicercaAccordi();
            filtroAccordiServizioComposto.setIdGruppo(idGruppo);
            filtroAccordiServizioComposto.setServizioComposto(Boolean.valueOf(true));
            try {
                List<IDAccordo> idsAccordi = this.archiveEngine.getAllIdAccordiServizioParteComune(filtroAccordiServizioComposto);
                if (idsAccordi != null && idsAccordi.size() > 0) {
                    for (IDAccordo idAccordo : idsAccordi) {
                        this.readAccordoServizioComposto(archive, idAccordo, cascadeConfig, ArchiveType.GRUPPO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound idsAccordi) {
                // empty catch block
            }
            if (cascadeConfig.isCascadePolicyConfigurazione()) {
                void var10_22;
                List<IdActivePolicy> listControlloTraffico_activePolicies = null;
                try {
                    listControlloTraffico_activePolicies = this.archiveEngine.getAllIdControlloTraffico_activePolicies_all(idGruppo.getNome());
                }
                catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                    // empty catch block
                }
                if (listControlloTraffico_activePolicies != null && listControlloTraffico_activePolicies.size() > 0) {
                    for (IdActivePolicy idPolicy : listControlloTraffico_activePolicies) {
                        this.readControlloTraffico_activePolicy(archive, idPolicy, cascadeConfig, provenienza);
                    }
                }
                Object var10_20 = null;
                try {
                    List<IdAllarme> list = this.archiveEngine.getAllIdAllarmi_all(idGruppo.getNome());
                }
                catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                    // empty catch block
                }
                if (var10_22 != null && var10_22.size() > 0) {
                    for (IdAllarme idAllarme : var10_22) {
                        this.readAllarme(archive, idAllarme, cascadeConfig, provenienza);
                    }
                }
            }
        }
    }

    private void readRuolo(Archive archive, IDRuolo idRuolo, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readRuolo(archive, idRuolo, cascadeConfig, true, provenienza);
    }

    private void readRuolo(Archive archive, IDRuolo idRuolo, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String key = ArchiveRuolo.buildKey((String)idRuolo.getNome());
        if (!archive.getRuoli().containsKey(key)) {
            try {
                if (cascadeConfig.isCascadeRuoli() || ArchiveType.RUOLO.equals((Object)provenienza)) {
                    Ruolo ruolo = this.archiveEngine.getRuolo(idRuolo);
                    ArchiveRuolo archiveRuolo = new ArchiveRuolo(ruolo, this.idCorrelazione);
                    archive.getRuoli().add((Object)archiveRuolo);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(Ruolo " + idRuolo.getNome() + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti) {
            Object _idsPA2;
            Object _idsPD2;
            FiltroRicercaSoggetti filtroSoggetti = new FiltroRicercaSoggetti();
            filtroSoggetti.setIdRuolo(idRuolo);
            try {
                List<IDSoggetto> idsSoggetti = this.archiveEngine.getAllIdSoggettiRegistro(filtroSoggetti);
                if (idsSoggetti != null && idsSoggetti.size() > 0) {
                    for (IDSoggetto idSoggetto : idsSoggetti) {
                        this.readSoggetto(archive, idSoggetto, cascadeConfig, ArchiveType.RUOLO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound idsSoggetti) {
                // empty catch block
            }
            ArrayList<IDPortaDelegata> idsPD = new ArrayList<IDPortaDelegata>();
            FiltroRicercaPorteDelegate filtroPorteDelegate = new FiltroRicercaPorteDelegate();
            filtroPorteDelegate.setIdRuolo(idRuolo);
            try {
                _idsPD2 = this.archiveEngine.getAllIdPorteDelegate(filtroPorteDelegate);
                if (_idsPD2 != null && _idsPD2.size() > 0) {
                    idsPD.addAll((Collection<IDPortaDelegata>)_idsPD2);
                }
            }
            catch (DriverConfigurazioneNotFound _idsPD2) {
                // empty catch block
            }
            filtroPorteDelegate = new FiltroRicercaPorteDelegate();
            filtroPorteDelegate.setIdRuoloToken(idRuolo);
            try {
                _idsPD2 = this.archiveEngine.getAllIdPorteDelegate(filtroPorteDelegate);
                if (_idsPD2 != null && _idsPD2.size() > 0) {
                    Iterator iterator = _idsPD2.iterator();
                    while (iterator.hasNext()) {
                        IDPortaDelegata idPortaDelegataCheck = (IDPortaDelegata)iterator.next();
                        if (idsPD.contains(idPortaDelegataCheck)) continue;
                        idsPD.add(idPortaDelegataCheck);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound _idsPD3) {
                // empty catch block
            }
            if (idsPD != null && idsPD.size() > 0) {
                for (IDPortaDelegata idPD : idsPD) {
                    this.readPortaDelegata(archive, idPD, cascadeConfig, ArchiveType.RUOLO);
                }
            }
            ArrayList<IDPortaApplicativa> idsPA = new ArrayList<IDPortaApplicativa>();
            FiltroRicercaPorteApplicative filtroPorteApplicative = new FiltroRicercaPorteApplicative();
            filtroPorteApplicative.setIdRuolo(idRuolo);
            try {
                _idsPA2 = this.archiveEngine.getAllIdPorteApplicative(filtroPorteApplicative);
                if (_idsPA2 != null && !_idsPA2.isEmpty()) {
                    idsPA.addAll((Collection<IDPortaApplicativa>)_idsPA2);
                }
            }
            catch (DriverConfigurazioneNotFound _idsPA2) {
                // empty catch block
            }
            filtroPorteApplicative = new FiltroRicercaPorteApplicative();
            filtroPorteApplicative.setIdRuoloToken(idRuolo);
            try {
                _idsPA2 = this.archiveEngine.getAllIdPorteApplicative(filtroPorteApplicative);
                if (_idsPA2 != null && !_idsPA2.isEmpty()) {
                    Iterator iterator = _idsPA2.iterator();
                    while (iterator.hasNext()) {
                        IDPortaApplicativa idPortaApplicativaCheck = (IDPortaApplicativa)iterator.next();
                        if (idsPA.contains(idPortaApplicativaCheck)) continue;
                        idsPA.add(idPortaApplicativaCheck);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound _idsPA3) {
                // empty catch block
            }
            if (idsPA != null && idsPA.size() > 0) {
                for (IDPortaApplicativa idPA : idsPA) {
                    this.readPortaApplicativa(archive, idPA, cascadeConfig, ArchiveType.RUOLO);
                }
            }
            FiltroRicercaServiziApplicativi filtroServiziApplicativi = new FiltroRicercaServiziApplicativi();
            filtroServiziApplicativi.setIdRuolo(idRuolo);
            try {
                List<IDServizioApplicativo> idsSA = this.archiveEngine.getAllIdServiziApplicativi(filtroServiziApplicativi);
                if (idsSA != null && idsSA.size() > 0) {
                    for (IDServizioApplicativo idSA : idsSA) {
                        this.readServizioApplicativo(archive, idSA, cascadeConfig, ArchiveType.RUOLO);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
        }
    }

    private void readScope(Archive archive, IDScope idScope, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readScope(archive, idScope, cascadeConfig, true, provenienza);
    }

    private void readScope(Archive archive, IDScope idScope, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String key = ArchiveScope.buildKey((String)idScope.getNome());
        if (!archive.getScope().containsKey(key)) {
            try {
                if (cascadeConfig.isCascadeScope() || ArchiveType.SCOPE.equals((Object)provenienza)) {
                    org.openspcoop2.core.registry.Scope scope = this.archiveEngine.getScope(idScope);
                    ArchiveScope archiveScope = new ArchiveScope(scope, this.idCorrelazione);
                    archive.getScope().add((Object)archiveScope);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(Scope " + idScope.getNome() + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaPorteDelegate filtroPorteDelegate = new FiltroRicercaPorteDelegate();
            filtroPorteDelegate.setIdScope(idScope);
            try {
                List<IDPortaDelegata> idsPD = this.archiveEngine.getAllIdPorteDelegate(filtroPorteDelegate);
                if (idsPD != null && idsPD.size() > 0) {
                    for (IDPortaDelegata idPD : idsPD) {
                        this.readPortaDelegata(archive, idPD, cascadeConfig, ArchiveType.SCOPE);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound idsPD) {
                // empty catch block
            }
            FiltroRicercaPorteApplicative filtroPorteApplicative = new FiltroRicercaPorteApplicative();
            filtroPorteApplicative.setIdScope(idScope);
            try {
                List<IDPortaApplicativa> idsPA = this.archiveEngine.getAllIdPorteApplicative(filtroPorteApplicative);
                if (idsPA != null && idsPA.size() > 0) {
                    for (IDPortaApplicativa idPA : idsPA) {
                        this.readPortaApplicativa(archive, idPA, cascadeConfig, ArchiveType.SCOPE);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
        }
    }

    private void readSoggetto(Archive archive, IDSoggetto idSoggetto, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readSoggetto(archive, idSoggetto, cascadeConfig, true, provenienza);
    }

    private void readSoggetto(Archive archive, IDSoggetto idSoggetto, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        block41: {
            String key = ArchiveSoggetto.buildKey((String)idSoggetto.getTipo(), (String)idSoggetto.getNome());
            if (!archive.getSoggetti().containsKey(key)) {
                try {
                    if (!cascadeConfig.isCascadeSoggetti() && !ArchiveType.SOGGETTO.equals((Object)provenienza)) break block41;
                    org.openspcoop2.core.registry.Soggetto soggettoRegistro = this.archiveEngine.getSoggettoRegistro(idSoggetto);
                    Soggetto soggettoConfigurazione = this.archiveEngine.getSoggettoConfigurazione(idSoggetto);
                    ArchiveSoggetto archiveSoggetto = new ArchiveSoggetto(soggettoConfigurazione, soggettoRegistro, this.idCorrelazione);
                    archive.getSoggetti().add((Object)archiveSoggetto);
                    FiltroRicerca filtroRicerca = new FiltroRicerca();
                    filtroRicerca.setNome(soggettoRegistro.getPortaDominio());
                    try {
                        List<String> idsPdD = this.archiveEngine.getAllIdPorteDominio(filtroRicerca);
                        if (idsPdD != null && idsPdD.size() > 0) {
                            for (String string : idsPdD) {
                                this.readPdd(archive, string, cascadeConfig, false, ArchiveType.SOGGETTO);
                            }
                        }
                    }
                    catch (DriverRegistroServiziNotFound idsPdD) {
                        // empty catch block
                    }
                    if (soggettoRegistro.getRuoli() != null && soggettoRegistro.getRuoli().sizeRuoloList() > 0) {
                        for (int i = 0; i < soggettoRegistro.getRuoli().sizeRuoloList(); ++i) {
                            RuoloSoggetto ruoloSoggetto = soggettoRegistro.getRuoli().getRuolo(i);
                            FiltroRicercaRuoli filtroRicercaRuoli = new FiltroRicercaRuoli();
                            filtroRicercaRuoli.setNome(ruoloSoggetto.getNome());
                            try {
                                List<IDRuolo> list = this.archiveEngine.getAllIdRuoli(filtroRicercaRuoli);
                                if (list == null || list.size() <= 0) continue;
                                for (IDRuolo idRuolo : list) {
                                    this.readRuolo(archive, idRuolo, cascadeConfig, false, ArchiveType.SOGGETTO);
                                }
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException("(Soggetto " + idSoggetto + ") " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaServiziApplicativi filtroServiziApplicativi = new FiltroRicercaServiziApplicativi();
            filtroServiziApplicativi.setTipoSoggetto(idSoggetto.getTipo());
            filtroServiziApplicativi.setNomeSoggetto(idSoggetto.getNome());
            try {
                List<IDServizioApplicativo> idsSA = this.archiveEngine.getAllIdServiziApplicativi(filtroServiziApplicativi);
                if (idsSA != null && idsSA.size() > 0) {
                    for (IDServizioApplicativo iDServizioApplicativo : idsSA) {
                        this.readServizioApplicativo(archive, iDServizioApplicativo, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound idsSA) {
                // empty catch block
            }
            FiltroRicercaAccordi filtroAccordiCooperazione = new FiltroRicercaAccordi();
            filtroAccordiCooperazione.setTipoSoggettoReferente(idSoggetto.getTipo());
            filtroAccordiCooperazione.setNomeSoggettoReferente(idSoggetto.getNome());
            try {
                List<IDAccordoCooperazione> idsAC = this.archiveEngine.getAllIdAccordiCooperazione(filtroAccordiCooperazione);
                if (idsAC != null && idsAC.size() > 0) {
                    for (IDAccordoCooperazione idAccordoCooperazione : idsAC) {
                        this.readAccordoCooperazione(archive, idAccordoCooperazione, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound idsAC) {
                // empty catch block
            }
            FiltroRicercaAccordi filtroAccordiServizioParteComune = new FiltroRicercaAccordi();
            filtroAccordiServizioParteComune.setTipoSoggettoReferente(idSoggetto.getTipo());
            filtroAccordiServizioParteComune.setNomeSoggettoReferente(idSoggetto.getNome());
            filtroAccordiServizioParteComune.setServizioComposto(Boolean.valueOf(false));
            try {
                List<IDAccordo> list = this.archiveEngine.getAllIdAccordiServizioParteComune(filtroAccordiServizioParteComune);
                if (list != null && list.size() > 0) {
                    for (IDAccordo iDAccordo : list) {
                        this.readAccordoServizioParteComune(archive, iDAccordo, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            FiltroRicercaAccordi filtroRicercaAccordi = new FiltroRicercaAccordi();
            filtroRicercaAccordi.setTipoSoggettoReferente(idSoggetto.getTipo());
            filtroRicercaAccordi.setNomeSoggettoReferente(idSoggetto.getNome());
            filtroRicercaAccordi.setServizioComposto(Boolean.valueOf(true));
            try {
                List<IDAccordo> idsAccordi = this.archiveEngine.getAllIdAccordiServizioParteComune(filtroRicercaAccordi);
                if (idsAccordi != null && idsAccordi.size() > 0) {
                    for (IDAccordo iDAccordo : idsAccordi) {
                        this.readAccordoServizioComposto(archive, iDAccordo, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound idsAccordi) {
                // empty catch block
            }
            FiltroRicercaServizi filtroAccordiServizioParteSpecifica = new FiltroRicercaServizi();
            filtroAccordiServizioParteSpecifica.setTipoSoggettoErogatore(idSoggetto.getTipo());
            filtroAccordiServizioParteSpecifica.setNomeSoggettoErogatore(idSoggetto.getNome());
            try {
                List<IDServizio> list = this.archiveEngine.getAllIdAccordiServizioParteSpecifica(filtroAccordiServizioParteSpecifica);
                if (list != null && list.size() > 0) {
                    for (IDServizio iDServizio : list) {
                        this.readAccordoServizioParteSpecifica(archive, iDServizio, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            FiltroRicercaPorteDelegate filtroRicercaPorteDelegate = new FiltroRicercaPorteDelegate();
            filtroRicercaPorteDelegate.setTipoSoggetto(idSoggetto.getTipo());
            filtroRicercaPorteDelegate.setNomeSoggetto(idSoggetto.getNome());
            try {
                List<IDPortaDelegata> list = this.archiveEngine.getAllIdPorteDelegate(filtroRicercaPorteDelegate);
                if (list != null && list.size() > 0) {
                    for (IDPortaDelegata idPortaDelegata : list) {
                        this.readPortaDelegata(archive, idPortaDelegata, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            FiltroRicercaPorteApplicative filtroRicercaPorteApplicative = new FiltroRicercaPorteApplicative();
            filtroRicercaPorteApplicative.setTipoSoggetto(idSoggetto.getTipo());
            filtroRicercaPorteApplicative.setNomeSoggetto(idSoggetto.getNome());
            try {
                List<IDPortaApplicativa> list = this.archiveEngine.getAllIdPorteApplicative(filtroRicercaPorteApplicative);
                if (list != null && list.size() > 0) {
                    for (IDPortaApplicativa idPortaApplicativa : list) {
                        this.readPortaApplicativa(archive, idPortaApplicativa, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
        }
    }

    private void readServizioApplicativo(Archive archive, IDServizioApplicativo idServizioApplicativo, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readServizioApplicativo(archive, idServizioApplicativo, cascadeConfig, true, provenienza);
    }

    private void readServizioApplicativo(Archive archive, IDServizioApplicativo idServizioApplicativo, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        block28: {
            String key = ArchiveServizioApplicativo.buildKey((String)idServizioApplicativo.getIdSoggettoProprietario().getTipo(), (String)idServizioApplicativo.getIdSoggettoProprietario().getNome(), (String)idServizioApplicativo.getNome());
            if (!archive.getServiziApplicativi().containsKey(key)) {
                try {
                    TipiConnettore tipo;
                    boolean enabled = cascadeConfig.isCascadeServiziApplicativi();
                    switch (provenienza) {
                        case SOGGETTO: {
                            break;
                        }
                        case SERVIZIO_APPLICATIVO: {
                            enabled = enabled || ArchiveType.SERVIZIO_APPLICATIVO.equals((Object)provenienza);
                            break;
                        }
                        case PORTA_DELEGATA: {
                            enabled = enabled && cascadeConfig.isCascadePorteDelegate();
                            break;
                        }
                        case PORTA_APPLICATIVA: {
                            enabled = enabled && cascadeConfig.isCascadePorteApplicative();
                            break;
                        }
                        case FRUITORE: {
                            enabled = enabled && cascadeConfig.isCascadeFruizioni();
                            break;
                        }
                    }
                    if (!enabled) break block28;
                    ServizioApplicativo sa = this.archiveEngine.getServizioApplicativo(idServizioApplicativo);
                    if (sa == null) {
                        throw new Exception("Servizio Applicativo '" + idServizioApplicativo + "' non esistente");
                    }
                    if (sa.getTipoSoggettoProprietario() == null) {
                        sa.setTipoSoggettoProprietario(idServizioApplicativo.getIdSoggettoProprietario().getTipo());
                    }
                    if (sa.getNomeSoggettoProprietario() == null) {
                        sa.setNomeSoggettoProprietario(idServizioApplicativo.getIdSoggettoProprietario().getNome());
                    }
                    ArchiveServizioApplicativo archiveSa = new ArchiveServizioApplicativo(sa, this.idCorrelazione);
                    archive.getServiziApplicativi().add((Object)archiveSa);
                    this.readSoggetto(archive, idServizioApplicativo.getIdSoggettoProprietario(), cascadeConfig, false, ArchiveType.SERVIZIO_APPLICATIVO);
                    if (sa.getInvocazionePorta() != null && sa.getInvocazionePorta().getRuoli() != null && sa.getInvocazionePorta().getRuoli().sizeRuoloList() > 0) {
                        for (int i = 0; i < sa.getInvocazionePorta().getRuoli().sizeRuoloList(); ++i) {
                            org.openspcoop2.core.config.Ruolo ruolo = sa.getInvocazionePorta().getRuoli().getRuolo(i);
                            FiltroRicercaRuoli filtroRuolo = new FiltroRicercaRuoli();
                            filtroRuolo.setNome(ruolo.getNome());
                            try {
                                List<IDRuolo> idsRuoli = this.archiveEngine.getAllIdRuoli(filtroRuolo);
                                if (idsRuoli == null || idsRuoli.size() <= 0) continue;
                                for (IDRuolo idRuolo : idsRuoli) {
                                    this.readRuolo(archive, idRuolo, cascadeConfig, false, ArchiveType.SERVIZIO_APPLICATIVO);
                                }
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                // empty catch block
                            }
                        }
                    }
                    if (cascadeConfig.isCascadePolicyConfigurazione()) {
                        if (sa != null && sa.getInvocazioneServizio() != null && sa.getInvocazioneServizio().getConnettore() != null && sa.getInvocazioneServizio().getConnettore().getProperties() != null && sa.getInvocazioneServizio().getConnettore().getProperties().containsKey("tokenPolicy")) {
                            this.readTokenPolicy_retrieve(archive, (String)sa.getInvocazioneServizio().getConnettore().getProperties().get("tokenPolicy"), cascadeConfig, provenienza);
                        }
                        if (sa != null && sa.getRispostaAsincrona() != null && sa.getRispostaAsincrona().getConnettore() != null && sa.getRispostaAsincrona().getConnettore().getProperties() != null && sa.getRispostaAsincrona().getConnettore().getProperties().containsKey("tokenPolicy")) {
                            this.readTokenPolicy_retrieve(archive, (String)sa.getRispostaAsincrona().getConnettore().getProperties().get("tokenPolicy"), cascadeConfig, provenienza);
                        }
                    }
                    if (!cascadeConfig.isCascadePluginConfigurazione()) break block28;
                    if (sa != null && sa.getInvocazioneServizio() != null && sa.getInvocazioneServizio().getConnettore() != null && sa.getInvocazioneServizio().getConnettore().getCustom() != null && sa.getInvocazioneServizio().getConnettore().getCustom().booleanValue() && sa.getInvocazioneServizio().getConnettore().getTipo() != null && (tipo = TipiConnettore.toEnumFromName((String)sa.getInvocazioneServizio().getConnettore().getTipo())) == null) {
                        try {
                            this.readPlugin_classe(archive, TipoPlugin.CONNETTORE.getValue(), sa.getInvocazioneServizio().getConnettore().getTipo(), cascadeConfig, provenienza);
                        }
                        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                            // empty catch block
                        }
                    }
                    if (sa != null && sa.getRispostaAsincrona() != null && sa.getRispostaAsincrona().getConnettore() != null && sa.getRispostaAsincrona().getConnettore().getCustom() != null && sa.getRispostaAsincrona().getConnettore().getCustom().booleanValue() && sa.getRispostaAsincrona().getConnettore().getTipo() != null && (tipo = TipiConnettore.toEnumFromName((String)sa.getRispostaAsincrona().getConnettore().getTipo())) == null) {
                        try {
                            this.readPlugin_classe(archive, TipoPlugin.CONNETTORE.getValue(), sa.getRispostaAsincrona().getConnettore().getTipo(), cascadeConfig, provenienza);
                        }
                        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException("(ServizioApplicativo " + idServizioApplicativo + ") " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (cascadeAvanti) {
            // empty if block
        }
    }

    private void readAccordoCooperazione(Archive archive, IDAccordoCooperazione idAccordoCooperazione, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readAccordoCooperazione(archive, idAccordoCooperazione, cascadeConfig, true, provenienza);
    }

    private void readAccordoCooperazione(Archive archive, IDAccordoCooperazione idAccordoCooperazione, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        if (idAccordoCooperazione.getSoggettoReferente() != null) {
            tipoSoggetto = idAccordoCooperazione.getSoggettoReferente().getTipo();
            nomeSoggetto = idAccordoCooperazione.getSoggettoReferente().getNome();
        }
        String key = ArchiveAccordoCooperazione.buildKey((String)tipoSoggetto, nomeSoggetto, (String)idAccordoCooperazione.getNome(), (Integer)idAccordoCooperazione.getVersione());
        if (!archive.getAccordiCooperazione().containsKey(key)) {
            try {
                if (cascadeConfig.isCascadeAccordoCooperazione() || ArchiveType.ACCORDO_COOPERAZIONE.equals((Object)provenienza)) {
                    AccordoCooperazione ac = this.archiveEngine.getAccordoCooperazione(idAccordoCooperazione, true);
                    ArchiveAccordoCooperazione archiveAc = new ArchiveAccordoCooperazione(ac, this.idCorrelazione);
                    archive.getAccordiCooperazione().add((Object)archiveAc);
                    this.readSoggetto(archive, idAccordoCooperazione.getSoggettoReferente(), cascadeConfig, false, ArchiveType.ACCORDO_COOPERAZIONE);
                    if (ac.getElencoPartecipanti() != null && ac.getElencoPartecipanti().sizeSoggettoPartecipanteList() > 0) {
                        for (IdSoggetto partecipante : ac.getElencoPartecipanti().getSoggettoPartecipanteList()) {
                            IDSoggetto idPartecipante = new IDSoggetto(partecipante.getTipo(), partecipante.getNome());
                            this.readSoggetto(archive, idPartecipante, cascadeConfig, false, ArchiveType.ACCORDO_COOPERAZIONE);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(AccordoCooperazione " + IDAccordoCooperazioneFactory.getInstance().getUriFromIDAccordo(idAccordoCooperazione) + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaAccordi filtroRicercaAccordi = new FiltroRicercaAccordi();
            filtroRicercaAccordi.setIdAccordoCooperazione(idAccordoCooperazione);
            try {
                List<IDAccordo> idsAS = this.archiveEngine.getAllIdAccordiServizioParteComune(filtroRicercaAccordi);
                if (idsAS != null && idsAS.size() > 0) {
                    for (IDAccordo idAccordo : idsAS) {
                        this.readAccordoServizioComposto(archive, idAccordo, cascadeConfig, ArchiveType.ACCORDO_COOPERAZIONE);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
        }
    }

    private void readAccordoServizioParteComune(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readAccordoServizioParteComune(archive, idAccordoServizio, cascadeConfig, true, provenienza);
    }

    private void readAccordoServizioParteComune(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        if (idAccordoServizio.getSoggettoReferente() != null) {
            tipoSoggetto = idAccordoServizio.getSoggettoReferente().getTipo();
            nomeSoggetto = idAccordoServizio.getSoggettoReferente().getNome();
        }
        String key = ArchiveAccordoServizioParteComune.buildKey((String)tipoSoggetto, nomeSoggetto, (String)idAccordoServizio.getNome(), (Integer)idAccordoServizio.getVersione());
        if (!archive.getAccordiServizioParteComune().containsKey(key)) {
            try {
                if (cascadeConfig.isCascadeAccordoServizioParteComune() || ArchiveType.ACCORDO_SERVIZIO_PARTE_COMUNE.equals((Object)provenienza)) {
                    AccordoServizioParteComune as = this.archiveEngine.getAccordoServizioParteComune(idAccordoServizio, true, true);
                    ArchiveAccordoServizioParteComune archiveAs = new ArchiveAccordoServizioParteComune(as, this.idCorrelazione);
                    archive.getAccordiServizioParteComune().add((Object)archiveAs);
                    this.readSoggetto(archive, idAccordoServizio.getSoggettoReferente(), cascadeConfig, false, ArchiveType.ACCORDO_SERVIZIO_PARTE_COMUNE);
                    if (as.getGruppi() != null && as.getGruppi().sizeGruppoList() > 0) {
                        for (GruppoAccordo gruppo : as.getGruppi().getGruppoList()) {
                            IDGruppo idGruppo = new IDGruppo(gruppo.getNome());
                            this.readGruppo(archive, idGruppo, cascadeConfig, false, ArchiveType.GRUPPO);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(AccordoServizioParteComune " + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizio) + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaServizi filtroRicercaAccordi = new FiltroRicercaServizi();
            filtroRicercaAccordi.setIdAccordoServizioParteComune(idAccordoServizio);
            try {
                List<IDServizio> idsAS = this.archiveEngine.getAllIdAccordiServizioParteSpecifica(filtroRicercaAccordi);
                if (idsAS != null && idsAS.size() > 0) {
                    for (IDServizio idAccordo : idsAS) {
                        this.readAccordoServizioParteSpecifica(archive, idAccordo, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_COMUNE);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
        }
    }

    private void readAccordoServizioComposto(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readAccordoServizioComposto(archive, idAccordoServizio, cascadeConfig, true, provenienza);
    }

    private void readAccordoServizioComposto(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        if (idAccordoServizio.getSoggettoReferente() != null) {
            tipoSoggetto = idAccordoServizio.getSoggettoReferente().getTipo();
            nomeSoggetto = idAccordoServizio.getSoggettoReferente().getNome();
        }
        String key = ArchiveAccordoServizioComposto.buildKeyComposto((String)tipoSoggetto, nomeSoggetto, (String)idAccordoServizio.getNome(), (Integer)idAccordoServizio.getVersione());
        AccordoServizioParteComune as = null;
        if (archive.getAccordiServizioComposto().containsKey(key)) {
            as = ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(key)).getAccordoServizioParteComune();
        } else {
            try {
                if (cascadeConfig.isCascadeAccordoServizioComposto() || ArchiveType.ACCORDO_SERVIZIO_COMPOSTO.equals((Object)provenienza)) {
                    as = this.archiveEngine.getAccordoServizioParteComune(idAccordoServizio, true, true);
                    ArchiveAccordoServizioComposto archiveAs = new ArchiveAccordoServizioComposto(as, this.idCorrelazione);
                    archive.getAccordiServizioComposto().add((Object)archiveAs);
                    this.readSoggetto(archive, idAccordoServizio.getSoggettoReferente(), cascadeConfig, false, ArchiveType.ACCORDO_SERVIZIO_COMPOSTO);
                } else {
                    as = this.archiveEngine.getAccordoServizioParteComune(idAccordoServizio, false, true);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(AccordoServizioComposto " + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizio) + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaServizi filtroRicercaAccordi = new FiltroRicercaServizi();
            filtroRicercaAccordi.setIdAccordoServizioParteComune(idAccordoServizio);
            try {
                List<IDServizio> idsAS = this.archiveEngine.getAllIdAccordiServizioParteSpecifica(filtroRicercaAccordi);
                if (idsAS != null && idsAS.size() > 0) {
                    for (IDServizio idAccordo : idsAS) {
                        this.readAccordoServizioParteSpecifica(archive, idAccordo, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_COMPOSTO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            for (AccordoServizioParteComuneServizioCompostoServizioComponente servizioComponente : as.getServizioComposto().getServizioComponenteList()) {
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(servizioComponente.getTipo(), servizioComponente.getNome(), servizioComponente.getTipoSoggetto(), servizioComponente.getNomeSoggetto(), servizioComponente.getVersione().intValue());
                this.readAccordoServizioParteSpecifica(archive, idServizio, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_COMPOSTO);
            }
        }
    }

    private void readAccordoServizioParteSpecifica(Archive archive, IDServizio idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readAccordoServizioParteSpecifica(archive, idAccordoServizio, cascadeConfig, true, provenienza);
    }

    private void readAccordoServizioParteSpecifica(Archive archive, IDServizio idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        AccordoServizioParteSpecifica as;
        ArrayList<Fruitore> fruitoriList;
        block43: {
            String tipoSoggetto = null;
            String nomeSoggetto = null;
            if (idAccordoServizio.getSoggettoErogatore() != null) {
                tipoSoggetto = idAccordoServizio.getSoggettoErogatore().getTipo();
                nomeSoggetto = idAccordoServizio.getSoggettoErogatore().getNome();
            }
            String key = ArchiveAccordoServizioParteSpecifica.buildKey((String)tipoSoggetto, (String)nomeSoggetto, (String)idAccordoServizio.getTipo(), (String)idAccordoServizio.getNome(), (Integer)idAccordoServizio.getVersione());
            fruitoriList = null;
            as = null;
            if (archive.getAccordiServizioParteSpecifica().containsKey(key)) {
                as = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(key)).getAccordoServizioParteSpecifica();
            } else {
                try {
                    TipiConnettore tipiConnettore;
                    List<IDPortaApplicativa> listIDPA;
                    if (!cascadeConfig.isCascadeAccordoServizioParteSpecifica() && !ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA.equals((Object)provenienza) && !ArchiveType.EROGAZIONE.equals((Object)provenienza) && !ArchiveType.FRUIZIONE.equals((Object)provenienza)) break block43;
                    fruitoriList = new ArrayList<Fruitore>();
                    as = this.archiveEngine.getAccordoServizioParteSpecifica(idAccordoServizio, true);
                    if (as == null) {
                        throw new Exception("Accordo di servizio '" + idAccordoServizio + "' non esistente");
                    }
                    if (as.getTipoSoggettoErogatore() == null) {
                        as.setTipoSoggettoErogatore(tipoSoggetto);
                    }
                    if (as.getNomeSoggettoErogatore() == null) {
                        as.setNomeSoggettoErogatore(nomeSoggetto);
                    }
                    ArchiveAccordoServizioParteSpecifica archiveAs = new ArchiveAccordoServizioParteSpecifica(as, this.idCorrelazione);
                    while (as.sizeFruitoreList() > 0) {
                        fruitoriList.add(as.removeFruitore(0));
                    }
                    archive.getAccordiServizioParteSpecifica().add((Object)archiveAs);
                    if (!ArchiveType.FRUIZIONE.equals((Object)provenienza) && (listIDPA = this.archiveEngine.getIDPorteApplicativeAssociateErogazione(idAccordoServizio)) != null && listIDPA.size() > 0) {
                        if (archiveAs.getMappingPorteApplicativeAssociate() == null) {
                            archiveAs.setMappingPorteApplicativeAssociate(new ArrayList());
                        }
                        for (IDPortaApplicativa iDPortaApplicativa : listIDPA) {
                            archiveAs.getMappingPorteApplicativeAssociate().add(this.archiveEngine.getMappingErogazionePortaApplicativa(idAccordoServizio, iDPortaApplicativa));
                        }
                    }
                    this.readSoggetto(archive, idAccordoServizio.getSoggettoErogatore(), cascadeConfig, false, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    IDAccordo idAccordoServizioParteComune = IDAccordoFactory.getInstance().getIDAccordoFromUri(as.getAccordoServizioParteComune());
                    AccordoServizioParteComune aspc = this.archiveEngine.getAccordoServizioParteComune(idAccordoServizioParteComune);
                    if (aspc.getServizioComposto() == null) {
                        this.readAccordoServizioParteComune(archive, idAccordoServizioParteComune, cascadeConfig, false, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    } else {
                        this.readAccordoServizioComposto(archive, idAccordoServizioParteComune, cascadeConfig, false, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    }
                    if (cascadeConfig.isCascadePolicyConfigurazione() && as != null && as.getConfigurazioneServizio() != null) {
                        if (as.getConfigurazioneServizio().getConnettore() != null && as.getConfigurazioneServizio().getConnettore().getProperties() != null && as.getConfigurazioneServizio().getConnettore().getProperties().containsKey("tokenPolicy")) {
                            this.readTokenPolicy_retrieve(archive, (String)as.getConfigurazioneServizio().getConnettore().getProperties().get("tokenPolicy"), cascadeConfig, provenienza);
                        }
                        if (as.getConfigurazioneServizio().sizeConfigurazioneAzioneList() > 0) {
                            for (ConfigurazioneServizioAzione confAzione : as.getConfigurazioneServizio().getConfigurazioneAzioneList()) {
                                if (confAzione.getConnettore() == null || confAzione.getConnettore().getProperties() == null || !confAzione.getConnettore().getProperties().containsKey("tokenPolicy")) continue;
                                this.readTokenPolicy_retrieve(archive, (String)confAzione.getConnettore().getProperties().get("tokenPolicy"), cascadeConfig, provenienza);
                            }
                        }
                    }
                    if (!cascadeConfig.isCascadePluginConfigurazione() || as == null || as.getConfigurazioneServizio() == null) break block43;
                    if (as.getConfigurazioneServizio().getConnettore() != null && as.getConfigurazioneServizio().getConnettore().getCustom() != null && as.getConfigurazioneServizio().getConnettore().getCustom().booleanValue() && as.getConfigurazioneServizio().getConnettore().getTipo() != null && (tipiConnettore = TipiConnettore.toEnumFromName((String)as.getConfigurazioneServizio().getConnettore().getTipo())) == null) {
                        try {
                            this.readPlugin_classe(archive, TipoPlugin.CONNETTORE.getValue(), as.getConfigurazioneServizio().getConnettore().getTipo(), cascadeConfig, provenienza);
                        }
                        catch (DriverConfigurazioneNotFound confAzione) {
                            // empty catch block
                        }
                    }
                    if (as.getConfigurazioneServizio().sizeConfigurazioneAzioneList() > 0) {
                        for (ConfigurazioneServizioAzione confAzione : as.getConfigurazioneServizio().getConfigurazioneAzioneList()) {
                            TipiConnettore tipo2;
                            if (confAzione.getConnettore() == null || confAzione.getConnettore().getCustom() == null || !confAzione.getConnettore().getCustom().booleanValue() || confAzione.getConnettore().getTipo() == null || (tipo2 = TipiConnettore.toEnumFromName((String)confAzione.getConnettore().getTipo())) != null) continue;
                            try {
                                this.readPlugin_classe(archive, TipoPlugin.CONNETTORE.getValue(), confAzione.getConnettore().getTipo(), cascadeConfig, provenienza);
                            }
                            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                        }
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException("(AccordoServizioParteSpecifica " + IDServizioFactory.getInstance().getUriFromIDServizio(idAccordoServizio) + ") " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (cascadeAvanti) {
            List<IDPortaApplicativa> listIDPA_associate;
            if (fruitoriList == null) {
                fruitoriList = new ArrayList();
                as = this.archiveEngine.getAccordoServizioParteSpecifica(idAccordoServizio, true);
                while (as.sizeFruitoreList() > 0) {
                    fruitoriList.add(as.removeFruitore(0));
                }
            }
            for (Fruitore fruitore : fruitoriList) {
                IDSoggetto idFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                this.readFruitore(archive, idAccordoServizio, idFruitore, fruitore, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
            }
            FiltroRicercaPorteDelegate filtroRicercaPorteDelegate = new FiltroRicercaPorteDelegate();
            filtroRicercaPorteDelegate.setTipoSoggettoErogatore(idAccordoServizio.getSoggettoErogatore().getTipo());
            filtroRicercaPorteDelegate.setNomeSoggettoErogatore(idAccordoServizio.getSoggettoErogatore().getNome());
            filtroRicercaPorteDelegate.setTipoServizio(as.getTipo());
            filtroRicercaPorteDelegate.setNomeServizio(as.getNome());
            filtroRicercaPorteDelegate.setVersioneServizio(as.getVersione());
            try {
                List<IDPortaDelegata> idsPD = this.archiveEngine.getAllIdPorteDelegate(filtroRicercaPorteDelegate);
                if (idsPD != null && idsPD.size() > 0) {
                    for (IDPortaDelegata iDPortaDelegata : idsPD) {
                        this.readPortaDelegata(archive, iDPortaDelegata, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound idsPD) {
                // empty catch block
            }
            if ((listIDPA_associate = this.archiveEngine.getIDPorteApplicativeAssociateErogazione(idAccordoServizio)) != null && listIDPA_associate.size() > 0) {
                for (IDPortaApplicativa iDPortaApplicativa : listIDPA_associate) {
                    this.readPortaApplicativa(archive, iDPortaApplicativa, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                }
            }
            FiltroRicercaPorteApplicative filtroRicercaPorteApplicative = new FiltroRicercaPorteApplicative();
            filtroRicercaPorteApplicative.setTipoSoggetto(idAccordoServizio.getSoggettoErogatore().getTipo());
            filtroRicercaPorteApplicative.setNomeSoggetto(idAccordoServizio.getSoggettoErogatore().getNome());
            filtroRicercaPorteApplicative.setTipoServizio(as.getTipo());
            filtroRicercaPorteApplicative.setNomeServizio(as.getNome());
            filtroRicercaPorteApplicative.setVersioneServizio(as.getVersione());
            try {
                List<IDPortaApplicativa> list = this.archiveEngine.getAllIdPorteApplicative(filtroRicercaPorteApplicative);
                if (list != null && list.size() > 0) {
                    for (IDPortaApplicativa idPortaApplicativa : list) {
                        if (listIDPA_associate != null && listIDPA_associate.size() > 0 && listIDPA_associate.contains(idPortaApplicativa)) continue;
                        this.readPortaApplicativa(archive, idPortaApplicativa, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            filtroRicercaPorteApplicative = new FiltroRicercaPorteApplicative();
            filtroRicercaPorteApplicative.setTipoSoggettoVirtuale(idAccordoServizio.getSoggettoErogatore().getTipo());
            filtroRicercaPorteApplicative.setNomeSoggettoVirtuale(idAccordoServizio.getSoggettoErogatore().getNome());
            filtroRicercaPorteApplicative.setTipoServizio(as.getTipo());
            filtroRicercaPorteApplicative.setNomeServizio(as.getNome());
            filtroRicercaPorteApplicative.setVersioneServizio(as.getVersione());
            try {
                List<IDPortaApplicativa> list = this.archiveEngine.getAllIdPorteApplicative(filtroRicercaPorteApplicative);
                if (list != null && list.size() > 0) {
                    for (IDPortaApplicativa idPortaApplicativa : list) {
                        this.readPortaApplicativa(archive, idPortaApplicativa, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
        }
    }

    private void readFruitore(Archive archive, IDServizio idAccordoServizio, IDSoggetto idFruitore, Fruitore fruitore, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readFruitore(archive, idAccordoServizio, idFruitore, fruitore, cascadeConfig, true, provenienza);
    }

    private void readFruitore(Archive archive, IDServizio idAccordoServizio, IDSoggetto idFruitore, Fruitore fruitore, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        List<IDPortaDelegata> listIDPD;
        block22: {
            String tipoSoggetto = null;
            String nomeSoggetto = null;
            if (idAccordoServizio.getSoggettoErogatore() != null) {
                tipoSoggetto = idAccordoServizio.getSoggettoErogatore().getTipo();
                nomeSoggetto = idAccordoServizio.getSoggettoErogatore().getNome();
            }
            String key = ArchiveFruitore.buildKey((String)idFruitore.getTipo(), (String)idFruitore.getNome(), (String)tipoSoggetto, (String)nomeSoggetto, (String)idAccordoServizio.getTipo(), (String)idAccordoServizio.getNome(), (Integer)idAccordoServizio.getVersione());
            if (!archive.getAccordiFruitori().containsKey(key)) {
                try {
                    TipiConnettore tipo;
                    if (!cascadeConfig.isCascadeFruizioni() && !ArchiveType.FRUITORE.equals((Object)provenienza)) break block22;
                    if (fruitore == null) {
                        AccordoServizioParteSpecifica as = this.archiveEngine.getAccordoServizioParteSpecifica(idAccordoServizio, true);
                        for (Object fruitoreCheck : as.getFruitoreList()) {
                            if (!fruitoreCheck.getTipo().equals(idFruitore.getTipo()) || !fruitoreCheck.getNome().equals(idFruitore.getNome())) continue;
                            fruitore = fruitoreCheck;
                            break;
                        }
                    }
                    ArchiveFruitore archiveFruitore = new ArchiveFruitore(idAccordoServizio, fruitore, this.idCorrelazione);
                    archive.getAccordiFruitori().add((Object)archiveFruitore);
                    List<IDPortaDelegata> listIDPD2 = this.archiveEngine.getIDPorteDelegateAssociateFruizione(idAccordoServizio, idFruitore);
                    if (listIDPD2 != null && listIDPD2.size() > 0) {
                        if (archiveFruitore.getMappingPorteDelegateAssociate() == null) {
                            archiveFruitore.setMappingPorteDelegateAssociate(new ArrayList());
                        }
                        for (IDPortaDelegata idPortaDelegata : listIDPD2) {
                            archiveFruitore.getMappingPorteDelegateAssociate().add(this.archiveEngine.getMappingFruizionePortaDelegata(idAccordoServizio, idFruitore, idPortaDelegata));
                        }
                    }
                    this.readSoggetto(archive, idFruitore, cascadeConfig, false, ArchiveType.FRUITORE);
                    this.readAccordoServizioParteSpecifica(archive, idAccordoServizio, cascadeConfig, false, ArchiveType.FRUITORE);
                    if (cascadeConfig.isCascadePolicyConfigurazione() && fruitore != null) {
                        if (fruitore.getConnettore() != null && fruitore.getConnettore().getProperties() != null && fruitore.getConnettore().getProperties().containsKey("tokenPolicy")) {
                            this.readTokenPolicy_retrieve(archive, (String)fruitore.getConnettore().getProperties().get("tokenPolicy"), cascadeConfig, provenienza);
                        }
                        if (fruitore.sizeConfigurazioneAzioneList() > 0) {
                            for (ConfigurazioneServizioAzione confAzione : fruitore.getConfigurazioneAzioneList()) {
                                if (confAzione.getConnettore() == null || confAzione.getConnettore().getProperties() == null || !confAzione.getConnettore().getProperties().containsKey("tokenPolicy")) continue;
                                this.readTokenPolicy_retrieve(archive, (String)confAzione.getConnettore().getProperties().get("tokenPolicy"), cascadeConfig, provenienza);
                            }
                        }
                    }
                    if (!cascadeConfig.isCascadePluginConfigurazione() || fruitore == null) break block22;
                    if (fruitore.getConnettore() != null && fruitore.getConnettore().getCustom() != null && fruitore.getConnettore().getCustom().booleanValue() && fruitore.getConnettore().getTipo() != null && (tipo = TipiConnettore.toEnumFromName((String)fruitore.getConnettore().getTipo())) == null) {
                        try {
                            this.readPlugin_classe(archive, TipoPlugin.CONNETTORE.getValue(), fruitore.getConnettore().getTipo(), cascadeConfig, provenienza);
                        }
                        catch (DriverConfigurazioneNotFound confAzione) {
                            // empty catch block
                        }
                    }
                    if (fruitore.sizeConfigurazioneAzioneList() > 0) {
                        for (ConfigurazioneServizioAzione confAzione : fruitore.getConfigurazioneAzioneList()) {
                            TipiConnettore tipo2;
                            if (confAzione.getConnettore() == null || confAzione.getConnettore().getCustom() == null || !confAzione.getConnettore().getCustom().booleanValue() || confAzione.getConnettore().getTipo() == null || (tipo2 = TipiConnettore.toEnumFromName((String)confAzione.getConnettore().getTipo())) != null) continue;
                            try {
                                this.readPlugin_classe(archive, TipoPlugin.CONNETTORE.getValue(), confAzione.getConnettore().getTipo(), cascadeConfig, provenienza);
                            }
                            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                        }
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException("(Fruitore " + idFruitore + " dell'accordo " + IDServizioFactory.getInstance().getUriFromIDServizio(idAccordoServizio) + ") " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (cascadeAvanti && (listIDPD = this.archiveEngine.getIDPorteDelegateAssociateFruizione(idAccordoServizio, idFruitore)) != null && listIDPD.size() > 0) {
            for (IDPortaDelegata idPortaDelegata_associata : listIDPD) {
                this.readPortaDelegata(archive, idPortaDelegata_associata, cascadeConfig, ArchiveType.FRUITORE);
            }
        }
    }

    private PortaDelegata readPortaDelegata(Archive archive, IDPortaDelegata idPortaDelegata, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        return this.readPortaDelegata(archive, idPortaDelegata, cascadeConfig, true, provenienza);
    }

    private PortaDelegata readPortaDelegata(Archive archive, IDPortaDelegata idPortaDelegata, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        PortaDelegata pd;
        IDSoggetto idSoggettoFruitore;
        block87: {
            idSoggettoFruitore = idPortaDelegata.getIdentificativiFruizione().getSoggettoFruitore();
            String key = ArchivePortaDelegata.buildKey((String)idSoggettoFruitore.getTipo(), (String)idSoggettoFruitore.getNome(), (String)idPortaDelegata.getNome());
            pd = null;
            if (archive.getPorteDelegate().containsKey(key)) {
                pd = ((ArchivePortaDelegata)archive.getPorteDelegate().get(key)).getPortaDelegata();
            } else {
                try {
                    String[] tipi;
                    TipoAutenticazione tipo;
                    List<IDRuolo> idsRuoli2;
                    FiltroRicercaRuoli filtroRuolo;
                    org.openspcoop2.core.config.Ruolo ruolo;
                    pd = this.archiveEngine.getPortaDelegata(idPortaDelegata);
                    if (!cascadeConfig.isCascadePorteDelegate() && !ArchiveType.PORTA_DELEGATA.equals((Object)provenienza)) break block87;
                    if (pd == null) {
                        throw new Exception("Porta delegata '" + idPortaDelegata + "' non esistente");
                    }
                    if (pd.getTipoSoggettoProprietario() == null) {
                        pd.setTipoSoggettoProprietario(idSoggettoFruitore.getTipo());
                    }
                    if (pd.getNomeSoggettoProprietario() == null) {
                        pd.setNomeSoggettoProprietario(idSoggettoFruitore.getNome());
                    }
                    ArchivePortaDelegata archivePd = new ArchivePortaDelegata(pd, this.idCorrelazione);
                    archive.getPorteDelegate().add((Object)archivePd);
                    this.readControlloTrafficoPolicyPorta(archive, true, pd.getNome(), cascadeConfig, provenienza);
                    this.readAllarmiPorta(archive, true, pd.getNome(), cascadeConfig, provenienza);
                    this.readSoggetto(archive, idSoggettoFruitore, cascadeConfig, false, ArchiveType.PORTA_DELEGATA);
                    if (!(pd.getSoggettoErogatore() == null || pd.getSoggettoErogatore().getTipo() == null || "".equals(pd.getSoggettoErogatore().getTipo()) || pd.getSoggettoErogatore().getNome() == null || "".equals(pd.getSoggettoErogatore().getNome()) || pd.getServizio() == null || pd.getServizio().getTipo() == null || "".equals(pd.getServizio().getTipo()) || pd.getServizio().getNome() == null || "".equals(pd.getServizio().getNome()) || pd.getServizio().getVersione() == null)) {
                        IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pd.getServizio().getTipo(), pd.getServizio().getNome(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome(), pd.getServizio().getVersione().intValue());
                        this.readAccordoServizioParteSpecifica(archive, idServizio, cascadeConfig, false, ArchiveType.PORTA_DELEGATA);
                    }
                    if (pd != null && pd.getRuoli() != null && pd.getRuoli().sizeRuoloList() > 0) {
                        for (int i = 0; i < pd.getRuoli().sizeRuoloList(); ++i) {
                            ruolo = pd.getRuoli().getRuolo(i);
                            filtroRuolo = new FiltroRicercaRuoli();
                            filtroRuolo.setNome(ruolo.getNome());
                            try {
                                idsRuoli2 = this.archiveEngine.getAllIdRuoli(filtroRuolo);
                                if (idsRuoli2 == null || idsRuoli2.size() <= 0) continue;
                                for (IDRuolo idRuolo : idsRuoli2) {
                                    this.readRuolo(archive, idRuolo, cascadeConfig, false, ArchiveType.PORTA_DELEGATA);
                                }
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound idsRuoli2) {
                                // empty catch block
                            }
                        }
                    }
                    if (pd.getAutorizzazioneToken() != null && pd.getAutorizzazioneToken().getServiziApplicativi() != null && pd.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                        for (PortaDelegataServizioApplicativo sa : pd.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativoList()) {
                            IDServizioApplicativo idSA = new IDServizioApplicativo();
                            idSA.setIdSoggettoProprietario(idSoggettoFruitore);
                            idSA.setNome(sa.getNome());
                            this.readServizioApplicativo(archive, idSA, cascadeConfig, ArchiveType.PORTA_DELEGATA);
                        }
                    }
                    if (pd != null && pd.getAutorizzazioneToken() != null && pd.getAutorizzazioneToken().getRuoli() != null && pd.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                        for (int i = 0; i < pd.getAutorizzazioneToken().getRuoli().sizeRuoloList(); ++i) {
                            ruolo = pd.getAutorizzazioneToken().getRuoli().getRuolo(i);
                            filtroRuolo = new FiltroRicercaRuoli();
                            filtroRuolo.setNome(ruolo.getNome());
                            try {
                                idsRuoli2 = this.archiveEngine.getAllIdRuoli(filtroRuolo);
                                if (idsRuoli2 == null || idsRuoli2.size() <= 0) continue;
                                for (IDRuolo idRuolo : idsRuoli2) {
                                    this.readRuolo(archive, idRuolo, cascadeConfig, false, ArchiveType.PORTA_DELEGATA);
                                }
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound idsRuoli3) {
                                // empty catch block
                            }
                        }
                    }
                    if (pd != null && pd.getScope() != null && pd.getScope().sizeScopeList() > 0) {
                        for (int i = 0; i < pd.getScope().sizeScopeList(); ++i) {
                            Scope scope = pd.getScope().getScope(i);
                            FiltroRicercaScope filtroScope = new FiltroRicercaScope();
                            filtroScope.setNome(scope.getNome());
                            try {
                                List<IDScope> idsScope = this.archiveEngine.getAllIdScope(filtroScope);
                                if (idsScope == null || idsScope.size() <= 0) continue;
                                for (IDScope idScope : idsScope) {
                                    this.readScope(archive, idScope, cascadeConfig, false, ArchiveType.PORTA_DELEGATA);
                                }
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound idsScope) {
                                // empty catch block
                            }
                        }
                    }
                    if (cascadeConfig.isCascadePolicyConfigurazione() && pd != null && pd.getGestioneToken() != null && pd.getGestioneToken().getPolicy() != null && !"".equals(pd.getGestioneToken().getPolicy())) {
                        this.readTokenPolicy_validation(archive, pd.getGestioneToken().getPolicy(), cascadeConfig, provenienza);
                    }
                    if (cascadeConfig.isCascadePolicyConfigurazione() && pd != null && pd.sizeAttributeAuthorityList() > 0) {
                        for (AttributeAuthority aa : pd.getAttributeAuthorityList()) {
                            String nomeAA = aa.getNome();
                            if (nomeAA == null || "".equals(nomeAA)) continue;
                            this.readAttributeAuthority(archive, nomeAA, cascadeConfig, provenienza);
                        }
                    }
                    if (pd != null && pd.getTrasformazioni() != null && pd.getTrasformazioni().sizeRegolaList() > 0) {
                        for (int i = 0; i < pd.getTrasformazioni().sizeRegolaList(); ++i) {
                            int j;
                            String[] regola = pd.getTrasformazioni().getRegola(i);
                            if (regola.getApplicabilita() == null) continue;
                            if (regola.getApplicabilita().sizeServizioApplicativoList() > 0) {
                                for (j = 0; j < regola.getApplicabilita().sizeServizioApplicativoList(); ++j) {
                                    TrasformazioneRegolaApplicabilitaServizioApplicativo trSa = regola.getApplicabilita().getServizioApplicativo(j);
                                    if (trSa.getTipoSoggettoProprietario() == null || trSa.getNomeSoggettoProprietario() == null || trSa.getNome() == null) continue;
                                    IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
                                    idServizioApplicativo.setNome(trSa.getNome());
                                    idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(trSa.getTipoSoggettoProprietario(), trSa.getNomeSoggettoProprietario()));
                                    this.readServizioApplicativo(archive, idServizioApplicativo, cascadeConfig, false, ArchiveType.PORTA_DELEGATA);
                                }
                            }
                            if (regola.getApplicabilita().sizeSoggettoList() <= 0) continue;
                            for (j = 0; j < regola.getApplicabilita().sizeSoggettoList(); ++j) {
                                TrasformazioneRegolaApplicabilitaSoggetto trSoggetto = regola.getApplicabilita().getSoggetto(j);
                                if (trSoggetto.getTipo() == null || trSoggetto.getNome() == null) continue;
                                IDSoggetto idSoggetto = new IDSoggetto(trSoggetto.getTipo(), trSoggetto.getNome());
                                this.readSoggetto(archive, idSoggetto, cascadeConfig, false, ArchiveType.PORTA_DELEGATA);
                            }
                        }
                    }
                    if (!cascadeConfig.isCascadePluginConfigurazione()) break block87;
                    if (pd != null && StringUtils.isNotEmpty((String)pd.getAutenticazione()) && (tipo = TipoAutenticazione.toEnumConstant((String)pd.getAutenticazione(), (boolean)false)) == null) {
                        try {
                            this.readPlugin_classe(archive, TipoPlugin.AUTENTICAZIONE.getValue(), pd.getAutenticazione(), cascadeConfig, provenienza);
                        }
                        catch (DriverConfigurazioneNotFound regola) {
                            // empty catch block
                        }
                    }
                    if (pd != null && StringUtils.isNotEmpty((String)pd.getAutorizzazione()) && (tipo2 = TipoAutorizzazione.toEnumConstant((String)pd.getAutorizzazione(), (boolean)false)) == null) {
                        try {
                            this.readPlugin_classe(archive, TipoPlugin.AUTORIZZAZIONE.getValue(), pd.getAutorizzazione(), cascadeConfig, provenienza);
                        }
                        catch (DriverConfigurazioneNotFound regola) {
                            // empty catch block
                        }
                    }
                    if (pd != null && StringUtils.isNotEmpty((String)pd.getAutorizzazioneContenuto()) && !"builtIn".equals(pd.getAutorizzazioneContenuto())) {
                        try {
                            this.readPlugin_classe(archive, TipoPlugin.AUTORIZZAZIONE_CONTENUTI.getValue(), pd.getAutorizzazioneContenuto(), cascadeConfig, provenienza);
                        }
                        catch (DriverConfigurazioneNotFound tipo2) {
                            // empty catch block
                        }
                    }
                    if (pd != null && pd.getIntegrazione() != null && StringUtils.isNotEmpty((String)pd.getIntegrazione()) && (tipi = pd.getIntegrazione().trim().split(",")) != null && tipi.length > 0) {
                        for (String t : tipi) {
                            if (!this.archiveEngine.existsPluginClasse(TipoPlugin.INTEGRAZIONE.getValue(), t)) continue;
                            try {
                                this.readPlugin_classe(archive, TipoPlugin.INTEGRAZIONE.getValue(), t, cascadeConfig, provenienza);
                            }
                            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                                // empty catch block
                            }
                        }
                    }
                    if (pd != null && pd.getConfigurazioneHandler() != null) {
                        if (pd.getConfigurazioneHandler().getRequest() != null) {
                            if (pd.getConfigurazioneHandler().getRequest().sizePreInList() > 0) {
                                for (ConfigurazioneHandler ch : pd.getConfigurazioneHandler().getRequest().getPreInList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                            if (pd.getConfigurazioneHandler().getRequest().sizeInList() > 0) {
                                for (ConfigurazioneHandler ch : pd.getConfigurazioneHandler().getRequest().getInList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                            if (pd.getConfigurazioneHandler().getRequest().sizeInProtocolInfoList() > 0) {
                                for (ConfigurazioneHandler ch : pd.getConfigurazioneHandler().getRequest().getInProtocolInfoList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                            if (pd.getConfigurazioneHandler().getRequest().sizeOutList() > 0) {
                                for (ConfigurazioneHandler ch : pd.getConfigurazioneHandler().getRequest().getOutList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                            if (pd.getConfigurazioneHandler().getRequest().sizePostOutList() > 0) {
                                for (ConfigurazioneHandler ch : pd.getConfigurazioneHandler().getRequest().getPostOutList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                        }
                        if (pd.getConfigurazioneHandler().getResponse() != null) {
                            if (pd.getConfigurazioneHandler().getResponse().sizePreInList() > 0) {
                                for (ConfigurazioneHandler ch : pd.getConfigurazioneHandler().getResponse().getPreInList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                            if (pd.getConfigurazioneHandler().getResponse().sizeInList() > 0) {
                                for (ConfigurazioneHandler ch : pd.getConfigurazioneHandler().getResponse().getInList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                            if (pd.getConfigurazioneHandler().getResponse().sizeOutList() > 0) {
                                for (ConfigurazioneHandler ch : pd.getConfigurazioneHandler().getResponse().getOutList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                            if (pd.getConfigurazioneHandler().getResponse().sizePostOutList() > 0) {
                                for (ConfigurazioneHandler ch : pd.getConfigurazioneHandler().getResponse().getPostOutList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException("(PortaDelegata " + idPortaDelegata + ") " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (cascadeAvanti && pd.sizeServizioApplicativoList() > 0) {
            for (PortaDelegataServizioApplicativo sa : pd.getServizioApplicativoList()) {
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(idSoggettoFruitore);
                idSA.setNome(sa.getNome());
                this.readServizioApplicativo(archive, idSA, cascadeConfig, ArchiveType.PORTA_DELEGATA);
            }
        }
        return pd;
    }

    private PortaApplicativa readPortaApplicativa(Archive archive, IDPortaApplicativa idPortaApplicativa, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        return this.readPortaApplicativa(archive, idPortaApplicativa, cascadeConfig, true, provenienza);
    }

    private PortaApplicativa readPortaApplicativa(Archive archive, IDPortaApplicativa idPortaApplicativa, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        PortaApplicativa pa;
        IDSoggetto idSoggettoErogatore;
        block99: {
            idSoggettoErogatore = idPortaApplicativa.getIdentificativiErogazione().getIdServizio().getSoggettoErogatore();
            String key = ArchivePortaApplicativa.buildKey((String)idSoggettoErogatore.getTipo(), (String)idSoggettoErogatore.getNome(), (String)idPortaApplicativa.getNome());
            pa = null;
            if (archive.getPorteApplicative().containsKey(key)) {
                pa = ((ArchivePortaApplicativa)archive.getPorteApplicative().get(key)).getPortaApplicativa();
            } else {
                try {
                    String[] tipi;
                    TipoBehaviour behaviourType;
                    TipoAutenticazione tipo;
                    IDServizioApplicativo idServizioApplicativo;
                    PortaApplicativaAutorizzazioneServizioApplicativo paSa;
                    List<IDRuolo> idsRuoli2;
                    FiltroRicercaRuoli filtroRuolo;
                    org.openspcoop2.core.config.Ruolo ruolo;
                    pa = this.archiveEngine.getPortaApplicativa(idPortaApplicativa);
                    if (!cascadeConfig.isCascadePorteApplicative() && !ArchiveType.PORTA_APPLICATIVA.equals((Object)provenienza)) break block99;
                    if (pa == null) {
                        throw new Exception("Porta applicativa '" + idPortaApplicativa + "' non esistente");
                    }
                    if (pa.getTipoSoggettoProprietario() == null) {
                        pa.setTipoSoggettoProprietario(idSoggettoErogatore.getTipo());
                    }
                    if (pa.getNomeSoggettoProprietario() == null) {
                        pa.setNomeSoggettoProprietario(idSoggettoErogatore.getNome());
                    }
                    ArchivePortaApplicativa archivePa = new ArchivePortaApplicativa(pa, this.idCorrelazione);
                    archive.getPorteApplicative().add((Object)archivePa);
                    this.readControlloTrafficoPolicyPorta(archive, false, pa.getNome(), cascadeConfig, provenienza);
                    this.readAllarmiPorta(archive, false, pa.getNome(), cascadeConfig, provenienza);
                    this.readSoggetto(archive, idSoggettoErogatore, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                    if (pa.getSoggettoVirtuale() != null && pa.getSoggettoVirtuale().getTipo() != null && !"".equals(pa.getSoggettoVirtuale().getTipo()) && pa.getSoggettoVirtuale().getNome() != null && !"".equals(pa.getSoggettoVirtuale().getNome())) {
                        IDSoggetto idSoggetto = new IDSoggetto(pa.getSoggettoVirtuale().getTipo(), pa.getSoggettoVirtuale().getNome());
                        this.readSoggetto(archive, idSoggetto, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                    }
                    if (pa.getServizio() != null && pa.getServizio().getTipo() != null && !"".equals(pa.getServizio().getTipo()) && pa.getServizio().getNome() != null && !"".equals(pa.getServizio().getNome()) && pa.getServizio().getVersione() != null) {
                        IDServizio idServizio;
                        if (pa.getSoggettoVirtuale() != null && pa.getSoggettoVirtuale().getTipo() != null && !"".equals(pa.getSoggettoVirtuale().getTipo()) && pa.getSoggettoVirtuale().getNome() != null && !"".equals(pa.getSoggettoVirtuale().getNome())) {
                            idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pa.getServizio().getTipo(), pa.getServizio().getNome(), pa.getSoggettoVirtuale().getTipo(), pa.getSoggettoVirtuale().getNome(), pa.getServizio().getVersione().intValue());
                            this.readAccordoServizioParteSpecifica(archive, idServizio, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                        } else {
                            idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pa.getServizio().getTipo(), pa.getServizio().getNome(), idSoggettoErogatore, pa.getServizio().getVersione().intValue());
                            this.readAccordoServizioParteSpecifica(archive, idServizio, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                        }
                    }
                    if (pa != null && pa.getRuoli() != null && pa.getRuoli().sizeRuoloList() > 0) {
                        for (int i = 0; i < pa.getRuoli().sizeRuoloList(); ++i) {
                            ruolo = pa.getRuoli().getRuolo(i);
                            filtroRuolo = new FiltroRicercaRuoli();
                            filtroRuolo.setNome(ruolo.getNome());
                            try {
                                idsRuoli2 = this.archiveEngine.getAllIdRuoli(filtroRuolo);
                                if (idsRuoli2 == null || idsRuoli2.size() <= 0) continue;
                                for (IDRuolo idRuolo : idsRuoli2) {
                                    this.readRuolo(archive, idRuolo, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                                }
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound idsRuoli2) {
                                // empty catch block
                            }
                        }
                    }
                    if (pa != null && pa.getAutorizzazioneToken() != null && pa.getAutorizzazioneToken().getServiziApplicativi() != null && pa.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                        for (int i = 0; i < pa.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList(); ++i) {
                            paSa = pa.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativo(i);
                            if (paSa.getTipoSoggettoProprietario() == null || paSa.getNomeSoggettoProprietario() == null || paSa.getNome() == null) continue;
                            idServizioApplicativo = new IDServizioApplicativo();
                            idServizioApplicativo.setNome(paSa.getNome());
                            idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(paSa.getTipoSoggettoProprietario(), paSa.getNomeSoggettoProprietario()));
                            this.readServizioApplicativo(archive, idServizioApplicativo, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                        }
                    }
                    if (pa != null && pa.getAutorizzazioneToken() != null && pa.getAutorizzazioneToken().getRuoli() != null && pa.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                        for (int i = 0; i < pa.getAutorizzazioneToken().getRuoli().sizeRuoloList(); ++i) {
                            ruolo = pa.getAutorizzazioneToken().getRuoli().getRuolo(i);
                            filtroRuolo = new FiltroRicercaRuoli();
                            filtroRuolo.setNome(ruolo.getNome());
                            try {
                                idsRuoli2 = this.archiveEngine.getAllIdRuoli(filtroRuolo);
                                if (idsRuoli2 == null || idsRuoli2.size() <= 0) continue;
                                for (IDRuolo idRuolo : idsRuoli2) {
                                    this.readRuolo(archive, idRuolo, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                                }
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound idsRuoli3) {
                                // empty catch block
                            }
                        }
                    }
                    if (pa != null && pa.getScope() != null && pa.getScope().sizeScopeList() > 0) {
                        for (int i = 0; i < pa.getScope().sizeScopeList(); ++i) {
                            Scope scope = pa.getScope().getScope(i);
                            FiltroRicercaScope filtroScope = new FiltroRicercaScope();
                            filtroScope.setNome(scope.getNome());
                            try {
                                List<IDScope> idsScope = this.archiveEngine.getAllIdScope(filtroScope);
                                if (idsScope == null || idsScope.size() <= 0) continue;
                                for (IDScope idScope : idsScope) {
                                    this.readScope(archive, idScope, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                                }
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound idsScope) {
                                // empty catch block
                            }
                        }
                    }
                    if (cascadeConfig.isCascadePolicyConfigurazione() && pa != null && pa.getGestioneToken() != null && pa.getGestioneToken().getPolicy() != null && !"".equals(pa.getGestioneToken().getPolicy())) {
                        this.readTokenPolicy_validation(archive, pa.getGestioneToken().getPolicy(), cascadeConfig, provenienza);
                    }
                    if (cascadeConfig.isCascadePolicyConfigurazione() && pa != null && pa.sizeAttributeAuthorityList() > 0) {
                        for (AttributeAuthority aa : pa.getAttributeAuthorityList()) {
                            String nomeAA = aa.getNome();
                            if (nomeAA == null || "".equals(nomeAA)) continue;
                            this.readAttributeAuthority(archive, nomeAA, cascadeConfig, provenienza);
                        }
                    }
                    if (pa != null && pa.getServiziApplicativiAutorizzati() != null && pa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0) {
                        for (int i = 0; i < pa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList(); ++i) {
                            paSa = pa.getServiziApplicativiAutorizzati().getServizioApplicativo(i);
                            if (paSa.getTipoSoggettoProprietario() == null || paSa.getNomeSoggettoProprietario() == null || paSa.getNome() == null) continue;
                            idServizioApplicativo = new IDServizioApplicativo();
                            idServizioApplicativo.setNome(paSa.getNome());
                            idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(paSa.getTipoSoggettoProprietario(), paSa.getNomeSoggettoProprietario()));
                            this.readServizioApplicativo(archive, idServizioApplicativo, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                        }
                    }
                    if (pa != null && pa.getSoggetti() != null && pa.getSoggetti().sizeSoggettoList() > 0) {
                        for (int i = 0; i < pa.getSoggetti().sizeSoggettoList(); ++i) {
                            PortaApplicativaAutorizzazioneSoggetto paSoggetto = pa.getSoggetti().getSoggetto(i);
                            if (paSoggetto.getTipo() == null || paSoggetto.getNome() == null) continue;
                            IDSoggetto idSoggetto = new IDSoggetto(paSoggetto.getTipo(), paSoggetto.getNome());
                            this.readSoggetto(archive, idSoggetto, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                        }
                    }
                    if (pa != null && pa.getTrasformazioni() != null && pa.getTrasformazioni().sizeRegolaList() > 0) {
                        for (int i = 0; i < pa.getTrasformazioni().sizeRegolaList(); ++i) {
                            int j;
                            String[] regola = pa.getTrasformazioni().getRegola(i);
                            if (regola.getApplicabilita() == null) continue;
                            if (regola.getApplicabilita().sizeServizioApplicativoList() > 0) {
                                for (j = 0; j < regola.getApplicabilita().sizeServizioApplicativoList(); ++j) {
                                    TrasformazioneRegolaApplicabilitaServizioApplicativo trSa = regola.getApplicabilita().getServizioApplicativo(j);
                                    if (trSa.getTipoSoggettoProprietario() == null || trSa.getNomeSoggettoProprietario() == null || trSa.getNome() == null) continue;
                                    IDServizioApplicativo idServizioApplicativo2 = new IDServizioApplicativo();
                                    idServizioApplicativo2.setNome(trSa.getNome());
                                    idServizioApplicativo2.setIdSoggettoProprietario(new IDSoggetto(trSa.getTipoSoggettoProprietario(), trSa.getNomeSoggettoProprietario()));
                                    this.readServizioApplicativo(archive, idServizioApplicativo2, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                                }
                            }
                            if (regola.getApplicabilita().sizeSoggettoList() <= 0) continue;
                            for (j = 0; j < regola.getApplicabilita().sizeSoggettoList(); ++j) {
                                TrasformazioneRegolaApplicabilitaSoggetto trSoggetto = regola.getApplicabilita().getSoggetto(j);
                                if (trSoggetto.getTipo() == null || trSoggetto.getNome() == null) continue;
                                IDSoggetto idSoggetto = new IDSoggetto(trSoggetto.getTipo(), trSoggetto.getNome());
                                this.readSoggetto(archive, idSoggetto, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                            }
                        }
                    }
                    if (!cascadeConfig.isCascadePluginConfigurazione()) break block99;
                    if (pa != null && StringUtils.isNotEmpty((String)pa.getAutenticazione()) && (tipo = TipoAutenticazione.toEnumConstant((String)pa.getAutenticazione(), (boolean)false)) == null) {
                        try {
                            this.readPlugin_classe(archive, TipoPlugin.AUTENTICAZIONE.getValue(), pa.getAutenticazione(), cascadeConfig, provenienza);
                        }
                        catch (DriverConfigurazioneNotFound regola) {
                            // empty catch block
                        }
                    }
                    if (pa != null && StringUtils.isNotEmpty((String)pa.getAutorizzazione()) && (tipo2 = TipoAutorizzazione.toEnumConstant((String)pa.getAutorizzazione(), (boolean)false)) == null) {
                        try {
                            this.readPlugin_classe(archive, TipoPlugin.AUTORIZZAZIONE.getValue(), pa.getAutorizzazione(), cascadeConfig, provenienza);
                        }
                        catch (DriverConfigurazioneNotFound regola) {
                            // empty catch block
                        }
                    }
                    if (pa != null && StringUtils.isNotEmpty((String)pa.getAutorizzazioneContenuto()) && !"builtIn".equals(pa.getAutorizzazioneContenuto())) {
                        try {
                            this.readPlugin_classe(archive, TipoPlugin.AUTORIZZAZIONE_CONTENUTI.getValue(), pa.getAutorizzazioneContenuto(), cascadeConfig, provenienza);
                        }
                        catch (DriverConfigurazioneNotFound tipo2) {
                            // empty catch block
                        }
                    }
                    if (pa != null && pa.getBehaviour() != null && pa.getBehaviour().getNome() != null && TipoBehaviour.CUSTOM.equals((Object)(behaviourType = TipoBehaviour.toEnumConstant((String)pa.getBehaviour().getNome())))) {
                        try {
                            this.readPlugin_classe(archive, TipoPlugin.BEHAVIOUR.getValue(), pa.getBehaviour().getNome(), cascadeConfig, provenienza);
                        }
                        catch (DriverConfigurazioneNotFound regola) {
                            // empty catch block
                        }
                    }
                    if (pa != null && pa.getIntegrazione() != null && StringUtils.isNotEmpty((String)pa.getIntegrazione()) && (tipi = pa.getIntegrazione().trim().split(",")) != null && tipi.length > 0) {
                        for (String t : tipi) {
                            if (!this.archiveEngine.existsPluginClasse(TipoPlugin.INTEGRAZIONE.getValue(), t)) continue;
                            try {
                                this.readPlugin_classe(archive, TipoPlugin.INTEGRAZIONE.getValue(), t, cascadeConfig, provenienza);
                            }
                            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                                // empty catch block
                            }
                        }
                    }
                    if (pa != null && pa.getConfigurazioneHandler() != null) {
                        if (pa.getConfigurazioneHandler().getRequest() != null) {
                            if (pa.getConfigurazioneHandler().getRequest().sizePreInList() > 0) {
                                for (ConfigurazioneHandler ch : pa.getConfigurazioneHandler().getRequest().getPreInList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                            if (pa.getConfigurazioneHandler().getRequest().sizeInList() > 0) {
                                for (ConfigurazioneHandler ch : pa.getConfigurazioneHandler().getRequest().getInList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                            if (pa.getConfigurazioneHandler().getRequest().sizeInProtocolInfoList() > 0) {
                                for (ConfigurazioneHandler ch : pa.getConfigurazioneHandler().getRequest().getInProtocolInfoList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                            if (pa.getConfigurazioneHandler().getRequest().sizeOutList() > 0) {
                                for (ConfigurazioneHandler ch : pa.getConfigurazioneHandler().getRequest().getOutList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                            if (pa.getConfigurazioneHandler().getRequest().sizePostOutList() > 0) {
                                for (ConfigurazioneHandler ch : pa.getConfigurazioneHandler().getRequest().getPostOutList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                        }
                        if (pa.getConfigurazioneHandler().getResponse() != null) {
                            if (pa.getConfigurazioneHandler().getResponse().sizePreInList() > 0) {
                                for (ConfigurazioneHandler ch : pa.getConfigurazioneHandler().getResponse().getPreInList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                            if (pa.getConfigurazioneHandler().getResponse().sizeInList() > 0) {
                                for (ConfigurazioneHandler ch : pa.getConfigurazioneHandler().getResponse().getInList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                            if (pa.getConfigurazioneHandler().getResponse().sizeOutList() > 0) {
                                for (ConfigurazioneHandler ch : pa.getConfigurazioneHandler().getResponse().getOutList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                            if (pa.getConfigurazioneHandler().getResponse().sizePostOutList() > 0) {
                                for (ConfigurazioneHandler ch : pa.getConfigurazioneHandler().getResponse().getPostOutList()) {
                                    if (!this.archiveEngine.existsPluginClasse(TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo())) continue;
                                    try {
                                        this.readPlugin_classe(archive, TipoPlugin.MESSAGE_HANDLER.getValue(), ch.getTipo(), cascadeConfig, provenienza);
                                    }
                                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {}
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException("(PortaApplicativa " + idPortaApplicativa + ") " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (cascadeAvanti) {
            if (pa.sizeServizioApplicativoList() > 0) {
                for (PortaApplicativaServizioApplicativo sa : pa.getServizioApplicativoList()) {
                    IDServizioApplicativo idSA = new IDServizioApplicativo();
                    idSA.setIdSoggettoProprietario(idSoggettoErogatore);
                    idSA.setNome(sa.getNome());
                    this.readServizioApplicativo(archive, idSA, cascadeConfig, ArchiveType.PORTA_APPLICATIVA);
                }
            }
            if (pa.getServizioApplicativoDefault() != null && !"".equals(pa.getServizioApplicativoDefault())) {
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(idSoggettoErogatore);
                idSA.setNome(pa.getServizioApplicativoDefault());
                this.readServizioApplicativo(archive, idSA, cascadeConfig, ArchiveType.PORTA_APPLICATIVA);
            }
        }
        return pa;
    }

    private void readErogazione(Archive archive, IDServizio idServizio, ArchiveCascadeConfiguration cascadeConfig) throws Exception {
        this.readAccordoServizioParteSpecifica(archive, idServizio, cascadeConfig, ArchiveType.EROGAZIONE);
        List<IDPortaApplicativa> listIDPA = this.archiveEngine.getIDPorteApplicativeAssociateErogazione(idServizio);
        if (listIDPA != null && listIDPA.size() > 0) {
            for (IDPortaApplicativa idPortaApplicativa : listIDPA) {
                PortaApplicativa pa = this.readPortaApplicativa(archive, idPortaApplicativa, cascadeConfig, ArchiveType.PORTA_APPLICATIVA);
                if (pa != null && pa.sizeServizioApplicativoList() > 0) {
                    for (PortaApplicativaServizioApplicativo pasa : pa.getServizioApplicativoList()) {
                        IDServizioApplicativo idSA = new IDServizioApplicativo();
                        idSA.setNome(pasa.getNome());
                        idSA.setIdSoggettoProprietario(new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                        ServizioApplicativo sa = this.archiveEngine.getServizioApplicativo(idSA);
                        if ("server".equals(sa.getTipo()) || "clientORserver".equals(sa.getTipo())) continue;
                        this.readServizioApplicativo(archive, idSA, cascadeConfig, ArchiveType.SERVIZIO_APPLICATIVO);
                    }
                }
                if (pa == null || pa.getServizioApplicativoDefault() == null || "".equals(pa.getServizioApplicativoDefault())) continue;
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setNome(pa.getServizioApplicativoDefault());
                idSA.setIdSoggettoProprietario(new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                ServizioApplicativo sa = this.archiveEngine.getServizioApplicativo(idSA);
                if ("server".equals(sa.getTipo()) || "clientORserver".equals(sa.getTipo())) continue;
                this.readServizioApplicativo(archive, idSA, cascadeConfig, ArchiveType.SERVIZIO_APPLICATIVO);
            }
        }
    }

    private void readFruizione(Archive archive, IDFruizione idFruizione, ArchiveCascadeConfiguration cascadeConfig) throws Exception {
        this.readAccordoServizioParteSpecifica(archive, idFruizione.getIdServizio(), cascadeConfig, ArchiveType.FRUIZIONE);
        this.readFruitore(archive, idFruizione.getIdServizio(), idFruizione.getIdFruitore(), null, cascadeConfig, ArchiveType.FRUITORE);
        List<IDPortaDelegata> listIDPD = this.archiveEngine.getIDPorteDelegateAssociateFruizione(idFruizione.getIdServizio(), idFruizione.getIdFruitore());
        if (listIDPD != null && listIDPD.size() > 0) {
            for (IDPortaDelegata idPortaDelegata : listIDPD) {
                this.readPortaDelegata(archive, idPortaDelegata, cascadeConfig, ArchiveType.PORTA_DELEGATA);
            }
        }
    }
}

