/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.protocol.basic.registry.ConfigIntegrationReader;
import org.openspcoop2.protocol.basic.registry.RegistryReader;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.archive.ArchiveEngine;
import org.openspcoop2.protocol.engine.archive.ArchiveValidator;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingCollection;
import org.openspcoop2.protocol.engine.archive.ImporterArchiveUtils;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImport;
import org.openspcoop2.protocol.sdk.archive.ArchiveMode;
import org.openspcoop2.protocol.sdk.archive.ArchiveModeType;
import org.openspcoop2.protocol.sdk.archive.IArchive;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class Importer {
    public static void main(String[] args) throws Exception {
        Logger log = LoggerWrapperFactory.getLogger(Importer.class);
        String archiveFile = args[0];
        byte[] archiveBytes = FileSystemUtilities.readBytesFromFile((String)archiveFile);
        String protocollo = args[1];
        String mode = args[2];
        ArchiveMode archiveMode = new ArchiveMode(mode);
        String type = args[3];
        ArchiveModeType archiveModeType = new ArchiveModeType(type);
        boolean validateDocuments = Boolean.parseBoolean(args[4]);
        String userLogin = args[5];
        String nomePddOperativa = args[6];
        String tipoPddDefault = args[7];
        boolean updateAbilitato = Boolean.parseBoolean(args[8]);
        boolean importPolicyConfig = Boolean.parseBoolean(args[9]);
        boolean importPluginConfig = Boolean.parseBoolean(args[10]);
        boolean checkExistsPluginConfig = Boolean.parseBoolean(args[11]);
        boolean importConfig = Boolean.parseBoolean(args[12]);
        boolean isShowCorrelazioneAsincronaInAccordi = true;
        boolean isShowGestioneWorkflowStatoDocumenti = true;
        boolean isShowAccordiColonnaAzioni = true;
        boolean isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto = false;
        boolean isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto = false;
        boolean isSoggettiApplicativiCredenzialiBasicPermitSameCredentials = false;
        boolean isSoggettiApplicativiCredenzialiSslPermitSameCredentials = false;
        boolean isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials = false;
        ConfigurazionePdD configPdD = new ConfigurazionePdD();
        configPdD.setLoader(new Loader());
        configPdD.setLog(log);
        ProtocolFactoryManager.initializeSingleProtocol(log, configPdD, protocollo);
        DriverRegistroServiziDB driverRegistroServizi = null;
        DriverConfigurazioneDB driverConfigurazione = null;
        JDBCServiceManager serviceManagerPlugins = null;
        org.openspcoop2.core.controllo_traffico.dao.jdbc.JDBCServiceManager serviceManagerControlloTraffico = null;
        org.openspcoop2.core.allarmi.dao.jdbc.JDBCServiceManager serviceManagerAllarmi = null;
        RegistryReader archiveRegistryReader = new RegistryReader(driverRegistroServizi, log);
        ConfigIntegrationReader archiveConfigIntegrationReader = new ConfigIntegrationReader(driverConfigurazione, log);
        IProtocolFactory<?> pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
        IArchive archiveEngine = pf.createArchive();
        Archive archive = archiveEngine.importArchive(archiveBytes, archiveMode, archiveModeType, (IRegistryReader)archiveRegistryReader, (IConfigIntegrationReader)archiveConfigIntegrationReader, validateDocuments, null);
        ArchiveValidator validator = new ArchiveValidator((IRegistryReader)archiveRegistryReader);
        ImportInformationMissingCollection importInformationMissingCollection = new ImportInformationMissingCollection();
        validator.validateArchive(archive, protocollo, validateDocuments, importInformationMissingCollection, userLogin, isShowCorrelazioneAsincronaInAccordi, false);
        ArchiveEngine importerEngine = new ArchiveEngine(driverRegistroServizi, driverConfigurazione, serviceManagerPlugins, serviceManagerControlloTraffico, serviceManagerAllarmi);
        ImporterArchiveUtils importerArchiveUtils = new ImporterArchiveUtils(importerEngine, log, userLogin, nomePddOperativa, tipoPddDefault, isShowGestioneWorkflowStatoDocumenti, updateAbilitato, importPolicyConfig, importPluginConfig, checkExistsPluginConfig, importConfig);
        ArchiveEsitoImport result = importerArchiveUtils.importArchive(archive, userLogin, isShowAccordiColonnaAzioni, isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto, isSoggettiApplicativiCredenzialiBasicPermitSameCredentials, isSoggettiApplicativiCredenzialiSslPermitSameCredentials, isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials);
        String resultAsString = archiveEngine.toString(result, archiveMode);
        log.info(resultAsString);
    }
}

