/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import java.util.ArrayList;
import org.openspcoop2.core.config.CorrelazioneApplicativaElemento;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.InvocazionePorta;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.TipologiaFruizione;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioComposto;
import org.openspcoop2.core.registry.ConfigurazioneServizio;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.information_missing.AccordoCooperazione;
import org.openspcoop2.protocol.information_missing.AccordoServizioParteComune;
import org.openspcoop2.protocol.information_missing.AccordoServizioParteSpecifica;
import org.openspcoop2.protocol.information_missing.PortaApplicativa;
import org.openspcoop2.protocol.information_missing.ReplaceFruitoreMatchType;
import org.openspcoop2.protocol.information_missing.ReplaceMatchFieldType;
import org.openspcoop2.protocol.information_missing.ReplaceMatchType;
import org.openspcoop2.protocol.information_missing.constants.ReplaceKeywordType;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveFruitore;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaDelegata;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;

public class ImporterInformationMissingSetter {
    private ImporterInformationMissingSetter() {
    }

    public static void setInformationMissingReferenteAPI(Archive archive, IRegistryReader registryReader) throws ProtocolException {
        if (archive.getAccordiServizioParteComune() != null && archive.getAccordiServizioParteComune().size() > 0) {
            for (int i = 0; i < archive.getAccordiServizioParteComune().size(); ++i) {
                ProtocolFactoryManager protocolFactoryManager;
                IProtocolFactory<?> protocol;
                boolean referente;
                org.openspcoop2.core.registry.AccordoServizioParteComune as = ((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i)).getAccordoServizioParteComune();
                IdSoggetto soggettoReferente = as.getSoggettoReferente();
                String tipoSoggettoReferente = null;
                String nomeSoggettoReferente = null;
                if (soggettoReferente != null) {
                    tipoSoggettoReferente = soggettoReferente.getTipo();
                    nomeSoggettoReferente = soggettoReferente.getNome();
                }
                if (tipoSoggettoReferente == null || "".equals(tipoSoggettoReferente) || nomeSoggettoReferente != null && !"".equals(nomeSoggettoReferente) || (referente = (protocol = (protocolFactoryManager = ProtocolFactoryManager.getInstance()).getProtocolFactoryByOrganizationType(tipoSoggettoReferente)).createProtocolConfiguration().isSupportoSoggettoReferenteAccordiParteComune())) continue;
                String tipoSoggettoDefault = (String)protocolFactoryManager.getDefaultOrganizationTypes().get((Object)protocol.getProtocol());
                IDSoggetto idSoggettoDefault = null;
                try {
                    idSoggettoDefault = registryReader.getIdSoggettoDefault(tipoSoggettoDefault);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                as.getSoggettoReferente().setNome(idSoggettoDefault.getNome());
            }
        }
    }

    public static void setInformationMissingSoggetto(Archive archive, org.openspcoop2.protocol.information_missing.Soggetto soggetto, IDSoggetto idSoggetto, Connettore connettore) throws ProtocolException {
        switch (soggetto.getTipo()) {
            case RIFERIMENTO: {
                ImporterInformationMissingSetter.setInformationMissingRiferimentoSoggetto(archive, soggetto, idSoggetto);
                break;
            }
            case CONNETTORE: {
                ImporterInformationMissingSetter.setInformationMissingConnettoreSoggetto(archive, soggetto, connettore);
            }
        }
    }

    public static void setInformationMissingServizioApplicativo(Archive archive, org.openspcoop2.protocol.information_missing.ServizioApplicativo sa, InvocazioneServizio invocazioneServizio, Credenziali credenziali) throws ProtocolException {
        switch (sa.getTipo()) {
            case RIFERIMENTO: {
                break;
            }
            case CONNETTORE: {
                ImporterInformationMissingSetter.setInformationMissingConnettoreSA(archive, sa, invocazioneServizio, credenziali);
                break;
            }
            case CREDENZIALI_ACCESSO_PDD: {
                ImporterInformationMissingSetter.setInformationMissingCredenzialiSA(archive, sa, credenziali);
                break;
            }
            case ALLINEA_CREDENZIALI_PD: {
                ImporterInformationMissingSetter.setInformationMissingAllineaCredenzialiPD(archive, sa);
            }
        }
    }

    public static void setInformationMissingAccordoCooperazione(Archive archive, AccordoCooperazione ac, IDAccordoCooperazione idAccordo) throws ProtocolException {
        switch (ac.getTipo()) {
            case RIFERIMENTO: {
                ImporterInformationMissingSetter.setInformationMissingRiferimentoAccordoCooperazione(archive, ac, idAccordo);
                break;
            }
            case STATO_ARCHIVIO: {
                if (ac.getStato() == null) {
                    throw new ProtocolException("Stato non fornito, \u00e8 richiesto con tipo di operazione [" + ac.getTipo().name() + "]");
                }
                ImporterInformationMissingSetter.setInformationMissingStatoAccordoCooperazione(archive, ac);
            }
        }
    }

    public static void setInformationMissingAccordoServizioParteComune(Archive archive, AccordoServizioParteComune as, IDAccordo idAccordo) throws ProtocolException {
        switch (as.getTipo()) {
            case RIFERIMENTO: {
                ImporterInformationMissingSetter.setInformationMissingRiferimentoAccordoServizioParteComune(archive, as, idAccordo);
                break;
            }
            case STATO_ARCHIVIO: {
                if (as.getStato() == null) {
                    throw new ProtocolException("Stato non fornito, \u00e8 richiesto con tipo di operazione [" + as.getTipo().name() + "]");
                }
                ImporterInformationMissingSetter.setInformationMissingStatoAccordoServizioParteComune(archive, as);
            }
        }
    }

    public static void setInformationMissingAccordoServizioParteSpecifica(Archive archive, AccordoServizioParteSpecifica asps, Connettore connettore) throws ProtocolException {
        switch (asps.getTipo()) {
            case CONNETTORE: {
                ImporterInformationMissingSetter.setInformationMissingConnettoreASPS(archive, asps, connettore);
                break;
            }
            case STATO_ARCHIVIO: {
                if (asps.getStato() == null) {
                    throw new ProtocolException("Stato non fornito, \u00e8 richiesto con tipo di operazione [" + asps.getTipo().name() + "]");
                }
                ImporterInformationMissingSetter.setInformationMissingStatoAccordoServizioParteSpecifica(archive, asps);
            }
        }
    }

    public static void setInformationMissingAccordoServizioComposto(Archive archive, AccordoServizioParteComune as, IDAccordo idAccordo) throws ProtocolException {
        switch (as.getTipo()) {
            case RIFERIMENTO: {
                ImporterInformationMissingSetter.setInformationMissingRiferimentoAccordoServizioComposto(archive, as, idAccordo);
                break;
            }
            case STATO_ARCHIVIO: {
                if (as.getStato() == null) {
                    throw new ProtocolException("Stato non fornito, \u00e8 richiesto con tipo di operazione [" + as.getTipo().name() + "]");
                }
                ImporterInformationMissingSetter.setInformationMissingStatoAccordoServizioComposto(archive, as);
            }
        }
    }

    public static void setInformationMissingFruitore(Archive archive, org.openspcoop2.protocol.information_missing.Fruitore fruitore, Connettore connettore) {
        switch (fruitore.getTipo()) {
            case CONNETTORE: {
                ImporterInformationMissingSetter.setInformationMissingConnettoreFruitore(archive, fruitore, connettore);
                break;
            }
            case STATO_ARCHIVIO: {
                ImporterInformationMissingSetter.setInformationMissingStatoFruitore(archive, fruitore);
            }
        }
    }

    public static void setInformationMissingPortaDelegata(Archive archive, org.openspcoop2.protocol.information_missing.PortaDelegata portaDelegata) {
        switch (portaDelegata.getTipo()) {
            case STATO: {
                ImporterInformationMissingSetter.setInformationMissingStatoPortaDelegata(archive, portaDelegata);
            }
        }
    }

    public static void setInformationMissingPortaApplicativa(Archive archive, PortaApplicativa portaApplicativa) {
        switch (portaApplicativa.getTipo()) {
            case STATO: {
                ImporterInformationMissingSetter.setInformationMissingStatoPortaApplicativa(archive, portaApplicativa);
            }
        }
    }

    private static boolean match(ReplaceMatchFieldType fieldType, String value) {
        return ReplaceKeywordType.EMPTY.equals((Object)fieldType.getTipo()) ? value == null || "".equals(value) : (ReplaceKeywordType.EQUALS.equals((Object)fieldType.getTipo()) ? value != null && value.equals(fieldType.getValore()) : (ReplaceKeywordType.CONTAINS.equals((Object)fieldType.getTipo()) ? value != null && value.contains(fieldType.getValore()) : (ReplaceKeywordType.STARTS_WITH.equals((Object)fieldType.getTipo()) ? value != null && value.startsWith(fieldType.getValore()) : (ReplaceKeywordType.ENDS_WITH.equals((Object)fieldType.getTipo()) ? value != null && value.endsWith(fieldType.getValore()) : ReplaceKeywordType.ALL.equals((Object)fieldType.getTipo())))));
    }

    private static boolean matchSoggetto(ReplaceMatchType replaceMatch, String tipoSoggetto, String nomeSoggetto) {
        ReplaceMatchFieldType nome = replaceMatch.getNome();
        ReplaceMatchFieldType tipo = replaceMatch.getTipo();
        if (nome == null && tipo == null) {
            return false;
        }
        if (nome != null && !ImporterInformationMissingSetter.match(nome, nomeSoggetto)) {
            return false;
        }
        return tipo == null || ImporterInformationMissingSetter.match(tipo, tipoSoggetto);
    }

    private static boolean matchServizio(ReplaceMatchType replaceMatch, String tipoServizio, String nomeServizio) {
        ReplaceMatchFieldType nome = replaceMatch.getNome();
        ReplaceMatchFieldType tipo = replaceMatch.getTipo();
        if (nome == null && tipo == null) {
            return false;
        }
        if (nome != null && !ImporterInformationMissingSetter.match(nome, nomeServizio)) {
            return false;
        }
        return tipo == null || ImporterInformationMissingSetter.match(tipo, tipoServizio);
    }

    private static boolean matchFruitore(ReplaceFruitoreMatchType replaceMatch, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String tipoSoggettoErogatore, String nomeSoggettoErogatore) {
        ReplaceMatchFieldType nome = replaceMatch.getNome();
        ReplaceMatchFieldType tipo = replaceMatch.getTipo();
        ReplaceMatchFieldType rNomeServizio = replaceMatch.getNomeServizio();
        ReplaceMatchFieldType rTipoServizio = replaceMatch.getTipoServizio();
        ReplaceMatchFieldType rNomeSoggettoErogatore = replaceMatch.getNomeErogatore();
        ReplaceMatchFieldType rTipoSoggettoErogatore = replaceMatch.getTipoErogatore();
        if (nome == null && tipo == null && rNomeServizio == null && rTipoServizio == null && rNomeSoggettoErogatore == null && rTipoSoggettoErogatore == null) {
            return false;
        }
        if (nome != null && !ImporterInformationMissingSetter.match(nome, nomeSoggetto)) {
            return false;
        }
        if (tipo != null && !ImporterInformationMissingSetter.match(tipo, tipoSoggetto)) {
            return false;
        }
        if (rNomeServizio != null && !ImporterInformationMissingSetter.match(rNomeServizio, nomeServizio)) {
            return false;
        }
        if (rTipoServizio != null && !ImporterInformationMissingSetter.match(rTipoServizio, tipoServizio)) {
            return false;
        }
        if (rNomeSoggettoErogatore != null && !ImporterInformationMissingSetter.match(rNomeSoggettoErogatore, nomeSoggettoErogatore)) {
            return false;
        }
        return rTipoSoggettoErogatore == null || ImporterInformationMissingSetter.match(rTipoSoggettoErogatore, tipoSoggettoErogatore);
    }

    private static boolean matchServizioApplicativo(ReplaceMatchType replaceMatch, String nomeServizio) {
        ReplaceMatchFieldType nome = replaceMatch.getNome();
        if (nome == null) {
            return false;
        }
        return ImporterInformationMissingSetter.match(nome, nomeServizio);
    }

    private static boolean matchAccordo(ReplaceMatchType replaceMatch, String nomeAccordo) {
        ReplaceMatchFieldType nome = replaceMatch.getNome();
        if (nome == null) {
            return false;
        }
        return ImporterInformationMissingSetter.match(nome, nomeAccordo);
    }

    private static boolean matchPorta(ReplaceMatchType replaceMatch, String nomePorta) {
        ReplaceMatchFieldType nome = replaceMatch.getNome();
        if (nome == null) {
            return false;
        }
        return ImporterInformationMissingSetter.match(nome, nomePorta);
    }

    private static void setInformationMissingRiferimentoSoggetto(Archive archive, org.openspcoop2.protocol.information_missing.Soggetto soggetto, IDSoggetto idSoggetto) throws ProtocolException {
        org.openspcoop2.core.registry.AccordoServizioParteComune as;
        String nomeSoggettoReferente;
        String tipoSoggettoReferente;
        IdSoggetto soggettoReferente;
        int i;
        for (i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            ServizioApplicativo sa = ((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getServizioApplicativo();
            if (!ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario())) continue;
            sa.setTipoSoggettoProprietario(idSoggetto.getTipo());
            sa.setNomeSoggettoProprietario(idSoggetto.getNome());
            ((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).update(sa, false);
        }
        for (i = 0; i < archive.getPorteDelegate().size(); ++i) {
            PortaDelegata pd = ((ArchivePortaDelegata)archive.getPorteDelegate().get(i)).getPortaDelegata();
            if (ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario())) {
                pd.setTipoSoggettoProprietario(idSoggetto.getTipo());
                pd.setNomeSoggettoProprietario(idSoggetto.getNome());
                ((ArchivePortaDelegata)archive.getPorteDelegate().get(i)).update(pd, false);
            }
            if (pd.getSoggettoErogatore() == null || !ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome())) continue;
            pd.getSoggettoErogatore().setTipo(idSoggetto.getTipo());
            pd.getSoggettoErogatore().setNome(idSoggetto.getNome());
            ((ArchivePortaDelegata)archive.getPorteDelegate().get(i)).update(pd, false);
        }
        for (i = 0; i < archive.getPorteApplicative().size(); ++i) {
            org.openspcoop2.core.config.PortaApplicativa pa = ((ArchivePortaApplicativa)archive.getPorteApplicative().get(i)).getPortaApplicativa();
            if (ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario())) {
                pa.setTipoSoggettoProprietario(idSoggetto.getTipo());
                pa.setNomeSoggettoProprietario(idSoggetto.getNome());
                ((ArchivePortaApplicativa)archive.getPorteApplicative().get(i)).update(pa, false);
            }
            if (pa.getSoggettoVirtuale() == null || !ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), pa.getSoggettoVirtuale().getTipo(), pa.getSoggettoVirtuale().getNome())) continue;
            pa.getSoggettoVirtuale().setTipo(idSoggetto.getTipo());
            pa.getSoggettoVirtuale().setNome(idSoggetto.getNome());
            ((ArchivePortaApplicativa)archive.getPorteApplicative().get(i)).update(pa, false);
        }
        for (i = 0; i < archive.getAccordiCooperazione().size(); ++i) {
            org.openspcoop2.core.registry.AccordoCooperazione ac = ((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i)).getAccordoCooperazione();
            soggettoReferente = ac.getSoggettoReferente();
            tipoSoggettoReferente = null;
            nomeSoggettoReferente = null;
            if (soggettoReferente != null) {
                tipoSoggettoReferente = soggettoReferente.getTipo();
                nomeSoggettoReferente = soggettoReferente.getNome();
            }
            if (!ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), tipoSoggettoReferente, nomeSoggettoReferente)) continue;
            if (soggettoReferente == null) {
                ac.setSoggettoReferente(new IdSoggetto());
            }
            ac.getSoggettoReferente().setTipo(idSoggetto.getTipo());
            ac.getSoggettoReferente().setNome(idSoggetto.getNome());
            ((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i)).update(ac, false);
        }
        for (i = 0; i < archive.getAccordiServizioParteComune().size(); ++i) {
            as = ((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i)).getAccordoServizioParteComune();
            soggettoReferente = as.getSoggettoReferente();
            tipoSoggettoReferente = null;
            nomeSoggettoReferente = null;
            if (soggettoReferente != null) {
                tipoSoggettoReferente = soggettoReferente.getTipo();
                nomeSoggettoReferente = soggettoReferente.getNome();
            }
            if (!ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), tipoSoggettoReferente, nomeSoggettoReferente)) continue;
            if (soggettoReferente == null) {
                as.setSoggettoReferente(new IdSoggetto());
            }
            as.getSoggettoReferente().setTipo(idSoggetto.getTipo());
            as.getSoggettoReferente().setNome(idSoggetto.getNome());
            ((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i)).update(as, false);
        }
        for (i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            ArchiveAccordoServizioParteSpecifica archiveAS = (ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i);
            org.openspcoop2.core.registry.AccordoServizioParteSpecifica as2 = archiveAS.getAccordoServizioParteSpecifica();
            tipoSoggettoReferente = as2.getTipoSoggettoErogatore();
            nomeSoggettoReferente = as2.getNomeSoggettoErogatore();
            if (ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), tipoSoggettoReferente, nomeSoggettoReferente)) {
                as2.setTipoSoggettoErogatore(idSoggetto.getTipo());
                as2.setNomeSoggettoErogatore(idSoggetto.getNome());
                ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).update(as2, false);
            }
            if (as2.getAccordoServizioParteComune() != null) {
                try {
                    IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(as2.getAccordoServizioParteComune());
                    if (idAccordo.getSoggettoReferente() != null) {
                        String tipoSoggettoReferenteAccordo = idAccordo.getSoggettoReferente().getTipo();
                        String nomeSoggettoReferenteAccordo = idAccordo.getSoggettoReferente().getNome();
                        if (ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), tipoSoggettoReferenteAccordo, nomeSoggettoReferenteAccordo)) {
                            idAccordo.getSoggettoReferente().setTipo(idSoggetto.getTipo());
                            idAccordo.getSoggettoReferente().setNome(idSoggetto.getNome());
                            as2.setAccordoServizioParteComune(IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordo));
                            ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).update(as2, false);
                        }
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            if (archiveAS.getMappingPorteApplicativeAssociate() == null || archiveAS.getMappingPorteApplicativeAssociate().isEmpty()) continue;
            for (MappingErogazionePortaApplicativa mappingPA : archiveAS.getMappingPorteApplicativeAssociate()) {
                if (mappingPA.getIdServizio() == null || mappingPA.getIdServizio().getSoggettoErogatore() == null) continue;
                String tipoSoggettoErogatore = mappingPA.getIdServizio().getSoggettoErogatore().getTipo();
                String nomeSoggettoErogatore = mappingPA.getIdServizio().getSoggettoErogatore().getNome();
                if (!ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), tipoSoggettoErogatore, nomeSoggettoErogatore)) continue;
                mappingPA.getIdServizio().getSoggettoErogatore().setTipo(idSoggetto.getTipo());
                mappingPA.getIdServizio().getSoggettoErogatore().setNome(idSoggetto.getNome());
            }
        }
        for (i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
            as = ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).getAccordoServizioParteComune();
            soggettoReferente = as.getSoggettoReferente();
            tipoSoggettoReferente = null;
            nomeSoggettoReferente = null;
            if (soggettoReferente != null) {
                tipoSoggettoReferente = soggettoReferente.getTipo();
                nomeSoggettoReferente = soggettoReferente.getNome();
            }
            if (!ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), tipoSoggettoReferente, nomeSoggettoReferente)) continue;
            if (soggettoReferente == null) {
                as.setSoggettoReferente(new IdSoggetto());
            }
            as.getSoggettoReferente().setTipo(idSoggetto.getTipo());
            as.getSoggettoReferente().setNome(idSoggetto.getNome());
            ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).update(as, false);
        }
        for (i = 0; i < archive.getAccordiFruitori().size(); ++i) {
            ArchiveFruitore archiveFruitore = (ArchiveFruitore)archive.getAccordiFruitori().get(i);
            Fruitore fruitore = archiveFruitore.getFruitore();
            IDServizio idAps = archiveFruitore.getIdAccordoServizioParteSpecifica();
            String tipoSoggettoReferente2 = null;
            String nomeSoggettoReferente2 = null;
            if (idAps.getSoggettoErogatore() != null) {
                tipoSoggettoReferente2 = idAps.getSoggettoErogatore().getTipo();
                nomeSoggettoReferente2 = idAps.getSoggettoErogatore().getNome();
            }
            if (ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), fruitore.getTipo(), fruitore.getNome())) {
                fruitore.setTipo(idSoggetto.getTipo());
                fruitore.setNome(idSoggetto.getNome());
                ((ArchiveFruitore)archive.getAccordiFruitori().get(i)).update(idAps, fruitore, false);
            } else if (ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), tipoSoggettoReferente2, nomeSoggettoReferente2)) {
                try {
                    idAps = IDServizioFactory.getInstance().getIDServizioFromValuesWithoutCheck(idAps.getTipo(), idAps.getNome(), idSoggetto.getTipo(), idSoggetto.getNome(), idAps.getVersione().intValue());
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                ((ArchiveFruitore)archive.getAccordiFruitori().get(i)).update(idAps, fruitore, false);
            }
            if (archiveFruitore.getMappingPorteDelegateAssociate() == null || archiveFruitore.getMappingPorteDelegateAssociate().isEmpty()) continue;
            for (MappingFruizionePortaDelegata mappingPD : archiveFruitore.getMappingPorteDelegateAssociate()) {
                if (mappingPD.getIdServizio() != null && mappingPD.getIdServizio().getSoggettoErogatore() != null) {
                    String tipoSoggettoErogatore = mappingPD.getIdServizio().getSoggettoErogatore().getTipo();
                    String nomeSoggettoErogatore = mappingPD.getIdServizio().getSoggettoErogatore().getNome();
                    if (ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), tipoSoggettoErogatore, nomeSoggettoErogatore)) {
                        mappingPD.getIdServizio().getSoggettoErogatore().setTipo(idSoggetto.getTipo());
                        mappingPD.getIdServizio().getSoggettoErogatore().setNome(idSoggetto.getNome());
                    }
                }
                if (mappingPD.getIdFruitore() == null) continue;
                String tipoSoggettoFruitore = mappingPD.getIdFruitore().getTipo();
                String nomeSoggettoFruitore = mappingPD.getIdFruitore().getNome();
                if (!ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), tipoSoggettoFruitore, nomeSoggettoFruitore)) continue;
                mappingPD.getIdFruitore().setTipo(idSoggetto.getTipo());
                mappingPD.getIdFruitore().setNome(idSoggetto.getNome());
            }
        }
    }

    private static void setInformationMissingConnettoreSoggetto(Archive archive, org.openspcoop2.protocol.information_missing.Soggetto soggetto, Connettore connettore) {
        for (int i = 0; i < archive.getSoggetti().size(); ++i) {
            Soggetto soggettoRegistro = ((ArchiveSoggetto)archive.getSoggetti().get(i)).getSoggettoRegistro();
            if (soggettoRegistro == null || !ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), soggettoRegistro.getTipo(), soggettoRegistro.getNome())) continue;
            if (soggettoRegistro.getConnettore() == null) {
                soggettoRegistro.setConnettore(connettore);
                continue;
            }
            soggettoRegistro.getConnettore().setCustom(connettore.getCustom());
            soggettoRegistro.getConnettore().setTipo(connettore.getTipo());
            while (soggettoRegistro.getConnettore().sizePropertyList() > 0) {
                soggettoRegistro.getConnettore().removeProperty(0);
            }
            if (connettore.sizePropertyList() <= 0) continue;
            soggettoRegistro.getConnettore().getPropertyList().addAll(connettore.getPropertyList());
        }
    }

    private static void setInformationMissingConnettoreSA(Archive archive, org.openspcoop2.protocol.information_missing.ServizioApplicativo saMissingInfo, InvocazioneServizio invocazioneServizio, Credenziali credenziali) {
        for (int i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            ServizioApplicativo sa = ((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getServizioApplicativo();
            if (!ImporterInformationMissingSetter.matchServizioApplicativo(saMissingInfo.getReplaceMatch(), sa.getNome())) continue;
            if (credenziali != null) {
                if (sa.getInvocazionePorta() == null) {
                    sa.setInvocazionePorta(new InvocazionePorta());
                }
                while (sa.getInvocazionePorta().sizeCredenzialiList() > 0) {
                    sa.getInvocazionePorta().removeCredenziali(0);
                }
                sa.getInvocazionePorta().addCredenziali(credenziali);
            }
            if (sa.getInvocazioneServizio() == null) {
                sa.setInvocazioneServizio(invocazioneServizio);
                continue;
            }
            sa.getInvocazioneServizio().setSbustamentoInformazioniProtocollo(invocazioneServizio.getSbustamentoInformazioniProtocollo());
            sa.getInvocazioneServizio().setSbustamentoSoap(invocazioneServizio.getSbustamentoSoap());
            sa.getInvocazioneServizio().setGetMessage(invocazioneServizio.getGetMessage());
            sa.getInvocazioneServizio().setInvioPerRiferimento(invocazioneServizio.getInvioPerRiferimento());
            sa.getInvocazioneServizio().setRispostaPerRiferimento(invocazioneServizio.getRispostaPerRiferimento());
            if (sa.getInvocazioneServizio().getCredenziali() == null) {
                sa.getInvocazioneServizio().setCredenziali(invocazioneServizio.getCredenziali());
            } else {
                sa.getInvocazioneServizio().getCredenziali().setUser(invocazioneServizio.getCredenziali().getUser());
                sa.getInvocazioneServizio().getCredenziali().setPassword(invocazioneServizio.getCredenziali().getPassword());
            }
            sa.getInvocazioneServizio().setAutenticazione(invocazioneServizio.getAutenticazione());
            if (sa.getInvocazioneServizio().getConnettore() == null) {
                sa.getInvocazioneServizio().setConnettore(invocazioneServizio.getConnettore());
                continue;
            }
            sa.getInvocazioneServizio().getConnettore().setCustom(invocazioneServizio.getConnettore().getCustom());
            sa.getInvocazioneServizio().getConnettore().setTipo(invocazioneServizio.getConnettore().getTipo());
            while (sa.getInvocazioneServizio().getConnettore().sizePropertyList() > 0) {
                sa.getInvocazioneServizio().getConnettore().removeProperty(0);
            }
            if (invocazioneServizio.getConnettore().sizePropertyList() <= 0) continue;
            sa.getInvocazioneServizio().getConnettore().getPropertyList().addAll(invocazioneServizio.getConnettore().getPropertyList());
        }
    }

    private static void setInformationMissingCredenzialiSA(Archive archive, org.openspcoop2.protocol.information_missing.ServizioApplicativo saMissingInfo, Credenziali credenziali) {
        for (int i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            ServizioApplicativo sa = ((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getServizioApplicativo();
            if (!ImporterInformationMissingSetter.matchServizioApplicativo(saMissingInfo.getReplaceMatch(), sa.getNome())) continue;
            if (sa.getInvocazionePorta() == null) {
                sa.setInvocazionePorta(new InvocazionePorta());
            }
            while (sa.getInvocazionePorta().sizeCredenzialiList() > 0) {
                sa.getInvocazionePorta().removeCredenziali(0);
            }
            sa.getInvocazionePorta().addCredenziali(credenziali);
            sa.setTipologiaFruizione(TipologiaFruizione.NORMALE.getValue());
            sa.setTipo("client");
        }
    }

    private static void setInformationMissingAllineaCredenzialiPD(Archive archive, org.openspcoop2.protocol.information_missing.ServizioApplicativo saMissingInfo) throws ProtocolException {
        for (int i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            ServizioApplicativo sa = ((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getServizioApplicativo();
            if (!ImporterInformationMissingSetter.matchServizioApplicativo(saMissingInfo.getReplaceMatch(), sa.getNome())) continue;
            if (sa.getInvocazionePorta() == null || sa.getInvocazionePorta().sizeCredenzialiList() <= 0) {
                throw new ProtocolException("Credenziali di accesso non presenti nel servizio applicativo [" + sa.getNome() + "]. Le credenziali sono richieste dalla modalit\u00e0 di gestione delle informazioni mancanti impostata");
            }
            Credenziali credenziali = sa.getInvocazionePorta().getCredenziali(0);
            if (credenziali.getTipo() == null) {
                throw new ProtocolException("Credenziali di accesso non presenti nel servizio applicativo [" + sa.getNome() + "] (tipo non definito). Le credenziali sono richieste dalla modalit\u00e0 di gestione delle informazioni mancanti impostata");
            }
            block1: for (int j = 0; j < archive.getPorteDelegate().size(); ++j) {
                PortaDelegata pd = ((ArchivePortaDelegata)archive.getPorteDelegate().get(j)).getPortaDelegata();
                if (pd == null || pd.sizeServizioApplicativoList() <= 0) continue;
                for (int k = 0; k < pd.sizeServizioApplicativoList(); ++k) {
                    if (!sa.getNome().equals(pd.getServizioApplicativo(k).getNome())) continue;
                    pd.setAutenticazione(credenziali.getTipo().getValue());
                    continue block1;
                }
            }
        }
    }

    private static void setInformationMissingRiferimentoAccordoCooperazione(Archive archive, AccordoCooperazione ac, IDAccordoCooperazione idAccordo) throws ProtocolException {
        for (int i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
            org.openspcoop2.core.registry.AccordoServizioParteComune as = ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).getAccordoServizioParteComune();
            String uriAccordoCooperazione = null;
            if (as.getServizioComposto() != null) {
                uriAccordoCooperazione = as.getServizioComposto().getAccordoCooperazione();
            }
            if (!ImporterInformationMissingSetter.matchAccordo(ac.getReplaceMatch(), uriAccordoCooperazione)) continue;
            if (as.getServizioComposto() == null) {
                as.setServizioComposto(new AccordoServizioParteComuneServizioComposto());
            }
            try {
                as.getServizioComposto().setAccordoCooperazione(IDAccordoCooperazioneFactory.getInstance().getUriFromIDAccordo(idAccordo));
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).update(as, false);
        }
    }

    private static void setInformationMissingStatoAccordoCooperazione(Archive archive, AccordoCooperazione ac) throws ProtocolException {
        if (ac.getStato() != null) {
            for (int i = 0; i < archive.getAccordiCooperazione().size(); ++i) {
                org.openspcoop2.core.registry.AccordoCooperazione acObject = ((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i)).getAccordoCooperazione();
                String uriAccordoCooperazione = null;
                try {
                    uriAccordoCooperazione = IDAccordoCooperazioneFactory.getInstance().getUriFromAccordo(acObject);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                if (!ImporterInformationMissingSetter.matchAccordo(ac.getReplaceMatch(), uriAccordoCooperazione)) continue;
                acObject.setStatoPackage(ac.getStato().getValue());
            }
        }
    }

    private static void setInformationMissingRiferimentoAccordoServizioParteComune(Archive archive, AccordoServizioParteComune as, IDAccordo idAccordo) throws ProtocolException {
        for (int i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            org.openspcoop2.core.registry.AccordoServizioParteSpecifica asObject = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).getAccordoServizioParteSpecifica();
            String uriAccordo = null;
            if (asObject.getAccordoServizioParteComune() != null) {
                uriAccordo = asObject.getAccordoServizioParteComune();
            }
            if (!ImporterInformationMissingSetter.matchAccordo(as.getReplaceMatch(), uriAccordo)) continue;
            try {
                asObject.setAccordoServizioParteComune(IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordo));
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).update(asObject, false);
        }
    }

    private static void setInformationMissingStatoAccordoServizioParteComune(Archive archive, AccordoServizioParteComune as) throws ProtocolException {
        if (as.getStato() != null) {
            for (int i = 0; i < archive.getAccordiServizioParteComune().size(); ++i) {
                org.openspcoop2.core.registry.AccordoServizioParteComune asObject = ((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i)).getAccordoServizioParteComune();
                String uriAccordo = null;
                try {
                    uriAccordo = IDAccordoFactory.getInstance().getUriFromAccordo(asObject);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                if (!ImporterInformationMissingSetter.matchAccordo(as.getReplaceMatch(), uriAccordo)) continue;
                asObject.setStatoPackage(as.getStato().getValue());
            }
        }
    }

    private static void setInformationMissingConnettoreASPS(Archive archive, AccordoServizioParteSpecifica aspsMissingInfo, Connettore connettore) throws ProtocolException {
        for (int i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            org.openspcoop2.core.registry.AccordoServizioParteSpecifica asps = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).getAccordoServizioParteSpecifica();
            if (asps == null) continue;
            boolean matchTipoNome = ImporterInformationMissingSetter.matchServizio(aspsMissingInfo.getReplaceMatch(), asps.getTipo(), asps.getNome());
            String uriAccordo = null;
            try {
                uriAccordo = IDServizioFactory.getInstance().getUriFromAccordo(asps);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            boolean matchAccordo = ImporterInformationMissingSetter.matchAccordo(aspsMissingInfo.getReplaceMatch(), uriAccordo);
            if (!matchTipoNome && !matchAccordo) continue;
            if (asps.getConfigurazioneServizio() == null) {
                asps.setConfigurazioneServizio(new ConfigurazioneServizio());
            }
            if (asps.getConfigurazioneServizio().getConnettore() == null) {
                asps.getConfigurazioneServizio().setConnettore(connettore);
                continue;
            }
            asps.getConfigurazioneServizio().getConnettore().setCustom(connettore.getCustom());
            asps.getConfigurazioneServizio().getConnettore().setTipo(connettore.getTipo());
            while (asps.getConfigurazioneServizio().getConnettore().sizePropertyList() > 0) {
                asps.getConfigurazioneServizio().getConnettore().removeProperty(0);
            }
            if (connettore.sizePropertyList() <= 0) continue;
            asps.getConfigurazioneServizio().getConnettore().getPropertyList().addAll(connettore.getPropertyList());
        }
    }

    private static void setInformationMissingStatoAccordoServizioParteSpecifica(Archive archive, AccordoServizioParteSpecifica aspsMissingInfo) {
        if (aspsMissingInfo.getStato() != null) {
            for (int i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
                org.openspcoop2.core.registry.AccordoServizioParteSpecifica asps = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).getAccordoServizioParteSpecifica();
                if (asps == null) continue;
                boolean matchTipoNome = ImporterInformationMissingSetter.matchServizio(aspsMissingInfo.getReplaceMatch(), asps.getTipo(), asps.getNome());
                String uriAccordo = asps.getAccordoServizioParteComune();
                boolean matchAccordo = ImporterInformationMissingSetter.matchAccordo(aspsMissingInfo.getReplaceMatch(), uriAccordo);
                if (!matchTipoNome && !matchAccordo) continue;
                asps.setStatoPackage(aspsMissingInfo.getStato().getValue());
            }
        }
    }

    private static void setInformationMissingRiferimentoAccordoServizioComposto(Archive archive, AccordoServizioParteComune as, IDAccordo idAccordo) throws ProtocolException {
        ImporterInformationMissingSetter.setInformationMissingRiferimentoAccordoServizioParteComune(archive, as, idAccordo);
    }

    private static void setInformationMissingStatoAccordoServizioComposto(Archive archive, AccordoServizioParteComune as) throws ProtocolException {
        if (as.getStato() != null) {
            for (int i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
                org.openspcoop2.core.registry.AccordoServizioParteComune asObject = ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).getAccordoServizioParteComune();
                String uriAccordo = null;
                try {
                    uriAccordo = IDAccordoFactory.getInstance().getUriFromAccordo(asObject);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                if (!ImporterInformationMissingSetter.matchAccordo(as.getReplaceMatch(), uriAccordo)) continue;
                asObject.setStatoPackage(as.getStato().getValue());
            }
        }
    }

    private static void setInformationMissingConnettoreFruitore(Archive archive, org.openspcoop2.protocol.information_missing.Fruitore fruitoreMissingInfo, Connettore connettore) {
        for (int i = 0; i < archive.getAccordiFruitori().size(); ++i) {
            ArchiveFruitore archiveFruitore = (ArchiveFruitore)archive.getAccordiFruitori().get(i);
            Fruitore fruitore = archiveFruitore.getFruitore();
            String tipoServizio = null;
            String nomeServizio = null;
            String tipoSoggettoErogatore = null;
            String nomeSoggettoErogatore = null;
            if (archiveFruitore.getIdAccordoServizioParteSpecifica() != null) {
                tipoServizio = archiveFruitore.getIdAccordoServizioParteSpecifica().getTipo();
                nomeServizio = archiveFruitore.getIdAccordoServizioParteSpecifica().getNome();
                if (archiveFruitore.getIdAccordoServizioParteSpecifica().getSoggettoErogatore() != null) {
                    tipoSoggettoErogatore = archiveFruitore.getIdAccordoServizioParteSpecifica().getSoggettoErogatore().getTipo();
                    nomeSoggettoErogatore = archiveFruitore.getIdAccordoServizioParteSpecifica().getSoggettoErogatore().getNome();
                }
            }
            if (fruitore == null || !ImporterInformationMissingSetter.matchFruitore(fruitoreMissingInfo.getReplaceMatch(), fruitore.getTipo(), fruitore.getNome(), tipoServizio, nomeServizio, tipoSoggettoErogatore, nomeSoggettoErogatore)) continue;
            if (fruitore.getConnettore() == null) {
                fruitore.setConnettore(connettore);
                continue;
            }
            fruitore.getConnettore().setCustom(connettore.getCustom());
            fruitore.getConnettore().setTipo(connettore.getTipo());
            while (fruitore.getConnettore().sizePropertyList() > 0) {
                fruitore.getConnettore().removeProperty(0);
            }
            if (connettore.sizePropertyList() <= 0) continue;
            fruitore.getConnettore().getPropertyList().addAll(connettore.getPropertyList());
        }
    }

    private static void setInformationMissingStatoFruitore(Archive archive, org.openspcoop2.protocol.information_missing.Fruitore fruitoreMissingInfo) {
        if (fruitoreMissingInfo.getStato() != null) {
            for (int i = 0; i < archive.getAccordiFruitori().size(); ++i) {
                ArchiveFruitore archiveFruitore = (ArchiveFruitore)archive.getAccordiFruitori().get(i);
                Fruitore fruitore = archiveFruitore.getFruitore();
                String tipoServizio = null;
                String nomeServizio = null;
                String tipoSoggettoErogatore = null;
                String nomeSoggettoErogatore = null;
                if (archiveFruitore.getIdAccordoServizioParteSpecifica() != null) {
                    tipoServizio = archiveFruitore.getIdAccordoServizioParteSpecifica().getTipo();
                    nomeServizio = archiveFruitore.getIdAccordoServizioParteSpecifica().getNome();
                    if (archiveFruitore.getIdAccordoServizioParteSpecifica().getSoggettoErogatore() != null) {
                        tipoSoggettoErogatore = archiveFruitore.getIdAccordoServizioParteSpecifica().getSoggettoErogatore().getTipo();
                        nomeSoggettoErogatore = archiveFruitore.getIdAccordoServizioParteSpecifica().getSoggettoErogatore().getNome();
                    }
                }
                if (!ImporterInformationMissingSetter.matchFruitore(fruitoreMissingInfo.getReplaceMatch(), fruitore.getTipo(), fruitore.getNome(), tipoServizio, nomeServizio, tipoSoggettoErogatore, nomeSoggettoErogatore)) continue;
                fruitore.setStatoPackage(fruitoreMissingInfo.getStato().getValue());
            }
        }
    }

    private static void setInformationMissingStatoPortaDelegata(Archive archive, org.openspcoop2.protocol.information_missing.PortaDelegata portaDelegataMissingInfo) {
        if (portaDelegataMissingInfo.getStato() != null) {
            for (int i = 0; i < archive.getPorteDelegate().size(); ++i) {
                PortaDelegata portaDelegata = ((ArchivePortaDelegata)archive.getPorteDelegate().get(i)).getPortaDelegata();
                if (!ImporterInformationMissingSetter.matchPorta(portaDelegataMissingInfo.getReplaceMatch(), portaDelegata.getNome())) continue;
                portaDelegata.setStato(StatoFunzionalita.toEnumConstant((String)portaDelegataMissingInfo.getStato().getValue()));
            }
        }
    }

    private static void setInformationMissingStatoPortaApplicativa(Archive archive, PortaApplicativa portaApplicativaMissingInfo) {
        if (portaApplicativaMissingInfo.getStato() != null) {
            for (int i = 0; i < archive.getPorteApplicative().size(); ++i) {
                org.openspcoop2.core.config.PortaApplicativa portaApplicativa = ((ArchivePortaApplicativa)archive.getPorteApplicative().get(i)).getPortaApplicativa();
                if (!ImporterInformationMissingSetter.matchPorta(portaApplicativaMissingInfo.getReplaceMatch(), portaApplicativa.getNome())) continue;
                portaApplicativa.setStato(StatoFunzionalita.toEnumConstant((String)portaApplicativaMissingInfo.getStato().getValue()));
            }
        }
    }

    protected static String replaceSoggettoProprietarioOrDefault(IRegistryReader registryReader, String original, String tipoSoggetto, String nomeSoggetto) throws ProtocolException {
        if (original == null) {
            return null;
        }
        Object returnValue = original;
        if (tipoSoggetto != null && !"".equals(tipoSoggetto)) {
            returnValue = ((String)returnValue).replace("@OPENSPCOOP2_TIPO_SOGGETTO@", tipoSoggetto);
            returnValue = ((String)returnValue).replace("@OPENSPCOOP2_TIPO_SOGGETTO_PROPRIETARIO@", tipoSoggetto);
            if (original.contains("@OPENSPCOOP2_NOME_SOGGETTO_DEFAULT@")) {
                ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
                IProtocolFactory<?> protocol = protocolFactoryManager.getProtocolFactoryByOrganizationType(tipoSoggetto);
                String tipoSoggettoDefault = (String)protocolFactoryManager.getDefaultOrganizationTypes().get((Object)protocol.getProtocol());
                IDSoggetto idSoggettoDefault = null;
                try {
                    idSoggettoDefault = registryReader.getIdSoggettoDefault(tipoSoggettoDefault);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                returnValue = ((String)returnValue).replace("@OPENSPCOOP2_NOME_SOGGETTO_DEFAULT@", idSoggettoDefault.getNome());
            }
        }
        if (nomeSoggetto != null && !"".equals(nomeSoggetto)) {
            returnValue = ((String)returnValue).replace("@OPENSPCOOP2_NOME_SOGGETTO@", nomeSoggetto);
            returnValue = ((String)returnValue).replace("@OPENSPCOOP2_NOME_SOGGETTO_PROPRIETARIO@", nomeSoggetto);
        }
        return returnValue;
    }

    protected static String replaceSoggettoErogatore(String original, String tipoSoggetto, String nomeSoggetto) {
        if (original == null) {
            return null;
        }
        Object returnValue = original;
        if (tipoSoggetto != null && !"".equals(tipoSoggetto)) {
            returnValue = ((String)returnValue).replace("@OPENSPCOOP2_TIPO_SOGGETTO_EROGATORE@", tipoSoggetto);
        }
        if (nomeSoggetto != null && !"".equals(nomeSoggetto)) {
            returnValue = ((String)returnValue).replace("@OPENSPCOOP2_NOME_SOGGETTO_EROGATORE@", nomeSoggetto);
        }
        return returnValue;
    }

    private static String replaceServizio(String original, String tipoServizio, String nomeServizio) {
        if (original == null) {
            return null;
        }
        Object returnValue = original;
        if (tipoServizio != null && !"".equals(tipoServizio)) {
            returnValue = ((String)returnValue).replace("@OPENSPCOOP2_TIPO_SERVIZIO@", tipoServizio);
        }
        if (nomeServizio != null && !"".equals(nomeServizio)) {
            returnValue = ((String)returnValue).replace("@OPENSPCOOP2_NOME_SERVIZIO@", nomeServizio);
        }
        return returnValue;
    }

    private static String replaceAzione(String original, String nome) {
        if (original == null) {
            return null;
        }
        Object returnValue = original;
        if (nome != null && !"".equals(nome)) {
            returnValue = ((String)returnValue).replace("@OPENSPCOOP2_AZIONE@", nome);
        }
        return returnValue;
    }

    private static String replaceFruitore(String original, String tipoSoggetto, String nomeSoggetto) {
        if (original == null) {
            return null;
        }
        Object returnValue = original;
        if (tipoSoggetto != null && !"".equals(tipoSoggetto)) {
            returnValue = ((String)returnValue).replace("@OPENSPCOOP2_TIPO_FRUITORE@", tipoSoggetto);
        }
        if (nomeSoggetto != null && !"".equals(nomeSoggetto)) {
            returnValue = ((String)returnValue).replace("@OPENSPCOOP2_NOME_FRUITORE@", nomeSoggetto);
        }
        return returnValue;
    }

    public static void replaceTemplatesNames(Archive archive, IRegistryReader registryReader) throws ProtocolException {
        Property p2;
        int i;
        for (i = 0; i < archive.getSoggetti().size(); ++i) {
            Soggetto soggetto = ((ArchiveSoggetto)archive.getSoggetti().get(i)).getSoggettoRegistro();
            if (soggetto == null) continue;
            if (soggetto.getConnettore() != null && soggetto.getConnettore().sizePropertyList() > 0) {
                for (int j = 0; j < soggetto.getConnettore().sizePropertyList(); ++j) {
                    p2 = soggetto.getConnettore().getProperty(j);
                    p2.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p2.getNome(), soggetto.getTipo(), soggetto.getNome()));
                    p2.setValore(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p2.getValore(), soggetto.getTipo(), soggetto.getNome()));
                }
            }
            if (soggetto.getIdentificativoPorta() != null) {
                soggetto.setIdentificativoPorta(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, soggetto.getIdentificativoPorta(), soggetto.getTipo(), soggetto.getNome()));
            }
            if (soggetto.getPortaDominio() != null) {
                soggetto.setPortaDominio(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, soggetto.getPortaDominio(), soggetto.getTipo(), soggetto.getNome()));
            }
            if (soggetto.getProtocolPropertyList() == null || soggetto.sizeProtocolPropertyList() <= 0) continue;
            for (Property p2 : soggetto.getProtocolPropertyList()) {
                if (p2.getName() != null) {
                    p2.setName(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p2.getName(), soggetto.getTipo(), soggetto.getNome()));
                }
                if (p2.getValue() == null) continue;
                p2.setValue(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p2.getValue(), soggetto.getTipo(), soggetto.getNome()));
            }
        }
        for (i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            ServizioApplicativo sa = ((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getServizioApplicativo();
            sa.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, sa.getNome(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
            if (sa.getInvocazionePorta() != null && sa.getInvocazionePorta().sizeCredenzialiList() > 0) {
                for (int j = 0; j < sa.getInvocazionePorta().sizeCredenzialiList(); ++j) {
                    Credenziali c = sa.getInvocazionePorta().getCredenziali(j);
                    c.setUser(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, c.getUser(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    c.setPassword(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, c.getPassword(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    c.setSubject(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, c.getSubject(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                }
            }
            if (sa.getInvocazioneServizio() != null) {
                if (sa.getInvocazioneServizio().getCredenziali() != null) {
                    InvocazioneCredenziali c = sa.getInvocazioneServizio().getCredenziali();
                    c.setUser(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, c.getUser(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    c.setPassword(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, c.getPassword(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                }
                if (sa.getInvocazioneServizio().getConnettore() != null && sa.getInvocazioneServizio().getConnettore().sizePropertyList() > 0) {
                    for (int j = 0; j < sa.getInvocazioneServizio().getConnettore().sizePropertyList(); ++j) {
                        p2 = sa.getInvocazioneServizio().getConnettore().getProperty(j);
                        p2.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p2.getNome(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                        p2.setValore(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p2.getValore(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    }
                }
            }
            if (sa.getRispostaAsincrona() != null) {
                if (sa.getRispostaAsincrona().getCredenziali() != null) {
                    InvocazioneCredenziali c = sa.getRispostaAsincrona().getCredenziali();
                    c.setUser(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, c.getUser(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    c.setPassword(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, c.getPassword(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                }
                if (sa.getRispostaAsincrona().getConnettore() != null && sa.getRispostaAsincrona().getConnettore().sizePropertyList() > 0) {
                    for (int j = 0; j < sa.getRispostaAsincrona().getConnettore().sizePropertyList(); ++j) {
                        p2 = sa.getRispostaAsincrona().getConnettore().getProperty(j);
                        p2.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p2.getNome(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                        p2.setValore(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p2.getValore(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    }
                }
            }
            if (sa.getProtocolPropertyList() == null || sa.sizeProtocolPropertyList() <= 0) continue;
            for (Property p2 : sa.getProtocolPropertyList()) {
                if (p2.getName() != null) {
                    p2.setName(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p2.getName(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                }
                if (p2.getValue() == null) continue;
                p2.setValue(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p2.getValue(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
            }
        }
        for (i = 0; i < archive.getPorteDelegate().size(); ++i) {
            PortaDelegata pd = ((ArchivePortaDelegata)archive.getPorteDelegate().get(i)).getPortaDelegata();
            pd.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, pd.getNome(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
            if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && !"".equals(pd.getSoggettoErogatore().getNome())) {
                pd.setNome(ImporterInformationMissingSetter.replaceSoggettoErogatore(pd.getNome(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()));
            }
            if (pd.getServizio() != null && pd.getServizio().getNome() != null && !"".equals(pd.getServizio().getNome())) {
                pd.setNome(ImporterInformationMissingSetter.replaceServizio(pd.getNome(), pd.getServizio().getTipo(), pd.getServizio().getNome()));
            }
            if (pd.getAzione() != null && pd.getAzione().getNome() != null && !"".equals(pd.getAzione().getNome())) {
                pd.setNome(ImporterInformationMissingSetter.replaceAzione(pd.getNome(), pd.getAzione().getNome()));
            }
            if (pd.getDescrizione() != null && !"".equals(pd.getDescrizione())) {
                pd.setDescrizione(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, pd.getDescrizione(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
                if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && !"".equals(pd.getSoggettoErogatore().getNome())) {
                    pd.setDescrizione(ImporterInformationMissingSetter.replaceSoggettoErogatore(pd.getDescrizione(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()));
                }
                if (pd.getServizio() != null && pd.getServizio().getNome() != null && !"".equals(pd.getServizio().getNome())) {
                    pd.setDescrizione(ImporterInformationMissingSetter.replaceServizio(pd.getDescrizione(), pd.getServizio().getTipo(), pd.getServizio().getNome()));
                }
                if (pd.getAzione() != null && pd.getAzione().getNome() != null && !"".equals(pd.getAzione().getNome())) {
                    pd.setDescrizione(ImporterInformationMissingSetter.replaceAzione(pd.getDescrizione(), pd.getAzione().getNome()));
                }
            }
            if (pd.getAzione() != null && pd.getAzione().getPattern() != null && !"".equals(pd.getAzione().getPattern())) {
                pd.getAzione().setPattern(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, pd.getAzione().getPattern(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
                if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && !"".equals(pd.getSoggettoErogatore().getNome())) {
                    pd.getAzione().setPattern(ImporterInformationMissingSetter.replaceSoggettoErogatore(pd.getAzione().getPattern(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()));
                }
                if (pd.getServizio() != null && pd.getServizio().getNome() != null && !"".equals(pd.getServizio().getNome())) {
                    pd.getAzione().setPattern(ImporterInformationMissingSetter.replaceServizio(pd.getAzione().getPattern(), pd.getServizio().getTipo(), pd.getServizio().getNome()));
                }
            }
            if (pd.getAzione() != null && pd.getAzione().getNomePortaDelegante() != null && !"".equals(pd.getAzione().getNomePortaDelegante())) {
                pd.getAzione().setNomePortaDelegante(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, pd.getAzione().getNomePortaDelegante(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
            }
            for (int j = 0; j < pd.sizeServizioApplicativoList(); ++j) {
                pd.getServizioApplicativo(j).setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, pd.getServizioApplicativo(j).getNome(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
                if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && !"".equals(pd.getSoggettoErogatore().getNome())) {
                    pd.getServizioApplicativo(j).setNome(ImporterInformationMissingSetter.replaceSoggettoErogatore(pd.getServizioApplicativo(j).getNome(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()));
                }
                if (pd.getServizio() != null && pd.getServizio().getNome() != null && !"".equals(pd.getServizio().getNome())) {
                    pd.getServizioApplicativo(j).setNome(ImporterInformationMissingSetter.replaceServizio(pd.getServizioApplicativo(j).getNome(), pd.getServizio().getTipo(), pd.getServizio().getNome()));
                }
                if (pd.getAzione() == null || pd.getAzione().getNome() == null || "".equals(pd.getAzione().getNome())) continue;
                pd.getServizioApplicativo(j).setNome(ImporterInformationMissingSetter.replaceAzione(pd.getServizioApplicativo(j).getNome(), pd.getAzione().getNome()));
            }
            if (pd.getCorrelazioneApplicativa() != null && pd.getCorrelazioneApplicativa().sizeElementoList() > 0) {
                for (CorrelazioneApplicativaElemento elemento : pd.getCorrelazioneApplicativa().getElementoList()) {
                    if (elemento.getNome() != null && !"".equals(elemento.getNome())) {
                        elemento.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, elemento.getNome(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
                        if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && !"".equals(pd.getSoggettoErogatore().getNome())) {
                            elemento.setNome(ImporterInformationMissingSetter.replaceSoggettoErogatore(elemento.getNome(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()));
                        }
                        if (pd.getServizio() != null && pd.getServizio().getNome() != null && !"".equals(pd.getServizio().getNome())) {
                            elemento.setNome(ImporterInformationMissingSetter.replaceServizio(elemento.getNome(), pd.getServizio().getTipo(), pd.getServizio().getNome()));
                        }
                        if (pd.getAzione() != null && pd.getAzione().getNome() != null && !"".equals(pd.getAzione().getNome())) {
                            elemento.setNome(ImporterInformationMissingSetter.replaceAzione(elemento.getNome(), pd.getAzione().getNome()));
                        }
                    }
                    if (elemento.getPattern() == null || "".equals(elemento.getPattern())) continue;
                    elemento.setPattern(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, elemento.getPattern(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
                    if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && !"".equals(pd.getSoggettoErogatore().getNome())) {
                        elemento.setPattern(ImporterInformationMissingSetter.replaceSoggettoErogatore(elemento.getPattern(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()));
                    }
                    if (pd.getServizio() != null && pd.getServizio().getNome() != null && !"".equals(pd.getServizio().getNome())) {
                        elemento.setPattern(ImporterInformationMissingSetter.replaceServizio(elemento.getPattern(), pd.getServizio().getTipo(), pd.getServizio().getNome()));
                    }
                    if (pd.getAzione() == null || pd.getAzione().getNome() == null || "".equals(pd.getAzione().getNome())) continue;
                    elemento.setPattern(ImporterInformationMissingSetter.replaceAzione(elemento.getPattern(), pd.getAzione().getNome()));
                }
            }
            if (pd.getCorrelazioneApplicativaRisposta() == null || pd.getCorrelazioneApplicativaRisposta().sizeElementoList() <= 0) continue;
            for (CorrelazioneApplicativaElemento elemento : pd.getCorrelazioneApplicativaRisposta().getElementoList()) {
                if (elemento.getNome() != null && !"".equals(elemento.getNome())) {
                    elemento.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, elemento.getNome(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
                    if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && !"".equals(pd.getSoggettoErogatore().getNome())) {
                        elemento.setNome(ImporterInformationMissingSetter.replaceSoggettoErogatore(elemento.getNome(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()));
                    }
                    if (pd.getServizio() != null && pd.getServizio().getNome() != null && !"".equals(pd.getServizio().getNome())) {
                        elemento.setNome(ImporterInformationMissingSetter.replaceServizio(elemento.getNome(), pd.getServizio().getTipo(), pd.getServizio().getNome()));
                    }
                    if (pd.getAzione() != null && pd.getAzione().getNome() != null && !"".equals(pd.getAzione().getNome())) {
                        elemento.setNome(ImporterInformationMissingSetter.replaceAzione(elemento.getNome(), pd.getAzione().getNome()));
                    }
                }
                if (elemento.getPattern() == null || "".equals(elemento.getPattern())) continue;
                elemento.setPattern(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, elemento.getPattern(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
                if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && !"".equals(pd.getSoggettoErogatore().getNome())) {
                    elemento.setPattern(ImporterInformationMissingSetter.replaceSoggettoErogatore(elemento.getPattern(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()));
                }
                if (pd.getServizio() != null && pd.getServizio().getNome() != null && !"".equals(pd.getServizio().getNome())) {
                    elemento.setPattern(ImporterInformationMissingSetter.replaceServizio(elemento.getPattern(), pd.getServizio().getTipo(), pd.getServizio().getNome()));
                }
                if (pd.getAzione() == null || pd.getAzione().getNome() == null || "".equals(pd.getAzione().getNome())) continue;
                elemento.setPattern(ImporterInformationMissingSetter.replaceAzione(elemento.getPattern(), pd.getAzione().getNome()));
            }
        }
        for (i = 0; i < archive.getPorteApplicative().size(); ++i) {
            org.openspcoop2.core.config.PortaApplicativa pa = ((ArchivePortaApplicativa)archive.getPorteApplicative().get(i)).getPortaApplicativa();
            if (pa.getDescrizione() != null && !"".equals(pa.getDescrizione())) {
                pa.setDescrizione(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, pa.getDescrizione(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                if (pa.getServizio() != null && pa.getServizio().getNome() != null && !"".equals(pa.getServizio().getNome())) {
                    pa.setDescrizione(ImporterInformationMissingSetter.replaceServizio(pa.getDescrizione(), pa.getServizio().getTipo(), pa.getServizio().getNome()));
                }
                if (pa.getAzione() != null && pa.getAzione().getNome() != null && !"".equals(pa.getAzione().getNome())) {
                    pa.setDescrizione(ImporterInformationMissingSetter.replaceAzione(pa.getDescrizione(), pa.getAzione().getNome()));
                }
            }
            pa.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, pa.getNome(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
            if (pa.getServizio() != null && pa.getServizio().getNome() != null && !"".equals(pa.getServizio().getNome())) {
                pa.setNome(ImporterInformationMissingSetter.replaceServizio(pa.getNome(), pa.getServizio().getTipo(), pa.getServizio().getNome()));
            }
            if (pa.getAzione() != null && pa.getAzione().getNome() != null && !"".equals(pa.getAzione().getNome())) {
                pa.setNome(ImporterInformationMissingSetter.replaceAzione(pa.getNome(), pa.getAzione().getNome()));
            }
            if (pa.getAzione() != null && pa.getAzione().getNomePortaDelegante() != null && !"".equals(pa.getAzione().getNomePortaDelegante())) {
                pa.getAzione().setNomePortaDelegante(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, pa.getAzione().getNomePortaDelegante(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
            }
            for (int j = 0; j < pa.sizeServizioApplicativoList(); ++j) {
                pa.getServizioApplicativo(j).setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, pa.getServizioApplicativo(j).getNome(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                if (pa.getServizio() != null && pa.getServizio().getNome() != null && !"".equals(pa.getServizio().getNome())) {
                    pa.getServizioApplicativo(j).setNome(ImporterInformationMissingSetter.replaceServizio(pa.getServizioApplicativo(j).getNome(), pa.getServizio().getTipo(), pa.getServizio().getNome()));
                }
                if (pa.getAzione() == null || pa.getAzione().getNome() == null || "".equals(pa.getAzione().getNome())) continue;
                pa.getServizioApplicativo(j).setNome(ImporterInformationMissingSetter.replaceAzione(pa.getServizioApplicativo(j).getNome(), pa.getAzione().getNome()));
            }
            if (pa.getCorrelazioneApplicativa() != null && pa.getCorrelazioneApplicativa().sizeElementoList() > 0) {
                for (CorrelazioneApplicativaElemento elemento : pa.getCorrelazioneApplicativa().getElementoList()) {
                    if (elemento.getNome() != null && !"".equals(elemento.getNome())) {
                        elemento.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, elemento.getNome(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                        if (pa.getServizio() != null && pa.getServizio().getNome() != null && !"".equals(pa.getServizio().getNome())) {
                            elemento.setNome(ImporterInformationMissingSetter.replaceServizio(elemento.getNome(), pa.getServizio().getTipo(), pa.getServizio().getNome()));
                        }
                        if (pa.getAzione() != null && pa.getAzione().getNome() != null && !"".equals(pa.getAzione().getNome())) {
                            elemento.setNome(ImporterInformationMissingSetter.replaceAzione(elemento.getNome(), pa.getAzione().getNome()));
                        }
                    }
                    if (elemento.getPattern() == null || "".equals(elemento.getPattern())) continue;
                    elemento.setPattern(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, elemento.getPattern(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                    if (pa.getServizio() != null && pa.getServizio().getNome() != null && !"".equals(pa.getServizio().getNome())) {
                        elemento.setPattern(ImporterInformationMissingSetter.replaceServizio(elemento.getPattern(), pa.getServizio().getTipo(), pa.getServizio().getNome()));
                    }
                    if (pa.getAzione() == null || pa.getAzione().getNome() == null || "".equals(pa.getAzione().getNome())) continue;
                    elemento.setPattern(ImporterInformationMissingSetter.replaceAzione(elemento.getPattern(), pa.getAzione().getNome()));
                }
            }
            if (pa.getCorrelazioneApplicativaRisposta() == null || pa.getCorrelazioneApplicativaRisposta().sizeElementoList() <= 0) continue;
            for (CorrelazioneApplicativaElemento elemento : pa.getCorrelazioneApplicativaRisposta().getElementoList()) {
                if (elemento.getNome() != null && !"".equals(elemento.getNome())) {
                    elemento.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, elemento.getNome(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                    if (pa.getServizio() != null && pa.getServizio().getNome() != null && !"".equals(pa.getServizio().getNome())) {
                        elemento.setNome(ImporterInformationMissingSetter.replaceServizio(elemento.getNome(), pa.getServizio().getTipo(), pa.getServizio().getNome()));
                    }
                    if (pa.getAzione() != null && pa.getAzione().getNome() != null && !"".equals(pa.getAzione().getNome())) {
                        elemento.setNome(ImporterInformationMissingSetter.replaceAzione(elemento.getNome(), pa.getAzione().getNome()));
                    }
                }
                if (elemento.getPattern() == null || "".equals(elemento.getPattern())) continue;
                elemento.setPattern(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, elemento.getPattern(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                if (pa.getServizio() != null && pa.getServizio().getNome() != null && !"".equals(pa.getServizio().getNome())) {
                    elemento.setPattern(ImporterInformationMissingSetter.replaceServizio(elemento.getPattern(), pa.getServizio().getTipo(), pa.getServizio().getNome()));
                }
                if (pa.getAzione() == null || pa.getAzione().getNome() == null || "".equals(pa.getAzione().getNome())) continue;
                elemento.setPattern(ImporterInformationMissingSetter.replaceAzione(elemento.getPattern(), pa.getAzione().getNome()));
            }
        }
        for (i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            Property p32;
            ArchiveAccordoServizioParteSpecifica archiveAS = (ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i);
            org.openspcoop2.core.registry.AccordoServizioParteSpecifica as = archiveAS.getAccordoServizioParteSpecifica();
            if (as.getAccordoServizioParteComune() != null) {
                as.setAccordoServizioParteComune(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, as.getAccordoServizioParteComune(), as.getTipoSoggettoErogatore(), as.getNomeSoggettoErogatore()));
                as.setAccordoServizioParteComune(ImporterInformationMissingSetter.replaceSoggettoErogatore(as.getAccordoServizioParteComune(), as.getTipoSoggettoErogatore(), as.getNomeSoggettoErogatore()));
            }
            if (as.getConfigurazioneServizio() != null && as.getConfigurazioneServizio().getConnettore() != null) {
                for (int j = 0; j < as.getConfigurazioneServizio().getConnettore().sizePropertyList(); ++j) {
                    p32 = as.getConfigurazioneServizio().getConnettore().getProperty(j);
                    p32.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p32.getNome(), as.getTipoSoggettoErogatore(), as.getNomeSoggettoErogatore()));
                    p32.setValore(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p32.getValore(), as.getTipoSoggettoErogatore(), as.getNomeSoggettoErogatore()));
                }
            }
            if (as.getConfigurazioneServizio() != null && as.getConfigurazioneServizio().getConnettore() != null) {
                for (int j = 0; j < as.getConfigurazioneServizio().getConnettore().sizePropertyList(); ++j) {
                    p32 = as.getConfigurazioneServizio().getConnettore().getProperty(j);
                    p32.setNome(ImporterInformationMissingSetter.replaceSoggettoErogatore(p32.getNome(), as.getTipoSoggettoErogatore(), as.getNomeSoggettoErogatore()));
                    p32.setValore(ImporterInformationMissingSetter.replaceSoggettoErogatore(p32.getValore(), as.getTipoSoggettoErogatore(), as.getNomeSoggettoErogatore()));
                }
            }
            if (as.sizeFruitoreList() == 1) {
                if (as.getConfigurazioneServizio() != null && as.getConfigurazioneServizio().getConnettore() != null) {
                    for (int j = 0; j < as.getConfigurazioneServizio().getConnettore().sizePropertyList(); ++j) {
                        p32 = as.getConfigurazioneServizio().getConnettore().getProperty(j);
                        p32.setNome(ImporterInformationMissingSetter.replaceFruitore(p32.getNome(), as.getFruitore(0).getTipo(), as.getFruitore(0).getNome()));
                        p32.setValore(ImporterInformationMissingSetter.replaceFruitore(p32.getValore(), as.getFruitore(0).getTipo(), as.getFruitore(0).getNome()));
                    }
                }
            } else if (as.sizeFruitoreList() == 0) {
                int j;
                IDServizio idAccordoAttuale = null;
                try {
                    idAccordoAttuale = IDServizioFactory.getInstance().getIDServizioFromAccordo(as);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                ArrayList<Fruitore> listFruitori = new ArrayList<Fruitore>();
                for (j = 0; j < archive.getAccordiFruitori().size(); ++j) {
                    Fruitore fr = ((ArchiveFruitore)archive.getAccordiFruitori().get(j)).getFruitore();
                    IDServizio idAccordo = ((ArchiveFruitore)archive.getAccordiFruitori().get(j)).getIdAccordoServizioParteSpecifica();
                    if (!idAccordo.equals((Object)idAccordoAttuale)) continue;
                    listFruitori.add(fr);
                }
                if (listFruitori.size() == 1 && as.getConfigurazioneServizio() != null && as.getConfigurazioneServizio().getConnettore() != null) {
                    for (j = 0; j < as.getConfigurazioneServizio().getConnettore().sizePropertyList(); ++j) {
                        Property p4 = as.getConfigurazioneServizio().getConnettore().getProperty(j);
                        p4.setNome(ImporterInformationMissingSetter.replaceFruitore(p4.getNome(), ((Fruitore)listFruitori.get(0)).getTipo(), ((Fruitore)listFruitori.get(0)).getNome()));
                        p4.setValore(ImporterInformationMissingSetter.replaceFruitore(p4.getValore(), ((Fruitore)listFruitori.get(0)).getTipo(), ((Fruitore)listFruitori.get(0)).getNome()));
                    }
                }
            }
            if (as.getProtocolPropertyList() != null && as.sizeProtocolPropertyList() > 0) {
                for (Property p32 : as.getProtocolPropertyList()) {
                    if (p32.getName() != null) {
                        p32.setName(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p32.getName(), as.getTipoSoggettoErogatore(), as.getNomeSoggettoErogatore()));
                        p32.setName(ImporterInformationMissingSetter.replaceSoggettoErogatore(p32.getName(), as.getTipoSoggettoErogatore(), as.getNomeSoggettoErogatore()));
                    }
                    if (p32.getValue() == null) continue;
                    p32.setValue(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p32.getValue(), as.getTipoSoggettoErogatore(), as.getNomeSoggettoErogatore()));
                    p32.setValue(ImporterInformationMissingSetter.replaceSoggettoErogatore(p32.getValue(), as.getTipoSoggettoErogatore(), as.getNomeSoggettoErogatore()));
                }
            }
            if (archiveAS.getMappingPorteApplicativeAssociate() == null || archiveAS.getMappingPorteApplicativeAssociate().isEmpty()) continue;
            for (MappingErogazionePortaApplicativa mappingPA : archiveAS.getMappingPorteApplicativeAssociate()) {
                if (mappingPA.getIdPortaApplicativa() != null && mappingPA.getIdPortaApplicativa().getNome() != null) {
                    mappingPA.getIdPortaApplicativa().setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, mappingPA.getIdPortaApplicativa().getNome(), as.getTipoSoggettoErogatore(), as.getNomeSoggettoErogatore()));
                    mappingPA.getIdPortaApplicativa().setNome(ImporterInformationMissingSetter.replaceSoggettoErogatore(mappingPA.getIdPortaApplicativa().getNome(), as.getTipoSoggettoErogatore(), as.getNomeSoggettoErogatore()));
                    mappingPA.getIdPortaApplicativa().setNome(ImporterInformationMissingSetter.replaceServizio(mappingPA.getIdPortaApplicativa().getNome(), as.getTipo(), as.getNome()));
                }
                if (mappingPA.getIdServizio() == null) continue;
                ImporterInformationMissingSetter.replaceTemplatesNames(registryReader, mappingPA.getIdServizio(), as.getTipoSoggettoErogatore(), as.getNomeSoggettoErogatore(), as.getTipo(), as.getNome(), true);
            }
        }
        for (i = 0; i < archive.getAccordiFruitori().size(); ++i) {
            ArchiveFruitore archiveFr = (ArchiveFruitore)archive.getAccordiFruitori().get(i);
            Fruitore fr = archiveFr.getFruitore();
            IDServizio idAccordo = ((ArchiveFruitore)archive.getAccordiFruitori().get(i)).getIdAccordoServizioParteSpecifica();
            String tipoSoggettoErogatore = null;
            String nomeSoggettoErogatore = null;
            String tipoServizio = null;
            String nomeServizio = null;
            if (idAccordo != null && idAccordo.getSoggettoErogatore() != null) {
                tipoSoggettoErogatore = idAccordo.getSoggettoErogatore().getTipo();
                nomeSoggettoErogatore = idAccordo.getSoggettoErogatore().getNome();
            }
            if (idAccordo != null) {
                tipoServizio = idAccordo.getTipo();
                nomeServizio = idAccordo.getNome();
            }
            if (fr.getConnettore() != null) {
                Property p5;
                int j;
                for (j = 0; j < fr.getConnettore().sizePropertyList(); ++j) {
                    p5 = fr.getConnettore().getProperty(j);
                    p5.setNome(ImporterInformationMissingSetter.replaceFruitore(p5.getNome(), fr.getTipo(), fr.getNome()));
                    p5.setValore(ImporterInformationMissingSetter.replaceFruitore(p5.getValore(), fr.getTipo(), fr.getNome()));
                }
                for (j = 0; j < fr.getConnettore().sizePropertyList(); ++j) {
                    p5 = fr.getConnettore().getProperty(j);
                    p5.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p5.getNome(), fr.getTipo(), fr.getNome()));
                    p5.setValore(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p5.getValore(), fr.getTipo(), fr.getNome()));
                }
                if (tipoSoggettoErogatore != null && nomeSoggettoErogatore != null) {
                    for (j = 0; j < fr.getConnettore().sizePropertyList(); ++j) {
                        p5 = fr.getConnettore().getProperty(j);
                        p5.setNome(ImporterInformationMissingSetter.replaceSoggettoErogatore(p5.getNome(), tipoSoggettoErogatore, nomeSoggettoErogatore));
                        p5.setValore(ImporterInformationMissingSetter.replaceSoggettoErogatore(p5.getValore(), tipoSoggettoErogatore, nomeSoggettoErogatore));
                    }
                }
            }
            if (fr.getProtocolPropertyList() != null && fr.sizeProtocolPropertyList() > 0) {
                for (Property p5 : fr.getProtocolPropertyList()) {
                    if (p5.getName() != null) {
                        p5.setName(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p5.getName(), fr.getTipo(), fr.getNome()));
                        if (tipoSoggettoErogatore != null && nomeSoggettoErogatore != null) {
                            p5.setName(ImporterInformationMissingSetter.replaceSoggettoErogatore(p5.getName(), tipoSoggettoErogatore, nomeSoggettoErogatore));
                        }
                    }
                    if (p5.getValue() == null) continue;
                    p5.setValue(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, p5.getValue(), fr.getTipo(), fr.getNome()));
                    if (tipoSoggettoErogatore == null || nomeSoggettoErogatore == null) continue;
                    p5.setValue(ImporterInformationMissingSetter.replaceSoggettoErogatore(p5.getValue(), tipoSoggettoErogatore, nomeSoggettoErogatore));
                }
            }
            if (archiveFr.getMappingPorteDelegateAssociate() == null || archiveFr.getMappingPorteDelegateAssociate().isEmpty()) continue;
            for (MappingFruizionePortaDelegata mappingPD : archiveFr.getMappingPorteDelegateAssociate()) {
                if (mappingPD.getIdPortaDelegata() != null && mappingPD.getIdPortaDelegata().getNome() != null) {
                    if (tipoSoggettoErogatore != null && nomeSoggettoErogatore != null) {
                        mappingPD.getIdPortaDelegata().setNome(ImporterInformationMissingSetter.replaceSoggettoErogatore(mappingPD.getIdPortaDelegata().getNome(), tipoSoggettoErogatore, nomeSoggettoErogatore));
                    }
                    if (tipoServizio != null && nomeServizio != null) {
                        mappingPD.getIdPortaDelegata().setNome(ImporterInformationMissingSetter.replaceServizio(mappingPD.getIdPortaDelegata().getNome(), tipoServizio, nomeServizio));
                    }
                    mappingPD.getIdPortaDelegata().setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, mappingPD.getIdPortaDelegata().getNome(), fr.getTipo(), fr.getNome()));
                    mappingPD.getIdPortaDelegata().setNome(ImporterInformationMissingSetter.replaceFruitore(mappingPD.getIdPortaDelegata().getNome(), fr.getTipo(), fr.getNome()));
                }
                if (mappingPD.getIdServizio() != null && tipoSoggettoErogatore != null && nomeSoggettoErogatore != null && tipoServizio != null && nomeServizio != null) {
                    ImporterInformationMissingSetter.replaceTemplatesNames(registryReader, mappingPD.getIdServizio(), tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, false);
                }
                if (mappingPD.getIdFruitore() == null) continue;
                if (mappingPD.getIdFruitore().getTipo() != null) {
                    mappingPD.getIdFruitore().setTipo(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, mappingPD.getIdFruitore().getTipo(), fr.getTipo(), fr.getNome()));
                    mappingPD.getIdFruitore().setTipo(ImporterInformationMissingSetter.replaceFruitore(mappingPD.getIdFruitore().getTipo(), fr.getTipo(), fr.getNome()));
                }
                if (mappingPD.getIdFruitore().getNome() == null) continue;
                mappingPD.getIdFruitore().setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, mappingPD.getIdFruitore().getNome(), fr.getTipo(), fr.getNome()));
                mappingPD.getIdFruitore().setNome(ImporterInformationMissingSetter.replaceFruitore(mappingPD.getIdFruitore().getNome(), fr.getTipo(), fr.getNome()));
            }
        }
    }

    private static void replaceTemplatesNames(IRegistryReader registryReader, IDServizio idServizio, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, boolean replaceProprietario) throws ProtocolException {
        if (idServizio.getSoggettoErogatore() != null) {
            if (idServizio.getSoggettoErogatore().getTipo() != null) {
                if (replaceProprietario) {
                    idServizio.getSoggettoErogatore().setTipo(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, idServizio.getSoggettoErogatore().getTipo(), tipoSoggettoErogatore, nomeSoggettoErogatore));
                }
                idServizio.getSoggettoErogatore().setTipo(ImporterInformationMissingSetter.replaceSoggettoErogatore(idServizio.getSoggettoErogatore().getTipo(), tipoSoggettoErogatore, nomeSoggettoErogatore));
            }
            if (idServizio.getSoggettoErogatore().getNome() != null) {
                if (replaceProprietario) {
                    idServizio.getSoggettoErogatore().setNome(ImporterInformationMissingSetter.replaceSoggettoProprietarioOrDefault(registryReader, idServizio.getSoggettoErogatore().getNome(), tipoSoggettoErogatore, nomeSoggettoErogatore));
                }
                idServizio.getSoggettoErogatore().setNome(ImporterInformationMissingSetter.replaceSoggettoErogatore(idServizio.getSoggettoErogatore().getNome(), tipoSoggettoErogatore, nomeSoggettoErogatore));
            }
        }
        if (idServizio.getTipo() != null) {
            idServizio.setTipo(ImporterInformationMissingSetter.replaceServizio(idServizio.getTipo(), tipoServizio, nomeServizio));
        }
        if (idServizio.getNome() != null) {
            idServizio.setNome(ImporterInformationMissingSetter.replaceServizio(idServizio.getNome(), tipoServizio, nomeServizio));
        }
    }
}

