/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.config.constants.PortaDelegataAzioneIdentificazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteApplicative;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteDelegate;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.mapping.ImplementationUtils;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.mapping.SubscriptionUtils;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.utils.RegistroServiziUtils;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.ProtocolImplementation;
import org.openspcoop2.protocol.sdk.config.ProtocolSubscription;
import org.slf4j.Logger;

public class UtilitiesMappingFruizioneErogazione {
    private DriverConfigurazioneDB driverConfigurazione;
    private DriverRegistroServiziDB driverRegistroServizi;
    private Logger log;

    public UtilitiesMappingFruizioneErogazione(DriverConfigurazioneDB driverConfigurazione, DriverRegistroServiziDB driverRegistroServizi, Logger log) {
        this.driverConfigurazione = driverConfigurazione;
        this.driverRegistroServizi = driverRegistroServizi;
        this.log = log;
    }

    public void initMappingFruizione() throws ProtocolException {
        this._initMapping(false);
    }

    public void initMappingErogazione() throws ProtocolException {
        this._initMapping(true);
    }

    private void _initMapping(boolean erogazione) throws ProtocolException {
        try {
            ArrayList<String> tipiPdd = new ArrayList<String>();
            tipiPdd.add(PddTipologia.OPERATIVO.toString());
            tipiPdd.add(PddTipologia.NONOPERATIVO.toString());
            for (String tipoPdd : tipiPdd) {
                this.log.debug("Pdd (tipo:" + tipoPdd + ") ricerca in corso...");
                FiltroRicerca filtroPdd = new FiltroRicerca();
                filtroPdd.setTipo(tipoPdd);
                ArrayList listPdD = null;
                try {
                    listPdD = this.driverRegistroServizi.getAllIdPorteDominio(filtroPdd);
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                if (listPdD == null) {
                    listPdD = new ArrayList();
                }
                this.log.debug("Pdd (tipo:" + tipoPdd + ") trovate: " + listPdD.size());
                if (listPdD.size() <= 0) continue;
                for (String nomePdd : listPdD) {
                    this.log.debug("Soggetti (pdd:" + nomePdd + ") ricerca in corso...");
                    FiltroRicercaSoggetti filtroSoggetti = new FiltroRicercaSoggetti();
                    filtroSoggetti.setNomePdd(nomePdd);
                    ArrayList listSoggetti = null;
                    try {
                        listSoggetti = this.driverRegistroServizi.getAllIdSoggetti(filtroSoggetti);
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                        // empty catch block
                    }
                    if (listSoggetti == null) {
                        listSoggetti = new ArrayList();
                    }
                    this.log.debug("Soggetti (pdd:" + nomePdd + ") trovati: " + listSoggetti.size());
                    if (listSoggetti.size() <= 0) continue;
                    for (IDSoggetto idSoggetto : listSoggetti) {
                        ArrayList listServizi;
                        FiltroRicercaServizi filtroServizi;
                        if (erogazione) {
                            this.log.debug("Servizi (soggetto:" + idSoggetto + ") ricerca in corso...");
                            filtroServizi = new FiltroRicercaServizi();
                            filtroServizi.setTipoSoggettoErogatore(idSoggetto.getTipo());
                            filtroServizi.setNomeSoggettoErogatore(idSoggetto.getNome());
                            listServizi = null;
                            try {
                                listServizi = this.driverRegistroServizi.getAllIdServizi(filtroServizi);
                            }
                            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                // empty catch block
                            }
                            if (listServizi == null) {
                                listServizi = new ArrayList();
                            }
                            this.log.debug("Servizi (soggetto:" + idSoggetto + ") trovati: " + listServizi.size());
                            if (listServizi.size() <= 0) continue;
                            for (IDServizio idServizio : listServizi) {
                                this.log.debug("PorteApplicative (soggetto:" + idSoggetto + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + ") ricerca in corso...");
                                FiltroRicercaPorteApplicative filtroPA = new FiltroRicercaPorteApplicative();
                                filtroPA.setTipoServizio(idServizio.getTipo());
                                filtroPA.setNomeServizio(idServizio.getNome());
                                filtroPA.setVersioneServizio(idServizio.getVersione());
                                filtroPA.setTipoSoggetto(idSoggetto.getTipo());
                                filtroPA.setNomeSoggetto(idSoggetto.getNome());
                                ArrayList<IDPortaApplicativa> listPA = null;
                                try {
                                    listPA = this.driverConfigurazione.getAllIdPorteApplicative(filtroPA);
                                }
                                catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                                    // empty catch block
                                }
                                if (listPA == null) {
                                    listPA = new ArrayList<IDPortaApplicativa>();
                                }
                                this.log.debug("PorteApplicative (soggetto:" + idSoggetto + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + ") trovate: " + listPA.size());
                                this._gestioneMappingErogazionePA(listPA, idServizio, idSoggetto);
                            }
                            continue;
                        }
                        this.log.debug("Servizi (fruitore:" + idSoggetto + ") ricerca in corso...");
                        filtroServizi = new FiltroRicercaServizi();
                        filtroServizi.setTipoSoggettoFruitore(idSoggetto.getTipo());
                        filtroServizi.setNomeSoggettoFruitore(idSoggetto.getNome());
                        listServizi = null;
                        try {
                            listServizi = this.driverRegistroServizi.getAllIdServizi(filtroServizi);
                        }
                        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                            // empty catch block
                        }
                        if (listServizi == null) {
                            listServizi = new ArrayList();
                        }
                        this.log.debug("Servizi (fruitore:" + idSoggetto + ") trovati: " + listServizi.size());
                        if (listServizi.size() <= 0) continue;
                        for (IDServizio idServizio : listServizi) {
                            this.log.debug("PorteDelegate (soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + ") ricerca in corso...");
                            FiltroRicercaPorteDelegate filtroPD = new FiltroRicercaPorteDelegate();
                            filtroPD.setTipoSoggetto(idSoggetto.getTipo());
                            filtroPD.setNomeSoggetto(idSoggetto.getNome());
                            filtroPD.setTipoSoggettoErogatore(idServizio.getSoggettoErogatore().getTipo());
                            filtroPD.setNomeSoggettoErogatore(idServizio.getSoggettoErogatore().getNome());
                            filtroPD.setTipoServizio(idServizio.getTipo());
                            filtroPD.setNomeServizio(idServizio.getNome());
                            filtroPD.setVersioneServizio(idServizio.getVersione());
                            ArrayList<IDPortaDelegata> listPD = null;
                            try {
                                listPD = this.driverConfigurazione.getAllIdPorteDelegate(filtroPD);
                            }
                            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                                // empty catch block
                            }
                            if (listPD == null) {
                                listPD = new ArrayList<IDPortaDelegata>();
                            }
                            this.log.debug("PorteDelegate (soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + ") trovate: " + listPD.size());
                            this._gestioneMappingFruizionePD(listPD, idServizio, idSoggetto);
                        }
                    }
                }
            }
        }
        catch (Throwable se) {
            throw new ProtocolException(se.getMessage(), se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gestioneMappingErogazionePAbyId(List<IDPortaApplicativa> listPA) throws Exception {
        if (listPA == null || listPA.isEmpty()) {
            return;
        }
        for (IDPortaApplicativa idPortaApplicativa : listPA) {
            PortaApplicativa pa = null;
            IDSoggetto idSoggetto = null;
            IDServizio idServizio = null;
            Connection con = null;
            try {
                con = this.driverConfigurazione.getConnection("UtilitiesMappingFruizioneErogazione.gestioneMappingErogazionePA");
                try {
                    pa = this.driverConfigurazione.getPortaApplicativa(idPortaApplicativa);
                    idSoggetto = new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario());
                    idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pa.getServizio().getTipo(), pa.getServizio().getNome(), idSoggetto, pa.getServizio().getVersione().intValue());
                }
                catch (Exception e) {
                    this.log.error("Errore durante il recupero della porta applicativa con id [" + idPortaApplicativa + "]: " + e.getMessage(), (Throwable)e);
                    try {
                        this.driverConfigurazione.releaseConnection(con);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.driverConfigurazione.releaseConnection(con);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.driverConfigurazione.releaseConnection(con);
            }
            catch (Throwable e) {}
            ArrayList<IDPortaApplicativa> listPA_unique = new ArrayList<IDPortaApplicativa>();
            listPA_unique.add(idPortaApplicativa);
            this._gestioneMappingErogazionePA(listPA_unique, idServizio, idSoggetto);
        }
    }

    public void gestioneMappingErogazionePA(List<PortaApplicativa> listPA) throws Exception {
        if (listPA == null || listPA.isEmpty()) {
            return;
        }
        for (PortaApplicativa pa : listPA) {
            IDSoggetto idSoggetto = null;
            IDServizio idServizio = null;
            IDPortaApplicativa idPortaApplicativa = null;
            try {
                idSoggetto = new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario());
                idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pa.getServizio().getTipo(), pa.getServizio().getNome(), idSoggetto, pa.getServizio().getVersione().intValue());
                idPortaApplicativa = new IDPortaApplicativa();
                idPortaApplicativa.setNome(pa.getNome());
            }
            catch (Exception e) {
                this.log.error("Errore durante la lettura dei dati della porta applicativa [" + pa.getNome() + "]: " + e.getMessage(), (Throwable)e);
                continue;
            }
            ArrayList<IDPortaApplicativa> listPA_unique = new ArrayList<IDPortaApplicativa>();
            listPA_unique.add(idPortaApplicativa);
            this._gestioneMappingErogazionePA(listPA_unique, idServizio, idSoggetto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gestioneMappingFruizionePDbyId(List<IDPortaDelegata> listPD) throws Exception {
        if (listPD == null || listPD.isEmpty()) {
            return;
        }
        for (IDPortaDelegata idPortaDelegata : listPD) {
            PortaDelegata pd = null;
            IDSoggetto idSoggetto = null;
            IDServizio idServizio = null;
            Connection con = null;
            try {
                con = this.driverConfigurazione.getConnection("UtilitiesMappingFruizioneErogazione.gestioneMappingFruizionePD");
                try {
                    pd = this.driverConfigurazione.getPortaDelegata(idPortaDelegata);
                    idSoggetto = new IDSoggetto(pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario());
                    idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pd.getServizio().getTipo(), pd.getServizio().getNome(), new IDSoggetto(pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()), pd.getServizio().getVersione().intValue());
                }
                catch (Exception e) {
                    this.log.error("Errore durante il recupero della porta applicativa con id [" + idPortaDelegata + "]: " + e.getMessage(), (Throwable)e);
                    try {
                        this.driverConfigurazione.releaseConnection(con);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.driverConfigurazione.releaseConnection(con);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.driverConfigurazione.releaseConnection(con);
            }
            catch (Throwable e) {}
            ArrayList<IDPortaDelegata> listPD_unique = new ArrayList<IDPortaDelegata>();
            listPD_unique.add(idPortaDelegata);
            this._gestioneMappingFruizionePD(listPD_unique, idServizio, idSoggetto);
        }
    }

    public void gestioneMappingFruizionePD(List<PortaDelegata> listPD) throws Exception {
        if (listPD == null || listPD.isEmpty()) {
            return;
        }
        for (PortaDelegata pd : listPD) {
            IDSoggetto idSoggetto = null;
            IDServizio idServizio = null;
            IDPortaDelegata idPortaDelegata = null;
            try {
                idSoggetto = new IDSoggetto(pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario());
                idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pd.getServizio().getTipo(), pd.getServizio().getNome(), new IDSoggetto(pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()), pd.getServizio().getVersione().intValue());
                idPortaDelegata = new IDPortaDelegata();
                idPortaDelegata.setNome(pd.getNome());
            }
            catch (Exception e) {
                this.log.error("Errore durante la lettura dei dati della porta delegata [" + pd.getNome() + "]: " + e.getMessage(), (Throwable)e);
                continue;
            }
            ArrayList<IDPortaDelegata> listPD_unique = new ArrayList<IDPortaDelegata>();
            listPD_unique.add(idPortaDelegata);
            this._gestioneMappingFruizionePD(listPD_unique, idServizio, idSoggetto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _gestioneMappingErogazionePA(List<IDPortaApplicativa> listPA, IDServizio idServizio, IDSoggetto idSoggetto) throws Exception {
        if (listPA == null || listPA.isEmpty()) {
            return;
        }
        String nomePortaDefault = null;
        HashMap<String, IDPortaApplicativa> mapPorte = new HashMap<String, IDPortaApplicativa>();
        HashMap<IDPortaApplicativa, PortaApplicativa> listPAModificare = new HashMap<IDPortaApplicativa, PortaApplicativa>();
        for (IDPortaApplicativa idPortaApplicativa : listPA) {
            String nomeAzione2;
            Connection con = null;
            try {
                con = this.driverRegistroServizi.getConnection("UtilitiesMappingFruizioneErogazione.existsIDPortaApplicativaAssociata");
                if (DBMappingUtils.existsMappingErogazione((IDServizio)idServizio, (IDPortaApplicativa)idPortaApplicativa, (Connection)con, (String)this.driverRegistroServizi.getTipoDB())) {
                    this.log.debug("PortaApplicativa '" + idPortaApplicativa.getNome() + "' (soggetto:" + idSoggetto + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + ") mapping gi\u00e0 esistente");
                    continue;
                }
            }
            finally {
                try {
                    this.driverRegistroServizi.releaseConnection(con);
                }
                catch (Exception exception) {}
                continue;
            }
            String nomeMapping = null;
            boolean isDefault = false;
            PortaApplicativa pa = this.driverConfigurazione.getPortaApplicativa(idPortaApplicativa);
            if (ImplementationUtils.isPortaApplicativaUtilizzabileComeDefault((PortaApplicativa)pa)) {
                nomeMapping = ImplementationUtils.getDefaultMappingName();
                isDefault = true;
                if (nomePortaDefault != null) {
                    this.log.debug("PortaApplicativa '" + idPortaApplicativa.getNome() + "' ignorata (soggetto:" + idSoggetto + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + "): mapping di default gi\u00e0 esistente nella pa con nome [" + nomePortaDefault + "]");
                    continue;
                }
                nomePortaDefault = idPortaApplicativa.getNome();
            } else if (PortaApplicativaAzioneIdentificazione.DELEGATED_BY.equals((Object)pa.getAzione().getIdentificazione())) {
                if (pa.getAzione().sizeAzioneDelegataList() <= 0) {
                    this.log.error("Trovata porta applicativa " + pa.getNome() + "] con un'identificazione dell'azione delegata senza pero' possedere azioni delegate");
                    continue;
                }
                nomeMapping = nomeAzione2 = pa.getAzione().getAzioneDelegata(0);
            } else {
                nomeAzione2 = pa.getAzione().getNome();
                if (mapPorte.containsKey(nomeAzione2)) {
                    this.log.debug("PortaApplicativa '" + idPortaApplicativa.getNome() + "' ignorata (soggetto:" + idSoggetto + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + "): mapping per l'azione '" + nomeAzione2 + "' gi\u00e0 esistente nella pa con nome [" + mapPorte.get(nomeAzione2) + "]");
                    continue;
                }
                mapPorte.put(nomeAzione2, idPortaApplicativa);
                nomeMapping = nomeAzione2;
                ImplementationUtils.setAzioneDelegate((PortaApplicativa)pa, null, (String[])new String[]{pa.getAzione().getNome()});
                listPAModificare.put(idPortaApplicativa, pa);
            }
            this.log.debug("Creazione Mapping Erogazione (default:" + isDefault + " nome:" + nomeMapping + ") soggetto:" + idSoggetto + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + " con pa:" + idPortaApplicativa.getNome() + " in corso...");
            con = null;
            try {
                con = this.driverRegistroServizi.getConnection("UtilitiesMappingFruizioneErogazione.createMappingErogazione");
                DBMappingUtils.createMappingErogazione((String)nomeMapping, (String)(isDefault ? "Predefinito" : nomeMapping), (boolean)isDefault, (IDServizio)idServizio, (IDPortaApplicativa)idPortaApplicativa, (Connection)con, (String)this.driverRegistroServizi.getTipoDB());
            }
            finally {
                try {
                    if (this.driverRegistroServizi.isAtomica() && con != null) {
                        con.commit();
                    }
                }
                catch (Throwable nomeAzione2) {}
                try {
                    this.driverRegistroServizi.releaseConnection(con);
                }
                catch (Throwable nomeAzione2) {}
            }
            this.log.debug("Creazione Mapping Erogazione (default:" + isDefault + " nome:" + nomeMapping + ") soggetto:" + idSoggetto + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + " con pa:" + idPortaApplicativa.getNome() + " effettuata con successo");
        }
        if (listPAModificare.size() > 0) {
            for (IDPortaApplicativa idPortaApplicativa : listPAModificare.keySet()) {
                PortaApplicativa pa = (PortaApplicativa)listPAModificare.get(idPortaApplicativa);
                if (nomePortaDefault == null) {
                    ServiceBinding serviceBinding = this.readServiceBinding(idServizio);
                    IProtocolFactory<?> p = ProtocolFactoryManager.getInstance().getProtocolFactoryByServiceType(idServizio.getTipo());
                    ProtocolImplementation implementation = p.createProtocolIntegrationConfiguration().createDefaultImplementation(serviceBinding, idServizio);
                    PortaApplicativa paDefault = implementation.getPortaApplicativa();
                    if (pa.sizeServizioApplicativoList() > 0) {
                        for (PortaApplicativaServizioApplicativo paSA : pa.getServizioApplicativoList()) {
                            paDefault.addServizioApplicativo(paSA);
                        }
                    }
                    MappingErogazionePortaApplicativa mapping = implementation.getMapping();
                    IDPortaApplicativa idPADefault = mapping.getIdPortaApplicativa();
                    nomePortaDefault = idPADefault.getNome();
                    if (!this.driverConfigurazione.existsPortaApplicativa(idPADefault)) {
                        this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + pa.getTipoSoggettoProprietario() + "/" + pa.getNomeSoggettoProprietario() + " creazione delegante [" + paDefault.getNome() + "] in corso...");
                        this.driverConfigurazione.createPortaApplicativa(paDefault);
                        this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + pa.getTipoSoggettoProprietario() + "/" + pa.getNomeSoggettoProprietario() + " creazione delegante [" + paDefault.getNome() + "].");
                    }
                    Connection con = null;
                    try {
                        con = this.driverConfigurazione.getConnection("UtilitiesMappingFruizioneErogazione.createMappingErogazione");
                        this.log.info("Creazione mapping di erogazione di default (nome:" + mapping.getNome() + " default:" + mapping.isDefault() + ") tra Porta Applicativa [" + paDefault.getNome() + "] e servizio [" + idServizio + "] creazione delegante in corso...");
                        DBMappingUtils.createMappingErogazione((String)mapping.getNome(), (String)mapping.getDescrizione(), (boolean)mapping.isDefault(), (IDServizio)idServizio, (IDPortaApplicativa)idPADefault, (Connection)con, (String)this.driverConfigurazione.getTipoDB());
                        this.log.info("Creazione mapping di erogazione di default (nome:" + mapping.getNome() + " default:" + mapping.isDefault() + ") tra Porta Applicativa [" + paDefault.getNome() + "] e servizio [" + idServizio + "] creato delegante.");
                    }
                    finally {
                        try {
                            this.driverRegistroServizi.releaseConnection(con);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                pa.getAzione().setNomePortaDelegante(nomePortaDefault);
                this.log.debug("Aggiornamento Porta Applicativa '" + idPortaApplicativa + "' per  Mapping Erogazione soggetto:" + idSoggetto + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + " per impostare nome delegate '" + nomePortaDefault + "' in corso...");
                this.driverConfigurazione.updatePortaApplicativa(pa);
                this.log.debug("Aggiornamento Porta Applicativa '" + idPortaApplicativa + "' per  Mapping Erogazione soggetto:" + idSoggetto + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + " per impostare nome delegate '" + nomePortaDefault + "' effettuata con successo");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _gestioneMappingFruizionePD(List<IDPortaDelegata> listPD, IDServizio idServizio, IDSoggetto idSoggetto) throws Exception {
        String nomePortaDefault = null;
        HashMap<String, IDPortaDelegata> mapPorte = new HashMap<String, IDPortaDelegata>();
        HashMap<IDPortaDelegata, PortaDelegata> listPDModificare = new HashMap<IDPortaDelegata, PortaDelegata>();
        for (IDPortaDelegata idPortaDelegata : listPD) {
            String nomeAzione2;
            Connection con = null;
            try {
                con = this.driverRegistroServizi.getConnection("UtilitiesMappingFruizioneErogazione.existsIDPortaDelegataAssociata");
                if (DBMappingUtils.existsMappingFruizione((IDServizio)idServizio, (IDSoggetto)idSoggetto, (IDPortaDelegata)idPortaDelegata, (Connection)con, (String)this.driverRegistroServizi.getTipoDB())) {
                    this.log.debug("PortaDelegata '" + idPortaDelegata.getNome() + "' (soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + ") mapping gi\u00e0 esistente");
                    continue;
                }
            }
            finally {
                try {
                    this.driverRegistroServizi.releaseConnection(con);
                }
                catch (Exception exception) {}
                continue;
            }
            String nomeMapping = null;
            boolean isDefault = false;
            PortaDelegata pd = this.driverConfigurazione.getPortaDelegata(idPortaDelegata);
            if (SubscriptionUtils.isPortaDelegataUtilizzabileComeDefault((PortaDelegata)pd)) {
                nomeMapping = SubscriptionUtils.getDefaultMappingName();
                isDefault = true;
                if (nomePortaDefault != null) {
                    this.log.debug("PortaDelegata '" + idPortaDelegata.getNome() + "' ignorata (soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + "): mapping di default gi\u00e0 esistente nella pd con nome [" + nomePortaDefault + "]");
                    continue;
                }
                nomePortaDefault = idPortaDelegata.getNome();
            } else if (PortaDelegataAzioneIdentificazione.DELEGATED_BY.equals((Object)pd.getAzione().getIdentificazione())) {
                if (pd.getAzione().sizeAzioneDelegataList() <= 0) {
                    this.log.error("Trovata porta delegata " + pd.getNome() + "] con un'identificazione dell'azione delegata senza pero' possedere azioni delegate");
                    continue;
                }
                nomeMapping = nomeAzione2 = pd.getAzione().getAzioneDelegata(0);
            } else {
                nomeAzione2 = pd.getAzione().getNome();
                if (mapPorte.containsKey(nomeAzione2)) {
                    this.log.debug("PortaDelegata '" + idPortaDelegata.getNome() + "' ignorata (soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + "): mapping per l'azione '" + nomeAzione2 + "' gi\u00e0 esistente nella pa con nome [" + mapPorte.get(nomeAzione2) + "]");
                    continue;
                }
                mapPorte.put(nomeAzione2, idPortaDelegata);
                nomeMapping = nomeAzione2;
                SubscriptionUtils.setAzioneDelegate((PortaDelegata)pd, null, (String[])new String[]{pd.getAzione().getNome()});
                listPDModificare.put(idPortaDelegata, pd);
            }
            this.log.debug("Creazione Mapping Fruizione soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + " con pd:" + idPortaDelegata.getNome() + " in corso...");
            con = null;
            try {
                con = this.driverRegistroServizi.getConnection("UtilitiesMappingFruizioneErogazione.createMappingFruizione");
                DBMappingUtils.createMappingFruizione((String)nomeMapping, (String)(isDefault ? "Predefinito" : nomeMapping), (boolean)isDefault, (IDServizio)idServizio, (IDSoggetto)idSoggetto, (IDPortaDelegata)idPortaDelegata, (Connection)con, (String)this.driverRegistroServizi.getTipoDB());
            }
            finally {
                try {
                    if (this.driverRegistroServizi.isAtomica() && con != null) {
                        con.commit();
                    }
                }
                catch (Throwable nomeAzione2) {}
                try {
                    this.driverRegistroServizi.releaseConnection(con);
                }
                catch (Throwable nomeAzione2) {}
            }
            this.log.debug("Creazione Mapping Fruizione soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + " con pd:" + idPortaDelegata.getNome() + " effettuata con successo");
        }
        if (listPDModificare.size() > 0) {
            for (IDPortaDelegata idPortaDelegata : listPDModificare.keySet()) {
                PortaDelegata pd = (PortaDelegata)listPDModificare.get(idPortaDelegata);
                if (nomePortaDefault == null) {
                    IDSoggetto idFruitore = new IDSoggetto(pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario());
                    ServiceBinding serviceBinding = this.readServiceBinding(idServizio);
                    IProtocolFactory<?> p = ProtocolFactoryManager.getInstance().getProtocolFactoryByServiceType(idServizio.getTipo());
                    ProtocolSubscription subcription = p.createProtocolIntegrationConfiguration().createDefaultSubscription(serviceBinding, idFruitore, idServizio);
                    PortaDelegata pdDefault = subcription.getPortaDelegata();
                    MappingFruizionePortaDelegata mapping = subcription.getMapping();
                    IDPortaDelegata idPDDefault = mapping.getIdPortaDelegata();
                    nomePortaDefault = idPDDefault.getNome();
                    if (!this.driverConfigurazione.existsPortaDelegata(idPDDefault)) {
                        this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + pd.getTipoSoggettoProprietario() + "/" + pd.getNomeSoggettoProprietario() + " creazione delegante [" + pdDefault.getNome() + "] in corso...");
                        this.driverConfigurazione.createPortaDelegata(pdDefault);
                        this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + pd.getTipoSoggettoProprietario() + "/" + pd.getNomeSoggettoProprietario() + " creazione delegante [" + pdDefault.getNome() + "].");
                    }
                    Connection con = null;
                    try {
                        con = this.driverConfigurazione.getConnection("UtilitiesMappingFruizioneErogazione.createMappingFruizione");
                        this.log.info("Creazione mapping di fruizione di default (nome:" + mapping.getNome() + " default:" + mapping.isDefault() + ") tra Porta delegata [" + pdDefault.getNome() + "], fruitore [" + idFruitore + "] e servizio [" + idServizio + "] creazione delegante in corso...");
                        DBMappingUtils.createMappingFruizione((String)mapping.getNome(), (String)mapping.getDescrizione(), (boolean)mapping.isDefault(), (IDServizio)idServizio, (IDSoggetto)idFruitore, (IDPortaDelegata)idPDDefault, (Connection)con, (String)this.driverConfigurazione.getTipoDB());
                        this.log.info("Creazione mapping di fruizione di default (nome:" + mapping.getNome() + " default:" + mapping.isDefault() + ") tra Porta delegata [" + pdDefault.getNome() + "], fruitore [" + idFruitore + "] e servizio [" + idServizio + "] creato delegante.");
                    }
                    finally {
                        try {
                            this.driverRegistroServizi.releaseConnection(con);
                        }
                        catch (Exception exception) {}
                    }
                }
                pd.getAzione().setNomePortaDelegante(nomePortaDefault);
                this.log.debug("Aggiornamento Porta Delegata '" + idPortaDelegata + "' per  Mapping Fruizione soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + " per impostare nome delegate '" + nomePortaDefault + "' in corso...");
                this.driverConfigurazione.updatePortaDelegata(pd);
                this.log.debug("Aggiornamento Porta Delegata '" + idPortaDelegata + "' per  Mapping Fruizione soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipo() + "/" + idServizio.getNome() + " v" + idServizio.getVersione() + " per impostare nome delegate '" + nomePortaDefault + "' effettuata con successo");
            }
        }
    }

    private ServiceBinding readServiceBinding(IDServizio idServizio) throws ProtocolException {
        try {
            AccordoServizioParteSpecifica asps = this.driverRegistroServizi.getAccordoServizioParteSpecifica(idServizio, false);
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
            org.openspcoop2.core.registry.constants.ServiceBinding sb = this.driverRegistroServizi.getAccordoServizioParteComune(idAccordo).getServiceBinding();
            return RegistroServiziUtils.convertToMessage((org.openspcoop2.core.registry.constants.ServiceBinding)sb);
        }
        catch (Throwable se) {
            throw new ProtocolException("Servizio [" + idServizio + "] non trovato: " + se.getMessage(), se);
        }
    }
}

