/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.driver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.engine.LetturaParametriBusta;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.engine.driver.Riscontri;
import org.openspcoop2.protocol.engine.driver.repository.IGestoreRepository;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ContestoCodificaEccezione;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.protocol.sdk.state.StatelessMessage;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public class RepositoryBuste {
    private Logger log = null;
    private IState state;
    private boolean isRichiesta = true;
    private IGestoreRepository gestoreRepositoryBuste;
    private IProtocolFactory<?> protocolFactory;

    public boolean isRichiesta() {
        return this.isRichiesta;
    }

    public void setRichiesta(boolean isRichiesta) {
        this.isRichiesta = isRichiesta;
    }

    public RepositoryBuste(IState state, boolean isRichiesta, IProtocolFactory<?> protocolFactory) {
        this(state, Configurazione.getLibraryLog(), isRichiesta, protocolFactory);
    }

    public RepositoryBuste(IState state, Logger alog, IProtocolFactory<?> protocolFactory) {
        this(state, alog, true, protocolFactory);
    }

    public RepositoryBuste(IState state, IProtocolFactory<?> protocolFactory) {
        this(state, Configurazione.getLibraryLog(), true, protocolFactory);
    }

    public RepositoryBuste(IState state, Logger alog, boolean isRichiesta, IProtocolFactory<?> protocolFactory) {
        this.state = state;
        this.gestoreRepositoryBuste = Configurazione.getGestoreRepositoryBuste();
        this.log = alog != null ? alog : LoggerWrapperFactory.getLogger((String)RepositoryBuste.class.getName());
        this.isRichiesta = isRichiesta;
        this.protocolFactory = protocolFactory;
    }

    public void updateState(IState state) {
        this.state = state;
    }

    public void registraBustaIntoOutBox(Busta busta, long scadenza) throws ProtocolException {
        this.registraBusta(busta, "OUTBOX", null, scadenza);
    }

    public void registraBustaIntoOutBox(Busta busta, List<Eccezione> errors, long scadenza) throws ProtocolException {
        this.registraBusta(busta, "OUTBOX", errors, scadenza);
    }

    public void registraBustaIntoOutBox(String id, IDSoggetto soggettoFruitore, IDServizio servizio, long scadenza, org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione profiloCollaborazione, boolean confermaRicezione, Inoltro inoltro) throws ProtocolException {
        Busta busta = new Busta(this.protocolFactory.getProtocol());
        busta.setID(id);
        busta.setTipoMittente(soggettoFruitore.getTipo());
        busta.setMittente(soggettoFruitore.getNome());
        busta.setIdentificativoPortaMittente(soggettoFruitore.getCodicePorta());
        busta.setTipoDestinatario(servizio.getSoggettoErogatore().getTipo());
        busta.setDestinatario(servizio.getSoggettoErogatore().getNome());
        busta.setIdentificativoPortaDestinatario(servizio.getSoggettoErogatore().getCodicePorta());
        busta.setTipoServizio(servizio.getTipo());
        busta.setServizio(servizio.getNome());
        busta.setVersioneServizio(servizio.getVersione());
        busta.setAzione(servizio.getAzione());
        busta.setProfiloDiCollaborazione(profiloCollaborazione);
        busta.setConfermaRicezione(confermaRicezione);
        busta.setInoltro(inoltro, this.protocolFactory.createTraduttore().toString(inoltro));
        this.registraBusta(busta, "OUTBOX", null, scadenza);
    }

    public void aggiornaProprietaBustaIntoOutBox(Map<String, String> properties, String idBusta) throws ProtocolException {
        this.aggiornaProprietaBusta(properties, idBusta, "OUTBOX");
    }

    public void aggiornaDuplicatiIntoOutBox(String id) throws ProtocolException {
        this.aggiornaDuplicati(id, "OUTBOX");
    }

    public void aggiornaInfoIntegrazioneIntoOutBox(String id, Integrazione infoIntegrazione) throws ProtocolException {
        this.aggiornaInfoIntegrazione(id, "OUTBOX", infoIntegrazione);
    }

    public void aggiornaInfoIntegrazioneIntoOutBox_ServizioApplicativo(String id, String servizioApplicativo) throws ProtocolException {
        this.aggiornaInfoIntegrazione_ServizioApplicativo(id, "OUTBOX", servizioApplicativo);
    }

    public void aggiornaInfoIntegrazioneIntoOutBox_Scenario(String id, String scenario) throws ProtocolException {
        this.aggiornaInfoIntegrazione_Scenario(id, "OUTBOX", scenario);
    }

    public void aggiornaBustaIntoOutBox(Busta busta, long scadenza) throws ProtocolException {
        this.aggiornaBusta(busta, "OUTBOX", scadenza, null);
    }

    public void aggiornaBustaIntoOutBox(Busta busta, long scadenza, List<Eccezione> errors) throws ProtocolException {
        this.aggiornaBusta(busta, "OUTBOX", scadenza, errors);
    }

    public void aggiornaBustaIntoOutBox(String id, IDSoggetto soggettoFruitore, IDServizio servizio, long scadenza, org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione profiloCollaborazione, boolean confermaRicezione, Inoltro inoltro) throws ProtocolException {
        Busta bustaDaAggiornare = new Busta(this.protocolFactory.getProtocol());
        bustaDaAggiornare.setID(id);
        bustaDaAggiornare.setTipoMittente(soggettoFruitore.getTipo());
        bustaDaAggiornare.setMittente(soggettoFruitore.getNome());
        bustaDaAggiornare.setIdentificativoPortaMittente(soggettoFruitore.getCodicePorta());
        bustaDaAggiornare.setTipoDestinatario(servizio.getSoggettoErogatore().getTipo());
        bustaDaAggiornare.setDestinatario(servizio.getSoggettoErogatore().getNome());
        bustaDaAggiornare.setIdentificativoPortaDestinatario(servizio.getSoggettoErogatore().getCodicePorta());
        bustaDaAggiornare.setTipoServizio(servizio.getTipo());
        bustaDaAggiornare.setServizio(servizio.getNome());
        bustaDaAggiornare.setVersioneServizio(servizio.getVersione());
        bustaDaAggiornare.setAzione(servizio.getAzione());
        bustaDaAggiornare.setProfiloDiCollaborazione(profiloCollaborazione);
        bustaDaAggiornare.setConfermaRicezione(confermaRicezione);
        bustaDaAggiornare.setInoltro(inoltro, this.protocolFactory.createTraduttore().toString(inoltro));
        this.aggiornaBusta(bustaDaAggiornare, "OUTBOX", scadenza, null);
    }

    public void aggiornaCollaborazioneIntoOutBox(String id, String collaborazione) throws ProtocolException {
        this.aggiornaCollaborazione(id, "OUTBOX", collaborazione);
    }

    public void aggiornaSequenzaIntoOutBox(String id, long sequenza) throws ProtocolException {
        this.aggiornaSequenza(id, "OUTBOX", sequenza);
    }

    public boolean isRegistrataIntoOutBox(String id) throws ProtocolException {
        return this.isRegistrata(id, "OUTBOX");
    }

    public Busta getBustaFromOutBox(String id) throws ProtocolException {
        return this.getBusta(id, "OUTBOX");
    }

    public List<Eccezione> getErrorsFromOutBox(String id, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        return this.getErrors(id, "OUTBOX");
    }

    public Busta getSomeValuesFromOutBox(String id, LetturaParametriBusta parametri) throws ProtocolException {
        return this.getSomeValues(id, "OUTBOX", parametri, false, null);
    }

    public Busta getSomeValuesFromOutBox(String id, LetturaParametriBusta parametri, boolean forzaLetturaDatabase) throws ProtocolException {
        return this.getSomeValues(id, "OUTBOX", parametri, forzaLetturaDatabase, null);
    }

    public Busta getSomeValuesFromOutBox(String id, LetturaParametriBusta parametri, Date dataRegistrazione) throws ProtocolException {
        return this.getSomeValues(id, "OUTBOX", parametri, false, dataRegistrazione);
    }

    public Busta getSomeValuesFromOutBox(String id, LetturaParametriBusta parametri, boolean forzaLetturaDatabase, Date dataRegistrazione) throws ProtocolException {
        return this.getSomeValues(id, "OUTBOX", parametri, forzaLetturaDatabase, dataRegistrazione);
    }

    public String getCollaborazioneFromOutBox(String id) throws ProtocolException {
        return this.getCollaborazione(id, "OUTBOX");
    }

    public org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione getProfiloCollaborazioneFromOutBox(String id) throws ProtocolException {
        return this.getProfiloCollaborazione(id, "OUTBOX");
    }

    public String getProfiloCollaborazioneValueFromOutBox(String id) throws ProtocolException {
        return this.getProfiloCollaborazioneValue(id, "OUTBOX");
    }

    public long getSequenzaFromOutBox(String id) throws ProtocolException {
        return this.getSequenza(id, "OUTBOX");
    }

    public Integrazione getInfoIntegrazioneFromOutBox(String id) throws ProtocolException {
        return this.getInfoIntegrazione(id, "OUTBOX");
    }

    public void eliminaUtilizzoPdDFromOutBox(String id) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "OUTBOX", false, null);
    }

    public void eliminaUtilizzoPdDFromOutBox(String id, boolean forzaUpdateDB) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "OUTBOX", forzaUpdateDB, null);
    }

    public void eliminaUtilizzoPdDFromOutBox(String id, boolean forzaUpdateDB, boolean savePreparedStatement) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "OUTBOX", forzaUpdateDB, savePreparedStatement, null);
    }

    public void eliminaUtilizzoPdDFromOutBox(String id, Date dataRegistrazione) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "OUTBOX", false, dataRegistrazione);
    }

    public void eliminaUtilizzoPdDFromOutBox(String id, boolean forzaUpdateDB, Date dataRegistrazione) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "OUTBOX", forzaUpdateDB, dataRegistrazione);
    }

    public void eliminaUtilizzoPdDFromOutBox(String id, boolean forzaUpdateDB, boolean savePreparedStatement, Date dataRegistrazione) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "OUTBOX", forzaUpdateDB, savePreparedStatement, dataRegistrazione);
    }

    public void eliminaBustaFromOutBox(String id, Date data) throws ProtocolException {
        this.eliminaBusta(id, "OUTBOX", data);
    }

    public void eliminaBustaStatelessFromOutBox(String id) throws ProtocolException {
        this.eliminaBustaStateless(id, "OUTBOX", null);
    }

    public void eliminaBustaStatelessFromOutBox(String id, Date dataRegistrazione) throws ProtocolException {
        this.eliminaBustaStateless(id, "OUTBOX", dataRegistrazione);
    }

    public void impostaUtilizzoPdDIntoOutBox(String id) throws ProtocolException {
        this.impostaUtilizzoPdD(id, "OUTBOX");
    }

    public void registraBustaIntoInBox(Busta busta, long scadenza) throws ProtocolException {
        this.registraBusta(busta, "INBOX", null, scadenza);
    }

    public void registraBustaIntoInBox(Busta busta, long scadenza, boolean saveServizioApplicativoFruitore) throws ProtocolException {
        this.registraBusta(busta, "INBOX", null, scadenza, saveServizioApplicativoFruitore);
    }

    public void registraBustaIntoInBox(Busta busta, List<Eccezione> errors, long scadenza) throws ProtocolException {
        this.registraBusta(busta, "INBOX", errors, scadenza);
    }

    public void registraBustaIntoInBox(String id, IDSoggetto soggettoFruitore, IDServizio servizio, long scadenza, org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione profiloCollaborazione, boolean confermaRicezione, Inoltro inoltro) throws ProtocolException {
        Busta busta = new Busta(this.protocolFactory.getProtocol());
        busta.setID(id);
        busta.setTipoMittente(soggettoFruitore.getTipo());
        busta.setMittente(soggettoFruitore.getNome());
        busta.setIdentificativoPortaMittente(soggettoFruitore.getCodicePorta());
        busta.setTipoDestinatario(servizio.getSoggettoErogatore().getTipo());
        busta.setDestinatario(servizio.getSoggettoErogatore().getNome());
        busta.setIdentificativoPortaDestinatario(servizio.getSoggettoErogatore().getCodicePorta());
        busta.setTipoServizio(servizio.getTipo());
        busta.setServizio(servizio.getNome());
        busta.setVersioneServizio(servizio.getVersione());
        busta.setAzione(servizio.getAzione());
        busta.setProfiloDiCollaborazione(profiloCollaborazione);
        busta.setConfermaRicezione(confermaRicezione);
        busta.setInoltro(inoltro, this.protocolFactory.createTraduttore().toString(inoltro));
        this.registraBusta(busta, "INBOX", null, scadenza);
    }

    public void aggiornaProprietaBustaIntoInBox(Map<String, String> properties, String idBusta) throws ProtocolException {
        this.aggiornaProprietaBusta(properties, idBusta, "INBOX");
    }

    public void aggiornaDuplicatiIntoInBox(String id) throws ProtocolException {
        this.aggiornaDuplicati(id, "INBOX");
    }

    public void aggiornaInfoIntegrazioneIntoInBox(String id, Integrazione infoIntegrazione) throws ProtocolException {
        this.aggiornaInfoIntegrazione(id, "INBOX", infoIntegrazione);
    }

    public void aggiornaInfoIntegrazioneIntoInBox_ServizioApplicativo(String id, String servizioApplicativo) throws ProtocolException {
        this.aggiornaInfoIntegrazione_ServizioApplicativo(id, "INBOX", servizioApplicativo);
    }

    public void aggiornaInfoIntegrazioneIntoInBox_Scenario(String id, String scenario) throws ProtocolException {
        this.aggiornaInfoIntegrazione_Scenario(id, "INBOX", scenario);
    }

    public void aggiornaBustaIntoInBox(Busta busta, long scadenza) throws ProtocolException {
        this.aggiornaBusta(busta, "INBOX", scadenza, null);
    }

    public void aggiornaBustaIntoInBox(Busta busta, long scadenza, boolean saveServizioApplicativoFruitore) throws ProtocolException {
        this.aggiornaBusta(busta, "INBOX", scadenza, null, saveServizioApplicativoFruitore);
    }

    public void aggiornaBustaIntoInBox(Busta busta, long scadenza, List<Eccezione> errors) throws ProtocolException {
        this.aggiornaBusta(busta, "INBOX", scadenza, errors);
    }

    public void aggiornaBustaIntoInBox(String id, IDSoggetto soggettoFruitore, IDServizio servizio, long scadenza, org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione profiloCollaborazione, boolean confermaRicezione, Inoltro inoltro) throws ProtocolException {
        Busta bustaDaAggiornare = new Busta(this.protocolFactory.getProtocol());
        bustaDaAggiornare.setID(id);
        bustaDaAggiornare.setTipoMittente(soggettoFruitore.getTipo());
        bustaDaAggiornare.setMittente(soggettoFruitore.getNome());
        bustaDaAggiornare.setIdentificativoPortaMittente(soggettoFruitore.getCodicePorta());
        bustaDaAggiornare.setTipoDestinatario(servizio.getSoggettoErogatore().getTipo());
        bustaDaAggiornare.setDestinatario(servizio.getSoggettoErogatore().getNome());
        bustaDaAggiornare.setIdentificativoPortaDestinatario(servizio.getSoggettoErogatore().getCodicePorta());
        bustaDaAggiornare.setTipoServizio(servizio.getTipo());
        bustaDaAggiornare.setServizio(servizio.getNome());
        bustaDaAggiornare.setVersioneServizio(servizio.getVersione());
        bustaDaAggiornare.setAzione(servizio.getAzione());
        bustaDaAggiornare.setProfiloDiCollaborazione(profiloCollaborazione);
        bustaDaAggiornare.setConfermaRicezione(confermaRicezione);
        bustaDaAggiornare.setInoltro(inoltro, this.protocolFactory.createTraduttore().toString(inoltro));
        this.aggiornaBusta(bustaDaAggiornare, "INBOX", scadenza, null);
    }

    public void aggiornaCollaborazioneIntoInBox(String id, String collaborazione) throws ProtocolException {
        this.aggiornaCollaborazione(id, "INBOX", collaborazione);
    }

    public void aggiornaSequenzaIntoInBox(String id, long sequenza) throws ProtocolException {
        this.aggiornaSequenza(id, "INBOX", sequenza);
    }

    public boolean isRegistrataIntoInBox(String id) throws ProtocolException {
        return this.isRegistrata(id, "INBOX");
    }

    public Busta getBustaFromInBox(String id) throws ProtocolException {
        return this.getBusta(id, "INBOX");
    }

    public Busta getBustaFromInBox(String id, boolean readServizioApplicativoFruitore) throws ProtocolException {
        return this.getBusta(id, "INBOX", readServizioApplicativoFruitore);
    }

    public List<Eccezione> getErrorsFromInBox(String id) throws ProtocolException {
        return this.getErrors(id, "INBOX");
    }

    public Busta getSomeValuesFromInBox(String id, LetturaParametriBusta parametri) throws ProtocolException {
        return this.getSomeValues(id, "INBOX", parametri, false, null);
    }

    public Busta getSomeValuesFromInBox(String id, LetturaParametriBusta parametri, boolean forzaLetturaDatabase) throws ProtocolException {
        return this.getSomeValues(id, "INBOX", parametri, forzaLetturaDatabase, null);
    }

    public Busta getSomeValuesFromInBox(String id, LetturaParametriBusta parametri, Date dataRegistrazione) throws ProtocolException {
        return this.getSomeValues(id, "INBOX", parametri, false, dataRegistrazione);
    }

    public Busta getSomeValuesFromInBox(String id, LetturaParametriBusta parametri, boolean forzaLetturaDatabase, Date dataRegistrazione) throws ProtocolException {
        return this.getSomeValues(id, "INBOX", parametri, forzaLetturaDatabase, dataRegistrazione);
    }

    public String getCollaborazioneFromInBox(String id) throws ProtocolException {
        return this.getCollaborazione(id, "INBOX");
    }

    public org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione getProfiloCollaborazioneFromInBox(String id) throws ProtocolException {
        return this.getProfiloCollaborazione(id, "INBOX");
    }

    public String getProfiloCollaborazioneValueFromInBox(String id) throws ProtocolException {
        return this.getProfiloCollaborazioneValue(id, "INBOX");
    }

    public long getSequenzaFromInBox(String id) throws ProtocolException {
        return this.getSequenza(id, "INBOX");
    }

    public Integrazione getInfoIntegrazioneFromInBox(String id) throws ProtocolException {
        return this.getInfoIntegrazione(id, "INBOX");
    }

    public void eliminaUtilizzoPdDFromInBox(String id) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "INBOX", false, null);
    }

    public void eliminaUtilizzoPdDFromInBox(String id, boolean forzaUpdateDB) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "INBOX", forzaUpdateDB, null);
    }

    public void eliminaUtilizzoPdDFromInBox(String id, boolean forzaUpdateDB, boolean savePreparedStatement) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "INBOX", forzaUpdateDB, savePreparedStatement, null);
    }

    public void eliminaUtilizzoPdDFromInBox(String id, Date dataRegistrazione) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "INBOX", false, dataRegistrazione);
    }

    public void eliminaUtilizzoPdDFromInBox(String id, boolean forzaUpdateDB, Date dataRegistrazione) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "INBOX", forzaUpdateDB, dataRegistrazione);
    }

    public void eliminaUtilizzoPdDFromInBox(String id, boolean forzaUpdateDB, boolean savePreparedStatement, Date dataRegistrazione) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "INBOX", forzaUpdateDB, savePreparedStatement, dataRegistrazione);
    }

    public void eliminaBustaFromInBox(String id, Date data) throws ProtocolException {
        this.eliminaBusta(id, "INBOX", data);
    }

    public void eliminaBustaStatelessFromInBox(String id) throws ProtocolException {
        this.eliminaBustaStateless(id, "INBOX", null);
    }

    public void eliminaBustaStatelessFromInBox(String id, Date dataRegistrazione) throws ProtocolException {
        this.eliminaBustaStateless(id, "INBOX", dataRegistrazione);
    }

    public void impostaUtilizzoPdDIntoInBox(String id) throws ProtocolException {
        this.impostaUtilizzoPdD(id, "INBOX");
    }

    public void registraBustaIntoInboxForHistory(Busta busta, long scadenza) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtBusta = null;
        try {
            Timestamp dataRegistrazione = DateManager.getTimestamp();
            Date scadenzaBusta = busta.getScadenza();
            if (scadenzaBusta == null) {
                scadenzaBusta = new Date(DateManager.getTimeMillis() + scadenza * 60L * 1000L);
            }
            Timestamp scadenzaT = new Timestamp(scadenzaBusta.getTime());
            StringBuilder query = new StringBuilder();
            query.append("INSERT INTO  ");
            query.append("REPOSITORY_BUSTE");
            query.append(" (ID_MESSAGGIO,TIPO,MITTENTE,IDPORTA_MITTENTE,TIPO_MITTENTE,IND_TELEMATICO_MITT,DESTINATARIO,IDPORTA_DESTINATARIO,TIPO_DESTINATARIO,IND_TELEMATICO_DEST");
            query.append(",VERSIONE_SERVIZIO,SERVIZIO,TIPO_SERVIZIO,AZIONE,PROFILO_DI_COLLABORAZIONE,SERVIZIO_CORRELATO,TIPO_SERVIZIO_CORRELATO");
            query.append(",COLLABORAZIONE,SEQUENZA,INOLTRO_SENZA_DUPLICATI,CONFERMA_RICEZIONE,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE");
            query.append(",RIFERIMENTO_MESSAGGIO,SCADENZA_BUSTA,DUPLICATI,LOCATION_PD,SERVIZIO_APPLICATIVO,MODULO_IN_ATTESA,SCENARIO,PROTOCOLLO,DATA_REGISTRAZIONE,");
            query.append(this.gestoreRepositoryBuste.createSQLFieldHistory());
            query.append(") ");
            query.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,");
            query.append(this.gestoreRepositoryBuste.getSQLValueHistory(true));
            query.append(")");
            pstmtBusta = connectionDB.prepareStatement(query.toString());
            int index = 1;
            pstmtBusta.setString(index++, busta.getID());
            pstmtBusta.setString(index++, "INBOX");
            pstmtBusta.setString(index++, busta.getMittente());
            pstmtBusta.setString(index++, busta.getIdentificativoPortaMittente());
            pstmtBusta.setString(index++, busta.getTipoMittente());
            pstmtBusta.setString(index++, busta.getIndirizzoMittente());
            pstmtBusta.setString(index++, busta.getDestinatario());
            pstmtBusta.setString(index++, busta.getIdentificativoPortaDestinatario());
            pstmtBusta.setString(index++, busta.getTipoDestinatario());
            pstmtBusta.setString(index++, busta.getIndirizzoDestinatario());
            pstmtBusta.setInt(index++, busta.getVersioneServizio());
            pstmtBusta.setString(index++, busta.getServizio());
            pstmtBusta.setString(index++, busta.getTipoServizio());
            pstmtBusta.setString(index++, busta.getAzione());
            pstmtBusta.setString(index++, busta.getProfiloDiCollaborazione().getEngineValue());
            pstmtBusta.setString(index++, busta.getServizioCorrelato());
            pstmtBusta.setString(index++, busta.getTipoServizioCorrelato());
            pstmtBusta.setString(index++, busta.getCollaborazione());
            pstmtBusta.setLong(index++, busta.getSequenza());
            if (Inoltro.SENZA_DUPLICATI.equals((Object)busta.getInoltro())) {
                pstmtBusta.setInt(index++, 1);
            } else {
                pstmtBusta.setInt(index++, 0);
            }
            if (busta.isConfermaRicezione()) {
                pstmtBusta.setInt(index++, 1);
            } else {
                pstmtBusta.setInt(index++, 0);
            }
            Timestamp oraRec = null;
            TipoOraRegistrazione tipoOraRec = null;
            if (busta.getOraRegistrazione() != null && busta.getTipoOraRegistrazione() != null) {
                oraRec = new Timestamp(busta.getOraRegistrazione().getTime());
                tipoOraRec = busta.getTipoOraRegistrazione();
            } else {
                oraRec = dataRegistrazione;
                tipoOraRec = TipoOraRegistrazione.SINCRONIZZATO;
            }
            pstmtBusta.setTimestamp(index++, oraRec);
            pstmtBusta.setString(index++, tipoOraRec.getEngineValue());
            pstmtBusta.setString(index++, busta.getRiferimentoMessaggio());
            pstmtBusta.setTimestamp(index++, scadenzaT);
            pstmtBusta.setInt(index++, 0);
            pstmtBusta.setString(index++, null);
            pstmtBusta.setString(index++, null);
            pstmtBusta.setString(index++, null);
            pstmtBusta.setString(index++, null);
            if (busta.getProtocollo() != null) {
                pstmtBusta.setString(index++, busta.getProtocollo());
            } else if (this.protocolFactory != null) {
                pstmtBusta.setString(index++, this.protocolFactory.getProtocol());
            } else {
                throw new ProtocolException("Protocol unknow");
            }
            pstmtBusta.setTimestamp(index++, dataRegistrazione);
            stateMSG.getPreparedStatement().put("INSERT RegistrazioneBustaForHistoryINBOX_" + busta.getID(), (PreparedStatement)pstmtBusta);
        }
        catch (Exception e) {
            String id = busta.getID();
            String errorMsg = "REPOSITORY_BUSTE, Errore di registrazione per History INBOX/" + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmtBusta != null) {
                    pstmtBusta.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public void registraBusta(Busta busta, String tipoBusta, List<Eccezione> errors, long scadenza) throws ProtocolException {
        this.registraBusta(busta, tipoBusta, errors, scadenza, false);
    }

    public void registraBusta(Busta busta, String tipoBusta, List<Eccezione> errors, long scadenza, boolean saveServizioApplicativoFruitore) throws ProtocolException {
        if (!this.isRichiesta && this.state instanceof StatelessMessage) {
            ((StatelessMessage)this.state).setBusta(busta);
            return;
        }
        Timestamp dataRegistrazione = DateManager.getTimestamp();
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtBusta = null;
        Statement pstmtUpdateAccessoPdD = null;
        Statement pstmtListaRiscontri = null;
        Statement pstmtListaTrasmissioni = null;
        Statement pstmtListaEccezioni = null;
        Statement pstmtListaEccezioniValidazione = null;
        Statement pstmtListaExtInfo = null;
        try {
            Date scadenzaBusta = busta.getScadenza();
            if (scadenzaBusta == null) {
                scadenzaBusta = new Date(DateManager.getTimeMillis() + scadenza * 60L * 1000L);
            }
            Timestamp scadenzaT = new Timestamp(scadenzaBusta.getTime());
            StringBuilder query = new StringBuilder();
            query.append("INSERT INTO  ");
            query.append("REPOSITORY_BUSTE");
            query.append(" (ID_MESSAGGIO,TIPO,MITTENTE,IDPORTA_MITTENTE,TIPO_MITTENTE,IND_TELEMATICO_MITT,DESTINATARIO,IDPORTA_DESTINATARIO,TIPO_DESTINATARIO,IND_TELEMATICO_DEST");
            query.append(",VERSIONE_SERVIZIO,SERVIZIO,TIPO_SERVIZIO,AZIONE,PROFILO_DI_COLLABORAZIONE,SERVIZIO_CORRELATO,TIPO_SERVIZIO_CORRELATO");
            query.append(",COLLABORAZIONE,SEQUENZA,INOLTRO_SENZA_DUPLICATI,CONFERMA_RICEZIONE,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE");
            query.append(",RIFERIMENTO_MESSAGGIO,SCADENZA_BUSTA,DUPLICATI,LOCATION_PD,SERVIZIO_APPLICATIVO,MODULO_IN_ATTESA,SCENARIO,PROTOCOLLO,DATA_REGISTRAZIONE) ");
            query.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            pstmtBusta = connectionDB.prepareStatement(query.toString());
            int index = 1;
            pstmtBusta.setString(index++, busta.getID());
            pstmtBusta.setString(index++, tipoBusta);
            pstmtBusta.setString(index++, busta.getMittente());
            pstmtBusta.setString(index++, busta.getIdentificativoPortaMittente());
            pstmtBusta.setString(index++, busta.getTipoMittente());
            pstmtBusta.setString(index++, busta.getIndirizzoMittente());
            pstmtBusta.setString(index++, busta.getDestinatario());
            pstmtBusta.setString(index++, busta.getIdentificativoPortaDestinatario());
            pstmtBusta.setString(index++, busta.getTipoDestinatario());
            pstmtBusta.setString(index++, busta.getIndirizzoDestinatario());
            pstmtBusta.setInt(index++, busta.getVersioneServizio());
            pstmtBusta.setString(index++, busta.getServizio());
            pstmtBusta.setString(index++, busta.getTipoServizio());
            pstmtBusta.setString(index++, busta.getAzione());
            pstmtBusta.setString(index++, busta.getProfiloDiCollaborazione() == null ? null : busta.getProfiloDiCollaborazione().getEngineValue());
            pstmtBusta.setString(index++, busta.getServizioCorrelato());
            pstmtBusta.setString(index++, busta.getTipoServizioCorrelato());
            pstmtBusta.setString(index++, busta.getCollaborazione());
            pstmtBusta.setLong(index++, busta.getSequenza());
            if (Inoltro.SENZA_DUPLICATI.equals((Object)busta.getInoltro())) {
                pstmtBusta.setInt(index++, 1);
            } else {
                pstmtBusta.setInt(index++, 0);
            }
            if (busta.isConfermaRicezione()) {
                pstmtBusta.setInt(index++, 1);
            } else {
                pstmtBusta.setInt(index++, 0);
            }
            Timestamp oraRec = null;
            TipoOraRegistrazione tipoOraRec = null;
            if (busta.getOraRegistrazione() != null && busta.getTipoOraRegistrazione() != null) {
                oraRec = new Timestamp(busta.getOraRegistrazione().getTime());
                tipoOraRec = busta.getTipoOraRegistrazione();
            } else {
                oraRec = dataRegistrazione;
                tipoOraRec = TipoOraRegistrazione.SINCRONIZZATO;
            }
            pstmtBusta.setTimestamp(index++, oraRec);
            pstmtBusta.setString(index++, tipoOraRec.getEngineValue());
            pstmtBusta.setString(index++, busta.getRiferimentoMessaggio());
            pstmtBusta.setTimestamp(index++, scadenzaT);
            pstmtBusta.setInt(index++, 0);
            pstmtBusta.setString(index++, null);
            if (saveServizioApplicativoFruitore) {
                pstmtBusta.setString(index++, busta.getServizioApplicativoFruitore());
            } else {
                pstmtBusta.setString(index++, null);
            }
            pstmtBusta.setString(index++, null);
            pstmtBusta.setString(index++, null);
            if (busta.getProtocollo() != null) {
                pstmtBusta.setString(index++, busta.getProtocollo());
            } else if (this.protocolFactory != null) {
                pstmtBusta.setString(index++, this.protocolFactory.getProtocol());
            } else {
                throw new ProtocolException("Protocol unknow");
            }
            pstmtBusta.setTimestamp(index++, dataRegistrazione);
            stateMSG.getPreparedStatement().put("INSERT RegistrazioneBusta" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtBusta);
            query.delete(0, query.length());
            query.append("UPDATE ");
            query.append("REPOSITORY_BUSTE");
            query.append(" SET ");
            query.append(this.gestoreRepositoryBuste.createSQLSet_PdD(true));
            query.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
            pstmtUpdateAccessoPdD = connectionDB.prepareStatement(query.toString());
            index = 1;
            pstmtUpdateAccessoPdD.setString(index++, busta.getID());
            pstmtUpdateAccessoPdD.setString(index++, tipoBusta);
            stateMSG.getPreparedStatement().put("INSERT RegistrazioneBusta" + tipoBusta + "_" + busta.getID() + " UPDATE RegistrazioneBustaAccessoPdD", (PreparedStatement)pstmtUpdateAccessoPdD);
            if (this.state instanceof StatefulMessage) {
                String[] names;
                Eccezione eccezione;
                int i;
                for (i = 0; i < busta.sizeListaRiscontri(); ++i) {
                    Riscontro riscontro = busta.getRiscontro(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_RISCONTRI");
                    query.append(" (ID_MESSAGGIO,TIPO,ID_RISCONTRO,RICEVUTA,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE,DATA_REGISTRAZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?)");
                    pstmtListaRiscontri = connectionDB.prepareStatement(query.toString());
                    index = 1;
                    pstmtListaRiscontri.setString(index++, busta.getID());
                    pstmtListaRiscontri.setString(index++, tipoBusta);
                    pstmtListaRiscontri.setString(index++, riscontro.getID());
                    pstmtListaRiscontri.setString(index++, riscontro.getRicevuta());
                    Timestamp oraRecRiscontro = null;
                    if (riscontro.getOraRegistrazione() != null) {
                        oraRecRiscontro = new Timestamp(riscontro.getOraRegistrazione().getTime());
                    }
                    pstmtListaRiscontri.setTimestamp(index++, oraRecRiscontro);
                    pstmtListaRiscontri.setString(index++, riscontro.getTipoOraRegistrazione().getEngineValue());
                    pstmtListaRiscontri.setTimestamp(index++, dataRegistrazione);
                    stateMSG.getPreparedStatement().put("INSERT RegistrazioneListaRiscontri_riscontro[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaRiscontri);
                }
                for (i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                    Trasmissione trasmissione = busta.getTrasmissione(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_TRASMISSIONI");
                    query.append(" (ID_MESSAGGIO,TIPO,ORIGINE,TIPO_ORIGINE,DESTINAZIONE,TIPO_DESTINAZIONE,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE,DATA_REGISTRAZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?,?,?)");
                    pstmtListaTrasmissioni = connectionDB.prepareStatement(query.toString());
                    index = 1;
                    pstmtListaTrasmissioni.setString(index++, busta.getID());
                    pstmtListaTrasmissioni.setString(index++, tipoBusta);
                    pstmtListaTrasmissioni.setString(index++, trasmissione.getOrigine());
                    pstmtListaTrasmissioni.setString(index++, trasmissione.getTipoOrigine());
                    pstmtListaTrasmissioni.setString(index++, trasmissione.getDestinazione());
                    pstmtListaTrasmissioni.setString(index++, trasmissione.getTipoDestinazione());
                    Timestamp oraRecTrasmissione = null;
                    if (trasmissione.getOraRegistrazione() != null) {
                        oraRecTrasmissione = new Timestamp(trasmissione.getOraRegistrazione().getTime());
                    }
                    pstmtListaTrasmissioni.setTimestamp(index++, oraRecTrasmissione);
                    pstmtListaTrasmissioni.setString(index++, trasmissione.getTempo().getEngineValue());
                    pstmtListaTrasmissioni.setTimestamp(index++, dataRegistrazione);
                    stateMSG.getPreparedStatement().put("INSERT RegistrazioneListaTrasmissioni_trasmissione[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaTrasmissioni);
                }
                for (i = 0; i < busta.sizeListaEccezioni(); ++i) {
                    eccezione = busta.getEccezione(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_ECCEZIONI");
                    query.append(" (ID_MESSAGGIO,TIPO,VALIDAZIONE,CONTESTO,CODICE,RILEVANZA,POSIZIONE,DATA_REGISTRAZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?,?)");
                    pstmtListaEccezioni = connectionDB.prepareStatement(query.toString());
                    index = 1;
                    pstmtListaEccezioni.setString(index++, busta.getID());
                    pstmtListaEccezioni.setString(index++, tipoBusta);
                    pstmtListaEccezioni.setInt(index++, 0);
                    pstmtListaEccezioni.setString(index++, eccezione.getContestoCodifica().getEngineValue());
                    pstmtListaEccezioni.setInt(index++, eccezione.getCodiceEccezione().getCodice());
                    pstmtListaEccezioni.setString(index++, eccezione.getRilevanza().getEngineValue());
                    pstmtListaEccezioni.setString(index++, eccezione.getDescrizione(this.protocolFactory));
                    pstmtListaEccezioni.setTimestamp(index++, dataRegistrazione);
                    stateMSG.getPreparedStatement().put("INSERT RegistrazioneListaEccezioni_eccezioneBusta[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaEccezioni);
                }
                if (errors != null) {
                    for (i = 0; i < errors.size(); ++i) {
                        eccezione = errors.get(i);
                        query.delete(0, query.length());
                        query.append("INSERT INTO  ");
                        query.append("LISTA_ECCEZIONI");
                        query.append(" (ID_MESSAGGIO,TIPO,VALIDAZIONE,CONTESTO,CODICE,RILEVANZA,POSIZIONE,DATA_REGISTRAZIONE)");
                        query.append(" VALUES (?,?,?,?,?,?,?,?)");
                        pstmtListaEccezioniValidazione = connectionDB.prepareStatement(query.toString());
                        index = 1;
                        pstmtListaEccezioniValidazione.setString(index++, busta.getID());
                        pstmtListaEccezioniValidazione.setString(index++, tipoBusta);
                        pstmtListaEccezioniValidazione.setInt(index++, 1);
                        pstmtListaEccezioniValidazione.setString(index++, eccezione.getContestoCodifica().getEngineValue());
                        pstmtListaEccezioniValidazione.setInt(index++, eccezione.getCodiceEccezione().getCodice());
                        pstmtListaEccezioniValidazione.setString(index++, eccezione.getRilevanza().getEngineValue());
                        pstmtListaEccezioniValidazione.setString(index++, eccezione.getDescrizione(this.protocolFactory));
                        pstmtListaEccezioniValidazione.setTimestamp(index++, dataRegistrazione);
                        stateMSG.getPreparedStatement().put("INSERT RegistrazioneListaEccezioni_eccezioneValidazione[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaEccezioniValidazione);
                    }
                }
                if (busta.sizeProperties() > 0 && (names = busta.getPropertiesNames()) != null && names.length > 0) {
                    for (int i2 = 0; i2 < names.length; ++i2) {
                        String name = names[i2];
                        String value = busta.getProperty(name);
                        query.delete(0, query.length());
                        query.append("INSERT INTO  ");
                        query.append("LISTA_EXT_PROTOCOL_INFO");
                        query.append(" (ID_MESSAGGIO,TIPO,NOME,VALORE,DATA_REGISTRAZIONE)");
                        query.append(" VALUES (?,?,?,?,?)");
                        pstmtListaExtInfo = connectionDB.prepareStatement(query.toString());
                        index = 1;
                        pstmtListaExtInfo.setString(index++, busta.getID());
                        pstmtListaExtInfo.setString(index++, tipoBusta);
                        pstmtListaExtInfo.setString(index++, name);
                        pstmtListaExtInfo.setString(index++, value);
                        pstmtListaExtInfo.setTimestamp(index++, dataRegistrazione);
                        stateMSG.getPreparedStatement().put("INSERT RegistrazioneListaExtInfoProtocol_info[" + i2 + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaExtInfo);
                    }
                }
            }
        }
        catch (Exception e) {
            String id = busta.getID();
            String errorMsg = "REPOSITORY_BUSTE, Errore di registrazione " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmtBusta != null) {
                    pstmtBusta.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtUpdateAccessoPdD != null) {
                    pstmtUpdateAccessoPdD.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtListaRiscontri != null) {
                    pstmtListaRiscontri.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtListaTrasmissioni != null) {
                    pstmtListaTrasmissioni.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtListaEccezioni != null) {
                    pstmtListaEccezioni.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtListaEccezioniValidazione != null) {
                    pstmtListaEccezioniValidazione.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtListaExtInfo != null) {
                    pstmtListaExtInfo.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        if (stateMSG instanceof StatelessMessage) {
            ((StatelessMessage)stateMSG).setBusta(busta);
        }
    }

    public void aggiornaProprietaBusta(Map<String, String> properties, String idBusta, String tipoBusta) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        if (connectionDB == null) {
            return;
        }
        Statement pstmtDeleteListaExtInfo = null;
        Statement pstmtListaExtInfo = null;
        try {
            StringBuilder queryDelete = new StringBuilder();
            queryDelete.delete(0, queryDelete.length());
            queryDelete.append("DELETE FROM ");
            queryDelete.append("LISTA_EXT_PROTOCOL_INFO");
            queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
            pstmtDeleteListaExtInfo = connectionDB.prepareStatement(queryDelete.toString());
            pstmtDeleteListaExtInfo.setString(1, idBusta);
            pstmtDeleteListaExtInfo.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("DELETE(UPDATE) AggiornamentoBusta_listaExtInfo" + tipoBusta + "_" + idBusta, (PreparedStatement)pstmtDeleteListaExtInfo);
            if (properties.size() > 0) {
                int index = 0;
                for (String name : properties.keySet()) {
                    String value = properties.get(name);
                    StringBuilder query = new StringBuilder();
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_EXT_PROTOCOL_INFO");
                    query.append(" (ID_MESSAGGIO,TIPO,NOME,VALORE)");
                    query.append(" VALUES (?,?,?,?)");
                    pstmtListaExtInfo = connectionDB.prepareStatement(query.toString());
                    pstmtListaExtInfo.setString(1, idBusta);
                    pstmtListaExtInfo.setString(2, tipoBusta);
                    pstmtListaExtInfo.setString(3, name);
                    pstmtListaExtInfo.setString(4, value);
                    stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaExtInfoProtocol_info[" + index + "]_" + tipoBusta + "_" + idBusta, (PreparedStatement)pstmtListaExtInfo);
                    ++index;
                }
            }
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento proprieta' " + tipoBusta + "/" + idBusta + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmtDeleteListaExtInfo != null) {
                    pstmtDeleteListaExtInfo.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtListaExtInfo != null) {
                    pstmtListaExtInfo.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public void aggiornaBusta(Busta busta, String tipoBusta, long scadenza, List<Eccezione> errors) throws ProtocolException {
        this.aggiornaBusta(busta, tipoBusta, scadenza, errors, false);
    }

    public void aggiornaBusta(Busta busta, String tipoBusta, long scadenza, List<Eccezione> errors, boolean saveServizioApplicativoFruitore) throws ProtocolException {
        if (!this.isRichiesta && this.state instanceof StatelessMessage) {
            ((StatelessMessage)this.state).setBusta(busta);
            return;
        }
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtBusta = null;
        Statement pstmtDeleteListaRiscontri = null;
        Statement pstmtDeleteListaTrasmissioni = null;
        Statement pstmtDeleteListaEccezioni = null;
        Statement pstmtDeleteListaExtInfo = null;
        Statement pstmtListaRiscontri = null;
        Statement pstmtListaTrasmissioni = null;
        Statement pstmtListaEccezioni = null;
        Statement pstmtListaEccezioniValidazione = null;
        Statement pstmtListaExtInfo = null;
        try {
            Timestamp dataRegistrazione = DateManager.getTimestamp();
            Date scadenzaBusta = busta.getScadenza();
            if (scadenzaBusta == null) {
                scadenzaBusta = new Date(DateManager.getTimeMillis() + scadenza * 60L * 1000L);
            }
            Timestamp scadenzaT = new Timestamp(scadenzaBusta.getTime());
            StringBuilder query = new StringBuilder();
            query.append("UPDATE  ");
            query.append("REPOSITORY_BUSTE");
            query.append(" SET ");
            query.append("MITTENTE = ? ,");
            query.append("IDPORTA_MITTENTE = ? ,");
            query.append("TIPO_MITTENTE = ? ,");
            query.append("IND_TELEMATICO_MITT = ? ,");
            query.append("DESTINATARIO = ? ,");
            query.append("IDPORTA_DESTINATARIO = ? ,");
            query.append("TIPO_DESTINATARIO = ? ,");
            query.append("IND_TELEMATICO_DEST = ? ,");
            query.append("VERSIONE_SERVIZIO = ? ,");
            query.append("SERVIZIO = ? ,");
            query.append("TIPO_SERVIZIO = ? ,");
            query.append("AZIONE = ? ,");
            query.append("PROFILO_DI_COLLABORAZIONE = ? ,");
            query.append("SERVIZIO_CORRELATO = ? ,");
            query.append("TIPO_SERVIZIO_CORRELATO = ? ,");
            query.append("COLLABORAZIONE = ? ,");
            query.append("SEQUENZA = ? ,");
            query.append("INOLTRO_SENZA_DUPLICATI = ? ,");
            query.append("CONFERMA_RICEZIONE = ? ,");
            query.append("ORA_REGISTRAZIONE = ? ,");
            query.append("TIPO_ORA_REGISTRAZIONE = ? ,");
            query.append("RIFERIMENTO_MESSAGGIO = ? ,");
            query.append("SCADENZA_BUSTA = ? ,");
            query.append("DATA_REGISTRAZIONE = ? ");
            if (saveServizioApplicativoFruitore) {
                query.append("SERVIZIO_APPLICATIVO = ? ");
            }
            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            pstmtBusta = connectionDB.prepareStatement(query.toString());
            int index = 1;
            pstmtBusta.setString(index++, busta.getMittente());
            pstmtBusta.setString(index++, busta.getIdentificativoPortaMittente());
            pstmtBusta.setString(index++, busta.getTipoMittente());
            pstmtBusta.setString(index++, busta.getIndirizzoMittente());
            pstmtBusta.setString(index++, busta.getDestinatario());
            pstmtBusta.setString(index++, busta.getIdentificativoPortaDestinatario());
            pstmtBusta.setString(index++, busta.getTipoDestinatario());
            pstmtBusta.setString(index++, busta.getIndirizzoDestinatario());
            pstmtBusta.setInt(index++, busta.getVersioneServizio());
            pstmtBusta.setString(index++, busta.getServizio());
            pstmtBusta.setString(index++, busta.getTipoServizio());
            pstmtBusta.setString(index++, busta.getAzione());
            pstmtBusta.setString(index++, busta.getProfiloDiCollaborazione() == null ? null : busta.getProfiloDiCollaborazione().getEngineValue());
            pstmtBusta.setString(index++, busta.getServizioCorrelato());
            pstmtBusta.setString(index++, busta.getTipoServizioCorrelato());
            pstmtBusta.setString(index++, busta.getCollaborazione());
            pstmtBusta.setLong(index++, busta.getSequenza());
            if (Inoltro.SENZA_DUPLICATI.equals((Object)busta.getInoltro())) {
                pstmtBusta.setInt(index++, 1);
            } else {
                pstmtBusta.setInt(index++, 0);
            }
            if (busta.isConfermaRicezione()) {
                pstmtBusta.setInt(index++, 1);
            } else {
                pstmtBusta.setInt(index++, 0);
            }
            Timestamp oraRec = null;
            TipoOraRegistrazione tipoOraRec = null;
            if (busta.getOraRegistrazione() != null && busta.getTipoOraRegistrazione() != null) {
                oraRec = new Timestamp(busta.getOraRegistrazione().getTime());
                tipoOraRec = busta.getTipoOraRegistrazione();
            }
            pstmtBusta.setTimestamp(index++, oraRec);
            pstmtBusta.setString(index++, tipoOraRec != null ? tipoOraRec.getEngineValue() : null);
            pstmtBusta.setString(index++, busta.getRiferimentoMessaggio());
            pstmtBusta.setTimestamp(index++, scadenzaT);
            pstmtBusta.setTimestamp(index++, dataRegistrazione);
            if (saveServizioApplicativoFruitore) {
                pstmtBusta.setString(index++, busta.getServizioApplicativoFruitore());
            }
            pstmtBusta.setString(index++, busta.getID());
            pstmtBusta.setString(index++, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE AggiornamentoBusta" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtBusta);
            if (errors != null) {
                String[] names;
                Eccezione eccezione;
                int i;
                StringBuilder queryDelete = new StringBuilder();
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_TRASMISSIONI");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmtDeleteListaRiscontri = connectionDB.prepareStatement(queryDelete.toString());
                index = 1;
                pstmtDeleteListaRiscontri.setString(index++, busta.getID());
                pstmtDeleteListaRiscontri.setString(index++, tipoBusta);
                stateMSG.getPreparedStatement().put("DELETE(UPDATE) AggiornamentoBusta_listaRiscontri" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtDeleteListaRiscontri);
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_RISCONTRI");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmtDeleteListaTrasmissioni = connectionDB.prepareStatement(queryDelete.toString());
                index = 1;
                pstmtDeleteListaTrasmissioni.setString(index++, busta.getID());
                pstmtDeleteListaTrasmissioni.setString(index++, tipoBusta);
                stateMSG.getPreparedStatement().put("DELETE(UPDATE) AggiornamentoBusta_listaTrasmissioni" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtDeleteListaTrasmissioni);
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_ECCEZIONI");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmtDeleteListaEccezioni = connectionDB.prepareStatement(queryDelete.toString());
                index = 1;
                pstmtDeleteListaEccezioni.setString(index++, busta.getID());
                pstmtDeleteListaEccezioni.setString(index++, tipoBusta);
                stateMSG.getPreparedStatement().put("DELETE(UPDATE) AggiornamentoBusta_listaEccezioni" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtDeleteListaEccezioni);
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_EXT_PROTOCOL_INFO");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmtDeleteListaExtInfo = connectionDB.prepareStatement(queryDelete.toString());
                index = 1;
                pstmtDeleteListaExtInfo.setString(index++, busta.getID());
                pstmtDeleteListaExtInfo.setString(index++, tipoBusta);
                stateMSG.getPreparedStatement().put("DELETE(UPDATE) AggiornamentoBusta_listaExtInfo" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtDeleteListaExtInfo);
                for (i = 0; i < busta.sizeListaRiscontri(); ++i) {
                    Riscontro riscontro = busta.getRiscontro(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_RISCONTRI");
                    query.append(" (ID_MESSAGGIO,TIPO,ID_RISCONTRO,RICEVUTA,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE,DATA_REGISTRAZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?)");
                    pstmtListaRiscontri = connectionDB.prepareStatement(query.toString());
                    index = 1;
                    pstmtListaRiscontri.setString(index++, busta.getID());
                    pstmtListaRiscontri.setString(index++, tipoBusta);
                    pstmtListaRiscontri.setString(index++, riscontro.getID());
                    pstmtListaRiscontri.setString(index++, riscontro.getRicevuta());
                    Timestamp oraRecRiscontro = null;
                    if (riscontro.getOraRegistrazione() != null) {
                        oraRecRiscontro = new Timestamp(riscontro.getOraRegistrazione().getTime());
                    }
                    pstmtListaRiscontri.setTimestamp(index++, oraRecRiscontro);
                    pstmtListaRiscontri.setString(index++, riscontro.getTipoOraRegistrazione().getEngineValue());
                    pstmtListaRiscontri.setTimestamp(index++, dataRegistrazione);
                    stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaRiscontri_riscontro[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaRiscontri);
                }
                for (i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                    Trasmissione trasmissione = busta.getTrasmissione(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_TRASMISSIONI");
                    query.append(" (ID_MESSAGGIO,TIPO,ORIGINE,TIPO_ORIGINE,DESTINAZIONE,TIPO_DESTINAZIONE,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE,DATA_REGISTRAZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?,?,?)");
                    pstmtListaTrasmissioni = connectionDB.prepareStatement(query.toString());
                    index = 1;
                    pstmtListaTrasmissioni.setString(index++, busta.getID());
                    pstmtListaTrasmissioni.setString(index++, tipoBusta);
                    pstmtListaTrasmissioni.setString(index++, trasmissione.getOrigine());
                    pstmtListaTrasmissioni.setString(index++, trasmissione.getTipoOrigine());
                    pstmtListaTrasmissioni.setString(index++, trasmissione.getDestinazione());
                    pstmtListaTrasmissioni.setString(index++, trasmissione.getTipoDestinazione());
                    Timestamp oraRecTrasmissione = null;
                    if (trasmissione.getOraRegistrazione() != null) {
                        oraRecTrasmissione = new Timestamp(trasmissione.getOraRegistrazione().getTime());
                    }
                    pstmtListaTrasmissioni.setTimestamp(index++, oraRecTrasmissione);
                    pstmtListaTrasmissioni.setString(index++, trasmissione.getTempo().getEngineValue());
                    pstmtListaTrasmissioni.setTimestamp(index++, dataRegistrazione);
                    stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaTrasmissioni_trasmissione[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaTrasmissioni);
                }
                for (i = 0; i < busta.sizeListaEccezioni(); ++i) {
                    eccezione = busta.getEccezione(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_ECCEZIONI");
                    query.append(" (ID_MESSAGGIO,TIPO,VALIDAZIONE,CONTESTO,CODICE,RILEVANZA,POSIZIONE,DATA_REGISTRAZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?,?)");
                    pstmtListaEccezioni = connectionDB.prepareStatement(query.toString());
                    index = 1;
                    pstmtListaEccezioni.setString(index++, busta.getID());
                    pstmtListaEccezioni.setString(index++, tipoBusta);
                    pstmtListaEccezioni.setInt(index++, 0);
                    pstmtListaEccezioni.setString(index++, eccezione.getContestoCodifica().getEngineValue());
                    pstmtListaEccezioni.setInt(index++, eccezione.getCodiceEccezione().getCodice());
                    pstmtListaEccezioni.setString(index++, eccezione.getRilevanza().getEngineValue());
                    pstmtListaEccezioni.setString(index++, eccezione.getDescrizione(this.protocolFactory));
                    pstmtListaEccezioni.setTimestamp(index++, dataRegistrazione);
                    stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaEccezioni_eccezioneBusta[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaEccezioni);
                }
                for (i = 0; i < errors.size(); ++i) {
                    eccezione = errors.get(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_ECCEZIONI");
                    query.append(" (ID_MESSAGGIO,TIPO,VALIDAZIONE,CONTESTO,CODICE,RILEVANZA,POSIZIONE,DATA_REGISTRAZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?,?)");
                    pstmtListaEccezioniValidazione = connectionDB.prepareStatement(query.toString());
                    index = 1;
                    pstmtListaEccezioniValidazione.setString(index++, busta.getID());
                    pstmtListaEccezioniValidazione.setString(index++, tipoBusta);
                    pstmtListaEccezioniValidazione.setInt(index++, 1);
                    pstmtListaEccezioniValidazione.setString(index++, eccezione.getContestoCodifica().getEngineValue());
                    pstmtListaEccezioniValidazione.setInt(index++, eccezione.getCodiceEccezione().getCodice());
                    pstmtListaEccezioniValidazione.setString(index++, eccezione.getRilevanza().getEngineValue());
                    pstmtListaEccezioniValidazione.setString(index++, eccezione.getDescrizione(this.protocolFactory));
                    pstmtListaEccezioniValidazione.setTimestamp(index++, dataRegistrazione);
                    stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaEccezioni_eccezioneValidazione[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaEccezioniValidazione);
                }
                if (busta.sizeProperties() > 0 && (names = busta.getPropertiesNames()) != null && names.length > 0) {
                    for (int i2 = 0; i2 < names.length; ++i2) {
                        String name = names[i2];
                        String value = busta.getProperty(name);
                        query.delete(0, query.length());
                        query.append("INSERT INTO  ");
                        query.append("LISTA_EXT_PROTOCOL_INFO");
                        query.append(" (ID_MESSAGGIO,TIPO,NOME,VALORE,DATA_REGISTRAZIONE)");
                        query.append(" VALUES (?,?,?,?,?)");
                        pstmtListaExtInfo = connectionDB.prepareStatement(query.toString());
                        index = 1;
                        pstmtListaExtInfo.setString(index++, busta.getID());
                        pstmtListaExtInfo.setString(index++, tipoBusta);
                        pstmtListaExtInfo.setString(index++, name);
                        pstmtListaExtInfo.setString(index++, value);
                        pstmtListaExtInfo.setTimestamp(index++, dataRegistrazione);
                        stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaExtInfoProtocol_info[" + i2 + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaExtInfo);
                    }
                }
            }
        }
        catch (Exception e) {
            String id = busta.getID();
            String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmtBusta != null) {
                    pstmtBusta.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtDeleteListaRiscontri != null) {
                    pstmtDeleteListaRiscontri.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtDeleteListaTrasmissioni != null) {
                    pstmtDeleteListaTrasmissioni.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtDeleteListaEccezioni != null) {
                    pstmtDeleteListaEccezioni.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtDeleteListaExtInfo != null) {
                    pstmtDeleteListaExtInfo.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtListaRiscontri != null) {
                    pstmtListaRiscontri.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtListaTrasmissioni != null) {
                    pstmtListaTrasmissioni.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtListaEccezioni != null) {
                    pstmtListaEccezioni.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtListaEccezioniValidazione != null) {
                    pstmtListaEccezioniValidazione.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmtListaExtInfo != null) {
                    pstmtListaExtInfo.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        if (stateMSG instanceof StatelessMessage) {
            ((StatelessMessage)this.state).setBusta(busta);
        }
    }

    private void aggiornaDuplicati(String id, String tipoBusta) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmt = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append("REPOSITORY_BUSTE");
            query.append(" SET DUPLICATI=(DUPLICATI+1) WHERE  ID_MESSAGGIO = ? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE aggiornaDuplicati " + tipoBusta + "_" + id, (PreparedStatement)pstmt);
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento informazioni pacchetti duplicati " + tipoBusta + "/" + id + ": " + e.getMessage();
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.error(errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public void aggiornaInfoIntegrazione(String id, String tipoBusta, Integrazione infoIntegrazione) throws ProtocolException {
        boolean registrazioneInfoIntegrazione = false;
        if (this.state instanceof StatefulMessage) {
            registrazioneInfoIntegrazione = true;
        } else if (this.isRichiesta && "OUTBOX".equals(tipoBusta)) {
            StatelessMessage stateless = (StatelessMessage)this.state;
            Busta busta = stateless.getBusta();
            if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY.equals((Object)busta.getProfiloDiCollaborazione()) && busta.isConfermaRicezione()) {
                registrazioneInfoIntegrazione = true;
            } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione()) && busta.getRiferimentoMessaggio() == null) {
                registrazioneInfoIntegrazione = true;
            }
        }
        if (registrazioneInfoIntegrazione) {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            Statement pstmt = null;
            try {
                StringBuilder query = new StringBuilder();
                query.append("UPDATE ");
                query.append("REPOSITORY_BUSTE");
                query.append(" SET LOCATION_PD=? , SERVIZIO_APPLICATIVO=? , MODULO_IN_ATTESA=? , SCENARIO=? WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, infoIntegrazione.getNomePorta());
                pstmt.setString(2, infoIntegrazione.getServizioApplicativo());
                pstmt.setString(3, infoIntegrazione.getIdModuloInAttesa());
                pstmt.setString(4, infoIntegrazione.getScenario());
                pstmt.setString(5, id);
                pstmt.setString(6, tipoBusta);
                stateMSG.getPreparedStatement().put("UPDATE aggiornaInformazioniIntegrazione " + tipoBusta + "_" + id, (PreparedStatement)pstmt);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento informazioni di Integrazione " + tipoBusta + "/" + id + ": " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
    }

    private void aggiornaInfoIntegrazione_ServizioApplicativo(String id, String tipoBusta, String servizioApplicativo) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            try {
                StringBuilder query = new StringBuilder();
                query.append("UPDATE ");
                query.append("REPOSITORY_BUSTE");
                query.append(" SET SERVIZIO_APPLICATIVO=? WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, servizioApplicativo);
                pstmt.setString(2, id);
                pstmt.setString(3, tipoBusta);
                stateful.getPreparedStatement().put("UPDATE aggiornaInformazioniIntegrazione_ServizioApplicativo_" + tipoBusta + "_" + id, (PreparedStatement)pstmt);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento informazioni di Integrazione " + tipoBusta + "/" + id + " (ServizioApplicativo): " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
    }

    private void aggiornaInfoIntegrazione_Scenario(String id, String tipoBusta, String scenario) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            try {
                StringBuilder query = new StringBuilder();
                query.append("UPDATE ");
                query.append("REPOSITORY_BUSTE");
                query.append(" SET SCENARIO=? WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, scenario);
                pstmt.setString(2, id);
                pstmt.setString(3, tipoBusta);
                stateful.getPreparedStatement().put("UPDATE aggiornaInformazioniIntegrazione_Scenario_" + tipoBusta + "_" + id, (PreparedStatement)pstmt);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento informazioni di Integrazione " + tipoBusta + "/" + id + " (Scenario): " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
    }

    private void aggiornaCollaborazione(String id, String tipoBusta, String collaborazione) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmtBusta = null;
            try {
                StringBuilder query = new StringBuilder();
                query.append("UPDATE  ");
                query.append("REPOSITORY_BUSTE");
                query.append(" SET ");
                query.append("COLLABORAZIONE = ?");
                query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
                pstmtBusta = connectionDB.prepareStatement(query.toString());
                pstmtBusta.setString(1, collaborazione);
                pstmtBusta.setString(2, id);
                pstmtBusta.setString(3, tipoBusta);
                stateful.getPreparedStatement().put("UPDATE AggiornamentoCollaborazione" + tipoBusta + "_" + id, (PreparedStatement)pstmtBusta);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento collaborazione " + tipoBusta + "/" + id + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                try {
                    if (pstmtBusta != null) {
                        pstmtBusta.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        statelessMsg.getBusta().setCollaborazione(collaborazione);
    }

    private void aggiornaSequenza(String id, String tipoBusta, long sequenza) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmtBusta = null;
            try {
                StringBuilder query = new StringBuilder();
                query.append("UPDATE  ");
                query.append("REPOSITORY_BUSTE");
                query.append(" SET ");
                query.append("SEQUENZA = ?");
                query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
                pstmtBusta = connectionDB.prepareStatement(query.toString());
                pstmtBusta.setLong(1, sequenza);
                pstmtBusta.setString(2, id);
                pstmtBusta.setString(3, tipoBusta);
                stateful.getPreparedStatement().put("UPDATE AggiornamentoSequenza" + tipoBusta + "_" + id, (PreparedStatement)pstmtBusta);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento sequenza " + tipoBusta + "/" + id + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                try {
                    if (pstmtBusta != null) {
                        pstmtBusta.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        statelessMsg.getBusta().setSequenza(sequenza);
    }

    public boolean isRegistrata(String id, String tipoBusta) throws ProtocolException {
        Connection connectionDB = ((StateMessage)this.state).getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("select ID_MESSAGGIO from ");
            query.append("REPOSITORY_BUSTE");
            query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, tipoBusta);
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new ProtocolException("RS Null?");
            }
            boolean value = rs.next();
            rs.close();
            pstmt.close();
            return value;
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore durante isRegistrata " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    private Busta getBusta(String id, String tipoBusta) throws ProtocolException {
        return this.getBusta(id, tipoBusta, false);
    }

    private Busta getBusta(String id, String tipoBusta, boolean readServizioApplicativoFruitore) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                StringBuilder query = new StringBuilder();
                query.append("select * from ");
                query.append("REPOSITORY_BUSTE");
                query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                if (!rs.next()) {
                    throw new ProtocolException("Busta non trovata");
                }
                Busta busta = new Busta(rs.getString("PROTOCOLLO"));
                if (this.protocolFactory == null) {
                    if (busta.getProtocollo() != null) {
                        this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(busta.getProtocollo());
                    } else {
                        throw new ProtocolException("Protocol unknown");
                    }
                }
                busta.setID(rs.getString("ID_MESSAGGIO"));
                busta.setTipoMittente(rs.getString("TIPO_MITTENTE"));
                busta.setMittente(rs.getString("MITTENTE"));
                busta.setIdentificativoPortaMittente(rs.getString("IDPORTA_MITTENTE"));
                busta.setIndirizzoMittente(rs.getString("IND_TELEMATICO_MITT"));
                busta.setTipoDestinatario(rs.getString("TIPO_DESTINATARIO"));
                busta.setDestinatario(rs.getString("DESTINATARIO"));
                busta.setIdentificativoPortaDestinatario(rs.getString("IDPORTA_DESTINATARIO"));
                busta.setIndirizzoDestinatario(rs.getString("IND_TELEMATICO_DEST"));
                busta.setVersioneServizio(Integer.valueOf(rs.getInt("VERSIONE_SERVIZIO")));
                busta.setServizio(rs.getString("SERVIZIO"));
                busta.setTipoServizio(rs.getString("TIPO_SERVIZIO"));
                busta.setAzione(rs.getString("AZIONE"));
                String profiloCollaborazione = rs.getString("PROFILO_DI_COLLABORAZIONE");
                if (profiloCollaborazione != null) {
                    busta.setProfiloDiCollaborazione(org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.toProfiloDiCollaborazione((String)profiloCollaborazione));
                }
                busta.setServizioCorrelato(rs.getString("SERVIZIO_CORRELATO"));
                busta.setTipoServizioCorrelato(rs.getString("TIPO_SERVIZIO_CORRELATO"));
                busta.setCollaborazione(rs.getString("COLLABORAZIONE"));
                busta.setSequenza(rs.getLong("SEQUENZA"));
                if (rs.getInt("INOLTRO_SENZA_DUPLICATI") != 0) {
                    busta.setInoltro(Inoltro.SENZA_DUPLICATI, this.protocolFactory.createTraduttore().toString(Inoltro.SENZA_DUPLICATI));
                } else {
                    busta.setInoltro(Inoltro.CON_DUPLICATI, this.protocolFactory.createTraduttore().toString(Inoltro.CON_DUPLICATI));
                }
                if (rs.getInt("CONFERMA_RICEZIONE") != 0) {
                    busta.setConfermaRicezione(true);
                } else {
                    busta.setConfermaRicezione(false);
                }
                busta.setOraRegistrazione((Date)rs.getTimestamp("ORA_REGISTRAZIONE"));
                TipoOraRegistrazione tipoOraRegistrazione = TipoOraRegistrazione.toTipoOraRegistrazione((String)rs.getString("TIPO_ORA_REGISTRAZIONE"));
                busta.setTipoOraRegistrazione(tipoOraRegistrazione, this.protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
                busta.setRiferimentoMessaggio(rs.getString("RIFERIMENTO_MESSAGGIO"));
                busta.setScadenza((Date)rs.getTimestamp("SCADENZA_BUSTA"));
                if (readServizioApplicativoFruitore) {
                    busta.setServizioApplicativoFruitore(rs.getString("SERVIZIO_APPLICATIVO"));
                }
                rs.close();
                pstmt.close();
                query.delete(0, query.length());
                query.append("select * from ");
                query.append("LISTA_TRASMISSIONI");
                query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                while (rs.next()) {
                    Trasmissione trasmissione = new Trasmissione();
                    trasmissione.setOrigine(rs.getString("ORIGINE"));
                    trasmissione.setTipoOrigine(rs.getString("TIPO_ORIGINE"));
                    trasmissione.setDestinazione(rs.getString("DESTINAZIONE"));
                    trasmissione.setTipoDestinazione(rs.getString("TIPO_DESTINAZIONE"));
                    trasmissione.setOraRegistrazione((Date)rs.getTimestamp("ORA_REGISTRAZIONE"));
                    trasmissione.setTempo(TipoOraRegistrazione.toTipoOraRegistrazione((String)rs.getString("TIPO_ORA_REGISTRAZIONE")));
                    busta.addTrasmissione(trasmissione);
                }
                rs.close();
                pstmt.close();
                query.delete(0, query.length());
                query.append("select * from ");
                query.append("LISTA_RISCONTRI");
                query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                while (rs.next()) {
                    Riscontro riscontro = new Riscontro();
                    riscontro.setID(rs.getString("ID_RISCONTRO"));
                    riscontro.setRicevuta(rs.getString("RICEVUTA"));
                    riscontro.setOraRegistrazione((Date)rs.getTimestamp("ORA_REGISTRAZIONE"));
                    riscontro.setTipoOraRegistrazione(TipoOraRegistrazione.toTipoOraRegistrazione((String)rs.getString("TIPO_ORA_REGISTRAZIONE")));
                    busta.addRiscontro(riscontro);
                }
                rs.close();
                pstmt.close();
                query.delete(0, query.length());
                query.append("select * from ");
                query.append("LISTA_ECCEZIONI");
                query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ? AND VALIDAZIONE=0");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                while (rs.next()) {
                    Eccezione eccezione = Eccezione.newEccezione();
                    eccezione.setContestoCodifica(ContestoCodificaEccezione.toContestoCodificaEccezione((String)rs.getString("CONTESTO")));
                    eccezione.setCodiceEccezione(CodiceErroreCooperazione.toCodiceErroreCooperazione((int)rs.getInt("CODICE")));
                    eccezione.setRilevanza(LivelloRilevanza.toLivelloRilevanza((String)rs.getString("RILEVANZA")));
                    eccezione.setDescrizione(rs.getString("POSIZIONE"));
                    busta.addEccezione(eccezione);
                }
                rs.close();
                pstmt.close();
                query.delete(0, query.length());
                query.append("select * from ");
                query.append("LISTA_EXT_PROTOCOL_INFO");
                query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                while (rs.next()) {
                    busta.addProperty(rs.getString("NOME"), rs.getString("VALORE"));
                }
                rs.close();
                pstmt.close();
                return busta;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore durante la getBusta " + tipoBusta + "/" + id + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        return statelessMsg.getBusta();
    }

    private List<Eccezione> getErrors(String id, String tipoBusta) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<Eccezione> errors = new ArrayList<Eccezione>();
            try {
                StringBuilder query = new StringBuilder();
                query.append("select * from ");
                query.append("LISTA_ECCEZIONI");
                query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ? AND VALIDAZIONE=1");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                while (rs.next()) {
                    Eccezione eccezione = Eccezione.newEccezione();
                    eccezione.setContestoCodifica(ContestoCodificaEccezione.toContestoCodificaEccezione((String)rs.getString("CONTESTO")));
                    eccezione.setCodiceEccezione(CodiceErroreCooperazione.toCodiceErroreCooperazione((int)rs.getInt("CODICE")));
                    eccezione.setRilevanza(LivelloRilevanza.toLivelloRilevanza((String)rs.getString("RILEVANZA")));
                    eccezione.setDescrizione(rs.getString("POSIZIONE"));
                    errors.add(eccezione);
                }
                rs.close();
                pstmt.close();
                return errors;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore durante la getErrors " + tipoBusta + "/" + id + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        return null;
    }

    private Busta getSomeValues(String id, String tipoBusta, LetturaParametriBusta parametri, boolean forzaLetturaSuDatabase, Date dataRegistrazione) throws ProtocolException {
        int i;
        if (this.state instanceof StatefulMessage || forzaLetturaSuDatabase) {
            StateMessage state = (StateMessage)this.state;
            Connection connectionDB = state.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            String protocollo = null;
            if (this.protocolFactory != null) {
                protocollo = this.protocolFactory.getProtocol();
            }
            Busta busta = new Busta(protocollo);
            try {
                StringBuilder bf = new StringBuilder();
                bf.append("SELECT ");
                bf.append("PROTOCOLLO");
                boolean first = false;
                if (parametri.isMittente()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("MITTENTE,TIPO_MITTENTE,IDPORTA_MITTENTE");
                    first = false;
                }
                if (parametri.isDestinatario()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("DESTINATARIO,TIPO_DESTINATARIO,IDPORTA_DESTINATARIO");
                }
                if (parametri.isIndirizziTelematici()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("IND_TELEMATICO_MITT,IND_TELEMATICO_DEST");
                }
                if (parametri.isServizio()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("SERVIZIO,TIPO_SERVIZIO,VERSIONE_SERVIZIO");
                }
                if (parametri.isAzione()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("AZIONE");
                }
                if (parametri.isProfiloDiCollaborazione()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("PROFILO_DI_COLLABORAZIONE");
                }
                if (parametri.isServizioCorrelato()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("SERVIZIO_CORRELATO,TIPO_SERVIZIO_CORRELATO");
                }
                if (parametri.isCollaborazione()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("COLLABORAZIONE");
                }
                if (parametri.isSequenza()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("SEQUENZA");
                }
                if (parametri.isProfiloTrasmissione()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("INOLTRO_SENZA_DUPLICATI,CONFERMA_RICEZIONE");
                }
                if (parametri.isOraRegistrazione()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE");
                }
                if (parametri.isRiferimentoMessaggio()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("RIFERIMENTO_MESSAGGIO");
                }
                if (parametri.isScadenza()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("SCADENZA_BUSTA");
                }
                bf.append(" FROM ");
                bf.append("REPOSITORY_BUSTE");
                bf.append(" WHERE ");
                if (dataRegistrazione != null) {
                    bf.append("(DATA_REGISTRAZIONE BETWEEN ? AND ?) AND ");
                }
                bf.append("ID_MESSAGGIO=? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(bf.toString());
                int index = 1;
                Timestamp leftValue = null;
                Timestamp rightValue = null;
                if (dataRegistrazione != null) {
                    leftValue = new Timestamp(dataRegistrazione.getTime() - 300000L);
                    rightValue = new Timestamp(dataRegistrazione.getTime() + 300000L);
                    pstmt.setTimestamp(index++, leftValue);
                    pstmt.setTimestamp(index++, rightValue);
                }
                pstmt.setString(index++, id);
                pstmt.setString(index++, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                if (rs.next()) {
                    String protocolloRead = rs.getString("PROTOCOLLO");
                    if (busta.getProtocollo() == null) {
                        busta.setProtocollo(protocolloRead);
                    }
                    if (this.protocolFactory == null) {
                        this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocolloRead);
                    }
                    if (parametri.isMittente()) {
                        busta.setTipoMittente(rs.getString("TIPO_MITTENTE"));
                        busta.setMittente(rs.getString("MITTENTE"));
                        busta.setIdentificativoPortaMittente(rs.getString("IDPORTA_MITTENTE"));
                    }
                    if (parametri.isDestinatario()) {
                        busta.setTipoDestinatario(rs.getString("TIPO_DESTINATARIO"));
                        busta.setDestinatario(rs.getString("DESTINATARIO"));
                        busta.setIdentificativoPortaDestinatario(rs.getString("IDPORTA_DESTINATARIO"));
                    }
                    if (parametri.isIndirizziTelematici()) {
                        busta.setIndirizzoMittente(rs.getString("IND_TELEMATICO_MITT"));
                        busta.setIndirizzoDestinatario(rs.getString("IND_TELEMATICO_DEST"));
                    }
                    if (parametri.isServizio()) {
                        busta.setTipoServizio(rs.getString("TIPO_SERVIZIO"));
                        busta.setServizio(rs.getString("SERVIZIO"));
                        busta.setVersioneServizio(Integer.valueOf(rs.getInt("VERSIONE_SERVIZIO")));
                    }
                    if (parametri.isAzione()) {
                        busta.setAzione(rs.getString("AZIONE"));
                    }
                    if (parametri.isProfiloDiCollaborazione()) {
                        busta.setProfiloDiCollaborazione(org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.toProfiloDiCollaborazione((String)rs.getString("PROFILO_DI_COLLABORAZIONE")));
                    }
                    if (parametri.isServizioCorrelato()) {
                        busta.setTipoServizioCorrelato(rs.getString("TIPO_SERVIZIO_CORRELATO"));
                        busta.setServizioCorrelato(rs.getString("SERVIZIO_CORRELATO"));
                    }
                    if (parametri.isCollaborazione()) {
                        busta.setCollaborazione(rs.getString("COLLABORAZIONE"));
                    }
                    if (parametri.isSequenza()) {
                        busta.setSequenza(rs.getLong("SEQUENZA"));
                    }
                    if (parametri.isProfiloTrasmissione()) {
                        if (rs.getInt("INOLTRO_SENZA_DUPLICATI") != 0) {
                            busta.setInoltro(Inoltro.SENZA_DUPLICATI, this.protocolFactory.createTraduttore().toString(Inoltro.SENZA_DUPLICATI));
                        } else {
                            busta.setInoltro(Inoltro.CON_DUPLICATI, this.protocolFactory.createTraduttore().toString(Inoltro.CON_DUPLICATI));
                        }
                        if (rs.getInt("CONFERMA_RICEZIONE") != 0) {
                            busta.setConfermaRicezione(true);
                        } else {
                            busta.setConfermaRicezione(false);
                        }
                    }
                    if (parametri.isOraRegistrazione()) {
                        busta.setOraRegistrazione((Date)rs.getTimestamp("ORA_REGISTRAZIONE"));
                        TipoOraRegistrazione tipoOraRegistrazione = TipoOraRegistrazione.toTipoOraRegistrazione((String)rs.getString("TIPO_ORA_REGISTRAZIONE"));
                        busta.setTipoOraRegistrazione(tipoOraRegistrazione, this.protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
                    }
                    if (parametri.isRiferimentoMessaggio()) {
                        busta.setRiferimentoMessaggio(rs.getString("RIFERIMENTO_MESSAGGIO"));
                    }
                    if (parametri.isScadenza()) {
                        busta.setScadenza((Date)rs.getTimestamp("SCADENZA_BUSTA"));
                    }
                } else {
                    throw new ProtocolException("Busta non trovata");
                }
                rs.close();
                pstmt.close();
                return busta;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore  getSomeValues " + tipoBusta + "/" + id + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        Busta busta = statelessMsg.getBusta().newInstance();
        if (!parametri.isMittente()) {
            busta.setTipoMittente(null);
            busta.setMittente(null);
        }
        if (!parametri.isDestinatario()) {
            busta.setTipoDestinatario(null);
            busta.setDestinatario(null);
        }
        if (!parametri.isIndirizziTelematici()) {
            busta.setIndirizzoMittente(null);
            busta.setIndirizzoDestinatario(null);
        }
        if (!parametri.isServizio()) {
            busta.setTipoServizio(null);
            busta.setServizio(null);
        }
        if (!parametri.isAzione()) {
            busta.setAzione(null);
        }
        if (!parametri.isProfiloDiCollaborazione()) {
            busta.setProfiloDiCollaborazione(null);
        }
        if (!parametri.isServizioCorrelato()) {
            busta.setTipoServizioCorrelato(null);
            busta.setServizioCorrelato(null);
        }
        if (!parametri.isCollaborazione()) {
            busta.setCollaborazione(null);
        }
        if (!parametri.isSequenza()) {
            busta.setSequenza(-1L);
        }
        if (!parametri.isProfiloTrasmissione()) {
            busta.setInoltro(null, null);
            busta.setConfermaRicezione(false);
        }
        if (!parametri.isOraRegistrazione()) {
            busta.setOraRegistrazione(null);
            busta.setTipoOraRegistrazione(null, null);
        }
        if (!parametri.isRiferimentoMessaggio()) {
            busta.setRiferimentoMessaggio(null);
        }
        if (!parametri.isScadenza()) {
            busta.setScadenza(null);
        }
        for (i = 0; i < busta.sizeListaEccezioni(); ++i) {
            busta.removeEccezione(i);
        }
        for (i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
            busta.removeTrasmissione(i);
        }
        for (i = 0; i < busta.sizeListaRiscontri(); ++i) {
            busta.removeRiscontro(i);
        }
        if (busta.sizeProperties() > 0) {
            String[] pNames = busta.getPropertiesNames();
            for (int i2 = 0; i2 < pNames.length; ++i2) {
                busta.removeProperty(pNames[i2]);
            }
        }
        return busta;
    }

    private String getCollaborazione(String id, String tipoBusta) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT COLLABORAZIONE FROM REPOSITORY_BUSTE WHERE ID_MESSAGGIO=? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                String collaborazione = null;
                if (rs.next()) {
                    collaborazione = rs.getString("COLLABORAZIONE");
                }
                rs.close();
                pstmt.close();
                return collaborazione;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore  getCollaborazione " + tipoBusta + "/" + id + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        Busta busta = statelessMsg.getBusta();
        return busta.getCollaborazione();
    }

    private org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione getProfiloCollaborazione(String id, String tipoBusta) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT PROFILO_DI_COLLABORAZIONE FROM REPOSITORY_BUSTE WHERE ID_MESSAGGIO=? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione profiloCollaborazione = null;
                if (rs.next()) {
                    profiloCollaborazione = org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.toProfiloDiCollaborazione((String)rs.getString("PROFILO_DI_COLLABORAZIONE"));
                }
                rs.close();
                pstmt.close();
                return profiloCollaborazione;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore  getProfiloCollaborazione " + tipoBusta + "/" + id + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        Busta busta = statelessMsg.getBusta();
        return busta.getProfiloDiCollaborazione();
    }

    private String getProfiloCollaborazioneValue(String id, String tipoBusta) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            return null;
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        Busta busta = statelessMsg.getBusta();
        return busta.getProfiloDiCollaborazioneValue();
    }

    private long getSequenza(String id, String tipoBusta) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT SEQUENZA FROM REPOSITORY_BUSTE WHERE ID_MESSAGGIO=? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                long sequenza = -1L;
                if (rs.next()) {
                    sequenza = rs.getLong("SEQUENZA");
                }
                rs.close();
                pstmt.close();
                return sequenza;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore  getSequenza " + tipoBusta + "/" + id + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.error(errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        Busta busta = statelessMsg.getBusta();
        return busta.getSequenza();
    }

    private Integrazione getInfoIntegrazione(String id, String tipoBusta) throws ProtocolException {
        StateMessage stateful = (StateMessage)this.state;
        Connection connectionDB = stateful.getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = "SELECT LOCATION_PD,SERVIZIO_APPLICATIVO,MODULO_IN_ATTESA,SCENARIO FROM REPOSITORY_BUSTE WHERE ID_MESSAGGIO=? AND TIPO=?";
            pstmt = connectionDB.prepareStatement(query);
            pstmt.setString(1, id);
            pstmt.setString(2, tipoBusta);
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new ProtocolException("RS Null?");
            }
            Integrazione infoIntegrazione = new Integrazione();
            if (rs.next()) {
                infoIntegrazione.setIdModuloInAttesa(rs.getString("MODULO_IN_ATTESA"));
                infoIntegrazione.setNomePorta(rs.getString("LOCATION_PD"));
                infoIntegrazione.setScenario(rs.getString("SCENARIO"));
                infoIntegrazione.setServizioApplicativo(rs.getString("SERVIZIO_APPLICATIVO"));
            }
            rs.close();
            pstmt.close();
            return infoIntegrazione;
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore  getInfoIntegrazione " + tipoBusta + "/" + id + ": " + e.getMessage();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.error(errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    private void eliminaUtilizzoPdD(String id, String tipoBusta, boolean forzaEliminazioneDB, Date dataRegistrazione) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, tipoBusta, forzaEliminazioneDB, true, dataRegistrazione);
    }

    private void eliminaUtilizzoPdD(String id, String tipoBusta, boolean forzaEliminazioneDB, boolean savePreparedStatement, Date dataRegistrazione) throws ProtocolException {
        if (this.state instanceof StatefulMessage || forzaEliminazioneDB) {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            Statement pstmtUpdate = null;
            try {
                StringBuilder queryUpdate = new StringBuilder();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_BUSTE");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_PdD(false));
                queryUpdate.append(" WHERE ");
                if (dataRegistrazione != null) {
                    queryUpdate.append("(DATA_REGISTRAZIONE BETWEEN ? AND ?) AND ");
                }
                queryUpdate.append("ID_MESSAGGIO = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                int index = 1;
                Timestamp leftValue = null;
                Timestamp rightValue = null;
                if (dataRegistrazione != null) {
                    leftValue = new Timestamp(dataRegistrazione.getTime() - 300000L);
                    rightValue = new Timestamp(dataRegistrazione.getTime() + 300000L);
                    pstmtUpdate.setTimestamp(index++, leftValue);
                    pstmtUpdate.setTimestamp(index++, rightValue);
                }
                pstmtUpdate.setString(index++, id);
                pstmtUpdate.setString(index++, tipoBusta);
                if (savePreparedStatement) {
                    stateMSG.getPreparedStatement().put("UPDATE AggiornamentoBusta" + tipoBusta + "_" + id, (PreparedStatement)pstmtUpdate);
                } else {
                    pstmtUpdate.executeUpdate();
                }
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore di cancellazione utilizzo from PdD " + tipoBusta + "/" + id + ": " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdate != null) {
                        pstmtUpdate.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
    }

    private void eliminaBustaStateless(String id, String tipoBusta, Date dataRegistrazione) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtUpdate = null;
        try {
            StringBuilder queryUpdate = new StringBuilder();
            queryUpdate.append("UPDATE ");
            queryUpdate.append("REPOSITORY_BUSTE");
            queryUpdate.append(" SET ");
            queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_PdD(false));
            queryUpdate.append(" WHERE ");
            if (dataRegistrazione != null) {
                queryUpdate.append("(DATA_REGISTRAZIONE BETWEEN ? AND ?) AND ");
            }
            queryUpdate.append("ID_MESSAGGIO = ? AND TIPO=?");
            pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
            int index = 1;
            Timestamp leftValue = null;
            Timestamp rightValue = null;
            if (dataRegistrazione != null) {
                leftValue = new Timestamp(dataRegistrazione.getTime() - 300000L);
                rightValue = new Timestamp(dataRegistrazione.getTime() + 300000L);
                pstmtUpdate.setTimestamp(index++, leftValue);
                pstmtUpdate.setTimestamp(index++, rightValue);
            }
            pstmtUpdate.setString(index++, id);
            pstmtUpdate.setString(index++, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE AggiornamentoBusta" + tipoBusta + "_" + id, (PreparedStatement)pstmtUpdate);
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore di cancellazione utilizzo from PdD " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    private void eliminaBusta(String id, String tipoBusta, Date data) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmtDelete = null;
        try {
            StringBuilder queryDelete;
            ProfiloDiCollaborazione profilo;
            if ("OUTBOX".equals(tipoBusta)) {
                if (this.state instanceof StatefulMessage) {
                    Riscontri riscontri = new Riscontri((IState)state, this.log);
                    riscontri.validazioneRiscontroRicevuto(id);
                    state.executePreparedStatement();
                }
                profilo = new ProfiloDiCollaborazione((IState)state, this.log, this.protocolFactory);
                profilo.asincrono_eliminaRegistrazione(id, "OUTBOX", data);
                state.executePreparedStatement();
            } else if ("INBOX".equals(tipoBusta)) {
                profilo = new ProfiloDiCollaborazione((IState)state, this.log, this.protocolFactory);
                profilo.asincrono_eliminaRegistrazione(id, "INBOX", data);
                state.executePreparedStatement();
            }
            Timestamp nowT = null;
            if (data != null) {
                nowT = new Timestamp(data.getTime());
            }
            if (this.state instanceof StatefulMessage) {
                queryDelete = new StringBuilder();
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_TRASMISSIONI");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                if (data != null) {
                    queryDelete.append(" AND DATA_REGISTRAZIONE<=?");
                }
                pstmtDelete = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDelete.setString(1, id);
                pstmtDelete.setString(2, tipoBusta);
                if (data != null) {
                    pstmtDelete.setTimestamp(3, nowT);
                }
                pstmtDelete.execute();
                pstmtDelete.close();
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_RISCONTRI");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                if (data != null) {
                    queryDelete.append(" AND DATA_REGISTRAZIONE<=?");
                }
                pstmtDelete = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDelete.setString(1, id);
                pstmtDelete.setString(2, tipoBusta);
                if (data != null) {
                    pstmtDelete.setTimestamp(3, nowT);
                }
                pstmtDelete.execute();
                pstmtDelete.close();
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_ECCEZIONI");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                if (data != null) {
                    queryDelete.append(" AND DATA_REGISTRAZIONE<=?");
                }
                pstmtDelete = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDelete.setString(1, id);
                pstmtDelete.setString(2, tipoBusta);
                if (data != null) {
                    pstmtDelete.setTimestamp(3, nowT);
                }
                pstmtDelete.execute();
                pstmtDelete.close();
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_EXT_PROTOCOL_INFO");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                if (data != null) {
                    queryDelete.append(" AND DATA_REGISTRAZIONE<=?");
                }
                pstmtDelete = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDelete.setString(1, id);
                pstmtDelete.setString(2, tipoBusta);
                if (data != null) {
                    pstmtDelete.setTimestamp(3, nowT);
                }
                pstmtDelete.execute();
                pstmtDelete.close();
            }
            queryDelete = new StringBuilder();
            queryDelete.append("DELETE FROM ");
            queryDelete.append("REPOSITORY_BUSTE");
            queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
            if (data != null) {
                queryDelete.append(" AND DATA_REGISTRAZIONE<=?");
            }
            pstmtDelete = connectionDB.prepareStatement(queryDelete.toString());
            pstmtDelete.setString(1, id);
            pstmtDelete.setString(2, tipoBusta);
            if (data != null) {
                pstmtDelete.setTimestamp(3, nowT);
            }
            pstmtDelete.execute();
            pstmtDelete.close();
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore di cancellazione from REPOSITORY_BUSTE " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmtDelete != null) {
                    pstmtDelete.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public static Date getDataRegistrazioneBustaMassima(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger) throws ProtocolException {
        return RepositoryBuste._getDataRegistrazioneBusta(false, connectionDB, tipoDatabase, logQuery, logger);
    }

    public static Date getDataRegistrazioneBustaMinima(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger) throws ProtocolException {
        return RepositoryBuste._getDataRegistrazioneBusta(true, connectionDB, tipoDatabase, logQuery, logger);
    }

    private static Date _getDataRegistrazioneBusta(boolean min, Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger) throws ProtocolException {
        Statement pstmt = null;
        ResultSet rs = null;
        String queryString = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            if (min) {
                sqlQueryObject.addSelectMinField("DATA_REGISTRAZIONE", "check_data");
            } else {
                sqlQueryObject.addSelectMaxField("DATA_REGISTRAZIONE", "check_data");
            }
            sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            if (logQuery) {
                logger.debug("Esecuzione query [" + queryString + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") ...");
            }
            pstmt = connectionDB.prepareStatement(queryString);
            rs = pstmt.executeQuery();
            if (logQuery) {
                logger.debug("Esecuzione query [" + queryString + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") completata");
            }
            if (rs.next()) {
                Timestamp timestamp = rs.getTimestamp("check_data");
                return timestamp;
            }
            Date date = null;
            return date;
        }
        catch (Exception e) {
            String errorMsg = "[RepositoryBuste.getDataRegistrazioneBusta] errore, queryString[" + queryString + "]: " + e.getMessage();
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Date getDataScadenzaBustaMassima(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger) throws ProtocolException {
        return RepositoryBuste._getDataScadenzaBusta(false, connectionDB, tipoDatabase, logQuery, logger);
    }

    public static Date getDataScadenzaBustaMinima(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger) throws ProtocolException {
        return RepositoryBuste._getDataScadenzaBusta(true, connectionDB, tipoDatabase, logQuery, logger);
    }

    private static Date _getDataScadenzaBusta(boolean min, Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger) throws ProtocolException {
        Statement pstmt = null;
        ResultSet rs = null;
        String queryString = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            if (min) {
                sqlQueryObject.addSelectMinField("SCADENZA_BUSTA", "check_data");
            } else {
                sqlQueryObject.addSelectMaxField("SCADENZA_BUSTA", "check_data");
            }
            sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            if (logQuery) {
                logger.debug("Esecuzione query [" + queryString + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") ...");
            }
            pstmt = connectionDB.prepareStatement(queryString);
            rs = pstmt.executeQuery();
            if (logQuery) {
                logger.debug("Esecuzione query [" + queryString + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") completata");
            }
            if (rs.next()) {
                Timestamp timestamp = rs.getTimestamp("check_data");
                return timestamp;
            }
            Date date = null;
            return date;
        }
        catch (Exception e) {
            String errorMsg = "[RepositoryBuste.getDataScadenzaBusta] errore, queryString[" + queryString + "]: " + e.getMessage();
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static int countBusteInutiliIntoInBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, IGestoreRepository repository, Date leftDate, Date rightDate, boolean useDataRegistrazione) throws ProtocolException {
        return RepositoryBuste._countBusteIntoBox(true, connectionDB, tipoDatabase, logQuery, logger, false, repository, leftDate, rightDate, useDataRegistrazione);
    }

    public static int countBusteInutiliIntoOutBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, IGestoreRepository repository, Date leftDate, Date rightDate, boolean useDataRegistrazione) throws ProtocolException {
        return RepositoryBuste._countBusteIntoBox(false, connectionDB, tipoDatabase, logQuery, logger, false, repository, leftDate, rightDate, useDataRegistrazione);
    }

    public static int countBusteScaduteIntoInBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, IGestoreRepository repository) throws ProtocolException {
        return RepositoryBuste._countBusteIntoBox(true, connectionDB, tipoDatabase, logQuery, logger, true, repository, null, null, false);
    }

    public static int countBusteScaduteIntoOutBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, IGestoreRepository repository) throws ProtocolException {
        return RepositoryBuste._countBusteIntoBox(false, connectionDB, tipoDatabase, logQuery, logger, true, repository, null, null, false);
    }

    private static int _countBusteIntoBox(boolean searchIntoInbox, Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, boolean scadenzaMsg, IGestoreRepository repository, Date leftDate, Date rightDate, boolean useDataRegistrazione) throws ProtocolException {
        String tipo = null;
        tipo = searchIntoInbox ? "INBOX" : "OUTBOX";
        Statement pstmt = null;
        ResultSet rs = null;
        String queryString = null;
        try {
            Timestamp nowT = null;
            if (scadenzaMsg) {
                nowT = DateManager.getTimestamp();
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addSelectCountField("totale_msg");
            sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
            if (leftDate != null) {
                sqlQueryObject.addWhereCondition((useDataRegistrazione ? "DATA_REGISTRAZIONE" : "SCADENZA_BUSTA") + ">=?");
            }
            if (rightDate != null) {
                sqlQueryObject.addWhereCondition((useDataRegistrazione ? "DATA_REGISTRAZIONE" : "SCADENZA_BUSTA") + "<=?");
            }
            if (scadenzaMsg) {
                sqlQueryObject.addWhereCondition("SCADENZA_BUSTA < ?");
                sqlQueryObject.addWhereCondition("TIPO=?");
                sqlQueryObject.addWhereCondition(repository.createSQLCondition_enableOnlyHistory());
            } else {
                sqlQueryObject.addWhereCondition("TIPO=?");
                sqlQueryObject.addWhereCondition(repository.createSQLCondition_disabledAll());
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            pstmt = connectionDB.prepareStatement(queryString);
            int index = 1;
            ArrayList<String> objects = new ArrayList<String>();
            if (leftDate != null) {
                Timestamp leftDateT = new Timestamp(leftDate.getTime());
                pstmt.setTimestamp(index++, leftDateT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(leftDateT));
                }
            }
            if (rightDate != null) {
                Timestamp rightDateT = new Timestamp(rightDate.getTime());
                pstmt.setTimestamp(index++, rightDateT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(rightDateT));
                }
            }
            if (scadenzaMsg) {
                pstmt.setTimestamp(index++, nowT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(nowT));
                }
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
            } else {
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
            }
            String query = null;
            if (logQuery) {
                query = DBUtils.formatSQLString((String)queryString, (Object[])objects.toArray());
                logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") ...");
            }
            rs = pstmt.executeQuery();
            int res = 0;
            if (rs.next()) {
                res = rs.getInt("totale_msg");
            }
            if (logQuery) {
                logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") completata; trovati " + res + " risultati");
            }
            int n = res;
            return n;
        }
        catch (Exception e) {
            String errorMsg = "[RepositoryBuste.countBusteIntoBox] errore, queryString[" + queryString + "]: " + e.getMessage();
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static SortedMap<Integer> deleteBusteInutiliIntoInBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, IGestoreRepository repository, Date leftDate, Date rightDate, boolean useDataRegistrazione) throws ProtocolException {
        return RepositoryBuste._deleteBusteIntoBox(true, connectionDB, tipoDatabase, logQuery, logger, false, repository, leftDate, rightDate, useDataRegistrazione);
    }

    public static SortedMap<Integer> deleteBusteInutiliIntoOutBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, IGestoreRepository repository, Date leftDate, Date rightDate, boolean useDataRegistrazione) throws ProtocolException {
        return RepositoryBuste._deleteBusteIntoBox(false, connectionDB, tipoDatabase, logQuery, logger, false, repository, leftDate, rightDate, useDataRegistrazione);
    }

    public static SortedMap<Integer> deleteBusteScaduteIntoInBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, IGestoreRepository repository) throws ProtocolException {
        return RepositoryBuste._deleteBusteIntoBox(true, connectionDB, tipoDatabase, logQuery, logger, true, repository, null, null, false);
    }

    public static SortedMap<Integer> deleteBusteScaduteIntoOutBox(Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, IGestoreRepository repository) throws ProtocolException {
        return RepositoryBuste._deleteBusteIntoBox(false, connectionDB, tipoDatabase, logQuery, logger, true, repository, null, null, false);
    }

    private static SortedMap<Integer> _deleteBusteIntoBox(boolean searchIntoInbox, Connection connectionDB, String tipoDatabase, boolean logQuery, Logger logger, boolean scadenzaMsg, IGestoreRepository repository, Date leftDate, Date rightDate, boolean useDataRegistrazione) throws ProtocolException {
        SortedMap mapTabelleRigheEliminate = new SortedMap();
        String tipo = null;
        tipo = searchIntoInbox ? "INBOX" : "OUTBOX";
        Statement pstmt = null;
        String deleteString = null;
        try {
            Timestamp nowT = null;
            if (scadenzaMsg) {
                nowT = DateManager.getTimestamp();
            }
            ISQLQueryObject sqlQueryObjectRepositoryBusteJoin = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObjectRepositoryBusteJoin.addSelectField("ID_MESSAGGIO");
            sqlQueryObjectRepositoryBusteJoin.addFromTable("REPOSITORY_BUSTE");
            if (leftDate != null) {
                sqlQueryObjectRepositoryBusteJoin.addWhereCondition((useDataRegistrazione ? "DATA_REGISTRAZIONE" : "SCADENZA_BUSTA") + ">=?");
            }
            if (rightDate != null) {
                sqlQueryObjectRepositoryBusteJoin.addWhereCondition((useDataRegistrazione ? "DATA_REGISTRAZIONE" : "SCADENZA_BUSTA") + "<=?");
            }
            if (scadenzaMsg) {
                sqlQueryObjectRepositoryBusteJoin.addWhereCondition("SCADENZA_BUSTA < ?");
                sqlQueryObjectRepositoryBusteJoin.addWhereCondition("TIPO=?");
                sqlQueryObjectRepositoryBusteJoin.addWhereCondition(repository.createSQLCondition_enableOnlyHistory());
            } else {
                sqlQueryObjectRepositoryBusteJoin.addWhereCondition("TIPO=?");
                sqlQueryObjectRepositoryBusteJoin.addWhereCondition(repository.createSQLCondition_disabledAll());
            }
            sqlQueryObjectRepositoryBusteJoin.setANDLogicOperator(true);
            RepositoryBuste._deleteListaRepositoryBuste(tipoDatabase, connectionDB, logQuery, logger, "LISTA_RISCONTRI", "TIPO", "ID_MESSAGGIO", tipo, nowT, sqlQueryObjectRepositoryBusteJoin, leftDate, rightDate, (SortedMap<Integer>)mapTabelleRigheEliminate);
            RepositoryBuste._deleteListaRepositoryBuste(tipoDatabase, connectionDB, logQuery, logger, "LISTA_TRASMISSIONI", "TIPO", "ID_MESSAGGIO", tipo, nowT, sqlQueryObjectRepositoryBusteJoin, leftDate, rightDate, (SortedMap<Integer>)mapTabelleRigheEliminate);
            RepositoryBuste._deleteListaRepositoryBuste(tipoDatabase, connectionDB, logQuery, logger, "LISTA_ECCEZIONI", "TIPO", "ID_MESSAGGIO", tipo, nowT, sqlQueryObjectRepositoryBusteJoin, leftDate, rightDate, (SortedMap<Integer>)mapTabelleRigheEliminate);
            RepositoryBuste._deleteListaRepositoryBuste(tipoDatabase, connectionDB, logQuery, logger, "LISTA_EXT_PROTOCOL_INFO", "TIPO", "ID_MESSAGGIO", tipo, nowT, sqlQueryObjectRepositoryBusteJoin, leftDate, rightDate, (SortedMap<Integer>)mapTabelleRigheEliminate);
            RepositoryBuste._deleteListaRepositoryBuste(tipoDatabase, connectionDB, logQuery, logger, "ASINCRONO", "TIPO", "ID_MESSAGGIO", tipo, nowT, sqlQueryObjectRepositoryBusteJoin, leftDate, rightDate, (SortedMap<Integer>)mapTabelleRigheEliminate);
            if (!searchIntoInbox) {
                RepositoryBuste._deleteListaRepositoryBuste(tipoDatabase, connectionDB, logQuery, logger, "RISCONTRI_DA_RICEVERE", null, "ID_MESSAGGIO", tipo, nowT, sqlQueryObjectRepositoryBusteJoin, leftDate, rightDate, (SortedMap<Integer>)mapTabelleRigheEliminate);
            }
            ISQLQueryObject sqlQueryObjectRepositoryBuste = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObjectRepositoryBuste.addDeleteTable("REPOSITORY_BUSTE");
            if (leftDate != null) {
                sqlQueryObjectRepositoryBuste.addWhereCondition((useDataRegistrazione ? "DATA_REGISTRAZIONE" : "SCADENZA_BUSTA") + ">=?");
            }
            if (rightDate != null) {
                sqlQueryObjectRepositoryBuste.addWhereCondition((useDataRegistrazione ? "DATA_REGISTRAZIONE" : "SCADENZA_BUSTA") + "<=?");
            }
            if (scadenzaMsg) {
                sqlQueryObjectRepositoryBuste.addWhereCondition("SCADENZA_BUSTA < ?");
                sqlQueryObjectRepositoryBuste.addWhereCondition("TIPO=?");
                sqlQueryObjectRepositoryBuste.addWhereCondition(repository.createSQLCondition_enableOnlyHistory());
            } else {
                sqlQueryObjectRepositoryBuste.addWhereCondition("TIPO=?");
                sqlQueryObjectRepositoryBuste.addWhereCondition(repository.createSQLCondition_disabledAll());
            }
            sqlQueryObjectRepositoryBuste.setANDLogicOperator(true);
            deleteString = sqlQueryObjectRepositoryBuste.createSQLDelete();
            pstmt = connectionDB.prepareStatement(deleteString);
            int index = 1;
            ArrayList<String> objects = new ArrayList<String>();
            if (leftDate != null) {
                Timestamp leftDateT = new Timestamp(leftDate.getTime());
                pstmt.setTimestamp(index++, leftDateT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(leftDateT));
                }
            }
            if (rightDate != null) {
                Timestamp rightDateT = new Timestamp(rightDate.getTime());
                pstmt.setTimestamp(index++, rightDateT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(rightDateT));
                }
            }
            if (scadenzaMsg) {
                pstmt.setTimestamp(index++, nowT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(nowT));
                }
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
            } else {
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
            }
            String query = null;
            if (logQuery) {
                query = DBUtils.formatSQLString((String)deleteString, (Object[])objects.toArray());
                logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") ...");
            }
            int result = pstmt.executeUpdate();
            pstmt.close();
            pstmt = null;
            if (logQuery) {
                logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") completata; " + result + " righe eliminate");
            }
            mapTabelleRigheEliminate.add("REPOSITORY_BUSTE", (Object)result);
            SortedMap sortedMap = mapTabelleRigheEliminate;
            return sortedMap;
        }
        catch (Exception e) {
            String errorMsg = "[RepositoryBuste.deleteBusteIntoBox] errore, deleteString[" + deleteString + "]: " + e.getMessage();
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _deleteListaRepositoryBuste(String tipoDatabase, Connection connectionDB, boolean logQuery, Logger logger, String nomeTabella, String nomeColonnaTipoMessaggio, String nomeColonnaIdMessaggio, String tipo, Timestamp scandenzaT, ISQLQueryObject sqlQueryObjectRepositoryBusteJoin, Date leftDate, Date rightDate, SortedMap<Integer> mapTabelleRigheEliminate) throws Exception {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
        sqlQueryObject.addDeleteTable(nomeTabella);
        if (nomeColonnaTipoMessaggio != null) {
            sqlQueryObject.addWhereCondition(nomeColonnaTipoMessaggio + "=?");
        }
        sqlQueryObject.addWhereINSelectSQLCondition(false, nomeColonnaIdMessaggio, sqlQueryObjectRepositoryBusteJoin);
        sqlQueryObject.setANDLogicOperator(true);
        String deleteString = sqlQueryObject.createSQLDelete();
        PreparedStatement pstmt = null;
        try {
            pstmt = connectionDB.prepareStatement(deleteString);
            int index = 1;
            ArrayList<String> objects = new ArrayList<String>();
            if (nomeColonnaTipoMessaggio != null) {
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
            }
            if (leftDate != null) {
                Timestamp leftDateT = new Timestamp(leftDate.getTime());
                pstmt.setTimestamp(index++, leftDateT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(leftDateT));
                }
            }
            if (rightDate != null) {
                Timestamp rightDateT = new Timestamp(rightDate.getTime());
                pstmt.setTimestamp(index++, rightDateT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(rightDateT));
                }
            }
            if (scandenzaT != null) {
                pstmt.setTimestamp(index++, scandenzaT);
                if (logQuery) {
                    objects.add(DateUtils.getSimpleDateFormatMs().format(scandenzaT));
                }
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
            } else {
                pstmt.setString(index++, tipo);
                if (logQuery) {
                    objects.add(tipo);
                }
            }
            String query = null;
            if (logQuery) {
                query = DBUtils.formatSQLString((String)deleteString, (Object[])objects.toArray());
                logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") ...");
            }
            int result = pstmt.executeUpdate();
            pstmt.close();
            pstmt = null;
            if (logQuery) {
                logger.debug("Esecuzione query [" + query + "] (" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + ") completata; " + result + " righe eliminate");
            }
            mapTabelleRigheEliminate.add(nomeTabella, (Object)result);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<String> getBusteDaEliminareFromInBox(int limit, boolean logQuery, boolean forceIndex, boolean filtraBustaScadetureRispettoOraRegistrazione, boolean orderBy, Date data) throws ProtocolException {
        return this.getBusteDaEliminare("INBOX", limit, logQuery, forceIndex, filtraBustaScadetureRispettoOraRegistrazione, orderBy, data);
    }

    public List<String> getBusteDaEliminareFromOutBox(int limit, boolean logQuery, boolean forceIndex, boolean filtraBustaScadetureRispettoOraRegistrazione, boolean orderBy, Date data) throws ProtocolException {
        return this.getBusteDaEliminare("OUTBOX", limit, logQuery, forceIndex, filtraBustaScadetureRispettoOraRegistrazione, orderBy, data);
    }

    private List<String> getBusteDaEliminare(String tipoBusta, int limit, boolean logQuery, boolean forceIndex, boolean filtraBustaScadetureRispettoOraRegistrazione, boolean orderBy, Date data) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            Timestamp nowT = null;
            if (data != null) {
                nowT = new Timestamp(data.getTime());
            }
            Statement pstmt = null;
            ResultSet rs = null;
            ArrayList<String> idBuste = new ArrayList<String>();
            IGestoreRepository gestorerepositoryBuste = Configurazione.getGestoreRepositoryBuste();
            String queryString = null;
            try {
                ISQLQueryObject sqlQueryObject;
                StringBuilder query;
                if (filtraBustaScadetureRispettoOraRegistrazione) {
                    if (Configurazione.getSqlQueryObjectType() == null) {
                        query = new StringBuilder();
                        query.append("SELECT ");
                        if (forceIndex) {
                            query.append("/*+ index(REPOSITORY_BUSTE REP_BUSTE_SEARCH) */");
                        }
                        query.append(" ID_MESSAGGIO FROM ");
                        query.append("REPOSITORY_BUSTE");
                        query.append(" WHERE SCADENZA_BUSTA < ? AND TIPO=? AND ");
                        query.append(gestorerepositoryBuste.createSQLCondition_enableOnlyHistory());
                        if (data != null) {
                            query.append(" AND DATA_REGISTRAZIONE<=?");
                        }
                        queryString = query.toString();
                    } else {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                        if (forceIndex) {
                            sqlQueryObject.addSelectForceIndex("REPOSITORY_BUSTE", "REP_BUSTE_SEARCH");
                        }
                        sqlQueryObject.addSelectField("ID_MESSAGGIO");
                        sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                        sqlQueryObject.addSelectField("SCADENZA_BUSTA");
                        sqlQueryObject.addSelectField("TIPO");
                        sqlQueryObject.addSelectField(gestorerepositoryBuste.createSQLFields());
                        sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
                        sqlQueryObject.addWhereCondition("SCADENZA_BUSTA < ?");
                        sqlQueryObject.addWhereCondition("TIPO=?");
                        sqlQueryObject.addWhereCondition(gestorerepositoryBuste.createSQLCondition_enableOnlyHistory());
                        if (data != null) {
                            sqlQueryObject.addWhereCondition("DATA_REGISTRAZIONE<=?");
                        }
                        sqlQueryObject.setANDLogicOperator(true);
                        if (orderBy) {
                            sqlQueryObject.addOrderBy("SCADENZA_BUSTA");
                            sqlQueryObject.setSortType(true);
                        }
                        sqlQueryObject.setLimit(limit);
                        queryString = sqlQueryObject.createSQLQuery();
                    }
                    Timestamp now = DateManager.getTimestamp();
                    pstmt = connectionDB.prepareStatement(queryString);
                    pstmt.setTimestamp(1, now);
                    pstmt.setString(2, tipoBusta);
                    if (data != null) {
                        pstmt.setTimestamp(3, nowT);
                    }
                    long startDateSQLCommand = DateManager.getTimeMillis();
                    if (logQuery) {
                        this.log.debug("[QUERY] (repositoryBuste.busteScadute) [" + queryString + "] 1[" + now + "] 2[" + tipoBusta + "] 3[" + nowT + "]...");
                    }
                    rs = pstmt.executeQuery();
                    long endDateSQLCommand = DateManager.getTimeMillis();
                    long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                    if (logQuery) {
                        this.log.debug("[QUERY] (repositoryBuste.busteScadute) [" + queryString + "] 1[" + now + "] 2[" + tipoBusta + "] 3[" + nowT + "] effettuata in " + secondSQLCommand + " secondi");
                    }
                    int countLimit = 0;
                    while (rs.next()) {
                        idBuste.add(rs.getString("ID_MESSAGGIO"));
                        if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                    }
                    rs.close();
                    pstmt.close();
                }
                queryString = null;
                if (Configurazione.getSqlQueryObjectType() == null) {
                    query = new StringBuilder();
                    query.append("SELECT ");
                    if (forceIndex) {
                        query.append("/*+ index(REPOSITORY_BUSTE REP_BUSTE_SEARCH_TIPO) */");
                    }
                    query.append(" ID_MESSAGGIO FROM ");
                    query.append("REPOSITORY_BUSTE");
                    query.append(" WHERE TIPO=? AND ");
                    query.append(gestorerepositoryBuste.createSQLCondition_disabledAll());
                    if (data != null) {
                        query.append(" AND DATA_REGISTRAZIONE<=?");
                    }
                    queryString = query.toString();
                } else {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    if (forceIndex) {
                        sqlQueryObject.addSelectForceIndex("REPOSITORY_BUSTE", "REP_BUSTE_SEARCH_TIPO");
                    }
                    sqlQueryObject.addSelectField("ID_MESSAGGIO");
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addSelectField(gestorerepositoryBuste.createSQLFields());
                    sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    sqlQueryObject.addWhereCondition(gestorerepositoryBuste.createSQLCondition_disabledAll());
                    if (data != null) {
                        sqlQueryObject.addWhereCondition("DATA_REGISTRAZIONE<=?");
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    if (orderBy) {
                        sqlQueryObject.addOrderBy("SCADENZA_BUSTA");
                        sqlQueryObject.setSortType(true);
                    }
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmt = connectionDB.prepareStatement(queryString.toString());
                pstmt.setString(1, tipoBusta);
                if (data != null) {
                    pstmt.setTimestamp(2, nowT);
                }
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug("[QUERY] (repositoryBuste.busteCancellateLogicamente) [" + queryString + "] 1[" + tipoBusta + "] 2[" + nowT + "]...");
                }
                rs = pstmt.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug("[QUERY] (repositoryBuste.busteCancellateLogicamente) [" + queryString + "] 1[" + tipoBusta + "] 2[" + nowT + "] effettuata in " + secondSQLCommand + " secondi");
                }
                int countLimit = 0;
                while (rs.next()) {
                    idBuste.add(rs.getString("ID_MESSAGGIO"));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmt.close();
                return idBuste;
            }
            catch (Exception e) {
                String errorMsg = "[repositoryBuste.getBusteDaEliminare] errore, queryString[" + queryString + "]: " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        throw new ProtocolException("Metodo non invocabile in stateless mode");
    }

    public void impostaUtilizzoPdD(String id, String tipoBusta) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtUpdate = null;
        try {
            StringBuilder queryUpdate = new StringBuilder();
            queryUpdate.append("UPDATE ");
            queryUpdate.append("REPOSITORY_BUSTE");
            queryUpdate.append(" SET ");
            queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_PdD(true));
            queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
            pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
            pstmtUpdate.setString(1, id);
            pstmtUpdate.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE AggiornamentoBusta_setUtilizzoPdD" + tipoBusta + "_" + id, (PreparedStatement)pstmtUpdate);
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore di impostazione utilizzo from PdD " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public boolean exists(String id, String tipoBusta) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuilder queryUpdate = new StringBuilder();
            queryUpdate.append("SELECT ID_MESSAGGIO FROM ");
            queryUpdate.append("REPOSITORY_BUSTE");
            queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=? AND (");
            queryUpdate.append(this.gestoreRepositoryBuste.createSQLCondition_History(true));
            queryUpdate.append(" OR ");
            queryUpdate.append(this.gestoreRepositoryBuste.createSQLCondition_PdD(true));
            queryUpdate.append(" OR ");
            queryUpdate.append(this.gestoreRepositoryBuste.createSQLCondition_ProfiloCollaborazione(true));
            queryUpdate.append(" ) ");
            pstmt = connectionDB.prepareStatement(queryUpdate.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, tipoBusta);
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new Exception("Result set is null??");
            }
            boolean value = rs.next();
            rs.close();
            pstmt.close();
            return value;
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore durante l'utilizzo di exists " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public boolean isRegistrazioneInCorso() {
        List keys;
        StateMessage stateMSG;
        if (this.state != null && (stateMSG = (StateMessage)this.state).getPreparedStatement() != null && stateMSG.getPreparedStatement().size() > 0 && (keys = stateMSG.getPreparedStatement().keys()) != null && !keys.isEmpty()) {
            for (String key : keys) {
                if (key != null && key.startsWith("INSERT")) {
                    return true;
                }
                if (key == null || !key.startsWith("UPDATE")) continue;
                return true;
            }
        }
        return false;
    }
}

