/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.mapping;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.xml.MessageDynamicNamespaceContextFactory;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.protocol.engine.constants.ModalitaIdentificazione;
import org.openspcoop2.protocol.engine.mapping.MappingInfo;
import org.openspcoop2.protocol.engine.mapping.MappingProperties;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.manifest.UrlMapping;
import org.openspcoop2.protocol.manifest.constants.UrlMappingSourceType;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.state.FunctionContextsCustom;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.transport.Credential;
import org.openspcoop2.utils.xml.AbstractXPathExpressionEngine;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml2json.JsonXmlPathExpressionEngine;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InformazioniServizioURLMapping {
    private static final String TIPO_MITTENTE = "identificazione-tipo-mittente";
    private static final String NOME_MITTENTE = "identificazione-mittente";
    private static final String INFORMAZIONI_PROTOCOLLO = "identificazione-informazioni-protocollo";
    private static final String ID_PROTOCOLLO = "identificazione-id-protocollo";
    private static final String GENERAZIONE_LISTA_TRASMISSIONI = "generazione-lista-trasmissioni";
    private static HashMap<String, MappingProperties> mappingPropertiesTable = new HashMap();
    private OpenSPCoop2Message msg;
    private URLProtocolContext urlProtocolContext;
    private Logger log;
    private MappingProperties mp;
    private String idMapping;
    private MappingInfo tipoMittente;
    private MappingInfo mittente;
    private MappingInfo infoProtocollo;
    private MappingInfo idProtocollo;
    private boolean generateListaTrasmissione = false;

    private static MappingProperties getMappingProperties(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        Openspcoop2 manifest = protocolFactory.getManifest();
        if (!mappingPropertiesTable.containsKey(manifest.getProtocol().getName())) {
            InformazioniServizioURLMapping.initMappingProperties(protocolFactory);
        }
        return mappingPropertiesTable.get(manifest.getProtocol().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initMappingProperties(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        block12: {
            try {
                Openspcoop2 manifest = protocolFactory.getManifest();
                if (mappingPropertiesTable.containsKey(manifest.getProtocol().getName())) break block12;
                UrlMapping urlMapping = manifest.getUrlMapping();
                if (UrlMappingSourceType.XML.equals((Object)urlMapping.getType())) {
                    throw new ProtocolException("Not implemented");
                }
                if (UrlMappingSourceType.PROPERTIES.equals((Object)urlMapping.getType())) {
                    File f = new File(urlMapping.getFile());
                    InputStream is = null;
                    try {
                        is = f.exists() ? new FileInputStream(f) : protocolFactory.getClass().getResourceAsStream(urlMapping.getFile());
                        MappingProperties m = new MappingProperties(urlMapping.getFile(), is, protocolFactory.getLogger());
                        mappingPropertiesTable.put(manifest.getProtocol().getName(), m);
                        break block12;
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                throw new ProtocolException("[" + urlMapping.getType().getValue() + "] Not supported");
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public InformazioniServizioURLMapping(OpenSPCoop2Message msg, IProtocolFactory<?> protocolFactory, URLProtocolContext urlProtocolContext, Logger log, IDService idService, FunctionContextsCustom customContexts) throws ProtocolException {
        this.mp = InformazioniServizioURLMapping.getMappingProperties(protocolFactory);
        this.msg = msg;
        this.urlProtocolContext = urlProtocolContext;
        this.log = log;
        this.idMapping = this.resolveMappingName(urlProtocolContext, idService, customContexts);
        this.tipoMittente = this.getMappingInfo(TIPO_MITTENTE);
        this.mittente = this.getMappingInfo(NOME_MITTENTE);
        this.infoProtocollo = this.getMappingInfo(INFORMAZIONI_PROTOCOLLO);
        this.idProtocollo = this.getMappingInfo(ID_PROTOCOLLO);
        String generazioneListaTrasmissioniTmp = this.mp.getValue(this.msg.getProtocolName(), this.idMapping, GENERAZIONE_LISTA_TRASMISSIONI);
        if (generazioneListaTrasmissioniTmp != null) {
            this.generateListaTrasmissione = Boolean.parseBoolean(generazioneListaTrasmissioniTmp);
        }
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append("MappingId(");
        bf.append(this.idMapping);
        bf.append(") ");
        bf.append("TipoMittente(");
        if (this.tipoMittente != null) {
            bf.append(this.tipoMittente.toString());
        } else {
            bf.append("?non presente?");
        }
        bf.append(") ");
        bf.append("Mittente(");
        if (this.mittente != null) {
            bf.append(this.mittente.toString());
        } else {
            bf.append("?non presente?");
        }
        bf.append(") ");
        bf.append("InformazioniProtocollo(");
        if (this.infoProtocollo != null) {
            bf.append(this.infoProtocollo.toString());
        } else {
            bf.append("?non presente?");
        }
        bf.append(") ");
        bf.append("IDProtocollo(");
        if (this.idProtocollo != null) {
            bf.append(this.idProtocollo.toString());
        } else {
            bf.append("?non presente?");
        }
        bf.append(") ");
        bf.append("GenerazioneListaTrasmissioni(");
        bf.append(this.generateListaTrasmissione);
        bf.append(") ");
        return bf.toString();
    }

    private String resolveMappingName(URLProtocolContext urlProtocolContext, IDService idService, FunctionContextsCustom customContexts) throws ProtocolException {
        String mappingName = this.mp.getMappingName(this.msg.getProtocolName(), urlProtocolContext.getRequestURI(), idService, customContexts);
        return mappingName;
    }

    private MappingInfo getMappingInfo(String proprieta) throws ProtocolException {
        MappingInfo mappingInfo = new MappingInfo();
        mappingInfo.setModalitaIdentificazione(this.mp.getModalita(this.msg.getProtocolName(), this.idMapping, proprieta));
        mappingInfo.setName(this.mp.getName(this.msg.getProtocolName(), this.idMapping, proprieta));
        mappingInfo.setValue(this.mp.getValue(this.msg.getProtocolName(), this.idMapping, proprieta));
        mappingInfo.setPattern(this.mp.getPattern(this.msg.getProtocolName(), this.idMapping, proprieta));
        mappingInfo.setAnonymous(this.mp.getAnonymous(this.msg.getProtocolName(), this.idMapping, proprieta));
        if (ID_PROTOCOLLO.equals(proprieta) || INFORMAZIONI_PROTOCOLLO.equals(proprieta)) {
            if (!ModalitaIdentificazione.STATIC.equals((Object)mappingInfo.getModalitaIdentificazione()) && !ModalitaIdentificazione.PLUGIN_BASED.equals((Object)mappingInfo.getModalitaIdentificazione())) {
                throw new ProtocolException("La Modalita' '" + mappingInfo.getModalitaIdentificazione().toString() + "', indicata per la proprieta' [" + proprieta + "], non puo' essere utilizzata");
            }
            return mappingInfo;
        }
        if (ModalitaIdentificazione.STATIC.equals((Object)mappingInfo.getModalitaIdentificazione()) && mappingInfo.getValue() == null) {
            throw new ProtocolException("La Modalita' '" + ModalitaIdentificazione.STATIC.toString() + "', indicata per la proprieta' [" + proprieta + "], richiede la definizione di una omonima proprieta' con suffisso '.value'");
        }
        if (ModalitaIdentificazione.URL_BASED.equals((Object)mappingInfo.getModalitaIdentificazione()) && mappingInfo.getPattern() == null) {
            throw new ProtocolException("La Modalita' '" + ModalitaIdentificazione.URL_BASED.toString() + "', indicata per la proprieta' [" + proprieta + "], richiede la definizione di una omonima proprieta' con suffisso '.pattern'");
        }
        if (ModalitaIdentificazione.CONTENT_BASED.equals((Object)mappingInfo.getModalitaIdentificazione()) && mappingInfo.getPattern() == null) {
            throw new ProtocolException("La Modalita' '" + ModalitaIdentificazione.CONTENT_BASED.toString() + "', indicata per la proprieta' [" + proprieta + "], richiede la definizione di una omonima proprieta' con suffisso '.pattern'");
        }
        if (ModalitaIdentificazione.HEADER_BASED.equals((Object)mappingInfo.getModalitaIdentificazione()) && mappingInfo.getName() == null) {
            throw new ProtocolException("La Modalita' '" + ModalitaIdentificazione.CONTENT_BASED.toString() + "', indicata per la proprieta' [" + proprieta + "], richiede la definizione di una omonima proprieta' con suffisso '.name'");
        }
        if (ModalitaIdentificazione.IDENTITY_BASED.equals((Object)mappingInfo.getModalitaIdentificazione()) && !NOME_MITTENTE.equals(proprieta)) {
            throw new ProtocolException("La Modalita' '" + ModalitaIdentificazione.IDENTITY_BASED.toString() + "', indicata per la proprieta' [" + proprieta + "], puo' essere utilizzata solamente per identificare il nome del mittente");
        }
        return mappingInfo;
    }

    public boolean existsUrlBasedIdentificationMode() {
        if (this.tipoMittente != null && ModalitaIdentificazione.URL_BASED.equals((Object)this.tipoMittente.getModalitaIdentificazione())) {
            return true;
        }
        return this.mittente != null && ModalitaIdentificazione.URL_BASED.equals((Object)this.mittente.getModalitaIdentificazione());
    }

    public boolean existsContentBasedIdentificationMode() {
        if (this.tipoMittente != null && ModalitaIdentificazione.CONTENT_BASED.equals((Object)this.tipoMittente.getModalitaIdentificazione())) {
            return true;
        }
        return this.mittente != null && ModalitaIdentificazione.CONTENT_BASED.equals((Object)this.mittente.getModalitaIdentificazione());
    }

    public boolean existsIdentityBasedIdentificationMode() {
        return this.mittente != null && ModalitaIdentificazione.IDENTITY_BASED.equals((Object)this.mittente.getModalitaIdentificazione());
    }

    public boolean isStaticBasedIdentificationMode_InfoProtocol() {
        return this.infoProtocollo != null && ModalitaIdentificazione.STATIC.equals((Object)this.infoProtocollo.getModalitaIdentificazione());
    }

    public boolean isStaticBasedIdentificationMode_IdProtocol() {
        return this.idProtocollo != null && ModalitaIdentificazione.STATIC.equals((Object)this.idProtocollo.getModalitaIdentificazione());
    }

    public boolean isGenerateListaTrasmissione() {
        return this.generateListaTrasmissione;
    }

    public void refreshDati(IDSoggetto idMittente, Credential identity, IDSoggetto headerIntegrazioneRichiestaSoggettoMittente) throws ProtocolException {
        String mittente;
        block20: {
            String tipoMittente;
            String elementJson;
            Object element;
            XPathExpressionEngine xPathEngine;
            DynamicNamespaceContext dnc;
            String urlInvocazione;
            block19: {
                urlInvocazione = null;
                dnc = null;
                xPathEngine = null;
                element = null;
                elementJson = null;
                if (this.existsUrlBasedIdentificationMode()) {
                    urlInvocazione = this.urlProtocolContext.getUrlInvocazione_formBased();
                }
                if (this.existsContentBasedIdentificationMode()) {
                    try {
                        if (ServiceBinding.SOAP.equals((Object)this.msg.getServiceBinding())) {
                            element = this.msg.castAsSoap().getSOAPPart().getEnvelope();
                        } else if (MessageType.XML.equals((Object)this.msg.getMessageType())) {
                            element = (Element)this.msg.castAsRestXml().getContent();
                        } else if (MessageType.JSON.equals((Object)this.msg.getMessageType())) {
                            elementJson = (String)this.msg.castAsRestJson().getContent();
                        } else {
                            throw new DriverConfigurazioneNotFound("Identificazione 'contentBased' non supportata per il message-type '" + this.msg.getMessageType() + "'");
                        }
                        if (element != null) {
                            dnc = MessageDynamicNamespaceContextFactory.getInstance((OpenSPCoop2MessageFactory)this.msg.getFactory()).getNamespaceContext((Node)element);
                            xPathEngine = new XPathExpressionEngine(this.msg.getFactory());
                        }
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                }
                tipoMittente = null;
                try {
                    tipoMittente = this.readValue(this.tipoMittente, TIPO_MITTENTE, identity, urlInvocazione, (Element)element, dnc, (AbstractXPathExpressionEngine)xPathEngine, elementJson, headerIntegrazioneRichiestaSoggettoMittente);
                }
                catch (ProtocolException e) {
                    if (tipoMittente != null || ModalitaIdentificazione.PLUGIN_BASED.equals((Object)this.tipoMittente.getModalitaIdentificazione())) break block19;
                    if (this.tipoMittente.getAnonymous() == null) {
                        throw e;
                    }
                    tipoMittente = this.tipoMittente.getAnonymous();
                }
            }
            if (tipoMittente != null) {
                idMittente.setTipo(tipoMittente);
            }
            mittente = null;
            try {
                mittente = this.readValue(this.mittente, NOME_MITTENTE, identity, urlInvocazione, (Element)element, dnc, (AbstractXPathExpressionEngine)xPathEngine, elementJson, headerIntegrazioneRichiestaSoggettoMittente);
            }
            catch (ProtocolException e) {
                if (mittente != null || ModalitaIdentificazione.PLUGIN_BASED.equals((Object)this.mittente.getModalitaIdentificazione())) break block20;
                if (this.mittente.getAnonymous() == null) {
                    throw e;
                }
                mittente = this.mittente.getAnonymous();
            }
        }
        if (mittente != null) {
            idMittente.setNome(mittente);
        }
    }

    private String readValue(MappingInfo mappingInfo, String oggetto, Credential identity, String urlInvocazione, Element element, DynamicNamespaceContext dnc, AbstractXPathExpressionEngine xPathEngine, String elementJson, IDSoggetto headerIntegrazioneRichiestaSoggettoMittente) throws ProtocolException {
        if (ModalitaIdentificazione.STATIC.equals((Object)mappingInfo.getModalitaIdentificazione())) {
            if (mappingInfo.getValue() == null) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.STATIC.toString() + " non riuscita: valore nell'omonima proprieta' con suffisso '.value' non fornito");
            }
            return mappingInfo.getValue();
        }
        if (ModalitaIdentificazione.PLUGIN_BASED.equals((Object)mappingInfo.getModalitaIdentificazione())) {
            return null;
        }
        if (ModalitaIdentificazione.URL_BASED.equals((Object)mappingInfo.getModalitaIdentificazione())) {
            try {
                return RegularExpressionEngine.getStringMatchPattern((String)urlInvocazione, (String)mappingInfo.getPattern());
            }
            catch (Exception e) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.URL_BASED.toString() + " non riuscita: " + e.getMessage(), (Throwable)e);
            }
        }
        if (ModalitaIdentificazione.CONTENT_BASED.equals((Object)mappingInfo.getModalitaIdentificazione())) {
            try {
                if (element != null) {
                    return AbstractXPathExpressionEngine.extractAndConvertResultAsString((Element)element, (DynamicNamespaceContext)dnc, (AbstractXPathExpressionEngine)xPathEngine, (String)mappingInfo.getPattern(), (Logger)this.log);
                }
                return JsonXmlPathExpressionEngine.extractAndConvertResultAsString((String)elementJson, (String)mappingInfo.getPattern(), (Logger)this.log);
            }
            catch (Exception e) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.CONTENT_BASED.toString() + " non riuscita: " + e.getMessage(), (Throwable)e);
            }
        }
        if (ModalitaIdentificazione.INPUT_BASED.equals((Object)mappingInfo.getModalitaIdentificazione())) {
            if (headerIntegrazioneRichiestaSoggettoMittente == null) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.HEADER_BASED.toString() + " non riuscita: non esistono informazioni di integrazione");
            }
            if (TIPO_MITTENTE.equals(oggetto)) {
                if (headerIntegrazioneRichiestaSoggettoMittente.getTipo() == null) {
                    throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.HEADER_BASED.toString() + " non riuscita: non esistono informazioni di integrazione (TipoMittente)");
                }
                return headerIntegrazioneRichiestaSoggettoMittente.getTipo();
            }
            if (NOME_MITTENTE.equals(oggetto)) {
                if (headerIntegrazioneRichiestaSoggettoMittente.getNome() == null) {
                    throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.HEADER_BASED.toString() + " non riuscita: non esistono informazioni di integrazione (Mittente)");
                }
                return headerIntegrazioneRichiestaSoggettoMittente.getNome();
            }
            throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.HEADER_BASED.toString() + " non supportata per l'oggetto " + oggetto);
        }
        if (ModalitaIdentificazione.HEADER_BASED.equals((Object)mappingInfo.getModalitaIdentificazione())) {
            if (mappingInfo.getName() == null) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.HEADER_BASED.toString() + " non riuscita: nome header nell'omonima proprieta' con suffisso '.name' non fornito");
            }
            String value = this.urlProtocolContext.getHeaderFirstValue(mappingInfo.getName());
            if (value == null) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.HEADER_BASED.toString() + " non riuscita: header di trasporto con nome [" + mappingInfo.getName() + "] non trovato");
            }
            return value;
        }
        if (ModalitaIdentificazione.IDENTITY_BASED.equals((Object)mappingInfo.getModalitaIdentificazione())) {
            if (identity == null) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.IDENTITY_BASED.toString() + " non riuscita: Identity non fornita");
            }
            String id = null;
            if (identity.getPrincipal() != null) {
                id = identity.getPrincipal();
            } else if (identity.getSubject() != null) {
                id = identity.getSubject();
            } else if (identity.getUsername() != null) {
                id = identity.getUsername();
            }
            if (id != null) {
                if (mappingInfo.getPattern() != null) {
                    try {
                        String tmp = RegularExpressionEngine.getStringMatchPattern((String)id, (String)mappingInfo.getPattern());
                        if (tmp != null && !"".equals(tmp.trim())) {
                            return tmp.trim();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return id;
            }
            throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.IDENTITY_BASED.toString() + " non riuscita: Identity fornita non contiene una identita");
        }
        return null;
    }
}

