/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.mapping;

import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.rest.AccordoServizioWrapper;
import org.openspcoop2.core.registry.wsdl.AccordoServizioWrapperUtilities;
import org.openspcoop2.core.registry.wsdl.WSDLValidatorConfig;
import org.openspcoop2.message.MessageUtils;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.rest.RestUtilities;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.protocol.engine.constants.ModalitaIdentificazioneAzione;
import org.openspcoop2.protocol.engine.mapping.IdentificazioneDinamicaException;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.InformationApiSource;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.PorteNamingUtils;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.rest.api.ApiOperation;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.xml.AbstractXPathExpressionEngine;
import org.openspcoop2.utils.xml2json.JsonXmlPathExpressionEngine;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class OperationFinder {
    private OperationFinder() {
    }

    private static String getPrefixIdentificazione(ModalitaIdentificazioneAzione modalitaIdentificazione) {
        return "Identificazione '" + modalitaIdentificazione.getValue() + "' ";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getAzione(RegistroServiziManager registroServiziManager, TransportRequestContext transportContext, RequestInfo requestInfo, OpenSPCoop2Message message, OpenSPCoop2MessageSoapStreamReader soapStreamReader, IDSoggetto soggettoErogatore, IDServizio idServizio, boolean readFirstHeaderIntegrazione, String azioneHeaderIntegrazione, IProtocolFactory<?> protocolFactory, ModalitaIdentificazioneAzione modalitaIdentificazione, String pattern, boolean forceRegistryBased, boolean forcePluginBased, Logger log, boolean portaApplicativa, boolean bufferMessageReadOnly, String idTransazione, WSDLValidatorConfig config) throws DriverConfigurazioneException, IdentificazioneDinamicaException {
        try {
            if (soggettoErogatore != null) {
                // empty if block
            }
            boolean registryBased = false;
            boolean pluginBased = false;
            String azione = null;
            Exception eAzione = null;
            try {
                if (ModalitaIdentificazioneAzione.STATIC.equals(modalitaIdentificazione)) {
                    azione = idServizio.getAzione();
                } else if (readFirstHeaderIntegrazione && azioneHeaderIntegrazione != null) {
                    azione = azioneHeaderIntegrazione;
                } else if (ModalitaIdentificazioneAzione.URL_BASED.equals(modalitaIdentificazione)) {
                    String urlInvocazionePD = transportContext.getUrlInvocazione_formBased();
                    azione = RegularExpressionEngine.getStringFindPattern((String)urlInvocazionePD, (String)pattern);
                    if (ServiceBinding.REST.equals((Object)message.getServiceBinding())) {
                        throw new DriverConfigurazioneNotFound(OperationFinder.getPrefixIdentificazione(modalitaIdentificazione) + "non supportata per il service binding '" + ServiceBinding.REST + "'");
                    }
                } else if (ModalitaIdentificazioneAzione.HEADER_BASED.equals(modalitaIdentificazione)) {
                    azione = transportContext.getHeaderFirstValue(pattern);
                } else if (ModalitaIdentificazioneAzione.CONTENT_BASED.equals(modalitaIdentificazione)) {
                    if (message == null) {
                        throw new DriverConfigurazioneNotFound("Messaggio non fornito");
                    }
                    XPathExpressionEngine xPathEngine = null;
                    Element element = null;
                    String elementJson = null;
                    boolean checkSoapBodyEmpty = false;
                    if (message != null) {
                        element = MessageUtils.getContentElement((OpenSPCoop2Message)message, (boolean)checkSoapBodyEmpty, (boolean)bufferMessageReadOnly, (String)idTransazione);
                        elementJson = MessageUtils.getContentString((OpenSPCoop2Message)message, (boolean)bufferMessageReadOnly, (String)idTransazione);
                    }
                    if (element != null) {
                        xPathEngine = new XPathExpressionEngine(message.getFactory());
                        azione = AbstractXPathExpressionEngine.extractAndConvertResultAsString((Element)element, (AbstractXPathExpressionEngine)xPathEngine, (String)pattern, (Logger)log);
                    } else {
                        if (elementJson == null) throw new DriverConfigurazioneNotFound(OperationFinder.getPrefixIdentificazione(modalitaIdentificazione) + "non supportata per il message-type '" + message.getMessageType() + "'");
                        azione = JsonXmlPathExpressionEngine.extractAndConvertResultAsString(elementJson, (String)pattern, (Logger)log);
                    }
                } else if (ModalitaIdentificazioneAzione.INPUT_BASED.equals(modalitaIdentificazione)) {
                    if (azioneHeaderIntegrazione == null) throw new DriverConfigurazioneNotFound("Azione non indicata negli header di integrazione");
                    azione = azioneHeaderIntegrazione;
                } else if (ModalitaIdentificazioneAzione.SOAP_ACTION_BASED.equals(modalitaIdentificazione)) {
                    org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper wrapper;
                    if (message != null && ServiceBinding.REST.equals((Object)message.getServiceBinding())) {
                        throw new DriverConfigurazioneNotFound(OperationFinder.getPrefixIdentificazione(modalitaIdentificazione) + "non supportata per il service binding '" + ServiceBinding.REST + "'");
                    }
                    azione = message != null ? message.castAsSoap().getSoapAction() : OperationFinder.getSoapAction(transportContext);
                    String azioneNonRipulita = azione;
                    if (azione != null) {
                        if ((azione = azione.trim()).startsWith("\"")) {
                            azione = azione.substring(1);
                        }
                        if (azione.endsWith("\"")) {
                            azione = azione.substring(0, azione.length() - 1);
                        }
                    }
                    if ((azioneNonRipulita != null || azione != null) && (wrapper = registroServiziManager.getWsdlAccordoServizio(idServizio, InformationApiSource.SAFE_SPECIFIC_REGISTRY, false, false, requestInfo)) != null) {
                        block5: for (int i = 0; i < wrapper.sizePortTypeList(); ++i) {
                            PortType pt = wrapper.getPortType(i);
                            if (wrapper.getNomePortType() != null && !pt.getNome().equals(wrapper.getNomePortType())) continue;
                            for (int j = 0; j < pt.sizeAzioneList(); ++j) {
                                Operation op = pt.getAzione(j);
                                if ((azioneNonRipulita == null || !azioneNonRipulita.equals(op.getSoapAction())) && (azione == null || !azione.equals(op.getSoapAction()))) continue;
                                azione = op.getNome();
                                continue block5;
                            }
                        }
                    }
                    if (azione != null && "".equals(azione)) {
                        azione = null;
                        throw new DriverConfigurazioneNotFound("SoapAction vuota (" + message.castAsSoap().getSoapAction() + ") non \u00e8 utilizzabile con una identificazione '" + ModalitaIdentificazioneAzione.SOAP_ACTION_BASED.getValue() + "'");
                    }
                } else if (ModalitaIdentificazioneAzione.INTERFACE_BASED.equals(modalitaIdentificazione)) {
                    registryBased = true;
                    OperationFinder.checkIDServizioPerRiconoscimentoAzione(idServizio, modalitaIdentificazione);
                    org.openspcoop2.core.registry.constants.ServiceBinding serviceBinding = registroServiziManager.getServiceBinding(idServizio, requestInfo);
                    azione = org.openspcoop2.core.registry.constants.ServiceBinding.SOAP.equals((Object)serviceBinding) ? OperationFinder.searchOperationByWsdlInRequestMessage(message, soapStreamReader, requestInfo, registroServiziManager, idServizio, log, config) : OperationFinder.searchOperationByRestInRequestMessage(transportContext, requestInfo, registroServiziManager, idServizio, log, protocolFactory, portaApplicativa);
                } else if (ModalitaIdentificazioneAzione.PROTOCOL_BASED.equals(modalitaIdentificazione)) {
                    pluginBased = true;
                    if (idServizio.getAzione() != null) {
                        azione = idServizio.getAzione();
                    } else {
                        OpenSPCoop2Message msgAnalizyProtocol = message;
                        if (message == null && soapStreamReader != null) {
                            msgAnalizyProtocol = soapStreamReader.getHeader_OpenSPCoop2Message();
                        }
                        if (msgAnalizyProtocol == null) {
                            throw new DriverConfigurazioneNotFound("Messaggio non fornito");
                        }
                        Busta busta = protocolFactory.createValidazioneSintattica(null).getBusta_senzaControlli(msgAnalizyProtocol);
                        if (busta != null) {
                            azione = busta.getAzione();
                        }
                    }
                }
            }
            catch (Exception e) {
                eAzione = e;
            }
            if (azione == null && forceRegistryBased && !registryBased) {
                azione = OperationFinder.getActionByInterface(log, transportContext, idServizio, modalitaIdentificazione, registroServiziManager, requestInfo, message, soapStreamReader, protocolFactory, portaApplicativa, config);
            }
            if (azione == null && forcePluginBased && !pluginBased) {
                azione = OperationFinder.getActionByPlugin(log, idServizio, message, soapStreamReader, protocolFactory);
            }
            if (azione != null || eAzione == null) return azione;
            throw new IdentificazioneDinamicaException(eAzione.getMessage(), eAzione);
        }
        catch (IdentificazioneDinamicaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    private static String getSoapAction(TransportRequestContext transportContext) {
        String azione = null;
        try {
            azione = SoapUtils.getSoapAction((TransportRequestContext)transportContext, (MessageType)MessageType.SOAP_11, (String)transportContext.getContentType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (azione == null) {
            try {
                azione = SoapUtils.getSoapAction((TransportRequestContext)transportContext, (MessageType)MessageType.SOAP_12, (String)transportContext.getContentType());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return azione;
    }

    private static String getActionByInterface(Logger log, TransportRequestContext transportContext, IDServizio idServizio, ModalitaIdentificazioneAzione modalitaIdentificazione, RegistroServiziManager registroServiziManager, RequestInfo requestInfo, OpenSPCoop2Message message, OpenSPCoop2MessageSoapStreamReader soapStreamReader, IProtocolFactory<?> protocolFactory, boolean portaApplicativa, WSDLValidatorConfig config) {
        String azione = null;
        try {
            OperationFinder.checkIDServizioPerRiconoscimentoAzione(idServizio, modalitaIdentificazione);
            org.openspcoop2.core.registry.constants.ServiceBinding serviceBinding = registroServiziManager.getServiceBinding(idServizio, requestInfo);
            azione = org.openspcoop2.core.registry.constants.ServiceBinding.SOAP.equals((Object)serviceBinding) ? OperationFinder.searchOperationByWsdlInRequestMessage(message, soapStreamReader, requestInfo, registroServiziManager, idServizio, log, config) : OperationFinder.searchOperationByRestInRequestMessage(transportContext, requestInfo, registroServiziManager, idServizio, log, protocolFactory, portaApplicativa);
        }
        catch (Exception eForceRegistry) {
            log.debug("Riconoscimento forzato dell'azione non riuscito: " + eForceRegistry.getMessage(), (Throwable)eForceRegistry);
        }
        return azione;
    }

    public static String searchOperationByWsdlInRequestMessage(OpenSPCoop2Message msg, OpenSPCoop2MessageSoapStreamReader soapStreamReaderParam, RequestInfo requestInfo, RegistroServiziManager registroServiziReader, IDServizio idServizio, Logger log, WSDLValidatorConfig config) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return OperationFinder.searchOperationByWsdl(true, msg, soapStreamReaderParam, requestInfo, registroServiziReader, idServizio, log, config);
    }

    private static String searchOperationByWsdl(boolean isRichiesta, OpenSPCoop2Message msg, OpenSPCoop2MessageSoapStreamReader soapStreamReaderParam, RequestInfo requestInfo, RegistroServiziManager registroServiziReader, IDServizio idServizio, Logger log, WSDLValidatorConfig config) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper wrapper = registroServiziReader.getWsdlAccordoServizio(idServizio, InformationApiSource.SAFE_SPECIFIC_REGISTRY, false, false, requestInfo);
        AccordoServizioWrapperUtilities wrapperUtilities = new AccordoServizioWrapperUtilities(log, wrapper);
        return wrapperUtilities.searchOperationName(isRichiesta, wrapper.getNomePortType(), msg, soapStreamReaderParam, config);
    }

    public static String searchOperationByRestInRequestMessage(TransportRequestContext transportContext, RequestInfo requestInfo, RegistroServiziManager registroServiziReader, IDServizio idServizio, Logger log, IProtocolFactory<?> protocolFactory, boolean portaApplicativa) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String normalizedInterfaceName = null;
        try {
            if (transportContext.getInterfaceName() != null) {
                PorteNamingUtils namingUtils = new PorteNamingUtils(protocolFactory);
                normalizedInterfaceName = portaApplicativa ? namingUtils.normalizePA(transportContext.getInterfaceName()) : namingUtils.normalizePD(transportContext.getInterfaceName());
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
        String path = RestUtilities.getUrlWithoutInterface((TransportRequestContext)transportContext, normalizedInterfaceName);
        HttpRequestMethod httpMethod = HttpRequestMethod.valueOf((String)transportContext.getRequestType());
        try {
            AccordoServizioWrapper wrapper = registroServiziReader.getRestAccordoServizio(idServizio, InformationApiSource.SAFE_SPECIFIC_REGISTRY, false, false, false, requestInfo);
            ApiOperation op = wrapper.getApi().findOperation(httpMethod, path);
            if (op != null) {
                for (int i = 0; i < wrapper.getAccordoServizio().sizeResourceList(); ++i) {
                    Resource r = wrapper.getAccordoServizio().getResource(i);
                    if (r.getMethod() != null ? op.getHttpMethod() == null || !r.getMethod().name().equals(op.getHttpMethod().name()) : op.getHttpMethod() != null) continue;
                    if (r.getPath() == null) {
                        if (op.getPath() != null) {
                            continue;
                        }
                    } else {
                        String rPath = r.getPath();
                        String opPath = op.getPath();
                        if (rPath != null && rPath.length() > 1 && rPath.endsWith("/")) {
                            rPath = rPath.substring(0, rPath.length() - 1);
                        }
                        if (opPath != null && opPath.length() > 1 && opPath.endsWith("/")) {
                            opPath = opPath.substring(0, opPath.length() - 1);
                        }
                        if (rPath != null && !rPath.equals(opPath)) continue;
                    }
                    return r.getNome();
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static String getActionByPlugin(Logger log, IDServizio idServizio, OpenSPCoop2Message message, OpenSPCoop2MessageSoapStreamReader soapStreamReader, IProtocolFactory<?> protocolFactory) {
        String azione = null;
        try {
            if (idServizio.getAzione() != null) {
                azione = idServizio.getAzione();
            } else {
                Busta busta;
                OpenSPCoop2Message msgAnalizyProtocol = message;
                if (message == null && soapStreamReader != null) {
                    msgAnalizyProtocol = soapStreamReader.getHeader_OpenSPCoop2Message();
                }
                if (msgAnalizyProtocol != null && (busta = protocolFactory.createValidazioneSintattica(null).getBusta_senzaControlli(msgAnalizyProtocol)) != null) {
                    azione = busta.getAzione();
                }
            }
        }
        catch (Exception eForcePlugin) {
            log.debug("Riconoscimento forzato dell'azione non riuscito: " + eForcePlugin.getMessage(), (Throwable)eForcePlugin);
        }
        return azione;
    }

    private static void checkIDServizioPerRiconoscimentoAzione(IDServizio idServizio, ModalitaIdentificazioneAzione modalitaIdentificazione) throws DriverConfigurazioneException {
        String suffixError = " (necessari per procedere con la modalit\u00e0 di identificazione " + modalitaIdentificazione + " dell'azione)";
        if (idServizio == null) {
            throw new DriverConfigurazioneException("Dati del servizio non trovati" + suffixError);
        }
        if (idServizio.getSoggettoErogatore() == null) {
            throw new DriverConfigurazioneException("Dati del soggetto erogatore del servizio non trovati" + suffixError);
        }
        if (idServizio.getSoggettoErogatore().getTipo() == null) {
            throw new DriverConfigurazioneException("Tipo soggetto erogatore del servizio non trovato" + suffixError);
        }
        if (idServizio.getSoggettoErogatore().getNome() == null) {
            throw new DriverConfigurazioneException("Nome soggetto erogatore del servizio non trovato" + suffixError);
        }
        if (idServizio.getTipo() == null) {
            throw new DriverConfigurazioneException("Tipo servizio non trovato" + suffixError);
        }
        if (idServizio.getNome() == null) {
            throw new DriverConfigurazioneException("Nome servizio non trovato" + suffixError);
        }
        if (idServizio.getVersione() == null) {
            throw new DriverConfigurazioneException("Versione servizio non trovata" + suffixError);
        }
    }
}

