/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.engine.utils.ResultPorta;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBOggettiInUsoUtils_accordiParteSpecifica {
    private static boolean isAccordoServizioParteSpecificaInUso(Connection con, String tipoDB, long idAccordoServizioParteSpecifica, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, String nomeMetodo, List<IDPortaDelegata> nomePDGenerateAutomaticamente, List<IDPortaApplicativa> nomePAGenerateAutomaticamente, boolean normalizeObjectIds) throws UtilsException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        PreparedStatement stmt2 = null;
        ResultSet risultato2 = null;
        try {
            Object l;
            IDPortaDelegata idPD;
            ResultPorta resultPorta;
            IDPortaApplicativa idPA;
            String nomePorta;
            boolean isInUso = false;
            List<String> porteApplicative_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE);
            List<String> porteDelegate_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE);
            List<String> fruitori_list = whereIsInUso.get(ErrorsHandlerCostant.POSSIEDE_FRUITORI);
            List<String> servizioComponente_list = whereIsInUso.get(ErrorsHandlerCostant.IS_SERVIZIO_COMPONENTE_IN_ACCORDI);
            List<String> mappingErogazionePA_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA);
            List<String> mappingFruizionePD_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_FRUIZIONE_PD);
            List<String> utenti_list = whereIsInUso.get(ErrorsHandlerCostant.UTENTE);
            List<String> ct_list = whereIsInUso.get(ErrorsHandlerCostant.CONTROLLO_TRAFFICO);
            List<String> allarme_list = whereIsInUso.get(ErrorsHandlerCostant.ALLARMI);
            if (porteApplicative_list == null) {
                porteApplicative_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE, porteApplicative_list);
            }
            if (porteDelegate_list == null) {
                porteDelegate_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE, porteDelegate_list);
            }
            if (fruitori_list == null) {
                fruitori_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.POSSIEDE_FRUITORI, fruitori_list);
            }
            if (servizioComponente_list == null) {
                servizioComponente_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IS_SERVIZIO_COMPONENTE_IN_ACCORDI, servizioComponente_list);
            }
            if (mappingErogazionePA_list == null) {
                mappingErogazionePA_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA, mappingErogazionePA_list);
            }
            if (mappingFruizionePD_list == null) {
                mappingFruizionePD_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_FRUIZIONE_PD, mappingFruizionePD_list);
            }
            if (utenti_list == null) {
                utenti_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.UTENTE, utenti_list);
            }
            if (ct_list == null) {
                ct_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.CONTROLLO_TRAFFICO, ct_list);
            }
            if (allarme_list == null) {
                allarme_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.ALLARMI, allarme_list);
            }
            String tipoServizio = null;
            String nomeServizio = null;
            String tipoSoggetto = null;
            String nomeSoggetto = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            sqlQueryObject.addWhereCondition("servizi.id=?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setLong(index++, idAccordoServizioParteSpecifica);
            risultato = stmt.executeQuery();
            if (!risultato.next()) {
                throw new UtilsException("Accordo con id [" + idAccordoServizioParteSpecifica + "] non trovato");
            }
            tipoServizio = risultato.getString("tipo_servizio");
            nomeServizio = risultato.getString("nome_servizio");
            int versioneServizio = risultato.getInt("versione_servizio");
            tipoSoggetto = risultato.getString("tipo_soggetto");
            nomeSoggetto = risultato.getString("nome_soggetto");
            versioneServizio = risultato.getInt("versione_servizio");
            risultato.close();
            stmt.close();
            long idSoggetto = DBUtils.getIdSoggetto((String)nomeSoggetto, (String)tipoSoggetto, (Connection)con, (String)tipoDB);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition(false, new String[]{"id_servizio = ?", "tipo_servizio = ? AND servizio = ? AND versione_servizio = ?"});
            sqlQueryObject.addWhereCondition(false, new String[]{"id_soggetto = ?", "id_soggetto_virtuale = ?", "tipo_soggetto_virtuale = ? AND nome_soggetto_virtuale = ?"});
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            index = 1;
            stmt.setLong(index++, idAccordoServizioParteSpecifica);
            stmt.setString(index++, tipoServizio);
            stmt.setString(index++, nomeServizio);
            stmt.setInt(index++, versioneServizio);
            stmt.setLong(index++, idSoggetto);
            stmt.setLong(index++, idSoggetto);
            stmt.setString(index++, tipoSoggetto);
            stmt.setString(index++, nomeSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                nomePorta = risultato.getString("nome_porta");
                idPA = new IDPortaApplicativa();
                idPA.setNome(nomePorta);
                if (nomePAGenerateAutomaticamente == null || nomePAGenerateAutomaticamente.contains(idPA)) continue;
                resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nomePorta, tipoDB, con, normalizeObjectIds);
                if (resultPorta.mapping) {
                    mappingErogazionePA_list.add(resultPorta.label);
                } else {
                    porteApplicative_list.add(resultPorta.label);
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition(false, new String[]{"id_servizio = ?", "tipo_servizio = ? AND nome_servizio = ? AND versione_servizio = ?"});
            sqlQueryObject.addWhereCondition(false, new String[]{"id_soggetto_erogatore = ?", "tipo_soggetto_erogatore = ? AND nome_soggetto_erogatore = ?"});
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            index = 1;
            stmt.setLong(index++, idAccordoServizioParteSpecifica);
            stmt.setString(index++, tipoServizio);
            stmt.setString(index++, nomeServizio);
            stmt.setInt(index++, versioneServizio);
            stmt.setLong(index++, idSoggetto);
            stmt.setString(index++, tipoSoggetto);
            stmt.setString(index++, nomeSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                nomePorta = risultato.getString("nome_porta");
                idPD = new IDPortaDelegata();
                idPD.setNome(nomePorta);
                if (nomePDGenerateAutomaticamente == null || nomePDGenerateAutomaticamente.contains(idPD)) continue;
                resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nomePorta, tipoDB, con, normalizeObjectIds);
                if (resultPorta.mapping) {
                    mappingFruizionePD_list.add(resultPorta.label);
                } else {
                    porteDelegate_list.add(resultPorta.label);
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_erogazione_pa");
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("porte_applicative.nome_porta");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addWhereCondition("mapping_erogazione_pa.id_erogazione = ?");
            sqlQueryObject.addWhereCondition("mapping_erogazione_pa.id_porta = porte_applicative.id");
            sqlQueryObject.addWhereCondition("porte_applicative.id_soggetto = soggetti.id");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoServizioParteSpecifica);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                nomePorta = risultato.getString("nome_porta");
                idPA = new IDPortaApplicativa();
                idPA.setNome(nomePorta);
                if (nomePAGenerateAutomaticamente == null || nomePAGenerateAutomaticamente.contains(idPA)) continue;
                resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nomePorta, tipoDB, con, normalizeObjectIds);
                if (resultPorta.mapping) {
                    l = resultPorta.label;
                    if (!mappingErogazionePA_list.contains(l)) {
                        mappingErogazionePA_list.add((String)l);
                    }
                } else {
                    l = resultPorta.label;
                    if (!porteApplicative_list.contains(l)) {
                        porteApplicative_list.add((String)l);
                    }
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("mapping_fruizione_pd");
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("porte_delegate.nome_porta");
            sqlQueryObject.addWhereCondition("soggetti.id = servizi_fruitori.id_soggetto");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("mapping_fruizione_pd.id_fruizione = servizi_fruitori.id");
            sqlQueryObject.addWhereCondition("mapping_fruizione_pd.id_porta = porte_delegate.id");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoServizioParteSpecifica);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                nomePorta = risultato.getString("nome_porta");
                idPD = new IDPortaDelegata();
                idPD.setNome(nomePorta);
                if (nomePDGenerateAutomaticamente == null || nomePDGenerateAutomaticamente.contains(idPD)) continue;
                resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nomePorta, tipoDB, con, normalizeObjectIds);
                if (resultPorta.mapping) {
                    l = resultPorta.label;
                    if (!mappingFruizionePD_list.contains(l)) {
                        mappingFruizionePD_list.add((String)l);
                    }
                } else {
                    l = resultPorta.label;
                    if (!porteDelegate_list.contains(l)) {
                        porteDelegate_list.add((String)l);
                    }
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            if (mappingFruizionePD_list.isEmpty()) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addWhereCondition("soggetti.id = servizi_fruitori.id_soggetto");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idAccordoServizioParteSpecifica);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String tipoSoggettoFruitore = risultato.getString("tipo_soggetto");
                    String nomeSoggettoFruitore = risultato.getString("nome_soggetto");
                    boolean usedForPD = false;
                    if (nomePDGenerateAutomaticamente != null) {
                        for (IDPortaDelegata idPD2 : nomePDGenerateAutomaticamente) {
                            IDSoggetto soggettoFruitore;
                            if (idPD2.getIdentificativiFruizione() == null || idPD2.getIdentificativiFruizione().getSoggettoFruitore() == null || !(soggettoFruitore = new IDSoggetto(tipoSoggettoFruitore, nomeSoggettoFruitore)).equals((Object)idPD2.getIdentificativiFruizione().getSoggettoFruitore())) continue;
                            usedForPD = true;
                            break;
                        }
                    }
                    if (usedForPD) continue;
                    if (normalizeObjectIds) {
                        fruitori_list.add(NamingUtils.getLabelSoggetto(new IDSoggetto(tipoSoggettoFruitore, nomeSoggettoFruitore)));
                    } else {
                        fruitori_list.add(tipoSoggettoFruitore + "/" + nomeSoggettoFruitore);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("acc_serv_componenti");
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("accordi.nome");
            sqlQueryObject.addSelectField("accordi.versione");
            sqlQueryObject.addSelectField("accordi.id_referente");
            sqlQueryObject.addWhereCondition("acc_serv_componenti.id_servizio_composto = acc_serv_composti.id");
            sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("acc_serv_componenti.id_servizio_componente = ?");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoServizioParteSpecifica);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                String nomeAccordo = risultato.getString("nome");
                int versione = risultato.getInt("versione");
                long idReferente = risultato.getLong("id_referente");
                IDSoggetto idReferenteObject = null;
                if (idReferente > 0L) {
                    ISQLQueryObject sqlQueryObjectReferente = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObjectReferente.addFromTable("soggetti");
                    sqlQueryObjectReferente.addSelectField("*");
                    sqlQueryObjectReferente.addWhereCondition("id=?");
                    sqlQueryObjectReferente.setANDLogicOperator(true);
                    String queryStringReferente = sqlQueryObjectReferente.createSQLQuery();
                    stmt2 = con.prepareStatement(queryStringReferente);
                    stmt2.setLong(1, idReferente);
                    risultato2 = stmt2.executeQuery();
                    if (risultato2.next()) {
                        idReferenteObject = new IDSoggetto();
                        idReferenteObject.setTipo(risultato2.getString("tipo_soggetto"));
                        idReferenteObject.setNome(risultato2.getString("nome_soggetto"));
                    }
                    risultato2.close();
                    risultato2 = null;
                    stmt2.close();
                    stmt2 = null;
                }
                if (normalizeObjectIds && idReferenteObject != null) {
                    String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idReferenteObject.getTipo());
                    IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromValues(nomeAccordo, idReferenteObject, Integer.valueOf(versione));
                    servizioComponente_list.add(DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelAccordoServizioParteComune(protocollo, idAccordo));
                    continue;
                }
                StringBuilder bf = new StringBuilder();
                bf.append(idReferenteObject != null ? idReferenteObject.getTipo() : "?");
                bf.append("/");
                bf.append(idReferenteObject != null ? idReferenteObject.getNome() : "?");
                bf.append(":");
                bf.append(nomeAccordo);
                if (idReferente > 0L) {
                    bf.append(":");
                    bf.append(versione);
                }
                servizioComponente_list.add(bf.toString());
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addFromTable("users_servizi");
            sqlQueryObject.addSelectField("login");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("users_servizi.id_servizio = ?");
            sqlQueryObject.addWhereCondition("users.id = users_servizi.id_utente");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoServizioParteSpecifica);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                utenti_list.add(risultato.getString("login"));
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("versione_servizio");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("servizi.id=?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoServizioParteSpecifica);
            risultato = stmt.executeQuery();
            IDServizio idServizio = null;
            if (risultato.next()) {
                idServizio = DBOggettiInUsoUtils_accordiParteSpecifica.readIdServizio(risultato);
            }
            risultato.close();
            stmt.close();
            if (idServizio != null) {
                int max = 2;
                if (!CostantiDB.isAllarmiEnabled()) {
                    max = 1;
                }
                for (int i = 0; i < max; ++i) {
                    String tabella = "ct_active_policy";
                    String identificativo_column = "active_policy_id";
                    String alias_column = "policy_alias";
                    List<String> list = ct_list;
                    String oggetto = "Policy";
                    if (i == 1) {
                        tabella = "allarmi";
                        identificativo_column = "nome";
                        alias_column = "alias";
                        list = allarme_list;
                        oggetto = "Allarme";
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable(tabella);
                    sqlQueryObject.addSelectField(identificativo_column);
                    sqlQueryObject.addSelectField(alias_column);
                    sqlQueryObject.addSelectField("filtro_ruolo");
                    sqlQueryObject.addSelectField("filtro_porta");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addWhereCondition(tabella + ".filtro_tipo_erogatore = ?");
                    sqlQueryObject.addWhereCondition(tabella + ".filtro_nome_erogatore = ?");
                    sqlQueryObject.addWhereCondition(tabella + ".filtro_tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition(tabella + ".filtro_nome_servizio = ?");
                    sqlQueryObject.addWhereCondition(tabella + ".filtro_versione_servizio = ?");
                    sqlQueryObject.addOrderBy("filtro_ruolo");
                    sqlQueryObject.addOrderBy("filtro_porta");
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    index = 1;
                    stmt.setString(index++, idServizio.getSoggettoErogatore().getTipo());
                    stmt.setString(index++, idServizio.getSoggettoErogatore().getNome());
                    stmt.setString(index++, idServizio.getTipo());
                    stmt.setString(index++, idServizio.getNome());
                    stmt.setInt(index++, idServizio.getVersione());
                    risultato = stmt.executeQuery();
                    while (risultato.next()) {
                        String alias = risultato.getString(alias_column);
                        if (alias == null || "".equals(alias)) {
                            alias = risultato.getString(identificativo_column);
                        }
                        String nomePorta2 = risultato.getString("filtro_porta");
                        String filtro_ruolo = risultato.getString("filtro_ruolo");
                        if (nomePorta2 != null) {
                            ResultPorta resultPorta2;
                            String tipo = null;
                            String label = null;
                            if ("delegata".equals(filtro_ruolo)) {
                                try {
                                    resultPorta2 = DBOggettiInUsoUtils.formatPortaDelegata(nomePorta2, tipoDB, con, normalizeObjectIds);
                                    if (resultPorta2.mapping) {
                                        label = "Fruizione di Servizio " + resultPorta2.label;
                                    }
                                }
                                catch (Exception e) {
                                    tipo = "Outbound";
                                }
                            } else if ("applicativa".equals(filtro_ruolo)) {
                                try {
                                    resultPorta2 = DBOggettiInUsoUtils.formatPortaApplicativa(nomePorta2, tipoDB, con, normalizeObjectIds);
                                    if (resultPorta2.mapping) {
                                        label = "Erogazione di Servizio " + resultPorta2.label;
                                    }
                                }
                                catch (Exception e) {
                                    tipo = "Inbound";
                                }
                            } else {
                                tipo = filtro_ruolo;
                            }
                            if (label == null) {
                                list.add(oggetto + " '" + alias + "' attiva nella porta '" + tipo + "' '" + nomePorta2 + "' ");
                            } else {
                                list.add(oggetto + " '" + alias + "' attiva nella " + label);
                            }
                        } else {
                            list.add(oggetto + " '" + alias + "'");
                        }
                        isInUso = true;
                    }
                    risultato.close();
                    stmt.close();
                }
            }
            bl = isInUso;
        }
        catch (Exception se) {
            try {
                throw new UtilsException("[DBOggettiInUsoUtils::" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato2, stmt2);
                JDBCUtilities.closeResources(risultato, stmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato2, (PreparedStatement)stmt2);
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        return bl;
    }

    private static IDServizio readIdServizio(ResultSet risultato) throws SQLException {
        IDServizio idServizio = new IDServizio();
        idServizio.setTipo(risultato.getString("tipo_servizio"));
        idServizio.setNome(risultato.getString("nome_servizio"));
        idServizio.setVersione(Integer.valueOf(risultato.getInt("versione_servizio")));
        idServizio.setSoggettoErogatore(new IDSoggetto(risultato.getString("tipo_soggetto"), risultato.getString("nome_soggetto")));
        return idServizio;
    }

    protected static boolean isAccordoServizioParteSpecificaInUso(Connection con, String tipoDB, IDServizio idServizio, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, List<IDPortaDelegata> nomePDGenerateAutomaticamente, List<IDPortaApplicativa> nomePAGenerateAutomaticamente, boolean normalizeObjectIds) throws UtilsException {
        String nomeMetodo = "isAccordoServizioParteSpecificaInUso(IDServizio)";
        long idAccordoServizioParteSpecifica = -1L;
        try {
            idAccordoServizioParteSpecifica = DBUtils.getIdAccordoServizioParteSpecifica((IDServizio)idServizio, (Connection)con, (String)tipoDB);
            if (idAccordoServizioParteSpecifica <= 0L) {
                throw new UtilsException("Accordi di Servizio Parte Specifica con id [" + idServizio.toString() + "] non trovato");
            }
        }
        catch (Exception se) {
            throw new UtilsException("[DBOggettiInUsoUtils::" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
        }
        return DBOggettiInUsoUtils_accordiParteSpecifica.isAccordoServizioParteSpecificaInUso(con, tipoDB, idAccordoServizioParteSpecifica, whereIsInUso, nomeMetodo, nomePDGenerateAutomaticamente, nomePAGenerateAutomaticamente, normalizeObjectIds);
    }

    protected static String toString(IDServizio idServizio, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, boolean normalizeObjectIds, String oggetto) {
        StringBuilder bf = new StringBuilder();
        if (normalizeObjectIds) {
            try {
                String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idServizio.getSoggettoErogatore().getTipo());
                String labelAccordo = DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelAccordoServizioParteSpecifica(protocollo, idServizio);
                bf.append(labelAccordo);
            }
            catch (Exception e) {
                bf.append(idServizio.toString());
            }
        } else {
            bf.append(idServizio.toString());
        }
        Set<ErrorsHandlerCostant> keys = whereIsInUso.keySet();
        Object msg = oggetto + " '" + bf.toString() + "' non eliminabile perch&egrave; :" + separator;
        if (!prefix) {
            msg = "";
        }
        String separatorCategorie = "";
        if (whereIsInUso.size() > 1) {
            separatorCategorie = separator;
        }
        block13: for (ErrorsHandlerCostant key : keys) {
            List<String> messages = whereIsInUso.get(key);
            if (messages != null && messages.size() > 0) {
                msg = (String)msg + separatorCategorie;
            }
            switch (key) {
                case IN_USO_IN_PORTE_DELEGATE: {
                    if (messages == null || messages.size() <= 0) continue block13;
                    msg = (String)msg + "in uso in Porte Delegate: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block13;
                }
                case IN_USO_IN_PORTE_APPLICATIVE: {
                    if (messages == null || messages.size() <= 0) continue block13;
                    msg = (String)msg + "in uso in Porte Applicative: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block13;
                }
                case POSSIEDE_FRUITORI: {
                    if (messages == null || messages.size() <= 0) continue block13;
                    msg = (String)msg + "fruito dai soggetti: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block13;
                }
                case IS_SERVIZIO_COMPONENTE_IN_ACCORDI: {
                    if (messages == null || messages.size() <= 0) continue block13;
                    msg = (String)msg + "associato come servizio componente in API di Servizi Composti: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block13;
                }
                case IN_USO_IN_MAPPING_EROGAZIONE_PA: {
                    if (messages == null || messages.size() <= 0) continue block13;
                    msg = (String)msg + "utilizzato nelle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block13;
                }
                case IN_USO_IN_MAPPING_FRUIZIONE_PD: {
                    if (messages == null || messages.size() <= 0) continue block13;
                    msg = (String)msg + "utilizzato nelle Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block13;
                }
                case UTENTE: {
                    if (messages == null || messages.size() <= 0) continue block13;
                    msg = (String)msg + "associato ad Utenti: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block13;
                }
                case CONTROLLO_TRAFFICO: {
                    if (messages == null || messages.size() <= 0) continue block13;
                    msg = (String)msg + "utilizzato in policy di Rate Limiting: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block13;
                }
                case ALLARMI: {
                    if (messages == null || messages.size() <= 0) continue block13;
                    msg = (String)msg + "utilizzato in Allarmi: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block13;
                }
            }
            msg = (String)msg + "utilizzato in oggetto non codificato (" + key + ")" + separator;
        }
        return msg;
    }
}

