/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBOggettiInUsoUtils_pdd {
    protected static boolean isPddInUso(Connection con, String tipoDB, String nomePdd, List<String> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        boolean bl;
        String nomeMetodo = "pddInUso";
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("server = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nomePdd);
            risultato = stmt.executeQuery();
            boolean isInUso = false;
            while (risultato.next()) {
                String tipo_soggetto = risultato.getString("tipo_soggetto");
                String nome_soggetto = risultato.getString("nome_soggetto");
                IDSoggetto idSoggetto = new IDSoggetto(tipo_soggetto, nome_soggetto);
                if (normalizeObjectIds) {
                    String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(tipo_soggetto);
                    whereIsInUso.add(DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelSoggetto(protocollo, idSoggetto));
                } else {
                    whereIsInUso.add(tipo_soggetto + "/" + nome_soggetto);
                }
                isInUso = true;
            }
            bl = isInUso;
        }
        catch (Exception se) {
            try {
                throw new UtilsException("[DBOggettiInUsoUtils::" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        return bl;
    }

    protected static String toString(String nomePdd, List<String> whereIsInUso, boolean prefix, String separator) {
        Object prefixString = "";
        if (prefix) {
            prefixString = "La Porta di Dominio [" + nomePdd + "] non \u00e8 eliminabile poich\u00e8: " + separator;
        }
        return (String)prefixString + "risulta associata ad uno o pi&ugrave; Soggetti: " + DBOggettiInUsoUtils.formatList(whereIsInUso, separator) + separator;
    }
}

