/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.validator;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.transazioni.utils.TempiElaborazione;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.engine.validator.ValidazioneConSchema;
import org.openspcoop2.protocol.engine.validator.ValidazioneSemantica;
import org.openspcoop2.protocol.engine.validator.ValidazioneSintattica;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.SecurityInfo;
import org.openspcoop2.protocol.sdk.Servizio;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.constants.SubCodiceErrore;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.validator.IValidatoreErrori;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazione;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazioneErrori;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.SubErrorCodeSecurity;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.digest.IDigestReader;
import org.slf4j.Logger;

public class Validatore {
    private IState state;
    private OpenSPCoop2Message msg;
    private Context context;
    private ProprietaValidazione proprietaValidazione;
    ErroreCooperazione errore;
    IntegrationFunctionError errore_integrationFunctionError;
    private List<Eccezione> erroriValidazione = new ArrayList<Eccezione>();
    private List<Eccezione> erroriProcessamento = new ArrayList<Eccezione>();
    private String erroreProcessamento_internalMessage;
    private boolean isMessaggioErrore;
    private boolean isMessaggioErroreIntestazione;
    private boolean isMessaggioErroreProcessamento;
    private boolean isBustaDiServizio;
    private Busta busta;
    private IDSoggetto mittente;
    private IDServizio servizio;
    private ValidazioneSintattica validatoreSintattico;
    private String servizioCorrelato;
    private String tipoServizioCorrelato;
    private Integer versioneServizioCorrelato;
    private Servizio infoServizio = null;
    private String versioneProtocollo = null;
    private RuoloBusta ruoloBustaRicevuta = null;
    private SecurityInfo securityInfo = null;
    private boolean readQualifiedAttribute;
    private Logger log = null;
    private IProtocolFactory<?> protocolFactory;
    private IProtocolManager protocolManager;
    private Busta bustaErroreHeaderIntestazione = null;
    private Exception eccezioneProcessamentoValidazioneSintattica = null;
    private boolean rilevatiErroriDuranteValidazioneSemantica = false;
    private Exception eccezioneProcessamentoValidazioneSemantica = null;

    public ValidazioneSintattica getValidatoreSintattico() {
        return this.validatoreSintattico;
    }

    public void setValidatoreSintattico(ValidazioneSintattica validator) {
        this.validatoreSintattico = validator;
    }

    public Busta getBustaErroreHeaderIntestazione() {
        return this.bustaErroreHeaderIntestazione;
    }

    public Validatore(OpenSPCoop2Message aMsg, Context ctx, ProprietaValidazione aValidazione, IState state, boolean readQualifiedAttribute, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        this(aMsg, ctx, aValidazione, state, Configurazione.getLibraryLog(), readQualifiedAttribute, protocolFactory);
    }

    public Validatore(OpenSPCoop2Message aMsg, Context ctx, ProprietaValidazione aValidazione, IState state, Logger alog, boolean readQualifiedAttribute, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        this.msg = aMsg;
        this.context = ctx;
        this.proprietaValidazione = aValidazione == null ? new ProprietaValidazione() : aValidazione;
        this.state = state;
        this.log = alog != null ? alog : LoggerWrapperFactory.getLogger(Validatore.class);
        this.readQualifiedAttribute = readQualifiedAttribute;
        this.protocolFactory = protocolFactory;
        this.protocolManager = this.protocolFactory.createProtocolManager();
    }

    public Validatore(OpenSPCoop2Message aMsg, Context ctx, IState state, Logger alog, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        this(aMsg, ctx, null, state, alog, false, protocolFactory);
    }

    public void updateState(IState state) {
        this.state = state;
    }

    public boolean validazioneSintattica() {
        return this.validazioneSintattica(null, null);
    }

    public boolean validazioneSintattica(Busta busta, Boolean isRichiestaParam) {
        boolean request = isRichiestaParam == null || isRichiestaParam != false;
        try {
            this.validatoreSintattico = new ValidazioneSintattica(this.context, this.state, this.msg, busta, isRichiestaParam, this.log, this.readQualifiedAttribute, this.protocolFactory);
            if (!this.validatoreSintattico.valida()) {
                this.errore = this.validatoreSintattico.getErrore();
                this.errore_integrationFunctionError = this.validatoreSintattico.getErrore_integrationFunctionError();
                if (this.errore_integrationFunctionError == null) {
                    this.errore_integrationFunctionError = request ? IntegrationFunctionError.INVALID_INTEROPERABILITY_PROFILE_REQUEST : IntegrationFunctionError.INVALID_INTEROPERABILITY_PROFILE_RESPONSE;
                }
                this.bustaErroreHeaderIntestazione = this.validatoreSintattico.getBustaErroreHeaderIntestazione();
                return false;
            }
            this.errore_integrationFunctionError = this.validatoreSintattico.getErrore_integrationFunctionError();
            this.busta = this.validatoreSintattico.getBusta();
            IValidatoreErrori validatoreErrori = this.protocolFactory.createValidatoreErrori(this.state);
            ProprietaValidazioneErrori pValidazioneErrori = new ProprietaValidazioneErrori();
            pValidazioneErrori.setIgnoraEccezioniNonGravi(this.protocolManager.isIgnoraEccezioniNonGravi());
            this.isMessaggioErrore = validatoreErrori.isBustaErrore(this.busta, this.msg, pValidazioneErrori);
            this.isMessaggioErroreIntestazione = validatoreErrori.isBustaErroreIntestazione(this.busta, this.msg, pValidazioneErrori);
            this.isMessaggioErroreProcessamento = validatoreErrori.isBustaErroreProcessamento(this.busta, this.msg, pValidazioneErrori);
            this.isBustaDiServizio = this.protocolFactory.createProtocolManager().isBustaServizio(this.busta);
            if (this.isMessaggioErrore) {
                this.addListaEccezioni(this.validatoreSintattico.getErroriTrovatiSullaListaEccezioni(), this.erroriValidazione);
            } else {
                this.addListaEccezioni(this.validatoreSintattico.getEccezioniValidazione(), this.erroriValidazione);
            }
            this.addListaEccezioni(this.validatoreSintattico.getEccezioniProcessamento(), this.erroriProcessamento);
            this.erroreProcessamento_internalMessage = this.validatoreSintattico.getErroreProcessamento_internalMessage();
            if (this.isBustaDiServizio && this.busta.sizeListaEccezioni() <= 0 && this.busta.sizeListaRiscontri() <= 0) {
                Eccezione ec = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.SERVIZIO_SCONOSCIUTO.getErroreCooperazione(), this.protocolFactory);
                this.erroriValidazione.add(ec);
                this.isBustaDiServizio = false;
            }
            if (this.busta.getTipoMittente() != null && this.busta.getMittente() != null) {
                this.mittente = new IDSoggetto(this.busta.getTipoMittente(), this.busta.getMittente());
                this.mittente.setCodicePorta(this.busta.getIdentificativoPortaMittente());
            }
            if (!this.isBustaDiServizio) {
                try {
                    this.servizio = IDServizioFactory.getInstance().getIDServizioFromValues(this.busta.getTipoServizio(), this.busta.getServizio(), this.busta.getTipoDestinatario(), this.busta.getDestinatario(), this.busta.getVersioneServizio().intValue());
                }
                catch (Exception e) {
                    this.log.debug("Generazione IDServizio non possibile: " + e.getMessage());
                }
                if (this.servizio != null) {
                    this.servizio.setAzione(this.busta.getAzione());
                    if (this.servizio != null && this.servizio.getSoggettoErogatore() != null) {
                        this.servizio.getSoggettoErogatore().setCodicePorta(this.busta.getIdentificativoPortaDestinatario());
                    }
                }
            }
            if (this.erroriValidazione != null && this.erroriValidazione.size() > 0 || this.erroriProcessamento != null && this.erroriProcessamento.size() > 0) {
                return true;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("validazioneSintattica", (Throwable)e);
            this.eccezioneProcessamentoValidazioneSintattica = e;
            this.errore = ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento("Errore di processamento: " + e.getMessage());
            this.errore_integrationFunctionError = request ? IntegrationFunctionError.INTERNAL_REQUEST_ERROR : IntegrationFunctionError.INTERNAL_RESPONSE_ERROR;
            return false;
        }
    }

    public Exception getEccezioneProcessamentoValidazioneSintattica() {
        return this.eccezioneProcessamentoValidazioneSintattica;
    }

    public boolean isRilevatiErroriDuranteValidazioneSemantica() {
        return this.rilevatiErroriDuranteValidazioneSemantica;
    }

    public boolean validazioneSemantica_beforeMessageSecurity(ServiceBinding serviceBinding, boolean rispostaConnectionReply, String profiloGestione, RequestInfo requestInfo) {
        try {
            this.rilevatiErroriDuranteValidazioneSemantica = true;
            if (this.validatoreSintattico == null) {
                this.errore = ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento("Errore di processamento: Analisi sintattica richiesta e validatoreSintattico non risulta inizializzato");
                return false;
            }
            if (this.ruoloBustaRicevuta == null) {
                this.ruoloBustaRicevuta = ValidazioneSemantica.getTipoBustaDaValidare(serviceBinding, this.busta, this.protocolFactory, rispostaConnectionReply, this.state, this.log);
            }
            try {
                this.versioneProtocollo = rispostaConnectionReply ? profiloGestione : (this.busta != null && this.busta.getMittente() != null && this.busta.getTipoMittente() != null ? ValidazioneSemantica.riconoscimentoVersioneProtocolloServizioErogato(this.busta, this.protocolFactory.createTraduttore(), this.ruoloBustaRicevuta, this.state, requestInfo) : profiloGestione);
            }
            catch (Exception e) {
                this.log.error("Riconoscimento profilo di gestione non riuscito", (Throwable)e);
            }
            if (this.protocolFactory.createProtocolVersionManager(this.versioneProtocollo).isEccezioniLivelloInfoAbilitato() && this.isMessaggioErrore) {
                IValidatoreErrori validatoreErrori = this.protocolFactory.createValidatoreErrori(this.state);
                ProprietaValidazioneErrori pValidazioneErrori = new ProprietaValidazioneErrori();
                pValidazioneErrori.setIgnoraEccezioniNonGravi(this.protocolManager.isIgnoraEccezioniNonGravi());
                pValidazioneErrori.setVersioneProtocollo(this.versioneProtocollo);
                this.isMessaggioErrore = validatoreErrori.isBustaErrore(this.busta, this.msg, pValidazioneErrori);
                this.isMessaggioErroreIntestazione = validatoreErrori.isBustaErroreIntestazione(this.busta, this.msg, pValidazioneErrori);
                this.isMessaggioErroreProcessamento = validatoreErrori.isBustaErroreProcessamento(this.busta, this.msg, pValidazioneErrori);
            }
            boolean ignoraEccezioniLivelloNonGravi = this.protocolFactory.createProtocolVersionManager(this.versioneProtocollo).isIgnoraEccezioniLivelloNonGrave();
            int sizeErroriValidazione = this.countErrori(ignoraEccezioniLivelloNonGravi, this.erroriValidazione);
            int sizeErroriProcessamento = this.countErrori(ignoraEccezioniLivelloNonGravi, this.erroriProcessamento);
            if (sizeErroriValidazione > 0 || sizeErroriProcessamento > 0) {
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("validazioneSemantica (validazioneSemantica_beforeMessageSecurity)", (Throwable)e);
            this.eccezioneProcessamentoValidazioneSemantica = e;
            this.errore = ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione();
            return false;
        }
        this.rilevatiErroriDuranteValidazioneSemantica = false;
        return true;
    }

    public boolean validazioneSemantica_messageSecurity_readSecurityInfo(MessageSecurityContext messageSecurityContext) {
        try {
            this.rilevatiErroriDuranteValidazioneSemantica = true;
            IDigestReader digestReader = null;
            if (messageSecurityContext != null) {
                digestReader = messageSecurityContext.getDigestReader(this.msg != null ? this.msg.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory());
            }
            if (messageSecurityContext != null && digestReader != null) {
                this.securityInfo = this.protocolFactory.createValidazioneSemantica(this.state).readSecurityInformation(digestReader, this.msg);
            }
        }
        catch (Exception e) {
            this.log.error("validazioneSemantica (validazioneSemantica_messageSecurity_readSecurityInfo)", (Throwable)e);
            this.eccezioneProcessamentoValidazioneSemantica = e;
            this.errore = ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione();
            return false;
        }
        this.rilevatiErroriDuranteValidazioneSemantica = false;
        return true;
    }

    public boolean validazioneSemantica_messageSecurity_process(MessageSecurityContext messageSecurityContext, StringBuilder errore, TempiElaborazione tempiElaborazione, boolean request) {
        block14: {
            try {
                this.rilevatiErroriDuranteValidazioneSemantica = true;
                if (messageSecurityContext == null || messageSecurityContext.getIncomingProperties() == null || messageSecurityContext.getIncomingProperties().size() <= 0) break block14;
                boolean existsHeaderMessageSecurity = messageSecurityContext.existsSecurityHeader(this.msg, messageSecurityContext.getActor());
                if (messageSecurityContext.processIncoming(this.msg, this.busta, (Map)this.context, tempiElaborazione)) break block14;
                ArrayList<Eccezione> eccezioniSicurezza = new ArrayList<Eccezione>();
                if (messageSecurityContext.getListaSubCodiceErrore() != null && messageSecurityContext.getListaSubCodiceErrore().size() > 0) {
                    List subCodiciErrore = messageSecurityContext.getListaSubCodiceErrore();
                    for (SubErrorCodeSecurity subCodiceErrore : subCodiciErrore) {
                        Eccezione ecc = new Eccezione(ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(subCodiceErrore.getMsgErrore(), messageSecurityContext.getCodiceErrore()), true, null, this.protocolFactory);
                        ecc.setSubCodiceEccezione((SubCodiceErrore)subCodiceErrore);
                        eccezioniSicurezza.add(ecc);
                    }
                } else {
                    Eccezione ecc = new Eccezione(ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(messageSecurityContext.getMsgErrore(), messageSecurityContext.getCodiceErrore()), true, null, this.protocolFactory);
                    eccezioniSicurezza.add(ecc);
                }
                this.errore_integrationFunctionError = request ? IntegrationFunctionError.MESSAGE_SECURITY_REQUEST_FAILED : IntegrationFunctionError.MESSAGE_SECURITY_RESPONSE_FAILED;
                if (this.isMessaggioErrore) {
                    if (existsHeaderMessageSecurity) {
                        for (Eccezione ecc : eccezioniSicurezza) {
                            this.erroriValidazione.add(ecc);
                            if (errore.length() > 0) {
                                errore.append("\n");
                            }
                            errore.append(ecc.getDescrizione(this.protocolFactory));
                        }
                        return true;
                    }
                    StringBuilder bf = new StringBuilder();
                    for (Eccezione ecc : eccezioniSicurezza) {
                        if (bf.length() > 0) {
                            bf.append(" ; ");
                        }
                        bf.append(ecc.toString(this.protocolFactory));
                    }
                    this.log.debug("MessageSecurityHeader not exists: " + bf.toString());
                    break block14;
                }
                for (Eccezione ecc : eccezioniSicurezza) {
                    this.erroriValidazione.add(ecc);
                    if (errore.length() > 0) {
                        errore.append("\n");
                    }
                    errore.append(ecc.getDescrizione(this.protocolFactory));
                }
                return true;
            }
            catch (Exception e) {
                if (errore.length() > 0) {
                    errore.append("\n");
                }
                errore.append(e.getMessage());
                this.log.error("validazioneSemantica (validazioneSemantica_messageSecurity_process)", (Throwable)e);
                this.eccezioneProcessamentoValidazioneSemantica = e;
                this.errore = ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione();
                return false;
            }
        }
        this.rilevatiErroriDuranteValidazioneSemantica = false;
        return true;
    }

    public boolean validazioneSemantica_afterMessageSecurity(ProprietaManifestAttachments proprietaManifestAttachments, boolean validazioneIdentificativiCompleta, RequestInfo requestInfo) {
        try {
            this.rilevatiErroriDuranteValidazioneSemantica = true;
            if (this.isMessaggioErrore) {
                this.validatoreSintattico.validazioneFault(this.msg);
                this.addListaEccezioni(this.validatoreSintattico.getErroriTrovatiSullaListaEccezioni(), this.erroriValidazione);
                this.addListaEccezioni(this.validatoreSintattico.getEccezioniProcessamento(), this.erroriProcessamento);
                if (this.erroriValidazione != null && this.erroriValidazione.size() > 0 || this.erroriProcessamento != null && this.erroriProcessamento.size() > 0) {
                    return true;
                }
            }
            boolean hasAttachments = false;
            if (ServiceBinding.SOAP.equals((Object)this.msg.getServiceBinding())) {
                hasAttachments = this.msg.castAsSoap().hasAttachments();
            } else if (MessageType.MIME_MULTIPART.equals((Object)this.msg.getMessageType())) {
                hasAttachments = true;
            }
            if (!this.isMessaggioErrore && this.proprietaValidazione.isValidazioneManifestAttachments() && hasAttachments) {
                this.validatoreSintattico.validazioneManifestAttachments(this.msg, proprietaManifestAttachments);
                this.addListaEccezioni(this.validatoreSintattico.getEccezioniValidazione(), this.erroriValidazione);
                this.addListaEccezioni(this.validatoreSintattico.getEccezioniProcessamento(), this.erroriProcessamento);
                if (this.erroriValidazione != null && this.erroriValidazione.size() > 0 || this.erroriProcessamento != null && this.erroriProcessamento.size() > 0) {
                    return true;
                }
            }
            if (!this.isMessaggioErrore) {
                ValidazioneSemantica registryValidator = new ValidazioneSemantica(this.busta, this.context, this.state, validazioneIdentificativiCompleta, this.log, this.protocolFactory);
                registryValidator.valida(this.msg, this.proprietaValidazione, this.ruoloBustaRicevuta, this.versioneProtocollo, requestInfo);
                this.addListaEccezioni(registryValidator.getEccezioniValidazione(), this.erroriValidazione);
                this.addListaEccezioni(registryValidator.getEccezioniProcessamento(), this.erroriProcessamento);
                this.servizioCorrelato = registryValidator.getServizioCorrelato();
                this.tipoServizioCorrelato = registryValidator.getTipoServizioCorrelato();
                this.versioneServizioCorrelato = registryValidator.getVersioneServizioCorrelato();
                this.infoServizio = registryValidator.getInfoServizio();
                this.errore_integrationFunctionError = registryValidator.getErrore_integrationFunctionError();
                if (this.erroriValidazione != null && this.erroriValidazione.size() > 0 || this.erroriProcessamento != null && this.erroriProcessamento.size() > 0) {
                    return true;
                }
            }
            if (this.proprietaValidazione.isValidazioneConSchema()) {
                ValidazioneConSchema schemaValidator = new ValidazioneConSchema(this.msg, this.isMessaggioErroreProcessamento, this.isMessaggioErroreIntestazione, this.proprietaValidazione.isValidazioneManifestAttachments(), this.log, this.protocolFactory, this.state);
                schemaValidator.valida(hasAttachments);
                this.addListaEccezioni(schemaValidator.getEccezioniValidazione(), this.erroriValidazione);
                this.addListaEccezioni(schemaValidator.getEccezioniProcessamento(), this.erroriProcessamento);
                if (this.erroriValidazione != null && this.erroriValidazione.size() > 0 || this.erroriProcessamento != null && this.erroriProcessamento.size() > 0) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.log.error("validazioneSemantica (validazioneSemantica_afterMessageSecurity)", (Throwable)e);
            this.eccezioneProcessamentoValidazioneSemantica = e;
            this.errore = ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione();
            return false;
        }
        this.rilevatiErroriDuranteValidazioneSemantica = false;
        return true;
    }

    public Exception getEccezioneProcessamentoValidazioneSemantica() {
        return this.eccezioneProcessamentoValidazioneSemantica;
    }

    public ErroreCooperazione getErrore() {
        return this.errore;
    }

    public IntegrationFunctionError getErrore_integrationFunctionError() {
        return this.errore_integrationFunctionError;
    }

    public boolean validazioneConEccezioni() {
        return this.erroriValidazione != null && this.erroriValidazione.size() > 0 || this.erroriProcessamento != null && this.erroriProcessamento.size() > 0;
    }

    public List<Eccezione> getEccezioniValidazione() {
        if (this.erroriValidazione != null) {
            return this.erroriValidazione;
        }
        return new ArrayList<Eccezione>();
    }

    public List<Eccezione> getEccezioniProcessamento() {
        if (this.erroriProcessamento != null) {
            return this.erroriProcessamento;
        }
        return new ArrayList<Eccezione>();
    }

    public String getErroreProcessamento_internalMessage() {
        return this.erroreProcessamento_internalMessage;
    }

    public boolean isErroreProtocollo() {
        return this.isMessaggioErrore;
    }

    public boolean isMessaggioErroreIntestazione() {
        return this.isMessaggioErroreIntestazione;
    }

    public boolean isMessaggioErroreProcessamento() {
        return this.isMessaggioErroreProcessamento;
    }

    public boolean isBustaDiServizio() {
        return this.isBustaDiServizio;
    }

    public Busta getBusta() {
        return this.busta;
    }

    public IDSoggetto getSoggettoMittente() {
        return this.mittente;
    }

    public void setMittente(IDSoggetto mittente) {
        this.mittente = mittente;
    }

    public IDServizio getIDServizio() {
        return this.servizio;
    }

    public String getServizioCorrelato() {
        return this.servizioCorrelato;
    }

    public String getTipoServizioCorrelato() {
        return this.tipoServizioCorrelato;
    }

    public Integer getVersioneServizioCorrelato() {
        return this.versioneServizioCorrelato;
    }

    public Servizio getInfoServizio() {
        return this.infoServizio;
    }

    public String getProfiloGestione() {
        return this.versioneProtocollo;
    }

    public void setProfiloGestione(String profiloGestione) {
        this.versioneProtocollo = profiloGestione;
    }

    public RuoloBusta getRuoloBustaRicevuta(ServiceBinding serviceBinding, boolean rispostaConnectionReply) throws ProtocolException {
        if (this.ruoloBustaRicevuta == null) {
            this.ruoloBustaRicevuta = ValidazioneSemantica.getTipoBustaDaValidare(serviceBinding, this.busta, this.protocolFactory, rispostaConnectionReply, this.state, this.log);
        }
        return this.ruoloBustaRicevuta;
    }

    public void setProprietaValidazione(ProprietaValidazione proprietaValidazione) {
        this.proprietaValidazione = proprietaValidazione;
    }

    public BustaRawContent<?> getHeaderProtocollo() {
        return this.validatoreSintattico.getProtocolHeader();
    }

    public BustaRawContent<?> getHeaderProtocollo_senzaControlli() throws ProtocolException {
        this.validatoreSintattico = new ValidazioneSintattica(this.context, this.state, this.msg, this.log, this.protocolFactory);
        return this.validatoreSintattico.getHeaderProtocollo_senzaControlli();
    }

    private void addListaEccezioni(List<Eccezione> from, List<Eccezione> to) {
        if (from != null) {
            to.addAll(from);
        }
    }

    public SecurityInfo getSecurityInfo() {
        return this.securityInfo;
    }

    private int countErrori(boolean ignoraEccezioniNonGravi, List<Eccezione> list) {
        int size = 0;
        if (list != null) {
            for (Eccezione eccezione : list) {
                if (eccezione.getRilevanza() != null && ignoraEccezioniNonGravi) {
                    if (!LivelloRilevanza.isEccezioneLivelloGrave((LivelloRilevanza)eccezione.getRilevanza())) continue;
                    ++size;
                    continue;
                }
                ++size;
            }
        }
        return size;
    }

    public void updateMsg(OpenSPCoop2Message msg) throws ProtocolException {
        boolean update;
        String msgClassName = msg.getClass().getName();
        boolean bl = update = !msgClassName.equals(this.msg.getClass().getName());
        if (update) {
            this.msg = msg;
            if (this.validatoreSintattico != null) {
                this.validatoreSintattico.updateMsg(msg);
            }
        }
    }
}

