/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa;

import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.core.mapping.DBProtocolPropertiesUtils;
import org.openspcoop2.protocol.basic.BasicFactory;
import org.openspcoop2.protocol.basic.BasicStaticInstanceConfig;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.modipa.AbstractModISecurityToken;
import org.openspcoop2.protocol.modipa.builder.ModIBustaBuilder;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.config.ModIProtocolConfiguration;
import org.openspcoop2.protocol.modipa.config.ModIProtocolManager;
import org.openspcoop2.protocol.modipa.config.ModIProtocolVersionManager;
import org.openspcoop2.protocol.modipa.properties.ModIDynamicConfiguration;
import org.openspcoop2.protocol.modipa.tracciamento.ModITracciaSerializer;
import org.openspcoop2.protocol.modipa.validator.ModIValidazioneSemantica;
import org.openspcoop2.protocol.modipa.validator.ModIValidazioneSintattica;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.properties.IConsoleDynamicConfiguration;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaSerializer;
import org.openspcoop2.protocol.sdk.validator.IValidazioneSemantica;
import org.slf4j.Logger;

public class ModIFactory
extends BasicFactory<AbstractModISecurityToken<?>> {
    private static final long serialVersionUID = -4246311511752079753L;
    private static IProtocolManager staticInstanceProtocolManager = null;
    private static Map<String, IProtocolVersionManager> staticInstanceProtocolVersionManager = null;
    private static IProtocolConfiguration staticInstanceProtocolConfiguration = null;

    public void init(Logger log, String protocol, ConfigurazionePdD configPdD, Openspcoop2 manifest) throws ProtocolException {
        super.init(log, protocol, configPdD, manifest);
        ModIProperties.initialize(configPdD.getConfigurationDir(), log);
        ModIProperties properties = ModIProperties.getInstance();
        properties.validaConfigurazione(configPdD.getLoader());
        BasicStaticInstanceConfig staticInstanceConfig = properties.getStaticInstanceConfig();
        super.initStaticInstance(staticInstanceConfig);
        if (staticInstanceConfig != null && staticInstanceConfig.isStaticConfig()) {
            staticInstanceProtocolManager = new ModIProtocolManager((IProtocolFactory<?>)this);
            staticInstanceProtocolVersionManager = new HashMap<String, IProtocolVersionManager>();
            staticInstanceProtocolConfiguration = new ModIProtocolConfiguration((IProtocolFactory<?>)this);
        }
        DBProtocolPropertiesUtils.addConfidentialProtocolProperty((String)"modipaKeystorePassword");
        DBProtocolPropertiesUtils.addConfidentialProtocolProperty((String)"modipaKeyPassword");
        DBProtocolPropertiesUtils.addConfidentialProtocolProperty((String)"modipaTruststorePassword");
        DBProtocolPropertiesUtils.addConfidentialProtocolProperty((String)"modipaSslTruststorePassword");
        DBProtocolPropertiesUtils.addConfidentialProtocolProperty((String)"modipaKeystoreArchive");
        DBProtocolPropertiesUtils.addConfidentialProtocolProperty((String)"modipaDPoPKeystorePassword");
        DBProtocolPropertiesUtils.addConfidentialProtocolProperty((String)"modipaDPoPKeyPassword");
        DBProtocolPropertiesUtils.addConfidentialProtocolProperty((String)"modipaDPoPKeystoreArchive");
    }

    public ModIBustaBuilder createBustaBuilder(IState state) throws ProtocolException {
        return new ModIBustaBuilder((IProtocolFactory<?>)this, state);
    }

    public ModIValidazioneSintattica createValidazioneSintattica(IState state) throws ProtocolException {
        return new ModIValidazioneSintattica((IProtocolFactory<AbstractModISecurityToken<?>>)this, state);
    }

    public IValidazioneSemantica createValidazioneSemantica(IState state) throws ProtocolException {
        return new ModIValidazioneSemantica((IProtocolFactory<?>)this, state);
    }

    public ITracciaSerializer createTracciaSerializer() throws ProtocolException {
        return new ModITracciaSerializer((IProtocolFactory<?>)this);
    }

    public IProtocolManager createProtocolManager() throws ProtocolException {
        return staticInstanceProtocolManager != null ? staticInstanceProtocolManager : new ModIProtocolManager((IProtocolFactory<?>)this);
    }

    public IProtocolVersionManager createProtocolVersionManager(String version) throws ProtocolException {
        if (staticInstanceProtocolVersionManager != null) {
            if (!staticInstanceProtocolVersionManager.containsKey(version)) {
                this.initProtocolVersionManager(version);
            }
            return staticInstanceProtocolVersionManager.get(version);
        }
        return new ModIProtocolVersionManager((IProtocolFactory<?>)this, version);
    }

    private synchronized void initProtocolVersionManager(String version) throws ProtocolException {
        if (!staticInstanceProtocolVersionManager.containsKey(version)) {
            staticInstanceProtocolVersionManager.put(version, new ModIProtocolVersionManager((IProtocolFactory<?>)this, version));
        }
    }

    public IProtocolConfiguration createProtocolConfiguration() throws ProtocolException {
        return staticInstanceProtocolConfiguration != null ? staticInstanceProtocolConfiguration : new ModIProtocolConfiguration((IProtocolFactory<?>)this);
    }

    public IConsoleDynamicConfiguration createDynamicConfigurationConsole() throws ProtocolException {
        return new ModIDynamicConfiguration((IProtocolFactory<?>)this);
    }
}

