/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.protocol.engine.utils.AzioniUtils;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.properties.ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities;
import org.openspcoop2.protocol.modipa.properties.ModIProfiliInterazioneRESTConfig;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemType;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemValueType;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.AbstractConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BaseConsoleItem;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesFactory;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.properties.StringConsoleItem;
import org.openspcoop2.protocol.sdk.properties.StringProperty;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaAccordi;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaPortTypeAzioni;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaRisorse;
import org.openspcoop2.protocol.sdk.registry.RegistryException;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.utils.SortedMap;
import org.slf4j.Logger;

public class ModIDynamicConfigurationAccordiParteComuneUtilities {
    private static volatile boolean permettiModificaNomeAccordo = true;
    private static IDAccordo idAccordoSignalHubPushAPI = null;

    private ModIDynamicConfigurationAccordiParteComuneUtilities() {
    }

    static void addProfiloInterazione(ModIProperties modiProperties, ConsoleConfiguration configuration, boolean rest, String httpMethod) throws ProtocolException {
        configuration.addConsoleItem(ProtocolPropertiesFactory.newSubTitleItem((String)"modipaAzioneProfiloInterazioneSubTitleId", (String)"Interazione"));
        ModIProfiliInterazioneRESTConfig config = null;
        if (rest) {
            config = new ModIProfiliInterazioneRESTConfig(modiProperties, httpMethod, null);
        }
        StringConsoleItem profiloInterazioneItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaInteractionProfile", (String)"Pattern");
        boolean addBloccante = true;
        boolean addNonBloccantePush = true;
        boolean addNonBloccantePull = true;
        if (rest) {
            addBloccante = config.isCompatibileBloccante();
            addNonBloccantePush = config.isCompatibileNonBloccantePush();
            addNonBloccantePull = config.isCompatibileNonBloccantePull();
        }
        if (rest) {
            profiloInterazioneItem.addLabelValue("Accesso CRUD", (Object)"crud");
        }
        if (addBloccante) {
            profiloInterazioneItem.addLabelValue("Bloccante", (Object)"bloccante");
        }
        if (addNonBloccantePush || addNonBloccantePull) {
            profiloInterazioneItem.addLabelValue("Non Bloccante", (Object)"nonBloccante");
        }
        profiloInterazioneItem.setDefaultValue((Object)(rest ? "crud" : "bloccante"));
        profiloInterazioneItem.setReloadOnChange(true);
        configuration.addConsoleItem((BaseConsoleItem)profiloInterazioneItem);
        StringConsoleItem profiloInterazioneItemReadOnly = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaInteractionProfile__LABEL", (String)"Pattern");
        configuration.addConsoleItem((BaseConsoleItem)profiloInterazioneItemReadOnly);
        StringConsoleItem profiloInterazioneAsincronaItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaInteractionAsyncProfile", (String)"Tipo");
        profiloInterazioneAsincronaItem.setDefaultValue((Object)"PUSH");
        profiloInterazioneAsincronaItem.setReloadOnChange(true);
        configuration.addConsoleItem((BaseConsoleItem)profiloInterazioneAsincronaItem);
        StringConsoleItem profiloInterazioneAsincronaItemReadOnly = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaInteractionAsyncProfile__LABEL", (String)"Tipo");
        configuration.addConsoleItem((BaseConsoleItem)profiloInterazioneAsincronaItemReadOnly);
        StringConsoleItem profiloInterazioneAsincronaRelazioneItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaInteractionAsyncRole", (String)"Funzione");
        profiloInterazioneAsincronaRelazioneItem.setDefaultValue((Object)"Richiesta");
        profiloInterazioneAsincronaRelazioneItem.setReloadOnChange(true);
        configuration.addConsoleItem((BaseConsoleItem)profiloInterazioneAsincronaRelazioneItem);
        StringConsoleItem profiloInterazioneAsincronaRelazioneItemReadOnly = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaInteractionAsyncRole__LABEL", (String)"Funzione");
        configuration.addConsoleItem((BaseConsoleItem)profiloInterazioneAsincronaRelazioneItemReadOnly);
        StringConsoleItem profiloInterazioneAsincronaCorrelataApiItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaInteractionAsyncApiRequest", (String)"");
        profiloInterazioneAsincronaCorrelataApiItem.setDefaultValue((Object)"-");
        profiloInterazioneAsincronaCorrelataApiItem.setReloadOnChange(true);
        configuration.addConsoleItem((BaseConsoleItem)profiloInterazioneAsincronaCorrelataApiItem);
        StringConsoleItem profiloInterazioneAsincronaCorrelataServizioItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaInteractionAsyncServiceRequest", (String)"");
        profiloInterazioneAsincronaCorrelataServizioItem.setDefaultValue((Object)"-");
        profiloInterazioneAsincronaCorrelataServizioItem.setReloadOnChange(true);
        configuration.addConsoleItem((BaseConsoleItem)profiloInterazioneAsincronaCorrelataServizioItem);
        StringConsoleItem profiloInterazioneAsincronaCorrelataAzioneItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.HIDDEN, (String)"modipaInteractionAsyncActionRequest", (String)"");
        profiloInterazioneAsincronaCorrelataAzioneItem.setDefaultValue((Object)"-");
        profiloInterazioneAsincronaCorrelataAzioneItem.setReloadOnChange(true);
        configuration.addConsoleItem((BaseConsoleItem)profiloInterazioneAsincronaCorrelataAzioneItem);
    }

    private static AccordoServizioParteComune getAccordoServizioParteComune(IRegistryReader registryReader, IDAccordo idAccordoSelected) throws RegistryException {
        AccordoServizioParteComune aspc = null;
        try {
            aspc = registryReader.getAccordoServizioParteComune(idAccordoSelected);
        }
        catch (RegistryNotFound registryNotFound) {
            // empty catch block
        }
        return aspc;
    }

    private static List<IDAccordo> findIdAccordiServizioParteComune(IRegistryReader registryReader, ProtocolFiltroRicercaAccordi filtro) throws RegistryException {
        List list = null;
        try {
            list = registryReader.findIdAccordiServizioParteComune(filtro);
        }
        catch (RegistryNotFound registryNotFound) {
            // empty catch block
        }
        return list;
    }

    static void updateProfiloInterazione(ModIProperties modiProperties, IProtocolFactory<?> protocolFactory, Logger log, ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, ProtocolProperties properties, IRegistryReader registryReader, IDAccordo idAccordo, String idPortType, String idAzione, boolean rest, String httpMethod) throws ProtocolException {
        String profiloInterazione;
        IDResource id;
        AbstractConsoleItem profiloInterazioneItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInteractionProfile");
        AbstractConsoleItem profiloInterazioneAsincronaItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInteractionAsyncProfile");
        AbstractConsoleItem profiloInterazioneAsincronaRelazioneItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInteractionAsyncRole");
        AbstractConsoleItem profiloInterazioneAsincronaCorrelataApiItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInteractionAsyncApiRequest");
        AbstractConsoleItem profiloInterazioneAsincronaCorrelataServizioItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInteractionAsyncServiceRequest");
        AbstractConsoleItem profiloInterazioneAsincronaCorrelataAzioneItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaInteractionAsyncActionRequest");
        ModIProfiliInterazioneRESTConfig config = null;
        boolean inUse = false;
        if (rest) {
            Resource resource = null;
            if (ConsoleOperationType.CHANGE.equals((Object)consoleOperationType)) {
                try {
                    id = new IDResource();
                    id.setIdAccordo(idAccordo);
                    id.setNome(idAzione);
                    resource = registryReader.getResourceAccordo(id);
                    inUse = registryReader.inUso(id);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
            config = new ModIProfiliInterazioneRESTConfig(modiProperties, httpMethod, resource);
        } else if (ConsoleOperationType.CHANGE.equals((Object)consoleOperationType)) {
            try {
                IDPortType idPT = new IDPortType();
                idPT.setIdAccordo(idAccordo);
                idPT.setNome(idPortType);
                id = new IDPortTypeAzione();
                id.setIdPortType(idPT);
                id.setNome(idAzione);
                inUse = registryReader.inUso((IDPortTypeAzione)id);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        boolean addBloccante = true;
        boolean addNonBloccantePush = true;
        boolean addNonBloccantePull = true;
        if (rest) {
            addBloccante = config.isCompatibileBloccante();
            addNonBloccantePush = config.isCompatibileNonBloccantePush();
            addNonBloccantePull = config.isCompatibileNonBloccantePull();
        }
        boolean allHidden = true;
        StringProperty profiloInterazioneItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInteractionProfile");
        String string = profiloInterazione = rest ? "crud" : "bloccante";
        if (profiloInterazioneItemValue != null && profiloInterazioneItemValue.getValue() != null && !"".equals(profiloInterazioneItemValue.getValue())) {
            profiloInterazione = (String)profiloInterazioneItemValue.getValue();
        }
        if (!addBloccante) {
            profiloInterazioneItem.removeLabelValue("Bloccante");
        }
        if (!addNonBloccantePush && !addNonBloccantePull) {
            profiloInterazioneItem.removeLabelValue("Non Bloccante");
        }
        if ("bloccante".equals(profiloInterazione) && !addBloccante || "nonBloccante".equals(profiloInterazione) && !addNonBloccantePush && !addNonBloccantePull) {
            String string2 = profiloInterazione = rest ? "crud" : "bloccante";
        }
        if ("nonBloccante".equals(profiloInterazione)) {
            allHidden = false;
            profiloInterazioneAsincronaItem.setType(ConsoleItemType.SELECT);
            if (addNonBloccantePush) {
                ((StringConsoleItem)profiloInterazioneAsincronaItem).addLabelValue("PUSH", (Object)"PUSH");
            }
            if (addNonBloccantePull) {
                ((StringConsoleItem)profiloInterazioneAsincronaItem).addLabelValue("PULL", (Object)"PULL");
            }
            StringProperty profiloInterazioneAsincronaItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInteractionAsyncProfile");
            String interazioneMode = "PUSH";
            if (profiloInterazioneAsincronaItemValue != null && profiloInterazioneAsincronaItemValue.getValue() != null && !"".equals(profiloInterazioneAsincronaItemValue.getValue())) {
                interazioneMode = (String)profiloInterazioneAsincronaItemValue.getValue();
                if ("PUSH".equals(interazioneMode) && !addNonBloccantePush) {
                    interazioneMode = "PULL";
                } else if ("PULL".equals(interazioneMode) && !addNonBloccantePull) {
                    interazioneMode = "PUSH";
                }
            } else {
                if ("PUSH".equals(interazioneMode) && !addNonBloccantePush) {
                    interazioneMode = "PULL";
                } else if ("PULL".equals(interazioneMode) && !addNonBloccantePull) {
                    interazioneMode = "PUSH";
                }
                if (profiloInterazioneAsincronaItemValue != null) {
                    profiloInterazioneAsincronaItemValue.setValue((Object)interazioneMode);
                }
            }
            boolean push = "PUSH".equals(interazioneMode);
            boolean addRichiesta = true;
            boolean addRichiestaStato = true;
            boolean addRisposta = true;
            if (push) {
                addRichiestaStato = false;
                if (rest) {
                    addRichiesta = config.isCompatibileNonBloccantePushRequest();
                    addRisposta = config.isCompatibileNonBloccantePushResponse();
                }
            } else if (rest) {
                addRichiesta = config.isCompatibileNonBloccantePullRequest();
                addRichiestaStato = config.isCompatibileNonBloccantePullRequestState();
                addRisposta = config.isCompatibileNonBloccantePullResponse();
            }
            profiloInterazioneAsincronaRelazioneItem.setType(ConsoleItemType.SELECT);
            if (addRichiesta) {
                ((StringConsoleItem)profiloInterazioneAsincronaRelazioneItem).addLabelValue("Richiesta", (Object)"Richiesta");
            }
            if (addRichiestaStato) {
                ((StringConsoleItem)profiloInterazioneAsincronaRelazioneItem).addLabelValue("Richiesta Stato", (Object)"RichiestaStato");
            }
            if (addRisposta) {
                ((StringConsoleItem)profiloInterazioneAsincronaRelazioneItem).addLabelValue("Risposta", (Object)"Risposta");
            }
            StringProperty profiloRelazioneAsincronaItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInteractionAsyncRole");
            String relazioneMode = "Richiesta";
            if (profiloRelazioneAsincronaItemValue != null && profiloRelazioneAsincronaItemValue.getValue() != null && !"".equals(profiloRelazioneAsincronaItemValue.getValue())) {
                relazioneMode = (String)profiloRelazioneAsincronaItemValue.getValue();
            }
            if ("Richiesta".equals(relazioneMode) && !addRichiesta) {
                if (addRisposta) {
                    relazioneMode = "Risposta";
                } else if (addRichiestaStato) {
                    relazioneMode = "RichiestaStato";
                }
            } else if ("RichiestaStato".equals(relazioneMode) && !addRichiestaStato) {
                if (addRichiesta) {
                    relazioneMode = "Richiesta";
                } else if (addRisposta) {
                    relazioneMode = "Risposta";
                }
            } else if ("Risposta".equals(relazioneMode) && !addRisposta) {
                if (addRichiesta) {
                    relazioneMode = "Richiesta";
                } else if (addRichiestaStato) {
                    relazioneMode = "RichiestaStato";
                }
            }
            boolean request = "Richiesta".equals(relazioneMode);
            if (request) {
                profiloInterazioneAsincronaCorrelataApiItem.setType(ConsoleItemType.HIDDEN);
                profiloInterazioneAsincronaCorrelataServizioItem.setType(ConsoleItemType.HIDDEN);
                profiloInterazioneAsincronaCorrelataAzioneItem.setType(ConsoleItemType.HIDDEN);
            } else {
                try {
                    if (push) {
                        StringProperty apiValue;
                        profiloInterazioneAsincronaCorrelataApiItem.setType(ConsoleItemType.SELECT);
                        ((StringConsoleItem)profiloInterazioneAsincronaCorrelataApiItem).addLabelValue("-", (Object)"-");
                        profiloInterazioneAsincronaCorrelataApiItem.setLabel("API Richiesta Correlata");
                        profiloInterazioneAsincronaCorrelataServizioItem.setType(ConsoleItemType.HIDDEN);
                        profiloInterazioneAsincronaCorrelataAzioneItem.setType(ConsoleItemType.HIDDEN);
                        ProtocolFiltroRicercaAccordi filtro = new ProtocolFiltroRicercaAccordi();
                        filtro.setServiceBinding(idPortType != null ? ServiceBinding.SOAP : ServiceBinding.REST);
                        filtro.setSoggetto(new IDSoggetto(protocolFactory.createProtocolConfiguration().getTipoSoggettoDefault(), null));
                        List<IDAccordo> list = ModIDynamicConfigurationAccordiParteComuneUtilities.findIdAccordiServizioParteComune(registryReader, filtro);
                        if (list != null && !list.isEmpty()) {
                            for (IDAccordo idAccordoTrovato : list) {
                                String uri = IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoTrovato);
                                ((StringConsoleItem)profiloInterazioneAsincronaCorrelataApiItem).addLabelValue(NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idAccordoTrovato), (Object)uri);
                            }
                        }
                        if ((apiValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInteractionAsyncApiRequest")) != null && apiValue.getValue() != null && !"".equals(apiValue.getValue()) && !"-".equals(apiValue.getValue())) {
                            String uriAPI = (String)apiValue.getValue();
                            IDAccordo idAccordoSelected = IDAccordoFactory.getInstance().getIDAccordoFromUri(uriAPI);
                            AccordoServizioParteSpecifica asps = new AccordoServizioParteSpecifica();
                            asps.setTipoSoggettoErogatore(idAccordoSelected.getSoggettoReferente().getTipo());
                            asps.setNomeSoggettoErogatore(idAccordoSelected.getSoggettoReferente().getNome());
                            asps.setNome(idAccordoSelected.getNome());
                            asps.setVersione(idAccordoSelected.getVersione());
                            AccordoServizioParteComune aspcNormale = registryReader.getAccordoServizioParteComune(idAccordoSelected, false, false);
                            AccordoServizioParteComuneSintetico aspcSelected = new AccordoServizioParteComuneSintetico(aspcNormale);
                            boolean addTrattinoSelezioneNonEffettuata = true;
                            boolean throwException = true;
                            AccordoServizioParteComune aspc = ModIDynamicConfigurationAccordiParteComuneUtilities.getAccordoServizioParteComune(registryReader, idAccordoSelected);
                            if (idPortType != null) {
                                StringProperty ptValue;
                                profiloInterazioneAsincronaCorrelataServizioItem.setType(ConsoleItemType.SELECT);
                                ((StringConsoleItem)profiloInterazioneAsincronaCorrelataServizioItem).addLabelValue("-", (Object)"-");
                                profiloInterazioneAsincronaCorrelataServizioItem.setLabel("Servizio");
                                if (aspc != null && aspc.sizePortTypeList() > 0) {
                                    for (PortType pt : aspc.getPortTypeList()) {
                                        if (pt.getNome().equals(idPortType)) continue;
                                        ((StringConsoleItem)profiloInterazioneAsincronaCorrelataServizioItem).addLabelValue(pt.getNome(), (Object)pt.getNome());
                                    }
                                }
                                if ((ptValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInteractionAsyncServiceRequest")) != null && ptValue.getValue() != null && !"".equals(ptValue.getValue()) && !"-".equals(ptValue.getValue())) {
                                    profiloInterazioneAsincronaCorrelataAzioneItem.setType(ConsoleItemType.SELECT);
                                    ((StringConsoleItem)profiloInterazioneAsincronaCorrelataAzioneItem).addLabelValue("-", (Object)"-");
                                    profiloInterazioneAsincronaCorrelataAzioneItem.setLabel("Azione");
                                    asps.setPortType((String)ptValue.getValue());
                                    ArrayList<String> filtraAzioniUtilizzate = new ArrayList<String>();
                                    filtraAzioniUtilizzate.add(idAzione);
                                    Map azioni = AzioniUtils.getAzioniConLabel((AccordoServizioParteSpecifica)asps, (AccordoServizioParteComuneSintetico)aspcSelected, (boolean)addTrattinoSelezioneNonEffettuata, (boolean)throwException, filtraAzioniUtilizzate, (String)"-", (String)"-", (Logger)log);
                                    if (azioni != null && !azioni.isEmpty()) {
                                        for (Map.Entry entry : azioni.entrySet()) {
                                            String tmpRelazione;
                                            String tmpRuolo;
                                            String azioneId = (String)entry.getKey();
                                            String tmpInterazione = AzioniUtils.getProtocolPropertyStringValue((AccordoServizioParteComune)aspc, (String)((String)ptValue.getValue()), (String)azioneId, (String)"modipaInteractionProfile");
                                            if (!"nonBloccante".equals(tmpInterazione) || !"PUSH".equals(tmpRuolo = AzioniUtils.getProtocolPropertyStringValue((AccordoServizioParteComune)aspc, (String)((String)ptValue.getValue()), (String)azioneId, (String)"modipaInteractionAsyncProfile")) || !"Richiesta".equals(tmpRelazione = AzioniUtils.getProtocolPropertyStringValue((AccordoServizioParteComune)aspc, (String)((String)ptValue.getValue()), (String)azioneId, (String)"modipaInteractionAsyncRole"))) continue;
                                            String azioneLabel = (String)azioni.get(azioneId);
                                            ((StringConsoleItem)profiloInterazioneAsincronaCorrelataAzioneItem).addLabelValue(azioneLabel, (Object)azioneId);
                                        }
                                    }
                                }
                            } else {
                                profiloInterazioneAsincronaCorrelataAzioneItem.setType(ConsoleItemType.SELECT);
                                ((StringConsoleItem)profiloInterazioneAsincronaCorrelataAzioneItem).addLabelValue("-", (Object)"-");
                                profiloInterazioneAsincronaCorrelataAzioneItem.setLabel("Risorsa");
                                ArrayList<String> filtraAzioniUtilizzate = new ArrayList<String>();
                                filtraAzioniUtilizzate.add(idAzione);
                                Map azioni = AzioniUtils.getAzioniConLabel((AccordoServizioParteSpecifica)asps, (AccordoServizioParteComuneSintetico)aspcSelected, (boolean)addTrattinoSelezioneNonEffettuata, (boolean)throwException, filtraAzioniUtilizzate, (String)"-", (String)"-", (Logger)log);
                                if (azioni != null && !azioni.isEmpty()) {
                                    for (String azioneId : azioni.keySet()) {
                                        String tmpRelazione;
                                        String tmpRuolo;
                                        String tmpInterazione = AzioniUtils.getProtocolPropertyStringValue((AccordoServizioParteComune)aspc, null, (String)azioneId, (String)"modipaInteractionProfile");
                                        if (!"nonBloccante".equals(tmpInterazione) || !"PUSH".equals(tmpRuolo = AzioniUtils.getProtocolPropertyStringValue((AccordoServizioParteComune)aspc, null, (String)azioneId, (String)"modipaInteractionAsyncProfile")) || !"Richiesta".equals(tmpRelazione = AzioniUtils.getProtocolPropertyStringValue((AccordoServizioParteComune)aspc, null, (String)azioneId, (String)"modipaInteractionAsyncRole"))) continue;
                                        String azioneLabel = (String)azioni.get(azioneId);
                                        ((StringConsoleItem)profiloInterazioneAsincronaCorrelataAzioneItem).addLabelValue(azioneLabel, (Object)azioneId);
                                    }
                                }
                            }
                        }
                    } else {
                        profiloInterazioneAsincronaCorrelataApiItem.setType(ConsoleItemType.HIDDEN);
                        profiloInterazioneAsincronaCorrelataServizioItem.setType(ConsoleItemType.HIDDEN);
                        profiloInterazioneAsincronaCorrelataAzioneItem.setType(ConsoleItemType.SELECT);
                        ((StringConsoleItem)profiloInterazioneAsincronaCorrelataAzioneItem).addLabelValue("-", (Object)"-");
                        profiloInterazioneAsincronaCorrelataAzioneItem.setLabel("Richiesta Correlata");
                        AccordoServizioParteSpecifica asps = new AccordoServizioParteSpecifica();
                        asps.setTipoSoggettoErogatore(idAccordo.getSoggettoReferente().getTipo());
                        asps.setNomeSoggettoErogatore(idAccordo.getSoggettoReferente().getNome());
                        asps.setNome(idAccordo.getNome());
                        asps.setVersione(idAccordo.getVersione());
                        asps.setPortType(idPortType);
                        AccordoServizioParteComune aspcNormale = registryReader.getAccordoServizioParteComune(idAccordo, false, false);
                        AccordoServizioParteComuneSintetico aspc = new AccordoServizioParteComuneSintetico(aspcNormale);
                        boolean addTrattinoSelezioneNonEffettuata = true;
                        boolean throwException = true;
                        ArrayList<String> filtraAzioniUtilizzate = new ArrayList<String>();
                        filtraAzioniUtilizzate.add(idAzione);
                        Map azioni = AzioniUtils.getAzioniConLabel((AccordoServizioParteSpecifica)asps, (AccordoServizioParteComuneSintetico)aspc, (boolean)addTrattinoSelezioneNonEffettuata, (boolean)throwException, filtraAzioniUtilizzate, (String)"-", (String)"-", (Logger)log);
                        if (azioni != null && !azioni.isEmpty()) {
                            for (String azioneId : azioni.keySet()) {
                                String tmpRelazione;
                                String tmpRuolo;
                                String tmpInterazione = AzioniUtils.getProtocolPropertyStringValue((AccordoServizioParteComune)aspcNormale, (String)idPortType, (String)azioneId, (String)"modipaInteractionProfile");
                                if (!"nonBloccante".equals(tmpInterazione) || !"PULL".equals(tmpRuolo = AzioniUtils.getProtocolPropertyStringValue((AccordoServizioParteComune)aspcNormale, (String)idPortType, (String)azioneId, (String)"modipaInteractionAsyncProfile")) || !"Richiesta".equals(tmpRelazione = AzioniUtils.getProtocolPropertyStringValue((AccordoServizioParteComune)aspcNormale, (String)idPortType, (String)azioneId, (String)"modipaInteractionAsyncRole"))) continue;
                                String azioneLabel = (String)azioni.get(azioneId);
                                ((StringConsoleItem)profiloInterazioneAsincronaCorrelataAzioneItem).addLabelValue(azioneLabel, (Object)azioneId);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (allHidden) {
            profiloInterazioneAsincronaItem.setType(ConsoleItemType.HIDDEN);
            profiloInterazioneAsincronaRelazioneItem.setType(ConsoleItemType.HIDDEN);
            profiloInterazioneAsincronaCorrelataApiItem.setType(ConsoleItemType.HIDDEN);
            profiloInterazioneAsincronaCorrelataServizioItem.setType(ConsoleItemType.HIDDEN);
            profiloInterazioneAsincronaCorrelataAzioneItem.setType(ConsoleItemType.HIDDEN);
        } else if (inUse) {
            ModIDynamicConfigurationAccordiParteComuneUtilities.setLabelInUse(consoleConfiguration, properties, profiloInterazioneItem, "modipaInteractionProfile", "modipaInteractionProfile__LABEL");
            ModIDynamicConfigurationAccordiParteComuneUtilities.setLabelInUse(consoleConfiguration, properties, profiloInterazioneAsincronaItem, "modipaInteractionAsyncProfile", "modipaInteractionAsyncProfile__LABEL");
            ModIDynamicConfigurationAccordiParteComuneUtilities.setLabelInUse(consoleConfiguration, properties, profiloInterazioneAsincronaRelazioneItem, "modipaInteractionAsyncRole", "modipaInteractionAsyncRole__LABEL");
        }
    }

    static void setLabelInUse(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties, AbstractConsoleItem<?> item, String id, String idReadOnly) throws ProtocolException {
        if (!ConsoleItemType.HIDDEN.equals((Object)item.getType())) {
            StringConsoleItem sci;
            SortedMap map;
            StringProperty itemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)id);
            item.setType(ConsoleItemType.HIDDEN);
            AbstractConsoleItem itemReadOnly = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)idReadOnly);
            itemReadOnly.setType(ConsoleItemType.TEXT);
            String label = null;
            String labelDefault = null;
            if (item instanceof StringConsoleItem && (map = (sci = (StringConsoleItem)item).getMapLabelValues()) != null && !map.isEmpty()) {
                for (String l : map.keys()) {
                    String v = (String)map.get(l);
                    if (v != null && v.equals(itemValue.getValue())) {
                        label = l;
                    }
                    if (v == null || !v.equals(item.getDefaultValue())) continue;
                    labelDefault = l;
                }
            }
            StringProperty itemValueReadOnly = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)idReadOnly);
            if (label != null) {
                itemValueReadOnly.setValue(label);
            } else {
                itemValueReadOnly.setValue(labelDefault);
            }
        }
    }

    static void validateProfiloInterazione(ProtocolProperties properties, String idPortType, boolean rest) throws ProtocolException {
        String profiloInterazione;
        StringProperty profiloInterazioneItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInteractionProfile");
        String string = profiloInterazione = rest ? "crud" : "bloccante";
        if (profiloInterazioneItemValue != null && profiloInterazioneItemValue.getValue() != null && !"".equals(profiloInterazioneItemValue.getValue())) {
            profiloInterazione = (String)profiloInterazioneItemValue.getValue();
        }
        if ("nonBloccante".equals(profiloInterazione)) {
            boolean request;
            StringProperty profiloInterazioneAsincronaItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInteractionAsyncProfile");
            String interazioneMode = "PUSH";
            if (profiloInterazioneAsincronaItemValue != null && profiloInterazioneAsincronaItemValue.getValue() != null && !"".equals(profiloInterazioneAsincronaItemValue.getValue())) {
                interazioneMode = (String)profiloInterazioneAsincronaItemValue.getValue();
            }
            boolean push = "PUSH".equals(interazioneMode);
            StringProperty profiloRelazioneAsincronaItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInteractionAsyncRole");
            String relazioneMode = "Richiesta";
            if (profiloRelazioneAsincronaItemValue != null && profiloRelazioneAsincronaItemValue.getValue() != null && !"".equals(profiloRelazioneAsincronaItemValue.getValue())) {
                relazioneMode = (String)profiloRelazioneAsincronaItemValue.getValue();
            }
            if (!(request = "Richiesta".equals(relazioneMode))) {
                String labelRelazione = "Risposta";
                if ("RichiestaStato".equals(relazioneMode)) {
                    labelRelazione = "Richiesta Stato";
                }
                if (push) {
                    StringProperty ptItemValue;
                    String prefixPushNonBloccante = "Il profilo non bloccante 'PUSH', relazione '" + labelRelazione + "'";
                    StringProperty apiItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInteractionAsyncApiRequest");
                    if (apiItemValue == null || apiItemValue.getValue() == null || "".equals(apiItemValue.getValue()) || "-".equals(apiItemValue.getValue())) {
                        throw new ProtocolException(prefixPushNonBloccante + ", richiede che sia perfezionata una correlazione verso una API che implementa il servizio di risposta");
                    }
                    if (idPortType != null && ((ptItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInteractionAsyncServiceRequest")) == null || ptItemValue.getValue() == null || "".equals(ptItemValue.getValue()) || "-".equals(ptItemValue.getValue()))) {
                        throw new ProtocolException(prefixPushNonBloccante + ", richiede che sia perfezionata una correlazione verso un servizio di risposta");
                    }
                    StringProperty azioneItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInteractionAsyncActionRequest");
                    if (azioneItemValue == null || azioneItemValue.getValue() == null || "".equals(azioneItemValue.getValue()) || "-".equals(azioneItemValue.getValue())) {
                        String az = null;
                        az = idPortType != null ? "un'azione" : "una risorsa";
                        throw new ProtocolException(prefixPushNonBloccante + ", richiede che sia perfezionata una correlazione verso " + az + " con relazione 'Richiesta'");
                    }
                } else {
                    StringProperty azioneItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaInteractionAsyncActionRequest");
                    if (azioneItemValue == null || azioneItemValue.getValue() == null || "".equals(azioneItemValue.getValue()) || "-".equals(azioneItemValue.getValue())) {
                        String az = null;
                        az = idPortType != null ? "un'azione" : "una risorsa";
                        throw new ProtocolException("Il profilo non bloccante 'PULL', relazione '" + labelRelazione + "', richiede che sia perfezionata una correlazione verso " + az + " con relazione 'Richiesta'");
                    }
                }
            }
        }
    }

    static void updateProfiloSicurezzaCanale(ConsoleConfiguration consoleConfiguration, ProtocolProperties properties) {
        String value;
        AbstractConsoleItem profiloSicurezzaCanaleItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleConfiguration.getConsoleItem(), (String)"modipaSecurityChannelProfile");
        StringProperty sicurezzaCanaleItemValue = (StringProperty)ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)properties, (String)"modipaSecurityChannelProfile");
        String string = value = sicurezzaCanaleItemValue != null ? (String)sicurezzaCanaleItemValue.getValue() : null;
        if ("idac01".equals(value)) {
            profiloSicurezzaCanaleItem.setNote("Direct Trust Transport-Level Security");
        } else if ("idac02".equals(value)) {
            profiloSicurezzaCanaleItem.setNote("Direct Trust mutual Transport-Level Security");
        }
    }

    public static boolean isPermettiModificaNomeAccordo() {
        return permettiModificaNomeAccordo;
    }

    public static void setPermettiModificaNomeAccordo(boolean permettiModificaNomeAccordo) {
        ModIDynamicConfigurationAccordiParteComuneUtilities.permettiModificaNomeAccordo = permettiModificaNomeAccordo;
    }

    private static int valueOfVersione(String versioneS) {
        int versione = -1;
        try {
            versione = Integer.valueOf(versioneS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return versione;
    }

    private static List<IDResource> findIdResourceAccordo(IRegistryReader registryReader, ProtocolFiltroRicercaRisorse filtro) throws RegistryException {
        List list = null;
        try {
            list = registryReader.findIdResourceAccordo(filtro);
        }
        catch (RegistryNotFound registryNotFound) {
            // empty catch block
        }
        return list;
    }

    private static List<IDPortTypeAzione> findIdAzionePortType(IRegistryReader registryReader, ProtocolFiltroRicercaPortTypeAzioni filtro) throws RegistryException {
        List list = null;
        try {
            list = registryReader.findIdAzionePortType(filtro);
        }
        catch (RegistryNotFound registryNotFound) {
            // empty catch block
        }
        return list;
    }

    static void validateDynamicConfigAccordoServizioParteComune(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IDAccordo id) throws ProtocolException {
        boolean rest = ModIDynamicConfigurationAccordiParteComuneUtilities.isApiRest(consoleOperationType, consoleHelper, registryReader, id);
        if (!permettiModificaNomeAccordo && ConsoleOperationType.CHANGE.equals((Object)consoleOperationType) && id != null) {
            try {
                String apiGestioneParziale = consoleHelper.getParameter("apiGestioneParziale");
                if ("apiInfoGenerali".equals(apiGestioneParziale)) {
                    String nome = consoleHelper.getParameter("nome");
                    String versioneS = consoleHelper.getParameter("versione");
                    int versione = ModIDynamicConfigurationAccordiParteComuneUtilities.valueOfVersione(versioneS);
                    if (!(nome == null || versione <= 0 || id.getNome().equals(nome) && id.getVersione() == versione)) {
                        AccordoServizioParteComune as = registryReader.getAccordoServizioParteComune(id);
                        if (ServiceBinding.REST.equals((Object)as.getServiceBinding())) {
                            ProtocolFiltroRicercaRisorse filtro = new ProtocolFiltroRicercaRisorse();
                            ProtocolProperties protocolPropertiesResources = new ProtocolProperties();
                            protocolPropertiesResources.addProperty("modipaInteractionAsyncApiRequest", IDAccordoFactory.getInstance().getUriFromIDAccordo(id));
                            filtro.setProtocolPropertiesRisorsa(protocolPropertiesResources);
                            List<IDResource> list = ModIDynamicConfigurationAccordiParteComuneUtilities.findIdResourceAccordo(registryReader, filtro);
                            if (list != null && !list.isEmpty()) {
                                IDResource idR = list.get(0);
                                String uriAPI = NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idR.getIdAccordo());
                                Resource resource = registryReader.getResourceAccordo(idR);
                                String labelR = NamingUtils.getLabelResource((Resource)resource);
                                throw new ProtocolException("Non \u00e8 possibile modificare le informazioni generali dell'API poich\u00e8 riferita dalla risorsa '" + labelR + "' dell'API '" + uriAPI + "' (Profilo non bloccante PUSH)");
                            }
                        } else {
                            ProtocolFiltroRicercaPortTypeAzioni filtro = new ProtocolFiltroRicercaPortTypeAzioni();
                            ProtocolProperties protocolPropertiesAzioni = new ProtocolProperties();
                            protocolPropertiesAzioni.addProperty("modipaInteractionAsyncApiRequest", IDAccordoFactory.getInstance().getUriFromIDAccordo(id));
                            filtro.setProtocolPropertiesAzione(protocolPropertiesAzioni);
                            List<IDPortTypeAzione> list = ModIDynamicConfigurationAccordiParteComuneUtilities.findIdAzionePortType(registryReader, filtro);
                            if (list != null && !list.isEmpty()) {
                                IDPortTypeAzione idA = list.get(0);
                                String uriAPI = NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idA.getIdPortType().getIdAccordo());
                                throw new ProtocolException("Non \u00e8 possibile modificare le informazioni generali dell'API poich\u00e8 riferita dall'azione '" + idA.getNome() + "' del Servizio '" + idA.getIdPortType().getNome() + "' nell'API '" + uriAPI + "' (Profilo non bloccante PUSH)");
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.validateProfiloSicurezzaMessaggio(properties, rest);
    }

    static boolean isApiRest(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IDAccordo id) throws ProtocolException {
        boolean rest = true;
        AccordoServizioParteComune aspc = null;
        if (ConsoleOperationType.CHANGE.equals((Object)consoleOperationType) && id != null) {
            try {
                aspc = registryReader.getAccordoServizioParteComune(id, false, false);
            }
            catch (RegistryNotFound registryNotFound) {
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        if (aspc != null) {
            rest = ServiceBinding.REST.equals((Object)aspc.getServiceBinding());
        } else {
            try {
                String serviceBinding = consoleHelper.getParameter("serviceBinding");
                rest = !ServiceBinding.SOAP.name().equals(serviceBinding);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return rest;
    }

    public static IDAccordo getIdAccordoSignalHubPush(IRegistryReader registryReader, ModIProperties modiProperties) throws RegistryNotFound, RegistryException, DriverRegistroServiziException, ProtocolException {
        if (idAccordoSignalHubPushAPI == null) {
            ModIDynamicConfigurationAccordiParteComuneUtilities.initIdAccordoSignalHubPush(registryReader, modiProperties);
        }
        return idAccordoSignalHubPushAPI;
    }

    private static synchronized void initIdAccordoSignalHubPush(IRegistryReader registryReader, ModIProperties modiProperties) throws RegistryNotFound, RegistryException, DriverRegistroServiziException, ProtocolException {
        if (idAccordoSignalHubPushAPI == null) {
            IDSoggetto idSoggetto = registryReader.getIdSoggettoDefault("modipa");
            idAccordoSignalHubPushAPI = IDAccordoFactory.getInstance().getIDAccordoFromValues(modiProperties.getSignalHubApiName(), idSoggetto, Integer.valueOf(modiProperties.getSignalHubApiVersion()));
        }
    }

    public static boolean isApiSignalHubPushAPI(IDAccordo idAccordo, IRegistryReader registryReader, ModIProperties modiProperties, Logger log) {
        if (idAccordo != null) {
            IDAccordo idAccordoSignalHubPushAPIreaded = null;
            try {
                idAccordoSignalHubPushAPIreaded = ModIDynamicConfigurationAccordiParteComuneUtilities.getIdAccordoSignalHubPush(registryReader, modiProperties);
            }
            catch (Exception e) {
                log.error("Lettura id accordo signalhub api push fallita: " + e.getMessage(), (Throwable)e);
            }
            return idAccordoSignalHubPushAPIreaded != null && idAccordoSignalHubPushAPIreaded.equals((Object)idAccordo);
        }
        return false;
    }
}

