/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.constants.RuoloContesto;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.UrlInvocazioneAPIUtils;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.protocol.engine.SecurityTokenUtilities;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.utils.SOAPInfo;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaPortTypeAzioni;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaRisorse;
import org.openspcoop2.protocol.sdk.registry.ProtocolFiltroRicercaServizi;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModIUtilities {
    public static final boolean REMOVE = true;
    private static final MapKey<String> DYNAMIC_MAP_REQUEST = org.openspcoop2.utils.Map.newMapKey((String)"MODI_DYNAMIC_MAP_REQUEST");

    private ModIUtilities() {
    }

    private static void logError(Logger log, String msg) {
        log.error(msg);
    }

    public static boolean exists(Properties p, String key) {
        return ModIUtilities.get(p, key, false) != null;
    }

    public static String get(Properties p, String key, boolean remove) {
        if (p == null || p.isEmpty()) {
            return null;
        }
        for (Object oKeyP : p.keySet()) {
            String keyP;
            if (!(oKeyP instanceof String) || !(keyP = (String)oKeyP).equalsIgnoreCase(key)) continue;
            String s = p.getProperty(keyP);
            if (remove) {
                p.remove(keyP);
            }
            return s;
        }
        return null;
    }

    public static void remove(Properties p, String key) {
        if (p == null || p.isEmpty()) {
            return;
        }
        for (Object oKeyP : p.keySet()) {
            String keyP;
            if (!(oKeyP instanceof String) || !(keyP = (String)oKeyP).equalsIgnoreCase(key)) continue;
            p.remove(keyP);
            break;
        }
    }

    public static List<String> getArrayStringAsList(String v, boolean deleteQuote) {
        List<String> l = null;
        if (v != null && v.startsWith("[") && v.endsWith("]") && v.length() > 2) {
            String newValue = v.substring(1, v.length() - 1);
            return ModIUtilities.getAsList(newValue, deleteQuote);
        }
        return l;
    }

    public static List<String> getAsList(String values, boolean deleteQuote) {
        ArrayList<String> l = new ArrayList<String>();
        if (values.contains(",")) {
            String[] tmp = values.split(",");
            ModIUtilities.convertAsListValue(l, tmp, deleteQuote);
        } else {
            String v = values;
            if (deleteQuote && v.startsWith("\"") && v.endsWith("\"") && v.length() > 2) {
                v = v.substring(1, v.length() - 1);
            }
            l.add(v);
        }
        return l;
    }

    private static void convertAsListValue(List<String> l, String[] tmp, boolean deleteQuote) {
        if (tmp != null && tmp.length > 0) {
            for (String v : tmp) {
                v = v.trim();
                if (deleteQuote && v.startsWith("\"") && v.endsWith("\"") && v.length() > 2) {
                    v = v.substring(1, v.length() - 1);
                }
                if (!StringUtils.isNotEmpty((String)v)) continue;
                l.add(v);
            }
        }
    }

    public static String extractCorrelationIdFromLocation(String resourcePath, String location, boolean throwException, Logger log) throws ProtocolException {
        if (resourcePath == null) {
            throw new ProtocolException("Resource path della risorsa correlata non trovato");
        }
        String[] rSplit = resourcePath.split("/");
        int lastDynamicPosition = -1;
        for (String r : rSplit) {
            if (!r.startsWith("{")) continue;
            ++lastDynamicPosition;
        }
        int lastDynamicPos = 0;
        StringBuilder sb = new StringBuilder();
        for (String r : rSplit) {
            if (r == null || "".equals(r)) continue;
            sb.append("/+");
            if (r.startsWith("{")) {
                if (lastDynamicPos == lastDynamicPosition) {
                    sb.append("([^/]+)");
                } else {
                    sb.append(".*");
                }
                ++lastDynamicPos;
                continue;
            }
            sb.append(r);
        }
        sb.append("/?");
        String pattern = sb.toString();
        try {
            return RegularExpressionEngine.getStringFindPattern((String)location, (String)pattern);
        }
        catch (Exception e) {
            ModIUtilities.logError(log, "Estrazione Id Correlazione dalla Location '" + location + "' non riuscita (resourcePath: " + resourcePath + ") (pattern: " + pattern + ")");
            if (throwException) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public static String extractCorrelationId(String location, AccordoServizioParteComune apiContenenteRisorsa, String azione, String asyncInteractionRole, Logger log) throws ProtocolException {
        if (location != null) {
            location = location.trim();
            String resourcePath = null;
            if ("Richiesta".equals(asyncInteractionRole)) {
                for (Resource r : apiContenenteRisorsa.getResourceList()) {
                    String actionCorrelata;
                    String ruolo;
                    if (r.getNome().equals(azione) || (ruolo = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)r.getProtocolPropertyList(), (String)"modipaInteractionAsyncRole")) == null || !"RichiestaStato".equals(ruolo) || (actionCorrelata = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)r.getProtocolPropertyList(), (String)"modipaInteractionAsyncActionRequest")) == null || !actionCorrelata.equals(azione)) continue;
                    resourcePath = r.getPath();
                    break;
                }
            } else if ("RichiestaStato".equals(asyncInteractionRole)) {
                String azioneRichiesta = null;
                if ("RichiestaStato".equals(asyncInteractionRole)) {
                    Resource rRichiestaStato = null;
                    for (Resource r : apiContenenteRisorsa.getResourceList()) {
                        if (!r.getNome().equals(azione)) continue;
                        rRichiestaStato = r;
                        break;
                    }
                    if (rRichiestaStato == null) {
                        throw new ProtocolException("Risorsa con ruolo 'Richiesta Stato' non trovata");
                    }
                    azioneRichiesta = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)rRichiestaStato.getProtocolPropertyList(), (String)"modipaInteractionAsyncActionRequest");
                }
                for (Resource r : apiContenenteRisorsa.getResourceList()) {
                    String actionCorrelata;
                    String ruolo;
                    if (r.getNome().equals(azioneRichiesta) || (ruolo = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)r.getProtocolPropertyList(), (String)"modipaInteractionAsyncRole")) == null || !"Risposta".equals(ruolo) || (actionCorrelata = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)r.getProtocolPropertyList(), (String)"modipaInteractionAsyncActionRequest")) == null || !actionCorrelata.equals(azioneRichiesta)) continue;
                    resourcePath = r.getPath();
                    break;
                }
            }
            if (resourcePath == null) {
                throw new ProtocolException("Resource path della risorsa correlata non trovato");
            }
            return ModIUtilities.extractCorrelationIdFromLocation(resourcePath, location, false, log);
        }
        return null;
    }

    public static String getReplyToErogazione(IDSoggetto idSoggettoErogatoreServizioCorrelato, AccordoServizioParteComune aspc, String portType, String azione, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IProtocolFactory<?> protocolFactory, IState state, RequestInfo requestInfo) throws ProtocolException {
        return ModIUtilities.getReplyTo(false, null, idSoggettoErogatoreServizioCorrelato, aspc, portType, azione, registryReader, configIntegrationReader, protocolFactory, state, requestInfo);
    }

    public static String getReplyToFruizione(IDSoggetto idSoggettoFrutore, IDSoggetto idSoggettoErogatoreServizioCorrelato, AccordoServizioParteComune aspc, String portType, String azione, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IProtocolFactory<?> protocolFactory, IState state, RequestInfo requestInfo) throws ProtocolException {
        return ModIUtilities.getReplyTo(true, idSoggettoFrutore, idSoggettoErogatoreServizioCorrelato, aspc, portType, azione, registryReader, configIntegrationReader, protocolFactory, state, requestInfo);
    }

    private static String getReplyTo(boolean fruizione, IDSoggetto idSoggettoFrutore, IDSoggetto idSoggettoErogatoreServizioCorrelato, AccordoServizioParteComune aspc, String portType, String azione, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IProtocolFactory<?> protocolFactory, IState state, RequestInfo requestInfo) throws ProtocolException {
        try {
            List l;
            if (configIntegrationReader != null) {
                // empty if block
            }
            String uriAPC = IDAccordoFactory.getInstance().getUriFromAccordo(aspc);
            boolean rest = ServiceBinding.REST.equals((Object)aspc.getServiceBinding());
            IDAccordo idAccordoRisposta = null;
            String portTypeRisposta = null;
            if (rest) {
                ProtocolFiltroRicercaRisorse filtroRisorse = new ProtocolFiltroRicercaRisorse();
                filtroRisorse.setProtocolPropertiesRisorsa(new ProtocolProperties());
                filtroRisorse.getProtocolPropertiesRisorsa().addProperty("modipaInteractionAsyncRole", "Risposta");
                filtroRisorse.getProtocolPropertiesRisorsa().addProperty("modipaInteractionAsyncApiRequest", uriAPC);
                filtroRisorse.getProtocolPropertiesRisorsa().addProperty("modipaInteractionAsyncActionRequest", azione);
                l = null;
                try {
                    l = registryReader.findIdResourceAccordo(filtroRisorse);
                }
                catch (RegistryNotFound registryNotFound) {
                    // empty catch block
                }
                if (l == null || l.isEmpty()) {
                    throw new RegistryNotFound("Non \u00e8 stata individuata alcun API contenente una risorsa correlata alla richiesta in corso");
                }
                if (l.size() > 1) {
                    throw new RegistryNotFound("Sono state individuate pi\u00f9 di una risorsa contenente una correlazione verso la richiesta in corso: " + l);
                }
                IDResource idResource = (IDResource)l.get(0);
                idAccordoRisposta = idResource.getIdAccordo();
            } else {
                ProtocolFiltroRicercaPortTypeAzioni filtroPTAzioni = new ProtocolFiltroRicercaPortTypeAzioni();
                filtroPTAzioni.setProtocolPropertiesAzione(new ProtocolProperties());
                filtroPTAzioni.getProtocolPropertiesAzione().addProperty("modipaInteractionAsyncRole", "Risposta");
                filtroPTAzioni.getProtocolPropertiesAzione().addProperty("modipaInteractionAsyncApiRequest", uriAPC);
                filtroPTAzioni.getProtocolPropertiesAzione().addProperty("modipaInteractionAsyncServiceRequest", portType);
                filtroPTAzioni.getProtocolPropertiesAzione().addProperty("modipaInteractionAsyncActionRequest", azione);
                l = null;
                try {
                    l = registryReader.findIdAzionePortType(filtroPTAzioni);
                }
                catch (RegistryNotFound idResource) {
                    // empty catch block
                }
                if (l == null || l.isEmpty()) {
                    throw new RegistryNotFound("Non \u00e8 stata individuata alcun API contenente un'azione correlata alla richiesta in corso");
                }
                if (l.size() > 1) {
                    throw new RegistryNotFound("Sono state individuate pi\u00f9 di un'azione contenente una correlazione verso la richiesta in corso: " + l);
                }
                IDPortTypeAzione idPTAzione = (IDPortTypeAzione)l.get(0);
                idAccordoRisposta = idPTAzione.getIdPortType().getIdAccordo();
                portTypeRisposta = idPTAzione.getIdPortType().getNome();
            }
            ProtocolFiltroRicercaServizi filtroServizi = new ProtocolFiltroRicercaServizi();
            filtroServizi.setIdAccordoServizioParteComune(idAccordoRisposta);
            filtroServizi.setSoggettoErogatore(idSoggettoErogatoreServizioCorrelato);
            if (!rest) {
                filtroServizi.setPortType(portTypeRisposta);
            }
            List lIdServizio = null;
            try {
                lIdServizio = registryReader.findIdAccordiServizioParteSpecifica(filtroServizi);
            }
            catch (RegistryNotFound idPTAzione) {
                // empty catch block
            }
            if (lIdServizio == null || lIdServizio.isEmpty()) {
                if (fruizione) {
                    throw new RegistryNotFound("Non \u00e8 stata individuata alcuna fruzione verso l'API " + NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idAccordoRisposta) + " erogata dal soggetto " + NamingUtils.getLabelSoggetto((IDSoggetto)idSoggettoErogatoreServizioCorrelato));
                }
                throw new RegistryNotFound("Non \u00e8 stata individuata alcun'erogazione da parte del soggetto " + NamingUtils.getLabelSoggetto((IDSoggetto)idSoggettoErogatoreServizioCorrelato) + " relativamente all'API " + NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idAccordoRisposta));
            }
            if (lIdServizio.size() > 1) {
                if (fruizione) {
                    throw new RegistryNotFound("Sono state individuate pi\u00f9 fruzioni verso l'API " + NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idAccordoRisposta) + " erogata dal soggetto " + NamingUtils.getLabelSoggetto((IDSoggetto)idSoggettoErogatoreServizioCorrelato));
                }
                throw new RegistryNotFound("Sono state individuate pi\u00f9 di un'erogazione da parte del soggetto " + NamingUtils.getLabelSoggetto((IDSoggetto)idSoggettoErogatoreServizioCorrelato) + " relativamente all'API " + NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idAccordoRisposta));
            }
            IDServizio idServizioCorrelato = (IDServizio)lIdServizio.get(0);
            if (fruizione) {
                List listMapping = ConfigurazionePdDManager.getInstance((IState)state).getMappingFruizionePortaDelegataList(idSoggettoFrutore, idServizioCorrelato, requestInfo);
                if (listMapping == null) {
                    throw new RegistryNotFound("(outbound empty) Non \u00e8 stata individuata alcuna fruzione da parte del soggetto " + NamingUtils.getLabelSoggetto((IDSoggetto)idSoggettoFrutore) + " verso l'API " + NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idAccordoRisposta) + " erogata dal soggetto " + NamingUtils.getLabelSoggetto((IDSoggetto)idSoggettoErogatoreServizioCorrelato));
                }
                String nomePD = null;
                IDSoggetto proprietarioPD = null;
                for (MappingFruizionePortaDelegata mappingFruizionePortaDelegata : listMapping) {
                    if (!mappingFruizionePortaDelegata.isDefault()) continue;
                    nomePD = mappingFruizionePortaDelegata.getIdPortaDelegata().getNome();
                    proprietarioPD = idSoggettoFrutore;
                }
                if (nomePD == null) {
                    throw new RegistryNotFound("(outbound) Non \u00e8 stata individuata alcuna fruzione da parte del soggetto " + NamingUtils.getLabelSoggetto((IDSoggetto)idSoggettoFrutore) + " verso l'API " + NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idAccordoRisposta) + " erogata dal soggetto " + NamingUtils.getLabelSoggetto((IDSoggetto)idSoggettoErogatoreServizioCorrelato));
                }
                return UrlInvocazioneAPIUtils.getUrlInvocazione(protocolFactory, (IState)state, (RequestInfo)requestInfo, (boolean)rest, (AccordoServizioParteComune)aspc, (RuoloContesto)RuoloContesto.PORTA_DELEGATA, (String)nomePD, proprietarioPD);
            }
            List listMapping = ConfigurazionePdDManager.getInstance((IState)state).getMappingErogazionePortaApplicativaList(idServizioCorrelato, requestInfo);
            if (listMapping == null) {
                throw new RegistryNotFound("(inbound empty) Non \u00e8 stata individuata alcun'erogazione da parte del soggetto " + NamingUtils.getLabelSoggetto((IDSoggetto)idSoggettoErogatoreServizioCorrelato) + " relativamente all'API " + NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idAccordoRisposta));
            }
            String nomePA = null;
            IDSoggetto proprietarioPA = null;
            for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa : listMapping) {
                if (!mappingErogazionePortaApplicativa.isDefault()) continue;
                nomePA = mappingErogazionePortaApplicativa.getIdPortaApplicativa().getNome();
                proprietarioPA = idServizioCorrelato.getSoggettoErogatore();
            }
            if (nomePA == null) {
                throw new RegistryNotFound("(inbound) Non \u00e8 stata individuata alcun'erogazione da parte del soggetto " + NamingUtils.getLabelSoggetto((IDSoggetto)idSoggettoErogatoreServizioCorrelato) + " relativamente all'API " + NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idAccordoRisposta));
            }
            return UrlInvocazioneAPIUtils.getUrlInvocazione(protocolFactory, (IState)state, (RequestInfo)requestInfo, (boolean)rest, (AccordoServizioParteComune)aspc, (RuoloContesto)RuoloContesto.PORTA_APPLICATIVA, (String)nomePA, proprietarioPA);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getSOAPHeaderReplyToValue(OpenSPCoop2SoapMessage soapMessage, boolean bufferMessageReadOnly, String idTransazione) throws ProtocolException {
        boolean useSoapReader = true;
        SOAPHeaderElement hdrElement = ModIUtilities.getSOAPHeaderReplyTo(useSoapReader, soapMessage, bufferMessageReadOnly, idTransazione);
        return hdrElement != null ? hdrElement.getValue() : null;
    }

    public static SOAPHeaderElement getSOAPHeaderReplyTo(boolean useSoapReader, OpenSPCoop2SoapMessage soapMessage, boolean bufferMessageReadOnly, String idTransazione) throws ProtocolException {
        try {
            ModIProperties modIProperties = ModIProperties.getInstance();
            SOAPInfo soapInfo = new SOAPInfo();
            boolean readRootElementInfo = modIProperties.useSoapBodyReplyToNamespace();
            soapInfo.read(useSoapReader, soapMessage, bufferMessageReadOnly, idTransazione, false, true, readRootElementInfo);
            MessageType messageType = soapMessage.getMessageType();
            SOAPHeader header = soapInfo.getHeader();
            String namespace = readRootElementInfo ? soapInfo.getRootElementNamespace() : modIProperties.getSoapReplyToNamespace();
            return ModIUtilities.getSOAPHeaderElement(messageType, header, modIProperties.getSoapReplyToName(), namespace, modIProperties.getSoapReplyToActor());
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getSOAPHeaderCorrelationIdValue(OpenSPCoop2SoapMessage soapMessage, boolean bufferMessageReadOnly, String idTransazione) throws ProtocolException {
        boolean useSoapReader = true;
        SOAPHeaderElement hdrElement = ModIUtilities.getSOAPHeaderCorrelationId(useSoapReader, soapMessage, bufferMessageReadOnly, idTransazione);
        return hdrElement != null ? hdrElement.getValue() : null;
    }

    public static SOAPHeaderElement getSOAPHeaderCorrelationId(boolean useSoapReader, OpenSPCoop2SoapMessage soapMessage, boolean bufferMessageReadOnly, String idTransazione) throws ProtocolException {
        try {
            ModIProperties modIProperties = ModIProperties.getInstance();
            SOAPInfo soapInfo = new SOAPInfo();
            boolean readRootElementInfo = modIProperties.useSoapBodyCorrelationIdNamespace();
            soapInfo.read(useSoapReader, soapMessage, bufferMessageReadOnly, idTransazione, false, true, readRootElementInfo);
            MessageType messageType = soapMessage.getMessageType();
            SOAPHeader header = soapInfo.getHeader();
            String namespace = readRootElementInfo ? soapInfo.getRootElementNamespace() : modIProperties.getSoapCorrelationIdNamespace();
            return ModIUtilities.getSOAPHeaderElement(messageType, header, modIProperties.getSoapCorrelationIdName(), namespace, modIProperties.getSoapCorrelationIdActor());
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static SOAPHeaderElement getSOAPHeaderRequestDigest(boolean useSoapReader, OpenSPCoop2SoapMessage soapMessage, boolean bufferMessageReadOnly, String idTransazione) throws ProtocolException {
        try {
            ModIProperties modIProperties = ModIProperties.getInstance();
            SOAPInfo soapInfo = new SOAPInfo();
            boolean readRootElementInfo = modIProperties.useSoapBodyRequestDigestNamespace();
            soapInfo.read(useSoapReader, soapMessage, bufferMessageReadOnly, idTransazione, false, true, readRootElementInfo);
            MessageType messageType = soapMessage.getMessageType();
            SOAPHeader header = soapInfo.getHeader();
            String namespace = readRootElementInfo ? soapInfo.getRootElementNamespace() : modIProperties.getSoapRequestDigestNamespace();
            return ModIUtilities.getSOAPHeaderElement(messageType, header, modIProperties.getSoapRequestDigestName(), namespace, modIProperties.getSoapRequestDigestActor());
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static SOAPHeaderElement getSOAPHeaderElement(MessageType messageType, SOAPHeader header, String localName, String namespace, String actor) throws ProtocolException {
        try {
            if (header == null) {
                return null;
            }
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext()) {
                SOAPHeaderElement headerElementCheck = (SOAPHeaderElement)it.next();
                if (!namespace.equals(headerElementCheck.getNamespaceURI()) || !localName.equals(headerElementCheck.getLocalName())) continue;
                String actorCheck = SoapUtils.getSoapActor((SOAPHeaderElement)headerElementCheck, (MessageType)messageType);
                if (!(actor == null ? actorCheck == null : actor.equals(actorCheck))) continue;
                return headerElementCheck;
            }
            return null;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static void addSOAPHeaderReplyTo(OpenSPCoop2SoapMessage soapMessage, boolean bufferMessageReadOnly, String idTransazione, String value) throws ProtocolException {
        try {
            ModIProperties modIProperties = ModIProperties.getInstance();
            boolean useSoapReader = true;
            SOAPInfo soapInfo = new SOAPInfo();
            boolean readRootElementInfo = modIProperties.useSoapBodyReplyToNamespace();
            if (readRootElementInfo) {
                soapInfo.read(useSoapReader, soapMessage, bufferMessageReadOnly, idTransazione, false, false, readRootElementInfo);
            }
            ModIUtilities.addSOAPHeaderElement(soapMessage, modIProperties.getSoapReplyToName(), modIProperties.useSoapBodyReplyToNamespace() ? soapInfo.getRootElementPrefix() : modIProperties.getSoapReplyToPrefix(), modIProperties.useSoapBodyReplyToNamespace() ? soapInfo.getRootElementNamespace() : modIProperties.getSoapReplyToNamespace(), modIProperties.getSoapReplyToActor(), modIProperties.isSoapReplyToMustUnderstand(), value);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static void addSOAPHeaderCorrelationId(OpenSPCoop2SoapMessage soapMessage, boolean bufferMessageReadOnly, String idTransazione, String value) throws ProtocolException {
        try {
            ModIProperties modIProperties = ModIProperties.getInstance();
            boolean useSoapReader = true;
            SOAPInfo soapInfo = new SOAPInfo();
            boolean readRootElementInfo = modIProperties.useSoapBodyCorrelationIdNamespace();
            if (readRootElementInfo) {
                soapInfo.read(useSoapReader, soapMessage, bufferMessageReadOnly, idTransazione, false, false, readRootElementInfo);
            }
            ModIUtilities.addSOAPHeaderElement(soapMessage, modIProperties.getSoapCorrelationIdName(), modIProperties.useSoapBodyCorrelationIdNamespace() ? soapInfo.getRootElementPrefix() : modIProperties.getSoapCorrelationIdPrefix(), modIProperties.useSoapBodyCorrelationIdNamespace() ? soapInfo.getRootElementNamespace() : modIProperties.getSoapCorrelationIdNamespace(), modIProperties.getSoapCorrelationIdActor(), modIProperties.isSoapCorrelationIdMustUnderstand(), value);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static SOAPHeaderElement addSOAPHeaderRequestDigest(OpenSPCoop2SoapMessage soapMessage, boolean bufferMessageReadOnly, String idTransazione, NodeList value) throws ProtocolException {
        try {
            ModIProperties modIProperties = ModIProperties.getInstance();
            boolean useSoapReader = true;
            SOAPInfo soapInfo = new SOAPInfo();
            boolean readRootElementInfo = modIProperties.useSoapBodyRequestDigestNamespace();
            if (readRootElementInfo) {
                soapInfo.read(useSoapReader, soapMessage, bufferMessageReadOnly, idTransazione, false, false, readRootElementInfo);
            }
            return ModIUtilities.addSOAPHeaderElement(soapMessage, modIProperties.getSoapRequestDigestName(), modIProperties.useSoapBodyRequestDigestNamespace() ? soapInfo.getRootElementPrefix() : modIProperties.getSoapRequestDigestPrefix(), modIProperties.useSoapBodyRequestDigestNamespace() ? soapInfo.getRootElementNamespace() : modIProperties.getSoapRequestDigestNamespace(), modIProperties.getSoapRequestDigestActor(), modIProperties.isSoapRequestDigestMustUnderstand(), value);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static SOAPHeaderElement addSOAPHeaderElement(OpenSPCoop2SoapMessage msg, String localName, String prefix, String namespace, String actor, boolean mustUnderstand, Object value) throws ProtocolException {
        try {
            SOAPHeaderElement hdrElement = ModIUtilities.getSOAPHeaderElement(msg.getMessageType(), msg.getSOAPHeader(), localName, namespace, actor);
            if (hdrElement == null) {
                SOAPHeader header = msg.getSOAPHeader();
                if (header == null) {
                    header = msg.getSOAPPart().getEnvelope().addHeader();
                }
                hdrElement = msg.newSOAPHeaderElement(header, new QName(namespace, localName, prefix));
                if (actor != null && !"".equals(actor)) {
                    hdrElement.setActor(actor);
                }
                hdrElement.setMustUnderstand(mustUnderstand);
                msg.addHeaderElement(header, hdrElement);
            }
            if (value instanceof String) {
                hdrElement.setValue((String)value);
            } else {
                NodeList nodeList = (NodeList)value;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node n = nodeList.item(i);
                    byte[] ref = msg.getAsByte(n, false);
                    Element element = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)msg.getFactory()).newElement(ref);
                    hdrElement.addChildElement(SoapUtils.getSoapFactory((OpenSPCoop2MessageFactory)msg.getFactory(), (MessageType)msg.getMessageType()).createElement(element));
                }
            }
            return hdrElement;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getDynamicValue(String tipoRisorsa, String template, Map<String, Object> dynamicMap, Context context) throws ProtocolException {
        String valoreRisorsa = null;
        try {
            valoreRisorsa = DynamicUtils.convertDynamicPropertyValue((String)tipoRisorsa, (String)template, dynamicMap, (Context)context);
        }
        catch (Exception e) {
            throw new ProtocolException("Conversione valore della risorsa (" + tipoRisorsa + ") '" + template + "' non riuscita: " + e.getMessage(), (Throwable)e);
        }
        return valoreRisorsa;
    }

    public static String getDynamicValue(String tipoRisorsa, List<String> templates, Map<String, Object> dynamicMap, Context context) throws ProtocolException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (String template : templates) {
            try {
                String v = ModIUtilities.getDynamicValue(tipoRisorsa, template, dynamicMap, context);
                if (v == null || "".equals(v)) continue;
                return v;
            }
            catch (Exception t) {
                exceptions.add(t);
            }
        }
        Object errorMsg = "";
        StringBuilder sb = new StringBuilder();
        if (!exceptions.isEmpty()) {
            for (Exception t : exceptions) {
                if (exceptions.size() > 1) {
                    sb.append("\n");
                }
                sb.append(t.getMessage());
            }
        }
        if (sb.length() > 0) {
            errorMsg = ": " + sb.toString();
        }
        UtilsMultiException multi = new UtilsMultiException("Non \u00e8 stato possibile recuperare un valore da associare alla risorsa '" + tipoRisorsa + "'" + (String)errorMsg, exceptions.toArray(new Throwable[1]));
        throw new ProtocolException(multi.getMessage(), (Throwable)multi);
    }

    public static void addHeaderProperty(Busta busta, String hdrName, String hdrValue) {
        String pName = "ProfiloSicurezzaMessaggioSignedHeader-" + hdrName;
        String actualValue = busta.getProperty(pName);
        if (actualValue != null) {
            for (int i = 2; i < 1000; ++i) {
                pName = "ProfiloSicurezzaMessaggioSignedHeader-" + hdrName + "___#" + i;
                actualValue = busta.getProperty(pName);
                if (actualValue != null) continue;
                busta.addProperty(pName, hdrValue);
                break;
            }
        } else {
            busta.addProperty(pName, hdrValue);
        }
    }

    public static void saveDynamicMapRequest(Context context, Map<String, Object> map) {
        if (context != null && map != null) {
            context.addObject(DYNAMIC_MAP_REQUEST, map);
        }
    }

    public static Map<String, Object> removeDynamicMapRequest(Context context) {
        Object o;
        Map<String, Object> map = null;
        if (context != null && (o = context.removeObject(DYNAMIC_MAP_REQUEST)) instanceof Map) {
            return (Map)o;
        }
        return map;
    }

    public static SecurityToken newSecurityToken(Context context) {
        return SecurityTokenUtilities.newSecurityToken((Context)context);
    }

    public static SecurityToken readSecurityToken(Context context) {
        return SecurityTokenUtilities.readSecurityToken((Context)context);
    }
}

