/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.bean;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import org.openspcoop2.web.monitor.core.bean.AbstractCoreSearchForm;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;

public abstract class AbstractDateSearchForm
extends AbstractCoreSearchForm {
    private String lastPeriodo;
    protected String periodo;
    protected String periodoDefault;
    protected Date dataInizio;
    protected Date dataFine;
    private Date dataRicerca;
    private boolean useDataRicerca = false;

    public String getPeriodo() {
        if (this.periodo == null) {
            this.periodo = "Ultimo mese";
            this.setPeriodo(this.periodo);
        }
        return this.periodo;
    }

    public void periodoListener(ActionEvent ae) {
        this._setPeriodo();
    }

    public void setPeriodo(String periodo) {
        this.lastPeriodo = this.periodo;
        this.periodo = periodo;
    }

    public void setPeriodoDefault(String periodoDefault) {
        this.periodoDefault = periodoDefault;
    }

    public String getPeriodoDefault() {
        return this.periodoDefault;
    }

    public abstract String getPrintPeriodo();

    protected String getDefaultPrintPeriodoBehaviour() {
        Date inizio = null;
        if (this.dataInizio != null) {
            inizio = (Date)this.dataInizio.clone();
        }
        Date fine = null;
        if (this.dataFine != null && this.dataRicerca != null && this.useDataRicerca) {
            fine = this.dataFine.before(this.dataRicerca) ? (Date)this.dataFine.clone() : (Date)this.dataRicerca.clone();
        } else if (this.dataFine != null) {
            fine = (Date)this.dataFine.clone();
        } else if (this.dataRicerca != null && this.useDataRicerca) {
            fine = (Date)this.dataRicerca.clone();
        }
        return AbstractDateSearchForm.printPeriodo(inizio, fine);
    }

    public static String printPeriodo(Date inizio, Date fine) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS", ApplicationBean.getInstance().getLocale());
        StringBuilder bf = new StringBuilder();
        bf.append("[ ");
        if (inizio != null) {
            bf.append(sdf.format(inizio));
        } else {
            bf.append("*");
        }
        bf.append(" - ");
        if (fine != null) {
            bf.append(sdf.format(fine));
        } else {
            bf.append("*");
        }
        bf.append(" ]");
        return bf.toString();
    }

    protected void _setPeriodo() {
        Date lastDataInizio = this.dataInizio;
        Date lastDataFine = this.dataFine;
        Calendar today_without_second_and_ms = Calendar.getInstance();
        today_without_second_and_ms.set(11, 23);
        today_without_second_and_ms.set(12, 59);
        today_without_second_and_ms.clear(13);
        today_without_second_and_ms.clear(14);
        if ("Ultima ora".equals(this.periodo)) {
            this.dataFine = Calendar.getInstance().getTime();
            Calendar lasth = Calendar.getInstance();
            lasth.add(11, -1);
            this.dataInizio = lasth.getTime();
        } else if ("Ultime 12 ore".equals(this.periodo)) {
            this.dataFine = Calendar.getInstance().getTime();
            Calendar lasth = Calendar.getInstance();
            lasth.add(11, -12);
            this.dataInizio = lasth.getTime();
        } else if ("Ultime 24 ore".equals(this.periodo)) {
            this.dataFine = Calendar.getInstance().getTime();
            Calendar ieri = Calendar.getInstance();
            ieri.add(5, -1);
            this.dataInizio = ieri.getTime();
        } else if ("Ieri".equals(this.periodo)) {
            Calendar ieri = (Calendar)today_without_second_and_ms.clone();
            ieri.add(5, -1);
            ieri.set(13, 59);
            ieri.set(14, 999);
            this.dataFine = ieri.getTime();
            ieri.set(11, 0);
            ieri.set(12, 0);
            ieri.clear(13);
            ieri.clear(14);
            this.dataInizio = ieri.getTime();
        } else if ("Ultima settimana".equals(this.periodo)) {
            this.dataFine = Calendar.getInstance().getTime();
            Calendar lastWeek = (Calendar)today_without_second_and_ms.clone();
            lastWeek.set(11, 0);
            lastWeek.set(12, 0);
            lastWeek.add(5, -7);
            this.dataInizio = lastWeek.getTime();
        } else if ("Ultimo mese".equals(this.periodo)) {
            this.dataFine = Calendar.getInstance().getTime();
            Calendar lastMonth = (Calendar)today_without_second_and_ms.clone();
            lastMonth.set(11, 0);
            lastMonth.set(12, 0);
            lastMonth.add(5, -30);
            this.dataInizio = lastMonth.getTime();
        } else if ("Ultimo anno".equals(this.periodo)) {
            this.dataFine = Calendar.getInstance().getTime();
            Calendar lastyear = (Calendar)today_without_second_and_ms.clone();
            lastyear.set(11, 0);
            lastyear.set(12, 0);
            lastyear.add(1, -1);
            this.dataInizio = lastyear.getTime();
        } else if (this.lastPeriodo == null) {
            this.dataFine = Calendar.getInstance().getTime();
            Calendar ieri = Calendar.getInstance();
            ieri.add(5, -1);
            this.dataInizio = ieri.getTime();
        } else if (this.lastPeriodo.equals("Personalizzato")) {
            this.dataInizio = lastDataInizio;
            this.dataFine = lastDataFine;
        } else if ("Ieri".equals(this.lastPeriodo)) {
            Calendar ieri = (Calendar)today_without_second_and_ms.clone();
            ieri.add(5, -1);
            ieri.set(13, 59);
            ieri.set(14, 999);
            this.dataFine = ieri.getTime();
            ieri.set(11, 0);
            ieri.set(12, 0);
            ieri.clear(13);
            ieri.clear(14);
            this.dataInizio = ieri.getTime();
        } else if (this.lastPeriodo.equals("Ultima ora")) {
            this.dataFine = Calendar.getInstance().getTime();
            Calendar lasth = Calendar.getInstance();
            lasth.add(11, -1);
            this.dataInizio = lasth.getTime();
        } else if (this.lastPeriodo.equals("Ultime 12 ore")) {
            this.dataFine = Calendar.getInstance().getTime();
            Calendar lasth = Calendar.getInstance();
            lasth.add(11, -12);
            this.dataInizio = lasth.getTime();
        } else if ("Ultime 24 ore".equals(this.lastPeriodo)) {
            this.dataFine = Calendar.getInstance().getTime();
            Calendar ieri = Calendar.getInstance();
            ieri.add(5, -1);
            this.dataInizio = ieri.getTime();
        } else if ("Ultima settimana".equals(this.lastPeriodo)) {
            this.dataFine = Calendar.getInstance().getTime();
            Calendar lastWeek = (Calendar)today_without_second_and_ms.clone();
            lastWeek.set(11, 0);
            lastWeek.set(12, 0);
            lastWeek.add(5, -7);
            this.dataInizio = lastWeek.getTime();
        } else if ("Ultimo mese".equals(this.lastPeriodo)) {
            this.dataFine = Calendar.getInstance().getTime();
            Calendar lastMonth = (Calendar)today_without_second_and_ms.clone();
            lastMonth.set(11, 0);
            lastMonth.set(12, 0);
            lastMonth.add(5, -30);
            this.dataInizio = lastMonth.getTime();
        } else if (this.lastPeriodo.equals("Ultimo anno")) {
            this.dataFine = Calendar.getInstance().getTime();
            Calendar lastyear = (Calendar)today_without_second_and_ms.clone();
            lastyear.set(11, 0);
            lastyear.set(12, 0);
            lastyear.add(1, -1);
            this.dataInizio = lastyear.getTime();
        }
    }

    public boolean isPeriodoPersonalizzato() {
        return "Personalizzato".equals(this.periodo);
    }

    public boolean isPeriodoUltime12ore() {
        return "Ultime 12 ore".equals(this.periodo);
    }

    public boolean isLastPeriodoPersonalizzato() {
        return "Personalizzato".equals(this.lastPeriodo);
    }

    public Date getDataInizio() {
        return this.dataInizio;
    }

    public void setDataInizio(Date dataInizio) {
        if (dataInizio != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(dataInizio);
            c.clear(13);
            c.clear(14);
            this.dataInizio = c.getTime();
        } else {
            this.dataInizio = null;
        }
    }

    public Date getDataFine() {
        return this.dataFine;
    }

    public void setDataFine(Date dataFine) {
        if (dataFine != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(dataFine);
            c.set(13, 59);
            c.set(14, 999);
            this.dataFine = c.getTime();
        } else {
            this.dataFine = null;
        }
    }

    public void dataInizioChangeListener(ValueChangeEvent evt) {
        this.setDataInizio((Date)evt.getNewValue());
    }

    public void dataFineChangeListener(ValueChangeEvent evt) {
        this.setDataFine((Date)evt.getNewValue());
    }

    public void dataFineListener(ActionEvent ae) {
    }

    public void dataInizioListener(ActionEvent ae) {
    }

    public Date getDataRicerca() {
        if (this.useDataRicerca) {
            return this.dataRicerca;
        }
        return null;
    }

    public Date getDataRicercaRaw() {
        return this.dataRicerca;
    }

    public void aggiornaNuovaDataRicerca() {
        this.dataRicerca = new Date();
        this.useDataRicerca = false;
    }

    public void congelaDataRicerca() {
        this.useDataRicerca = true;
    }
}

