/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.bean;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DialogInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean resizeable;
    private boolean moveable;
    private String width;
    private String height;
    private String headerFinestraModale;
    private String headerBody;
    private List<String> listBody;
    private String body;
    private String buttonIcon;

    public DialogInfo(String headerFinestraModale) {
        this.headerFinestraModale = headerFinestraModale;
        this.resizeable = false;
        this.moveable = false;
        this.width = "500";
        this.height = "300";
        this.buttonIcon = "info_outline";
    }

    public String getHeaderFinestraModale() {
        return this.headerFinestraModale;
    }

    public String getHeaderBody() {
        return this.headerBody;
    }

    public void setHeaderBody(String headerBody) {
        this.headerBody = headerBody;
    }

    public List<String> getListBody() {
        return this.listBody;
    }

    public String getListBodyHtml() {
        StringBuilder sb = new StringBuilder();
        if (this.getListBody() != null && !this.getListBody().isEmpty()) {
            sb.append("<ul>");
            for (String info : this.getListBody()) {
                sb.append("<li>").append(info).append("</li>");
            }
            sb.append("</ul>");
        }
        return sb.toString();
    }

    public void setListBody(List<String> listBody) {
        this.listBody = listBody;
    }

    public String getBody() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((String)this.body)) {
            sb.append(this.body);
        } else {
            sb.append("<p>");
            boolean addBreak = false;
            if (StringUtils.isNotEmpty((String)this.getHeaderBody())) {
                sb.append("<span>").append(this.getHeaderBody()).append("</span>");
                addBreak = true;
            }
            if (StringUtils.isNotEmpty((String)this.getListBodyHtml())) {
                if (addBreak) {
                    sb.append("<br/>");
                }
                sb.append(this.getListBodyHtml());
            }
            sb.append("</p>");
        }
        return sb.toString();
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getButtonIcon() {
        return this.buttonIcon;
    }

    public void setButtonIcon(String buttonIcon) {
        this.buttonIcon = buttonIcon;
    }

    public boolean isResizeable() {
        return this.resizeable;
    }

    public void setResizeable(boolean resizeable) {
        this.resizeable = resizeable;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public void setMoveable(boolean moveable) {
        this.moveable = moveable;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }
}

