/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.constants;

public enum ModalitaRicercaTransazioni {
    ANDAMENTO_TEMPORALE("intervalloTemporale"),
    RICERCA_LIBERA("ricercaLibera"),
    MITTENTE_TOKEN_INFO("mittenteTokenInfo"),
    MITTENTE_SOGGETTO("mittenteSoggetto"),
    MITTENTE_APPLICATIVO("mittenteApplicativo"),
    MITTENTE_IDENTIFICATIVO_AUTENTICATO("mittenteIdentificativoAutenticato"),
    MITTENTE_INDIRIZZO_IP("mittenteIndirizzoIP"),
    ID_APPLICATIVO_AVANZATA("idApplicativo"),
    ID_APPLICATIVO_BASE("idApplicativoBase"),
    ID_MESSAGGIO("idMessaggio"),
    ID_TRANSAZIONE("idTransazione"),
    ID_TOKEN("idToken"),
    PURPOSE_ID("purposeId");

    private String value;

    private ModalitaRicercaTransazioni(String ruolo) {
        this.value = ruolo;
    }

    public String toString() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public static ModalitaRicercaTransazioni getFromString(String v) {
        ModalitaRicercaTransazioni res = null;
        for (ModalitaRicercaTransazioni tmp : ModalitaRicercaTransazioni.values()) {
            if (!tmp.getValue().equals(v)) continue;
            res = tmp;
            break;
        }
        return res;
    }

    public static int getLivello(String modalita) {
        ModalitaRicercaTransazioni modalitaEnum = ModalitaRicercaTransazioni.getFromString(modalita);
        if (modalitaEnum != null) {
            switch (modalitaEnum) {
                case ANDAMENTO_TEMPORALE: 
                case ID_MESSAGGIO: 
                case ID_TRANSAZIONE: 
                case MITTENTE_APPLICATIVO: 
                case MITTENTE_IDENTIFICATIVO_AUTENTICATO: 
                case MITTENTE_INDIRIZZO_IP: 
                case MITTENTE_SOGGETTO: 
                case MITTENTE_TOKEN_INFO: 
                case RICERCA_LIBERA: 
                case ID_TOKEN: 
                case PURPOSE_ID: {
                    return 1;
                }
                case ID_APPLICATIVO_AVANZATA: 
                case ID_APPLICATIVO_BASE: {
                    return 2;
                }
            }
        }
        return 1;
    }
}

