/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.core;

import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.search.IdSoggetto;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.dao.IServiceManager;
import org.openspcoop2.core.commons.search.utils.ProjectInfo;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.config.CanaleConfigurazioneNodo;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.constants.PortaApplicativaSoggettiFruitori;
import org.openspcoop2.core.config.constants.PortaDelegataSoggettiErogatori;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.utils.ProtocolUtils;
import org.openspcoop2.utils.resources.MapReader;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.bean.UserDetailsBean;
import org.openspcoop2.web.monitor.core.constants.TipologiaRicerca;
import org.openspcoop2.web.monitor.core.core.ConfigurazioneSoggettiVisualizzatiSearchForm;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.DynamicPdDBeanUtils;
import org.openspcoop2.web.monitor.core.utils.ParseUtility;
import org.slf4j.Logger;

public class Utility {
    private static final String REPORTISTICA_DIAGNOSTICI_FREQ_INVIO = "reportistica.diagnostici.freq_invio.";
    private static final String REPORTISTICA_DIAGNOSTICI_INTERVALLO_INTERESSE = "reportistica.diagnostici.intervallo_interesse.";
    private static final String REPORTISTICA_TRACCE_FREQ_INVIO = "reportistica.tracce.freq_invio.";
    private static final String REPORTISTICA_TRACCE_INTERVALLO_INTERESSE = "reportistica.tracce.intervallo_interesse.";
    private static final String STATUS_INTERVALLO_STORICO = "status.storico.";
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static ArrayList<String> frequenzaInvioDiagnostici = null;
    private static ArrayList<String> frequenzaInvioTracce = null;
    private static ArrayList<String> intervalloInteresseDiagnostici = null;
    private static ArrayList<String> intervalloInteresseTracce = null;
    private static ArrayList<String> statoSistemaStorico = null;
    private static LoginBean loginBean;
    private static Configurazione configurazioneGenerale;
    private static Boolean filtroDominioAbilitato;
    private static Map<String, String> mapIdentificativoPorta;

    private Utility() {
    }

    public static void setLoginMBean(LoginBean loginBean) {
        Utility.loginBean = loginBean;
    }

    public static LoginBean getLoginBean() {
        FacesContext fc = FacesContext.getCurrentInstance();
        if (fc != null) {
            ExternalContext ec = fc.getExternalContext();
            return (LoginBean)ec.getSessionMap().get("loginBean");
        }
        return loginBean;
    }

    public static LoginBean getLoginBeanFromSession(HttpSession sessione) {
        if (sessione != null) {
            return (LoginBean)sessione.getAttribute("loginBean");
        }
        return null;
    }

    private static synchronized void initFrequenzaInvioDiagnostici() {
        if (frequenzaInvioDiagnostici == null) {
            frequenzaInvioDiagnostici = Utility.loadAndOrderProps(REPORTISTICA_DIAGNOSTICI_FREQ_INVIO);
        }
    }

    public static List<String> getFrequenzaInvioDiagnostici() {
        if (frequenzaInvioDiagnostici == null) {
            Utility.initFrequenzaInvioDiagnostici();
        }
        return frequenzaInvioDiagnostici;
    }

    private static synchronized void initFrequenzaInvioTracce() {
        if (frequenzaInvioTracce == null) {
            frequenzaInvioTracce = Utility.loadAndOrderProps(REPORTISTICA_TRACCE_FREQ_INVIO);
        }
    }

    public static List<String> getFrequenzaInvioTracce() {
        if (frequenzaInvioTracce == null) {
            Utility.initFrequenzaInvioTracce();
        }
        return frequenzaInvioTracce;
    }

    private static synchronized void initIntervalloInteresseDiagnostici() {
        if (intervalloInteresseDiagnostici == null) {
            intervalloInteresseDiagnostici = Utility.loadAndOrderProps(REPORTISTICA_DIAGNOSTICI_INTERVALLO_INTERESSE);
        }
    }

    public static List<String> getIntervalloInteresseDiagnostici() {
        if (intervalloInteresseDiagnostici == null) {
            Utility.initIntervalloInteresseDiagnostici();
        }
        return intervalloInteresseDiagnostici;
    }

    private static synchronized void initIntervalloInteresseTracce() {
        if (intervalloInteresseTracce == null) {
            intervalloInteresseTracce = Utility.loadAndOrderProps(REPORTISTICA_TRACCE_INTERVALLO_INTERESSE);
        }
    }

    public static List<String> getIntervalloInteresseTracce() {
        if (intervalloInteresseTracce == null) {
            Utility.initIntervalloInteresseTracce();
        }
        return intervalloInteresseTracce;
    }

    private static synchronized void initStatoSistemaStorico() {
        if (statoSistemaStorico == null) {
            statoSistemaStorico = Utility.loadAndOrderProps(STATUS_INTERVALLO_STORICO);
        }
    }

    public static List<String> getStatoSistemaStorico() {
        if (statoSistemaStorico == null) {
            Utility.initStatoSistemaStorico();
        }
        return statoSistemaStorico;
    }

    private static ArrayList<String> loadAndOrderProps(String prefix) {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance(log);
            Enumeration<?> keys = govwayMonitorProperties.keys();
            HashMap<CallSite, String> matched = new HashMap<CallSite, String>();
            ArrayList<CallSite> matchedKeys = new ArrayList<CallSite>();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith(prefix)) continue;
                String mk = "0" + key.substring(prefix.length());
                String string = govwayMonitorProperties.getProperty(key, false, false);
                matched.put((CallSite)((Object)mk), string);
                matchedKeys.add((CallSite)((Object)mk));
            }
            Collections.sort(matchedKeys);
            ArrayList<String> ordered = new ArrayList<String>();
            for (String string : matchedKeys) {
                String val = (String)matched.get(string);
                ordered.add(val);
            }
            return ordered;
        }
        catch (Exception e) {
            log.info("Errore durante il caricamento frequenza invio diagnostici, {}", (Object)e.getMessage());
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static int getFreqInvioValueForDiagnostici(String label) {
        return Utility.getValueFromLabel(REPORTISTICA_DIAGNOSTICI_FREQ_INVIO, label);
    }

    public static int getIntervalloInteresseValueDiagnostici(String label) {
        return Utility.getValueFromLabel(REPORTISTICA_DIAGNOSTICI_INTERVALLO_INTERESSE, label);
    }

    public static int getFreqInvioValueForTracce(String label) {
        return Utility.getValueFromLabel(REPORTISTICA_TRACCE_FREQ_INVIO, label);
    }

    public static int getIntervalloInteresseValueTracce(String label) {
        return Utility.getValueFromLabel(REPORTISTICA_TRACCE_INTERVALLO_INTERESSE, label);
    }

    public static String getFreqInvioLabelForDiagnistici(int value) {
        return Utility.getLabelFromValue(REPORTISTICA_DIAGNOSTICI_FREQ_INVIO, value);
    }

    public static String getFreqInvioLabelForTracce(int value) {
        return Utility.getLabelFromValue(REPORTISTICA_TRACCE_FREQ_INVIO, value);
    }

    public static String getPeriodoInteresseLabelForDiagnistici(int value) {
        return Utility.getLabelFromValue(REPORTISTICA_DIAGNOSTICI_INTERVALLO_INTERESSE, value);
    }

    public static String getPeriodoInteresseLabelForTracce(int value) {
        return Utility.getLabelFromValue(REPORTISTICA_TRACCE_INTERVALLO_INTERESSE, value);
    }

    private static int getValueFromLabel(String prefix, String label) {
        try {
            if (label == null || prefix == null) {
                return 0;
            }
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance(log);
            Enumeration<?> keys = govwayMonitorProperties.keys();
            while (keys.hasMoreElements()) {
                String prop;
                String key = (String)keys.nextElement();
                if (!key.startsWith(prefix) || !label.equals(prop = govwayMonitorProperties.getProperty(key, false, false))) continue;
                String val = key.substring(prefix.length());
                try {
                    return Integer.parseInt(val);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    private static String getLabelFromValue(String prefix, int value) {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance(log);
            String key = prefix + value;
            String label = govwayMonitorProperties.getProperty(key, false, false);
            if (label == null) {
                return "";
            }
            return label;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static UserDetailsBean getLoggedUser() {
        LoginBean lb = Utility.getLoginBean();
        if (lb != null && lb.isLoggedIn()) {
            return lb.getLoggedUser();
        }
        return null;
    }

    public static User getLoggedUtente() {
        LoginBean lb = Utility.getLoginBean();
        if (lb != null && lb.isLoggedIn()) {
            return lb.getUtente();
        }
        return null;
    }

    public static String getSoggettoSelezionatoPerVersionInfo() {
        try {
            User utente = Utility.getLoggedUtente();
            if (utente != null) {
                return utente.getSoggettoSelezionatoPddMonitor();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getLoggedUtenteModalita() {
        LoginBean lb = Utility.getLoginBean();
        if (lb != null && lb.isLoggedIn()) {
            return lb.getModalita();
        }
        return null;
    }

    public static String getLoggedUtenteSoggettoPddMonitor() {
        LoginBean lb = Utility.getLoginBean();
        if (lb != null && lb.isLoggedIn()) {
            return lb.getSoggettoPddMonitor();
        }
        return null;
    }

    public static synchronized void setStaticConfigurazioneGenerale(Configurazione configurazioneGenerale) {
        Utility.configurazioneGenerale = configurazioneGenerale;
    }

    public static Configurazione getConfigurazioneGenerale() {
        if (configurazioneGenerale != null) {
            return configurazioneGenerale;
        }
        LoginBean lb = Utility.getLoginBean();
        if (lb != null && lb.isLoggedIn()) {
            return lb.getConfigurazioneGenerale();
        }
        if (lb == null) {
            lb = new LoginBean(true);
            return lb.getConfigurazioneGenerale();
        }
        return null;
    }

    public static synchronized void setStaticFiltroDominioAbilitato(boolean filtroDominioAbilitato) {
        Utility.filtroDominioAbilitato = filtroDominioAbilitato;
    }

    public static boolean isFiltroDominioAbilitato() {
        if (filtroDominioAbilitato != null) {
            return filtroDominioAbilitato;
        }
        if (Utility.isMultitenantAbilitato()) {
            String soggettoOperativoSelezionato;
            User utente = Utility.getLoggedUtente();
            if (utente != null && (soggettoOperativoSelezionato = utente.getSoggettoSelezionatoPddMonitor()) != null) {
                return true;
            }
            LoginBean lb = Utility.getLoginBean();
            if (lb != null && lb.isLoggedIn()) {
                return lb.isShowFiltroSoggettoLocale();
            }
            if (loginBean != null) {
                return loginBean.isShowFiltroSoggettoLocale();
            }
            if (lb == null) {
                lb = new LoginBean(true);
                return lb.isShowFiltroSoggettoLocale();
            }
            return true;
        }
        return false;
    }

    public static boolean isCanaliAbilitato() {
        Configurazione configurazioneGenerale = null;
        if (Utility.configurazioneGenerale != null) {
            configurazioneGenerale = Utility.configurazioneGenerale;
        } else {
            LoginBean lb = Utility.getLoginBean();
            if (lb != null && lb.isLoggedIn()) {
                configurazioneGenerale = lb.getConfigurazioneGenerale();
            } else if (lb == null) {
                lb = new LoginBean(true);
                configurazioneGenerale = lb.getConfigurazioneGenerale();
            }
        }
        if (configurazioneGenerale != null && configurazioneGenerale.getGestioneCanali() != null && configurazioneGenerale.getGestioneCanali().getStato() != null) {
            return StatoFunzionalita.ABILITATO.equals((Object)configurazioneGenerale.getGestioneCanali().getStato());
        }
        return false;
    }

    public static List<String> getCanali() {
        Configurazione configurazioneGenerale = null;
        if (Utility.configurazioneGenerale != null) {
            configurazioneGenerale = Utility.configurazioneGenerale;
        } else {
            LoginBean lb = Utility.getLoginBean();
            if (lb != null && lb.isLoggedIn()) {
                configurazioneGenerale = lb.getConfigurazioneGenerale();
            } else if (lb == null) {
                lb = new LoginBean(true);
                configurazioneGenerale = lb.getConfigurazioneGenerale();
            }
        }
        if (configurazioneGenerale != null && configurazioneGenerale.getGestioneCanali() != null && configurazioneGenerale.getGestioneCanali().getStato() != null && StatoFunzionalita.ABILITATO.equals((Object)configurazioneGenerale.getGestioneCanali().getStato())) {
            ArrayList<String> l = new ArrayList<String>();
            if (configurazioneGenerale.getGestioneCanali().sizeCanaleList() > 0) {
                for (CanaleConfigurazione c : configurazioneGenerale.getGestioneCanali().getCanaleList()) {
                    l.add(c.getNome());
                }
            }
            return l;
        }
        return null;
    }

    public static List<String> getNodi(String canale) {
        Configurazione configurazioneGenerale = null;
        if (Utility.configurazioneGenerale != null) {
            configurazioneGenerale = Utility.configurazioneGenerale;
        } else {
            LoginBean lb = Utility.getLoginBean();
            if (lb != null && lb.isLoggedIn()) {
                configurazioneGenerale = lb.getConfigurazioneGenerale();
            } else if (lb == null) {
                lb = new LoginBean(true);
                configurazioneGenerale = lb.getConfigurazioneGenerale();
            }
        }
        if (configurazioneGenerale != null && configurazioneGenerale.getGestioneCanali() != null && configurazioneGenerale.getGestioneCanali().getStato() != null && StatoFunzionalita.ABILITATO.equals((Object)configurazioneGenerale.getGestioneCanali().getStato())) {
            ArrayList<String> l = new ArrayList<String>();
            if (configurazioneGenerale.getGestioneCanali().sizeNodoList() > 0) {
                for (CanaleConfigurazioneNodo nodo : configurazioneGenerale.getGestioneCanali().getNodoList()) {
                    if (nodo.getCanaleList() == null || !nodo.getCanaleList().contains(canale)) continue;
                    l.add(nodo.getNome());
                }
            }
            return l;
        }
        return null;
    }

    public static boolean isMultitenantAbilitato() {
        Configurazione configurazioneGenerale = null;
        if (Utility.configurazioneGenerale != null) {
            configurazioneGenerale = Utility.configurazioneGenerale;
        } else {
            LoginBean lb = Utility.getLoginBean();
            if (lb != null && lb.isLoggedIn()) {
                configurazioneGenerale = lb.getConfigurazioneGenerale();
            } else if (lb == null) {
                lb = new LoginBean(true);
                configurazioneGenerale = lb.getConfigurazioneGenerale();
            }
        }
        if (configurazioneGenerale != null && configurazioneGenerale.getMultitenant() != null && configurazioneGenerale.getMultitenant().getStato() != null) {
            return StatoFunzionalita.ABILITATO.equals((Object)configurazioneGenerale.getMultitenant().getStato());
        }
        return false;
    }

    public static PortaDelegataSoggettiErogatori getMultitenantAbilitatoFruizioneSceltaSoggettiErogatori() {
        Configurazione configurazioneGenerale = null;
        if (Utility.configurazioneGenerale != null) {
            configurazioneGenerale = Utility.configurazioneGenerale;
        } else {
            LoginBean lb = Utility.getLoginBean();
            if (lb != null && lb.isLoggedIn()) {
                configurazioneGenerale = lb.getConfigurazioneGenerale();
            } else if (lb == null) {
                lb = new LoginBean(true);
                configurazioneGenerale = lb.getConfigurazioneGenerale();
            }
        }
        if (configurazioneGenerale != null && configurazioneGenerale.getMultitenant() != null) {
            return configurazioneGenerale.getMultitenant().getFruizioneSceltaSoggettiErogatori();
        }
        return null;
    }

    public static PortaApplicativaSoggettiFruitori getMultitenantAbilitatoErogazioneSceltaSoggettiFruitori() {
        Configurazione configurazioneGenerale = null;
        if (Utility.configurazioneGenerale != null) {
            configurazioneGenerale = Utility.configurazioneGenerale;
        } else {
            LoginBean lb = Utility.getLoginBean();
            if (lb != null && lb.isLoggedIn()) {
                configurazioneGenerale = lb.getConfigurazioneGenerale();
            } else if (lb == null) {
                lb = new LoginBean(true);
                configurazioneGenerale = lb.getConfigurazioneGenerale();
            }
        }
        if (configurazioneGenerale != null && configurazioneGenerale.getMultitenant() != null) {
            return configurazioneGenerale.getMultitenant().getErogazioneSceltaSoggettiFruitori();
        }
        return null;
    }

    public static ConfigurazioneSoggettiVisualizzatiSearchForm getMultitenantAbilitatoSoggettiConfig(TipologiaRicerca ricercaParam) {
        boolean multiTenant = Utility.isMultitenantAbilitato();
        boolean includiSoloOperativi = false;
        boolean includiSoloEsterni = false;
        boolean escludiSoggettoSelezionato = false;
        TipologiaRicerca ricerca = ricercaParam;
        if (ricerca == null) {
            ricerca = TipologiaRicerca.all;
        }
        block0 : switch (ricerca) {
            case all: {
                break;
            }
            case uscita: {
                PortaDelegataSoggettiErogatori scelta;
                if (multiTenant) {
                    scelta = Utility.getMultitenantAbilitatoFruizioneSceltaSoggettiErogatori();
                    if (scelta == null) {
                        scelta = PortaDelegataSoggettiErogatori.SOGGETTI_ESTERNI;
                    }
                    switch (scelta) {
                        case SOGGETTI_ESTERNI: {
                            includiSoloEsterni = true;
                            break block0;
                        }
                        case ESCLUDI_SOGGETTO_FRUITORE: {
                            escludiSoggettoSelezionato = true;
                            break block0;
                        }
                    }
                    break;
                }
                includiSoloEsterni = true;
                break;
            }
            case ingresso: {
                PortaDelegataSoggettiErogatori scelta;
                if (multiTenant) {
                    scelta = Utility.getMultitenantAbilitatoErogazioneSceltaSoggettiFruitori();
                    if (scelta == null) {
                        scelta = PortaApplicativaSoggettiFruitori.SOGGETTI_ESTERNI;
                    }
                    switch (1.$SwitchMap$org$openspcoop2$core$config$constants$PortaApplicativaSoggettiFruitori[scelta.ordinal()]) {
                        case 1: {
                            includiSoloEsterni = true;
                            break block0;
                        }
                        case 2: {
                            escludiSoggettoSelezionato = true;
                            break block0;
                        }
                    }
                    break;
                }
                includiSoloEsterni = true;
            }
        }
        ConfigurazioneSoggettiVisualizzatiSearchForm config = new ConfigurazioneSoggettiVisualizzatiSearchForm();
        config.setIncludiSoloOperativi(includiSoloOperativi);
        config.setIncludiSoloEsterni(includiSoloEsterni);
        config.setEscludiSoggettoSelezionato(escludiSoggettoSelezionato);
        return config;
    }

    public static String fileSizeConverter(Number bytes) {
        MessageFormat mf = new MessageFormat("{0,number,#.##}");
        Double len = null;
        Object res = "";
        len = bytes.doubleValue();
        long d = Math.round(len / 1024.0);
        if (d <= 1L) {
            Object[] objs = new Object[]{len};
            res = mf.format(objs);
            res = (String)res + " B";
        } else if (d > 1L && d < 1000L) {
            Object[] objs = new Object[]{len / 1024.0};
            res = mf.format(objs);
            res = (String)res + " KB";
        } else if (d >= 1000L && d < 1000000L) {
            Object[] objs = new Object[]{len / 1048576.0};
            res = mf.format(objs);
            res = (String)res + " MB";
        } else {
            Object[] objs = new Object[]{len / 1.073741824E9};
            res = mf.format(objs);
            res = (String)res + " GB";
        }
        return res;
    }

    public static String numberConverter(Number bytes) {
        NumberFormat nf = NumberFormat.getInstance(ApplicationBean.getInstance().getLocale());
        String res = "";
        res = nf.format(bytes.longValue());
        return res;
    }

    public static String parseNomeSoggetto(String tipoNomeSoggetto) {
        return ParseUtility.parseNomeSoggetto(tipoNomeSoggetto);
    }

    public static String parseTipoSoggetto(String tipoNomeSoggetto) {
        return ParseUtility.parseTipoSoggetto(tipoNomeSoggetto);
    }

    public static Soggetto getSoggetto(IdSoggetto idSog) {
        LoginBean lb = Utility.getLoginBean();
        if (lb != null && lb.isLoggedIn()) {
            return lb.getSoggetto(idSog);
        }
        if (lb == null) {
            lb = new LoginBean(true);
            return lb.getSoggetto(idSog);
        }
        return null;
    }

    public static IDServizio parseSoggettoServizio(String input) {
        return ParseUtility.parseSoggettoServizio(input);
    }

    public static String convertToSoggettoServizio(IDServizio idServizio) {
        return ParseUtility.convertToSoggettoServizio(idServizio);
    }

    public static IDServizio parseServizioSoggetto(String input) throws CoreException {
        return ParseUtility.parseServizioSoggetto(input);
    }

    public static String convertToServizioSoggetto(IDServizio idServizio) throws CoreException {
        return ParseUtility.convertToServizioSoggetto(idServizio);
    }

    public static synchronized void putIdentificativoPorta(String tipoSoggetto, String nomeSoggetto, String idPorta) {
        String key = tipoSoggetto + "/" + nomeSoggetto;
        mapIdentificativoPorta.put(key, idPorta);
    }

    public static boolean existsIdentificativoPorta(String tipoSoggetto, String nomeSoggetto) {
        String key = tipoSoggetto + "/" + nomeSoggetto;
        return mapIdentificativoPorta.containsKey(key);
    }

    public static String getIdentificativoPorta(String tipoSoggetto, String nomeSoggetto) throws CoreException {
        String idPorta = null;
        String key = tipoSoggetto + "/" + nomeSoggetto;
        if (mapIdentificativoPorta.containsKey(key)) {
            idPorta = mapIdentificativoPorta.get(key);
        } else {
            try {
                Logger log = LoggerManager.getPddMonitorSqlLogger();
                ProjectInfo prInfo = ProjectInfo.getInstance();
                IServiceManager sm = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)prInfo, log);
                IdSoggetto idSog = new IdSoggetto();
                idSog.setTipo(tipoSoggetto);
                idSog.setNome(nomeSoggetto);
                Soggetto soggetto = (Soggetto)sm.getSoggettoServiceSearch().get((Object)idSog);
                idPorta = soggetto.getIdentificativoPorta();
            }
            catch (Exception e) {
                throw new CoreException("Si e' verificato un errore durante il recupero del soggetto dal registro: tipoSoggetto[" + tipoSoggetto + "] nomeSoggetto[" + nomeSoggetto + "]", (Throwable)e);
            }
        }
        return idPorta;
    }

    public static List<String> getListaProtocolli(User utente, List<Soggetto> listaSoggettiGestione, ProtocolFactoryManager pfManager, MapReader<String, IProtocolFactory<?>> protocolFactories) throws ProtocolException {
        ArrayList<String> listaNomiProtocolli = new ArrayList<String>();
        if (listaSoggettiGestione != null && !listaSoggettiGestione.isEmpty()) {
            ArrayList<String> tipiSoggetti = new ArrayList<String>();
            for (Soggetto soggetto : listaSoggettiGestione) {
                String tipoSoggetto = soggetto.getTipoSoggetto();
                if (tipiSoggetti.contains(tipoSoggetto)) continue;
                tipiSoggetti.add(tipoSoggetto);
            }
            for (String tipo : tipiSoggetti) {
                String protocolBySubjectType = pfManager.getProtocolByOrganizationType(tipo);
                if (listaNomiProtocolli.contains(protocolBySubjectType)) continue;
                listaNomiProtocolli.add(protocolBySubjectType);
            }
        } else if (utente.getProtocolliSupportati() != null) {
            for (String protocolKey : utente.getProtocolliSupportati()) {
                if (listaNomiProtocolli.contains(protocolKey)) continue;
                listaNomiProtocolli.add(protocolKey);
            }
        } else {
            Enumeration keys = protocolFactories.keys();
            while (keys.hasMoreElements()) {
                String protocolKey = (String)keys.nextElement();
                if (listaNomiProtocolli.contains(protocolKey)) continue;
                listaNomiProtocolli.add(protocolKey);
            }
        }
        return ProtocolUtils.orderProtocolli(listaNomiProtocolli);
    }

    public static List<Soggetto> getSoggettiOperativiAssociatiAlProfilo(UserDetailsBean u, String profiloSelezionato) {
        ArrayList<Soggetto> soggetti = new ArrayList<Soggetto>();
        if (u.getUtenteSoggettoProtocolliMap().containsKey(profiloSelezionato)) {
            for (IDSoggetto idSog : u.getUtenteSoggettoProtocolliMap().get(profiloSelezionato)) {
                IdSoggetto idsog2 = new IdSoggetto();
                idsog2.setNome(idSog.getNome());
                idsog2.setTipo(idSog.getTipo());
                Soggetto soggetto = Utility.getSoggetto(idsog2);
                soggetti.add(soggetto);
            }
        }
        return soggetti;
    }

    public static boolean isTipoSoggettoCompatibileConProtocollo(String tipoSoggetto, String tipoProtocollo) throws ProtocolException {
        return DynamicPdDBeanUtils.getInstance(log).isTipoSoggettoCompatibileConProtocollo(tipoSoggetto, tipoProtocollo);
    }

    public static List<Soggetto> getSoggettiGestione(User u, String tipoNomeSoggettoLocale) {
        ArrayList<Soggetto> soggetti = new ArrayList<Soggetto>();
        if (StringUtils.isNotEmpty((String)tipoNomeSoggettoLocale)) {
            String tipo = Utility.parseTipoSoggetto(tipoNomeSoggettoLocale);
            String nome = Utility.parseNomeSoggetto(tipoNomeSoggettoLocale);
            for (IDSoggetto idSog : u.getSoggetti()) {
                if (!idSog.getTipo().equals(tipo) || !idSog.getNome().equals(nome)) continue;
                IdSoggetto idsog2 = new IdSoggetto();
                idsog2.setNome(idSog.getNome());
                idsog2.setTipo(idSog.getTipo());
                Soggetto soggetto = Utility.getSoggetto(idsog2);
                soggetti.add(soggetto);
                break;
            }
            return soggetti;
        }
        ArrayList<CallSite> checkUnique = new ArrayList<CallSite>();
        for (IDSoggetto idSog : u.getSoggetti()) {
            String tipoNome = idSog.getTipo() + "/" + idSog.getNome();
            if (checkUnique.contains(tipoNome)) continue;
            IdSoggetto idsog2 = new IdSoggetto();
            idsog2.setNome(idSog.getNome());
            idsog2.setTipo(idSog.getTipo());
            Soggetto s = Utility.getSoggetto(idsog2);
            soggetti.add(s);
            checkUnique.add((CallSite)((Object)tipoNome));
        }
        return soggetti;
    }

    public static List<String> getProtocolli(User utente) throws ProtocolException {
        return Utility.getProtocolli(utente, false);
    }

    public static List<String> getProtocolli(User utente, boolean ignoreProtocolloSelezionato) throws ProtocolException {
        ProtocolFactoryManager pfManager = ProtocolFactoryManager.getInstance();
        MapReader protocolFactories = pfManager.getProtocolFactories();
        return Utility.getProtocolli(utente, pfManager, protocolFactories, ignoreProtocolloSelezionato);
    }

    public static List<String> getProtocolli(User utente, ProtocolFactoryManager pfManager, MapReader<String, IProtocolFactory<?>> protocolFactories) throws ProtocolException {
        return Utility.getProtocolli(utente, pfManager, protocolFactories, false);
    }

    public static List<String> getProtocolli(User utente, ProtocolFactoryManager pfManager, MapReader<String, IProtocolFactory<?>> protocolFactories, boolean ignoreProtocolloSelezionato) throws ProtocolException {
        return Utility.getProtocolli(utente, pfManager, protocolFactories, ignoreProtocolloSelezionato, false);
    }

    public static List<String> getProtocolli(User utente, ProtocolFactoryManager pfManager, MapReader<String, IProtocolFactory<?>> protocolFactories, boolean ignoreProtocolloSelezionato, boolean consideraProtocolliCompatibiliSoggettoSelezionato) throws ProtocolException {
        ArrayList<String> protocolliList = new ArrayList<String>();
        if (!ignoreProtocolloSelezionato) {
            if (utente.getProtocolloSelezionatoPddMonitor() != null) {
                protocolliList.add(utente.getProtocolloSelezionatoPddMonitor());
                return protocolliList;
            }
            if (consideraProtocolliCompatibiliSoggettoSelezionato && utente.getProtocolloSelezionatoPddMonitor() != null && !"".equals(utente.getProtocolloSelezionatoPddMonitor())) {
                String tipoSoggetto = utente.getProtocolloSelezionatoPddMonitor().split("/")[0];
                String protocollo = pfManager.getProtocolByOrganizationType(tipoSoggetto);
                protocolliList.add(protocollo);
                return protocolliList;
            }
        }
        List listProtocolli = null;
        listProtocolli = utente.getProtocolliSupportati() != null && !utente.getProtocolliSupportati().isEmpty() ? ProtocolUtils.orderProtocolli((List)utente.getProtocolliSupportati()) : Utility.getProtocolli(protocolFactories);
        if (utente.getSoggetti() != null && !utente.getSoggetti().isEmpty()) {
            ArrayList<String> protocolliNewList = new ArrayList<String>();
            for (IDSoggetto idSoggetto : utente.getSoggetti()) {
                String protocollo = pfManager.getProtocolByOrganizationType(idSoggetto.getTipo());
                if (protocolliNewList.contains(protocollo)) continue;
                protocolliNewList.add(protocollo);
            }
            return protocolliNewList;
        }
        return listProtocolli;
    }

    public static List<String> getProtocolli(MapReader<String, IProtocolFactory<?>> protocolFactories) {
        ArrayList<String> protocolliList = new ArrayList<String>();
        Enumeration protocolli = protocolFactories.keys();
        while (protocolli.hasMoreElements()) {
            String protocollo = (String)protocolli.nextElement();
            protocolliList.add(protocollo);
        }
        return ProtocolUtils.orderProtocolli(protocolliList);
    }

    public static String normalizeLabel(String label, int maxWidth) {
        return Utility.normalizeLabel(label, maxWidth, false, false);
    }

    public static String normalizeLabel(String label, int maxWidth, boolean multiline, boolean soloTestoPrimaLinea) {
        if (label.length() > maxWidth) {
            if (multiline) {
                StringBuilder sb = new StringBuilder();
                int startToken = 0;
                int endToken = startToken + maxWidth;
                if (!soloTestoPrimaLinea) {
                    sb.append("<p>");
                    sb.append(label.substring(startToken, endToken)).append("-");
                    sb.append("</p>");
                    do {
                        if ((endToken = (startToken += maxWidth) + maxWidth) >= label.length()) {
                            endToken = label.length();
                        }
                        if (startToken >= label.length()) continue;
                        sb.append("<p>");
                        sb.append(label.substring(startToken, endToken));
                        if (endToken < label.length()) {
                            sb.append("-");
                        }
                        sb.append("</p>");
                    } while (endToken < label.length());
                } else {
                    sb.append(label.substring(startToken, endToken)).append("-");
                }
                return sb.toString();
            }
            return label.substring(0, maxWidth - 3) + "...";
        }
        return label;
    }

    public static List<String> getListaNomiGruppi() {
        LoginBean lb = Utility.getLoginBean();
        if (lb != null && lb.isLoggedIn()) {
            return lb.getListaNomiGruppi();
        }
        return new ArrayList<String>();
    }

    public static boolean isAmministratore() {
        LoginBean lb = Utility.getLoginBean();
        if (lb != null && lb.isLoggedIn()) {
            return lb.isAmministratore();
        }
        return false;
    }

    public static String buildInternalRedirectUrl(HttpServletRequest request, String destination) {
        return ServletUtils.buildInternalRedirectUrl((HttpServletRequest)request, (String)destination);
    }

    public static boolean isUtenteLoggatoOAuth2() {
        LoginBean lb = Utility.getLoginBean();
        if (lb != null && lb.isLoggedIn()) {
            return lb.isUtenteLoggatoOAuth2();
        }
        return false;
    }

    public static boolean isPasswordUtenteObbligatoria() {
        LoginBean lb = Utility.getLoginBean();
        if (lb != null && lb.isLoggedIn()) {
            return lb.isApplicationLogin() && !lb.isMultiLoginEnabled();
        }
        return false;
    }

    static {
        mapIdentificativoPorta = new HashMap<String, String>();
    }
}

