/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.core;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.pdd.logger.info.FormatUtils;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class Utils {
    private static Logger log = LoggerWrapperFactory.getLogger(Utils.class);

    private Utils() {
    }

    protected static ClassLoader getCurrentClassLoader(Object defaultObject) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = defaultObject.getClass().getClassLoader();
        }
        return loader;
    }

    public static String getMessageFromResourceBundle(String bundleName, String key, Object[] params, Locale locale) {
        Object text = null;
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, Utils.getCurrentClassLoader(params));
        try {
            text = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            text = "?? key " + key + " not found ??";
        }
        if (params != null) {
            MessageFormat mf = new MessageFormat((String)text, locale);
            text = mf.format(params, new StringBuffer(), (FieldPosition)null).toString();
        }
        return text;
    }

    public static String getMessageFromJSFBundle(String bundleName, String key) {
        ResourceBundle rb = ResourceBundle.getBundle(bundleName);
        return rb.getString(key);
    }

    public static Object resolveExpression(String expression) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application app = facesContext.getApplication();
        ExpressionFactory elFactory = app.getExpressionFactory();
        ELContext elContext = facesContext.getELContext();
        ValueExpression valueExp = elFactory.createValueExpression(elContext, expression, Object.class);
        return valueExp.getValue(elContext);
    }

    public static String prettifyXml(String xml) {
        return FormatUtils.prettifyXml((Logger)log, (String)xml);
    }

    public static String prettifyXml(String xml, String charset) {
        return FormatUtils.prettifyXml((Logger)log, (String)xml, (String)charset);
    }

    public static String prettifyXml(byte[] xml) {
        return FormatUtils.prettifyXml((Logger)log, (byte[])xml);
    }

    public static String prettifyXml(byte[] xml, String charset) {
        return FormatUtils.prettifyXml((Logger)log, (byte[])xml, (String)charset);
    }

    public static String getTestoVisualizzabile(byte[] b, StringBuilder stringBuffer, boolean logError) {
        return FormatUtils.getTestoVisualizzabile((Logger)log, (byte[])b, (StringBuilder)stringBuffer, (boolean)logError);
    }

    public static String getTestoVisualizzabile(byte[] b, StringBuilder stringBuffer, boolean logError, int max) {
        return FormatUtils.getTestoVisualizzabile((Logger)log, (byte[])b, (StringBuilder)stringBuffer, (boolean)logError, (int)max);
    }

    public static boolean isContentAuthorizationRequiredForThisResource(HttpServletRequest httpServletRequest, List<String> excludedPaths) {
        String contextPath;
        String requestPath = httpServletRequest.getRequestURI();
        if (StringUtils.equals((String)requestPath, (String)((contextPath = httpServletRequest.getContextPath()) + "/"))) {
            return false;
        }
        boolean controlRequired = true;
        if (!excludedPaths.isEmpty()) {
            for (String page : excludedPaths) {
                if (!StringUtils.contains((String)requestPath, (String)(contextPath + page))) continue;
                controlRequired = false;
                break;
            }
        }
        return controlRequired;
    }

    public static String incapsulaValoreStato(String valoreStato) {
        if (valoreStato != null) {
            valoreStato = "{" + (String)valoreStato + "}";
        }
        return valoreStato;
    }

    public static String extractValoreStato(String valoreStato) {
        if (valoreStato != null) {
            if (valoreStato.startsWith("{")) {
                valoreStato = valoreStato.substring(1);
            }
            if (valoreStato.endsWith("}")) {
                valoreStato = valoreStato.substring(0, valoreStato.length() - 1);
            }
        }
        return valoreStato;
    }
}

