/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.dao;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.commons.search.AccordoServizioParteComune;
import org.openspcoop2.core.commons.search.AccordoServizioParteComuneGruppo;
import org.openspcoop2.core.commons.search.AccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.Fruitore;
import org.openspcoop2.core.commons.search.Gruppo;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteComune;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteComuneGruppo;
import org.openspcoop2.core.commons.search.IdPortaDominio;
import org.openspcoop2.core.commons.search.PortType;
import org.openspcoop2.core.commons.search.PortaApplicativa;
import org.openspcoop2.core.commons.search.PortaDelegata;
import org.openspcoop2.core.commons.search.PortaDominio;
import org.openspcoop2.core.commons.search.ServizioApplicativo;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.constants.TipoPdD;
import org.openspcoop2.core.commons.search.dao.IAccordoServizioParteComuneGruppoServiceSearch;
import org.openspcoop2.core.commons.search.dao.IAccordoServizioParteComuneServiceSearch;
import org.openspcoop2.core.commons.search.dao.IAccordoServizioParteSpecificaServiceSearch;
import org.openspcoop2.core.commons.search.dao.IFruitoreServiceSearch;
import org.openspcoop2.core.commons.search.dao.IGruppoServiceSearch;
import org.openspcoop2.core.commons.search.dao.IPortTypeServiceSearch;
import org.openspcoop2.core.commons.search.dao.IPortaApplicativaServiceSearch;
import org.openspcoop2.core.commons.search.dao.IPortaDelegataServiceSearch;
import org.openspcoop2.core.commons.search.dao.IPortaDominioServiceSearch;
import org.openspcoop2.core.commons.search.dao.IServizioApplicativoServiceSearch;
import org.openspcoop2.core.commons.search.dao.ISoggettoServiceSearch;
import org.openspcoop2.core.commons.search.dao.jdbc.JDBCAccordoServizioParteComuneServiceSearch;
import org.openspcoop2.core.commons.search.dao.jdbc.JDBCAccordoServizioParteSpecificaServiceSearch;
import org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.commons.search.dao.jdbc.JDBCSoggettoServiceSearch;
import org.openspcoop2.core.commons.search.utils.ExpressionProperties;
import org.openspcoop2.core.commons.search.utils.RegistroCore;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.config.constants.PortaDelegataAzioneIdentificazione;
import org.openspcoop2.core.config.constants.TipologiaFruizione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.dao.IPluginServiceSearch;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.plugins.utils.ProjectInfo;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaGruppi;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.generic_project.beans.CustomField;
import org.openspcoop2.generic_project.beans.Function;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.dao.IExpressionConstructor;
import org.openspcoop2.generic_project.dao.IServiceSearchWithId;
import org.openspcoop2.generic_project.dao.IServiceSearchWithoutId;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.PermessiUtenteOperatore;
import org.openspcoop2.web.monitor.core.dao.IDynamicUtilsService;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.slf4j.Logger;

public class DynamicUtilsServiceEngine
implements IDynamicUtilsService {
    private int defaultStart = 0;
    private int LIMIT_SEARCH = 10000;
    private static Logger log = LoggerManager.getPddMonitorSqlLogger();
    private org.openspcoop2.core.commons.search.dao.IServiceManager utilsServiceManager;
    private ISoggettoServiceSearch soggettoDAO;
    private IGruppoServiceSearch gruppiDAO;
    private IAccordoServizioParteComuneServiceSearch aspcDAO = null;
    private IAccordoServizioParteComuneGruppoServiceSearch aspcGruppiDAO = null;
    private IAccordoServizioParteSpecificaServiceSearch aspsDAO = null;
    private IServizioApplicativoServiceSearch serviziApplicativiDAO = null;
    private IPortTypeServiceSearch portTypeDAO = null;
    private IFruitoreServiceSearch fruitoreSearchDAO;
    private IPortaDominioServiceSearch pddDAO = null;
    private IPortaDelegataServiceSearch portaDelegataDAO = null;
    private IPortaApplicativaServiceSearch portaApplicativaDAO = null;
    private IServiceManager pluginsServiceManager;
    private IPluginServiceSearch pluginsServiceSearchDAO;
    private transient DriverRegistroServiziDB driverRegistroDB = null;
    private transient DriverConfigurazioneDB driverConfigDB = null;

    public DynamicUtilsServiceEngine() {
        this(null, null, null, null);
    }

    public DynamicUtilsServiceEngine(org.openspcoop2.core.commons.search.dao.IServiceManager serviceManager, IServiceManager pluginsServiceManager, DriverRegistroServiziDB driverRegistroServiziDB, DriverConfigurazioneDB driverConfigurazioneDB) {
        try {
            this.utilsServiceManager = serviceManager == null ? (org.openspcoop2.core.commons.search.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), log) : serviceManager;
            this.soggettoDAO = this.utilsServiceManager.getSoggettoServiceSearch();
            this.gruppiDAO = this.utilsServiceManager.getGruppoServiceSearch();
            this.aspcDAO = this.utilsServiceManager.getAccordoServizioParteComuneServiceSearch();
            this.aspcGruppiDAO = this.utilsServiceManager.getAccordoServizioParteComuneGruppoServiceSearch();
            this.aspsDAO = this.utilsServiceManager.getAccordoServizioParteSpecificaServiceSearch();
            this.serviziApplicativiDAO = this.utilsServiceManager.getServizioApplicativoServiceSearch();
            this.portTypeDAO = this.utilsServiceManager.getPortTypeServiceSearch();
            this.fruitoreSearchDAO = this.utilsServiceManager.getFruitoreServiceSearch();
            this.pddDAO = this.utilsServiceManager.getPortaDominioServiceSearch();
            this.portaApplicativaDAO = this.utilsServiceManager.getPortaApplicativaServiceSearch();
            this.portaDelegataDAO = this.utilsServiceManager.getPortaDelegataServiceSearch();
            this.pluginsServiceManager = pluginsServiceManager == null ? (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), log) : pluginsServiceManager;
            this.pluginsServiceSearchDAO = this.pluginsServiceManager.getPluginServiceSearch();
            String datasourceJNDIName = null;
            Properties datasourceJNDIContext = null;
            String tipoDatabase = null;
            if (driverRegistroServiziDB == null || driverConfigurazioneDB == null) {
                datasourceJNDIName = DAOFactoryProperties.getInstance((Logger)log).getDatasourceJNDIName((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
                datasourceJNDIContext = DAOFactoryProperties.getInstance((Logger)log).getDatasourceJNDIContext((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
                tipoDatabase = DAOFactoryProperties.getInstance((Logger)log).getTipoDatabase((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            }
            this.driverRegistroDB = driverRegistroServiziDB == null ? new DriverRegistroServiziDB(datasourceJNDIName, datasourceJNDIContext, log, tipoDatabase) : driverRegistroServiziDB;
            this.driverConfigDB = driverConfigurazioneDB == null ? new DriverConfigurazioneDB(datasourceJNDIName, datasourceJNDIContext, log, tipoDatabase) : driverConfigurazioneDB;
            PddMonitorProperties monitorProperties = PddMonitorProperties.getInstance(log);
            this.LIMIT_SEARCH = monitorProperties.getSearchFormLimit();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public DynamicUtilsServiceEngine(Connection con, boolean autoCommit) {
        this(con, autoCommit, null, log);
    }

    public DynamicUtilsServiceEngine(Connection con, boolean autoCommit, Logger log) {
        this(con, autoCommit, null, log);
    }

    public DynamicUtilsServiceEngine(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties) {
        this(con, autoCommit, serviceManagerProperties, log);
    }

    public DynamicUtilsServiceEngine(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties, Logger log) {
        try {
            this.utilsServiceManager = (org.openspcoop2.core.commons.search.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, log);
            this.soggettoDAO = this.utilsServiceManager.getSoggettoServiceSearch();
            this.gruppiDAO = this.utilsServiceManager.getGruppoServiceSearch();
            this.aspcDAO = this.utilsServiceManager.getAccordoServizioParteComuneServiceSearch();
            this.aspcGruppiDAO = this.utilsServiceManager.getAccordoServizioParteComuneGruppoServiceSearch();
            this.aspsDAO = this.utilsServiceManager.getAccordoServizioParteSpecificaServiceSearch();
            this.serviziApplicativiDAO = this.utilsServiceManager.getServizioApplicativoServiceSearch();
            this.portTypeDAO = this.utilsServiceManager.getPortTypeServiceSearch();
            this.fruitoreSearchDAO = this.utilsServiceManager.getFruitoreServiceSearch();
            this.pddDAO = this.utilsServiceManager.getPortaDominioServiceSearch();
            this.portaApplicativaDAO = this.utilsServiceManager.getPortaApplicativaServiceSearch();
            this.portaDelegataDAO = this.utilsServiceManager.getPortaDelegataServiceSearch();
            this.pluginsServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, log);
            this.pluginsServiceSearchDAO = this.pluginsServiceManager.getPluginServiceSearch();
            String tipoDatabase = DAOFactoryProperties.getInstance((Logger)log).getTipoDatabase((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
            this.driverRegistroDB = new DriverRegistroServiziDB(con, log, tipoDatabase);
            this.driverConfigDB = new DriverConfigurazioneDB(con, log, tipoDatabase);
            PddMonitorProperties monitorProperties = PddMonitorProperties.getInstance(log);
            this.LIMIT_SEARCH = monitorProperties.getSearchFormLimit();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public org.openspcoop2.core.commons.search.dao.IServiceManager getUtilsServiceManager() {
        return this.utilsServiceManager;
    }

    public static IExpression getExpressionTipiSoggettiCompatibiliConProtocollo(IServiceSearchWithId<?, ?> dao, IField field, String protocollo) throws Exception {
        if (protocollo != null) {
            IExpression expr = dao.newExpression();
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            List tipiSoggetti = protocolFactory.createProtocolConfiguration().getTipiSoggetti();
            return expr.in(field, (Collection)tipiSoggetti);
        }
        return null;
    }

    public static IExpression getExpressionTipiServiziCompatibiliConProtocollo(IServiceSearchWithId<?, ?> dao, IField field, String protocollo) throws Exception {
        if (protocollo != null) {
            IExpression expr = dao.newExpression();
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            ArrayList tipiServizi = new ArrayList();
            tipiServizi.addAll(protocolFactory.createProtocolConfiguration().getTipiServizi(ServiceBinding.SOAP));
            tipiServizi.addAll(protocolFactory.createProtocolConfiguration().getTipiServizi(ServiceBinding.REST));
            return expr.in(field, tipiServizi);
        }
        return null;
    }

    public static IExpression getExpressionTipiSoggettiCompatibiliConProtocollo(IServiceSearchWithoutId<?> dao, IField field, String protocollo) throws Exception {
        if (protocollo != null) {
            IExpression expr = dao.newExpression();
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            List tipiSoggetti = protocolFactory.createProtocolConfiguration().getTipiSoggetti();
            return expr.in(field, (Collection)tipiSoggetti);
        }
        return null;
    }

    public static IExpression getExpressionTipiServiziCompatibiliConProtocollo(IServiceSearchWithoutId<?> dao, IField field, String protocollo) throws Exception {
        if (protocollo != null) {
            IExpression expr = dao.newExpression();
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            ArrayList tipiServizi = new ArrayList();
            tipiServizi.addAll(protocolFactory.createProtocolConfiguration().getTipiServizi(ServiceBinding.SOAP));
            tipiServizi.addAll(protocolFactory.createProtocolConfiguration().getTipiServizi(ServiceBinding.REST));
            return expr.in(field, tipiServizi);
        }
        return null;
    }

    @Override
    public int countPdD(String tipoProtocollo) {
        try {
            IExpression expr = this.pddDAO.newExpression();
            NonNegativeNumber nnn = null;
            if (StringUtils.isNotBlank((String)tipoProtocollo)) {
                List select;
                IPaginatedExpression sogExpr = this.soggettoDAO.newPaginatedExpression();
                if (StringUtils.isNotEmpty((String)tipoProtocollo)) {
                    sogExpr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.soggettoDAO, Soggetto.model().TIPO_SOGGETTO, tipoProtocollo)});
                }
                return (select = this.soggettoDAO.select(sogExpr, true, Soggetto.model().SERVER)) != null ? select.size() : 0;
            }
            nnn = this.pddDAO.count(expr);
            if (nnn != null) {
                return (int)nnn.longValue();
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage());
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    @Override
    public List<Soggetto> soggettiAutoComplete(String tipoProtocollo, String input) {
        return this.soggettiAutoComplete(tipoProtocollo, input, false);
    }

    @Override
    public List<Soggetto> soggettiAutoComplete(String tipoProtocollo, String input, Boolean searchTipo) {
        return this.findElencoSoggetti(tipoProtocollo, null, input, searchTipo);
    }

    @Override
    public List<Soggetto> findElencoSoggetti(String tipoProtocollo, String idPorta) {
        return this.findElencoSoggetti(tipoProtocollo, idPorta, null, false);
    }

    @Override
    public int countElencoSoggetti(String tipoProtocollo, String idPorta) {
        return this.countElencoSoggetti(tipoProtocollo, idPorta, null, false);
    }

    @Override
    public List<Soggetto> findElencoSoggetti(String tipoProtocollo, String idPorta, String input) {
        return this.findElencoSoggetti(tipoProtocollo, idPorta, input, false);
    }

    @Override
    public int countElencoSoggetti(String tipoProtocollo, String idPorta, String input) {
        return this.countElencoSoggetti(tipoProtocollo, idPorta, input, false);
    }

    @Override
    public List<Soggetto> findElencoSoggetti(String tipoProtocollo, String idPorta, String input, Boolean searchTipo) {
        try {
            IExpression expr = this.soggettoDAO.newExpression();
            boolean addAnd = false;
            if (idPorta != null) {
                expr.equals(Soggetto.model().IDENTIFICATIVO_PORTA, (Object)idPorta);
                addAnd = true;
            }
            if (!StringUtils.isEmpty((String)input)) {
                int idx = input.indexOf("/");
                if (idx != -1) {
                    input = input.substring(idx + 1, input.length());
                }
                if (searchTipo.booleanValue()) {
                    IExpression exprOrTipo = this.soggettoDAO.newExpression();
                    exprOrTipo.ilike(Soggetto.model().TIPO_SOGGETTO, input.toLowerCase(), LikeMode.ANYWHERE);
                    IExpression exprOrNome = this.soggettoDAO.newExpression();
                    exprOrNome.ilike(Soggetto.model().NOME_SOGGETTO, input.toLowerCase(), LikeMode.ANYWHERE);
                    expr.or(exprOrTipo, exprOrNome);
                } else {
                    expr.ilike(Soggetto.model().NOME_SOGGETTO, input.toLowerCase(), LikeMode.ANYWHERE);
                }
            }
            if (tipoProtocollo != null) {
                if (addAnd) {
                    expr.and();
                }
                expr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.soggettoDAO, Soggetto.model().TIPO_SOGGETTO, tipoProtocollo)});
            }
            expr.sortOrder(SortOrder.ASC).addOrder(Soggetto.model().TIPO_SOGGETTO).addOrder(Soggetto.model().NOME_SOGGETTO);
            IPaginatedExpression pagExpr = this.soggettoDAO.toPaginatedExpression(expr);
            pagExpr.offset(this.defaultStart).limit(this.LIMIT_SEARCH);
            return this.soggettoDAO.findAll(pagExpr);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<Soggetto>();
    }

    @Override
    public int countElencoSoggetti(String tipoProtocollo, String idPorta, String input, Boolean searchTipo) {
        try {
            NonNegativeNumber nnn;
            IExpression expr = this.soggettoDAO.newExpression();
            boolean addAnd = false;
            if (idPorta != null) {
                expr.equals(Soggetto.model().IDENTIFICATIVO_PORTA, (Object)idPorta);
                addAnd = true;
            }
            if (!StringUtils.isEmpty((String)input)) {
                int idx = input.indexOf("/");
                if (idx != -1) {
                    input = input.substring(idx + 1, input.length());
                }
                if (searchTipo.booleanValue()) {
                    IExpression exprOrTipo = this.soggettoDAO.newExpression();
                    exprOrTipo.ilike(Soggetto.model().TIPO_SOGGETTO, input.toLowerCase(), LikeMode.ANYWHERE);
                    IExpression exprOrNome = this.soggettoDAO.newExpression();
                    exprOrNome.ilike(Soggetto.model().NOME_SOGGETTO, input.toLowerCase(), LikeMode.ANYWHERE);
                    expr.or(exprOrTipo, exprOrNome);
                } else {
                    expr.ilike(Soggetto.model().NOME_SOGGETTO, input.toLowerCase(), LikeMode.ANYWHERE);
                }
            }
            if (tipoProtocollo != null) {
                if (addAnd) {
                    expr.and();
                }
                expr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.soggettoDAO, Soggetto.model().TIPO_SOGGETTO, tipoProtocollo)});
            }
            if ((nnn = this.soggettoDAO.count(expr)) != null) {
                return (int)nnn.longValue();
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    @Override
    public Soggetto findSoggettoByTipoNome(String tipoSoggetto, String nomeSoggetto) {
        try {
            if (StringUtils.isNotEmpty((String)tipoSoggetto) && StringUtils.isNotEmpty((String)nomeSoggetto)) {
                return (Soggetto)this.soggettoDAO.find(this.soggettoDAO.newExpression().equals(Soggetto.model().NOME_SOGGETTO, (Object)nomeSoggetto).and().equals(Soggetto.model().TIPO_SOGGETTO, (Object)tipoSoggetto));
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public Soggetto findSoggettoById(Long idSoggetto) {
        try {
            return ((JDBCSoggettoServiceSearch)this.soggettoDAO).get(idSoggetto.longValue());
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public List<Soggetto> findElencoSoggettiFromTipoSoggetto(String tipoSoggetto) {
        try {
            return this.soggettoDAO.findAll(this.soggettoDAO.toPaginatedExpression(this.soggettoDAO.newPaginatedExpression().equals(Soggetto.model().TIPO_SOGGETTO, (Object)tipoSoggetto).sortOrder(SortOrder.ASC).addOrder(Soggetto.model().NOME_SOGGETTO)));
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public int countElencoSoggettiFromTipoSoggetto(String tipoSoggetto) {
        try {
            IExpression expr = this.soggettoDAO.newExpression();
            expr.equals(Soggetto.model().TIPO_SOGGETTO, (Object)tipoSoggetto);
            NonNegativeNumber nnn = this.soggettoDAO.count(expr);
            if (nnn != null) {
                return (int)nnn.longValue();
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    @Override
    public List<Soggetto> findElencoSoggettiFromTipoPdD(String tipoProtocollo, TipoPdD tipoPdD) {
        try {
            IPaginatedExpression pagExpr = this.pddDAO.newPaginatedExpression();
            pagExpr.equals(PortaDominio.model().TIPO, (Object)tipoPdD).sortOrder(SortOrder.ASC).addOrder(PortaDominio.model().NOME);
            List idPorte = this.pddDAO.findAllIds(pagExpr);
            IPaginatedExpression sogPagExpr = this.soggettoDAO.newPaginatedExpression();
            if (idPorte != null && idPorte.size() > 0) {
                ArrayList<String> nomiPorte = new ArrayList<String>();
                for (IdPortaDominio idPorta : idPorte) {
                    nomiPorte.add(idPorta.getNome());
                }
                sogPagExpr.in(Soggetto.model().SERVER, nomiPorte);
            }
            sogPagExpr.sortOrder(SortOrder.ASC).addOrder(Soggetto.model().TIPO_SOGGETTO).addOrder(Soggetto.model().NOME_SOGGETTO);
            if (StringUtils.isNotEmpty((String)tipoProtocollo)) {
                sogPagExpr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.soggettoDAO, Soggetto.model().TIPO_SOGGETTO, tipoProtocollo)});
            }
            return this.soggettoDAO.findAll(sogPagExpr);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<Soggetto>();
    }

    @Override
    public int countElencoSoggettiFromTipoTipoPdD(String tipoProtocollo, TipoPdD tipoPdD) {
        try {
            if (tipoPdD != null) {
                NonNegativeNumber nnn;
                ArrayList<String> nomiPorte;
                IPaginatedExpression pagExpr = this.pddDAO.newPaginatedExpression();
                pagExpr.equals(PortaDominio.model().TIPO, (Object)tipoPdD).sortOrder(SortOrder.ASC).addOrder(PortaDominio.model().NOME);
                List idPorte = this.pddDAO.findAllIds(pagExpr);
                IExpression sogExpr = this.soggettoDAO.newExpression();
                if (idPorte != null && idPorte.size() > 0) {
                    nomiPorte = new ArrayList<String>();
                    for (IdPortaDominio idPorta : idPorte) {
                        nomiPorte.add(idPorta.getNome());
                    }
                } else {
                    return 0;
                }
                sogExpr.in(Soggetto.model().SERVER, nomiPorte);
                if (StringUtils.isNotEmpty((String)tipoProtocollo)) {
                    sogExpr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.soggettoDAO, Soggetto.model().TIPO_SOGGETTO, tipoProtocollo)});
                }
                if ((nnn = this.soggettoDAO.count(sogExpr)) != null) {
                    return (int)nnn.longValue();
                }
            } else {
                NonNegativeNumber nnn;
                IExpression sogExpr = this.soggettoDAO.newExpression();
                IExpression sogExprServer = this.soggettoDAO.newExpression();
                sogExprServer.isNull(Soggetto.model().SERVER);
                sogExprServer.isEmpty(Soggetto.model().SERVER);
                sogExprServer.or();
                sogExpr.and(new IExpression[]{sogExprServer});
                if (StringUtils.isNotEmpty((String)tipoProtocollo)) {
                    sogExpr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.soggettoDAO, Soggetto.model().TIPO_SOGGETTO, tipoProtocollo)});
                }
                if ((nnn = this.soggettoDAO.count(sogExpr)) != null) {
                    return (int)nnn.longValue();
                }
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    @Override
    public boolean checkTipoPdd(String nome, TipoPdD tipoPdD) {
        try {
            if (nome == null || "".equals(nome) || "-".equals(nome)) {
                return TipoPdD.ESTERNO.equals((Object)tipoPdD);
            }
            IPaginatedExpression pagExpr = this.pddDAO.newPaginatedExpression();
            pagExpr.equals(PortaDominio.model().TIPO, (Object)tipoPdD).equals(PortaDominio.model().NOME, (Object)nome).sortOrder(SortOrder.ASC).addOrder(PortaDominio.model().NOME);
            pagExpr.limit(1);
            List idPorte = this.pddDAO.findAllIds(pagExpr);
            return idPorte != null && idPorte.size() > 0;
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    public List<Map<String, Object>> findElencoServizi(String tipoProtocollo) {
        try {
            IExpression expr = this.aspsDAO.newExpression();
            expr.sortOrder(SortOrder.ASC).addOrder(AccordoServizioParteSpecifica.model().TIPO).addOrder(AccordoServizioParteSpecifica.model().NOME);
            IPaginatedExpression pagExpr = this.aspsDAO.toPaginatedExpression(expr);
            if (tipoProtocollo != null) {
                pagExpr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.aspsDAO, AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, tipoProtocollo)});
            }
            return this.aspsDAO.select(pagExpr, true, new IField[]{AccordoServizioParteSpecifica.model().TIPO, AccordoServizioParteSpecifica.model().NOME});
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<Map<String, Object>>();
    }

    @Override
    public int countElencoServizi(String tipoProtocollo) {
        try {
            IExpression expr = this.aspsDAO.newExpression();
            NonNegativeNumber nnn = this.aspsDAO.count(expr);
            if (tipoProtocollo != null) {
                expr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.aspsDAO, AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, tipoProtocollo)});
            }
            if (nnn != null) {
                return (int)nnn.longValue();
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    @Override
    public List<Map<String, Object>> findElencoServizi(String tipoProtocollo, Soggetto soggetto) {
        return this.findElencoServizi(tipoProtocollo, soggetto, null);
    }

    @Override
    public List<Map<String, Object>> findElencoServizi(String tipoProtocollo, Soggetto soggetto, String val) {
        return this.findElencoServizi(tipoProtocollo, soggetto, val, false);
    }

    @Override
    public List<Map<String, Object>> findElencoServizi(String tipoProtocollo, Soggetto soggetto, String val, Boolean searchTipo) {
        log.debug("Get Lista Servizi [Soggetto: " + (soggetto != null ? soggetto.getNomeSoggetto() : "Null") + "], VAL: [" + val + "]");
        try {
            IExpression expr = this.aspsDAO.newExpression();
            if (soggetto != null) {
                expr.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, (Object)soggetto.getTipoSoggetto());
                expr.and().equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, (Object)soggetto.getNomeSoggetto());
            }
            if (tipoProtocollo != null) {
                expr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.aspsDAO, AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, tipoProtocollo)});
            }
            if (StringUtils.isNotEmpty((String)val)) {
                if (searchTipo.booleanValue()) {
                    IExpression exprOrTipo = this.aspsDAO.newExpression();
                    exprOrTipo.ilike(AccordoServizioParteSpecifica.model().TIPO, val, LikeMode.ANYWHERE);
                    IExpression exprOrNome = this.aspsDAO.newExpression();
                    exprOrNome.ilike(AccordoServizioParteSpecifica.model().NOME, val, LikeMode.ANYWHERE);
                    expr.or(exprOrTipo, exprOrNome);
                } else {
                    expr.and().ilike(AccordoServizioParteSpecifica.model().NOME, val, LikeMode.ANYWHERE);
                }
            }
            expr.sortOrder(SortOrder.ASC).addOrder(AccordoServizioParteSpecifica.model().TIPO).addOrder(AccordoServizioParteSpecifica.model().NOME);
            IPaginatedExpression pagExpr = this.aspsDAO.toPaginatedExpression(expr);
            CustomField cf = new CustomField("idAccordo", Long.class, "id_accordo", "servizi");
            List list = this.aspsDAO.select(pagExpr, true, new IField[]{AccordoServizioParteSpecifica.model().TIPO, AccordoServizioParteSpecifica.model().NOME, cf});
            for (Map map : list) {
                Long idAccordoLong = (Long)map.remove("idAccordo");
                AccordoServizioParteComune aspc = ((JDBCAccordoServizioParteComuneServiceSearch)this.aspcDAO).get(idAccordoLong.longValue());
                map.put("idAccordo", aspc);
            }
            return list;
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<Map<String, Object>>();
    }

    @Override
    public AccordoServizioParteComune getAccordoServizio(String tipoProtocollo, IDSoggetto idSoggetto, String tipoServizio, String nomeServizio, Integer versioneServizio) {
        log.debug("Get Lista Servizi [Soggetto: " + (idSoggetto != null ? idSoggetto.getNome() : "Null") + "], Servizio: [" + tipoServizio + "/" + nomeServizio + "]");
        AccordoServizioParteComune aspc = null;
        try {
            IExpression expr = this.aspsDAO.newExpression();
            if (idSoggetto != null) {
                expr.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, (Object)idSoggetto.getTipo());
                expr.and().equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, (Object)idSoggetto.getNome());
            }
            if (tipoProtocollo != null) {
                expr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.aspsDAO, AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, tipoProtocollo)});
            }
            if (StringUtils.isNotEmpty((String)tipoServizio) && StringUtils.isNotEmpty((String)nomeServizio) && versioneServizio != null) {
                expr.equals(AccordoServizioParteSpecifica.model().TIPO, (Object)tipoServizio);
                expr.and();
                expr.equals(AccordoServizioParteSpecifica.model().NOME, (Object)nomeServizio);
                expr.and();
                expr.equals(AccordoServizioParteSpecifica.model().VERSIONE, (Object)versioneServizio);
            }
            expr.sortOrder(SortOrder.ASC).addOrder(AccordoServizioParteSpecifica.model().TIPO).addOrder(AccordoServizioParteSpecifica.model().NOME);
            IPaginatedExpression pagExpr = this.aspsDAO.toPaginatedExpression(expr);
            CustomField cf = new CustomField("idAccordo", Long.class, "id_accordo", "servizi");
            List list = this.aspsDAO.select(pagExpr, true, (IField)cf);
            for (Object idAccordoObj : list) {
                Long idAccordoLong = (Long)idAccordoObj;
                aspc = ((JDBCAccordoServizioParteComuneServiceSearch)this.aspcDAO).get(idAccordoLong.longValue());
            }
            return aspc;
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public List<IdAccordoServizioParteComuneGruppo> getAccordoServizioGruppi(IdAccordoServizioParteComune id) {
        try {
            IPaginatedExpression pagExpr = this.aspcGruppiDAO.newPaginatedExpression();
            pagExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)id.getNome());
            pagExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)id.getVersione());
            pagExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)id.getIdSoggetto().getNome());
            pagExpr.equals(AccordoServizioParteComuneGruppo.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)id.getIdSoggetto().getTipo());
            List list = this.aspcGruppiDAO.findAllIds(pagExpr);
            return list;
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public int countElencoServizi(String tipoProtocollo, Soggetto soggetto) {
        try {
            NonNegativeNumber nnn;
            IExpression expr = this.aspsDAO.newExpression();
            if (soggetto != null) {
                expr.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, (Object)soggetto.getTipoSoggetto());
                expr.and().equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, (Object)soggetto.getNomeSoggetto());
            }
            if (tipoProtocollo != null) {
                expr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.aspsDAO, AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, tipoProtocollo)});
            }
            if ((nnn = this.aspsDAO.count(expr)) != null) {
                return (int)nnn.longValue();
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    public List<Map<String, Object>> findElencoServizi(List<Soggetto> soggetti) {
        log.debug("Get Lista Servizi dei soggetti");
        try {
            IExpression expr = this.aspsDAO.newExpression();
            if (soggetti != null && soggetti.size() > 0) {
                IExpression exprSoggetti = this.aspsDAO.newExpression();
                for (Soggetto soggetto : soggetti) {
                    IExpression expr2 = this.aspsDAO.newExpression();
                    expr2.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, (Object)soggetto.getTipoSoggetto());
                    expr2.and().equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, (Object)soggetto.getNomeSoggetto());
                    exprSoggetti.or(new IExpression[]{expr2});
                }
                expr.and(new IExpression[]{exprSoggetti});
            }
            expr.sortOrder(SortOrder.ASC).addOrder(AccordoServizioParteSpecifica.model().TIPO).addOrder(AccordoServizioParteSpecifica.model().NOME);
            IPaginatedExpression pagExpr = this.aspsDAO.toPaginatedExpression(expr);
            CustomField cf = new CustomField("idAccordo", Long.class, "id_accordo", "servizi");
            List list = this.aspsDAO.select(pagExpr, true, new IField[]{AccordoServizioParteSpecifica.model().TIPO, AccordoServizioParteSpecifica.model().NOME, cf});
            for (Map map : list) {
                Long idAccordoLong = (Long)map.remove("idAccordo");
                AccordoServizioParteComune aspc = ((JDBCAccordoServizioParteComuneServiceSearch)this.aspcDAO).get(idAccordoLong.longValue());
                map.put("idAccordo", aspc);
            }
            return list;
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<Map<String, Object>>();
    }

    @Override
    public Map<String, String> findAzioniFromServizio(String tipoProtocollo, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String val) {
        log.debug("Get Lista Azioni from Accordo Servizio [nome Servizio: " + nomeServizio + "]");
        try {
            Map azioniConLabel = RegistroCore.getAzioniConLabel((JDBCServiceManager)((JDBCServiceManager)this.utilsServiceManager), (String)tipoProtocollo, (String)tipoErogatore, (String)nomeErogatore, (String)tipoServizio, (String)nomeServizio, (Integer)versioneServizio, (String)val);
            return azioniConLabel;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    @Override
    public int countAzioniFromServizio(String tipoProtocollo, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String val) {
        return this.findAzioniFromServizio(tipoProtocollo, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, val).size();
    }

    @Override
    public Map<String, String> findAzioniFromAPI(String tipoProtocollo, String nomeAccordo, String tipoReferente, String nomeReferente, Integer versioneAccordo, String val) {
        log.debug("Get Lista Azioni from API [nomeAccordo: " + nomeAccordo + "]");
        try {
            Map azioniConLabel = RegistroCore.getAzioniFromAPIConLabel((JDBCServiceManager)((JDBCServiceManager)this.utilsServiceManager), (String)tipoProtocollo, (String)nomeAccordo, (String)tipoReferente, (String)nomeReferente, (Integer)versioneAccordo, (String)val);
            return azioniConLabel;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    @Override
    public List<Object> findElencoServiziApplicativi(String tipoProtocollo, Soggetto soggetto, boolean trasporto, boolean token) {
        log.debug("Get Lista Servizi Applicativi [Soggetto: " + (soggetto != null ? soggetto.getNomeSoggetto() : "Null") + "]");
        try {
            boolean viaModiProperties = tipoProtocollo == null || "modipa".equals(tipoProtocollo);
            IExpression expr = this.buildExpressionServiziApplicativi(tipoProtocollo, soggetto, trasporto, token, false);
            expr.sortOrder(SortOrder.ASC).addOrder(ServizioApplicativo.model().NOME);
            IPaginatedExpression pagExpr = this.serviziApplicativiDAO.toPaginatedExpression(expr);
            ArrayList<Object> l = null;
            try {
                l = this.serviziApplicativiDAO.select(pagExpr, true, ServizioApplicativo.model().NOME);
            }
            catch (NotFoundException e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            if (l == null) {
                l = new ArrayList<Object>();
            }
            if (viaModiProperties) {
                expr = this.buildExpressionServiziApplicativi(tipoProtocollo, soggetto, trasporto, token, true);
                expr.sortOrder(SortOrder.ASC).addOrder(ServizioApplicativo.model().NOME);
                pagExpr = this.serviziApplicativiDAO.toPaginatedExpression(expr);
                try {
                    List lmodi = this.serviziApplicativiDAO.select(pagExpr, true, ServizioApplicativo.model().NOME);
                    if (lmodi != null && !lmodi.isEmpty()) {
                        l.addAll(lmodi);
                    }
                }
                catch (NotFoundException e) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
            return l;
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<Object>();
    }

    @Override
    public int countElencoServiziApplicativi(String tipoProtocollo, Soggetto soggetto, boolean trasporto, boolean token) {
        log.debug("countElencoServiziApplicativi [Soggetto: " + (soggetto != null ? soggetto.getNomeSoggetto() : "Null") + "]");
        try {
            int resultModi;
            boolean viaModiProperties = tipoProtocollo == null || "modipa".equals(tipoProtocollo);
            IExpression expr = this.buildExpressionServiziApplicativi(tipoProtocollo, soggetto, trasporto, token, false);
            NonNegativeNumber nnn = this.serviziApplicativiDAO.count(expr);
            int result = 0;
            if (nnn != null) {
                result = (int)nnn.longValue();
            }
            if (viaModiProperties && (nnn = this.serviziApplicativiDAO.count(expr = this.buildExpressionServiziApplicativi(tipoProtocollo, soggetto, trasporto, token, false))) != null && (resultModi = (int)nnn.longValue()) > 0) {
                result += resultModi;
            }
            return result;
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    private IExpression buildExpressionServiziApplicativi(String tipoProtocollo, Soggetto soggetto, boolean trasporto, boolean token, boolean viaModiProperties) throws Exception {
        IExpression expr = this.serviziApplicativiDAO.newExpression();
        if (soggetto != null) {
            if (soggetto.getTipoSoggetto() != null && !"qualsiasi".equals(soggetto.getTipoSoggetto())) {
                expr.equals(ServizioApplicativo.model().ID_SOGGETTO.TIPO, (Object)soggetto.getTipoSoggetto());
            }
            if (soggetto.getNomeSoggetto() != null && !"qualsiasi".equals(soggetto.getNomeSoggetto())) {
                expr.and().equals(ServizioApplicativo.model().ID_SOGGETTO.NOME, (Object)soggetto.getNomeSoggetto());
            }
        }
        IExpression exprClient = this.serviziApplicativiDAO.newExpression();
        exprClient.isNotNull(ServizioApplicativo.model().TIPOLOGIA_FRUIZIONE).and().notEquals(ServizioApplicativo.model().TIPOLOGIA_FRUIZIONE, (Object)TipologiaFruizione.DISABILITATO);
        IExpression exprServerUseAsClient = this.serviziApplicativiDAO.newExpression();
        exprServerUseAsClient.isNotNull(ServizioApplicativo.model().AS_CLIENT).and().equals(ServizioApplicativo.model().AS_CLIENT, (Object)1);
        expr.or(exprClient, exprServerUseAsClient);
        if (tipoProtocollo != null) {
            expr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.serviziApplicativiDAO, ServizioApplicativo.model().ID_SOGGETTO.TIPO, tipoProtocollo)});
        }
        if (!trasporto || !token) {
            if (token) {
                if (viaModiProperties) {
                    expr.equals(ServizioApplicativo.model().SERVIZIO_APPLICATIVO_PROPRIETA_PROTOCOLLO.NAME, (Object)"modipaSecurityTokenPolicy");
                    expr.isNotNull(ServizioApplicativo.model().SERVIZIO_APPLICATIVO_PROPRIETA_PROTOCOLLO.VALUE_STRING);
                } else {
                    expr.and().in(ServizioApplicativo.model().TIPOAUTH, new Object[]{CostantiConfigurazione.CREDENZIALE_TOKEN.toString(), CostantiConfigurazione.CREDENZIALE_SSL.toString()});
                    expr.and().isNotNull(ServizioApplicativo.model().TOKEN_POLICY);
                }
            } else {
                expr.and().isNull(ServizioApplicativo.model().TOKEN_POLICY);
            }
        }
        return expr;
    }

    @Override
    public PortType getPortTypeFromAccordoServizio(String tipoProtocollo, IDAccordo idAccordo, String nomeServizio) {
        log.debug("Get Port Type from Accordo Servizio [Accordo: " + idAccordo.getNome() + "], [nome Servizio: " + nomeServizio + "]");
        IExpression expr = null;
        try {
            AccordoServizioParteSpecifica asps;
            expr = this.aspsDAO.newExpression();
            expr.equals(AccordoServizioParteSpecifica.model().NOME, (Object)nomeServizio).and();
            if (idAccordo.getNome() != null) {
                expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)idAccordo.getNome());
            }
            if (idAccordo.getVersione() != null) {
                expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)idAccordo.getVersione());
            }
            if (idAccordo.getSoggettoReferente() != null) {
                expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)idAccordo.getSoggettoReferente().getTipo()).and();
                expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)idAccordo.getSoggettoReferente().getNome());
            }
            if ((asps = (AccordoServizioParteSpecifica)this.aspsDAO.find(expr)) != null && asps.getPortType() != null) {
                expr = this.portTypeDAO.newExpression();
                expr.equals(PortType.model().NOME, (Object)asps.getPortType());
                if (idAccordo.getNome() != null) {
                    expr.equals(PortType.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)idAccordo.getNome());
                }
                if (idAccordo.getVersione() != null) {
                    expr.equals(PortType.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)idAccordo.getVersione());
                }
                if (idAccordo.getSoggettoReferente() != null) {
                    expr.equals(PortType.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)idAccordo.getSoggettoReferente().getTipo()).and();
                    expr.equals(PortType.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)idAccordo.getSoggettoReferente().getNome());
                }
                return (PortType)this.portTypeDAO.find(expr);
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public int countPortTypeFromAccordoServizio(String tipoProtocollo, IDAccordo idAccordo, String nomeServizio) {
        log.debug("count Port Type from Accordo Servizio [Accordo: " + idAccordo.getNome() + "], [nome Servizio: " + nomeServizio + "]");
        IExpression expr = null;
        try {
            AccordoServizioParteSpecifica asps;
            expr = this.aspsDAO.newExpression();
            expr.equals(AccordoServizioParteSpecifica.model().NOME, (Object)nomeServizio).and();
            if (idAccordo.getNome() != null) {
                expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)idAccordo.getNome());
            }
            if (idAccordo.getVersione() != null) {
                expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)idAccordo.getVersione());
            }
            if (idAccordo.getSoggettoReferente() != null) {
                expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)idAccordo.getSoggettoReferente().getTipo()).and();
                expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)idAccordo.getSoggettoReferente().getNome());
            }
            if ((asps = (AccordoServizioParteSpecifica)this.aspsDAO.find(expr)) != null && asps.getPortType() != null) {
                NonNegativeNumber nnn;
                expr = this.portTypeDAO.newExpression();
                expr.equals(PortType.model().NOME, (Object)asps.getPortType());
                if (idAccordo.getNome() != null) {
                    expr.equals(PortType.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)idAccordo.getNome());
                }
                if (idAccordo.getVersione() != null) {
                    expr.equals(PortType.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)idAccordo.getVersione());
                }
                if (idAccordo.getSoggettoReferente() != null) {
                    expr.equals(PortType.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)idAccordo.getSoggettoReferente().getTipo()).and();
                    expr.equals(PortType.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)idAccordo.getSoggettoReferente().getNome());
                }
                if ((nnn = this.portTypeDAO.count(expr)) != null) {
                    return (int)nnn.longValue();
                }
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    @Override
    public AccordoServizioParteSpecifica getAspsFromValues(String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio) {
        log.debug("Get AccordoServizioParteSpecifica from Tipo/Nome Servizio [Tipo: " + tipoServizio + "], [nome: " + nomeServizio + "]");
        IExpression expr = null;
        try {
            expr = this.aspsDAO.newExpression();
            expr.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, (Object)tipoErogatore).and();
            expr.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, (Object)nomeErogatore);
            expr.equals(AccordoServizioParteSpecifica.model().NOME, (Object)nomeServizio).and();
            expr.equals(AccordoServizioParteSpecifica.model().TIPO, (Object)tipoServizio).and();
            expr.equals(AccordoServizioParteSpecifica.model().VERSIONE, (Object)versioneServizio);
            return (AccordoServizioParteSpecifica)this.aspsDAO.find(expr);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public AccordoServizioParteSpecifica getAspsFromId(Long idServizio) {
        log.debug("Get AccordoServizioParteSpecifica from Id [" + idServizio + "]");
        try {
            return ((JDBCAccordoServizioParteSpecificaServiceSearch)this.aspsDAO).get(idServizio.longValue());
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public List<AccordoServizioParteComune> getAccordiServizio(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, Boolean isReferente, Boolean isErogatore, String tag) {
        List<Object> toRet;
        block21: {
            toRet = new ArrayList<AccordoServizioParteComune>();
            log.debug("Get AccordiServizio from Tipo/Nome Soggetto [Tipo: " + tipoSoggetto + "], [nome: " + nomeSoggetto + "] Referente[" + isReferente + "] Erogatore [" + isErogatore + "] Tag[" + tag + "]");
            try {
                if (StringUtils.isNotEmpty((String)nomeSoggetto) && StringUtils.isNotEmpty((String)tipoSoggetto)) {
                    if (isReferente.booleanValue()) {
                        IPaginatedExpression pagExpr = this.aspcDAO.newPaginatedExpression();
                        pagExpr.and();
                        pagExpr.equals(AccordoServizioParteComune.model().ID_REFERENTE.TIPO, (Object)tipoSoggetto).and().equals(AccordoServizioParteComune.model().ID_REFERENTE.NOME, (Object)nomeSoggetto);
                        if (tipoProtocollo != null) {
                            pagExpr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.aspcDAO, AccordoServizioParteComune.model().ID_REFERENTE.TIPO, tipoProtocollo)});
                        }
                        if (tag != null && !"".equals(tag)) {
                            pagExpr.equals(AccordoServizioParteComune.model().ACCORDO_SERVIZIO_PARTE_COMUNE_GRUPPO.ID_GRUPPO.NOME, (Object)tag);
                        }
                        pagExpr.sortOrder(SortOrder.ASC);
                        pagExpr.addOrder(AccordoServizioParteComune.model().ID_REFERENTE.TIPO);
                        pagExpr.addOrder(AccordoServizioParteComune.model().ID_REFERENTE.NOME);
                        pagExpr.addOrder(AccordoServizioParteComune.model().NOME);
                        pagExpr.addOrder(AccordoServizioParteComune.model().VERSIONE);
                        pagExpr.offset(0).limit(this.LIMIT_SEARCH);
                        toRet = this.aspcDAO.findAll(pagExpr);
                        return toRet;
                    }
                    if (!isErogatore.booleanValue()) break block21;
                    IExpression expr = this.aspsDAO.newExpression();
                    expr.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, (Object)tipoSoggetto).and().equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, (Object)nomeSoggetto);
                    if (tipoProtocollo != null) {
                        expr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.aspsDAO, AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, tipoProtocollo)});
                    }
                    if (tag != null && !"".equals(tag)) {
                        throw new Exception("Funzionalit\u00e0 non supportata (Ricerca per Tag con isErogatore)");
                    }
                    expr.sortOrder(SortOrder.ASC).addOrder(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO).addOrder(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME).addOrder(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME).addOrder(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE);
                    IPaginatedExpression pagExpr = this.aspsDAO.toPaginatedExpression(expr);
                    pagExpr.and();
                    CustomField cf = new CustomField("idAccordo", Long.class, "id_accordo", "servizi");
                    List list = null;
                    try {
                        list = this.aspsDAO.select(pagExpr, true, new IField[]{AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, cf});
                    }
                    catch (NotFoundException e) {
                        log.debug("Nessun risultato trovato");
                    }
                    if (list != null && list.size() > 0) {
                        for (Map map : list) {
                            Long idAccordoLong = (Long)map.remove("idAccordo");
                            try {
                                AccordoServizioParteComune aspc = ((JDBCAccordoServizioParteComuneServiceSearch)this.aspcDAO).get(idAccordoLong.longValue());
                                toRet.add(aspc);
                            }
                            catch (NotFoundException e) {
                                log.debug("Accordo si servizio non trovato");
                            }
                        }
                    }
                    break block21;
                }
                IPaginatedExpression pagExpr = this.aspcDAO.newPaginatedExpression();
                pagExpr.and();
                if (tipoProtocollo != null) {
                    pagExpr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.aspcDAO, AccordoServizioParteComune.model().ID_REFERENTE.TIPO, tipoProtocollo)});
                }
                if (tag != null && !"".equals(tag)) {
                    pagExpr.equals(AccordoServizioParteComune.model().ACCORDO_SERVIZIO_PARTE_COMUNE_GRUPPO.ID_GRUPPO.NOME, (Object)tag);
                }
                pagExpr.sortOrder(SortOrder.ASC);
                pagExpr.addOrder(AccordoServizioParteComune.model().ID_REFERENTE.TIPO);
                pagExpr.addOrder(AccordoServizioParteComune.model().ID_REFERENTE.NOME);
                pagExpr.addOrder(AccordoServizioParteComune.model().NOME);
                pagExpr.addOrder(AccordoServizioParteComune.model().VERSIONE);
                pagExpr.offset(0).limit(this.LIMIT_SEARCH);
                toRet = this.aspcDAO.findAll(pagExpr);
            }
            catch (ServiceException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotImplementedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (ExpressionNotImplementedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (ExpressionException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (MultipleResultException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return toRet;
    }

    @Override
    public int countAccordiServizio(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, Boolean isReferente, Boolean isErogatore, String tag) {
        NonNegativeNumber nnn = null;
        log.debug("countAccordiServizio from Tipo/Nome Soggetto [Tipo: " + tipoSoggetto + "], [nome: " + nomeSoggetto + "] Referente[" + isReferente + "] Erogatore [" + isErogatore + "] Tag[" + tag + "]");
        try {
            if (StringUtils.isNotEmpty((String)nomeSoggetto) && StringUtils.isNotEmpty((String)tipoSoggetto)) {
                if (isReferente.booleanValue()) {
                    IExpression expr = this.aspcDAO.newExpression();
                    expr.and();
                    if (tipoProtocollo != null) {
                        expr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.aspcDAO, AccordoServizioParteComune.model().ID_REFERENTE.TIPO, tipoProtocollo)});
                    }
                    expr.equals(AccordoServizioParteComune.model().ID_REFERENTE.TIPO, (Object)tipoSoggetto).and().equals(AccordoServizioParteComune.model().ID_REFERENTE.NOME, (Object)nomeSoggetto);
                    if (tag != null && !"".equals(tag)) {
                        expr.equals(AccordoServizioParteComune.model().ACCORDO_SERVIZIO_PARTE_COMUNE_GRUPPO.ID_GRUPPO.NOME, (Object)tag);
                    }
                    nnn = this.aspcDAO.count(expr);
                }
                if (isErogatore.booleanValue()) {
                    CustomField cf = new CustomField("idAccordo", Long.class, "id_accordo", "servizi");
                    IExpression expr = this.aspsDAO.newExpression();
                    expr.and();
                    if (tipoProtocollo != null) {
                        expr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.aspsDAO, AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, tipoProtocollo)});
                    }
                    expr.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, (Object)tipoSoggetto).and().equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, (Object)nomeSoggetto);
                    if (tag != null && !"".equals(tag)) {
                        throw new Exception("Funzionalit\u00e0 non supportata (Ricerca per Tag con isErogatore)");
                    }
                    FunctionField countF = new FunctionField((IField)cf, Function.COUNT_DISTINCT, "numeroAccordi");
                    Object aggregate = this.aspsDAO.aggregate(expr, countF);
                    if (aggregate != null && aggregate instanceof Long) {
                        Long count = (Long)aggregate;
                        return count.intValue();
                    }
                }
            } else {
                IExpression expr = this.aspcDAO.newExpression();
                expr.and();
                if (tipoProtocollo != null) {
                    expr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.aspcDAO, AccordoServizioParteComune.model().ID_REFERENTE.TIPO, tipoProtocollo)});
                }
                if (tag != null && !"".equals(tag)) {
                    expr.equals(AccordoServizioParteComune.model().ACCORDO_SERVIZIO_PARTE_COMUNE_GRUPPO.ID_GRUPPO.NOME, (Object)tag);
                }
                nnn = this.aspcDAO.count(expr);
            }
            if (nnn != null) {
                return (int)nnn.longValue();
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    @Override
    public List<IDGruppo> getGruppi(String protocollo) {
        if (protocollo == null || "".equals(protocollo) || "-".equals(protocollo) || "--".equals(protocollo)) {
            try {
                IPaginatedExpression expr = this.gruppiDAO.newPaginatedExpression();
                expr.sortOrder(SortOrder.ASC).addOrder(Gruppo.model().NOME);
                List list = this.gruppiDAO.select(expr, Gruppo.model().NOME);
                if (list != null && !list.isEmpty()) {
                    ArrayList<IDGruppo> r = new ArrayList<IDGruppo>();
                    for (Object o : list) {
                        r.add(new IDGruppo((String)o));
                    }
                    return r;
                }
            }
            catch (ServiceException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotImplementedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotFoundException notFound) {
                log.debug(notFound.getMessage(), (Throwable)notFound);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            FiltroRicercaGruppi filtroGruppi = new FiltroRicercaGruppi();
            filtroGruppi.setProtocollo(protocollo);
            try {
                List listGruppi = this.driverRegistroDB.getAllIdGruppi(filtroGruppi);
                return listGruppi;
            }
            catch (DriverRegistroServiziNotFound notFound) {
                log.debug(notFound.getMessage(), (Throwable)notFound);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<IDGruppo>();
    }

    @Override
    public int countGruppi(String protocollo) {
        if (protocollo == null || "".equals(protocollo) || "-".equals(protocollo) || "--".equals(protocollo)) {
            try {
                IExpression expr = this.gruppiDAO.newExpression();
                return (int)this.gruppiDAO.count(expr).longValue();
            }
            catch (ServiceException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotImplementedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            FiltroRicercaGruppi filtroGruppi = new FiltroRicercaGruppi();
            filtroGruppi.setProtocollo(protocollo);
            try {
                List listGruppi = this.driverRegistroDB.getAllIdGruppi(filtroGruppi);
                return listGruppi != null ? listGruppi.size() : 0;
            }
            catch (DriverRegistroServiziNotFound notFound) {
                log.debug(notFound.getMessage(), (Throwable)notFound);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return 0;
    }

    @Override
    public List<AccordoServizioParteSpecifica> getServizi(String tipoProtocollo, String uriAccordoServizio, String tipoSoggetto, String nomeSoggetto) {
        return this.getServizi(tipoProtocollo, uriAccordoServizio, tipoSoggetto, nomeSoggetto, null);
    }

    @Override
    public List<AccordoServizioParteSpecifica> getServizi(String tipoProtocollo, String uriAccordoServizio, String tipoSoggetto, String nomeSoggetto, String val) {
        return this.getServizi(tipoProtocollo, uriAccordoServizio, tipoSoggetto, nomeSoggetto, val, false);
    }

    @Override
    public List<AccordoServizioParteSpecifica> getServizi(String tipoProtocollo, String uriAccordoServizio, String tipoSoggetto, String nomeSoggetto, String val, Boolean searchTipo) {
        log.debug("getServizi: UriAccordoServizio: [" + uriAccordoServizio + "] SoggettoErogatore: [" + tipoSoggetto + "/" + nomeSoggetto + "] Val [" + val + "]");
        try {
            IExpression expr = this.aspsDAO.newExpression();
            if (uriAccordoServizio != null && !uriAccordoServizio.isEmpty()) {
                IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(uriAccordoServizio);
                if (idAccordo.getNome() != null) {
                    expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)idAccordo.getNome());
                }
                if (idAccordo.getVersione() != null) {
                    expr.and().equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)idAccordo.getVersione());
                } else {
                    expr.and().isNull(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE);
                }
                if (idAccordo.getSoggettoReferente() != null) {
                    if (idAccordo.getSoggettoReferente().getTipo() != null) {
                        expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)idAccordo.getSoggettoReferente().getTipo()).and();
                    }
                    if (idAccordo.getSoggettoReferente().getNome() != null) {
                        expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)idAccordo.getSoggettoReferente().getNome()).and();
                    }
                } else {
                    CustomField cf2 = new CustomField("idReferente", Integer.class, "id_referente", "accordi");
                    expr.lessEquals((IField)cf2, (Object)0);
                }
            }
            if (StringUtils.isNotEmpty((String)nomeSoggetto) && StringUtils.isNotEmpty((String)tipoSoggetto)) {
                expr.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, (Object)tipoSoggetto).and().equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, (Object)nomeSoggetto);
            }
            if (tipoProtocollo != null) {
                expr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.aspsDAO, AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, tipoProtocollo)});
            }
            if (StringUtils.isNotEmpty((String)val)) {
                if (searchTipo.booleanValue()) {
                    IExpression exprOrTipo = this.aspsDAO.newExpression();
                    exprOrTipo.ilike(AccordoServizioParteSpecifica.model().TIPO, val, LikeMode.ANYWHERE);
                    IExpression exprOrNome = this.aspsDAO.newExpression();
                    exprOrNome.ilike(AccordoServizioParteSpecifica.model().NOME, val, LikeMode.ANYWHERE);
                    expr.or(exprOrTipo, exprOrNome);
                } else {
                    expr.and().ilike(AccordoServizioParteSpecifica.model().NOME, val, LikeMode.ANYWHERE);
                }
            }
            expr.sortOrder(SortOrder.ASC).addOrder(AccordoServizioParteSpecifica.model().TIPO).addOrder(AccordoServizioParteSpecifica.model().NOME).addOrder(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO).addOrder(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME);
            IPaginatedExpression pagExpr = this.aspsDAO.toPaginatedExpression(expr);
            pagExpr.offset(0).limit(this.LIMIT_SEARCH);
            return this.aspsDAO.findAll(pagExpr);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (DriverRegistroServiziException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<AccordoServizioParteSpecifica>();
    }

    @Override
    public int countServizi(String tipoProtocollo, String uriAccordoServizio, String tipoSoggetto, String nomeSoggetto) {
        log.debug("countServizi: UriAccordoServizio: [" + uriAccordoServizio + "] SoggettoErogatore: [" + tipoSoggetto + "/" + nomeSoggetto + "]");
        NonNegativeNumber nnn = null;
        try {
            IExpression expr = this.aspsDAO.newExpression();
            if (uriAccordoServizio != null && !uriAccordoServizio.isEmpty()) {
                IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(uriAccordoServizio);
                if (idAccordo.getNome() != null) {
                    expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)idAccordo.getNome());
                }
                if (idAccordo.getVersione() != null) {
                    expr.and().equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)idAccordo.getVersione());
                } else {
                    expr.and().isNull(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE);
                }
                if (idAccordo.getSoggettoReferente() != null) {
                    if (idAccordo.getSoggettoReferente().getTipo() != null) {
                        expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)idAccordo.getSoggettoReferente().getTipo()).and();
                    }
                    if (idAccordo.getSoggettoReferente().getNome() != null) {
                        expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)idAccordo.getSoggettoReferente().getNome()).and();
                    }
                } else {
                    CustomField cf2 = new CustomField("idReferente", Integer.class, "id_referente", "accordi");
                    expr.lessEquals((IField)cf2, (Object)0);
                }
            }
            if (StringUtils.isNotEmpty((String)nomeSoggetto) && StringUtils.isNotEmpty((String)tipoSoggetto)) {
                expr.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, (Object)tipoSoggetto).and().equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, (Object)nomeSoggetto);
            }
            if (tipoProtocollo != null) {
                expr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.aspsDAO, AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, tipoProtocollo)});
            }
            if ((nnn = this.aspsDAO.count(expr)) != null) {
                return (int)nnn.longValue();
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (DriverRegistroServiziException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    public AccordoServizioParteSpecifica convertPortTypeName(String portTypeName) {
        try {
            int idx = portTypeName.indexOf("(");
            if (idx == -1) {
                return null;
            }
            String tipoNomeServizio = portTypeName.substring(0, idx).trim();
            String tipoNomeSoggetto = portTypeName.substring(idx + 1).replace(")", "").trim();
            if (tipoNomeServizio.indexOf("/") == -1) {
                return null;
            }
            if (tipoNomeSoggetto.indexOf("/") == -1) {
                return null;
            }
            String tipoServizio = tipoNomeServizio.split("/")[0];
            String nomeServizio = tipoNomeServizio.split("/")[1];
            String tipoSoggetto = tipoNomeSoggetto.split("/")[0];
            String nomeSoggetto = tipoNomeSoggetto.split("/")[1];
            IExpression expr = this.aspsDAO.newExpression();
            expr.equals(AccordoServizioParteSpecifica.model().NOME, (Object)nomeServizio).and().equals(AccordoServizioParteSpecifica.model().TIPO, (Object)tipoServizio).and().equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, (Object)tipoSoggetto).and().equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, (Object)nomeSoggetto);
            return (AccordoServizioParteSpecifica)this.aspsDAO.find(expr);
        }
        catch (NotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public List<Soggetto> getSoggettiErogatoreAutoComplete(String tipoProtocollo, String uriAccordoServizio, String input) {
        block25: {
            try {
                int idx = input.indexOf("/");
                if (idx != -1) {
                    input = input.substring(idx + 1, input.length());
                }
                if (uriAccordoServizio != null && !uriAccordoServizio.isEmpty()) {
                    IExpression expr = this.aspsDAO.newExpression();
                    IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(uriAccordoServizio);
                    boolean addAnd = false;
                    if (idAccordo.getNome() != null) {
                        expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)idAccordo.getNome());
                        addAnd = true;
                    }
                    if (idAccordo.getVersione() != null) {
                        if (addAnd) {
                            expr.and();
                        }
                        expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)idAccordo.getVersione());
                        addAnd = true;
                    }
                    if (idAccordo.getSoggettoReferente() != null) {
                        if (addAnd) {
                            expr.and();
                        }
                        if (idAccordo.getSoggettoReferente().getTipo() != null) {
                            expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)idAccordo.getSoggettoReferente().getTipo()).and();
                        }
                        if (idAccordo.getSoggettoReferente().getNome() != null) {
                            expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)idAccordo.getSoggettoReferente().getNome()).and();
                        }
                    }
                    expr.sortOrder(SortOrder.ASC).addOrder(AccordoServizioParteSpecifica.model().TIPO).addOrder(AccordoServizioParteSpecifica.model().NOME);
                    IPaginatedExpression pagExpr = this.aspsDAO.toPaginatedExpression(expr);
                    pagExpr.offset(0).limit(this.LIMIT_SEARCH);
                    List lstAsps = this.aspsDAO.findAll(pagExpr);
                    if (lstAsps != null) {
                        ArrayList<Soggetto> lstSog = new ArrayList<Soggetto>();
                        HashSet<Soggetto> setSog = new HashSet<Soggetto>();
                        ArrayList<CallSite> soggettiGiaInseriti = new ArrayList<CallSite>();
                        for (AccordoServizioParteSpecifica asps : lstAsps) {
                            String key;
                            expr = this.soggettoDAO.newExpression();
                            if (asps.getIdErogatore() != null) {
                                if (asps.getIdErogatore().getTipo() != null) {
                                    expr.equals(Soggetto.model().TIPO_SOGGETTO, (Object)asps.getIdErogatore().getTipo()).and();
                                }
                                if (asps.getIdErogatore().getNome() != null) {
                                    expr.equals(Soggetto.model().NOME_SOGGETTO, (Object)asps.getIdErogatore().getNome());
                                }
                            }
                            expr.ilike(Soggetto.model().NOME_SOGGETTO, input.toLowerCase(), LikeMode.ANYWHERE);
                            expr.sortOrder(SortOrder.ASC).addOrder(Soggetto.model().TIPO_SOGGETTO).addOrder(Soggetto.model().NOME_SOGGETTO);
                            Soggetto s = (Soggetto)this.soggettoDAO.find(expr);
                            if (s == null || soggettiGiaInseriti.contains(key = s.getTipoSoggetto() + "/" + s.getNomeSoggetto())) continue;
                            setSog.add(s);
                            soggettiGiaInseriti.add((CallSite)((Object)key));
                        }
                        if (setSog.size() > 0) {
                            lstSog.addAll(setSog);
                        }
                        return lstSog;
                    }
                    break block25;
                }
                IExpression expr = this.soggettoDAO.newExpression();
                expr.ilike(Soggetto.model().NOME_SOGGETTO, input.toLowerCase(), LikeMode.ANYWHERE);
                if (tipoProtocollo != null) {
                    expr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.soggettoDAO, Soggetto.model().TIPO_SOGGETTO, tipoProtocollo)});
                }
                expr.sortOrder(SortOrder.ASC).addOrder(Soggetto.model().TIPO_SOGGETTO).addOrder(Soggetto.model().NOME_SOGGETTO);
                IPaginatedExpression pagExpr = this.soggettoDAO.toPaginatedExpression(expr);
                pagExpr.offset(0).limit(this.LIMIT_SEARCH);
                return this.soggettoDAO.findAll(pagExpr);
            }
            catch (ServiceException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotImplementedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (ExpressionNotImplementedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (ExpressionException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (DriverRegistroServiziException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (MultipleResultException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<Soggetto>();
    }

    @Override
    public List<Soggetto> getSoggettiFruitoreAutoComplete(String tipoProtocollo, String uriAccordoServizio, String input) {
        block28: {
            try {
                int idx = input.indexOf("/");
                if (idx != -1) {
                    input = input.substring(idx + 1, input.length());
                }
                if (uriAccordoServizio != null && !uriAccordoServizio.isEmpty()) {
                    IExpression expr = this.aspsDAO.newExpression();
                    IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(uriAccordoServizio);
                    boolean addAnd = false;
                    if (idAccordo.getNome() != null) {
                        expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)idAccordo.getNome());
                        addAnd = true;
                    }
                    if (idAccordo.getVersione() != null) {
                        if (addAnd) {
                            expr.and();
                        }
                        expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)idAccordo.getVersione());
                        addAnd = true;
                    }
                    if (idAccordo.getSoggettoReferente() != null) {
                        if (addAnd) {
                            expr.and();
                        }
                        if (idAccordo.getSoggettoReferente().getTipo() != null) {
                            expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)idAccordo.getSoggettoReferente().getTipo()).and();
                        }
                        if (idAccordo.getSoggettoReferente().getNome() != null) {
                            expr.equals(AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)idAccordo.getSoggettoReferente().getNome()).and();
                        }
                    }
                    expr.sortOrder(SortOrder.ASC).addOrder(AccordoServizioParteSpecifica.model().TIPO).addOrder(AccordoServizioParteSpecifica.model().NOME);
                    IPaginatedExpression pagExpr = this.aspsDAO.toPaginatedExpression(expr);
                    pagExpr.offset(0).limit(this.LIMIT_SEARCH);
                    List lstAsps = this.aspsDAO.findAll(pagExpr);
                    if (lstAsps != null) {
                        ArrayList<Soggetto> lstSog = new ArrayList<Soggetto>();
                        HashSet<Soggetto> setSog = new HashSet<Soggetto>();
                        ArrayList<CallSite> soggettiGiaInseriti = new ArrayList<CallSite>();
                        for (AccordoServizioParteSpecifica asps : lstAsps) {
                            expr = this.fruitoreSearchDAO.newExpression();
                            addAnd = false;
                            if (asps.getNome() != null) {
                                expr.equals(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.NOME, (Object)asps.getNome());
                                addAnd = true;
                            }
                            if (asps.getTipo() != null) {
                                if (addAnd) {
                                    expr.and();
                                }
                                expr.equals(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.TIPO, (Object)asps.getTipo());
                                addAnd = true;
                            }
                            if (asps.getIdErogatore() != null) {
                                if (addAnd) {
                                    expr.and();
                                }
                                if (asps.getIdErogatore().getTipo() != null) {
                                    expr.equals(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.ID_EROGATORE.TIPO, (Object)asps.getIdErogatore().getTipo()).and();
                                }
                                if (asps.getIdErogatore().getNome() != null) {
                                    expr.equals(Fruitore.model().ID_ACCORDO_SERVIZIO_PARTE_SPECIFICA.ID_EROGATORE.NOME, (Object)asps.getIdErogatore().getNome()).and();
                                }
                            }
                            expr.ilike(Fruitore.model().ID_FRUITORE.NOME, input.toLowerCase(), LikeMode.ANYWHERE);
                            expr.sortOrder(SortOrder.ASC).addOrder(Fruitore.model().ID_FRUITORE.TIPO).addOrder(Fruitore.model().ID_FRUITORE.NOME);
                            pagExpr = this.fruitoreSearchDAO.toPaginatedExpression(expr);
                            pagExpr.offset(0).limit(this.LIMIT_SEARCH);
                            List lstFruitori = this.fruitoreSearchDAO.findAll(pagExpr);
                            if (lstFruitori == null) continue;
                            for (Fruitore fruitore : lstFruitori) {
                                String key;
                                Soggetto s = (Soggetto)this.soggettoDAO.get((Object)fruitore.getIdFruitore());
                                if (s == null || soggettiGiaInseriti.contains(key = s.getTipoSoggetto() + "/" + s.getNomeSoggetto())) continue;
                                setSog.add(s);
                                soggettiGiaInseriti.add((CallSite)((Object)key));
                            }
                            if (setSog.size() <= 0) continue;
                            lstSog.addAll(setSog);
                        }
                        return lstSog;
                    }
                    break block28;
                }
                IExpression expr = this.soggettoDAO.newExpression();
                expr.ilike(Soggetto.model().NOME_SOGGETTO, input.toLowerCase(), LikeMode.ANYWHERE);
                expr.sortOrder(SortOrder.ASC).addOrder(Soggetto.model().TIPO_SOGGETTO).addOrder(Soggetto.model().NOME_SOGGETTO);
                IPaginatedExpression pagExpr = this.soggettoDAO.toPaginatedExpression(expr);
                pagExpr.offset(0).limit(this.LIMIT_SEARCH);
                return this.soggettoDAO.findAll(pagExpr);
            }
            catch (ServiceException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotImplementedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (ExpressionNotImplementedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (ExpressionException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (DriverRegistroServiziException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (MultipleResultException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<Soggetto>();
    }

    public List<PortaApplicativa> findPorteApplicative(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String nomeAzione, PermessiUtenteOperatore permessiUtenteOperatore) {
        log.debug("Get Lista Porta Applicativa [Soggetto Erogatore : " + nomeErogatore + "]");
        List<Object> listaPorte = new ArrayList<PortaApplicativa>();
        try {
            IExpression paExpr = this.getExpressionPA(tipoProtocollo, tipoSoggetto, nomeSoggetto, null, null, null, null, null, null, null, null);
            IPaginatedExpression pagPdExpr = this.portaApplicativaDAO.toPaginatedExpression(paExpr);
            listaPorte = this.portaApplicativaDAO.findAll(pagPdExpr);
            return listaPorte;
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return listaPorte;
    }

    public List<PortaDelegata> findPorteDelegate(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String nomeAzione, PermessiUtenteOperatore permessiUtenteOperatore) {
        log.debug("Get Lista Porta Delegate [Soggetto Erogatore : " + nomeErogatore + "]");
        List<Object> listaPorte = new ArrayList<PortaDelegata>();
        try {
            IExpression pdExpr = this.getExpressionPD(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoErogatore, nomeErogatore, tipoServizio, nomeServizio, versioneServizio, nomeAzione, null, permessiUtenteOperatore);
            IPaginatedExpression pagPdExpr = this.portaDelegataDAO.toPaginatedExpression(pdExpr);
            listaPorte = this.portaDelegataDAO.findAll(pagPdExpr);
            return listaPorte;
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return listaPorte;
    }

    @Override
    public List<IDServizio> getServiziErogazione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore, Boolean distinct) {
        log.debug("getServiziErogazione [Soggetto Proprietario : " + tipoSoggetto + "/" + nomeSoggetto + "]");
        ArrayList<IDServizio> lista = new ArrayList<IDServizio>();
        try {
            IExpression pAExpr = this.getExpressionPA(tipoProtocollo, tipoSoggetto, nomeSoggetto, null, null, null, null, null, null, val, permessiUtenteOperatore);
            List listaPorte = new ArrayList();
            IPaginatedExpression pagPaExpr = this.portaApplicativaDAO.toPaginatedExpression(pAExpr);
            pagPaExpr.addOrder(PortaApplicativa.model().ID_SOGGETTO.TIPO, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().ID_SOGGETTO.NOME, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().TIPO_SERVIZIO, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().NOME_SERVIZIO, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().VERSIONE_SERVIZIO, SortOrder.ASC);
            pagPaExpr.offset(this.defaultStart).limit(this.LIMIT_SEARCH);
            ExpressionProperties.enableSoloDatiIdentificativiServizio((IExpression)pagPaExpr);
            listaPorte = this.portaApplicativaDAO.findAll(pagPaExpr);
            ArrayList<String> lstTmp = new ArrayList<String>();
            for (PortaApplicativa portaApplicativa : listaPorte) {
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(portaApplicativa.getTipoServizio(), portaApplicativa.getNomeServizio(), portaApplicativa.getIdSoggetto().getTipo(), portaApplicativa.getIdSoggetto().getNome(), portaApplicativa.getVersioneServizio().intValue());
                String uriFromIDServizio = IDServizioFactory.getInstance().getUriFromIDServizio(idServizio);
                if (distinct.booleanValue() && lstTmp.contains(uriFromIDServizio)) continue;
                lstTmp.add(uriFromIDServizio);
                lista.add(idServizio);
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return lista;
    }

    @Override
    public List<IDServizio> getServiziErogazione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String nomeAzione, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore, Boolean distinct) {
        log.debug("getServiziErogazione [Soggetto Proprietario : " + tipoSoggetto + "/" + nomeSoggetto + "]");
        ArrayList<IDServizio> lista = new ArrayList<IDServizio>();
        try {
            IExpression paExpr = this.getExpressionPA(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, val, permessiUtenteOperatore);
            List listaPorte = new ArrayList();
            IPaginatedExpression pagPaExpr = this.portaApplicativaDAO.toPaginatedExpression(paExpr);
            pagPaExpr.addOrder(PortaApplicativa.model().ID_SOGGETTO.TIPO, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().ID_SOGGETTO.NOME, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().TIPO_SERVIZIO, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().NOME_SERVIZIO, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().VERSIONE_SERVIZIO, SortOrder.ASC);
            pagPaExpr.offset(this.defaultStart).limit(this.LIMIT_SEARCH);
            ExpressionProperties.enableSoloDatiIdentificativiServizio((IExpression)pagPaExpr);
            listaPorte = this.portaApplicativaDAO.findAll(pagPaExpr);
            ArrayList<String> lstTmp = new ArrayList<String>();
            for (PortaApplicativa portaApplicativa : listaPorte) {
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(portaApplicativa.getTipoServizio(), portaApplicativa.getNomeServizio(), portaApplicativa.getIdSoggetto().getTipo(), portaApplicativa.getIdSoggetto().getNome(), portaApplicativa.getVersioneServizio().intValue());
                String uriFromIDServizio = IDServizioFactory.getInstance().getUriFromIDServizio(idServizio);
                if (distinct.booleanValue() && lstTmp.contains(uriFromIDServizio)) continue;
                lstTmp.add(uriFromIDServizio);
                lista.add(idServizio);
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return lista;
    }

    @Override
    public int countServiziErogazione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore) {
        try {
            IExpression paExpr = this.getExpressionPA(tipoProtocollo, tipoSoggetto, nomeSoggetto, null, null, null, null, null, null, val, permessiUtenteOperatore);
            NonNegativeNumber nnn = this.portaApplicativaDAO.count(paExpr);
            if (nnn != null) {
                return (int)nnn.longValue();
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    @Override
    public List<IDServizio> getConfigurazioneServiziErogazione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore, Boolean distinct) {
        log.debug("getServiziErogazione [Soggetto Proprietario : " + tipoSoggetto + "/" + nomeSoggetto + "]");
        ArrayList<IDServizio> lista = new ArrayList<IDServizio>();
        try {
            IExpression pAExpr = this.getExpressionPA(tipoProtocollo, tipoSoggetto, nomeSoggetto, null, null, null, null, null, null, val, permessiUtenteOperatore);
            List listaPorte = new ArrayList();
            IPaginatedExpression pagPaExpr = this.portaApplicativaDAO.toPaginatedExpression(pAExpr);
            pagPaExpr.addOrder(PortaApplicativa.model().ID_SOGGETTO.TIPO, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().ID_SOGGETTO.NOME, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().TIPO_SERVIZIO, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().NOME_SERVIZIO, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().VERSIONE_SERVIZIO, SortOrder.ASC);
            pagPaExpr.offset(this.defaultStart).limit(this.LIMIT_SEARCH);
            ExpressionProperties.enableSoloDatiIdentificativiServizio((IExpression)pagPaExpr);
            listaPorte = this.portaApplicativaDAO.findAll(pagPaExpr);
            ArrayList<String> lstTmp = new ArrayList<String>();
            for (PortaApplicativa portaApplicativa : listaPorte) {
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(portaApplicativa.getTipoServizio(), portaApplicativa.getNomeServizio(), portaApplicativa.getIdSoggetto().getTipo(), portaApplicativa.getIdSoggetto().getNome(), portaApplicativa.getVersioneServizio().intValue());
                String uriFromIDServizio = IDServizioFactory.getInstance().getUriFromIDServizio(idServizio);
                if (distinct.booleanValue() && lstTmp.contains(uriFromIDServizio)) continue;
                lstTmp.add(uriFromIDServizio);
                lista.add(idServizio);
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return lista;
    }

    @Override
    public List<IDServizio> getConfigurazioneServiziErogazione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String nomeAzione, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore, Boolean distinct) {
        log.debug("getServiziErogazione [Soggetto Proprietario : " + tipoSoggetto + "/" + nomeSoggetto + "]");
        ArrayList<IDServizio> lista = new ArrayList<IDServizio>();
        try {
            IExpression paExpr = this.getExpressionPA(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, val, permessiUtenteOperatore);
            List listaPorte = new ArrayList();
            IPaginatedExpression pagPaExpr = this.portaApplicativaDAO.toPaginatedExpression(paExpr);
            pagPaExpr.addOrder(PortaApplicativa.model().ID_SOGGETTO.TIPO, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().ID_SOGGETTO.NOME, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().TIPO_SERVIZIO, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().NOME_SERVIZIO, SortOrder.ASC);
            pagPaExpr.addOrder(PortaApplicativa.model().VERSIONE_SERVIZIO, SortOrder.ASC);
            pagPaExpr.offset(this.defaultStart).limit(this.LIMIT_SEARCH);
            ExpressionProperties.enableSoloDatiIdentificativiServizio((IExpression)pagPaExpr);
            listaPorte = this.portaApplicativaDAO.findAll(pagPaExpr);
            ArrayList<String> lstTmp = new ArrayList<String>();
            for (PortaApplicativa portaApplicativa : listaPorte) {
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(portaApplicativa.getTipoServizio(), portaApplicativa.getNomeServizio(), portaApplicativa.getIdSoggetto().getTipo(), portaApplicativa.getIdSoggetto().getNome(), portaApplicativa.getVersioneServizio().intValue());
                String uriFromIDServizio = IDServizioFactory.getInstance().getUriFromIDServizio(idServizio);
                if (distinct.booleanValue() && lstTmp.contains(uriFromIDServizio)) continue;
                lstTmp.add(uriFromIDServizio);
                lista.add(idServizio);
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return lista;
    }

    @Override
    public int countConfigurazioneServiziErogazione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String nomeAzione, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore) {
        try {
            IExpression paExpr = this.getExpressionPA(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, tipoErogatore, nomeErogatore, versioneServizio, nomeAzione, val, permessiUtenteOperatore);
            NonNegativeNumber nnn = this.portaApplicativaDAO.count(paExpr);
            if (nnn != null) {
                return (int)nnn.longValue();
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    private IExpression getExpressionPA(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String nomeAzione, String val, PermessiUtenteOperatore permessiUtenteOperatore) throws ServiceException, NotImplementedException, CoreException, ExpressionNotImplementedException, ExpressionException, Exception {
        IExpression paExpr = this.portaApplicativaDAO.newExpression();
        if (permessiUtenteOperatore != null) {
            IExpression permessi = permessiUtenteOperatore.toExpressionConfigurazioneServizi((IExpressionConstructor)this.portaApplicativaDAO, PortaApplicativa.model().ID_SOGGETTO.TIPO, PortaApplicativa.model().ID_SOGGETTO.NOME, PortaApplicativa.model().ID_SOGGETTO.TIPO, PortaApplicativa.model().ID_SOGGETTO.NOME, PortaApplicativa.model().TIPO_SERVIZIO, PortaApplicativa.model().NOME_SERVIZIO, PortaApplicativa.model().VERSIONE_SERVIZIO, false);
            paExpr.and(new IExpression[]{permessi});
        }
        if (StringUtils.isNotEmpty((String)tipoSoggetto) && !"qualsiasi".equals(tipoSoggetto)) {
            paExpr.equals(PortaApplicativa.model().ID_SOGGETTO.TIPO, (Object)tipoSoggetto);
        }
        if (StringUtils.isNotEmpty((String)nomeSoggetto) && !"qualsiasi".equals(nomeSoggetto)) {
            paExpr.and().equals(PortaApplicativa.model().ID_SOGGETTO.NOME, (Object)nomeSoggetto);
        }
        if (StringUtils.isNotEmpty((String)val)) {
            if (StringUtils.isNotEmpty((String)nomeSoggetto) && !"qualsiasi".equals(nomeSoggetto)) {
                paExpr.and().ilike(PortaApplicativa.model().NOME_SERVIZIO, val.toLowerCase(), LikeMode.ANYWHERE);
            } else {
                IExpression likeExpr = this.portaApplicativaDAO.newExpression();
                likeExpr.ilike(PortaApplicativa.model().ID_SOGGETTO.NOME, val.toLowerCase(), LikeMode.ANYWHERE).or().ilike(PortaApplicativa.model().NOME_SERVIZIO, val.toLowerCase(), LikeMode.ANYWHERE);
                paExpr.and(new IExpression[]{likeExpr});
            }
        }
        if (StringUtils.isNotEmpty((String)nomeServizio)) {
            paExpr.equals(PortaApplicativa.model().NOME_SERVIZIO, (Object)nomeServizio).and();
        }
        if (StringUtils.isNotEmpty((String)tipoServizio)) {
            paExpr.equals(PortaApplicativa.model().TIPO_SERVIZIO, (Object)tipoServizio).and();
        }
        if (versioneServizio != null) {
            paExpr.equals(PortaApplicativa.model().VERSIONE_SERVIZIO, (Object)versioneServizio).and();
        }
        if (StringUtils.isNotEmpty((String)nomeErogatore)) {
            paExpr.equals(PortaApplicativa.model().ID_SOGGETTO.NOME, (Object)nomeErogatore).and();
        }
        if (StringUtils.isNotEmpty((String)tipoErogatore)) {
            paExpr.equals(PortaApplicativa.model().ID_SOGGETTO.TIPO, (Object)tipoErogatore).and();
        }
        if (StringUtils.isNotEmpty((String)nomeAzione)) {
            IExpression azioneExpr = this.portaApplicativaDAO.newExpression();
            azioneExpr.equals(PortaApplicativa.model().NOME_AZIONE, (Object)nomeAzione).or().isNull(PortaApplicativa.model().NOME_AZIONE);
            paExpr.and(new IExpression[]{azioneExpr});
        }
        if (tipoProtocollo != null) {
            paExpr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.portaApplicativaDAO, PortaApplicativa.model().ID_SOGGETTO.TIPO, tipoProtocollo)});
        }
        paExpr.notEquals(PortaApplicativa.model().MODE_AZIONE, (Object)PortaApplicativaAzioneIdentificazione.DELEGATED_BY);
        return paExpr;
    }

    @Override
    public List<IDServizio> getServiziFruizione(String tipoProtocollo, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore, Boolean distinct) {
        log.debug("getServiziFruizione [Soggetto Erogatore : " + tipoSoggettoErogatore + "/" + nomeSoggettoErogatore + "]");
        ArrayList<IDServizio> lista = new ArrayList<IDServizio>();
        try {
            IExpression pdExpr = this.getExpressionPD(tipoProtocollo, null, null, tipoSoggettoErogatore, nomeSoggettoErogatore, null, null, null, null, val, permessiUtenteOperatore);
            List listaPorte = new ArrayList();
            IPaginatedExpression pagPdExpr = this.portaDelegataDAO.toPaginatedExpression(pdExpr);
            pagPdExpr.addOrder(PortaDelegata.model().TIPO_SOGGETTO_EROGATORE, SortOrder.ASC);
            pagPdExpr.addOrder(PortaDelegata.model().NOME_SOGGETTO_EROGATORE, SortOrder.ASC);
            pagPdExpr.addOrder(PortaDelegata.model().TIPO_SERVIZIO, SortOrder.ASC);
            pagPdExpr.addOrder(PortaDelegata.model().NOME_SERVIZIO, SortOrder.ASC);
            pagPdExpr.addOrder(PortaDelegata.model().VERSIONE_SERVIZIO, SortOrder.ASC);
            pagPdExpr.offset(this.defaultStart).limit(this.LIMIT_SEARCH);
            ExpressionProperties.enableSoloDatiIdentificativiServizio((IExpression)pagPdExpr);
            listaPorte = this.portaDelegataDAO.findAll(pagPdExpr);
            ArrayList<String> lstTmp = new ArrayList<String>();
            for (PortaDelegata portaDelegata : listaPorte) {
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(portaDelegata.getTipoServizio(), portaDelegata.getNomeServizio(), portaDelegata.getTipoSoggettoErogatore(), portaDelegata.getNomeSoggettoErogatore(), portaDelegata.getVersioneServizio().intValue());
                String uriFromIDServizio = IDServizioFactory.getInstance().getUriFromIDServizio(idServizio);
                if (distinct.booleanValue() && lstTmp.contains(uriFromIDServizio)) continue;
                lstTmp.add(uriFromIDServizio);
                lista.add(idServizio);
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return lista;
    }

    @Override
    public List<IDServizio> getServiziFruizione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String nomeAzione, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore, Boolean distinct) {
        log.debug("getServiziFruizione [Soggetto Erogatore : " + tipoSoggettoErogatore + "/" + nomeSoggettoErogatore + "]");
        ArrayList<IDServizio> lista = new ArrayList<IDServizio>();
        try {
            IExpression pdExpr = this.getExpressionPD(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, versioneServizio, nomeAzione, val, permessiUtenteOperatore);
            List listaPorte = new ArrayList();
            IPaginatedExpression pagPdExpr = this.portaDelegataDAO.toPaginatedExpression(pdExpr);
            pagPdExpr.addOrder(PortaDelegata.model().TIPO_SOGGETTO_EROGATORE, SortOrder.ASC);
            pagPdExpr.addOrder(PortaDelegata.model().NOME_SOGGETTO_EROGATORE, SortOrder.ASC);
            pagPdExpr.addOrder(PortaDelegata.model().TIPO_SERVIZIO, SortOrder.ASC);
            pagPdExpr.addOrder(PortaDelegata.model().NOME_SERVIZIO, SortOrder.ASC);
            pagPdExpr.addOrder(PortaDelegata.model().VERSIONE_SERVIZIO, SortOrder.ASC);
            pagPdExpr.offset(this.defaultStart).limit(this.LIMIT_SEARCH);
            ExpressionProperties.enableSoloDatiIdentificativiServizio((IExpression)pagPdExpr);
            listaPorte = this.portaDelegataDAO.findAll(pagPdExpr);
            ArrayList<String> lstTmp = new ArrayList<String>();
            for (PortaDelegata portaDelegata : listaPorte) {
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(portaDelegata.getTipoServizio(), portaDelegata.getNomeServizio(), portaDelegata.getTipoSoggettoErogatore(), portaDelegata.getNomeSoggettoErogatore(), portaDelegata.getVersioneServizio().intValue());
                String uriFromIDServizio = IDServizioFactory.getInstance().getUriFromIDServizio(idServizio);
                if (distinct.booleanValue() && lstTmp.contains(uriFromIDServizio)) continue;
                lstTmp.add(uriFromIDServizio);
                lista.add(idServizio);
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return lista;
    }

    @Override
    public int countServiziFruizione(String tipoProtocollo, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore) {
        try {
            IExpression pdExpr = this.getExpressionPD(tipoProtocollo, null, null, tipoSoggettoErogatore, nomeSoggettoErogatore, null, null, null, null, val, permessiUtenteOperatore);
            NonNegativeNumber nnn = this.portaDelegataDAO.count(pdExpr);
            if (nnn != null) {
                return (int)nnn.longValue();
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    @Override
    public List<IDServizio> getConfigurazioneServiziFruizione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String nomeAzione, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore, Boolean distinct) {
        log.debug("getServiziFruizione [Soggetto Fruitore : " + tipoSoggetto + "/" + nomeSoggetto + "]");
        ArrayList<IDServizio> lista = new ArrayList<IDServizio>();
        try {
            IExpression pdExpr = this.getExpressionPD(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoErogatore, nomeErogatore, tipoServizio, nomeServizio, versioneServizio, nomeAzione, val, permessiUtenteOperatore);
            List listaPorte = new ArrayList();
            IPaginatedExpression pagPdExpr = this.portaDelegataDAO.toPaginatedExpression(pdExpr);
            pagPdExpr.addOrder(PortaDelegata.model().ID_SOGGETTO.TIPO, SortOrder.ASC);
            pagPdExpr.addOrder(PortaDelegata.model().ID_SOGGETTO.NOME, SortOrder.ASC);
            pagPdExpr.addOrder(PortaDelegata.model().TIPO_SOGGETTO_EROGATORE, SortOrder.ASC);
            pagPdExpr.addOrder(PortaDelegata.model().NOME_SOGGETTO_EROGATORE, SortOrder.ASC);
            pagPdExpr.addOrder(PortaDelegata.model().TIPO_SERVIZIO, SortOrder.ASC);
            pagPdExpr.addOrder(PortaDelegata.model().NOME_SERVIZIO, SortOrder.ASC);
            pagPdExpr.addOrder(PortaDelegata.model().VERSIONE_SERVIZIO, SortOrder.ASC);
            pagPdExpr.offset(this.defaultStart).limit(this.LIMIT_SEARCH);
            ExpressionProperties.enableSoloDatiIdentificativiServizio((IExpression)pagPdExpr);
            listaPorte = this.portaDelegataDAO.findAll(pagPdExpr);
            ArrayList<String> lstTmp = new ArrayList<String>();
            for (PortaDelegata portaDelegata : listaPorte) {
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(portaDelegata.getTipoServizio(), portaDelegata.getNomeServizio(), portaDelegata.getTipoSoggettoErogatore(), portaDelegata.getNomeSoggettoErogatore(), portaDelegata.getVersioneServizio().intValue());
                String uriFromIDServizio = IDServizioFactory.getInstance().getUriFromIDServizio(idServizio);
                if (distinct.booleanValue() && lstTmp.contains(uriFromIDServizio)) continue;
                lstTmp.add(uriFromIDServizio);
                lista.add(idServizio);
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return lista;
    }

    @Override
    public int countConfigurazioneServiziFruizione(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, String tipoErogatore, String nomeErogatore, Integer versioneServizio, String nomeAzione, String val, Boolean searchTipo, PermessiUtenteOperatore permessiUtenteOperatore) {
        try {
            IExpression pdExpr = this.getExpressionPD(tipoProtocollo, tipoSoggetto, nomeSoggetto, tipoErogatore, nomeErogatore, tipoServizio, nomeServizio, versioneServizio, nomeAzione, val, permessiUtenteOperatore);
            NonNegativeNumber nnn = this.portaDelegataDAO.count(pdExpr);
            if (nnn != null) {
                return (int)nnn.longValue();
            }
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    private IExpression getExpressionPD(String tipoProtocollo, String tipoSoggetto, String nomeSoggetto, String tipoErogatore, String nomeErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String nomeAzione, String val, PermessiUtenteOperatore permessiUtenteOperatore) throws ServiceException, NotImplementedException, CoreException, ExpressionNotImplementedException, ExpressionException, Exception {
        IExpression pdExpr = this.portaDelegataDAO.newExpression();
        if (permessiUtenteOperatore != null) {
            IExpression permessi = permessiUtenteOperatore.toExpressionConfigurazioneServizi((IExpressionConstructor)this.portaDelegataDAO, PortaDelegata.model().ID_SOGGETTO.TIPO, PortaDelegata.model().ID_SOGGETTO.NOME, PortaDelegata.model().TIPO_SOGGETTO_EROGATORE, PortaDelegata.model().NOME_SOGGETTO_EROGATORE, PortaDelegata.model().TIPO_SERVIZIO, PortaDelegata.model().NOME_SERVIZIO, PortaDelegata.model().VERSIONE_SERVIZIO, false);
            pdExpr.and(new IExpression[]{permessi});
        }
        if (StringUtils.isNotEmpty((String)tipoSoggetto) && !"qualsiasi".equals(tipoSoggetto)) {
            pdExpr.equals(PortaDelegata.model().ID_SOGGETTO.TIPO, (Object)tipoSoggetto);
        }
        if (StringUtils.isNotEmpty((String)nomeSoggetto) && !"qualsiasi".equals(nomeSoggetto)) {
            pdExpr.and().equals(PortaDelegata.model().ID_SOGGETTO.NOME, (Object)nomeSoggetto);
        }
        if (StringUtils.isNotEmpty((String)val)) {
            if (StringUtils.isNotEmpty((String)nomeSoggetto) && !"qualsiasi".equals(nomeSoggetto)) {
                pdExpr.and().ilike(PortaDelegata.model().NOME_SERVIZIO, val.toLowerCase(), LikeMode.ANYWHERE);
            } else {
                IExpression likeExpr = this.portaDelegataDAO.newExpression();
                likeExpr.ilike(PortaDelegata.model().ID_SOGGETTO.NOME, val.toLowerCase(), LikeMode.ANYWHERE).or().ilike(PortaDelegata.model().NOME_SERVIZIO, val.toLowerCase(), LikeMode.ANYWHERE);
                pdExpr.and(new IExpression[]{likeExpr});
            }
        }
        if (StringUtils.isNotEmpty((String)nomeErogatore)) {
            pdExpr.equals(PortaDelegata.model().NOME_SOGGETTO_EROGATORE, (Object)nomeErogatore).and();
        }
        if (StringUtils.isNotEmpty((String)tipoErogatore)) {
            pdExpr.equals(PortaDelegata.model().TIPO_SOGGETTO_EROGATORE, (Object)tipoErogatore).and();
        }
        if (StringUtils.isNotEmpty((String)tipoServizio)) {
            pdExpr.equals(PortaDelegata.model().TIPO_SERVIZIO, (Object)tipoServizio);
        }
        if (StringUtils.isNotEmpty((String)nomeServizio)) {
            pdExpr.and().equals(PortaDelegata.model().NOME_SERVIZIO, (Object)nomeServizio);
        }
        if (versioneServizio != null) {
            pdExpr.equals(PortaDelegata.model().VERSIONE_SERVIZIO, (Object)versioneServizio).and();
        }
        if (StringUtils.isNotEmpty((String)nomeAzione)) {
            IExpression azioneExpr = this.portaDelegataDAO.newExpression();
            azioneExpr.equals(PortaDelegata.model().NOME_AZIONE, (Object)nomeAzione).or().isNull(PortaDelegata.model().NOME_AZIONE);
            pdExpr.and(new IExpression[]{azioneExpr});
        }
        if (tipoProtocollo != null) {
            pdExpr.and(new IExpression[]{DynamicUtilsServiceEngine.getExpressionTipiSoggettiCompatibiliConProtocollo(this.portaDelegataDAO, PortaDelegata.model().ID_SOGGETTO.TIPO, tipoProtocollo)});
        }
        pdExpr.notEquals(PortaDelegata.model().MODE_AZIONE, (Object)PortaDelegataAzioneIdentificazione.DELEGATED_BY);
        return pdExpr;
    }

    @Override
    public PortaApplicativa getPortaApplicativa(String nomePorta) {
        log.debug("getPortaApplicativa [Nome: " + nomePorta + "]");
        PortaApplicativa portaApplicativa = null;
        try {
            IExpression expr = this.portaApplicativaDAO.newExpression();
            expr.equals(PortaApplicativa.model().NOME, (Object)nomePorta);
            portaApplicativa = (PortaApplicativa)this.portaApplicativaDAO.find(expr);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return portaApplicativa;
    }

    @Override
    public PortaDelegata getPortaDelegata(String nomePorta) {
        log.debug("getPortaDelegata [Nome: " + nomePorta + "]");
        PortaDelegata portaDelegata = null;
        try {
            IExpression expr = this.portaDelegataDAO.newExpression();
            expr.equals(PortaDelegata.model().NOME, (Object)nomePorta);
            portaDelegata = (PortaDelegata)this.portaDelegataDAO.find(expr);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return portaDelegata;
    }

    @Override
    public List<IDServizio> getServizi(String protocolloSelezionato, List<String> protocolliSupportati, String tipoServizio, String nomeServizio, Integer versioneServizio, String tag) {
        log.debug("Get Servizi [Protocollo: " + protocolloSelezionato + "], [Protocolli supportati: " + protocolliSupportati + "], [TipoServizio: " + tipoServizio + "], [NomeServizio: " + nomeServizio + "], [VersioneServizio: " + versioneServizio + "], [Tag: " + tag + "]");
        try {
            if (protocolloSelezionato != null) {
                return RegistroCore.getServizi((JDBCServiceManager)((JDBCServiceManager)this.utilsServiceManager), (String)protocolloSelezionato, (String)tipoServizio, (String)nomeServizio, (Integer)versioneServizio, (String)tag);
            }
            return RegistroCore.getServizi((JDBCServiceManager)((JDBCServiceManager)this.utilsServiceManager), protocolliSupportati, (String)tipoServizio, (String)nomeServizio, (Integer)versioneServizio, (String)tag);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new ArrayList<IDServizio>();
        }
    }

    @Override
    public MappingFruizionePortaDelegata getMappingFruizione(IDServizio idServizio, IDSoggetto idSoggetto, IDPortaDelegata idPortaDelegata) {
        log.debug("getMappingFruizione [idServizio:" + idServizio + ", idSoggetto:" + idSoggetto + ", idPortaDelegata:" + idPortaDelegata + "]");
        try {
            return this.driverConfigDB.getMappingFruizione(idServizio, idSoggetto, idPortaDelegata);
        }
        catch (DriverConfigurazioneNotFound e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public MappingErogazionePortaApplicativa getMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativa) {
        log.debug("MappingErogazionePortaApplicativa [idServizio:" + idServizio + ", idPortaApplicativa:" + idPortaApplicativa + "]");
        try {
            return this.driverConfigDB.getMappingErogazione(idServizio, idPortaApplicativa);
        }
        catch (DriverConfigurazioneNotFound e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public Plugin getPlugin(IdPlugin idPlugin) {
        log.debug("getPlugin [tipoPlugin:" + idPlugin.getTipoPlugin() + ", ClassName:" + idPlugin.getClassName() + ", Tipo:" + idPlugin.getTipo() + ", Label:" + idPlugin.getLabel() + "]");
        try {
            return (Plugin)this.pluginsServiceSearchDAO.get((Object)idPlugin);
        }
        catch (NotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean existsFaseTracciamentoDBRequestIn(boolean erogazioni, boolean fruizioni) {
        log.debug("existsFaseTracciamentoDBRequestIn [erogazioni:" + erogazioni + ", fruizioni:" + fruizioni + "]");
        try {
            return this.driverConfigDB.existsFaseTracciamentoDBRequestIn(erogazioni, fruizioni);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean existsFaseTracciamentoDBRequestOut(boolean erogazioni, boolean fruizioni) {
        log.debug("existsFaseTracciamentoDBRequestOut [erogazioni:" + erogazioni + ", fruizioni:" + fruizioni + "]");
        try {
            return this.driverConfigDB.existsFaseTracciamentoDBRequestOut(erogazioni, fruizioni);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean existsFaseTracciamentoDBResponseOut(boolean erogazioni, boolean fruizioni) {
        log.debug("existsFaseTracciamentoDBResponseOut [erogazioni:" + erogazioni + ", fruizioni:" + fruizioni + "]");
        try {
            return this.driverConfigDB.existsFaseTracciamentoDBResponseOut(erogazioni, fruizioni);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

