/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.dao;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.search.AccordoServizioParteComune;
import org.openspcoop2.core.commons.search.Resource;
import org.openspcoop2.core.commons.search.dao.IAccordoServizioParteComuneServiceSearch;
import org.openspcoop2.core.commons.search.dao.IResourceServiceSearch;
import org.openspcoop2.core.commons.search.dao.IServiceManager;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.transazioni.CredenzialeMittente;
import org.openspcoop2.core.transazioni.constants.TipoAPI;
import org.openspcoop2.core.transazioni.dao.ICredenzialeMittenteService;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCCredenzialeMittenteServiceSearch;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeTokenClient;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.protocol.sdk.PDNDTokenInfo;
import org.openspcoop2.utils.json.JsonPathExpressionEngine;
import org.openspcoop2.web.monitor.core.dao.DynamicUtilsService;
import org.openspcoop2.web.monitor.core.listener.AbstractConsoleStartupListener;
import org.slf4j.Logger;

public class MBeanUtilsService {
    private Logger log;
    private IServiceManager service;
    private ICredenzialeMittenteService credenzialiMittenteDAO;

    public MBeanUtilsService(IServiceManager service, Logger log) {
        this.service = service;
        this.log = log;
    }

    public MBeanUtilsService(ICredenzialeMittenteService credenzialiMittenteDAO, Logger log) {
        this.credenzialiMittenteDAO = credenzialiMittenteDAO;
        this.log = log;
    }

    public static String buildKey(Object ... params) {
        return DynamicUtilsService.buildKey(params);
    }

    public int getTipoApiFromCache(IDAccordo idAccordo) throws Exception {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = MBeanUtilsService.buildKey(idAccordo);
            String methodName = "getTipoApi";
            try {
                return (Integer)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{IDAccordo.class}, new Object[]{idAccordo});
            }
            catch (Throwable e) {
                this.log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return -1;
            }
        }
        return this.getTipoApi(idAccordo);
    }

    public int getTipoApi(IDAccordo idAccordo) throws Exception {
        IAccordoServizioParteComuneServiceSearch apcServiceSearch = this.service.getAccordoServizioParteComuneServiceSearch();
        IPaginatedExpression pagExpr = apcServiceSearch.newPaginatedExpression();
        pagExpr.and().equals(AccordoServizioParteComune.model().NOME, (Object)idAccordo.getNome()).equals(AccordoServizioParteComune.model().VERSIONE, (Object)idAccordo.getVersione()).equals(AccordoServizioParteComune.model().ID_REFERENTE.TIPO, (Object)idAccordo.getSoggettoReferente().getTipo()).equals(AccordoServizioParteComune.model().ID_REFERENTE.NOME, (Object)idAccordo.getSoggettoReferente().getNome());
        List l = this.service.getAccordoServizioParteComuneServiceSearch().select(pagExpr, AccordoServizioParteComune.model().SERVICE_BINDING);
        if (l != null && !l.isEmpty()) {
            String sb = (String)l.get(0);
            ServiceBinding serviceBinding = ServiceBinding.toEnumConstant((String)sb);
            switch (serviceBinding) {
                case REST: {
                    return TipoAPI.REST.getValoreAsInt();
                }
                case SOAP: {
                    return TipoAPI.SOAP.getValoreAsInt();
                }
            }
        }
        return -1;
    }

    public List<Map<String, Object>> getInfoOperazioneFromCache(String op, IDAccordo idAccordo) throws Exception {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = MBeanUtilsService.buildKey(op, idAccordo);
            String methodName = "getInfoOperazione";
            try {
                return (List)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{String.class, IDAccordo.class}, new Object[]{op, idAccordo});
            }
            catch (Throwable e) {
                this.log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.getInfoOperazione(op, idAccordo);
    }

    public List<Map<String, Object>> getInfoOperazione(String op, IDAccordo idAccordo) throws Exception {
        IResourceServiceSearch resourceServiceSearch = this.service.getResourceServiceSearch();
        IPaginatedExpression pagExpr = resourceServiceSearch.newPaginatedExpression();
        pagExpr.equals(Resource.model().NOME, (Object)op).and().equals(Resource.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)idAccordo.getNome()).equals(Resource.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)idAccordo.getVersione()).equals(Resource.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, (Object)idAccordo.getSoggettoReferente().getTipo()).equals(Resource.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME, (Object)idAccordo.getSoggettoReferente().getNome());
        List l = this.service.getResourceServiceSearch().select(pagExpr, new IField[]{Resource.model().HTTP_METHOD, Resource.model().PATH});
        return l;
    }

    public CredenzialeMittente getCredenzialeMittenteFromCache(Long id) throws ServiceException, MultipleResultException, NotFoundException, NotImplementedException {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = MBeanUtilsService.buildKey(id);
            String methodName = "getCredenzialeMittente";
            try {
                return (CredenzialeMittente)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{Long.class}, new Object[]{id});
            }
            catch (Throwable e) {
                this.log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.getCredenzialeMittente(id);
    }

    public CredenzialeMittente getCredenzialeMittente(Long id) throws ServiceException, MultipleResultException, NotFoundException, NotImplementedException {
        return ((JDBCCredenzialeMittenteServiceSearch)this.credenzialiMittenteDAO).get(id.longValue());
    }

    public CredenzialeMittente getCredenzialeMittenteByReferenceFromCache(TipoCredenzialeMittente tipo, Long id) throws ServiceException, NotFoundException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        if (AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione != null) {
            String key = MBeanUtilsService.buildKey(tipo, id);
            String methodName = "getCredenzialeMittenteByReference";
            try {
                return (CredenzialeMittente)AbstractConsoleStartupListener.dynamicUtilsServiceCache_datiConfigurazione.getObjectCache(this, AbstractConsoleStartupListener.debugCache_datiConfigurazione, key, methodName, new Class[]{TipoCredenzialeMittente.class, Long.class}, new Object[]{tipo, id});
            }
            catch (NotFoundException e) {
                String msg = "Cache Access NotFound (method:" + methodName + " key:" + key + "): " + e.getMessage();
                this.log.debug(msg);
                return null;
            }
            catch (Throwable e) {
                this.log.error("Cache Access Error (method:" + methodName + " key:" + key + "): " + e.getMessage(), e);
                return null;
            }
        }
        return this.getCredenzialeMittenteByReference(tipo, id);
    }

    public CredenzialeMittente getCredenzialeMittenteByReference(TipoCredenzialeMittente tipo, Long id) throws ServiceException, NotFoundException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        JDBCCredenzialeMittenteServiceSearch search = (JDBCCredenzialeMittenteServiceSearch)this.credenzialiMittenteDAO;
        IPaginatedExpression pagExpr = search.newPaginatedExpression();
        pagExpr.equals(CredenzialeMittente.model().REF_CREDENZIALE, (Object)id);
        pagExpr.equals(CredenzialeMittente.model().TIPO, (Object)tipo.getRawValue());
        pagExpr.addOrder(CredenzialeMittente.model().ORA_REGISTRAZIONE, SortOrder.DESC);
        pagExpr.limit(1);
        List l = search.findAll(pagExpr);
        CredenzialeMittente cm = null;
        if (l != null && !l.isEmpty()) {
            cm = (CredenzialeMittente)l.get(0);
        }
        if (cm != null) {
            return cm;
        }
        if (TipoCredenzialeMittente.PDND_ORGANIZATION_NAME.equals((Object)tipo) || TipoCredenzialeMittente.PDND_ORGANIZATION_EXTERNAL_ID.equals((Object)tipo) || TipoCredenzialeMittente.PDND_ORGANIZATION_CONSUMER_ID.equals((Object)tipo) || TipoCredenzialeMittente.PDND_ORGANIZATION_JSON.equals((Object)tipo)) {
            block6: {
                try {
                    cm = this.getPdndOrganizationJsonFromClientIdLong(search, tipo, id);
                }
                catch (Exception e) {
                    if (this.log == null) break block6;
                    this.log.error("getPdndOrganizationJsonFromClientIdLong process failed: " + e.getMessage(), (Throwable)e);
                }
            }
            if (cm != null) {
                return cm;
            }
        }
        throw new NotFoundException("Credential type[" + tipo.getRawValue() + "] ref[" + id + "] not found");
    }

    private CredenzialeMittente getPdndOrganizationJsonFromClientIdLong(JDBCCredenzialeMittenteServiceSearch search, TipoCredenzialeMittente tipo, Long id) throws ServiceException, NotFoundException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        String consumerId;
        TipoCredenzialeMittente t;
        CredenzialeMittente cmClient = null;
        try {
            cmClient = search.get(id.longValue());
        }
        catch (NotFoundException notFoundException) {
        }
        catch (Exception e) {
            this.log.error("getPdndOrganizationJsonFromClientIdLong failed: " + e.getMessage(), (Throwable)e);
        }
        String clientId = null;
        if (cmClient != null && (t = TipoCredenzialeMittente.toEnumConstant((String)cmClient.getTipo(), (boolean)false)) != null && t.equals((Object)TipoCredenzialeMittente.TOKEN_CLIENT_ID)) {
            clientId = CredenzialeTokenClient.convertClientIdDBValueToOriginal((String)cmClient.getCredenziale());
        }
        if ((consumerId = this.getPdndOrganizationConsumerId(search, clientId)) != null) {
            return this.getPdndOrganizationInfoFromConsumerId(search, consumerId, tipo, id);
        }
        return null;
    }

    private String getPdndOrganizationConsumerId(JDBCCredenzialeMittenteServiceSearch search, String clientId) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        IPaginatedExpression pagExpr = search.newPaginatedExpression();
        pagExpr.equals(CredenzialeMittente.model().TIPO, (Object)TipoCredenzialeMittente.PDND_CLIENT_JSON.getRawValue());
        pagExpr.like(CredenzialeMittente.model().CREDENZIALE, "\"" + clientId + "\"", LikeMode.ANYWHERE);
        pagExpr.addOrder(CredenzialeMittente.model().ORA_REGISTRAZIONE, SortOrder.DESC);
        pagExpr.limit(1);
        List l = null;
        try {
            l = search.findAll(pagExpr);
        }
        catch (Exception e) {
            this.log.error("getPdndOrganizationConsumerId clientId:'" + clientId + "' failed: " + e.getMessage(), (Throwable)e);
        }
        CredenzialeMittente cmJson = null;
        if (l != null && !l.isEmpty()) {
            cmJson = (CredenzialeMittente)l.get(0);
        }
        String consumerId = null;
        if (cmJson != null && cmJson.getCredenziale() != null) {
            String pattern = "$.consumerId";
            try {
                consumerId = JsonPathExpressionEngine.extractAndConvertResultAsString((String)cmJson.getCredenziale(), (String)pattern, (Logger)this.log);
            }
            catch (Exception e) {
                this.log.error("getPdndOrganizationJsonFromClientIdLong consumerId read failed from [" + cmJson.getCredenziale() + "] with pattern [" + pattern + "]: " + e.getMessage(), (Throwable)e);
            }
        }
        return consumerId;
    }

    private CredenzialeMittente getPdndOrganizationInfoFromConsumerId(JDBCCredenzialeMittenteServiceSearch search, String consumerId, TipoCredenzialeMittente tipo, long id) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException {
        IPaginatedExpression pagExpr = search.newPaginatedExpression();
        pagExpr.equals(CredenzialeMittente.model().TIPO, (Object)TipoCredenzialeMittente.PDND_ORGANIZATION_JSON.getRawValue());
        pagExpr.like(CredenzialeMittente.model().CREDENZIALE, "\"" + consumerId + "\"", LikeMode.ANYWHERE);
        pagExpr.addOrder(CredenzialeMittente.model().ORA_REGISTRAZIONE, SortOrder.DESC);
        pagExpr.limit(1);
        List l = null;
        try {
            l = search.findAll(pagExpr);
        }
        catch (Exception e) {
            this.log.error("getPdndOrganizationInfoFromConsumerId consumerId:'" + consumerId + "' failed: " + e.getMessage(), (Throwable)e);
        }
        CredenzialeMittente cmJson = null;
        if (l != null && !l.isEmpty()) {
            cmJson = (CredenzialeMittente)l.get(0);
        }
        if (cmJson != null && cmJson.getCredenziale() != null) {
            if (TipoCredenzialeMittente.PDND_ORGANIZATION_JSON.equals((Object)tipo)) {
                cmJson.setRefCredenziale(Long.valueOf(id));
                return cmJson;
            }
            Object value = null;
            try {
                if (TipoCredenzialeMittente.PDND_ORGANIZATION_NAME.equals((Object)tipo)) {
                    value = PDNDTokenInfo.readOrganizationNameFromJson((Logger)this.log, (String)cmJson.getCredenziale());
                } else if (TipoCredenzialeMittente.PDND_ORGANIZATION_EXTERNAL_ID.equals((Object)tipo)) {
                    String origin = PDNDTokenInfo.readOrganizationExternalOriginFromJson((Logger)this.log, (String)cmJson.getCredenziale());
                    String externalId = PDNDTokenInfo.readOrganizationExternalIdFromJson((Logger)this.log, (String)cmJson.getCredenziale());
                    if (origin != null && StringUtils.isNotEmpty((String)origin) && externalId != null && StringUtils.isNotEmpty((String)externalId)) {
                        value = origin + " " + externalId;
                    } else if (origin != null && StringUtils.isNotEmpty((String)origin)) {
                        value = origin;
                    } else if (externalId != null && StringUtils.isNotEmpty((String)externalId)) {
                        value = externalId;
                    }
                } else if (TipoCredenzialeMittente.PDND_ORGANIZATION_CONSUMER_ID.equals((Object)tipo)) {
                    value = PDNDTokenInfo.readOrganizationIdFromJson((Logger)this.log, (String)cmJson.getCredenziale());
                }
            }
            catch (Exception e) {
                this.log.error("getPdndOrganizationJsonFromClientIdLong name read failed from [" + cmJson.getCredenziale() + "]: " + e.getMessage(), (Throwable)e);
            }
            if (value != null && StringUtils.isNotEmpty((String)value)) {
                CredenzialeMittente cmName = new CredenzialeMittente();
                cmName.setCredenziale((String)value);
                cmName.setOraRegistrazione(cmJson.getOraRegistrazione());
                cmName.setRefCredenziale(Long.valueOf(id));
                cmName.setTipo(tipo.getRawValue());
                return cmName;
            }
        }
        return null;
    }
}

